<?php
/**
 * The demo app router file of ZenTaoPHP.
 *
 * All request should be routed by this router.
 *
 * ZenTaoPHP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * ZenTaoPHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ZenTaoPHP.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @copyright   Copyright: 2009 Chunsheng Wang
 * @author      Chunsheng Wang <wwccss@263.net>
 * @package     ZenTaoPHP
 * @version     $Id: index.php 1180 2009-05-25 00:05:49Z wwccss $
 * @link        http://www.zentao.cn
 */
/* ¼ʼʱ䡣*/
$timeStart = _getTime();

/* ļ*/
include '../../../framework/router.class.php';
include '../../../framework/control.class.php';
include '../../../framework/model.class.php';
include '../../../framework/helper.class.php';

/* zentaoͨpearʽװģԽע͵䡣*/
//include 'zentao/framework/router.class.php';
//include 'zentao/framework/control.class.php';
//include 'zentao/framework/model.class.php';
//include 'zentao/framework/helper.class.php';

/* ʵ·ɶ󣬲ãӵݿ⡣*/
$app    = router::createApp('demo', dirname(dirname(__FILE__)));
$config = $app->loadConfig('common');
$dbh    = $app->connectDB();

/* ÿͻʹõԡ*/
$app->setClientLang();
$app->setClientTheme();
$lang = $app->loadLang('common');

/* 󣬼Ӧģ顣*/
$app->parseRequest();
$app->loadModule();

/* DebugϢҳִʱڴռá*/
$timeUsed = round(_getTime() - $timeStart, 4) * 1000;
$memory   = round(memory_get_usage() / 1024, 1);

echo <<<EOT
<div style='text-align:center'>
  Powered By <a href='http://www.zentao.cn' target='_blank'>ZenTaoPHP</a>.
EOT;
if($config->debug)
{
    echo " Time:$timeUsed ms; Mem</strong>:$memory KB ";
}
echo '</div>';

/* ȡϵͳʱ䣬΢Ϊλ*/
function _getTime()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
}
