<?php
/**
 * The helper class file of ZenTaoPHP.
 *
 * ZenTaoPHP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * ZenTaoPHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ZenTaoPHP.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @copyright   Copyright: 2009 Chunsheng Wang
 * @author      Chunsheng Wang <wwccss@263.net>
 * @package     ZenTaoPHP
 * @version     $Id: helper.class.php 1126 2009-03-22 13:39:35Z wwccss $
 * @link        http://www.zentao.cn
 */
class helper
{
    /* Ϊһĳһԣkeyǡfather.childʽ*/
    static function setMember($obj, $key, $value)
    {
        if(!is_object($obj) or empty($key)) return false;
        if(strpos($key, '.'))
        {
            list($father, $child) = explode('.', $key);
            $obj->{$father}->{$child} = $value;
        }
        else
        {
            $obj->$key = $value;
        }
    }

    /* ĳһģĳӡ*/
    static function createLink($moduleName, $methodName = 'index', $vars = array())
    {
        global $router, $config;
        $link = $config->webRoot;
        if($config->requestType == 'PATH_INFO')
        {
            $link .= "$moduleName/$methodName";
            foreach($vars as $key => $value) $link .= "/$key/$value";
            $link .= '.' . $router->getViewType();
        }
        elseif($config->requestType == 'GET')
        {
            $link .= "?{$config->moduleVar}=$moduleName&{$config->methodVar}=$methodName&{$config->viewVar}=" . $router->getViewType();
            foreach($vars as $key => $value) $link .= "&$key=$value";
        }
        return $link;
    }
}    
