<?php
/**
 * The model class file of ZenTaoPHP.
 *
 * ZenTaoPHP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * ZenTaoPHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ZenTaoPHP.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @copyright   Copyright: 2009 Chunsheng Wang
 * @author      Chunsheng Wang <wwccss@263.net>
 * @package     ZenTaoPHP
 * @version     $Id: model.class.php 1112 2009-03-18 11:58:57Z wwccss $
 * @link        http://www.zentao.cn
 */
class model
{
    protected $router       = '';      // router
    protected $config       = '';      // config 
    protected $lang         = '';      // lang
    protected $dbh          = '';      // dbh 
    protected $moduleName   = '';      // ģơ
    protected $modulePath   = '';      // ģڵ·
    protected $moduleConfig = '';      // ģļ
    protected $moduleLang   = '';      // ģļ

    /* 캯*/
    public function __construct()
    {
        /* ȫֵĶ󲢸ֵ*/
        global $router, $config, $lang, $dbh;
        $this->router = $router;
        $this->config = $config;
        $this->lang   = $lang;
        $this->dbh    = $dbh;

        $this->setModuleName();
        $this->setModulePath();
        $this->setModuleConfig();
        $this->loadModuleConfig();
        $this->setModuleLang();
        $this->loadModuleLang();
    }

    /**
     * ģеmodel滻Ϊģ
     * ûʹ$router->getModule()Ϊصǵǰõģ顣
     * һУǰģcontrolļпܻģmodel
     */
    protected function setModuleName()
    {
        $this->moduleName = strtolower(str_ireplace('Model', '', get_class($this)));
    }

    /* ģ·*/
    protected function setModulePath()
    {
        $this->modulePath = $this->router->getModuleRoot() . $this->moduleName . $this->router->getPathFix();
    }

    /* ģļ*/
    protected function setModuleConfig()
    {
        $this->moduleConfig = $this->modulePath. 'config.php';
    }

    /* ģļ*/
    protected function loadModuleConfig()
    {
        if(file_exists($this->moduleConfig)) $this->router->loadConfig($this->moduleName);
    }

    /* ģļ*/
    protected function setModuleLang()
    {
        $this->moduleLang = $this->modulePath. 'lang' . $this->router->getPathFix() . $this->router->getClientLang() . '.php';
    }

    /* ģļ*/
    protected function loadModuleLang()
    {
        if(file_exists($this->moduleLang)) $this->router->loadLang($this->moduleName);
    }
}    
