<?php
/**
 * The router class file of ZenTaoPHP.
 *
 * ZenTaoPHP is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * ZenTaoPHP is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ZenTaoPHP.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @copyright   Copyright: 2009 Chunsheng Wang
 * @author      Chunsheng Wang <wwccss@263.net>
 * @package     ZenTaoPHP
 * @version     $Id: router.class.php 1134 2009-03-29 11:54:45Z wwccss $
 * @link        http://www.zentao.cn
 */
class router
{
    private $pathFix     = '';      // ·ָ
    private $self        = '';      // router
    private $baseRoot    = '';      // ܵĻ׼·
    private $frameRoot   = '';      // ܻ·
    private $libRoot     = '';      // classļڵĸĿ¼
    private $appRoot     = '';      // ǰӦóڵĿ¼
    private $cacheRoot   = '';      // ļڵĸĿ¼
    private $configRoot  = '';      // ļڵĸĿ¼
    private $moduleRoot  = '';      // ģļڵĸĿ¼
    private $themeRoot   = '';      // ļڵĸĿ¼

    private $clientLang  = '';      // ûʹõԡ
    private $clientTheme = '';      // ûʹõ⡣

    private $moduleName  = '';      // ǰҪصģơ
    private $controlFile = '';      // ǰģӦcontrolļ
    private $methodName  = '';      // ҪõcontrolFileķ

    private $URI         = '';      // ǰURI
    private $params      = array(); // ݵĲ
    private $viewType    = '';      // ͼʽhtml|json|xml|txt

    private $config      = '';      // config 
    private $lang        = '';      // lang
    private $dbh         = '';      // dbh 

    /* 캯*/
    public function __construct($appName = 'demo')
    {
        $this->setPathFix();
        $this->setSelf();
        $this->setBaseRoot();
        $this->setFrameRoot();
        $this->setLibRoot();
        $this->setAppRoot($appName);
        $this->setCacheRoot();
        $this->setConfigRoot();
        $this->setModuleRoot();
        $this->setThemeRoot();
    }

    //-------------------- ·صķ--------------------//

    /* ·ָ*/
    protected function setPathFix()
    {
        $this->pathFix = DIRECTORY_SEPARATOR;
    }
    
    /* router򣬼index.phpλá*/
    protected function setSelf()
    {
        $this->self = $_SERVER['SCRIPT_NAME'];
    }

    /* ڵĸĿ¼*/
    protected function setBaseRoot()
    {
        $this->baseRoot = realpath(dirname(dirname(__FILE__))) . $this->pathFix;
    }
    
    /* ÿܺļڵĸĿ¼*/
    protected function setFrameRoot()
    {
        $this->frameRoot = $this->baseRoot . 'framework' . $this->pathFix;
    }

    /* libļĸĿ¼*/
    protected function setLibRoot()
    {
        $this->libRoot = $this->baseRoot . 'lib' . $this->pathFix;
    }

    /* ӦóڵĸĿ¼*/
    protected function setAppRoot($appName = 'demo')
    {
        $this->appRoot = $this->baseRoot . 'app' . $this->pathFix . $appName . $this->pathFix;
        if(!file_exists($this->appRoot)) $this->error("The app you call not noud in {$this->appRoot}", __FILE__, __LINE__, $exit = true);
    }

    /* ûļڵĸĿ¼*/
    protected function setCacheRoot()
    {
        $this->cacheRoot = $this->appRoot . 'cache' . $this->pathFix;
    }

    /* ļڵĸĿ¼*/
    protected function setConfigRoot()
    {
        $this->configRoot = $this->appRoot . 'config' . $this->pathFix;
    }

    /* moduleڵĸĿ¼*/
    protected function setModuleRoot()
    {
        $this->moduleRoot = $this->appRoot . 'module' . $this->pathFix;
    }

    /* ÿͻļڵĸĿ¼*/
    protected function setThemeRoot()
    {
        $this->themeRoot = $this->appRoot . 'www' . $this->pathFix . 'theme' . $this->pathFix;
    }

    /* routerķ·*/
    public function getSelf()
    {
        return $this->self;
    }

    /* ·ָ*/
    public function getPathFix()
    {
        return $this->pathFix;
    }

    /* ܵڵĿ¼*/
    public function getBaseRoot()
    {
        return $this->baseRoot;
    }
    
    /* ؿܺļڵĸĿ¼*/
    public function getFrameRoot()
    {
        return $this->frameRoot;
    }

    /* libļڵĸĿ¼*/
    public function getLibRoot()
    {
        return $this->libRoot;
    }

    /* ӦóڵĸĿ¼*/
    public function getAppRoot()
    {
        return $this->appRoot;
    }

    /* ػļڵĸĿ¼*/
    public function getCacheRoot()
    {
        return $this->cacheRoot;
    } 

    /* ļڵĸĿ¼*/
    public function getConfigRoot()
    {
        return $this->configRoot;
    }

    /* ģļڵĸĿ¼*/
    public function getModuleRoot()
    {
        return $this->moduleRoot;
    }

    /* ļڵĸĿ¼*/
    public function getThemeRoot()
    {
        return $this->themeRoot;
    }

    //-------------------- ͻ˻á--------------------//

    /* ÿͻʹõԡ*/
    public function setClientLang($lang = '')
    {
        if(!empty($lang))
        {
            $this->clientLang = $lang;
        }
        elseif(isset($_SESSION['lang']))
        {
            $this->clientLang = $_SESSION['lang'];
        }
        elseif(isset($_COOKIE['lang']))
        {
            $this->clientLang = $_COOKIE['lang'];
        }    
        elseif(isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
        {
            $this->clientLang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, strpos($_SERVER['HTTP_ACCEPT_LANGUAGE'], ','));
        }
        if(!empty($this->clientLang))
        {
            $this->clientLang = strtolower($this->clientLang);
            if(strpos($this->config->langs, $this->clientLang) === false)
            {
                $this->clientLang = $this->config->default->lang;
            }
        }    
        else
        {
            $this->clientLang = $this->config->default->lang;
        }
        setcookie('lang', $this->clientLang, $this->config->cookieLife, $this->config->cookiePath);
    }

    /* ؿͻʹõԡ*/
    public function getClientLang()
    {
        return $this->clientLang;
    }

    /* ÿͻʹõ⡣*/
    public function setClientTheme($theme = '')
    {
        if(!empty($theme))
        {
            $this->clientTheme = $theme;
        }
        elseif(isset($_SESSION['theme']))
        {
            $this->clientTheme = $_SESSION['theme'];
        }
        elseif(isset($_COOKIE['theme']))
        {
            $this->clientTheme = $_COOKIE['theme'];
        }    
        if(!empty($this->clientTheme))
        {
            $this->clientTheme = strtolower($this->clientTheme);
            if(strpos($this->config->themes, $this->clientTheme) === false)
            {
                $this->clientTheme = $this->config->default->theme;
            }
        }    
        else
        {
            $this->clientTheme = $this->config->default->theme;
        }
        setcookie('theme', $this->clientTheme, $this->config->cookieLife, $this->config->cookiePath);
    }

    /* ؿͻʹõ⡣*/
    public function getClientTheme()
    {
        return $this->config->webRoot . 'theme/' . $this->clientTheme . '/';
    }

    //-------------------- URI--------------------//

    /* 󣬷ΪPATH_INFOGETģʽ*/
    public function parseRequest()
    {
        if($this->config->requestType == 'PATH_INFO')
        {
            $this->parsePathInfo();
            $this->setRouteByPathInfo();
            $this->setParamsByPathInfo();
        }
        elseif($this->config->requestType == 'GET')
        {
            $this->parseGET();
            $this->setRouteByGET();
            $this->setParamsByGET();
        }
        else
        {
            $this->error("The request type $this->config->requestType not supported", __FILE__, __LINE__, $exit = true);
        }
    }

    /* еóPATH_INFOϢ */
    public function parsePathInfo()
    {
        $pathInfo = $this->getPathInfo('PATH_INFO');
        if(!empty($pathInfo))
        {
            $dotPos = strpos($pathInfo, '.');
            if($dotPos)
            {
                $this->URI      = substr($pathInfo, 0, $dotPos);
                $this->viewType = substr($pathInfo, $dotPos + 1);
                if(strpos($this->config->views, ',' . $this->viewType . ',') === false)
                {
                    $this->viewType = $this->config->default->view;
                }
            }
            else
            {
                $this->URI      = $pathInfo;
                $this->viewType = $this->config->default->view;
            }
        }
        else
        {
            $this->viewType = $this->config->default->view;
        }
    }

    /* env_SERVERлȡĳPATH_INFOı֡*/
    private function getPathInfo($varName)
    {
        $value = @getenv($varName);
        if(isset($_SERVER[$varName])) $value = $_SERVER[$varName];
        return trim($value, '/');
    }

    /* ͨGETʽݹĲ*/
    private function parseGET()
    {
        if(isset($_GET[$this->config->viewVar]))
        {
            $this->viewType = $_GET[$this->config->viewVar]; 
            if(strpos($this->config->views, ',' . $this->viewType . ',') === false)
            {
                $this->viewType = $this->config->default->view;
            }
        }
        else
        {
            $this->viewType = $this->config->default->view;
        }
        $this->URI = $_SERVER['REQUEST_URI'];
    }

    /* ͨPATH_INFOϢҪݸcontrol෽Ĳ*/
    public function setParamsByPathInfo()
    {
        $items = explode('/', $this->URI);
        $count = count($items);
        if($count < 4) return;
        for($i = 2; $i < count($items); $i += 2)
        {
            $this->params[$items[$i]] = $items[$i + 1];
        }
    }

    /* ͨGETҪݸcontrolʵĲ*/
    public function setParamsByGET()
    {
        unset($_GET[$this->config->moduleVar]);
        unset($_GET[$this->config->methodVar]);
        unset($_GET[$this->config->viewVar]);
        $this->params = $_GET;
    }
    
    /* صǰURI*/
    public function getURI()
    {
        return $this->URI;
    }

    /* صǰviewType*/
    public function getViewType()
    {
        return $this->viewType;
    }

    /* صǰ󴫵ݵĲ*/
    public function getParams()
    {
        return $this->params;
    }

    //-------------------- ·صķ--------------------//

    /* Ҫõģ顣*/
    public function setModuleName($moduleName = '')
    {
        $this->moduleName = strtolower($moduleName);
    }

    /* ҪصĿļ*/
    public function setControlFile()
    {
        $this->controlFile = $this->moduleRoot . $this->moduleName . $this->pathFix . 'control.php';
        if(!file_exists($this->controlFile)) $this->error("the control file $this->controlFile not found.", __FILE__, __LINE__, $exit = true);
    }

    /* Ҫõķ*/
    public function setMethodName($methodName = '')
    {
        $this->methodName = strtolower($methodName);
    }

    /* PATH_INFOϢ·ɡ*/
    public function setRouteByPathInfo()
    {
        if(strpos($this->URI, '/') !== false)
        {
            $items = explode('/', $this->URI);
            if(count($items) >= 2)
            {
                $this->setModuleName($items[0]);
                $this->setMethodName($items[1]);
            }    
            else
            {
                $this->setModuleName($items[0]);
                $this->setMethodName($this->default->method);
            }
        }    
        elseif(!empty($this->URI))
        {
            $this->setModuleName($this->URI);
            $this->setMethodName($this->config->default->method);
        }
        else
        {    
            $this->setModuleName($this->config->default->module);
            $this->setMethodName($this->config->default->method);
        }
        $this->setControlFile();
    }

    /* ͨGET·Ϣ*/
    public function setRouteByGET()
    {
        $moduleName = isset($_GET[$this->config->moduleVar]) ? strtolower($_GET[$this->config->moduleVar]) : $this->config->default->module;
        $methodName = isset($_GET[$this->config->methodVar]) ? strtolower($_GET[$this->config->methodVar]) : $this->config->default->method;
        $this->setModuleName($moduleName);
        $this->setControlFile();
        $this->setMethodName($methodName);
    }
    
    /* ģ顣*/
    public function loadModule()
    {
        chdir(dirname($this->controlFile));
        include $this->controlFile;
        $moduleName = $this->moduleName;
        $methodName = $this->methodName;
        if(!class_exists($moduleName)) $this->error("the control $moduleName not found", __FILE__, __LINE__, $exit = true);
        $module = new $moduleName();
        if(!method_exists($module, $methodName)) $this->error("the module $moduleName has no $methodName method", __FILE__, __LINE__, $exit = true);
        call_user_func_array(array(&$module, $methodName), $this->params);
        return $module;
    }

    /* صǰõģơ*/
    public function getModuleName()
    {
        return $this->moduleName;
    }

    /* controlļ·*/
    public function getControlFile()
    {
        return $this->controlFile;
    }

    /* صǰõcontrolķ*/
    public function getMethodName()
    {
        return $this->methodName;
    }

    //-------------------- ෽-------------------//

    /* */
    public function error($message, $file, $line, $exit = false)
    {
        /* ¼Ϣ*/
        $log = "ERROR: $message in $file on line $line";
        if(isset($_SERVER['SCRIPT_URI'])) $log .= ", request: $_SERVER[SCRIPT_URI]";; 
        error_log($log);

        /* ҪֹʾնûĻϡ*/
        if($exit) die($log);
    }

    /* ĳһļ*/
    public function loadClass($className, $static = false)
    {
        $classFile = $this->libRoot . $className;
        if(is_dir($classFile))
        {
            $classFile .= $this->pathFix . $className . '.class.php';
        }
        else
        {
            $classFile .= '.class.php';
        }    

        if(!file_exists($classFile)) $this->error("class file $classFile not found", __FILE__, __LINE__, $exit = true);
        static $loadedClass = array();

        if(in_array($classFile, $loadedClass)) return;

        $loadedClass[] = $classFile;
        include $classFile;

        /* Ǿ̬Ļʵֱ˳*/
        if($static) return;

        /* ʵɶ*/
        global $$className;
        if(!class_exists($className)) $this->error("the class $className not found in $classFile", __FILE__, __LINE__, $exit = true);
        if(!is_object($$className)) $$className = new $className();
        return $$className;
    }

    /* ļתΪ󣬲Ϊȫֵö*/
    public function loadConfig($moduleName)
    {
        /* ģӦļ·*/
        if($moduleName == 'common')
        {
            $configFile = $this->configRoot . 'config.php';
        }
        else
        {
            $configFile = $this->moduleRoot . $moduleName . $this->pathFix . 'config.php';
        }
        if(!file_exists($configFile)) self::error("config file $configFile not found", __FILE__, __LINE__, $exit = true);

        static $loadedConfigs = array();
        if(in_array($configFile, $loadedConfigs)) return;

        $loadedConfigs[] = $configFile;
        include $configFile;
        if(!isset($config) or empty($config)) return false;

        /* תͻ*/
        $configArray = &$config;
        unset($config);

        /* config*/
        global $config;
        if(!is_object($config)) $config = new config();
        foreach($configArray as $key => $item)
        {
            if(!is_array($item))
            {
                $config->$key = $item;
            }
            else
            {
                foreach($item as $itemKey => $itemOfItem)
                {
                    $config->$key->$itemKey = $itemOfItem;
                }
            }    
        }    
        $this->config = $config;
        return $config;
    }

    /* ļתΪ󣬲ΪȫֵԶ*/
    public function loadLang($moduleName)
    {
        $langFile = $this->moduleRoot . $moduleName . $this->pathFix . 'lang' . $this->pathFix . $this->clientLang . '.php';
        if(!file_exists($langFile)) self::error("language file $langFile not found", __FILE__, __LINE__);

        static $loadedLangs = array();
        if(in_array($langFile, $loadedLangs)) return;

        $loadedLangs[] = $langFile;
        include $langFile;
        if(!isset($lang) or empty($lang)) return false;

        /* תͻ*/
        $langArray = &$lang;
        unset($lang);

        /* lang*/
        global $lang;
        if(!is_object($lang)) $lang = new language();
        foreach($langArray as $key => $item)
        {
            if(!is_array($item))
            {
                $lang->$key = $item;
            }
            else
            {
                foreach($item as $itemKey => $itemOfItem)
                {
                    $lang->$key->$itemKey = $itemOfItem;
                }
            } 
        }
        $this->lang = $lang;
        return $lang;
    }

    /* ӵݿ⣬$dbh*/
    public function connectDB()
    {
        global $config;
        if(!isset($config->db->driver)) self::error('no pdo driver defined, it should be mysql or sqlite', __FILE__, __LINE__, $exit = true);
        if($config->db->driver == 'mysql')
        {
            $dsn = "mysql:host={$config->db->host}; port={$config->db->port}; dbname={$config->db->name}";
        }    
        try 
        {
            $dbh = new PDO($dsn, $config->db->user, $config->db->password, array(PDO::ATTR_PERSISTENT => $config->db->persistant));
            $dbh->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_OBJ);
            $dbh->setAttribute(PDO::ATTR_ERRMODE, $config->db->errorMode);
            $dbh->exec("SET NAMES {$config->db->encoding}");
            $this->dbh = $dbh;
            return $dbh;
        }
        catch (PDOException $exception)
        {
            self::error($exception->getMessage(), __FILE__, __LINE__, $exit = true);
        }
    }
}

/* configࡣ*/
class config
{ 
    function set($key, $value)
    {
        helper::setMember($this, $key, $value);
    }
}

/* languageࡣ*/
class language 
{
    function set($key, $value)
    {
        helper::setMember($this, $key, $value);
    }
}
