/*! Responsive 2.0.1-dev
* 2014-2015 SpryMedia Ltd - datatables.net/license
*/
/**
* @summary     Responsive
* @description Responsive tables plug-in for DataTables
* @version     2.0.1-dev
* @file        dataTables.responsive.js
* @author      SpryMedia Ltd (www.sprymedia.co.uk)
* @contact     www.sprymedia.co.uk/contact
* @copyright   Copyright 2014-2015 SpryMedia Ltd.
*
* This source file is free software, available under the following license:
*   MIT license - http://datatables.net/license/mit
*
* This source file is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE. See the license files for details.
*
* For details please refer to: http://www.datatables.net
*/
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery','datatables.net'],function($){return factory($,window,document);});}else if(typeof exports==='object'){module.exports=function(root,$){if(!root){root=window;}if(!$||!$.fn.dataTable){$=require('datatables.net')(root,$).$;}return factory($,root,root.document);};}
else{factory(jQuery,window,document);}}(function($,window,document,undefined){'use strict';var DataTable=$.fn.dataTable;var Responsive=function(settings,opts){if(!DataTable.versionCheck||!DataTable.versionCheck('1.10.3')){throw'DataTables Responsive requires DataTables 1.10.3 or newer';}this.s={dt:new DataTable.Api(settings),columns:[],current:[]};if(this.s.dt.settings()[0].responsive){return;}if(opts&&typeof opts.details==='string'){opts.details={type:opts.details};}this.c=$.extend(true,{},Responsive.defaults,DataTable.defaults.responsive,opts);settings.responsive=this;this._constructor();};$.extend(Responsive.prototype,{_constructor:function(){var that=this;var dt=this.s.dt;var dtPrivateSettings=dt.settings()[0];var oldWindowWidth=$(window).width();dt.settings()[0]._responsive=this;$(window).on('resize.dtr orientationchange.dtr',DataTable.util.throttle(function(){var width=$(window).width();if(width!==oldWindowWidth){that._resize();oldWindowWidth=width;}}));dtPrivateSettings.oApi._fnCallbackReg(dtPrivateSettings,'aoRowCreatedCallback',function(tr,data,idx){if($.inArray(false,that.s.current)!==-1){$('td, th',tr).each(function(i){var idx=dt.column.index('toData',i);if(that.s.current[idx]===false){$(this).css('display','none');}});}});dt.on('destroy.dtr',function(){dt.off('.dtr');$(dt.table().body()).off('.dtr');$(window).off('resize.dtr orientationchange.dtr');$.each(that.s.current,function(i,val){if(val===false){that._setColumnVis(i,true);}});});this.c.breakpoints.sort(function(a,b){return a.width<b.width?1:a.width>b.width?-1:0;});this._classLogic();this._resizeAuto();var details=this.c.details;if(details.type!==false){that._detailsInit();dt.on('column-visibility.dtr',function(e,ctx,col,vis){that._classLogic();that._resizeAuto();that._resize();});dt.on('draw.dtr',function(){that._redrawChildren();});$(dt.table().node()).addClass('dtr-'+details.type);}dt.on('column-reorder.dtr',function(e,settings,details){if(details.drop){that._classLogic();that._resizeAuto();that._resize();}});dt.on('init.dtr',function(e,settings,details){that._resizeAuto();that._resize();});this._resize();},_columnsVisiblity:function(breakpoint){var dt=this.s.dt;var columns=this.s.columns;var i,ien;var order=columns.map(function(col,idx){return{columnIdx:idx,priority:col.priority};}).sort(function(a,b){if(a.priority!==b.priority){return a.priority-b.priority;}return a.columnIdx-b.columnIdx;});var display=$.map(columns,function(col){return col.auto&&col.minWidth===null?false:col.auto===true?'-':$.inArray(breakpoint,col.includeIn)!==-1;});var requiredWidth=0;for(i=0,ien=display.length;i<ien;i++){if(display[i]===true){requiredWidth+=columns[i].minWidth;}}var scrolling=dt.settings()[0].oScroll;var bar=scrolling.sY||scrolling.sX?scrolling.iBarWidth:0;var widthAvailable=dt.table().container().offsetWidth-bar;var usedWidth=widthAvailable-requiredWidth;for(i=0,ien=display.length;i<ien;i++){if(columns[i].control){usedWidth-=columns[i].minWidth;}}var empty=false;for(i=0,ien=order.length;i<ien;i++){var colIdx=order[i].columnIdx;if(display[colIdx]==='-'&&!columns[colIdx].control&&columns[colIdx].minWidth){if(empty||usedWidth-columns[colIdx].minWidth<0){empty=true;display[colIdx]=false;}else{display[colIdx]=true;}usedWidth-=columns[colIdx].minWidth;}}var showControl=false;for(i=0,ien=columns.length;i<ien;i++){if(!columns[i].control&&!columns[i].never&&!display[i]){showControl=true;break;}}for(i=0,ien=columns.length;i<ien;i++){if(columns[i].control){display[i]=showControl;}}if($.inArray(true,display)===-1){display[0]=true;}return display;},_classLogic:function(){var that=this;var calc={};var breakpoints=this.c.breakpoints;var dt=this.s.dt;var columns=dt.columns().eq(0).map(function(i){var column=this.column(i);var className=column.header().className;var priority=dt.settings()[0].aoColumns[i].responsivePriority;if(priority===undefined){var dataPriority=$(column.header()).data('priority');priority=dataPriority!==undefined?dataPriority*1:10000;}return{className:className,includeIn:[],auto:false,control:false,never:className.match(/\bnever\b/)?true:false,priority:priority};});var add=function(colIdx,name){var includeIn=columns[colIdx].includeIn;if($.inArray(name,includeIn)===-1){includeIn.push(name);}};var column=function(colIdx,name,operator,matched){var size,i,ien;if(!operator){columns[colIdx].includeIn.push(name);}else if(operator==='max-'){size=that._find(name).width;for(i=0,ien=breakpoints.length;i<ien;i++){if(breakpoints[i].width<=size){add(colIdx,breakpoints[i].name);}}}else if(operator==='min-'){size=that._find(name).width;for(i=0,ien=breakpoints.length;i<ien;i++){if(breakpoints[i].width>=size){add(colIdx,breakpoints[i].name);}}}else if(operator==='not-'){for(i=0,ien=breakpoints.length;i<ien;i++){if(breakpoints[i].name.indexOf(matched)===-1){add(colIdx,breakpoints[i].name);}}}};columns.each(function(col,i){var classNames=col.className.split(' ');var hasClass=false;for(var k=0,ken=classNames.length;k<ken;k++){var className=$.trim(classNames[k]);if(className==='all'){hasClass=true;col.includeIn=$.map(breakpoints,function(a){return a.name;});return;}else if(className==='none'||col.never){hasClass=true;return;}else if(className==='control'){hasClass=true;col.control=true;return;}$.each(breakpoints,function(j,breakpoint){var brokenPoint=breakpoint.name.split('-');var re=new RegExp('(min\\-|max\\-|not\\-)?('+brokenPoint[0]+')(\\-[_a-zA-Z0-9])?');var match=className.match(re);if(match){hasClass=true;if(match[2]===brokenPoint[0]&&match[3]==='-'+brokenPoint[1]){column(i,breakpoint.name,match[1],match[2]+match[3]);}else if(match[2]===brokenPoint[0]&&!match[3]){column(i,breakpoint.name,match[1],match[2]);}}});}if(!hasClass){col.auto=true;}});this.s.columns=columns;},_detailsDisplay:function(row,update){var that=this;var dt=this.s.dt;var details=this.c.details;if(details&&details.type){var res=details.display(row,update,function(){return details.renderer(dt,row[0],that._detailsObj(row[0]));});if(res===true||res===false){$(dt.table().node()).triggerHandler('responsive-display.dt',[dt,row,res,update]);}}},_detailsInit:function(){var that=this;var dt=this.s.dt;var details=this.c.details;if(details.type==='inline'){details.target='td:first-child';}dt.on('draw.dtr',function(){that._tabIndexes();});that._tabIndexes();$(dt.table().body()).on('keyup.dtr','td',function(e){if(e.keyCode===13&&$(this).data('dtr-keyboard')){$(this).click();}});var target=details.target;var selector=typeof target==='string'?target:'td';$(dt.table().body()).on('click.dtr mousedown.dtr',selector,function(e){if(!$(dt.table().node()).hasClass('collapsed')){return;}if(!dt.row($(this).closest('tr')).length){return;}if(typeof target==='number'){var targetIdx=target<0?dt.columns().eq(0).length+target:target;if(dt.cell(this).index().column!==targetIdx){return;}}var row=dt.row($(this).closest('tr'));if(e.type==='click'){that._detailsDisplay(row,false);}else if(e.type==='mousedown'){e.preventDefault();}});},_detailsObj:function(rowIdx){var that=this;var dt=this.s.dt;return $.map(this.s.columns,function(col,i){if(col.never){return;}return{title:dt.settings()[0].aoColumns[i].sTitle,data:dt.cell(rowIdx,i).render(that.c.orthogonal),hidden:dt.column(i).visible()&&!that.s.current[i],columnIndex:i};});},_find:function(name){var breakpoints=this.c.breakpoints;for(var i=0,ien=breakpoints.length;i<ien;i++){if(breakpoints[i].name===name){return breakpoints[i];}}},_redrawChildren:function(){var that=this;var dt=this.s.dt;dt.rows({page:'current'}).iterator('row',function(settings,idx){var row=dt.row(idx);that._detailsDisplay(dt.row(idx),true);});},_resize:function(){var that=this;var dt=this.s.dt;var width=$(window).width();var breakpoints=this.c.breakpoints;var breakpoint=breakpoints[0].name;var columns=this.s.columns;var i,ien;var oldVis=this.s.current.slice();for(i=breakpoints.length-1;i>=0;i--){if(width<=breakpoints[i].width){breakpoint=breakpoints[i].name;break;}}var columnsVis=this._columnsVisiblity(breakpoint);this.s.current=columnsVis;var collapsedClass=false;for(i=0,ien=columns.length;i<ien;i++){if(columnsVis[i]===false&&!columns[i].never&&!columns[i].control){collapsedClass=true;break;}}$(dt.table().node()).toggleClass('collapsed',collapsedClass);var changed=false;dt.columns().eq(0).each(function(colIdx,i){if(columnsVis[i]!==oldVis[i]){changed=true;that._setColumnVis(colIdx,columnsVis[i]);}});if(changed){this._redrawChildren();$(dt.table().node()).trigger('responsive-resize.dt',[dt,this.s.current]);}},_resizeAuto:function(){var dt=this.s.dt;var columns=this.s.columns;if(!this.c.auto){return;}if($.inArray(true,$.map(columns,function(c){return c.auto;}))===-1){return;}var tableWidth=dt.table().node().offsetWidth;var columnWidths=dt.columns;var clonedTable=dt.table().node().cloneNode(false);var clonedHeader=$(dt.table().header().cloneNode(false)).appendTo(clonedTable);var clonedBody=$(dt.table().body().cloneNode(false)).appendTo(clonedTable);var headerCells=dt.columns().header().filter(function(idx){return dt.column(idx).visible();}).to$().clone(false).css('display','table-cell');$(clonedBody).append($(dt.rows({page:'current'}).nodes()).clone(false)).find('th, td').css('display','');var footer=dt.table().footer();if(footer){var clonedFooter=$(footer.cloneNode(false)).appendTo(clonedTable);var footerCells=dt.columns().header().filter(function(idx){return dt.column(idx).visible();}).to$().clone(false).css('display','table-cell');$('<tr/>').append(footerCells).appendTo(clonedFooter);}$('<tr/>').append(headerCells).appendTo(clonedHeader);if(this.c.details.type==='inline'){$(clonedTable).addClass('dtr-inline collapsed');}var inserted=$('<div/>').css({width:1,height:1,overflow:'hidden'}).append(clonedTable);inserted.insertBefore(dt.table().node());headerCells.each(function(i){var idx=dt.column.index('fromVisible',i);columns[idx].minWidth=this.offsetWidth||0;});inserted.remove();},_setColumnVis:function(col,showHide){var dt=this.s.dt;var display=showHide?'':'none';$(dt.column(col).header()).css('display',display);$(dt.column(col).footer()).css('display',display);dt.column(col).nodes().to$().css('display',display);},_tabIndexes:function(){var dt=this.s.dt;var cells=dt.cells({page:'current'}).nodes().to$();var ctx=dt.settings()[0];var target=this.c.details.target;cells.filter('[data-dtr-keyboard]').removeData('[data-dtr-keyboard]');var selector=typeof target==='number'?':eq('+target+')':target;$(selector,dt.rows({page:'current'}).nodes()).attr('tabIndex',ctx.iTabIndex).data('dtr-keyboard',1);}});Responsive.breakpoints=[{name:'desktop',width:Infinity},{name:'tablet-l',width:1024},{name:'tablet-p',width:768},{name:'mobile-l',width:480},{name:'mobile-p',width:320}];Responsive.display={childRow:function(row,update,render){if(update){if($(row.node()).hasClass('parent')){row.child(render(),'child').show();return true;}}else{if(!row.child.isShown()){row.child(render(),'child').show();$(row.node()).addClass('parent');return true;}else{row.child(false);$(row.node()).removeClass('parent');return false;}}},childRowImmediate:function(row,update,render){if((!update&&row.child.isShown())||!row.responsive.hasHidden()){row.child(false);$(row.node()).removeClass('parent');return false;}else{row.child(render(),'child').show();$(row.node()).addClass('parent');return true;}},modal:function(options){return function(row,update,render){if(!update){var close=function(){modal.remove();$(document).off('keypress.dtr');};var modal=$('<div class="dtr-modal"/>').append($('<div class="dtr-modal-display"/>').append($('<div class="dtr-modal-content"/>').append(render())).append($('<div class="dtr-modal-close">&times;</div>').click(function(){close();}))).append($('<div class="dtr-modal-background"/>').click(function(){close();})).appendTo('body');if(options&&options.header){modal.find('div.dtr-modal-content').prepend('<h2>'+options.header(row)+'</h2>');}$(document).on('keyup.dtr',function(e){if(e.keyCode===27){e.stopPropagation();close();}});}else{$('div.dtr-modal-content').empty().append(render());}};}};Responsive.defaults={breakpoints:Responsive.breakpoints,auto:true,details:{display:Responsive.display.childRow,renderer:function(api,rowIdx,columns){var data=$.map(columns,function(col,i){return col.hidden?'<li data-dtr-index="'+col.columnIndex+'">'+'<span class="dtr-title">'+col.title+'</span> '+'<span class="dtr-data">'+col.data+'</span>'+'</li>':'';}).join('');return data?$('<ul data-dtr-index="'+rowIdx+'"/>').append(data):false;},target:0,type:'inline'},orthogonal:'display'};var Api=$.fn.dataTable.Api;Api.register('responsive()',function(){return this;});Api.register('responsive.index()',function(li){li=$(li);return{column:li.data('dtr-index'),row:li.parent().data('dtr-index')};});Api.register('responsive.rebuild()',function(){return this.iterator('table',function(ctx){if(ctx._responsive){ctx._responsive._classLogic();}});});Api.register('responsive.recalc()',function(){return this.iterator('table',function(ctx){if(ctx._responsive){ctx._responsive._resizeAuto();ctx._responsive._resize();}});});Api.register('responsive.hasHidden()',function(){var ctx=this.context[0];return ctx._responsive?$.inArray(false,ctx._responsive.s.current)!==-1:false;});Responsive.version='2.0.1-dev';$.fn.dataTable.Responsive=Responsive;$.fn.DataTable.Responsive=Responsive;$(document).on('preInit.dt.dtr',function(e,settings,json){if(e.namespace!=='dt'){return;}if($(settings.nTable).hasClass('responsive')||$(settings.nTable).hasClass('dt-responsive')||settings.oInit.responsive||DataTable.defaults.responsive){var init=settings.oInit.responsive;if(init!==false){new Responsive(settings,$.isPlainObject(init)?init:{});}}});return Responsive;}));