<?php
/**
 * 模型内容信息_检测PHPOK系统是否安全
 * @作者 phpok.com <admin@phpok.com>
 * @版权 深圳市锟铻科技有限公司
 * @主页 http://www.phpok.com
 * @版本 5.x
 * @许可 http://www.phpok.com/lgpl.html PHPOK开源授权协议：GNU Lesser General Public License
 * @时间 2018年12月08日 10时01分
**/
namespace phpok\app\model\safecheck;
/**
 * 安全限制，防止直接访问
**/
if(!defined("PHPOK_SET")){
	exit("<h1>Access Denied</h1>");
}
class model extends \phpok_model
{
	public function __construct()
	{
		parent::model();
	}

	public function save($data)
	{
		return $this->lib('xml')->save($data,$this->dir_data.'safecheck.config.php');
	}

	public function get_one()
	{
		if(is_file($this->dir_data.'safecheck.config.php')){
			return $this->lib('xml')->read($this->dir_data.'safecheck.config.php');
		}
		return false;
	}

	public function get_table($remote=false)
	{
		if($remote){
			$i = $this->get_one();
			if(!$i || !$i['server']){
				return false;
			}
			if($i['ip']){
				$this->lib('curl')->host_ip($i['ip']);
			}
			$msg = $this->lib('curl')->get_content($i['server']);
		}else{
			$file = $this->dir_data.'table.php';
			if(!file_exists($file)){
				return false;
			}
			$msg = $this->lib('file')->cat($file);
		}
		if(!$msg){
			return false;
		}
		return $this->table2list($msg);
	}

	private function table2list($info)
	{
		$info = str_replace(" ","",$info);
		$list = explode("\n",$info);
		$rslist = array();
		foreach($list as $key=>$value){
			if(strpos($value,'|') === false){
				continue;
			}
			$tmp = explode("|",trim($value));
			if(!$tmp || $tmp[0] == 'MD5'){
				continue;
			}
			$info = array();
			$info['md5'] = $tmp[0];
			$info['hash'] = $tmp[1];
			$info['mdate'] = $tmp[2];
			$info['cdate'] = $tmp[3];
			$info['adate'] = $tmp[4];
			$info['filesize'] = $tmp[5];
			$info['ext'] = $tmp[6];
			$info['filename'] = $tmp[7];
			$rslist[$tmp[0]] = $info;
		}
		return $rslist;
	}

	public function ip()
	{
		$info = $this->get_one();
		if(!$info){
			return false;
		}
		return $info['ip'];
	}
}
