SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


CREATE TABLE IF NOT EXISTS `qinggan_77` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `sitename` varchar(255) NOT NULL DEFAULT '' COMMENT '网站名称',
  `linkurl` varchar(255) NOT NULL DEFAULT '' COMMENT '自定义链接',
  `target` varchar(255) NOT NULL DEFAULT '_blank' COMMENT '链接目标',
  `logo` varchar(255) NOT NULL DEFAULT '' COMMENT '网站LOGO',
  `tel` varchar(255) NOT NULL DEFAULT '' COMMENT '联系电话',
  `taxis` varchar(255) NOT NULL DEFAULT '' COMMENT '排序',
  PRIMARY KEY (`id`),
  KEY `site_id_index` (`site_id`,`project_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='友情链接' AUTO_INCREMENT=5 ;

INSERT INTO `qinggan_77` (`id`, `site_id`, `project_id`, `sitename`, `linkurl`, `target`, `logo`, `tel`, `taxis`) VALUES
(1, 1, 389, '锟铻科技', 'https://www.phpok.com', '_blank', '', '0755-23776246', '0'),
(2, 1, 389, '启邦互动', 'https://www.sz-qibang.com/', '_blank', '', '13724259054', '20'),
(3, 1, 389, '联迅网络', 'http://www.17tengfei.com/', '_blank', '1333', '0755-36890218', '30'),
(4, 1, 389, '求学网', 'https://www.7139.com/', '_blank', '1334', '13235908186', '40');

CREATE TABLE IF NOT EXISTS `qinggan_adm` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '管理员ID，系统自增',
  `account` varchar(50) NOT NULL COMMENT '管理员账号',
  `pass` varchar(100) NOT NULL COMMENT '管理员密码',
  `email` varchar(50) NOT NULL COMMENT '管理员邮箱',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0未审核1正常2管理员锁定',
  `if_system` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '系统管理员',
  `vpass` varchar(50) NOT NULL COMMENT '二次验证密码，两次MD5加密',
  `fullname` varchar(100) NOT NULL COMMENT '姓名',
  `close_tip` varchar(255) NOT NULL COMMENT '关闭窗口前弹出的提示',
  `open_id` varchar(255) NOT NULL COMMENT '系统生成的OpenID，用于实现扫码登录',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='管理员信息' AUTO_INCREMENT=2 ;

INSERT INTO `qinggan_adm` (`id`, `account`, `pass`, `email`, `status`, `if_system`, `vpass`, `fullname`, `close_tip`, `open_id`) VALUES
(1, 'admin', '101d9fd14b31a93b06a10421f14dd023:21', 'qinggan@188.com', 1, 1, '14e1b600b1fd579f47433b88e8d85291', '', '', '');

CREATE TABLE IF NOT EXISTS `qinggan_adm_popedom` (
  `id` int(10) unsigned NOT NULL COMMENT '管理员ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '权限ID，对应popedom表里的id',
  PRIMARY KEY (`id`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='管理员权限分配表';

INSERT INTO `qinggan_adm_popedom` (`id`, `pid`) VALUES
(4, 2),
(4, 3),
(4, 26);

CREATE TABLE IF NOT EXISTS `qinggan_all` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `identifier` varchar(100) NOT NULL COMMENT '标识串',
  `title` varchar(200) NOT NULL COMMENT '分类名称',
  `ico` varchar(255) NOT NULL COMMENT '图标',
  `is_system` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0普通１系统',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否前台调用',
  `is_api` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0禁用API，1启用API',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='分类管理' AUTO_INCREMENT=138 ;

INSERT INTO `qinggan_all` (`id`, `site_id`, `identifier`, `title`, `ico`, `is_system`, `status`, `is_api`) VALUES
(4, 1, 'copyright', '页脚版权', 'images/ico/copyright.png', 0, 1, 0),
(37, 1, 'code', '代码脚本', 'images/ico/tag.png', 0, 1, 0);

CREATE TABLE IF NOT EXISTS `qinggan_attr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID',
  `title` varchar(100) NOT NULL COMMENT '属性名称',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='产品属性' AUTO_INCREMENT=3 ;

INSERT INTO `qinggan_attr` (`id`, `site_id`, `title`, `taxis`) VALUES
(1, 1, '颜色', 5),
(2, 1, '型号', 10);

CREATE TABLE IF NOT EXISTS `qinggan_attr_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性ID',
  `title` varchar(200) NOT NULL COMMENT '参数名称',
  `pic` varchar(200) NOT NULL COMMENT '参数图片',
  `taxis` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `val` varchar(255) NOT NULL COMMENT '值',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='属性参数管理' AUTO_INCREMENT=15 ;

INSERT INTO `qinggan_attr_values` (`id`, `aid`, `title`, `pic`, `taxis`, `val`) VALUES
(1, 1, '雅金', 'res/202010/10/43e120b4dfc8cc03.png', 5, ''),
(2, 1, '砚墨', 'res/202010/10/9657b9f1f3f52012.png', 10, ''),
(3, 1, '玄武灰', 'res/202010/10/ebf97d2aec7c4a7b.png', 15, ''),
(4, 2, '6+64GB', '', 5, ''),
(5, 2, '6+128GB', '', 10, ''),
(6, 1, '幻夜星河', '', 20, ''),
(7, 1, '蓝水翡翠', '', 25, ''),
(8, 1, '冰岛幻境', '', 30, ''),
(9, 1, '晴空蓝', '', 35, ''),
(10, 1, '砂石黑', '', 40, ''),
(11, 1, '湖光绿', '', 45, ''),
(12, 2, '6GB+128GB', '', 15, ''),
(13, 2, '4GB+64GB', '', 20, ''),
(14, 2, '4GB+128GB', '', 25, '');

CREATE TABLE IF NOT EXISTS `qinggan_cart` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `session_id` varchar(255) NOT NULL COMMENT 'SESSION_ID号',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID号，为0表示游客',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `coupon_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '优惠码ID（仅当优惠码有效时体现）',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_cart_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `cart_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '购物车ID号',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `title` varchar(255) NOT NULL COMMENT '产品名称',
  `price` float NOT NULL COMMENT '产品单价',
  `qty` int(11) NOT NULL DEFAULT '0' COMMENT '产品数量',
  `ext` text NOT NULL COMMENT '扩展属性',
  `weight` float unsigned NOT NULL DEFAULT '0' COMMENT '重量',
  `volume` float unsigned NOT NULL DEFAULT '0' COMMENT '体积',
  `thumb` varchar(255) NOT NULL COMMENT '缩略图',
  `is_virtual` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0实物1虚拟或服务',
  `unit` varchar(50) NOT NULL COMMENT '单位',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后操作时间',
  `apps` varchar(255) NOT NULL COMMENT '应用管理器',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID，不为0表示这是一个捆绑销售',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='购物车里的产品信息' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_cate` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID，0为根分类',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不使用1正常使用',
  `title` varchar(200) NOT NULL COMMENT '分类名称',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '分类排序，值越小越往前靠',
  `tpl_list` varchar(255) NOT NULL COMMENT '列表模板',
  `tpl_content` varchar(255) NOT NULL COMMENT '内容模板',
  `psize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '列表每页数量',
  `seo_title` varchar(255) NOT NULL COMMENT 'SEO标题',
  `seo_keywords` varchar(255) NOT NULL COMMENT 'SEO关键字',
  `seo_desc` varchar(255) NOT NULL COMMENT 'SEO描述',
  `identifier` varchar(255) NOT NULL COMMENT '分类标识串',
  `tag` varchar(255) NOT NULL COMMENT '自身Tag设置',
  `style` varchar(255) NOT NULL COMMENT 'CSS样式',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模块ID',
  `psize_api` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'API接口读取的数量',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `site_id` (`site_id`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='分类管理' AUTO_INCREMENT=703 ;

INSERT INTO `qinggan_cate` (`id`, `site_id`, `parent_id`, `status`, `title`, `taxis`, `tpl_list`, `tpl_content`, `psize`, `seo_title`, `seo_keywords`, `seo_desc`, `identifier`, `tag`, `style`, `module_id`, `psize_api`) VALUES
(7, 1, 0, 1, '新闻资讯', 10, '', '', 0, '', '', '', 'information', '', 'text-decoration:on;', 0, 0),
(8, 1, 7, 1, '公司新闻', 10, '', '', 0, '', '', '', 'company', '新闻,公司', '', 0, 0),
(68, 1, 7, 1, '行业新闻', 25, '', '', 0, '', '', '', 'industry', '', '', 0, 0),
(70, 1, 0, 1, '产品分类', 20, '', '', 0, '', '', '', 'chanpinfenlei', '', '', 0, 0),
(154, 1, 0, 1, '图集相册', 30, '', '', 0, '', '', '', 'album', '', '', 0, 0),
(168, 1, 70, 1, '手机', 10, '', '', 0, '', '', '', 'shouji', '', '', 0, 0),
(197, 1, 0, 1, '资源下载', 40, '', '', 0, '', '', '', 'ziyuanxiazai', '', '', 0, 0),
(198, 1, 197, 1, '软件下载', 10, '', '', 0, '', '', '', 'ruanjianxiazai', '', '', 0, 0),
(199, 1, 197, 1, '风格下载', 20, '', '', 0, '', '', '', 'fenggexiazai', '', '', 0, 0),
(200, 1, 197, 1, '官方插件', 30, '', '', 0, '', '', '', 'guanfangchajian', '', '', 0, 0),
(201, 1, 0, 1, '论坛分类', 50, '', '', 0, '', '', '', 'bbs-cate', '', '', 0, 0),
(204, 1, 201, 1, '情感驿站', 10, '', '', 0, '', '', '', 'qingganyizhan', '', '', 0, 0),
(205, 1, 201, 1, '产品讨论', 20, '', '', 0, '', '', '', 'chanpintaolun', '', '', 0, 0),
(206, 1, 201, 1, '水吧专区', 30, '', '', 0, '', '', '', 'shuibazhuanqu', '', '', 0, 0),
(207, 1, 201, 1, '常见问题', 30, '', '', 0, '', '', '', 'faq', '', '', 0, 0),
(211, 1, 154, 1, '手机美图', 10, '', '', 0, '', '', '', 'shoujimeitu', '', '', 0, 0),
(582, 1, 168, 1, '小米', 10, '', '', 0, '', '', '', 'xiaomi', '', '', 0, 0),
(583, 1, 168, 1, '魅族', 20, '', '', 0, '', '', '', 'meizu', '公司', '', 0, 0),
(584, 1, 168, 1, '华为', 30, '', '', 0, '', '', '', 'huawei', '', '', 0, 0),
(701, 1, 70, 1, '天木立景', 20, '', '', 0, '', '', '', 'tianmu', '', '', 0, 0);

CREATE TABLE IF NOT EXISTS `qinggan_currency` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '货币ID',
  `code` varchar(3) NOT NULL COMMENT '货币标识，仅限三位数的大写字母',
  `val` decimal(13,8) unsigned NOT NULL COMMENT '货币转化',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，值越小越往前靠',
  `title` varchar(50) NOT NULL COMMENT '名称',
  `symbol_left` varchar(24) NOT NULL COMMENT '价格左侧',
  `symbol_right` varchar(24) NOT NULL COMMENT '价格右侧',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0不使用1使用',
  `hidden` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不隐藏1隐藏',
  `code_num` varchar(5) NOT NULL COMMENT '币种数值',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='货币管理' AUTO_INCREMENT=9 ;

INSERT INTO `qinggan_currency` (`id`, `code`, `val`, `taxis`, `title`, `symbol_left`, `symbol_right`, `status`, `hidden`, `code_num`) VALUES
(1, 'CNY', '6.16989994', 10, '人民币', '', '元', 1, 0, '165'),
(2, 'USD', '1.00000000', 20, '美金', 'US$', '', 1, 0, '840'),
(3, 'HKD', '7.76350021', 30, '港元', 'HK$', '', 1, 0, '344'),
(4, 'EUR', '0.76639998', 40, '欧元', 'EUR', '', 1, 0, '978'),
(5, 'GBP', '0.64529997', 50, '英镑', '￡', '', 1, 0, '826'),
(7, 'AUD', '1.00000000', 60, '澳币', 'A$', '', 1, 0, '036');

CREATE TABLE IF NOT EXISTS `qinggan_email` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID，0表示全部网站',
  `identifier` varchar(255) NOT NULL COMMENT '发送标识',
  `title` varchar(200) NOT NULL COMMENT '邮件主题',
  `content` text NOT NULL COMMENT '邮件内容',
  `note` varchar(255) NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='邮件内容' AUTO_INCREMENT=101 ;

INSERT INTO `qinggan_email` (`id`, `site_id`, `identifier`, `title`, `content`, `note`) VALUES
(4, 1, 'register_code', '获取会员注册资格', '<p>您好，{$email}</p><p>您将注册成为网站【{$config.title} 】会员，请点击下面的地址，进入下一步注册：</p><p><br/></p><blockquote style="margin: 0 0 0 40px; border: none; padding: 0px;"><p><a href="{$link}" target="_blank">{$link}</a></p><p>（此链接24小时内有效）</p></blockquote><p><br/></p><p><br/></p><p>感谢您对本站的关注，茫茫人海中，能有缘走到一起。</p>', ''),
(5, 1, 'getpass', '取回密码操作', '<p>您好，{$user.account}</p><p>您执行了忘记密码操作功能，请点击下面的链接执行下一步：</p><p><br /></p><p><blockquote style="margin: 0 0 0 40px; border: none; padding: 0px;"><p><a href="{$link}" target="_blank">{$link}</a></p></blockquote><br /></p><p>感谢您对本站的支持，有什么问题您在登录后可以咨询我们的客服。</p>', ''),
(6, 1, 'project_save', '主题添加通知', '<p>您好，管理员</p><blockquote><p>您的网站（<a href="http://{$sys.url}" target="_self">{$sys.url}</a>）新增了一篇主题，下述是主题的基本信息：<br/></p><p>主题名称：{$rs.title}</p><p>项目类型：{$page_rs.title}</p><p><br/></p><p>请登录网站查询</p></blockquote>', ''),
(7, 1, 'order_admin', '网站有新订单【{$order.sn}】', '<p>您好，管理员</p><blockquote><p>您的网站：{$sys.url} 收到一份新的订单，订单号是：{$order.sn}，请登录网站后台进行核验。</p></blockquote>', ''),
(8, 1, 'user_order_create', '我们已收到您的订单【{$order.sn}】，欢迎您随时关注订单状态', '<p><strong>尊敬的{$fullname}，您好：</strong><br/></p><p><br/></p><p>感谢您在<span style="color: rgb(0, 112, 192);">{$config.title}</span>（{$sys.url}）购物。</p><p>我们已经收到您的订单<span style="color: rgb(0, 112, 192);">{$order.sn}</span>，建议您选择<span style="color: rgb(0, 112, 192);">在线支付</span>的支付配送方式。订单信息以个人中心里的“<span style="color: rgb(0, 112, 192);"><strong>我的订单</strong></span>”信息为准，您也可以随时进入订单详细进行查看修改等操作。</p><p><br/></p><p><strong>重要说明：</strong></p><p>本邮件仅表明销售方已收到了您提交的订单；销售方收到你的订单信息后，只有在销售方将您的订单中订购的商品从仓库实际直接向您发出时（以商品出库为标志），方视为您与销售方之间就实际直接向您发出的商品建立了合同关系；<br/>如果您在一份订单里订购了多种商品并且销售方只给您发出了部分商品时，您与销售方之间仅就实际直接向您发出的商品建立了合同关系；只有在销售方实际直接向您发出了订单中订购的其他商品时，您和销售方之间就订单中该其他已实际直接向您发出的商品建立了合同关系。<br/>您可以随时登陆您在京东注册的账户，查询您的订单状态。更多内容请见最新的京东网站用户注册协议及京东网站各类购物规则，我们建议您不时地浏览阅读。</p><p><br/></p><p><strong>账户安全提醒：</strong><br/>互联网账号存在被盗风险，为了保障您的账号及资金安全，我们提醒您访问 我的账户- &gt; 修改密码，尽量使用复杂密码，如字母+数字+特殊符号等。</p>', ''),
(9, 1, 'sms_order_create', '会员下单成功后，短信通知', '<p>您的订单：{$order.sn} 已成功提交，请您及时完成支付操作。超过24小时未支付订单将会自动删除。感谢您对我们的支持！</p>', ''),
(10, 1, 'order_user_paid', '您的订单【{$order.sn}】已支付成功', '<p><strong>尊敬的{$fullname}，您好：</strong></p><p style="white-space: normal;">感谢您在<span style="color: rgb(0, 112, 192);">{$config.title}</span>（{$sys.url}）购物。</p><p style="white-space: normal;">您的订单<span style="color: rgb(0, 112, 192);">{$order.sn}</span>已成功支付，请耐心等候，我们管理员正在核验付款信息。</p><p style="white-space: normal;">订单信息以个人中心里的“<span style="color: rgb(0, 112, 192);"><strong>我的订单</strong></span>”信息为准，您也可以随时进入订单详细进行查看修改等操作。</p><p style="white-space: normal;"><br/></p><p style="white-space: normal;"><strong>重要说明：</strong></p><p style="white-space: normal;">本邮件仅表明销售方已收到了您提交的订单；销售方收到你的订单信息后，只有在销售方将您的订单中订购的商品从仓库实际直接向您发出时（以商品出库为标志），方视为您与销售方之间就实际直接向您发出的商品建立了合同关系；<br/>如果您在一份订单里订购了多种商品并且销售方只给您发出了部分商品时，您与销售方之间仅就实际直接向您发出的商品建立了合同关系；只有在销售方实际直接向您发出了订单中订购的其他商品时，您和销售方之间就订单中该其他已实际直接向您发出的商品建立了合同关系。<br/>您可以随时登陆您在京东注册的账户，查询您的订单状态。更多内容请见最新的京东网站用户注册协议及京东网站各类购物规则，我们建议您不时地浏览阅读。</p><p style="white-space: normal;"><br/></p><p style="white-space: normal;"><strong>账户安全提醒：</strong><br/>互联网账号存在被盗风险，为了保障您的账号及资金安全，我们提醒您访问 我的账户- &gt; 修改密码，尽量使用复杂密码，如字母+数字+特殊符号等。</p><p><br/></p>', ''),
(11, 1, 'order_admin_paid', '客户{$user.user}订单【{$orser.sn}】付款成功', '<p>您好，管理员，请登录网站后台 {$sys.url} 核验订单【{$orser.sn}】支付是否成功</p>', ''),
(12, 1, 'sms_order_paid', '订单付款成功后的通知', '<p>您的订单：{$order.sn} 已成功付款，我们正在核验中，请耐心等候！</p>', ''),
(13, 1, 'order_user_shipped', '您的订单【{$order.sn}】已发货', '<p style="white-space: normal;"><strong>尊敬的{$fullname}，您好：</strong><br/></p><p style="white-space: normal;"><br/></p><p style="white-space: normal;">感谢您在<span style="color: rgb(0, 112, 192);">{$config.title}</span>（{$sys.url}）购物。</p><p style="white-space: normal;">您的订单<span style="color: rgb(0, 112, 192);">{$order.sn}</span>已经发货，请保持您的电话畅通，以方便快递人员能与您取得联系。</p><p style="white-space: normal;">订单信息以个人中心里的“<span style="color: rgb(0, 112, 192);"><strong>我的订单</strong></span>”信息为准，您也可以随时进入订单详细进行查看修改等操作。</p><p style="white-space: normal;"><br/></p><p style="white-space: normal;"><strong>重要说明：</strong></p><p style="white-space: normal;">本邮件仅表明销售方已收到了您提交的订单；销售方收到你的订单信息后，只有在销售方将您的订单中订购的商品从仓库实际直接向您发出时（以商品出库为标志），方视为您与销售方之间就实际直接向您发出的商品建立了合同关系；<br/>如果您在一份订单里订购了多种商品并且销售方只给您发出了部分商品时，您与销售方之间仅就实际直接向您发出的商品建立了合同关系；只有在销售方实际直接向您发出了订单中订购的其他商品时，您和销售方之间就订单中该其他已实际直接向您发出的商品建立了合同关系。<br/>您可以随时登陆您在京东注册的账户，查询您的订单状态。更多内容请见最新的京东网站用户注册协议及京东网站各类购物规则，我们建议您不时地浏览阅读。</p><p style="white-space: normal;"><br/></p><p style="white-space: normal;"><strong>账户安全提醒：</strong><br/>互联网账号存在被盗风险，为了保障您的账号及资金安全，我们提醒您访问 我的账户- &gt; 修改密码，尽量使用复杂密码，如字母+数字+特殊符号等。</p><p><br/></p>', ''),
(14, 1, 'sms_order_shipped', '订单发货短信通知', '您的订单：{$order.sn} 已经发货，请保持电话畅通，以方便快递人员能与您取得联系。', ''),
(15, 1, 'order_admin_recerved', '订单【{$order.sn}】已确认收货', '<p>您好，管理员，客户已对订单【{$order.sn}】执行确认收货操作，请登录后台核验</p>', ''),
(16, 1, 'email_code', '【{$config.title}】邮件验证码', '<p>你的验证码是：{$code}，三十分钟内有效，请及时输入</p>', ''),
(17, 1, 'sms_code', '短信验证码', '{$code}', ''),
(18, 1, 'sms_paid_admin', '订单成功后管理员', '订单：{$order.sn}，客户已支付成功，请检查', ''),
(34, 1, 'email_code', '您的验证码', '<p>您的验证码是：<span style="color: rgb(255, 0, 0);"><strong>{$code}</strong></span>，有效时间20分钟，请不要将验证码发送别人。<br/></p><p><br/></p>', ''),
(35, 1, 'sms_sendcloud_code', '4575', 'code:{$code}', 'SendCloud使用的验证码'),
(37, 1, 'sms_61825160', 'SMS_61825160', 'code:{$code}', '阿里云：验证码'),
(38, 1, 'email_toall', '您的留言 #{$rs.id}，管理员已经回复', '', '留言回复通知');

CREATE TABLE IF NOT EXISTS `qinggan_express` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` int(11) NOT NULL DEFAULT '0' COMMENT '站点ID，为0所有站点使用',
  `title` varchar(255) NOT NULL COMMENT '名称',
  `company` varchar(255) NOT NULL COMMENT '公司名称',
  `homepage` varchar(255) NOT NULL COMMENT '官方网站',
  `logo` varchar(255) NOT NULL COMMENT '物流快递公司的Logo',
  `code` varchar(100) NOT NULL COMMENT '接口标识，用于读取logistics文件夹下的接口文件',
  `rate` int(11) NOT NULL DEFAULT '6' COMMENT '查询频率，用于减少请求',
  `ext` text NOT NULL COMMENT '扩展数据保存',
  `content` text NOT NULL COMMENT '公司介绍',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='快递平台管理' AUTO_INCREMENT=7 ;

INSERT INTO `qinggan_express` (`id`, `site_id`, `title`, `company`, `homepage`, `logo`, `code`, `rate`, `ext`, `content`) VALUES
(4, 1, '顺丰速运', '顺丰速运(集团)有限公司', 'http://www.sf-express.com/', '', 'showapi', 4, 'a:3:{s:6:"app_id";s:5:"93566";s:10:"app_secret";s:32:"00f8505d3d164dbfa3b11c34d9ff9c0a";s:7:"app_com";s:8:"shunfeng";}', '');

CREATE TABLE IF NOT EXISTS `qinggan_extc` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '内容值ID，对应ext表中的id',
  `content` longtext NOT NULL COMMENT '内容文本',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='扩展字段内容维护';

INSERT INTO `qinggan_extc` (`id`, `content`) VALUES
(836, '<p style="text-align: center;">Powered By phpok.com 版权所有 © 2004-2021, All right reserved.&nbsp; &nbsp;ICP证：<a href="https://beian.miit.gov.cn/" target="_blank">粤ICP备14077223号</a></p>'),
(837, 'News'),
(838, '1393'),
(840, '1389'),
(841, '1390'),
(844, '1388'),
(845, '1389'),
(846, '本区以讨论各种感情，各类人生为核心主题心灵鸡汤无处不在，不在于多少，只在于感悟懂了就是懂了，不懂仍然不懂'),
(847, '1393'),
(848, '围绕我公司提供的产品进行讨论广开言路，我公司会虚心接纳，完善产品'),
(849, '吐吐糟，发发牢骚，八卦精神无处不在笑一笑，十年少，在这个快节奏的时代里，这里还有一片净土供您休息不是我不爱，只是世界变化快^o^'),
(850, 'Photos'),
(852, '关于常见问题'),
(854, 'Download'),
(855, '深圳市锟铻科技有限公司'),
(856, '广东深圳龙华区民治大道325号东边商务大楼13层1309室'),
(857, 'admin@phpok.com'),
(858, '15818533971'),
(859, '苏先生'),
(860, 'res/201905/03/536df8e440865a64.jpg'),
(861, '<p>深圳市锟铻科技有限公司（简称<strong>锟铻科技</strong>）是一家从事 互联网+ 规划、咨询、开发及运营的综合服务商，致力于互联网市场的探索与研究，推动企业电子商务转型发展。<strong><br/></strong></p><p>专注企业\n 互联网+ 发展，将互联网思维植入传统企业，帮 助企业搭建属于自己的互联网经营平台，引领商业新生态 \n的变革，帮助企业做大做强。我们为每个客户提供专业化 和定制化的互联网+方案，坚持以客户需求为导向，竭力 \n为客户带来最大的商业价值。相信我们是您值得信赖的合作伙伴！</p><p>整体设计 我们为企业提供“品牌包装、网站建设、运营推广”一体 化整体设计，并运用新的思想，新的技术，帮助企业实现二次腾飞。专业的技术力量及丰富的运营经验深受广大客 户的认可。</p>'),
(862, '518000'),
(869, '1393'),
(1097, '<script type="text/javascript" charset="utf-8" src="//static.bshare.cn/b/buttonLite.js#style=-1&uuid=&pophcol=2&lang=zh"></script>\r\n<script type="text/javascript" charset="utf-8" src="//static.bshare.cn/b/bshareC0.js"></script>'),
(1309, 'PHPOK系统（下述简称OK系统）是一套针对网站建设的内容管理系统，采用 PHP 语言编写，默认使用 MySQL 数据库存储，基于 LGPL 开源协议授权发布到网上共享使用。'),
(1098, '<div class="bshare-custom icon-medium">\r\n	<a title="分享到QQ空间" class="bshare-qzone"></a>\r\n	<a title="分享到QQ好友" class="bshare-qqim"></a>\r\n	<a title="分享到微信" class="bshare-weixin" href="javascript:void(0);"></a>\r\n	<a title="分享到新浪微博" class="bshare-sinaminiblog"></a>\r\n	<a title="分享到有道笔记" class="bshare-youdaonote"></a>\r\n	<a title="分享到i贴吧" class="bshare-itieba"></a>\r\n	<a title="分享到Facebook" class="bshare-facebook"></a>\r\n	<a title="更多平台" class="bshare-more bshare-more-icon more-style-addthis"></a>\r\n</div>'),
(1112, '0'),
(1115, 'Products'),
(1116, '1392'),
(1117, 'About Us'),
(1221, '1'),
(1222, '2500'),
(1223, '500'),
(1297, ''),
(1298, '<p>深圳市锟铻科技有限公司（简称<strong>锟铻科技</strong>）是一家从事 互联网+ 规划、咨询、开发及运营的综合服务商，致力于互联网市场的探索与研究，推动企业电子商务转型发展。 <br/></p><h3><strong>互联网+ </strong><br/></h3><p>强大企业\r\n专注企业 互联网+ 发展，将互联网思维植入传统企业，帮 助企业搭建属于自己的互联网经营平台，引领商业新生态 的变革，帮助企业做大做强。我们为每个客户提供专业化 和定制化的互联网+方案，坚持以客户需求为导向，竭力 为客户带来最大的商业价值。相信我们是您值得信赖的合作伙伴！</p>'),
(1299, 'res/202010/10/6c4b71ae156dd4dd.jpg'),
(1300, '深圳市锟铻科技有限公司'),
(1301, '广东深圳龙华新区民治大道325号东边商务大楼13层1309室'),
(1302, 'admin@phpok.com'),
(1303, '518000'),
(1304, '0755-23776246'),
(1305, '苏生'),
(1306, '91');

CREATE TABLE IF NOT EXISTS `qinggan_fav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `user_id` int(10) unsigned NOT NULL COMMENT '会员ID',
  `thumb` varchar(255) NOT NULL COMMENT '缩略图',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `note` varchar(255) NOT NULL COMMENT '摘要',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `lid` int(11) NOT NULL COMMENT '关联主题',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员收藏夹' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_fields` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '字段ID，自增',
  `ftype` varchar(255) NOT NULL COMMENT '模型ID，当为数字时表示模块ID，非数表示其他模型的ID',
  `title` varchar(255) NOT NULL COMMENT '字段名称',
  `identifier` varchar(50) NOT NULL COMMENT '字段标识串',
  `field_type` varchar(255) NOT NULL DEFAULT '200' COMMENT '字段存储类型',
  `note` varchar(255) NOT NULL COMMENT '字段内容备注',
  `form_type` varchar(100) NOT NULL COMMENT '表单类型',
  `form_style` varchar(255) NOT NULL COMMENT '表单CSS',
  `format` varchar(100) NOT NULL COMMENT '格式化方式',
  `content` varchar(255) NOT NULL COMMENT '默认值',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序',
  `ext` text NOT NULL COMMENT '扩展内容',
  `is_front` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0前端不可用1前端可用',
  `search` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0不支持搜索1完全匹配搜索2模糊匹配搜索3区间搜索',
  `search_separator` varchar(10) NOT NULL COMMENT '分割符，仅限区间搜索时有效',
  `form_class` varchar(255) NOT NULL COMMENT '自定义表单Class',
  `onlyone` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '唯一性检测，为1值时检测字段在当前项目是否唯一',
  `group_id` varchar(255) NOT NULL DEFAULT 'main' COMMENT '字段所在组，默认是main',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='字段管理器' AUTO_INCREMENT=1337 ;

INSERT INTO `qinggan_fields` (`id`, `ftype`, `title`, `identifier`, `field_type`, `note`, `form_type`, `form_style`, `format`, `content`, `taxis`, `ext`, `is_front`, `search`, `search_separator`, `form_class`, `onlyone`, `group_id`) VALUES
(82, '22', '缩略图', 'thumb', 'int', '', 'upload', '', 'safe', '', 10, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(83, '22', '内容', 'content', 'longtext', '', 'editor', '', 'html_js', '', 255, 'a:7:{s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:1:"1";s:4:"btns";a:8:{s:5:"image";s:2:"on";s:5:"video";s:2:"on";s:5:"audio";s:2:"on";s:3:"map";s:2:"on";s:10:"insertcode";s:2:"on";s:9:"paragraph";s:2:"on";s:8:"fontsize";s:2:"on";s:10:"fontfamily";s:2:"on";}s:8:"is_float";s:1:"1";s:11:"auto_height";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(88, '24', '图片', 'pictures', 'varchar', '设置产品的图片，支持多图，上传规格为500x500', 'upload', '', 'safe', '', 50, 'a:3:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"1";s:11:"upload_auto";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(92, '21', '链接', 'link', 'longtext', '如果【子级动画】有内容，此项无效', 'text', '', 'safe', '', 90, 'a:5:{s:8:"form_btn";s:3:"url";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(93, '21', '链接方式', 'target', 'varchar', '设置是否在新窗口打开，仅限链接有效时使用', 'radio', '', 'safe', '_blank', 100, 'a:3:{s:11:"option_list";s:5:"opt:6";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";}', 0, 0, '', '', 0, 'main'),
(131, '40', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 255, 'a:7:{s:5:"width";s:3:"800";s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:0:"";s:4:"btns";a:6:{s:5:"image";s:1:"1";s:4:"info";s:1:"1";s:10:"insertcode";s:1:"1";s:9:"paragraph";s:1:"1";s:8:"fontsize";s:1:"1";s:10:"fontfamily";s:1:"1";}}', 0, 0, '', '', 0, 'main'),
(141, '46', '姓名', 'fullname', 'varchar', '', 'text', '', 'safe', '', 10, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 1, 0, '', '', 0, 'main'),
(142, '46', '邮箱', 'email', 'varchar', '', 'text', '', 'safe', '', 130, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 1, 0, '', '', 0, 'main'),
(143, '46', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 200, 'a:7:{s:6:"height";s:3:"180";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:4:"btns";a:6:{s:5:"image";s:2:"on";s:7:"emotion";s:2:"on";s:10:"insertcode";s:2:"on";s:9:"paragraph";s:2:"on";s:8:"fontsize";s:2:"on";s:10:"fontfamily";s:2:"on";}s:8:"is_float";s:0:"";s:11:"auto_height";s:0:"";}', 1, 0, '', '', 0, 'main'),
(144, '46', '管理员回复', 'adm_reply', 'longtext', '', 'editor', '', 'html_js', '', 255, 'a:7:{s:5:"width";s:3:"800";s:6:"height";s:3:"100";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:0:"";s:4:"btns";a:3:{s:5:"image";s:1:"1";s:9:"paragraph";s:1:"1";s:8:"fontsize";s:1:"1";}}', 0, 0, '', '', 0, 'main'),
(177, '22', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 20, 'a:2:{s:5:"width";s:3:"800";s:6:"height";s:2:"80";}', 0, 2, '', '', 0, 'main'),
(221, '65', '摘要', 'note', 'longtext', '简要描述下载信息', 'textarea', '', 'safe', '', 120, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(222, '65', '文件大小', 'fsize', 'varchar', '设置文件大小，注意填写相应的单位，如KB，MB', 'text', '', 'safe', '', 10, 'a:2:{s:8:"form_btn";b:0;s:5:"width";s:3:"300";}', 0, 0, '', '', 0, 'main'),
(224, '65', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 255, 'a:7:{s:5:"width";s:3:"800";s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:0:"";s:4:"btns";a:3:{s:5:"image";s:1:"1";s:9:"paragraph";s:1:"1";s:8:"fontsize";s:1:"1";}}', 0, 0, '', '', 0, 'main'),
(226, '65', '版本', 'version', 'varchar', '设置软件版本号', 'text', '', 'safe', '', 15, 'a:2:{s:8:"form_btn";b:0;s:5:"width";s:3:"100";}', 0, 0, '', '', 0, 'main'),
(227, '65', '官方网站', 'website', 'varchar', '请输入软件官方网址，没有请留空，需要加 http:// 或 https://', 'text', '', 'safe', '', 30, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(230, '65', '开发商', 'author', 'varchar', '设置开发商名称', 'text', '', 'safe', '', 20, 'a:4:{s:8:"form_btn";b:0;s:5:"width";s:3:"300";s:15:"ext_quick_words";b:0;s:14:"ext_quick_type";b:0;}', 0, 0, '', '', 0, 'main'),
(231, '65', '缩略图', 'thumb', 'varchar', '设置附件缩略图，宽高为420x420', 'upload', '', 'safe', '', 110, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"1";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(233, '66', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 255, 'a:7:{s:5:"width";s:3:"800";s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:0:"";s:4:"btns";a:4:{s:5:"image";s:1:"1";s:9:"paragraph";s:1:"1";s:8:"fontsize";s:1:"1";s:10:"fontfamily";s:1:"1";}}', 1, 0, '', '', 0, 'main'),
(234, '66', '置顶', 'toplevel', 'varchar', '', 'radio', '', 'int', '0', 10, 'a:4:{s:11:"option_list";s:6:"opt:12";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";s:6:"is_add";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1320, '66', '图片', 'pictures', 'varchar', '支持多图', 'upload', '', 'safe', '', 15, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"1";}', 1, 0, '', '', 0, 'main'),
(239, '68', '缩略图', 'thumb', 'varchar', '请上传300x300规格的图片，文件大小建议不超过100KB', 'upload', '', 'safe', '', 30, 'a:3:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";s:11:"upload_auto";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(240, '68', '图片', 'pictures', 'varchar', '支持多图，建议上传500x500或600x600规格的图片', 'upload', '', 'safe', '', 50, 'a:3:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"1";s:11:"upload_auto";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(267, '68', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 255, 'a:7:{s:5:"width";s:3:"950";s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:0:"";s:4:"btns";a:3:{s:5:"image";s:1:"1";s:9:"paragraph";s:1:"1";s:8:"fontsize";s:1:"1";}}', 0, 0, '', '', 0, 'main'),
(268, '65', '附件', 'dfile', 'varchar', '请上传文件，启用此项，附件链接失效，适用于小文件', 'upload', '', 'safe', '', 60, 'a:8:{s:7:"cate_id";s:2:"11";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:7:"rar,zip";s:11:"upload_name";s:12:"压缩软件";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(269, '46', '图片', 'pic', 'varchar', '', 'upload', '', 'safe', '', 180, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"1";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"1";s:18:"upload_compress_wh";s:3:"500";}', 1, 0, '', '', 0, 'main'),
(270, '64', '客服QQ', 'qq', 'varchar', '', 'text', '', 'safe', '', 20, 'a:2:{s:8:"form_btn";b:0;s:5:"width";s:3:"300";}', 0, 0, '', '', 0, 'main'),
(288, '24', '缩略图', 'thumb', 'varchar', '', 'upload', '', 'safe', '', 20, 'a:3:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";s:11:"upload_auto";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(293, '24', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 255, 'a:8:{s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:1:"0";s:4:"btns";a:4:{s:5:"image";s:2:"on";s:9:"paragraph";s:2:"on";s:8:"fontsize";s:2:"on";s:10:"fontfamily";s:2:"on";}s:8:"is_float";s:0:"";s:11:"auto_height";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(389, '65', '附件链接', 'dlink', 'varchar', '请填写外部附件链接，注意必须附件为空此项才有效', 'text', '', 'safe', '', 65, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(390, '65', '限制会员可下载', 'onlyuser', 'int', '', 'radio', '', 'int', '0', 70, 'a:4:{s:11:"option_list";s:5:"opt:4";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";s:6:"is_add";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(836, 'all-4', '内容', 'content', 'longtext', '备案号也在这里填写', 'editor', '', 'html', '', 90, 'a:8:{s:6:"height";s:3:"300";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:1:"1";s:4:"btns";s:0:"";s:8:"is_float";s:0:"";s:11:"auto_height";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(837, 'project-43', '英文标题En-Title', 'entitle', 'varchar', '', 'text', '', 'safe', '', 10, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"500";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(838, 'project-43', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 40, 'a:6:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(840, 'project-87', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 40, 'a:3:{s:11:"upload_type";s:7:"picture";s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(841, 'project-45', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 40, 'a:3:{s:11:"upload_type";s:7:"picture";s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1313, '24', '产品包装', 'package', 'longtext', '', 'param', '', 'safe', '', 55, 'a:7:{s:6:"p_name";s:14:"名称\r\n数量";s:5:"p_val";s:0:"";s:6:"p_type";s:1:"1";s:7:"p_width";s:0:"";s:5:"p_add";s:2:"no";s:6:"p_line";s:1:"1";s:8:"lock_row";s:0:"";}', 0, 0, '', '', 0, 'main'),
(844, 'project-96', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 40, 'a:3:{s:11:"upload_type";s:7:"picture";s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(845, 'project-151', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 40, 'a:3:{s:11:"upload_type";s:7:"picture";s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(846, 'cate-204', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 20, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(847, 'project-152', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 40, 'a:3:{s:11:"upload_type";s:7:"picture";s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(848, 'cate-205', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 20, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(849, 'cate-206', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 20, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(850, 'project-144', '英文标题', 'entitle', 'varchar', '设置与主题名称相对应的英文标题', 'text', '', 'safe', '', 255, 'a:4:{s:8:"form_btn";b:0;s:5:"width";s:3:"500";s:15:"ext_quick_words";b:0;s:14:"ext_quick_type";b:0;}', 0, 0, '', '', 0, 'main'),
(852, 'cate-207', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 20, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(854, 'project-151', '英文标题', 'entitle', 'varchar', '设置与主题名称相对应的英文标题', 'text', '', 'safe', '', 255, 'a:4:{s:8:"form_btn";b:0;s:5:"width";s:3:"500";s:15:"ext_quick_words";b:0;s:14:"ext_quick_type";b:0;}', 0, 0, '', '', 0, 'main'),
(855, 'list-1757', '企业名称', 'company', 'varchar', '', 'text', '', 'safe', '', 255, 'a:2:{s:8:"form_btn";b:0;s:5:"width";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(856, 'list-1757', '公司地址', 'address', 'varchar', '请填写您的办公地址', 'text', '', 'safe', '', 79, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"500";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(857, 'list-1757', 'Email', 'email', 'varchar', '请填写联系邮箱，用户方便客户与您取得联系', 'text', '', 'safe', '', 50, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(858, 'list-1757', '客服电话', 'tel', 'varchar', '请填写客服电话，建议填写400号', 'text', '', 'safe', '', 20, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"300";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(859, 'list-1757', '联系人', 'fullname', 'varchar', '', 'text', '', 'safe', '', 10, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"300";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(860, 'list-1756', '图片', 'pic', 'varchar', '此图片仅在首页调用中显示，限制宽高为120x150', 'text', '', 'safe', '', 10, 'a:4:{s:8:"form_btn";s:5:"image";s:5:"width";s:3:"500";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(861, 'list-1756', '摘要', 'note', 'longtext', '支持HTML，仅在首页显示，请注意长度', 'editor', '', 'html', '', 20, 'a:8:{s:6:"height";s:3:"100";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:1:"0";s:4:"btns";s:0:"";s:8:"is_float";s:0:"";s:11:"auto_height";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(862, 'list-1757', '邮编', 'zipcode', 'varchar', '请填写六位数字的邮编号码', 'text', '', 'safe', '', 30, 'a:2:{s:8:"form_btn";b:0;s:5:"width";s:3:"300";}', 0, 0, '', '', 0, 'main'),
(869, 'project-144', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 0, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(897, '77', '网站名称', 'sitename', 'varchar', '填写网站的名称', 'text', '', 'safe', '', 5, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 2, '', '', 0, 'main'),
(898, '77', '自定义链接', 'linkurl', 'varchar', '请填写链接地址，包含 http:// 或 https://', 'text', '', 'safe', '', 10, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 2, '', '', 0, 'main'),
(899, '77', '链接目标', 'target', 'varchar', '请选择是在新窗口或是当前窗口打开网址', 'radio', '', 'safe', '_blank', 15, 'a:3:{s:11:"option_list";s:5:"opt:6";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";}', 0, 0, '', '', 0, 'main'),
(900, '77', '网站LOGO', 'logo', 'varchar', '', 'upload', '', 'safe', '', 20, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"jpg,png,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(901, '77', '联系电话', 'tel', 'varchar', '请填写网站联系人电话，用于方便沟通', 'text', '', 'safe', '', 25, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 2, '', '', 0, 'main'),
(902, '77', '排序', 'taxis', 'varchar', '用于排序使用', 'text', '', 'int', '', 30, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:23:"5\n10\n15\n20\n30\n50\n80\n100";s:14:"ext_quick_type";s:4:"none";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(903, '21', '手机版图片', 'picmobile', 'int', '仅用于手机版或是公众号或是小程序中，图片宽高要求是：720x400', 'upload', '', 'safe', '', 30, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(910, '64', '客服类型', 'qtype', 'varchar', '选择客服类型，QQ请填写QQ号，微信请填写微信号及二维码图片', 'radio', '', 'safe', 'qq', 10, 'a:3:{s:11:"option_list";s:6:"opt:20";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";}', 0, 0, '', '', 0, 'main'),
(911, '64', '微信号', 'weixin', 'varchar', '', 'text', '', 'safe', '', 25, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(912, '64', '微信二维码', 'qrcode', 'varchar', '', 'upload', '', 'safe', '', 30, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"jpg,png,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(1097, 'all-37', '统计代码', 'statjs', '200', '用于填写分享的代码，这里的代码是不可见的', 'code_editor', '', 'html_js', '', 20, 'a:2:{s:5:"width";s:3:"800";s:6:"height";s:3:"200";}', 0, 0, '', '', 0, 'main'),
(1098, 'all-37', '分享代码', 'share', 'longtext', '', 'code_editor', '', 'html_js', '', 10, 'a:2:{s:5:"width";s:3:"800";s:6:"height";s:3:"150";}', 0, 0, '', '', 0, 'main'),
(1112, 'project-148', '底部浮动', 'isbottom', '200', '选择是客服将在页脚浮动，否就在右侧浮动', 'radio', '', 'int', '0', 5, 'a:3:{s:11:"option_list";s:5:"opt:4";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1115, 'project-45', '英文标题', 'entitle', 'varchar', '适用于项目名称显示英文标题使用', 'text', '', 'safe', '', 0, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1116, 'list-1757', '公司图片地址', 'map', '200', '请上传一张 800x330 规格的静态地图图片', 'upload', '', 'safe', '', 84, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1117, 'project-87', '英文标题', 'entitle', 'varchar', '适用于项目名称显示英文标题使用', 'text', '', 'safe', '', 0, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1134, 'user', '姓名', 'fullname', 'varchar', '', 'text', '', 'safe', '', 5, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 1, 0, '', '', 0, 'main'),
(1139, '22', '来源', 'linkurl', 'varchar', '请填写链接地址，外链请输入http://或https://', 'text', '', 'safe', '', 35, 'a:5:{s:8:"form_btn";s:3:"url";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1140, '22', '网站', 'linksite', 'varchar', '填写网站或作者名称', 'text', '', 'safe', '', 40, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1309, 'list-18', '页脚简介', 'footnote', '200', '用于放在页脚的简介信息，请注意内容长度', 'textarea', '', 'safe', '', 20, 'a:2:{s:5:"width";s:3:"500";s:6:"height";s:3:"180";}', 0, 0, '', '', 0, 'main'),
(1296, '24', '内容图片', 'contentpics', 'varchar', '用于放在内容区里的图片，一般图片宽度是1024，以确保图片精度', 'upload', '', 'safe', '', 255, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(1295, '24', '子标题', 'subtitle', 'varchar', '', 'text', '', 'safe', '', 10, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"300";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1221, 'project-41', '是否循环', 'pnloop', '200', '前/后按钮是否继续循环，若为false则当翻动到最前/后页时，前/后按钮点击无效', 'radio', '', 'int', '', 5, 'a:3:{s:11:"option_list";s:5:"opt:4";s:9:"put_order";s:1:"0";s:10:"ext_select";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1222, 'project-41', '等待时间', 'intertime', '200', '单侠毫秒；自动运行间隔。', 'text', '', 'int', '2500', 10, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:19:"2500\n3000\n5000\n7000";s:14:"ext_quick_type";s:4:"none";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1223, 'project-41', '切换时间', 'delaytime', '200', '单位毫秒；切换效果持续时间（一次切换效果执行所用的时间长度）。', 'text', '', 'int', '500', 15, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:24:"500\n600\n700\n800\n900\n1000";s:14:"ext_quick_type";s:4:"none";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1224, 'user', '背景色', 'bgcolor', 'varchar', '应用到小程序的背景色', 'text', '', 'safe', '', 30, 'a:5:{s:8:"form_btn";s:5:"color";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"1";}', 0, 0, '', '', 0, 'main'),
(1225, 'user', '背景图片', 'bgimg', 'varchar', '应用于小程序的背景图片', 'text', '', 'safe', '', 50, 'a:5:{s:8:"form_btn";s:4:"file";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1312, '110', '内容', 'content', 'longtext', '', 'design', '', 'html_js', '', 15, 'a:1:{s:6:"height";s:3:"360";}', 0, 0, '', '', 0, 'main'),
(1232, 'user', '性别', 'gender', 'varchar', '', 'radio', '', 'safe', '未知', 10, 'a:3:{s:11:"option_list";s:0:"";s:9:"put_order";s:1:"0";s:10:"ext_select";s:16:"未知\r\n男\r\n女";}', 1, 0, '', '', 0, 'main'),
(1237, '21', '通栏图片', 'banner', 'varchar', '建议图片规格是1920x500', 'upload', '', 'safe', '', 20, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1311, '110', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 10, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(1297, 'list-18', '英文标题', 'entitle', 'varchar', '适用于项目名称显示英文标题使用', 'text', '', 'safe', '', 5, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1298, 'list-18', '摘要', 'note', 'longtext', '简要文字描述', 'editor', '', 'safe', '', 10, 'a:8:{s:6:"height";s:3:"200";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:1:"1";s:4:"btns";a:2:{s:9:"paragraph";s:2:"on";s:8:"fontsize";s:2:"on";}s:8:"is_float";s:0:"";s:11:"auto_height";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1299, 'list-18', '首页图片', 'pic', '200', '请上传规格是500x400的图片', 'text', '', 'safe', '', 15, 'a:5:{s:8:"form_btn";s:5:"image";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1300, 'list-20', '企业名称', 'company', 'varchar', '', 'text', '', 'safe', '', 5, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"500";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1301, 'list-20', '联系地址', 'address', 'varchar', '', 'text', '', 'safe', '', 10, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"500";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1302, 'list-20', '邮箱', 'email', 'varchar', '', 'text', '', 'safe', '', 15, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1303, 'list-20', '邮编', 'zipcode', 'varchar', '请填写六位数字的邮编号码', 'text', '', 'safe', '', 20, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"300";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1304, 'list-20', '联系电话', 'tel', 'varchar', '', 'text', '', 'safe', '', 25, 'a:4:{s:8:"form_btn";s:0:"";s:5:"width";s:3:"300";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1305, 'list-20', '联系人', 'fullname', 'varchar', '', 'text', '', 'safe', '', 30, 'a:5:{s:8:"form_btn";s:0:"";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1306, 'list-20', '地图', 'map', '200', '放在首页上使用的', 'upload', '', 'safe', '', 35, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1310, '110', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 5, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(1314, '111', '缩略图', 'thumb', 'varchar', '', 'upload', '', 'safe', '', 5, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(1315, '111', '视频', 'video', 'varchar', '系统支持识别优酷，QQ，Youtube，B站，请填写播放页网址', 'text', '', 'safe', '', 10, 'a:7:{s:8:"form_btn";s:5:"video";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";s:9:"ext_field";s:0:"";s:11:"ext_onlyone";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1316, '111', 'MP4文件', 'mp4', 'varchar', '适用于本地附件', 'upload', '', 'safe', '', 15, 'a:2:{s:7:"cate_id";s:2:"24";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main'),
(1317, '111', '内容', 'content', 'longtext', '', 'editor', '', 'html', '', 255, 'a:7:{s:5:"width";s:3:"950";s:6:"height";s:3:"360";s:7:"is_code";s:0:"";s:7:"is_read";s:0:"";s:7:"inc_tag";s:0:"";s:10:"paste_text";s:0:"";s:4:"btns";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1318, 'project-452', '通栏图片', 'banner', 'varchar', '', 'upload', '', 'safe', '', 5, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(1319, '111', '视频封面', 'mp4_bg', 'varchar', '仅限本地播放有效，建议使用1600x900规格', 'text', '', 'safe', '', 20, 'a:7:{s:8:"form_btn";s:5:"image";s:10:"ext_format";s:0:"";s:15:"ext_quick_words";s:0:"";s:14:"ext_quick_type";s:0:"";s:13:"ext_include_3";s:1:"0";s:9:"ext_field";s:0:"";s:11:"ext_onlyone";s:0:"";}', 0, 0, '', '', 0, 'main'),
(1321, '112', '缩略图', 'thumb', 'varchar', '', 'upload', '', 'safe', '', 5, 'a:8:{s:7:"cate_id";s:1:"1";s:11:"cate_custom";s:1:"0";s:11:"is_multiple";s:1:"0";s:11:"upload_type";s:11:"png,jpg,gif";s:11:"upload_name";s:6:"图片";s:13:"upload_binary";s:1:"0";s:15:"upload_compress";s:1:"0";s:18:"upload_compress_wh";s:3:"500";}', 0, 0, '', '', 0, 'main'),
(1322, '112', '摘要', 'note', 'longtext', '简要文字描述', 'textarea', '', 'safe', '', 10, 'a:2:{s:5:"width";s:3:"600";s:6:"height";s:2:"80";}', 0, 0, '', '', 0, 'main'),
(1323, '112', '内容', 'content', 'longtext', '', 'design', '', 'html_js', '', 15, 'a:1:{s:6:"height";s:3:"360";}', 0, 0, '', '', 0, 'main'),
(1324, '112', '通栏图片', 'banner', 'varchar', '建议使用宽度1920规格的JPG图片，建议大小不超过300KB', 'upload', '', 'safe', '', 8, 'a:2:{s:7:"cate_id";s:1:"1";s:11:"is_multiple";s:1:"0";}', 0, 0, '', '', 0, 'main');

CREATE TABLE IF NOT EXISTS `qinggan_freight` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '运费模板ID，自增ID',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `title` varchar(100) NOT NULL COMMENT '模板名称，便于后台管理',
  `type` enum('weight','volume','number','fixed','price','vweight') NOT NULL DEFAULT 'weight' COMMENT 'weight重量volume体积number数量fixed固定值vweight体积重',
  `currency_id` int(11) NOT NULL DEFAULT '0' COMMENT '货币ID',
  `taxis` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `country_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家ID',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='物流运费模板管理' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_freight_price` (
  `zid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '区域ID',
  `unit_val` varchar(20) NOT NULL COMMENT '单位量，如0.5kg，或1个或1立方米，取决于系统设定',
  `price` varchar(50) NOT NULL DEFAULT '0' COMMENT '运费价格，最低为0，不能为负数',
  PRIMARY KEY (`zid`,`unit_val`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='单位体积价格';

CREATE TABLE IF NOT EXISTS `qinggan_freight_zone` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '运费模板ID',
  `title` varchar(100) NOT NULL COMMENT '名称',
  `taxis` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `note` varchar(255) NOT NULL COMMENT '简单说明该区域信息',
  `area` longtext NOT NULL COMMENT '省份+城市',
  PRIMARY KEY (`id`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='运费模板区域设置' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_gateway` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID，为0表示所有站点可用',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不可用1可用',
  `is_default` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1表示默认使用',
  `type` varchar(50) NOT NULL COMMENT '类型，gateway文件夹的子文件夹',
  `code` varchar(50) NOT NULL COMMENT '路由引挈',
  `title` varchar(255) NOT NULL COMMENT '名称',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序',
  `note` varchar(255) NOT NULL COMMENT '功能备注',
  `ext` text NOT NULL COMMENT '扩展参数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='第三方网关路由引挈' AUTO_INCREMENT=20 ;

INSERT INTO `qinggan_gateway` (`id`, `site_id`, `status`, `is_default`, `type`, `code`, `title`, `taxis`, `note`, `ext`) VALUES
(13, 1, 1, 1, 'email', 'okmail', '邮件发送', 5, '', 'a:6:{s:6:"server";s:32:"https://www.phpok.com/apix-31134";s:2:"ip";s:0:"";s:6:"app_id";s:1:"3";s:7:"app_key";s:16:"vhDsxyZSsHnBeXlV";s:5:"reply";s:15:"qinggan@188.com";s:7:"siteurl";s:22:"https://www.phpok.com/";}'),
(18, 1, 1, 1, 'sms', 'oksms', '短信验证码', 5, '', 'a:6:{s:6:"server";s:32:"https://www.phpok.com/apix-31566";s:2:"ip";s:13:"119.23.144.85";s:6:"app_id";s:1:"3";s:7:"app_key";s:16:"vhDsxyZSsHnBeXlV";s:7:"signame";s:0:"";s:7:"tplcode";s:0:"";}');

CREATE TABLE IF NOT EXISTS `qinggan_gd` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `identifier` varchar(100) NOT NULL COMMENT '标识串',
  `title` varchar(255) NOT NULL COMMENT '类型名称，方便管理',
  `width` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '图片宽度',
  `height` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '图片高度',
  `mark_picture` varchar(255) NOT NULL COMMENT '水印图片位置',
  `mark_position` varchar(100) NOT NULL COMMENT '水印位置',
  `cut_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '图片生成方式，支持缩放法、裁剪法、等宽、等高及自定义五种，默认使用缩放法',
  `quality` tinyint(3) unsigned NOT NULL DEFAULT '100' COMMENT '图片生成质量，默认是100',
  `bgcolor` varchar(10) NOT NULL DEFAULT 'FFFFFF' COMMENT '补白背景色，默认是白色',
  `trans` tinyint(3) unsigned NOT NULL DEFAULT '65' COMMENT '透明度',
  `editor` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0普通1默认插入编辑器',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='上传图片自动生成方案' AUTO_INCREMENT=13 ;

INSERT INTO `qinggan_gd` (`id`, `identifier`, `title`, `width`, `height`, `mark_picture`, `mark_position`, `cut_type`, `quality`, `bgcolor`, `trans`, `editor`) VALUES
(2, 'thumb', '缩略图', 320, 320, '', 'bottom-right', 1, 80, 'FFFFFF', 0, 0),
(12, 'auto', '自动压缩图', 0, 0, '', 'bottom-right', 0, 80, 'FFFFFF', 0, 1);

CREATE TABLE IF NOT EXISTS `qinggan_hits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后点击时间（3小时内多次点击仅记一次）',
  `title` varchar(255) NOT NULL COMMENT '标题，仅用于第一次记录，如修改了此标题不会一起修改',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`,`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='主题点击记录' AUTO_INCREMENT=3 ;

INSERT INTO `qinggan_hits` (`id`, `tid`, `user_id`, `dateline`, `title`) VALUES
(1, 1762, 23, 1592227936, 'vivo Xplay5 全网通4G手机 4GB+128GB 双卡双待'),
(2, 1762, 23, 1592273003, 'vivo Xplay5 全网通4G手机 4GB+128GB 双卡双待');

CREATE TABLE IF NOT EXISTS `qinggan_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0为根主题，其他ID对应list表的id字段',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `module_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '模块ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `site_id` mediumint(8) unsigned NOT NULL COMMENT '网站ID',
  `title` varchar(255) NOT NULL COMMENT '主题',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发布时间',
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后修改时间',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0未审核，1已审核',
  `hidden` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0显示，1隐藏',
  `hits` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '查看次数',
  `tpl` varchar(255) NOT NULL COMMENT '自定义的模板',
  `seo_title` varchar(255) NOT NULL COMMENT 'SEO标题',
  `seo_keywords` varchar(255) NOT NULL COMMENT 'SEO关键字',
  `seo_desc` varchar(255) NOT NULL COMMENT 'SEO描述',
  `tag` varchar(255) NOT NULL COMMENT 'tag标签',
  `attr` varchar(255) NOT NULL COMMENT '主题属性',
  `replydate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后回复时间',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID号，为0表示管理员发布',
  `identifier` varchar(255) NOT NULL COMMENT '内容标识串',
  `integral` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '财富基于，用于计算财富的基础量',
  `style` varchar(255) NOT NULL COMMENT 'CSS样式',
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`),
  KEY `site_id` (`site_id`,`identifier`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='内容主表' AUTO_INCREMENT=2263 ;

INSERT INTO `qinggan_list` (`id`, `parent_id`, `cate_id`, `module_id`, `project_id`, `site_id`, `title`, `dateline`, `lastdate`, `sort`, `status`, `hidden`, `hits`, `tpl`, `seo_title`, `seo_keywords`, `seo_desc`, `tag`, `attr`, `replydate`, `user_id`, `identifier`, `integral`, `style`) VALUES
(1, 0, 0, 21, 41, 1, '三网合一，一站式服务', 1602246929, 1610077027, 20, 1, 0, 0, '', '', '', '', '', '', 0, 0, '', 0, ''),
(2, 0, 0, 21, 41, 1, '10年产品发展，稳定，健全的企业服务系统', 1602246991, 1610076988, 10, 1, 0, 0, '', '', '', '', '', '', 0, 0, '', 0, ''),
(3, 0, 0, 21, 41, 1, '支持心中那一份支持', 1602247012, 1610077050, 30, 1, 0, 0, '', '', '', '', '', '', 0, 0, '', 0, ''),
(4, 0, 583, 24, 45, 1, '魅族 15 Plus', 1602247765, 1602312808, 0, 1, 0, 63, '', '', '', '', '', '', 0, 0, '', 0, ''),
(5, 0, 211, 68, 144, 1, '魅族 15Plus', 1602251728, 1602314272, 0, 1, 0, 14, '', '', '', '', '', '', 0, 0, '', 0, ''),
(6, 0, 584, 24, 45, 1, '荣耀20 PRO', 1602261328, 1602300998, 0, 1, 0, 12, '', '', '', '', '', '', 0, 0, '', 0, ''),
(7, 0, 582, 24, 45, 1, 'Redmi 9A', 1602262832, 1602313327, 0, 1, 0, 71, '', '', '', '', '', '', 1610411684, 0, '', 0, ''),
(9, 0, 701, 24, 45, 1, '开业花篮（红色系）', 1602264350, 1602301918, 0, 1, 0, 5, '', '', '', '', '', '', 0, 0, '', 0, ''),
(10, 0, 701, 24, 45, 1, '青苹果杏叶藤/心叶藤 青苹果杏叶藤/心叶藤 青苹果杏叶藤/心叶藤', 1602265884, 1613695812, 0, 1, 0, 6, '', '', '', '', '', '', 0, 0, '', 0, ''),
(11, 0, 701, 24, 45, 1, '测试产品', 1602266234, 1619935640, 0, 1, 0, 59, '', '', '', '', '', '', 0, 0, '', 0, ''),
(12, 0, 8, 22, 43, 1, '升级包制作', 1539886018, 1602297017, 0, 1, 0, 11, '', '', '', '', 'phpok,升级包', '', 0, 0, '', 0, ''),
(13, 0, 68, 22, 43, 1, '浏览器25年之巨变：IE曾是真·王者 被Chrome夺走宝座', 1602266911, 1610169806, 0, 1, 0, 47, '', '', '', '', '浏览器,IE,Chrome', '', 1610171908, 0, '', 0, ''),
(14, 0, 68, 22, 43, 1, 'Windows 95 诞生 25 周年', 1602266997, 1606203293, 0, 1, 0, 1, '', '', '', '', 'windows 95,操作系统', '', 0, 0, '', 0, ''),
(15, 0, 68, 22, 43, 1, '90后和00后代沟有多大？苏宁推客大数据告诉你', 1577939400, 1602296988, 0, 1, 0, 0, '', '', '', '', '代沟,大数据', '', 0, 0, '', 0, ''),
(16, 0, 68, 22, 43, 1, '巨头为什么一齐瞄准知识领域？', 1577676960, 1602313914, 0, 1, 0, 1, '', '', '', '', '知识', '', 0, 0, '', 0, ''),
(17, 0, 68, 22, 43, 1, '如何提高服务器的并发处理能力？', 1602267515, 1620810573, 0, 1, 0, 142, '', '', '', '', '服务器,并发,处理能力', '', 1610172174, 0, '', 0, ''),
(18, 0, 0, 40, 87, 1, '公司简介', 1602297289, 1620695922, 10, 1, 0, 54, '', '', '', '', '', '', 0, 0, 'aboutus', 0, ''),
(19, 0, 0, 40, 87, 1, '发展历程', 1602297401, 1602297401, 20, 1, 0, 18, '', '', '', '', '', '', 0, 0, 'development-course', 0, ''),
(20, 0, 0, 40, 87, 1, '联系我们', 1602298323, 1610148735, 30, 1, 0, 25, 'contactus', '', '', '', '', '', 0, 0, 'contactus', 0, ''),
(37, 0, 204, 66, 152, 1, '测试用的', 1604075213, 0, 0, 1, 0, 0, '', '', '', '', '', '', 0, 23, '', 0, ''),
(38, 0, 204, 66, 152, 1, '测试2', 1604075230, 0, 0, 1, 0, 0, '', '', '', '', '', '', 0, 23, '', 0, ''),
(39, 0, 204, 66, 152, 1, '测试3', 1604075302, 1604075302, 0, 1, 0, 0, '', '', '', '', '', '', 0, 0, '', 0, ''),
(2262, 0, 8, 22, 43, 1, '测试视频', 1620822100, 1620822745, 0, 1, 0, 2, '', '', '', '', '', '', 0, 0, '', 0, ''),
(41, 0, 0, 110, 451, 1, 'APP 隐私协议', 1610104099, 1610150699, 0, 1, 0, 65, '', '', '', '', '协议,隐私,保密,注册', '', 0, 0, 'application-privacy-agreement', 0, 'text-decoration:on;'),
(42, 0, 0, 110, 451, 1, '用户注册协议', 1610113331, 1610113462, 0, 1, 0, 17, '', '', '', '', '', '', 0, 0, 'user-registration-agreement', 0, ''),
(43, 0, 0, 110, 451, 1, '售后保障', 1610282650, 1610282925, 0, 1, 0, 2, '', '', '', '', '', '', 0, 0, 'after-sale-protection', 0, ''),
(44, 0, 0, 46, 96, 1, '测试给自己的留言', 1610284903, 1610284986, 0, 1, 0, 0, '', '', '', '', '', '', 0, 0, '', 0, ''),
(45, 0, 198, 65, 151, 1, '测试下载（会员限制）', 1610355663, 1610356492, 0, 1, 0, 8, '', '', '', '', '', '', 0, 0, '', 0, ''),
(46, 0, 199, 65, 151, 1, '开放下载', 1610359354, 1614718520, 0, 1, 0, 4, '', '', '', '', '', '', 0, 0, '', 0, ''),
(47, 0, 0, 111, 452, 1, 'PHPOK基础教程（1）系统安装', 1610368568, 1610368568, 0, 1, 0, 15, '', '', '', '', '', '', 0, 0, '', 0, ''),
(48, 0, 204, 66, 152, 1, '测试新贴', 1610409626, 0, 0, 1, 0, 1, '', '', '', '', '', '', 0, 23, '', 0, ''),
(49, 0, 204, 66, 152, 1, '再来新的图片9999888', 1610409760, 0, 0, 1, 0, 3, '', '', '', '', '', '', 0, 23, '', 0, ''),
(50, 0, 0, 112, 453, 1, '测试专题（仅用于测试效果）', 1610420662, 1610694547, 0, 1, 0, 99, '', '', '', '', '', '', 0, 0, '', 0, '');

CREATE TABLE IF NOT EXISTS `qinggan_list_21` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `link` longtext NOT NULL COMMENT '链接',
  `target` varchar(255) NOT NULL DEFAULT '_blank' COMMENT '链接方式',
  `picmobile` int(11) NOT NULL COMMENT '手机版图片',
  `banner` varchar(255) NOT NULL DEFAULT '' COMMENT '通栏图片',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图片播放器';

INSERT INTO `qinggan_list_21` (`id`, `site_id`, `project_id`, `cate_id`, `link`, `target`, `picmobile`, `banner`) VALUES
(1, 1, 41, 0, 'index.php', '_self', 0, '88'),
(2, 1, 41, 0, '', '_self', 0, '87'),
(3, 1, 41, 0, '', '_blank', 0, '89');

CREATE TABLE IF NOT EXISTS `qinggan_list_22` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `thumb` int(11) NOT NULL COMMENT '缩略图',
  `content` longtext NOT NULL COMMENT '内容',
  `note` longtext NOT NULL COMMENT '摘要',
  `plugin_vote` int(11) NOT NULL DEFAULT '0' COMMENT '插件投票统计-plugin-vote',
  `linkurl` varchar(255) NOT NULL DEFAULT '' COMMENT '来源',
  `linksite` varchar(255) NOT NULL DEFAULT '' COMMENT '网站',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章资讯';

INSERT INTO `qinggan_list_22` (`id`, `site_id`, `project_id`, `cate_id`, `thumb`, `content`, `note`, `plugin_vote`, `linkurl`, `linksite`) VALUES
(12, 1, 43, 8, 0, '<h2>结构</h2><p>将要升级的文件按原目录结构存放</p><p><img src="https://www.phpok.com/res/201810/19/auto_10158.png" title="图片" alt="图片"/></p><p>和程序要一起打包的文件有：</p><blockquote><p>version.txt：版本信息</p><p>delete.txt：要删除的文件清单（一行一个文件）</p><p>table.sql：新版的数据表结构文件，用于执行比较新旧版本数据结构，并调整更改</p><p>update.sql：要执行的SQL文件（单独执行）</p><p>run.php：如果升级涉及到比较复杂的操作，可以在这里写PHP文件引入执行<br/></p></blockquote><h2>升级原理顺序<br/></h2><ol style="list-style-type: decimal;" class=" list-paddingleft-2"><li><p>远程获取升级包数据</p></li><li><p>将 ZIP 压缩包下载到 _data 目录下</p></li><li><p>将下载好的压缩包解压到 _data/update/ 目录下</p></li><li><p>归纳整理文件（主要是收集：version.txt，delete.txt，table.sql，update.sql，run.php）</p></li><li><p>将 framework 这个目录的文件及文件夹移到现有程序的核心框架（可能用户会因为安全原因改名）</p></li><li><p>移动其他目录文件（或创建目录）</p></li><li><p>删除delete.txt清单中的文件【非必须】</p></li><li><p>执行 table.sql 操作（比较表结构，更新到最新的表结构）【非必须】</p></li><li><p>运行 update.sql 或是其他的 sql 文件【非必须】</p></li><li><p>运行 run.php 执行复杂的升级操作【非必须】</p></li><li><p>删除 _data/update/ 下的文件</p></li><li><p>基于 version.txt 更新版本记录</p></li></ol><h2>特别说明</h2><p>table.sql 必须是完整的数据表结构，才能进行升级比较，基本上这个操作比较复杂，不推荐使用</p><p>delete.txt 主要是删除文件操作，除非涉及到安全漏洞，一般我们没必要执行删除操作</p><p>update.sql 这里执行的SQL是不进行判断的，如果涉及到升级一关失败了，可能会出错（除非SQL里有写好相应的判断）</p><p>run.php 重点在这里，这个文件意味着可以完全嵌入执行PHP，可以用PHP来写数据表的增删查改，也支持文件的删除，也支持数据表结构的更新等等！一般OK程序的升级都会有这个的（纯文件覆盖更新连这个都可以忽略的）</p>', 'table.sql 必须是完整的数据表结构，才能进行升级比较，基本上这个操作比较复杂，不推荐使用\r\ndelete.txt 主要是删除文件操作，除非涉及到安全漏洞，一般我们没必要执行删除操作\r\nupdate.sql 这里执行的SQL是不进行判断的，如果涉及到升级一关失败了，可能会出错（除非SQL里有写好相应的判断）', 0, '', ''),
(13, 1, 43, 68, 0, '<p class="">浏览器是我们上网冲浪之必备工具，无论是台式机、平板、智能手机，你都离不开一款浏览器。</p><p class="">在过去25年间，浏览器市场经历了翻天覆地的变化。</p><p class=""><strong class="">1995年，网景浏览器(Netscape )占据浏览器80.4%的份额</strong>，但是到1995年8月16日，微软推出了第一代Internet Explore浏览器，之后IE就一直作为Windows的默认浏览器，也是从那一年开始，IE开始了持续增长，不断蚕食网景的份额。</p><p style="text-align:center"><img src="https://www.phpok.com/res/_cache/auto/14/14414.png" title="图片" alt="图片"/></p><p><strong>2002年，IE浏览器迎来顶峰，市场份额高达95.4%</strong>。一家独大，是真正的浏览器王者，放眼全球，没有任何对手。</p><p><br/></p><p style="text-align:center"><img src="https://www.phpok.com/res/_cache/auto/14/14415.png" title="图片" alt="图片"/></p><p>月圆则缺水满则溢，所谓盛极必衰就是IE了。2002年下半年，Firefox火狐问世，之后数年，它成了IE的唯一对手，2008年市场份额一度达到33.1%。</p><p>然而，Safari和Chrome相继问世。尤其是Chrome，2008年一经问世便表现出了非凡的天赋，一路披荆斩棘所向披靡。</p><p><strong>2011年，Chrome超越Firefox，2012年，又超越IE，成为全球第一大浏览器</strong>。</p><p>2019年，Chrome市场份额57%，Safari排在第二位，份额为13.4%。其它较为知名的玩家还有Firefox、IE、Edge、Opera。</p><p><br/></p><p style="text-align:center"><img src="https://www.phpok.com/res/_cache/auto/14/14416.png" title="图片" alt="图片"/></p><p>到了今年，Chrome依然牢牢占据第一的位置，第三方统计机构数据显示，<strong>仅仅在桌面领域，Chrome的市场份额就接近70%</strong>。</p><p>现如今，曾经的王者IE已经被微软放弃，虽然仍旧可以使用，但实际上，微软已经将所有对浏览器的期待都放到了Edge身上。提一下，Edge是微软基于Chromium内核开发的新版浏览器，被预装在Windows 10中.</p><p><br/></p>', '浏览器是我们上网冲浪之必备工具，无论是台式机、平板、智能手机，你都离不开一款浏览器。在过去25年间，浏览器市场经历了翻天覆地的变化。', 0, '', ''),
(14, 1, 43, 68, 77, '<p>8月24日是 Windows 95 诞生 25 周年的纪念日，在这个有特殊意义的日子里，微软发布了一段回顾 Windows 95 \r\n的视频，向大众介绍了其中一些经典元素（开始菜单、回收站、扫雷和纸牌等）的改变和演进，以及系统整体视觉风格和 UI 设计上的变化。</p><p style="text-align: center;"><img src="res/_cache/auto/77/77.jpg" title="window-95" alt="window-95"/></p><p style="text-align: center;">▲ <a href="https://youtu.be/MhZVyQtFx_U" target="_blank">https://youtu.be/MhZVyQtFx_U</a></p><p>除此之外，微软还制作了两集播客，对两位曾参与 Windows 95 开发的工程师进行采访，目前他们仍在微软工作。</p><ul class=" list-paddingleft-2"><li><p><strong>The Start of Something Different, Part 1</strong><strong>: </strong>这集采访了 Windows 的首席软件工程师 Raymond Chen，他回顾了 Windows 95 系统的历史以及早期的应用程序兼容性和测试</p></li><li><p><strong>The Start of Something Different, Part 2</strong><strong>: </strong>这集由 Windows 的主要软件开发者 Chris Guzak 分享 Windows 95 标志性体验的历史，包括“开始”菜单、任务栏以及早期的软件可用性测试</p></li></ul><p>Windows 95 作为微软历史上具备里程碑意义的操作系统版本之一，拥有许多新功能和变化，简单回顾一下：</p><ol class=" list-paddingleft-2"><li><p>全新的“开始”按钮、菜单和任务栏</p></li><li><p>引入 Windows 资源管理器</p></li><li><p>改进多任务处理</p></li><li><p>引入即插即用机制，支持自动检测和安装硬件</p></li><li><p>支持长文件名（最多 250 个字符）</p></li><li><p>引入 Microsoft Network (MSN)，MSN 旨在通过拨号连接访问电子邮件、聊天室，新闻组和首个 WWW 主页</p></li><li><p>首次提出在多台计算机之间同步数据的想法，自带的&quot;My Briefcase&quot;程序旨在在笔记本电脑和台式计算机之间同步文件</p></li><li><p>首个搭售 Internet Explorer(IE) 的系统</p></li></ol><p>以上的变化如今有的已被取代，例如\r\n IE 浏览器；有的则继续被沿用着，例如开始菜单概念——它甚至称得上 Windows \r\n系统最具代表性且影响最深远的设计。话说影响一直持续至今的可能还有 Windows 95 这个名字，据说 Windows 9 \r\n就是因为它而被跳过，整个 Windows 家族命名方式的变化也是由此而起。</p><p>1995年8月24日对于微软来说是重要的一天，杰伊·莱诺(Jay Leno)与微软联合创始人比尔·盖茨(Bill Gates)共同宣布了 Windows 95，整个 Windows 95 开发团队也登台亮相。</p><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/045bcb14fd6fbdc2_58_0.jpg"/></p><p>为宣传这款系统，微软斥巨资铺天盖地在电视台投放搭配滚石乐队《Start\r\n Me Up》歌曲的广告，甚至还请来《老友记》演员 Jennifer Aniston（“瑞秋”饰演者）和 Matthew \r\nPerry（“钱德勒”饰演者）拍摄介绍 Windows 95 的长达一小时的情境短剧。</p><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/8408c4071b009add_84_1.png"/></p><p>在微软的强力营销下，Windows 95 在前五周内就售出了 700 万份，市场一度出现午夜时分消费者在 CompUSA 和百思买排队购买 Windows 95 CD-ROM 副本的热闹场面。</p><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/ec3801b6f503f0a8_49_2.jpg" height="591"/></p><p>现在想体验原汁原味的 Windows 95 并非易事，不过好在有开发者基于 Electron 打造了可在 macOS, Linux 和 Windows 上运行的 Windows 95，详情查看 <a href="https://github.com/felixrieseberg/windows95" target="_blank">https://github.com/felixrieseberg/windows95</a>。</p><h3>部分图集</h3><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/24a9437d34d61655_74_3.jpg"/></p><p style="text-align: center;">▲ 比尔·盖茨向世界推出了 Windows 95</p><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/318fe45380d1e826_46_4.jpg"/></p><p style="text-align: center;">▲ 革命性的“开始菜单”</p><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/41b3395e4f37faf6_33_5.jpg"/></p><p style="text-align: center;">▲ Windows 95 桌面</p><p style="text-align: center;"><img src="https://www.phpok.com/res/202009/01/41d187d506be6882_30_6.jpg" height="612"/></p><p style="text-align: center;">▲ Windows 95 零售副本</p><p><br/></p>', '8月24日是 Windows 95 诞生 25 周年的纪念日，在这个有特殊意义的日子里，微软发布了一段回顾 Windows 95 的视频，向大众介绍了其中一些经典元素（开始菜单、回收站、扫雷和纸牌等）的改变和演进，以及系统整体视觉风格和 UI 设计上的变化。', 0, '', ''),
(15, 1, 43, 68, 0, '<p>2019年已经结束，年终总结愁到人头秃。效率惊人的苏宁率先发布了年终大数据报告，唤醒了“社畜们”难得的好奇心。</p><p>“你会在朋友圈买东西吗?”朋友急冲冲在微信上问我。</p><p>“看到好东西就会买啊，你问这个干啥?”</p><p>在我的追问下朋友告诉我，原来这两天“90后和00后的代沟有多大”冲上了热搜，她一边咆哮着我还没老，一边暗搓搓观察自己是不是真的跟00后有代沟，结果就看到了苏宁推客的年终大数据指出：会在朋友圈买东西的90后占了31.7%，80后占了37.0%，而00后只占了9.0%。</p><p style="text-align:center;"><img id="68437535" src="https://www.phpok.com/res/202001/02/affff7dc67d4b1cb_32_0.png" title="90后和00后代沟有多大？苏宁推客大数据告诉你" alt="90后和00后代沟有多大？苏宁推客大数据告诉你"/></p><p>“我不服!怎么也没想到我跟80后是一挂的……”朋友委屈巴巴抗议。</p><p>毕竟再过几天，第一批90后就要迈入“30岁大军”，2019仿佛就是他们的最后一条底裤，但是马上这条底裤就要像他们的头发一样离他们而去了，怎么能不让人难过呢?</p><p>正当我想要跟她抱头痛哭的时候，她突然发出了杠铃般的笑声，又给我发了一组数据，我抹干眼泪定睛一看：在朋友圈买东西的女性占比56.3%，男性占比43.7%..……Excuse me?男性占比43.7%?</p><p style="text-align:center;"><img id="68437537" src="https://www.phpok.com/res/202001/02/d5287c9070db15d6_95_1.png" title="90后和00后代沟有多大？苏宁推客大数据告诉你" alt="90后和00后代沟有多大？苏宁推客大数据告诉你"/></p><p>打扰了，现在的男生购物欲这么强的吗?谁能想到表面上仿佛只知道一日三餐的钢铁直男们，背地里在朋友圈买东西买的这么勤，还真是有两幅面孔呢!</p><p>这时我又想到了上个星期我爹说在网上买的那四斤流心柿子……打开朋友圈翻翻记录，远方二舅在卖……ok，破案了。</p><p>妈!我爸藏私房钱!!!</p><p>你以为奇妙操作仅限于此?NONONO!苏宁推客这组数据还指出：南京、上海、北京这三个地区的人在朋友圈买东西最多。这我就真实迷惑了，原本以为二三线城市的人才是朋友圈购物主力军，没想到一线城市才是大部队集结地。</p><p style="text-align:center;"><img id="68437539" src="https://www.phpok.com/res/202001/02/071c9d1d690cf9bb_9_2.png" title="90后和00后代沟有多大？苏宁推客大数据告诉你" alt="90后和00后代沟有多大？苏宁推客大数据告诉你"/></p><p>那么为什么无论男女、不限地域，大家都乐于在朋友圈购物呢?毕竟它不是一个为了“购物”而产生的平台。</p><p>我那偷偷藏私房钱的爹给了我三个答案。一是需求：我确实需要这样东西，看不见的时候我想不起来，看到朋友圈有人发我就想起来了。二是信任：我信任我朋友圈里的人，相信他不会骗我。三是人情：朋友圈里有很多我的亲朋好友，为了照顾他们的生意。</p><p>这么一听是不是就恍然大悟了?当零售跟社交结合起来，蕴含的能量是无限大的，任何人都可以成为一个“零售商”。2019年，国人的网购习惯依然与传统人情挂上了钩。</p><p>而说到人情，即将到来的春节才是“人情”高发段。为了满足国人的消费习惯，苏宁2020年货节已经全面启动，年货节期间，各品类品牌商将苏宁平台锁定为新品首发渠道，并专门为苏宁用户定制的专属商品，还有汽车、厨电等新品也将陆续登陆苏宁平台。（一鸣）</p><p><br/></p>', '2019年已经结束，年终总结愁到人头秃。效率惊人的苏宁率先发布了年终大数据报告，唤醒了“社畜们”难得的好奇心。', 0, 'https://tech.gmw.cn/2020-01/02/content_33449331.htm', '光明网'),
(16, 1, 43, 68, 76, '<p style="text-align:center;"><img src="res/_cache/auto/76/76.jpg" title="图片" alt="图片"/></p><p>近两年，百度、腾讯、快手、爱奇艺、B站等巨头、先行者在知识领域的动作不约而同。</p><p>2019年12月12日，百度知识垂类总经理阮瑜在“2019百度知识峰会”上披露：百度知识内容日均搜索量已达到15.4亿次，百度知识垂类产品每天服务用户突破2.3亿，用户日均浏览总时长超过6.3亿分钟。</p><p>几乎同一时段，快手宣称其平台上的知识作品数量超过1.2亿，平均每秒诞生4个知识内容，平均每个作品获得一万多播放曝光。</p><p>除此之外，爱奇艺、腾讯视频、优酷等纷纷上线知识频道，入局知识付费，更不用提B站摇身一变成为“一家神奇的学习网站”了。今年4月，B站公布了一组数据：过去一年有近2000万人在B站学习，相当于2018年高考人数的两倍。</p><p>不久前，腾讯在ConTech技术大会上发布了内容产业趋势报告，其中提及，近4成用户反映，他们开始关心知识技能方面的内容。在用户挑选资讯内容的影响因素排名中，可以涨知识也超过了内容有趣。</p><p>字节跳动副总裁张羽提到，人类的文明史就是知识的普及史。搜狗CTO杨洪涛认为，搜索的未来会走向专业化和服务化，掌握知识和完成服务一定是搜索整个领域未来发展的方向。</p><p>以上动作和言论反映出背后知识形态的趋势变化：过去，知识是静态、独立、客观、集中的，是复刻现实的照片；如今，知识是动态、共创、主观、分散的，是自主生长的生命体。</p><p>知识形态的变化，加之近几年罗振宇等人对知识服务进行的大规模宣贯，知识的价值得以被重新彰显，“与知识共生共长”被巨头平台们重视起来。</p><p>“碎片化知识”更有价值？</p><p>互联网改变了知识本身，即便知识被网络碾压得支离破碎，它们的好处也十分突出。这是最真实的知识形态——达尔文写作《物种起源》时，已经尽最大可能设想了各种意见，甚至模拟了无数假想敌，但一本书终究辩论不完，总有些人的意见不能被写入。</p><p>一本已然封禁了知识的书可以成为经典，但无法做到与时俱进。</p><p>书还有另外一种写法，就是开放，就是不写完。</p><p>相对封装好的书本知识，互联网知识其实更容易用来存放，它们可以不断更新迭代，永远生猛鲜活。</p><p>得到APP讲师万维钢曾说：“互联网时代，我们根本没必要把东西‘写完’。你应该只写下你认为这次应该写的，然后让这个文本保持开放状态，让读者添加评论和内容。”</p><p>这种现代人创造和使用知识的方法，其实早就有了实现方式，即众所周知的——使用搜索引擎。或者说，如果搜索如此方便，人们完全可以在任何地方写下自己最新发现的知识。</p><p style="text-align:center;"><img id="68428596" alt="巨头为什么一齐瞄准知识领域？" src="https://www.phpok.com/res/202001/02/5cd982af5e87fa59_29_1.png" title="巨头为什么一齐瞄准知识领域？"/></p><p>的确，互联网甚至是更具象的搜索引擎，为知识创造了适宜的生长环境。新的语境下，原本为少数精英分子所掌握的知识壁垒被打破，普通民众可以随时释放自己在生产生活中的客观智慧。</p><p>同时，因为群体的复杂力量交织、汇聚、共振，知识灵感不再是单点突破，而可以借助一整套发生范式——群众的力量是无穷的，因此孕育了知识的喷薄而生。</p><p>在“把知识生产权交予用户”的逻辑下，一些头部视频平台正向视频形式的“喜马拉雅FM”靠拢。这正是快手、爱奇艺、腾讯视频、优酷、B站等视频、短视频平台押注知识领域的重要原因。</p><p>腾讯副总裁陈菊红曾提到：“如果我们把中国3.2亿有涨知识需求的用户拿出来看，他们主要需求在哪里？日常生活技巧占第1位。接下来是健康生活、百科养生、疾病防控。第3位是文化知识、文学历史和社会常识，也是非常高的比例。”</p><p>搜索引擎与这些信息、知识有更天然的连接属性，以百度为例，其历经15年的沉淀，形成了更浩如烟海的知识海洋。</p><p>巨大的数据背后是每位网民逐条的生成、编辑和互动累积：百度在知道、百科、文库等方面积累了远超10亿的知识内容。因此，百度百科成为了全球最大的中文百科全书，拥有1600万个词条；百度知道成为了全球最大的互动问答平台，累积问答数达到5.5亿；百度文库的文档数也已超6亿。</p><p>这些知识内容铸成极深的护城河，帮助百度成为了中国最大的以信息和知识为核心的移动生态。</p><p>搜索引擎有什么“知识优势”？</p><p>类似百度这样的搜索引擎中数量庞大的知识优势，实际上早已为我们的大脑赋能。</p><p>学生时代，我们需要把知识存在脑子里，记忆力好的同学更容易拥有更多知识，通常能够外化为一个好成绩。现在，只要能在搜索引擎查询到的，都是体外知识，人人都能进行使用和管理。</p><p style="text-align:center;"><img id="68428597" alt="巨头为什么一齐瞄准知识领域？" src="https://www.phpok.com/res/202001/02/cb5c11751add7491_59_2.png" title="巨头为什么一齐瞄准知识领域？"/></p><p>培根有句名言“Knowledge is power”，被翻译为“知识就是力量”，但power不只有“力量”的含义，在那个年代，还代表着“权力”。</p><p>知识是驱动社会发展的前进力量，掌握知识的人自然也掌握着社会的权力。</p><p>这一概念后来演变为“知识鸿沟”。美国明尼苏达大学传播学者蒂奇纳等人最早提出了“知识鸿沟假说”，点明经济地位高者通常能比社会经济地位低者更快地获得信息。</p><p>以国内高考为例，尽管通过单纯的成绩选拔已将各地区差异降低到最小，但国际学校双语教学的富二代和十几年没出过村落的孩子仍然有着明显的知识差异。两者接触的师资力量和书籍资料完全不同，由此引申的个体认知也在不断扩大差距。</p><p>这样的知识鸿沟该如何解决？</p><p>美国政府曾做过尝试：20世纪六十年代推出了益智电视节目《芝麻街》，节目不断向孩子传递知识，最终的结果却是，知识鸿沟不仅没有消失，反而日益扩大。因为贫穷的孩子根本无法接触这档节目，换言之，观看《芝麻街》的都是经济条件不错的孩子，对他们做再多的教育，也无法带来知识平等。</p><p>长辈们总会讲这样的故事，因为小时候条件不好，无书可读，他们只能把亲戚朋友家的书借空，但读完之后，也就无可奈何地陷入书荒。</p><p>图书馆是奢侈的，“如饥似渴，得了文学胃炎症”的作家木心就因此前所著书稿和相关资料被悉数烧毁，讲课时又没有课本，只能全凭记忆讲述。所幸，他的记忆力远超常人，文艺课开起来后，一讲就是五年，记录的讲义形成了厚重的五本，最终成就了著名的《文学回忆录》。</p><p>木心这记忆力常人难以企及，我们的资料烧了也就烧了，哪有什么补救措施。</p><p>但属于这一代人的幸运是，即便资料烧毁，丢失记忆，我们也还有互联网。</p><p>如今，摆在课堂桌角的那本新华字典消失不见，取而代之的是离开学校也不会丢失的知识——太阳半径是6.955*10^5千米，雅鲁藏布江是中国最长的高原河流，重力加速度的数值是9.8，1785年瓦特制成的改良型蒸汽机投入使用……这些知识我们随时可以通过互联网查到。</p><p>二十年时间，因为互联网的发展普及，知识获取方式经历了波折的颠覆性变革。</p><p>1996年，搜狐定位于网络信息分类导航网站，提出“出门找地图，上网找搜狐”的说法，一些知识信息开始进入网络。</p><p>但是，知识日益爆发式增长的现状和人们快速准确获取知识的需求之间的矛盾，使得搜狐人工信息分类的局限性逐渐暴露，搜索引擎root自动抓取、智能分类成了替代。</p><p>2000年，中文搜索引擎百度面世，从最初的千万页索引内容（约等于一个小型图书馆），到如今百度阳泉数据中心成为亚洲单体规模最大的数据中心，用了20年时间。</p><p>20年后的今天，百度阳泉数据中心已投产12万平方米，上线服务器超过15万台，超过300万个CPU核，存储容量超过6EB，可存储信息量相当于30多万个中国国家图书馆的藏书总量。</p><p style="text-align:center;"><img id="68428598" alt="巨头为什么一齐瞄准知识领域？" src="https://www.phpok.com/res/202001/02/378edb22bf93184c_76_3.png" title="巨头为什么一齐瞄准知识领域？"/></p><p>知识的获取方式发生了翻天覆地的变化，我们再也不用专程赶赴图书馆或购买众多书籍来完成知识的提取，原本耗时耗力还耗钱的过程被免费简便易用的“百度一下”取代，信息鸿沟被逐渐踏平。</p><p>现在无论你身处何地，只要能联网，就能获取与更高阶层完全相同的知识，这在20年前完全不可想象，而这正是属于具备海量知识信息搜索引擎的独特知识优势。</p><p>知识领域为什么被巨头盯上？</p><p>作为硬通货的知识和技能被巨头平台们看上，有着共同的理由——知识网络是牢不可破的刚需城墙，不仅能带来知识平权的社会价值，还能铸造商业价值的护城河。</p><p>相比娱乐性内容基础上，用户眼球的迅速转移，知识内容的稳定力量不容小觑。</p><p>经过一些人的所思所想总结而来、未经过时间考验、不具备普适性的东西是不严谨的，更适合被称作包裹有娱乐、主观外壳的“见识”。</p><p>几年前，人们曾是“见识”疯狂的拥趸。</p><p>网友曾花费5000元在网络平台问王思聪问题，王思聪只用简单的几个字就将其收入囊中。人们愿意为自己的好奇和王思聪所在阶层的见识买单。</p><p>王思聪的见识不一定正确，他说：9012年，难道还有人没坐过飞机？这就与真正的知识相悖：截至目前，中国其实还有10亿人没坐过飞机。</p><p><br/></p>', '近两年，百度、腾讯、快手、爱奇艺、B站等巨头、先行者在知识领域的动作不约而同。\r\n2019年12月12日，百度知识垂类总经理阮瑜在“2019百度知识峰会”上披露：百度知识内容日均搜索量已达到15.4亿次，百度知识垂类产品每天服务用户突破2.3亿，用户日均浏览总时长超过6.3亿分钟。', 0, 'https://tech.gmw.cn/2019-12/30/content_33440672.htm', '光明网'),
(17, 1, 43, 68, 0, '<p>什么是服务器并发处理能力</p>\r\n\r\n<p>[download:167]image-20210511235823-1[/download]</p>\r\n\r\n<p>[download:166]image-20210511223552-1[/download]</p>\r\n\r\n<p>[download:165]008[/download]</p>\r\n\r\n<p>一台服务器在单位时间里能处理的请求越多，服务器的能力越高，也就是服务器并发处理能力越强<iframe align="right" frameborder="0" height="362px" scrolling="no" src="static/ckeditor/plugins/baidumap/index.html?center=121.5013%2C31.1612&amp;zoom=11&amp;width=558&amp;height=360&amp;markers=121.5013%2C31.1612&amp;markerStyles=l%2CA" style="width:560px;height:362px;" width="560px"></iframe></p>\r\n\r\n<p>有什么方法衡量服务器并发处理能力</p>\r\n\r\n<h3>1. 吞吐率<!--?php\r\necho "123456";</pre--></h3>\r\n\r\n<p>吞吐率，单位时间里服务器处理的最大请求数，单位req/s</p>\r\n\r\n<p>从服务器角度，实际并发用户数的可以理解为服务器当前维护的代表不同用户的文件描述符总数，也就是并发连接数。</p>\r\n\r\n<p>服务器一般会限制同时服务的最多用户数，比如apache的MaxClents参数。</p>\r\n\r\n<p>这里再深入一下，对于服务器来说，服务器希望支持高吞吐率，对于用户来说，用户只希望等待最少的时间，显然，双方不能满足，所以双方利益的平衡点，就是我们希望的最大并发用户数。</p>\r\n\r\n<p>2. 压力测试</p>\r\n\r\n<pre>\r\n<!--?php\r\necho "123456";</code--></pre>\r\n\r\n<p>有一个原理一定要先搞清楚，假如100个用户同时向服务器分别进行10个请求，与1个用户向服务器连续进行1000次请求，对服务器的压力是一样吗？</p>\r\n\r\n<p>实际上是不一样的，因对每一个用户，连续发送请求实际上是指发送一个请求并接收到响应数据后再发送下一个请求。</p>\r\n\r\n<p>这样对于1个用户向服务器连续进行1000次请求, 任何时刻服务器的网卡接收缓冲区中只有1个请求，而对于100个用户同时向服务器分别进行10个请求，服务器的网卡接收缓冲区最多有100个等待处理的请求，显然这时的服务器压力更大。</p>\r\n\r\n<p>压力测试前提考虑的条件</p>\r\n\r\n<ul>\r\n	<li>\r\n	<p>并发用户数: 指在某一时刻同时向服务器发送请求的用户总数(HttpWatch)</p>\r\n	</li>\r\n	<li>\r\n	<p>总请求数</p>\r\n	</li>\r\n	<li>\r\n	<p>请求资源描述</p>\r\n	</li>\r\n	<li>\r\n	<p>请求等待时间(用户等待时间)</p>\r\n	</li>\r\n	<li>\r\n	<p>用户平均请求的等待时间</p>\r\n	</li>\r\n	<li>\r\n	<p>服务器平均请求处理的时间</p>\r\n	</li>\r\n	<li>\r\n	<p>硬件环境</p>\r\n	</li>\r\n</ul>\r\n\r\n<p>压力测试中关心的时间又细分以下2种:</p>\r\n\r\n<ol>\r\n	<li>\r\n	<p>用户平均请求等待时间（这里暂不把数据在网络的传输时间，还有用户PC本地的计算时间计算入内）</p>\r\n	</li>\r\n	<li>\r\n	<p>服务器平均请求处理时间</p>\r\n	</li>\r\n</ol>\r\n\r\n<p>用户平均请求等待时间主要用于衡量服务器在一定并发用户数下，单个用户的服务质量；而服务器平均请求处理时间就是吞吐率的倒数。</p>\r\n\r\n<p>一般来说，用户平均请求等待时间 = 服务器平均请求处理时间 * 并发用户数</p>\r\n\r\n<p>怎么提高服务器的并发处理能力</p>\r\n\r\n<p>1. 提高CPU并发计算能力</p>\r\n\r\n<p>服务器之所以可以同时处理多个请求，在于操作系统通过多执行流体系设计使得多个任务可以轮流使用系统资源。<br />\r\n这些资源包括CPU，内存以及I/O. 这里的I/O主要指磁盘I/O, 和网络I/O。</p>\r\n\r\n<p>多进程 &amp; 多线程</p>\r\n\r\n<p>多执行流的一般实现便是进程，多进程的好处可以对CPU时间的轮流使用，对CPU计算和IO操作重叠利用。这里的IO主要是指磁盘IO和网络IO，相对CPU而言，它们慢的可怜。</p>\r\n\r\n<p>而实际上，大多数进程的时间主要消耗在I/O操作上。</p>\r\n\r\n<p>现代计算机的DMA技术可以让CPU不参与I/O操作的全过程，比如进程通过系统调用，使得CPU向网卡或者磁盘等I/O设备发出指令，然后进程被挂起，释放出CPU资源，等待I/O设备完成工作后通过中断来通知进程重新就绪。</p>\r\n\r\n<p>对于单任务而言，CPU大部分时间空闲，这时候多进程的作用尤为重要。CPU 是怎么认识代码的？推荐大家看下。</p>\r\n\r\n<p>多进程不仅能够提高CPU的并发度。其优越性还体现在独立的内存地址空间和生命周期所带来的稳定性和健壮性，其中一个进程崩溃不会影响到另一个进程。<br />\r\n但是进程也有如下缺点：</p>\r\n\r\n<ol>\r\n	<li>\r\n	<p>fork()系统调用开销很大: prefork</p>\r\n	</li>\r\n	<li>\r\n	<p>进程间调度和上下文切换成本: 减少进程数量</p>\r\n	</li>\r\n	<li>\r\n	<p>庞大的内存重复：共享内存</p>\r\n	</li>\r\n	<li>\r\n	<p>IPC编程相对比较麻烦</p>\r\n	</li>\r\n</ol>\r\n\r\n<p>减少进程切换</p>\r\n\r\n<p>当硬件上下文频繁装入和移出时，所消耗的时间是非常可观的。可用Nmon工具监视服务器每秒的上下文切换次数。</p>\r\n\r\n<p>为了尽量减少上下文切换次数，最简单的做法就是减少进程数，尽量使用线程并配合其它I/O模型来设计并发策略。</p>\r\n\r\n<p>还可以考虑使用进程绑定CPU技术，增加CPU缓存的命中率。若进程不断在各CPU上切换，这样旧的CPU缓存就会失效。</p>\r\n\r\n<p>减少使用不必要的锁</p>\r\n\r\n<p>服务器处理大量并发请求时，多个请求处理任务时存在一些资源抢占竞争，这时一般采用&ldquo;锁&rdquo;机制来控制资源的占用。到底什么是重入锁，推荐大家看下。</p>\r\n\r\n<p>当一个任务占用资源时，我们锁住资源，这时其它任务都在等待锁的释放，这个现象称为锁竞争。</p>\r\n\r\n<p>通过锁竞争的本质，我们要意识到尽量减少并发请求对于共享资源的竞争。</p>\r\n\r\n<p>比如在允许情况下关闭服务器访问日志，这可以大大减少在锁等待时的延迟时间。要最大程度减少无辜的等待时间。</p>\r\n\r\n<p>这里说下无锁编程，就是由内核完成这个锁机制，主要是使用原子操作替代锁来实现对共享资源的访问保护。</p>\r\n\r\n<p>使用原子操作时，在进行实际的写操作时，使用了lock指令，这样就可以阻止其他任务写这块内存，避免出现数据竞争现象。原子操作速度比锁快，一般要快一倍以上。</p>\r\n\r\n<p>例如fwrite(), fopen()，其是使用append方式写文件，其原理就是使用了无锁编程，无锁编程的复杂度高，但是效率快，而且发生死锁概率低。</p>\r\n\r\n<p>考虑进程优先级</p>\r\n\r\n<p>进程调度器会动态调整运行队列中进程的优先级，通过top观察进程的PR值</p>\r\n\r\n<p>考虑系统负载</p>\r\n\r\n<p>可在任何时刻查看/proc/loadavg, top中的load average也可看出</p>\r\n\r\n<p>考虑CPU使用率</p>\r\n\r\n<p>除了用户空间和内核空间的CPU使用率以外，还要关注I/O wait,它是指CPU空闲并且等待I/O操作完成的时间比例（top中查看wa的值）。</p>\r\n\r\n<p>2. 考虑减少内存分配和释放</p>\r\n\r\n<p>服务器的工作过程中，需要大量的内存，使得内存的分配和释放工作尤为重要。</p>\r\n\r\n<p>可以通过改善数据结构和算法复制度来适当减少中间临时变量的内存分配及数据复制时间，而服务器本身也使用了各自的策略来提高效率。</p>\r\n\r\n<p>例如Apache,在运行开始时一次申请大片的内存作为内存池，若随后需要时就在内存池中直接获取，不需要再次分配，避免了频繁的内存分配和释放引起的内存整理时间。</p>\r\n\r\n<p>再如Nginx使用多线程来处理请求，使得多个线程之间可以共享内存资源，从而令它的内存总体使用量大大减少。</p>\r\n\r\n<p>另外，Nginx分阶段的内存分配策略，按需分配，及时释放，使得内存使用量保持在很小的数量范围。</p>\r\n\r\n<p>另外，还可以考虑共享内存。</p>\r\n\r\n<p>共享内存指在多处理器的计算机系统中，可以被不同中央处理器（CPU）访问的大容量内存，也可以由不同进程共享，是非常快的进程通信方式。</p>\r\n\r\n<p>但是使用共享内存也有不好的地方，就是对于多机器时数据不好统一。</p>\r\n\r\n<p>shell命令ipcs可用来显示系统下共享内存的状态，函数shmget可以创建或打开一块共享内存区，函数shmat将一个存在的共享内存段连接到本进程空间, 函数shmctl可以对共享内存段进行多种操作，函数shmdt函数分离该共享内存。</p>\r\n\r\n<p>3. 考虑使用持久连接</p>\r\n\r\n<p>持久连接也为长连接，它本身是TCP通信的一种普通方式，即在一次TCP连接中持续发送多分数据而不断开连接。</p>\r\n\r\n<p>与它相反的方式称为短连接，也就是建立连接后发送一份数据就断开，然后再次建立连接发送下一份数据， 周而复始。</p>\r\n\r\n<p>是否采用持久连接，完全取决于应用特点。</p>\r\n\r\n<p>从性能角度看，建立TCP连接的操作本身是一项不小的开销，在允许的情况下，连接次数越少，越有利于性能的提升; 尤其对于密集型的图片或网页等小数据请求处理有明显的加速所用。</p>\r\n\r\n<p>HTTP长连接需要浏览器和web服务器的共同协作，目前浏览器普遍支持长连接，表现在其发出的HTTP请求数据头中包含关于长连接的声明，如下：Connection: Keep-Alive</p>\r\n\r\n<p>主流的web服务器都支持长连接，比如apache中，可以用KeepAlive off关闭长连接。</p>\r\n\r\n<p>对于长连接的有效使用，还有关键一点在于长连接超时时间的设置，即长连接在什么时候关闭吗？</p>\r\n\r\n<p>Apache的默认设置为5s, 若这个时间设置过长，则可能导致资源无效占有，维持大量空闲进程，影响服务器性能。</p>\r\n\r\n<p>4. 改进I/O 模型</p>\r\n\r\n<p>I/O操作根据设备的不同分为很多类型，比如内存I/O, 网络I/O, 磁盘I/O。详解 Java 中 4 种 I/O 模型，推荐大家看下。</p>\r\n\r\n<p>对于网络I/O和磁盘I/O, 它们的速度要慢很多，尽管使用RAID磁盘阵列可通过并行磁盘磁盘来加快磁盘I/O速度，购买大连独享网络带宽以及使用高带宽网络适配器可以提高网络I/O的速度。</p>\r\n\r\n<p>但这些I/O操作需要内核系统调用来完成，这些需要CPU来调度，这使得CPU不得不浪费宝贵的时间来等待慢速I/O操作。</p>\r\n\r\n<p>我们希望让CPU足够少的时间在i/O操作的调度上，如何让高速的CPU和慢速的I/O设备更好地协调工作，是现代计算机一直探讨的话题。各种I/O模型的本质区别在于CPU的参与方式。</p>\r\n\r\n<p>DMA技术</p>\r\n\r\n<p>I/O设备和内存之间的数据传输方式由DMA控制器完成。在DMA模式下，CPU只需向DMA下达命令，让DMA控制器来处理数据的传送，这样可以大大节省系统资源。</p>\r\n\r\n<p>异步I/O</p>\r\n\r\n<p>异步I/O指主动请求数据后便可以继续处理其它任务，随后等待I/O操作的通知，这样进程在数据读写时不发生阻塞。</p>\r\n\r\n<p>异步I/O是非阻塞的，当函数返回时，真正的I/O传输已经完成，这让CPU处理和I/O操作达到很好的重叠。</p>\r\n\r\n<p>I/O多路复用</p>\r\n\r\n<p>epoll服务器同时处理大量的文件描述符是必不可少的，若采用同步非阻塞I/O模型，若同时接收TCP连接的数据，就必须轮流对每个socket调用接收数据的方法，不管这些socket有没有可接收的数据，都要询问一次。</p>\r\n\r\n<p>假如大部分socket并没有数据可以接收，那么进程便会浪费很多CPU时间用于检查这些socket有没有可以接收的数据。</p>\r\n\r\n<p>多路I/O就绪通知的出现，提供了对大量文件描述符就绪检查的高性能方案，它允许进程通过一种方法同时监视所有文件描述符，并可以快速获得所有就绪的文件描述符，然后只针对这些文件描述符进行数据访问。</p>\r\n\r\n<p>epoll可以同时支持水平触发和边缘触发，理论上边缘触发性能更高，但是代码实现复杂，因为任何意外的丢失事件都会造成请求处理错误。</p>\r\n\r\n<p>epoll主要有2大改进：</p>\r\n\r\n<ol>\r\n	<li>\r\n	<p>epoll只告知就绪的文件描述符，而且当调用epoll_wait()获得文件描述符时，返回并不是实际的描述符，而是一个代表就绪描述符数量的值，然后只需去epoll指定的一个数组中依次取得相应数量的文件描述符即可。这里使用了内存映射(mmap)技术，这样彻底省掉了这些文件描述符在系统调用时复制的开销。</p>\r\n	</li>\r\n	<li>\r\n	<p>epoll采用基于事件的就绪通知方式。其事先通过epoll_ctrl()注册每一个文件描述符，一旦某个文件描述符就绪时，内核会采用类似callback的回调机制，当进程调用epoll_wait()时得到通知</p>\r\n	</li>\r\n</ol>\r\n\r\n<p>关于IO模型，可以参考笔者前面写的相关文章Java NIO.2；关于epoll，可以参考笔者前面写的文章select、poll和epoll简介。</p>\r\n\r\n<p>Sendfile</p>\r\n\r\n<p>大多数时候，我们都向服务器请求静态文件，比如图片，样式表等。<br />\r\n在处理这些请求时，磁盘文件的数据先经过内核缓冲区，然后到用户内存空间，不需经过任何处理，其又被送到网卡对应的内核缓冲区，接着再被送入网卡进行发送。</p>\r\n\r\n<p>Linux提供sendfile()系统调用，可以讲磁盘文件的特定部分直接传送到代表客户端的socket描述符，加快了静态文件的请求速度，同时减少CPU和内存的开销。<br />\r\n适用场景：对于请求较小的静态文件，sendfile发挥的作用不那么明显，因发送数据的环节在整个过程中所占时间的比例相比于大文件请求时小很多。</p>\r\n\r\n<p>内存映射</p>\r\n\r\n<p>Linux内核提供一种访问磁盘文件的特殊方式，它可以将内存中某块地址空间和我们指定的磁盘文件相关联，从而对这块内存的访问转换为对磁盘文件的访问。这种技术称为内存映射。</p>\r\n\r\n<p>多数情况下，内存映射可以提高磁盘I/O的性能，无须使用read()或write()等系统调用来访问文件，而是通过mmap()系统调用来建立内存和磁盘文件的关联，然后像访问内存一样自由访问文件。</p>\r\n\r\n<p>缺点：在处理较大文件时，内存映射会导致较大的内存开销，得不偿失。</p>\r\n\r\n<p>直接I/O</p>\r\n\r\n<p>在linux 2.6中，内存映射和直接访问文件没有本质差异，因为数据需要经过2次复制，即在磁盘与内核缓冲区之间以及在内核缓冲区与用户态内存空间。</p>\r\n\r\n<p>引入内核缓冲区的目的在于提高磁盘文件的访问性能，然而对于一些复杂的应用，比如数据库服务器，它们为了进一步提高性能，希望绕过内核缓冲区，由自己在用户态空间实现并管理I/O缓冲区，比如数据库可根据更加合理的策略来提高查询缓存命中率。</p>\r\n\r\n<p>另一方面，绕过内核缓冲区也可以减少系统内存的开销，因内核缓冲区本身就在使用系统内存。</p>\r\n\r\n<p>Linux在open()系统调用中增加参数选项O_DIRECT,即可绕过内核缓冲区直接访问文件,实现直接I/O。</p>\r\n\r\n<p>在Mysql中，对于Innodb存储引擎，自身进行数据和索引的缓存管理，可在my.cnf配置中分配raw分区跳过内核缓冲区，实现直接I/O。</p>\r\n\r\n<p>5. 改进服务器并发策略</p>\r\n\r\n<p>服务器并发策略的目的，是让I/O操作和CPU计算尽量重叠进行，一方面让CPU在I/O等待时不要空闲，另一方面让CPU在I/O调度上尽量花最少的时间。</p>\r\n\r\n<p>一个进程处理一个连接，非阻塞I/O</p>\r\n\r\n<p>这样会存在多个并发请求同时到达时，服务器必然要准备多个进程来处理请求。其进程的开销限制了它的并发连接数。</p>\r\n\r\n<p>但从稳定性和兼容性的角度，则其相对安全，任何一个子进程的崩溃不会影响服务器本身，父进程可以创建新的子进程；这种策略典型的例子就是Apache的fork和prefork模式。</p>\r\n\r\n<p>对于并发数不高（如150以内）的站点同时依赖Apache其它功能时的应用选择Apache还是可以的。</p>\r\n\r\n<p>一个线程处理一个连接，非阻塞IO</p>\r\n\r\n<p>这种方式允许在一个进程中通过多个线程来处理多个连接，一个线程处理一个连接。Apache的worker模式就是这种典型例子，使其可支持更多的并发连接。不过这种模式的总体性能还不如prefork，所以一般不选用worker模式。推荐阅读：14个Java并发容器。</p>\r\n\r\n<p>一个进程处理多个连接，异步I/O</p>\r\n\r\n<p>一个线程同时处理多个连接，潜在的前提条件就是使用IO多路复用就绪通知。</p>\r\n\r\n<p>这种情况下，将处理多个连接的进程叫做worker进程或服务进程。worker的数量可以配置，如Nginx中的worker_processes 4。</p>\r\n\r\n<p>一个线程处理多个连接，异步IO</p>\r\n\r\n<p>即使有高性能的IO多路复用就绪通知，但磁盘IO的等待还是无法避免的。更加高效的方法是对磁盘文件使用异步IO，目前很少有Web服务器真正意义上支持这种异步IO。</p>\r\n\r\n<p>6. 改进硬件环境</p>\r\n\r\n<p>还有一点要提及的是硬件环境，服务器的硬件配置对应用程序的性能提升往往是最直接，也是最简单的方式，这就是所谓的scale up。这里不做论述。</p>\r\n\r\n<p>&nbsp;</p>\r\n', '一台服务器在单位时间里能处理的请求越多，服务器的能力越高，也就是服务器并发处理能力越强', 0, 'http://www.itpub.net/2020/02/13/5225/', 'ITPUB'),
(2262, 1, 43, 8, 0, '<p>测试下~</p>\r\n\r\n<p>&nbsp;</p>\r\n', '', 0, '', '');

CREATE TABLE IF NOT EXISTS `qinggan_list_24` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `pictures` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `content` longtext NOT NULL COMMENT '内容',
  `subtitle` varchar(255) NOT NULL DEFAULT '' COMMENT '子标题',
  `contentpics` varchar(255) NOT NULL DEFAULT '' COMMENT '内容图片',
  `package` longtext NOT NULL COMMENT '产品包装',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品';

INSERT INTO `qinggan_list_24` (`id`, `site_id`, `project_id`, `cate_id`, `pictures`, `thumb`, `content`, `subtitle`, `contentpics`, `package`) VALUES
(4, 1, 45, 583, '', '74', '', '三星8895处理器 2000万暗光双摄', '', ''),
(6, 1, 45, 584, '', '29', '', '4800万全焦段AI四摄 麒麟980全网通版8GB+128GB 蓝水翡翠', '', ''),
(7, 1, 45, 582, '', '75', '<p>5000mAh长循环大电量</p><p>6.53&quot;超大护眼屏幕</p><p>G25八核处理器</p><p>大音量扬声器</p><p>1300万 AI相机</p><p>人脸解锁</p><p>最高支持512GB存储扩展</p>', '5000mAh长循环大电量 / 6.53&quot;超大护眼屏幕 / G25八核处理器 / 大音量扬声器 / 1300万 AI相机 / 人脸解锁 / 最高支持512GB存储扩展', '', ''),
(9, 1, 45, 701, '', '47', '<p><img src="res/_cache/auto/54/54.jpg" title="小程序码" alt="小程序码"/></p>', '', '', ''),
(10, 1, 45, 701, '48,49,50,51,52', '48', '<p><img src="res/_cache/auto/54/54.jpg" title="小程序码" alt="小程序码"/></p>', '', '', 'a:1:{s:5:"title";a:2:{i:0;s:8:"名称\r\n";i:1;s:6:"数量";}}'),
(11, 1, 45, 701, '', '55', '', '', '', 'a:2:{s:5:"title";a:2:{i:0;s:8:"名称\r\n";i:1;s:6:"数量";}s:7:"content";a:2:{i:0;a:2:{i:0;s:3:"花";i:1;s:5:"10支";}i:1;a:2:{i:0;s:6:"蓝子";i:1;s:4:"1个";}}}');

CREATE TABLE IF NOT EXISTS `qinggan_list_40` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `content` longtext NOT NULL COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='关于我们';

INSERT INTO `qinggan_list_40` (`id`, `site_id`, `project_id`, `cate_id`, `content`) VALUES
(18, 1, 87, 0, '<p>深圳市锟铻科技有限公司（简称<strong>锟铻科技</strong>）是一家从事 互联网+ 规划、咨询、开发及运营的综合服务商，致力于互联网市场的探索与研究，推动企业电子商务转型发展。<strong><br/></strong></p><p><strong>互联网+ 强大企业</strong></p><p>专注企业\r\n 互联网+ 发展，将互联网思维植入传统企业，帮 助企业搭建属于自己的互联网经营平台，引领商业新生态 \r\n的变革，帮助企业做大做强。我们为每个客户提供专业化 和定制化的互联网+方案，坚持以客户需求为导向，竭力 \r\n为客户带来最大的商业价值。相信我们是您值得信赖的合作伙伴！</p><p><strong>一体化服务</strong></p><p>整体设计 我们为企业提供“品牌包装、网站建设、运营推广”一体 化整体设计，并运用新的思想，新的技术，帮助企业实现二次腾飞。专业的技术力量及丰富的运营经验深受广大客 户的认可。</p><p><strong>价值观</strong></p><p>有偿服务，利人利己 无私开源，共同发展</p><p><strong>目标</strong></p><p>助力客户成就梦想 完善自我，更上一层楼</p>'),
(19, 1, 87, 0, '<table width="100%"><tbody><tr class="firstRow"><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2020年05月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK5.5发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2019年12月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK5.4发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2019年10月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">OKLite2.0发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2019年08月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK5.3发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2019年03月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK5.2发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2019年01月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK5.1发布<br/></td></tr><tr><td valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2018年11月</strong></td><td valign="middle" align="left">PHPOK5.0发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2018年05月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.9发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2018年01月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">OKLite1.2发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2017年10月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.8发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2017年03月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.7发布<br/></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="text-align: -webkit-right; white-space: normal; color: rgb(153, 0, 0);">2016年10月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.6发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="color: rgb(153, 0, 0); text-align: -webkit-right; white-space: normal;">2016年04月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.5发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><strong style="color: rgb(153, 0, 0); text-align: -webkit-right; white-space: normal;">2016年01月</strong></td><td colspan="1" rowspan="1" valign="middle" align="left">OKLite1.1发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><span style="color: rgb(153, 0, 0);"><strong>2015年10月</strong></span></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.4发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><span style="color: rgb(153, 0, 0); font-weight: bold; text-align: -webkit-right;">2015年06月</span></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK4.3发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><span style="color: rgb(153, 0, 0); font-weight: bold; text-align: -webkit-right;">2015年03月</span></td><td colspan="1" rowspan="1" valign="middle" align="left">PHPOK手册新鲜出炉</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><span style="color: rgb(153, 0, 0); font-weight: bold; text-align: -webkit-right;">2014年10月</span></td><td colspan="1" rowspan="1">PHPOK4.2发布并成立公司<strong>深圳市锟铻科技有限公司</strong></td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><span style="color: rgb(153, 0, 0); font-weight: bold; text-align: -webkit-right;">2014年08月</span></td><td colspan="1" rowspan="1">PHPOK4.1发布</td></tr><tr><td colspan="1" rowspan="1" valign="middle" align="right"><span style="color: rgb(153, 0, 0); font-weight: bold; text-align: -webkit-right;">2014年01月</span></td><td colspan="1" rowspan="1">PHPOK4.0发布<br/></td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2011年12月</span></td><td>PHPOK3.4版发布（后台更换为桌面式）</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2011年09月</span></td><td>phpok3.3完整版发布</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2010年08月</span></td><td>PHPOK3.0完整版发布</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2008年09月</span></td><td>PHPOK3.0精简版发布</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2008年05月</span></td><td>PHPOK2.2发布（稳定版本）</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2008年03月</span></td><td>PHPOK2.0发布</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2007年05月</span></td><td>qgweb5.2发布，同时更名为：PHPOK1.0.0版！</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2007年01月</span></td><td>qgweb5.0发布（首次实现多语言多风格功能）</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2006年10月</span></td><td>qgweb4.2发布（GBK）</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2006年08月</span></td><td>qgweb4.1发布（UTF）</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2006年08月</span></td><td>团队决定开发进销存管理系统</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2006年06月</span></td><td>qgweb4.0发布</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2005年11月</span></td><td>qgWeb3.0发布（分企业版及个人版）</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2005年08月</span></td><td>工作室论坛开通</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2005年07月</span></td><td>qgWeb1.0发布</td></tr><tr><td valign="middle" align="right"><span style="color: rgb(153, 0, 0);font-weight: bold;">2005年04月</span></td><td>qgWeb0.54版发布</td></tr></tbody></table><p><br/></p>'),
(20, 1, 87, 0, '<div class="content"><p>我们一直在努力提升项目质量及效率，一切的一切都是为客户提供更放心的服务！</p><p><strong>公司</strong>：深圳市锟铻科技有限公司</p><p><strong>电话</strong>：0755-23776246</p><p><strong>邮箱</strong>：admin@phpok.com</p><p><strong>网址</strong>：<a href="https://www.phpok.com" target="_self">www.phpok.com</a></p><p><strong><br/></strong></p><p><strong>办公地址</strong>：广东深圳龙华新区民治大道325号东边商务大楼13层1309室</p><p><strong><span style="line-height: 24px;">地铁</span></strong><span style="line-height: 24px;">：5号线，民治地铁站D出口<span style="line-height: 24px;"></span></span></p><p><strong>公交车（民治小学站）</strong>：302路&nbsp;302区间线&nbsp;316路&nbsp;324路&nbsp;333路&nbsp;334路&nbsp;334路区间线&nbsp;336路&nbsp;339路&nbsp;352路&nbsp;620路&nbsp;621路&nbsp;76路区间线&nbsp;B657路&nbsp;B690路&nbsp;M213路（原787路）&nbsp;M262路&nbsp;M282路&nbsp;M302路&nbsp;M344路&nbsp;M365路&nbsp;M372路&nbsp;M391路&nbsp;M392路&nbsp;高峰专线13号&nbsp;口岸观光线（观光3线）</p></div>');

CREATE TABLE IF NOT EXISTS `qinggan_list_46` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `fullname` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '邮箱',
  `content` longtext NOT NULL COMMENT '内容',
  `adm_reply` longtext NOT NULL COMMENT '管理员回复',
  `pic` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='留言模块';

INSERT INTO `qinggan_list_46` (`id`, `site_id`, `project_id`, `cate_id`, `fullname`, `email`, `content`, `adm_reply`, `pic`) VALUES
(44, 1, 96, 0, '苏工', 'admin@phpok.com', '<p>测试给自己的留言</p>', '<p>测试回复噢！</p>', '');

CREATE TABLE IF NOT EXISTS `qinggan_list_64` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `qq` varchar(255) NOT NULL DEFAULT '' COMMENT '客服QQ',
  `qtype` varchar(255) NOT NULL DEFAULT 'qq' COMMENT '客服类型',
  `weixin` varchar(255) NOT NULL DEFAULT '' COMMENT '微信号',
  `qrcode` varchar(255) NOT NULL DEFAULT '' COMMENT '微信二维码',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='客服';

CREATE TABLE IF NOT EXISTS `qinggan_list_65` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `note` longtext NOT NULL COMMENT '摘要',
  `fsize` varchar(255) NOT NULL DEFAULT '' COMMENT '文件大小',
  `content` longtext NOT NULL COMMENT '内容',
  `version` varchar(255) NOT NULL DEFAULT '' COMMENT '版本',
  `website` varchar(255) NOT NULL DEFAULT '' COMMENT '官方网站',
  `author` varchar(255) NOT NULL DEFAULT '' COMMENT '开发商',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `dfile` varchar(255) NOT NULL DEFAULT '' COMMENT '附件',
  `dlink` varchar(255) NOT NULL DEFAULT '' COMMENT '附件链接',
  `onlyuser` int(11) NOT NULL DEFAULT '0' COMMENT '限制会员可下载',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='资源下载';

INSERT INTO `qinggan_list_65` (`id`, `site_id`, `project_id`, `cate_id`, `note`, `fsize`, `content`, `version`, `website`, `author`, `thumb`, `dfile`, `dlink`, `onlyuser`) VALUES
(45, 1, 151, 198, '测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）测试下载（会员限制）', '100KB', '', '1.0', 'https://www.phpok.com', 'phpok.com', '109', '', '', 1),
(46, 1, 151, 199, '开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载', '120KB', '<p>开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载开放下载</p>', '1.2', 'https://www.phpok.com', 'phpok.com', '', '113', '', 0);

CREATE TABLE IF NOT EXISTS `qinggan_list_66` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `content` longtext NOT NULL COMMENT '内容',
  `toplevel` varchar(255) NOT NULL DEFAULT '0' COMMENT '置顶',
  `pictures` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='论坛BBS';

INSERT INTO `qinggan_list_66` (`id`, `site_id`, `project_id`, `cate_id`, `content`, `toplevel`, `pictures`) VALUES
(37, 1, 152, 204, '<p>测试用的</p>', '0', ''),
(38, 1, 152, 204, '<p>测试2测试2测试2</p>', '0', ''),
(39, 1, 152, 204, '<p>测试3测试3测试3测试3</p>', '', ''),
(48, 1, 152, 204, '<p>测试新贴测试新贴测试新贴</p>', '0', ''),
(49, 1, 152, 204, '<p>再来新的图片再来新的图片再来新的图片再来新的图片</p>\r\n', '0', '158');

CREATE TABLE IF NOT EXISTS `qinggan_list_68` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `pictures` varchar(255) NOT NULL DEFAULT '' COMMENT '图片',
  `content` longtext NOT NULL COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图集相册';

INSERT INTO `qinggan_list_68` (`id`, `site_id`, `project_id`, `cate_id`, `thumb`, `pictures`, `content`) VALUES
(5, 1, 144, 211, '74', '74', '');

CREATE TABLE IF NOT EXISTS `qinggan_list_110` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `banner` varchar(255) NOT NULL DEFAULT '' COMMENT '通栏图片',
  `note` longtext NOT NULL COMMENT '摘要',
  `content` longtext NOT NULL COMMENT '内容',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='独立页' AUTO_INCREMENT=44 ;

INSERT INTO `qinggan_list_110` (`id`, `site_id`, `project_id`, `cate_id`, `banner`, `note`, `content`) VALUES
(41, 1, 451, 0, '', '为了给您提供更准确、更有个性化的服务，本应用会按照本隐私权政策的规定使用和披露您的个人信息。', '<div class="row no-gutters" pre-type="layer" pre-id="ksrxdtdjte" pre-name="content"><div class="col-12" pre-name="content" pre-type="data" pre-id="ksrxdtdjte-0" pre-vtype="editor">	<div pre-type="content"><p>本应用尊重并保护所有使用服务用户的个人隐私权。为了给您提供更准确、更有个性化的服务，本应用会按照本隐私权政策的规定使用和披露您的个人信息。但本应用将以高度的勤勉、审慎义务对待这些信息。除本隐私权政策另有规定外，在未征得您事先许可的情况下，本应用不会将这些信息对外披露或向第三方提供。本应用会不时更新本隐私权政策。 您在同意本应用服务使用协议之时，即视为您已经同意本隐私权政策全部内容。本隐私权政策属于本应用服务使用协议不可分割的一部分。</p><h3>适用范围</h3><ul class=" list-paddingleft-2" style="list-style-type: disc;"><li><p>在您使用本应用网络服务，或访问本应用平台网页时，本应用自动接收并记录的您的浏览器和计算机上的信息，包括但不限于您的IP地址、浏览器的类型、使用的语言、访问日期和时间、软硬件特征信息及您需求的网页记录等数据；</p></li><li><p>本应用通过合法途径从商业伙伴处取得的用户个人数据。</p></li><li><p>您了解并同意，以下信息不适用本隐私权政策：</p></li><ul class=" list-paddingleft-2" style="list-style-type: square;"><li><p>您在使用本应用平台提供的搜索服务时输入的关键字信息；</p></li><li><p>本应用收集到的您在本应用发布的有关信息数据，包括但不限于参与活动、成交信息及评价详情；</p></li><li><p>违反法律规定或违反本应用规则行为及本应用已对您采取的措施。</p></li></ul></ul><h3>信息使用</h3><ul class=" list-paddingleft-2" style="list-style-type: disc;"><li><p>本应用不会向任何无关第三方提供、出售、出租、分享或交易您的个人信息，除非事先得到您的许可，或该第三方和本应用（含本应用关联公司）单独或共同为您提供服务，且在该服务结束后，其将被禁止访问包括其以前能够访问的所有这些资料。</p></li><li><p>本应用亦不允许任何第三方以任何手段收集、编辑、出售或者无偿传播您的个人信息。任何本应用平台用户如从事上述活动，一经发现，本应用有权立即终止与该用户的服务协议。</p></li><li><p>为服务用户的目的，本应用可能通过使用您的个人信息，向您提供您感兴趣的信息，包括但不限于向您发出产品和服务信息，或者与本应用合作伙伴共享信息以便他们向您发送有关其产品和服务的信息（后者需要您的事先同意）。</p></li></ul><h3>信息披露</h3><p>在如下情况下，本应用将依据您的个人意愿或法律的规定全部或部分的披露您的个人信息：</p><ul class=" list-paddingleft-2" style="list-style-type: disc;"><li><p>经您事先同意，向第三方披露；</p></li><li><p>为提供您所要求的产品和服务，而必须和第三方分享您的个人信息；</p></li><li><p>根据法律的有关规定，或者行政或司法机构的要求，向第三方或者行政、司法机构披露；</p></li><li><p>如您出现违反中国有关法律、法规或者本应用服务协议或相关规则的情况，需要向第三方披露；</p></li><li><p>如您是适格的知识产权投诉人并已提起投诉，应被投诉人要求，向被投诉人披露，以便双方处理可能的权利纠纷；</p></li><li><p>在本应用平台上创建的某一交易中，如交易任何一方履行或部分履行了交易义务并提出信息披露请求的，本应用有权决定向该用户提供其交易对方的联络方式等必要信息，以促成交易的完成或纠纷的解决。</p></li><li><p>其它本应用根据法律、法规或者网站政策认为合适的披露。</p></li></ul><h3>信息存储和交换</h3><p>本应用收集的有关您的信息和资料将保存在本应用及（或）其关联公司的服务器上，这些信息和资料可能传送至您所在国家、地区或本应用收集信息和资料所在地的境外并在境外被访问、存储和展示。</p><p>信息安全</p><ul class=" list-paddingleft-2" style="list-style-type: disc;"><li><p>本应用帐号均有安全保护功能，请妥善保管您的用户名及密码信息。本应用将通过对用户密码进行加密等安全措施确保您的信息不丢失，不被滥用和变造。尽管有前述安全措施，但同时也请您注意在信息网络上不存在“完善的安全措施”。</p></li><li><p>在使用本应用网络服务进行网上交易时，您不可避免的要向交易对方或潜在的交易对方披露自己的个人信息，如联络方式或者邮政地址。请您妥善保护自己的个人信息，仅在必要的情形下向他人提供。如您发现自己的个人信息泄密，尤其是本应用用户名及密码发生泄露，请您立即联络本应用客服，以便本应用采取相应措施。</p></li></ul></div></div></div>'),
(42, 1, 451, 0, '', '', '<div class="row no-gutters" pre-type="layer" pre-id="yxcbminikj" pre-name="content"><div class="col-12" pre-name="content" pre-type="data" pre-id="yxcbminikj-0" pre-vtype="editor">	<div pre-type="content"><h3>1、协议的主体及范围</h3><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>请确认，在完成注册或以其他本站允许的方式实际登陆网站时，注册人或者登陆人应当是具备完全民事权利能力和完全民事行为能力的自然人、法人或非法人组织（以下统称为“用户”、“您”）。若您是未成年人或限制民事行为能力人，则不具备前述主体资格，您及您的监护人应承担因不当注册行为而导致的一切后果，且本站有权注销（永久冻结）您的账户，并向您及您的监护人索偿。</p></li><li><p>本协议是您与本网站之间关于用户使用本站相关服务所订立的协议。</p></li><li><p>本协议项下的服务是指本网站向用户提供的包括但不限于技术支持、信息推广等产品及服务（以下简称“本服务”）。</p></li><li><p>您在使用本网站某一特定服务时，该服务可能会另有单独的协议、相关业务规则等（以下统称为“单独协议”）。上述内容一经正式发布，即为本协议不可分割的组成部分，您同样应当遵守。您对前述任何业务规则、单独协议的接受，即视为您对本协议全部的接受</p></li></ol><h3>2、协议生效条件</h3><p>本网站提供的服务将完全按照其发布的章程、服务条款和操作规则严格执行。用户完全完成注册程序，便成为本网站的注册用户，将得到一个密码和帐号，同时此协议即时生效。用户有义务保证密码和帐号的安全。用户对利用该密码和帐号所进行的一切活动负全部责任；因此所衍生的任何损失或损害，本网站无法也不承担任何责任。</p><h3>3、注册义务</h3><p>本网站运用自己的操作系统通过国际互联网为用户提供网络服务。同时，用户必须：,</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>自行配备上网的所需设备，包括个人电脑、智能手持终端或其他必备上网装置；</p></li><li><p>自行负担个人上网所支付的与此服务有关的电话费用、网络费用。</p></li></ol><p>为了能使用本服务，您同意以下事项：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>依本服务注册表的提示提供真实身份信息，不提供真实身份信息的，本网站拒绝为您提供相关服务；</p></li><li><p>维持更新您个人用户信息，确保其真实、正确、最新及完整。若您提供任何错误、不实、过时或不完整的资料，并为本网站所确知，或者本网站有合理的理由怀疑前述资料为错误、不实、过时或不完整，本网站有权暂停或终止您的帐号，并拒绝您于现在和未来使用本网站全部或部分的服务。但您发现本网站违反法律、行政法规的规定或者双方的约定收集、使用您个人信息的，有权要求本网站删除您个人信息；发现本网站收集、存储的您个人信息有错误的，有权要求本网站予以更正，本网站将采取措施予以删除或者更正。</p></li><li><p>您注册的用户名不能侵犯他人合法权益，不能对他人名誉权造成侵犯。本网站有权收回对本网站或者他人合法权益有侵犯嫌疑的帐号。</p></li></ol><h3>4、隐私制度</h3><p>尊重用户个人隐私、保护个人信息安全是《中华人民共和国网络安全法》的要求，也是本网站的一项基本政策。所以，本网站不会在未经合法用户同意或授权时，公开、编辑或透露其个人信息及保存在本网站中的非公开内容，除非有下列情况：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>有关法律规定和程序，本网站合法服务程序规定；</p></li><li><p>保持维护本网站的商标所有权和其他合法权益；</p></li><li><p>在紧急情况下竭力维护用户个人和社会大众的隐私安全；</p></li><li><p>与本网站的关联公司和战略合作伙伴分享客户资料，以及其他需要公开、编辑或透露个人信息的情况。</p></li><li><p>对个人信息数据进行脱敏（匿名化）处理后的使用。</p></li></ol><p>另外，在以下（包括但不限于）几种情况下，本网站有权使用用户的个人信息：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>在进行促销、抽奖、捐助等社会或商业活动时，本网站可能会与赞助商共享用户的个人信息，在这些情况下本网站会在发送用户信息之前进行提示，并且用户可以通过不参与来终止传送过程；</p></li><li><p>本网站会通过透露合计用户统计数据，向未来的合作伙伴、广告商及其他第三方以及为了其他合法目的而描述本网站的服务；</p></li><li><p>本网站可以将用户信息与第三方数据匹配；</p></li><li><p>本网站会向用户发送客户订制的信息或者其它本网站认为用户会感兴趣的其他信息。如果用户不希望收到这样的信息，只需在提供个人信息时或其他任何时候告知即可；</p></li><li><p>另外，本网站会采取行业惯用措施保护用户信息的安全，但本网站不能确信或保证任何个人信息的安全性，用户须自己承担风险。比如用户联机公布可被公众访问的个人信息时，用户有可能会收到未经用户同意的信息；本网站的合作伙伴和可通过本网站访问的第三方因特网站点和服务；通过抽奖、促销等活动得知用户个人信息的第三方会进行独立的数据收集工作等活动。本网站对用户及其他任何第三方的上述行为，不承担任何责任。</p></li></ol><h3>5、用户信息的存储与限制</h3><p>本网站不对用户所发布信息的删除或储存失败负责。本网站除按照《中华人民共和国网络安全法》的规定留存相关的网络日志不少于六个月之外，并不承诺对用户的存储信息进行无限期保留。除非按照《中华人民共和国网络安全法》的规定本网站为其服务持续提供安全维护，在规定或者约定的期限内不得终止提供安全维护外，否则本网站不保证服务一定会满足用户的使用要求，也不保证服务不会受中断，对服务的及时性、安全性、准确性也不作担保。本网站有判定用户的行为是否符合本网站服务条款的要求和精神的保留权利，如果用户违背了服务条款的规定，本网站有中断对其提供网络服务的权利。本网站运用自己的操作系统通过国际互联网向用户提供丰富的网上资源，包括各种信息工具、网上论坛、个性化内容等。除非另有明确规定，增强或强化目前服务的任何新功能，包括新产品、栏目，均无条件地适用本服务条款。</p><h3>6、服务条款的修改</h3><p>本网站有权在必要时修改服务条款。本网站服务条款一旦发生变动，将会在重要页面上提示所修改的内容。如果不同意所改动的内容，用户可以主动取消获得的网络服务。如果用户继续享用网络服务，则视为接受服务条款的变动。本网站保留随时修改或中断服务而不需照知用户的权利。本网站行使修改或中断服务的权利，不需对用户或第三方负责。</p><h3>7、拒绝提供担保</h3><p>用户对网络服务的使用承担风险。本网站对此不作任何类型的担保，不论是明确的或隐含的，但是不对商业性的隐含担保、特定目的和不违反规定的适当担保作限制。</p><h3>8、有限责任</h3><p>本网站对任何直接、间接、偶然、特殊及继起的损害不负责任，这些损害可能来自：不正当使用网络服务，在网上购买商品或进行同类型服务，在网上进行交易，非法使用网络服务或用户传送的信息有所变动。</p><h3>9、服务的结束</h3><p>用户或本网站可随时根据实际情况中断一项或多项网络服务。本网站不需对任何个人或第三方负责而随时中断服务。用户对后来的条款修改有异议，或对本网站的服务不满，可以行使如下权利：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>停止使用本网站的网络服务；</p></li><li><p>通告本网站停止对该用户的服务。结束用户服务后，用户使用网络服务的权利马上中止。从那时起，用户没有权利，本网站也没有义务传送任何未处理的信息或未完成的服务给用户或第三方。</p></li></ol><h3>10、用户管理</h3><p>用户单独承担发布内容的责任。用户对服务的使用是根据所有适用于本网站的国家法律、地方法律和国际法律标准的。</p><p>用户必须遵循：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>从中国境内向外传输技术性资料时必须符合中国有关法规；</p></li><li><p>使用网络服务不作非法用途；</p></li><li><p>不干扰或混乱网络服务；</p></li><li><p>遵守所有使用网络服务的网络协议、规定、程序和惯例。</p></li><li><p>用户的密码和帐号遭到未授权的使用或发生其他任何安全问题，用户可以立即通知本网站，并且用户在每次连线结束，应结束帐号使用，否则用户可能得不到本网站的安全保护。</p></li><li><p>禁止用户从事以下行为：</p></li><ol class=" list-paddingleft-2" style="list-style-type: lower-alpha;"><li><p>上载、张贴、发送或传送任何非法、反动、淫秽、粗俗、猥亵的，胁迫、骚扰、中伤他人、诽谤、侵害他人隐私或诋毁他人名誉或商誉的，种族歧视、危害未成年人或其他不适当的信息或电子邮件，包括但不限于资讯、资料、文字、软件、音乐、照片、图形、信息或其他资料（以下简称内容）。</p></li><li><p>未经本网站许可的广告行为。</p></li><li><p>冒充任何人或机构，或以虚伪不实的方式谎称或使人误认为与任何人或任何机构有关。</p></li><li><p>伪造标题或以其他方式操控识别资料，使人误认为该内容为本网站所传送。</p></li><li><p>上载、张贴、发送电子邮件或以其它方式传送无权传送的内容（例如内部资料、机密资料）。</p></li><li><p>上载、张贴、发送电子邮件或以其它方式传送侵犯任何人的专利、商标、著作权、商业秘密或其他专属权利之内容。</p></li><li><p>在本网站提供的专供张贴广告的区域之外，上载、张贴、发送电子邮件或以其他方式传送广告函件、促销资料、“垃圾邮件”等。</p></li><li><p>上载、张贴、发送电子邮件或以其他方式传送有关干扰、破坏或限制任何计算机软件、硬件或通讯设备功能的软件病毒或其他计算机代码、档案和程序之资料。</p></li><li><p>干扰或破坏本服务或与本服务相连的服务器和网络，或不遵守本服务协议之规定。</p></li><li><p>故意或非故意违反任何相关的中国法律、法规、规章、条例等其他具有法律效力的规范。</p></li><li><p>跟踪或以其他方式骚扰他人。</p></li><li><p>其它被本网站视为不适当的行为。</p></li><li><p>《中华人民共和国网络安全法》禁止的下列行为：</p></li><ol class=" list-paddingleft-2" style="list-style-type: lower-roman;"><li><p>不得危害网络安全，不得利用网络从事危害国家安全、荣誉和利益，煽动颠覆国家政权、推翻社会主义制度，煽动分裂国家、破坏国家统一，宣扬恐怖主义、极端主义，宣扬民族仇恨、民族歧视，传播暴力、淫秽色情信息，编造、传播虚假信息扰乱经济秩序和社会秩序，以及侵害他人名誉、隐私、知识产权和其他合法权益等活动。</p></li><li><p>不得从事非法侵入他人网络、干扰他人网络正常功能、窃取网络数据等危害网络安全的活动；不得提供专门用于从事侵入网络、干扰网络正常功能及防护措施、窃取网络数据等危害网络安全活动的程序、工具；明知他人从事危害网络安全的活动的，不得为其提供技术支持、广告推广、支付结算等帮助。</p></li><li><p>不得窃取或者以其他非法方式获取个人信息，不得非法出售或者非法向他人提供个人信息。</p></li><li><p>不得设立用于实施诈骗，传授犯罪方法，制作或者销售违禁物品、管制物品等违法犯罪活动的网站、通讯群组，不得利用网络发布涉及实施诈骗，制作或者销售违禁物品、管制物品以及其他违法犯罪活动的信息。</p></li><li><p>不得设置恶意程序，不得含有法律、行政法规禁止发布或者传输的信息。</p></li></ol></ol></ol><p>另外，用户对经由本服务上载、张贴、发送电子邮件或传送的内容负全部责任；对于经由本服务而传送的内容，本网站不保证前述内容的正确性、完整性或品质。用户在接受本服务时，有可能会接触到令人不快、不适当或令人厌恶的内容。在任何情况下，本网站均不对任何内容负责，包括但不限于任何内容发生任何错误或纰漏以及衍生的任何损失或损害。本网站有权（但无义务）自行拒绝或删除经由本服务提供的任何内容。用户使用上述内容，应自行承担风险。</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><ol class=" list-paddingleft-2" style="list-style-type: lower-alpha;"><ol class=" list-paddingleft-2" style="list-style-type: lower-roman;"><ol class=" list-paddingleft-2" style="list-style-type: decimal;"></ol></ol></ol></ol><p>本网站有权利在下述情况下，对内容进行保存或披露：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>法律程序所规定；</p></li><li><p>本服务条款规定；</p></li><li><p>被侵害的第三人提出权利主张；</p></li><li><p>为保护本网站、其使用者及社会公众的权利、财产或人身安全；</p></li><li><p>其他本网站认为有必要的情况。</p></li></ol><h3>11、用户的广告宣传</h3><p>用户在自己发表的信息中加入宣传资料或参与广告策划，在本网站的免费服务上展示他们的产品，任何这类促销方法，包括运输货物、付款、服务、商业条件、担保及与广告有关的描述都只是在相应的用户和广告销售商之间发生。本网站控股不承担任何责任，本网站控股没有义务为这类广告销售负任何一部分的责任。同时，如果该行为未经本网站控股同意或者对本网站控股产生利益侵犯，本网站控股有权利进行删除、屏蔽，以及采取相应的技术、法律手段阻止此类信息的发布。</p><h3>12、关于用户在本网站的公开使用区域的内容</h3><p>“公开使用区域”包括网上论坛、留言版、评论区和其它一般公众可以使用的网络内容区域；用户一旦在本服务公开使用区域张贴内容，即视为用户授予本网站该内容著作权之免费及非独家许可使用权，本网站有权为展示、传播及推广前述张贴的内容之服务目的，对上述内容进行复制、修改、出版。</p><p>由此展示、传播及推广行为所产生的损失或利润，均由本网站承担或享受。本网站有权自主决定是否给予此类用户鼓励或奖励。</p><p>因用户进行上述张贴，而导致任何第三方提出索赔要求或衍生的任何损害或损失，用户须承担全部责任。</p><p>其他访问者或者企业、单位，未经本网站控股授权，不得对他人张贴在公开使用区域或本服务其他内容进行复制、出售或用作其他商业用途。</p><h3>13、关于手机服务</h3><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>本网站为用户提供本网站手机短信服务。一旦用户在注册本服务的过程输入自己的手机号码和保护码并完成登记注册程序，则表明用户愿意接受本网站发送的短信，此服务为免信息费服务，本网站不向用户收取任何费用，用户主动发送的短信产生的费用，由用户向移动运营商支付，与本网站无关。若用户通过注册并使用了本网站的收费短信服务，则表示用户同意通过运营商支付信息费给本网站，此服务产生的信息费由运营商代为收取。手机短信服务的具体收费说明见具体服务的相应页面。</p></li><li><p>本网站为用户提供手机上网服务。本网站不收取用户任何费用，用户上网产生可能产生的流量费，由用户向运营商支付，与本网站无关。</p></li><li><p>本网站不承担用户由于手机故障、欠费、丢失、借用或盗用后他人利用手机订购本网站短信息服务而遭受的损失或并非由于本网站的原因而导致的任何其它损失。对于用户出国并使用国际漫游服务但未取消已定制的短信息服务，或者在国际漫游状态下继续使用短信息点播服务，用户应当承担相关所有费用，本网站不承担任何责任。</p></li><li><p>用户自己承担系统受损或资料丢失的所有风险和责任。本网站对于删除和存储数据失败并不负有任何责任。</p></li><li><p>如因本网站的过错，导致用户接收到错误的信息并支付了不应支付的信息费，本网站的全部责任仅限于赔偿用户因错误信息而支付的信息费</p></li></ol><h3>14、关于链接</h3><p>本服务可能会提供与其他国际互联网网站或资源进行链接。对于前述网站或资源是否可以利用，本网站不予担保。因使用或依赖上述网站或资源所产生的损失或损害，本网站也不承担任何责任。</p><h3>15、本网站的知识产权及其他权利</h3><p>本网站对本服务及本服务所使用的软件和受知识产权或其他法律保护的资料享有相应的权利；</p><p>经由本服务传送的资讯及内容，受到著作权法、商标法、专利法或其他法律的保护；未经本网站明示授权许可，用户不得进行修改、出租、散布或衍生其他作品，用户本人创作并在公开使用区域张贴的内容除外。</p><p>用户对本服务所使用的软件有非专属性使用权，但自己不得或许可任何第三方复制、修改、出售或衍生产品。</p><p>本网站、本网站设计图样以及其他本网站图样、产品及服务名称，均为本网站控股所享有的商标，未经本网站控股事先书面授权，任何人不得使用、复制或用作其他用途。</p><h3>16、免责声明</h3><p>本网站对于本服务包含的或用户经由或从任何与本服务有关的途径所获得的任何内容、信息或广告，不声明或保证其正确性或可靠性；并且对于用户经本服务上的广告、展示而购买、取得的任何产品、信息或资料，本网站不负保证责任。用户自行承担担使用本服务的风险。</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>本网站有权但无义务，改善或更正本服务任何部分之任何疏漏、错误。</p></li><li><p>本网站不保证以下事项（包括但不限于）：</p></li><ol class=" list-paddingleft-2" style="list-style-type: lower-alpha;"><li><p>本服务适合用户的使用要求；</p></li><li><p>本服务不受干扰，及时、安全、可靠或不出现错误；</p></li><li><p>用户经由本服务取得的任何产品、服务或其他材料符合用户的期望；</p></li><li><p>用户使用经由本服务下载的或取得的任何资料，其风险自行负担；因该使用而导致用户电脑系统损坏或资料流失，用户应负完全责任；</p></li><li><p>对基于以下原因而造成的利润、商业信誉、资料的损失或其他有形或无形损失，本网站不承担任何直接、间接、附带、衍生或惩罚性的赔偿；</p></li><li><p>服务使用或无法使用；</p></li><li><p>经由本服务购买或取得的任何产品、资料或服务；</p></li><li><p>用户资料遭到未授权的使用或修改；</p></li><li><p>其他与本服务相关的事宜。</p></li></ol><li><p>用户在浏览网际网路时自行判断使用本网站的检索目录。该检索目录可能会引导用户进入到被认为具有攻击性或不适当的网站，本网站没有义务查看检索目录所列网站的内容，因此，对其正确性、合法性、正当性不负任何责任。</p></li><li><p>用户同意，对于本网站向用户提供的下列产品或者服务的质量缺陷本身及其引发的任何损失，本网站无需承担任何责任：</p></li><ol class=" list-paddingleft-2" style="list-style-type: lower-alpha;"><li><p>本网站向用户免费提供的各项网络服务；</p></li><li><p>本网站向用户赠送的任何产品或者服务；</p></li><li><p>本网站向收费网络服务用户附赠的各种产品或者服务。</p></li></ol></ol><h3>17、法律</h3><p>网络服务条款要与中华人民共和国的法律解释相一致，用户和本网站一致同意服从高等法院所管辖。如发生本网站服务条款与中华人民共和国法律相抵触时，则这些条款将完全按法律规定重新解释，而其它条款则依旧保持对用户产生法律效力和影响。</p><p>在任何情况下，本网站用户不得利用本网站进行违反或可能违反国家法律和法规的言论或行为，否则，本网站可在任何时候不经任何事先通知终止向您提供服务。并且用户对自己的言论或行为负责。用户应遵守以下法律及法规：</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>用户同意遵守《中华人民共和国网络安全法》、《中华人民共和国保守国家秘密法》、《中华人民共和国计算机信息系统安全保护条例》、《计算机软件保护条例》、信息产业部2000年10月8日第4次部务会议通过的《互联网电子公告服务管理规定》，以及《互联网新闻信息服务管理规定》等有关计算机及互联网规定的法律和法规、实施办法。在任何情况下，本网站合理地认为用户的行为可能违反上述法律、法规，本网站可以在任何时候，不经事先通知终止向该用户提供服务。</p></li><li><p>用户应了解国际互联网的无国界性，应特别注意遵守当地所有有关的法律和法规。</p></li></ol></div></div></div>'),
(43, 1, 451, 0, '', '', '<div class="row no-gutters" pre-type="layer" pre-id="kmiecemtet" pre-name="content"><div class="col-12" pre-name="content" pre-type="data" pre-id="kmiecemtet-0" pre-vtype="editor">	<div pre-type="content"><h3>退货政策</h3><p>退换货基本条件（实物）</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>退换货申请应在确认签收商品之日起7天内提出（已物流签收时间为准），或交易完成之日起15天内发现商品存在质量问题提出。</p></li><li><p>退换货商品必须未经使用、未破坏原包装且不影响本站二次销售，存在质量问题的商品除外。</p></li><li><p>定制类商品由您与当地门店签订购买协议并付清全额货款，工厂开始下单生产后不予退换货。</p></li><li><p>未经本站授权的维修、改动、安装造成的商品问题不予退换货。</p></li><li><p>商品退换时，商品的外包装、附件、配件、赠品、说明书不完整，发票缺失或涂改，不予退换货。</p></li><li><p>您需同时将商品、发票、赠品回寄本站指定地址，邮费需由买家自行承担。</p></li></ol><h3>物流配送</h3><p>对于本站出售的定制类商品，由于无法使用快递运输，需通过物流发送到您所在当地店，并由当地门店安排专业安装人员上门安装。市内物流配送安装收费情况市外的其他区域，因距离远近不一样，以店面回复的收费标准为主。</p><h3>收货指南</h3><p>请在配送人员在场的情况下，当面验收您的商品</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>快递员送货上门时，请您务必当面对照发货单核对商品，如果出现商品缺少、配送错误、包装破损问题等，请直接联系客服中心，待客服确认后，可将整单商品由快递公司退回。</p></li><li><p>如您手下货物后，发现质量问题，可以联系本站客服中心为您办理退货业务。</p></li><li><p>确定订单时选择开具发票但签收时发票未随商品一起送到，请与本站客服中心联系为您补开发票。</p></li><li><p>签收后本站会视为您已经认可并接受本公司商品。非订货人本人签收的产品，我们会视您等同于订购人进行验货。一旦您确认签字，我们将无法为您办理退款或补发。</p></li></ol><h3>售后维护</h3><p>为保障消费者利益，凡在本站订购指定套餐产品成功的用户，可以享受以下承诺</p><ol class=" list-paddingleft-2" style="list-style-type: decimal;"><li><p>自交货之日起6年内，如橱柜、衣柜、书柜、电视柜等柜类产品在正常使用情况下产生质量问题，消费者将享受免费保修6年的服务承诺。</p></li><li><p>消费者将享受终身有偿维护的服务承诺。</p></li></ol></div></div></div>');

CREATE TABLE IF NOT EXISTS `qinggan_list_111` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `video` varchar(255) NOT NULL DEFAULT '' COMMENT '视频',
  `mp4` varchar(255) NOT NULL DEFAULT '' COMMENT 'MP4文件',
  `content` longtext NOT NULL COMMENT '内容',
  `mp4_bg` varchar(255) NOT NULL DEFAULT '' COMMENT '视频封面',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='视频' AUTO_INCREMENT=48 ;

INSERT INTO `qinggan_list_111` (`id`, `site_id`, `project_id`, `cate_id`, `thumb`, `video`, `mp4`, `content`, `mp4_bg`) VALUES
(47, 1, 452, 0, '112', 'https://www.bilibili.com/video/BV1oy4y1y7se/', '', '', '');

CREATE TABLE IF NOT EXISTS `qinggan_list_112` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '网站ID',
  `project_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主分类ID',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '缩略图',
  `note` longtext NOT NULL COMMENT '摘要',
  `content` longtext NOT NULL COMMENT '内容',
  `banner` varchar(255) NOT NULL DEFAULT '' COMMENT '通栏图片',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`),
  KEY `site_project` (`site_id`,`project_id`),
  KEY `site_cate` (`site_id`,`cate_id`),
  KEY `project_cate` (`site_id`,`project_id`,`cate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='专题设计' AUTO_INCREMENT=52 ;

INSERT INTO `qinggan_list_112` (`id`, `site_id`, `project_id`, `cate_id`, `thumb`, `note`, `content`, `banner`) VALUES
(50, 1, 453, 0, '94', '', '<div pre-type="layer" pre-id="aiawmrshjp6dtk5d68ni" pre-name="content" style="display: block; background-position: left top;" pre-width="fixed"><!-- layer aiawmrshjp6dtk5d68ni --><div class="row no-gutters"><div class="col-5" pre-name="content" pre-type="data" pre-id="aiawmrshjp6dtk5d68ni-0" pre-vtype="editor"><div pre-type="content"><hr><p><br></p></div></div><div class="col-2" pre-name="content" pre-type="data" pre-id="aiawmrshjp6dtk5d68ni-1" pre-vtype="editor"><div pre-type="content" data-wow-duration="" data-wow-delay="" data-wow-offset="" data-wow-iteration="" wow-in="bounce" wow-action="true" wow-out="" style="background-position: left top;"><h2 style="text-align: center;">图文新闻</h2></div></div><div class="col-5" pre-name="content" pre-type="data" pre-id="aiawmrshjp6dtk5d68ni-2" pre-vtype="editor"><div pre-type="content"><hr><p><br></p></div></div></div><!-- /layer aiawmrshjp6dtk5d68ni --></div><div pre-type="layer" pre-id="shbtrmdmtszfzajikbe0" pre-name="content" pre-width="fixed" style="background-position: left top; margin: 0px 0px 30px;"><!-- layer shbtrmdmtszfzajikbe0 --><div class="row no-gutters"><div class="col-12" pre-name="content" pre-type="data" pre-id="shbtrmdmtszfzajikbe0-0" pre-vtype="calldata" pre-code="news-pictures" pre-param="fields=note,content,thumb" pre-tplfile="_data/design/arclist"><div pre-type="content" data-wow-duration="2s" data-wow-delay="2s" data-wow-offset="1" data-wow-iteration="" wow-in="" wow-action="true" wow-out="" style="background-position: left top;"><!-- content-shbtrmdmtszfzajikbe0-0 --><div style="background:none;z-index:2;position:absolute;left:0;top:0;width:100%;height:100%;"></div><iframe src="api.php?c=call&amp;f=admin_preview&amp;id=shbtrmdmtszfzajikbe0-0&amp;code=news-pictures&amp;param=fields%3Dnote%2Ccontent%2Cthumb&amp;tplfile=_data%2Fdesign%2Farclist" style="border: 0px; margin: 0px; padding: 0px; background-color: transparent; z-index: 1; height: 289px;" id="iframe_shbtrmdmtszfzajikbe0-0" name="iframe_shbtrmdmtszfzajikbe0-0" scrolling="0" width="100%" allowtransparency="true" frameborder="0" marginheight="0" marginwidth="0"></iframe><!-- /content-shbtrmdmtszfzajikbe0-0 --></div></div></div><!-- /layer shbtrmdmtszfzajikbe0 --></div><div pre-type="layer" pre-id="rmxwwdkdkwjaxd0f0eky" pre-name="content" pre-width="auto" style="background-position: left top; background-color: rgb(243, 243, 243);"><!-- layer rmxwwdkdkwjaxd0f0eky --><div class="row no-gutters"><div class="col-12" pre-name="content" pre-type="data" pre-id="rmxwwdkdkwjaxd0f0eky-0" pre-vtype="editor"><div pre-type="content" data-wow-duration="" data-wow-delay="" data-wow-offset="" data-wow-iteration="" wow-in="bounceInLeft" wow-action="true" wow-out="" style="background-position: left top;"><h3 style="text-align: center;"><br></h3><h3 style="text-align: center;">图片效果<br></h3><p><br></p></div></div></div><!-- /layer rmxwwdkdkwjaxd0f0eky --></div><div pre-type="layer" pre-id="ieffsexmfi2wz23dyfmt" pre-name="content" pre-width="auto" style="background-position: left top; background-color: rgb(243, 243, 243);"><!-- layer ieffsexmfi2wz23dyfmt --><div class="row no-gutters"><div class="col-12" pre-name="content" pre-type="data" pre-id="ieffsexmfi2wz23dyfmt-0" pre-vtype="calldata" pre-code="hot_products" pre-param="psize=4" pre-tplfile="_data/design/piclist"><div pre-type="content" data-wow-duration="" data-wow-delay="" data-wow-offset="" data-wow-iteration="" wow-in="bounceInLeft" wow-action="true" wow-out="" style="background-position: left top; padding: 0px 0px 50px;"><!-- content-ieffsexmfi2wz23dyfmt-0 --><div style="background:none;z-index:2;position:absolute;left:0;top:0;width:100%;height:100%;"></div><iframe src="api.php?c=call&amp;f=admin_preview&amp;id=ieffsexmfi2wz23dyfmt-0&amp;code=hot_products&amp;param=psize%3D4&amp;tplfile=_data%2Fdesign%2Fpiclist" style="border: 0px; margin: 0px; padding: 0px; background-color: transparent; z-index: 1; height: 395px;" id="iframe_ieffsexmfi2wz23dyfmt-0" name="iframe_ieffsexmfi2wz23dyfmt-0" scrolling="0" width="100%" allowtransparency="true" frameborder="0" marginheight="0" marginwidth="0"></iframe><!-- /content-ieffsexmfi2wz23dyfmt-0 --></div></div></div><!-- /layer ieffsexmfi2wz23dyfmt --></div><div pre-type="layer" pre-id="whabpxrntn948tcad8ar" pre-name="content" pre-width="fixed" style="background-position: left top; padding: 50px 0px 30px;"><!-- layer whabpxrntn948tcad8ar --><div class="row no-gutters"><div class="col" pre-type="data" pre-name="content" pre-id="whabpxrntn948tcad8ar-0" pre-vtype="image" pre-gdtype="auto" pre-image="55"><div pre-type="content" data-wow-duration="" data-wow-delay="" data-wow-offset="" data-wow-iteration="" wow-in="fadeInLeft" wow-out="" style="text-align: center; background-position: left top;" wow-action="true"><img src="res/_cache/auto/55/55.jpg" style="border:0;width:400px;" alt="1"></div></div><div class="col" pre-type="data" pre-name="content" pre-id="whabpxrntn948tcad8ar-1" pre-vtype="calldata" pre-code="aboutus" pre-param="" pre-tplfile="_data/design/aboutus"><div pre-type="content" data-wow-duration="" data-wow-delay="" data-wow-offset="" data-wow-iteration="" wow-in="bounceInDown" wow-action="true" wow-out="" style="background-position: left top;"><!-- content-whabpxrntn948tcad8ar-1 --><div style="background:none;z-index:2;position:absolute;left:0;top:0;width:100%;height:100%;"></div><iframe src="api.php?c=call&amp;f=admin_preview&amp;id=whabpxrntn948tcad8ar-1&amp;code=aboutus&amp;tplfile=_data%2Fdesign%2Faboutus" style="border: 0px; margin: 0px; padding: 0px; background-color: transparent; z-index: 1; height: 246px;" id="iframe_whabpxrntn948tcad8ar-1" name="iframe_whabpxrntn948tcad8ar-1" scrolling="0" width="100%" allowtransparency="true" frameborder="0" marginheight="0" marginwidth="0"></iframe><!-- /content-whabpxrntn948tcad8ar-1 --></div></div></div><!-- /layer whabpxrntn948tcad8ar --></div><div pre-type="layer" pre-id="djzzjtaxzcdj0b2t3333" pre-name="content" pre-width="fixed" style="background-position: left top;"><!-- layer djzzjtaxzcdj0b2t3333 --><div class="row no-gutters"><div class="col-12" pre-name="content" pre-type="data" pre-id="djzzjtaxzcdj0b2t3333-0" pre-vtype="editor"><div pre-type="content"><p><br></p><p><span style="font-size: 24px;"><strong>结束寄语：</strong></span></p><p>感谢您使用PHPOK系统，这是一个强大的可自定义的CMS系统，代码开源，可免费商用，基于 LGPL 协议您甚至可以改造成自己进行二次发布！</p><p>2021年，相信我们还在创造奇迹！</p><p><br></p></div></div></div><!-- /layer djzzjtaxzcdj0b2t3333 --></div>', '87');

CREATE TABLE IF NOT EXISTS `qinggan_list_attr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性组ID',
  `vid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '参数ID',
  `price` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '增减价格值',
  `weight` float NOT NULL DEFAULT '0' COMMENT '重量增减',
  `volume` float NOT NULL DEFAULT '0' COMMENT '体积增减值，带-号为减值',
  `taxis` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='主题属性' AUTO_INCREMENT=15 ;

INSERT INTO `qinggan_list_attr` (`id`, `tid`, `aid`, `vid`, `price`, `weight`, `volume`, `taxis`) VALUES
(1, 4, 1, 1, '0.0000', 0, 0, 5),
(2, 4, 1, 2, '0.0000', 0, 0, 10),
(3, 4, 1, 3, '0.0000', 0, 0, 15),
(4, 4, 2, 4, '0.0000', 0, 0, 5),
(5, 4, 2, 5, '200.0000', 0, 0, 10),
(6, 6, 1, 6, '0.0000', 0, 0, 5),
(7, 6, 1, 7, '0.0000', 0, 0, 10),
(8, 6, 1, 8, '0.0000', 0, 0, 15),
(9, 7, 1, 9, '0.0000', 0, 0, 5),
(10, 7, 1, 10, '0.0000', 0, 0, 10),
(11, 7, 1, 11, '0.0000', 0, 0, 15),
(12, 7, 2, 12, '500.0000', 0, 0, 5),
(13, 7, 2, 13, '0.0000', 0, 0, 10),
(14, 7, 2, 14, '300.0000', 0, 0, 15);

CREATE TABLE IF NOT EXISTS `qinggan_list_biz` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `price` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '价格',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币ID',
  `weight` float unsigned NOT NULL DEFAULT '0' COMMENT '重量，单位是Kg',
  `volume` float unsigned NOT NULL DEFAULT '0' COMMENT '体积，单位立方米',
  `unit` varchar(50) NOT NULL COMMENT '单位',
  `is_virtual` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0实物1虚拟产品',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='电子商务';

INSERT INTO `qinggan_list_biz` (`id`, `price`, `currency_id`, `weight`, `volume`, `unit`, `is_virtual`) VALUES
(4, '1798.0000', 1, 0, 0, '', 0),
(6, '2299.0000', 1, 0, 0, '台', 0),
(7, '499.0000', 1, 0, 0, '台', 0),
(8, '99.0000', 1, 0, 0, '', 1),
(9, '299.0000', 1, 0, 0, '', 0),
(10, '160.0000', 1, 0, 0, '', 0),
(11, '0.1000', 1, 0, 0, '', 0);

CREATE TABLE IF NOT EXISTS `qinggan_list_cate` (
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `cate_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  PRIMARY KEY (`id`,`cate_id`),
  KEY `id` (`id`),
  KEY `cate_id` (`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='主题绑定的分类';

INSERT INTO `qinggan_list_cate` (`id`, `cate_id`) VALUES
(4, 583),
(5, 211),
(6, 584),
(7, 582),
(9, 701),
(10, 701),
(11, 701),
(12, 8),
(13, 68),
(14, 68),
(15, 68),
(16, 68),
(17, 68),
(37, 204),
(38, 204),
(39, 204),
(45, 198),
(46, 199),
(48, 204),
(49, 204),
(2262, 8);

CREATE TABLE IF NOT EXISTS `qinggan_list_stock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `attrs` text NOT NULL COMMENT '主题属性，多个属性用英文逗号隔开，属性ID和值ID用冒号隔开',
  `pictures` varchar(255) NOT NULL COMMENT '多张图片ID用英文逗号隔开',
  `qty` int(10) NOT NULL DEFAULT '0' COMMENT '库存数量，仅支持整数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='库存表' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `note` varchar(255) NOT NULL COMMENT '日志摘要',
  `url` varchar(255) NOT NULL COMMENT '请求网址',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行时间',
  `app_id` varchar(30) NOT NULL DEFAULT 'www' COMMENT '接入APP_ID',
  `ctrl` varchar(255) NOT NULL COMMENT '控制器',
  `func` varchar(255) NOT NULL COMMENT '方法',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作人',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ip` varchar(255) NOT NULL COMMENT '登录IP',
  `referer` varchar(255) NOT NULL COMMENT '来源网址',
  `mask` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0表示系统日志，1表示手动断点日志用于调试',
  `session_id` varchar(255) NOT NULL COMMENT 'SESSION_ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='日志记录' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID，主键',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID',
  `group_id` varchar(255) NOT NULL COMMENT '菜单组ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID，支持无限级菜单',
  `title` varchar(255) NOT NULL COMMENT '菜单名称',
  `type` varchar(255) NOT NULL COMMENT '类型，project指项目，cate指分类，content指内容，link自定义',
  `project_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cate_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `list_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `link` varchar(255) NOT NULL COMMENT '自定义链接，最长不能超过255',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0当前页，1新窗口',
  `is_userid` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0游客，1仅限会员',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，最大255，值越小越往前靠',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0未审，1正常',
  `submenu` varchar(255) NOT NULL COMMENT '二级菜单类型',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`group_id`) USING BTREE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='菜单管理' AUTO_INCREMENT=29 ;

INSERT INTO `qinggan_menu` (`id`, `site_id`, `group_id`, `parent_id`, `title`, `type`, `project_id`, `cate_id`, `list_id`, `link`, `target`, `is_userid`, `taxis`, `status`, `submenu`) VALUES
(1, 1, 'top', 0, '网站首页', 'link', 0, 0, 0, 'index.php', 0, 0, 5, 1, ''),
(2, 1, 'top', 0, '', 'project', 87, 0, 18, '', 0, 0, 10, 1, 'title1'),
(5, 1, 'top', 0, '', 'project', 43, 0, 0, '', 0, 0, 15, 1, 'cate1'),
(8, 1, 'top', 0, '', 'project', 45, 0, 0, '', 0, 0, 20, 1, 'cate1'),
(26, 1, 'topnav', 0, '', 'project', 96, 0, 0, '', 0, 0, 10, 1, ''),
(10, 1, 'top', 0, '图集相册', 'project', 144, 0, 0, '', 0, 0, 30, 1, ''),
(11, 1, 'top', 0, '下载中心', 'project', 151, 0, 0, '', 0, 0, 35, 1, ''),
(27, 1, 'topnav', 0, '', 'content', 87, 0, 20, '', 0, 0, 15, 1, ''),
(13, 1, 'bottom', 0, '网站首页', 'link', 0, 0, 0, 'index.php', 0, 0, 5, 1, ''),
(16, 1, 'bottom', 0, '资讯中心', 'project', 43, 0, 0, '', 0, 0, 20, 1, ''),
(17, 1, 'bottom', 0, '在线留言', 'project', 96, 0, 0, '', 0, 0, 25, 1, ''),
(20, 1, 'footnav', 0, '', 'content', 451, 0, 41, '', 0, 0, 5, 1, ''),
(21, 1, 'footnav', 0, '', 'content', 451, 0, 42, '', 0, 0, 10, 1, ''),
(22, 1, 'footnav', 0, '开源PHPOK', 'link', 0, 0, 0, 'https://github.com/qinggan/phpok', 1, 0, 15, 1, ''),
(25, 1, 'topnav', 0, '', 'project', 454, 0, 0, '', 0, 0, 5, 1, ''),
(28, 1, 'bottom', 0, '', 'project', 452, 0, 0, '', 0, 0, 30, 1, '');

CREATE TABLE IF NOT EXISTS `qinggan_module` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `title` varchar(255) NOT NULL COMMENT '模块名称',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不使用1使用',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '模块排序',
  `note` varchar(255) NOT NULL COMMENT '模块说明',
  `layout` text NOT NULL COMMENT '布局',
  `mtype` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0联合模块，1独立模块',
  `tbl` varchar(255) NOT NULL DEFAULT 'list' COMMENT '关联主表',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='模块管理，每创建一个模块自动创建一个表' AUTO_INCREMENT=114 ;

INSERT INTO `qinggan_module` (`id`, `title`, `status`, `taxis`, `note`, `layout`, `mtype`, `tbl`) VALUES
(21, '图片轮播', 1, 20, '适用于图片播放器，图片友情链接', 'sort,banner,picmobile,link,target', 0, 'list'),
(22, '文章资讯', 1, 10, '适用于新闻，文章之类', 'hits,dateline,sort,thumb', 0, 'list'),
(24, '产品', 1, 40, '适用于电子商务中产品展示模型', 'hits,dateline,sort,thumb', 0, 'list'),
(40, '单页信息', 1, 60, '适用于公司简介，联系我们', 'hits,dateline,sort', 0, 'list'),
(46, '留言模块', 1, 90, '', 'dateline,sort,fullname,email,content', 0, 'list'),
(64, '客服', 1, 110, '', 'sort,qtype,qq,weixin', 0, 'list'),
(65, '资源下载', 1, 70, '', 'dateline,sort,fsize,version,onlyuser,thumb', 0, 'list'),
(66, '论坛BBS', 1, 50, '', 'hits,dateline,user_id,toplevel,thumb', 0, 'list'),
(68, '图集相册', 1, 80, '', 'hits,dateline,sort,thumb', 0, 'list'),
(77, '友情链接', 1, 145, '', 'sitename,linkurl,target,logo,tel', 1, 'list'),
(110, '独立页', 1, 155, '', 'hits,banner,note', 0, 'list'),
(111, '视频', 1, 160, '适合接入各个平台的视频链接', 'hits,dateline,sort', 0, 'list'),
(112, '专题设计', 1, 165, '', 'hits,dateline,thumb', 0, 'list');

CREATE TABLE IF NOT EXISTS `qinggan_opt` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `group_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '组ID',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID',
  `title` varchar(255) NOT NULL COMMENT '名称',
  `val` varchar(255) NOT NULL COMMENT '值',
  `taxis` int(10) unsigned NOT NULL DEFAULT '255' COMMENT '排序，值越小越往前靠',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='表单列表选项' AUTO_INCREMENT=15137 ;

INSERT INTO `qinggan_opt` (`id`, `group_id`, `parent_id`, `title`, `val`, `taxis`) VALUES
(1, 1, 0, '未设置', '0', 30),
(2, 1, 0, '男', '1', 10),
(17, 4, 0, '是', '1', 10),
(18, 4, 0, '否', '0', 20),
(21, 6, 0, '当前窗口', '_self', 10),
(22, 6, 0, '新窗口', '_blank', 20),
(23, 7, 0, '启用', '1', 10),
(24, 7, 0, '禁用', '', 20),
(25, 8, 0, 'UTF-8', 'utf8', 20),
(26, 8, 0, 'GBK', 'gbk', 10),
(62, 12, 0, '不置顶', '0', 10),
(63, 12, 0, '一级置顶', '1', 20),
(64, 12, 0, '二级置顶', '2', 30),
(65, 13, 0, '三分钟', '180', 10),
(66, 14, 0, '点击推事件', 'click', 10),
(67, 14, 0, '跳转链接', 'view', 20),
(10147, 19, 0, '北京市', '北京市', 5),
(10148, 19, 10147, '朝阳区', '朝阳区', 5),
(10149, 19, 10148, '三环到四环之间', '三环到四环之间', 5),
(10150, 19, 10148, '四环到五环之间', '四环到五环之间', 10),
(10151, 19, 10148, '五环到六环之间', '五环到六环之间', 15),
(10152, 19, 10148, '管庄', '管庄', 20),
(10153, 19, 10148, '北苑', '北苑', 25),
(10154, 19, 10148, '定福庄', '定福庄', 30),
(10155, 19, 10148, '三环以内', '三环以内', 35),
(10156, 19, 10147, '海淀区', '海淀区', 10),
(10157, 19, 10156, '三环以内', '三环以内', 5),
(10158, 19, 10156, '三环到四环之间', '三环到四环之间', 10),
(10159, 19, 10156, '四环到五环之间', '四环到五环之间', 15),
(10160, 19, 10156, '五环到六环之间', '五环到六环之间', 20),
(10161, 19, 10156, '六环以外', '六环以外', 25),
(10162, 19, 10156, '西三旗', '西三旗', 30),
(10163, 19, 10156, '西二旗', '西二旗', 35),
(10164, 19, 10147, '西城区', '西城区', 15),
(10165, 19, 10164, '内环到二环里', '内环到二环里', 5),
(10166, 19, 10164, '二环到三环', '二环到三环', 10),
(10167, 19, 10147, '东城区', '东城区', 20),
(10168, 19, 10167, '内环到三环里', '内环到三环里', 5),
(10169, 19, 10147, '崇文区', '崇文区', 25),
(10170, 19, 10169, '一环到二环', '一环到二环', 5),
(10171, 19, 10169, '二环到三环', '二环到三环', 10),
(10172, 19, 10147, '宣武区', '宣武区', 30),
(10173, 19, 10172, '内环到三环里', '内环到三环里', 5),
(10174, 19, 10147, '丰台区', '丰台区', 35),
(10175, 19, 10174, '四环到五环之间', '四环到五环之间', 5),
(10176, 19, 10174, '二环到三环', '二环到三环', 10),
(10177, 19, 10174, '三环到四环之间', '三环到四环之间', 15),
(10178, 19, 10174, '五环到六环之间', '五环到六环之间', 20),
(10179, 19, 10174, '六环之外', '六环之外', 25),
(10180, 19, 10147, '石景山区', '石景山区', 40),
(10181, 19, 10180, '四环到五环内', '四环到五环内', 5),
(10182, 19, 10180, '石景山城区', '石景山城区', 10),
(10183, 19, 10180, '八大处科技园区', '八大处科技园区', 15),
(10184, 19, 10147, '门头沟', '门头沟', 45),
(10185, 19, 10184, '城区', '城区', 5),
(10186, 19, 10184, '龙泉镇', '龙泉镇', 10),
(10187, 19, 10184, '永定镇', '永定镇', 15),
(10188, 19, 10184, '大台镇', '大台镇', 20),
(10189, 19, 10184, '潭柘寺镇', '潭柘寺镇', 25),
(10190, 19, 10184, '王平镇', '王平镇', 30),
(10191, 19, 10184, '军庄镇', '军庄镇', 35),
(10192, 19, 10184, '妙峰山镇', '妙峰山镇', 40),
(10193, 19, 10184, '雁翅镇', '雁翅镇', 45),
(10194, 19, 10184, '斋堂镇', '斋堂镇', 50),
(10195, 19, 10184, '清水镇', '清水镇', 55),
(10196, 19, 10147, '房山区', '房山区', 50),
(10197, 19, 10196, '城区', '城区', 5),
(10198, 19, 10196, '大安山乡', '大安山乡', 10),
(10199, 19, 10196, '大石窝镇', '大石窝镇', 15),
(10200, 19, 10196, '窦店镇', '窦店镇', 20),
(10201, 19, 10196, '佛子庄乡', '佛子庄乡', 25),
(10202, 19, 10196, '韩村河镇', '韩村河镇', 30),
(10203, 19, 10196, '河北镇', '河北镇', 35),
(10204, 19, 10196, '良乡镇', '良乡镇', 40),
(10205, 19, 10196, '琉璃河镇', '琉璃河镇', 45),
(10206, 19, 10196, '南窖乡', '南窖乡', 50),
(10207, 19, 10196, '蒲洼乡', '蒲洼乡', 55),
(10208, 19, 10196, '青龙湖镇', '青龙湖镇', 60),
(10209, 19, 10196, '十渡镇', '十渡镇', 65),
(10210, 19, 10196, '石楼镇', '石楼镇', 70),
(10211, 19, 10196, '史家营乡', '史家营乡', 75),
(10212, 19, 10196, '霞云岭乡', '霞云岭乡', 80),
(10213, 19, 10196, '新镇', '新镇', 85),
(10214, 19, 10196, '阎村镇', '阎村镇', 90),
(10215, 19, 10196, '燕山地区', '燕山地区', 95),
(10216, 19, 10196, '张坊镇', '张坊镇', 100),
(10217, 19, 10196, '长沟镇', '长沟镇', 105),
(10218, 19, 10196, '长阳镇', '长阳镇', 110),
(10219, 19, 10196, '周口店镇', '周口店镇', 115),
(10220, 19, 10147, '通州区', '通州区', 55),
(10221, 19, 10220, '六环内（马驹桥镇）', '六环内（马驹桥镇）', 5),
(10222, 19, 10220, '中仓街道', '中仓街道', 10),
(10223, 19, 10220, '新华街道', '新华街道', 15),
(10224, 19, 10220, '玉桥街道', '玉桥街道', 20),
(10225, 19, 10220, '北苑街道', '北苑街道', 25),
(10226, 19, 10220, '六环外（马驹桥镇）', '六环外（马驹桥镇）', 30),
(10227, 19, 10220, '永顺镇', '永顺镇', 35),
(10228, 19, 10220, '梨园镇', '梨园镇', 40),
(10229, 19, 10220, '宋庄镇', '宋庄镇', 45),
(10230, 19, 10220, '漷县镇', '漷县镇', 50),
(10231, 19, 10220, '张家湾镇', '张家湾镇', 55),
(10232, 19, 10220, '西集镇', '西集镇', 60),
(10233, 19, 10220, '永乐店镇', '永乐店镇', 65),
(10234, 19, 10220, '潞城镇', '潞城镇', 70),
(10235, 19, 10220, '台湖镇', '台湖镇', 75),
(10236, 19, 10220, '于家务乡', '于家务乡', 80),
(10237, 19, 10220, '次渠镇', '次渠镇', 85),
(10238, 19, 10147, '大兴区', '大兴区', 60),
(10239, 19, 10238, '四环至五环之间', '四环至五环之间', 5),
(10240, 19, 10238, '五环至六环之间', '五环至六环之间', 10),
(10241, 19, 10238, '六环以外', '六环以外', 15),
(10242, 19, 10238, '亦庄经济开发区', '亦庄经济开发区', 20),
(10243, 19, 10147, '顺义区', '顺义区', 65),
(10244, 19, 10243, '北石槽镇', '北石槽镇', 5),
(10245, 19, 10243, '北务镇', '北务镇', 10),
(10246, 19, 10243, '北小营镇', '北小营镇', 15),
(10247, 19, 10243, '大孙各庄镇', '大孙各庄镇', 20),
(10248, 19, 10243, '高丽营镇', '高丽营镇', 25),
(10249, 19, 10243, '光明街道', '光明街道', 30),
(10250, 19, 10243, '后沙峪地区', '后沙峪地区', 35),
(10251, 19, 10243, '空港街道', '空港街道', 40),
(10252, 19, 10243, '李桥镇', '李桥镇', 45),
(10253, 19, 10243, '李遂镇', '李遂镇', 50),
(10254, 19, 10243, '龙湾屯镇', '龙湾屯镇', 55),
(10255, 19, 10243, '马坡地区', '马坡地区', 60),
(10256, 19, 10243, '木林镇', '木林镇', 65),
(10257, 19, 10243, '南彩镇', '南彩镇', 70),
(10258, 19, 10243, '南法信地区', '南法信地区', 75),
(10259, 19, 10243, '牛栏山地区', '牛栏山地区', 80),
(10260, 19, 10243, '仁和地区', '仁和地区', 85),
(10261, 19, 10243, '胜利街道', '胜利街道', 90),
(10262, 19, 10243, '石园街道', '石园街道', 95),
(10263, 19, 10243, '双丰街道', '双丰街道', 100),
(10264, 19, 10243, '天竺地区', '天竺地区', 105),
(10265, 19, 10243, '旺泉街道', '旺泉街道', 110),
(10266, 19, 10243, '杨镇地区', '杨镇地区', 115),
(10267, 19, 10243, '张镇', '张镇', 120),
(10268, 19, 10243, '赵全营镇', '赵全营镇', 125),
(10269, 19, 10147, '怀柔区', '怀柔区', 70),
(10270, 19, 10269, '城区以内', '城区以内', 5),
(10271, 19, 10269, '郊区', '郊区', 10),
(10272, 19, 10147, '密云区', '密云区', 75),
(10273, 19, 10272, '城区', '城区', 5),
(10274, 19, 10272, '城区以外', '城区以外', 10),
(10275, 19, 10147, '昌平区', '昌平区', 80),
(10276, 19, 10275, '六环以内', '六环以内', 5),
(10277, 19, 10275, '城区', '城区', 10),
(10278, 19, 10275, '城区以外', '城区以外', 15),
(10279, 19, 10147, '平谷区', '平谷区', 85),
(10280, 19, 10279, '城区', '城区', 5),
(10281, 19, 10279, '城区以外', '城区以外', 10),
(10282, 19, 10147, '延庆县', '延庆县', 90),
(10283, 19, 10282, '延庆镇', '延庆镇', 5),
(10284, 19, 10282, '城区', '城区', 10),
(10285, 19, 10282, '康庄镇', '康庄镇', 15),
(10286, 19, 10282, '八达岭镇', '八达岭镇', 20),
(10287, 19, 10282, '永宁镇', '永宁镇', 25),
(10288, 19, 10282, '旧县镇', '旧县镇', 30),
(10289, 19, 10282, '张山营镇', '张山营镇', 35),
(10290, 19, 10282, '四海镇', '四海镇', 40),
(10291, 19, 10282, '千家店镇', '千家店镇', 45),
(10292, 19, 10282, '沈家营镇', '沈家营镇', 50),
(10293, 19, 10282, '大榆树镇', '大榆树镇', 55),
(10294, 19, 10282, '井庄镇', '井庄镇', 60),
(10295, 19, 10282, '大庄科乡', '大庄科乡', 65),
(10296, 19, 10282, '刘斌堡乡', '刘斌堡乡', 70),
(10297, 19, 10282, '香营乡', '香营乡', 75),
(10298, 19, 10282, '珍珠泉乡', '珍珠泉乡', 80),
(10299, 19, 0, '上海市', '上海市', 10),
(10300, 19, 10299, '黄浦区', '黄浦区', 5),
(10301, 19, 10299, '徐汇区', '徐汇区', 10),
(10302, 19, 10299, '长宁区', '长宁区', 15),
(10303, 19, 10299, '静安区', '静安区', 20),
(10304, 19, 10299, '闸北区', '闸北区', 25),
(10305, 19, 10299, '虹口区', '虹口区', 30),
(10306, 19, 10299, '杨浦区', '杨浦区', 35),
(10307, 19, 10299, '宝山区', '宝山区', 40),
(10308, 19, 10307, '罗店镇', '罗店镇', 5),
(10309, 19, 10307, '城区', '城区', 10),
(10310, 19, 10307, '大场镇', '大场镇', 15),
(10311, 19, 10307, '杨行镇', '杨行镇', 20),
(10312, 19, 10307, '月浦镇', '月浦镇', 25),
(10313, 19, 10307, '罗泾镇', '罗泾镇', 30),
(10314, 19, 10307, '顾村镇', '顾村镇', 35),
(10315, 19, 10307, '高境镇', '高境镇', 40),
(10316, 19, 10307, '庙行镇', '庙行镇', 45),
(10317, 19, 10307, '淞南镇', '淞南镇', 50),
(10318, 19, 10307, '宝山城市工业园区', '宝山城市工业园区', 55),
(10319, 19, 10299, '闵行区', '闵行区', 45),
(10320, 19, 10319, '城区', '城区', 5),
(10321, 19, 10319, '莘庄镇', '莘庄镇', 10),
(10322, 19, 10319, '七宝镇', '七宝镇', 15),
(10323, 19, 10319, '浦江镇', '浦江镇', 20),
(10324, 19, 10319, '梅陇镇', '梅陇镇', 25),
(10325, 19, 10319, '虹桥镇', '虹桥镇', 30),
(10326, 19, 10319, '马桥镇', '马桥镇', 35),
(10327, 19, 10319, '吴泾镇', '吴泾镇', 40),
(10328, 19, 10319, '华漕镇', '华漕镇', 45),
(10329, 19, 10319, '颛桥镇', '颛桥镇', 50),
(10330, 19, 10299, '嘉定区', '嘉定区', 50),
(10331, 19, 10330, '城区', '城区', 5),
(10332, 19, 10330, '南翔镇', '南翔镇', 10),
(10333, 19, 10330, '马陆镇', '马陆镇', 15),
(10334, 19, 10330, '华亭镇', '华亭镇', 20),
(10335, 19, 10330, '江桥镇', '江桥镇', 25),
(10336, 19, 10330, '菊园新区', '菊园新区', 30),
(10337, 19, 10330, '安亭镇', '安亭镇', 35),
(10338, 19, 10330, '徐行镇', '徐行镇', 40),
(10339, 19, 10330, '外冈镇', '外冈镇', 45),
(10340, 19, 10330, '嘉定工业区', '嘉定工业区', 50),
(10341, 19, 10299, '浦东新区', '浦东新区', 55),
(10342, 19, 10341, '城区', '城区', 5),
(10343, 19, 10341, '川沙新镇', '川沙新镇', 10),
(10344, 19, 10341, '祝桥镇', '祝桥镇', 15),
(10345, 19, 10341, '新场镇', '新场镇', 20),
(10346, 19, 10341, '高桥镇', '高桥镇', 25),
(10347, 19, 10341, '惠南镇', '惠南镇', 30),
(10348, 19, 10341, '北蔡镇', '北蔡镇', 35),
(10349, 19, 10341, '合庆镇', '合庆镇', 40),
(10350, 19, 10341, '唐镇', '唐镇', 45),
(10351, 19, 10341, '曹路镇', '曹路镇', 50),
(10352, 19, 10341, '金桥镇', '金桥镇', 55),
(10353, 19, 10341, '高行镇', '高行镇', 60),
(10354, 19, 10341, '高东镇', '高东镇', 65),
(10355, 19, 10341, '张江镇', '张江镇', 70),
(10356, 19, 10341, '三林镇', '三林镇', 75),
(10357, 19, 10341, '南汇新城镇', '南汇新城镇', 80),
(10358, 19, 10341, '康桥镇', '康桥镇', 85),
(10359, 19, 10341, '宣桥镇', '宣桥镇', 90),
(10360, 19, 10341, '书院镇', '书院镇', 95),
(10361, 19, 10341, '大团镇', '大团镇', 100),
(10362, 19, 10341, '周浦镇', '周浦镇', 105),
(10363, 19, 10341, '芦潮港镇', '芦潮港镇', 110),
(10364, 19, 10341, '泥城镇', '泥城镇', 115),
(10365, 19, 10341, '航头镇', '航头镇', 120),
(10366, 19, 10341, '万祥镇', '万祥镇', 125),
(10367, 19, 10341, '老港镇', '老港镇', 130),
(10368, 19, 10299, '青浦区', '青浦区', 60),
(10369, 19, 10368, '城区', '城区', 5),
(10370, 19, 10368, '赵巷镇', '赵巷镇', 10),
(10371, 19, 10368, '徐泾镇', '徐泾镇', 15),
(10372, 19, 10368, '华新镇', '华新镇', 20),
(10373, 19, 10368, '重固镇', '重固镇', 25),
(10374, 19, 10368, '白鹤镇', '白鹤镇', 30),
(10375, 19, 10368, '练塘镇', '练塘镇', 35),
(10376, 19, 10368, '金泽镇', '金泽镇', 40),
(10377, 19, 10368, '朱家角镇', '朱家角镇', 45),
(10378, 19, 10299, '松江区', '松江区', 65),
(10379, 19, 10378, '城区', '城区', 5),
(10380, 19, 10378, '泗泾镇', '泗泾镇', 10),
(10381, 19, 10378, '佘山镇', '佘山镇', 15),
(10382, 19, 10378, '车墩镇', '车墩镇', 20),
(10383, 19, 10378, '新桥镇', '新桥镇', 25),
(10384, 19, 10378, '洞泾镇', '洞泾镇', 30),
(10385, 19, 10378, '九亭镇', '九亭镇', 35),
(10386, 19, 10378, '泖港镇', '泖港镇', 40),
(10387, 19, 10378, '石湖荡镇', '石湖荡镇', 45),
(10388, 19, 10378, '新浜镇', '新浜镇', 50),
(10389, 19, 10378, '叶榭镇', '叶榭镇', 55),
(10390, 19, 10378, '小昆山镇', '小昆山镇', 60),
(10391, 19, 10299, '金山区', '金山区', 70),
(10392, 19, 10391, '城区', '城区', 5),
(10393, 19, 10391, '金山工业区', '金山工业区', 10),
(10394, 19, 10391, '朱泾镇', '朱泾镇', 15),
(10395, 19, 10391, '枫泾镇', '枫泾镇', 20),
(10396, 19, 10391, '张堰镇', '张堰镇', 25),
(10397, 19, 10391, '亭林镇', '亭林镇', 30),
(10398, 19, 10391, '吕巷镇', '吕巷镇', 35),
(10399, 19, 10391, '廊下镇', '廊下镇', 40),
(10400, 19, 10391, '金山卫镇', '金山卫镇', 45),
(10401, 19, 10391, '漕泾镇', '漕泾镇', 50),
(10402, 19, 10391, '山阳镇', '山阳镇', 55),
(10403, 19, 10299, '奉贤区', '奉贤区', 75),
(10404, 19, 10403, '南桥镇', '南桥镇', 5),
(10405, 19, 10403, '奉城镇', '奉城镇', 10),
(10406, 19, 10403, '四团镇', '四团镇', 15),
(10407, 19, 10403, '柘林镇', '柘林镇', 20),
(10408, 19, 10403, '庄行镇', '庄行镇', 25),
(10409, 19, 10403, '金汇镇', '金汇镇', 30),
(10410, 19, 10403, '青村镇', '青村镇', 35),
(10411, 19, 10403, '海湾镇', '海湾镇', 40),
(10412, 19, 10299, '普陀区', '普陀区', 80),
(10413, 19, 10299, '崇明县', '崇明县', 85),
(10414, 19, 10413, '堡镇', '堡镇', 5),
(10415, 19, 10413, '庙镇', '庙镇', 10),
(10416, 19, 10413, '陈家镇', '陈家镇', 15),
(10417, 19, 10413, '城桥镇', '城桥镇', 20),
(10418, 19, 10413, '东平镇', '东平镇', 25),
(10419, 19, 10413, '港西镇', '港西镇', 30),
(10420, 19, 10413, '港沿镇', '港沿镇', 35),
(10421, 19, 10413, '建设镇', '建设镇', 40),
(10422, 19, 10413, '绿华镇', '绿华镇', 45),
(10423, 19, 10413, '三星镇', '三星镇', 50),
(10424, 19, 10413, '竖新镇', '竖新镇', 55),
(10425, 19, 10413, '向化镇', '向化镇', 60),
(10426, 19, 10413, '新海镇', '新海镇', 65),
(10427, 19, 10413, '新河镇', '新河镇', 70),
(10428, 19, 10413, '中兴镇', '中兴镇', 75),
(10429, 19, 10413, '长兴乡', '长兴乡', 80),
(10430, 19, 10413, '横沙乡', '横沙乡', 85),
(10431, 19, 10413, '新村乡', '新村乡', 90),
(10432, 19, 0, '天津市', '天津市', 15),
(10433, 19, 10432, '东丽区', '东丽区', 5),
(10434, 19, 10432, '和平区', '和平区', 10),
(10435, 19, 10432, '河北区', '河北区', 15),
(10436, 19, 10432, '河东区', '河东区', 20),
(10437, 19, 10432, '河西区', '河西区', 25),
(10438, 19, 10432, '红桥区', '红桥区', 30),
(10439, 19, 10432, '蓟县', '蓟县', 35),
(10440, 19, 10432, '静海县', '静海县', 40),
(10441, 19, 10432, '南开区', '南开区', 45),
(10442, 19, 10432, '塘沽区', '塘沽区', 50),
(10443, 19, 10432, '西青区', '西青区', 55),
(10444, 19, 10443, '杨柳青,中北,精武,大寺镇,环外海泰及外环内', '杨柳青,中北,精武,大寺镇,环外海泰及外环内', 5),
(10445, 19, 10443, '其它地区', '其它地区', 10),
(10446, 19, 10432, '武清区', '武清区', 60),
(10447, 19, 10446, '杨村镇、下朱庄内', '杨村镇、下朱庄内', 5),
(10448, 19, 10446, '其它地区', '其它地区', 10),
(10449, 19, 10432, '津南区', '津南区', 65),
(10450, 19, 10449, '双港，辛庄', '双港，辛庄', 5),
(10451, 19, 10449, '咸水沽镇、海河教育园，海河科技园', '咸水沽镇、海河教育园，海河科技园', 10),
(10452, 19, 10449, '其他地区', '其他地区', 15),
(10453, 19, 10432, '汉沽区', '汉沽区', 70),
(10454, 19, 10453, '汉沽区街里、汉沽开发区', '汉沽区街里、汉沽开发区', 5),
(10455, 19, 10453, '其它地区', '其它地区', 10),
(10456, 19, 10432, '大港区', '大港区', 75),
(10457, 19, 10456, '大港油田', '大港油田', 5),
(10458, 19, 10456, '主城区内', '主城区内', 10),
(10459, 19, 10456, '主城区外', '主城区外', 15),
(10460, 19, 10432, '北辰区', '北辰区', 80),
(10461, 19, 10460, '外环外双街镇，河北工大新校，屈店工业园', '外环外双街镇，河北工大新校，屈店工业园', 5),
(10462, 19, 10460, '外环内', '外环内', 10),
(10463, 19, 10460, '外环外其它地区', '外环外其它地区', 15),
(10464, 19, 10432, '宝坻区', '宝坻区', 85),
(10465, 19, 10464, '城关镇、马家店开发区、天宝工业园', '城关镇、马家店开发区、天宝工业园', 5),
(10466, 19, 10464, '其它地区', '其它地区', 10),
(10467, 19, 10432, '宁河县', '宁河县', 90),
(10468, 19, 10467, '芦台镇、经济开发区、贸易开发区', '芦台镇、经济开发区、贸易开发区', 5),
(10469, 19, 10467, '其它地区', '其它地区', 10),
(10470, 19, 0, '重庆市', '重庆市', 20),
(10471, 19, 10470, '万州区', '万州区', 5),
(10472, 19, 10471, '城区', '城区', 5),
(10473, 19, 10471, '白土镇', '白土镇', 10),
(10474, 19, 10471, '白羊镇', '白羊镇', 15),
(10475, 19, 10471, '大周镇', '大周镇', 20),
(10476, 19, 10471, '弹子镇', '弹子镇', 25),
(10477, 19, 10471, '分水镇', '分水镇', 30),
(10478, 19, 10471, '甘宁镇', '甘宁镇', 35),
(10479, 19, 10471, '高峰镇', '高峰镇', 40),
(10480, 19, 10471, '高梁镇', '高梁镇', 45),
(10481, 19, 10471, '后山镇', '后山镇', 50),
(10482, 19, 10471, '李河镇', '李河镇', 55),
(10483, 19, 10471, '龙驹镇', '龙驹镇', 60),
(10484, 19, 10471, '龙沙镇', '龙沙镇', 65),
(10485, 19, 10471, '罗田镇', '罗田镇', 70),
(10486, 19, 10471, '孙家镇', '孙家镇', 75),
(10487, 19, 10471, '太安镇', '太安镇', 80),
(10488, 19, 10471, '太龙镇', '太龙镇', 85),
(10489, 19, 10471, '天城镇', '天城镇', 90),
(10490, 19, 10471, '武陵镇', '武陵镇', 95),
(10491, 19, 10471, '响水镇', '响水镇', 100),
(10492, 19, 10471, '小周镇', '小周镇', 105),
(10493, 19, 10471, '新田镇', '新田镇', 110),
(10494, 19, 10471, '新乡镇', '新乡镇', 115),
(10495, 19, 10471, '熊家镇', '熊家镇', 120),
(10496, 19, 10471, '余家镇', '余家镇', 125),
(10497, 19, 10471, '长岭镇', '长岭镇', 130),
(10498, 19, 10471, '长坪镇', '长坪镇', 135),
(10499, 19, 10471, '长滩镇', '长滩镇', 140),
(10500, 19, 10471, '走马镇', '走马镇', 145),
(10501, 19, 10471, '瀼渡镇', '瀼渡镇', 150),
(10502, 19, 10471, '茨竹乡', '茨竹乡', 155),
(10503, 19, 10471, '柱山乡', '柱山乡', 160),
(10504, 19, 10471, '燕山乡', '燕山乡', 165),
(10505, 19, 10471, '溪口乡', '溪口乡', 170),
(10506, 19, 10471, '普子乡', '普子乡', 175),
(10507, 19, 10471, '地宝乡', '地宝乡', 180),
(10508, 19, 10471, '铁峰乡', '铁峰乡', 185),
(10509, 19, 10471, '黄柏乡', '黄柏乡', 190),
(10510, 19, 10471, '九池乡', '九池乡', 195),
(10511, 19, 10471, '梨树乡', '梨树乡', 200),
(10512, 19, 10471, '郭村乡', '郭村乡', 205),
(10513, 19, 10471, '恒合乡', '恒合乡', 210),
(10514, 19, 10470, '涪陵区', '涪陵区', 10),
(10515, 19, 10514, '城区', '城区', 5),
(10516, 19, 10514, '李渡镇', '李渡镇', 10),
(10517, 19, 10514, '白涛镇', '白涛镇', 15),
(10518, 19, 10514, '百胜镇', '百胜镇', 20),
(10519, 19, 10514, '堡子镇', '堡子镇', 25),
(10520, 19, 10514, '焦石镇', '焦石镇', 30),
(10521, 19, 10514, '蔺市镇', '蔺市镇', 35),
(10522, 19, 10514, '龙桥镇', '龙桥镇', 40),
(10523, 19, 10514, '龙潭镇', '龙潭镇', 45),
(10524, 19, 10514, '马武镇', '马武镇', 50),
(10525, 19, 10514, '南沱镇', '南沱镇', 55),
(10526, 19, 10514, '青羊镇', '青羊镇', 60),
(10527, 19, 10514, '清溪镇', '清溪镇', 65),
(10528, 19, 10514, '石沱镇', '石沱镇', 70),
(10529, 19, 10514, '新妙镇', '新妙镇', 75),
(10530, 19, 10514, '义和镇', '义和镇', 80),
(10531, 19, 10514, '增福乡', '增福乡', 85),
(10532, 19, 10514, '珍溪镇', '珍溪镇', 90),
(10533, 19, 10514, '镇安镇', '镇安镇', 95),
(10534, 19, 10514, '致韩镇', '致韩镇', 100),
(10535, 19, 10514, '土地坡乡', '土地坡乡', 105),
(10536, 19, 10514, '武陵山乡', '武陵山乡', 110),
(10537, 19, 10514, '中峰乡', '中峰乡', 115),
(10538, 19, 10514, '梓里乡', '梓里乡', 120),
(10539, 19, 10514, '丛林乡', '丛林乡', 125),
(10540, 19, 10514, '大木乡', '大木乡', 130),
(10541, 19, 10514, '惠民乡', '惠民乡', 135),
(10542, 19, 10514, '酒店乡', '酒店乡', 140),
(10543, 19, 10514, '聚宝乡', '聚宝乡', 145),
(10544, 19, 10514, '卷洞乡', '卷洞乡', 150),
(10545, 19, 10514, '两汇乡', '两汇乡', 155),
(10546, 19, 10514, '罗云乡', '罗云乡', 160),
(10547, 19, 10514, '明家乡', '明家乡', 165),
(10548, 19, 10514, '仁义乡', '仁义乡', 170),
(10549, 19, 10514, '山窝乡', '山窝乡', 175),
(10550, 19, 10514, '石和乡', '石和乡', 180),
(10551, 19, 10514, '石龙乡', '石龙乡', 185),
(10552, 19, 10514, '太和乡', '太和乡', 190),
(10553, 19, 10514, '天台乡', '天台乡', 195),
(10554, 19, 10514, '同乐乡', '同乐乡', 200),
(10555, 19, 10514, '新村乡', '新村乡', 205),
(10556, 19, 10470, '梁平县', '梁平县', 15),
(10557, 19, 10556, '县城内', '县城内', 5),
(10558, 19, 10556, '梁山镇', '梁山镇', 10),
(10559, 19, 10556, '柏家镇', '柏家镇', 15),
(10560, 19, 10556, '碧山镇', '碧山镇', 20),
(10561, 19, 10556, '大观镇', '大观镇', 25),
(10562, 19, 10556, '福禄镇', '福禄镇', 30),
(10563, 19, 10556, '合兴镇', '合兴镇', 35),
(10564, 19, 10556, '和林镇', '和林镇', 40),
(10565, 19, 10556, '虎城镇', '虎城镇', 45),
(10566, 19, 10556, '回龙镇', '回龙镇', 50),
(10567, 19, 10556, '金带镇', '金带镇', 55),
(10568, 19, 10556, '聚奎镇', '聚奎镇', 60),
(10569, 19, 10556, '礼让镇', '礼让镇', 65),
(10570, 19, 10556, '龙门镇', '龙门镇', 70),
(10571, 19, 10556, '明达镇', '明达镇', 75),
(10572, 19, 10556, '蟠龙镇', '蟠龙镇', 80),
(10573, 19, 10556, '屏锦镇', '屏锦镇', 85),
(10574, 19, 10556, '仁贤镇', '仁贤镇', 90),
(10575, 19, 10556, '石安镇', '石安镇', 95),
(10576, 19, 10556, '文化镇', '文化镇', 100),
(10577, 19, 10556, '新盛镇', '新盛镇', 105),
(10578, 19, 10556, '荫平镇', '荫平镇', 110),
(10579, 19, 10556, '袁驿镇', '袁驿镇', 115),
(10580, 19, 10556, '云龙镇', '云龙镇', 120),
(10581, 19, 10556, '竹山镇', '竹山镇', 125),
(10582, 19, 10556, '安胜乡', '安胜乡', 130),
(10583, 19, 10556, '铁门乡', '铁门乡', 135),
(10584, 19, 10556, '紫照乡', '紫照乡', 140),
(10585, 19, 10556, '曲水乡', '曲水乡', 145),
(10586, 19, 10556, '龙胜乡', '龙胜乡', 150),
(10587, 19, 10556, '城北乡', '城北乡', 155),
(10588, 19, 10556, '城东乡', '城东乡', 160),
(10589, 19, 10556, '复平乡', '复平乡', 165),
(10590, 19, 10470, '南川区', '南川区', 20),
(10591, 19, 10590, '城区', '城区', 5),
(10592, 19, 10590, '头渡镇', '头渡镇', 10),
(10593, 19, 10590, '兴隆镇', '兴隆镇', 15),
(10594, 19, 10590, '冷水关乡', '冷水关乡', 20),
(10595, 19, 10590, '德隆乡', '德隆乡', 25),
(10596, 19, 10590, '峰岩乡', '峰岩乡', 30),
(10597, 19, 10590, '福寿乡', '福寿乡', 35),
(10598, 19, 10590, '古花乡', '古花乡', 40),
(10599, 19, 10590, '河图乡', '河图乡', 45),
(10600, 19, 10590, '民主乡', '民主乡', 50),
(10601, 19, 10590, '木凉乡', '木凉乡', 55),
(10602, 19, 10590, '乾丰乡', '乾丰乡', 60),
(10603, 19, 10590, '庆元乡', '庆元乡', 65),
(10604, 19, 10590, '石莲乡', '石莲乡', 70),
(10605, 19, 10590, '石溪乡', '石溪乡', 75),
(10606, 19, 10590, '铁村乡', '铁村乡', 80),
(10607, 19, 10590, '土溪乡', '土溪乡', 85),
(10608, 19, 10590, '鱼泉乡', '鱼泉乡', 90),
(10609, 19, 10590, '中桥乡', '中桥乡', 95),
(10610, 19, 10590, '太平场镇', '太平场镇', 100),
(10611, 19, 10590, '大观镇', '大观镇', 105),
(10612, 19, 10590, '大有镇', '大有镇', 110),
(10613, 19, 10590, '合溪镇', '合溪镇', 115),
(10614, 19, 10590, '金山镇', '金山镇', 120),
(10615, 19, 10590, '鸣玉镇', '鸣玉镇', 125),
(10616, 19, 10590, '南平镇', '南平镇', 130),
(10617, 19, 10590, '三泉镇', '三泉镇', 135),
(10618, 19, 10590, '神童镇', '神童镇', 140),
(10619, 19, 10590, '石墙镇', '石墙镇', 145),
(10620, 19, 10590, '水江镇', '水江镇', 150),
(10621, 19, 10470, '潼南县', '潼南县', 25),
(10622, 19, 10621, '县城内', '县城内', 5),
(10623, 19, 10621, '柏梓镇', '柏梓镇', 10),
(10624, 19, 10621, '宝龙镇', '宝龙镇', 15),
(10625, 19, 10621, '崇龛镇', '崇龛镇', 20),
(10626, 19, 10621, '古溪镇', '古溪镇', 25),
(10627, 19, 10621, '龙形镇', '龙形镇', 30),
(10628, 19, 10621, '米心镇', '米心镇', 35),
(10629, 19, 10621, '群力镇', '群力镇', 40),
(10630, 19, 10621, '上和镇', '上和镇', 45),
(10631, 19, 10621, '双江镇', '双江镇', 50),
(10632, 19, 10621, '太安镇', '太安镇', 55),
(10633, 19, 10621, '塘坝镇', '塘坝镇', 60),
(10634, 19, 10621, '卧佛镇', '卧佛镇', 65),
(10635, 19, 10621, '五桂镇', '五桂镇', 70),
(10636, 19, 10621, '小渡镇', '小渡镇', 75),
(10637, 19, 10621, '新胜镇', '新胜镇', 80),
(10638, 19, 10621, '玉溪镇', '玉溪镇', 85),
(10639, 19, 10621, '别口乡', '别口乡', 90),
(10640, 19, 10621, '田家乡', '田家乡', 95),
(10641, 19, 10621, '寿桥乡', '寿桥乡', 100),
(10642, 19, 10470, '大足区', '大足区', 30),
(10643, 19, 10642, '城区', '城区', 5),
(10644, 19, 10642, '龙滩子镇', '龙滩子镇', 10),
(10645, 19, 10642, '龙水镇', '龙水镇', 15),
(10646, 19, 10642, '智凤镇', '智凤镇', 20),
(10647, 19, 10642, '宝顶镇', '宝顶镇', 25),
(10648, 19, 10642, '中敖镇', '中敖镇', 30),
(10649, 19, 10642, '三驱镇', '三驱镇', 35),
(10650, 19, 10642, '宝兴镇', '宝兴镇', 40),
(10651, 19, 10642, '玉龙镇', '玉龙镇', 45),
(10652, 19, 10642, '石马镇', '石马镇', 50),
(10653, 19, 10642, '拾万镇', '拾万镇', 55),
(10654, 19, 10642, '回龙镇', '回龙镇', 60),
(10655, 19, 10642, '金山镇', '金山镇', 65),
(10656, 19, 10642, '万古镇', '万古镇', 70),
(10657, 19, 10642, '国梁镇', '国梁镇', 75),
(10658, 19, 10642, '雍溪镇', '雍溪镇', 80),
(10659, 19, 10642, '珠溪镇', '珠溪镇', 85),
(10660, 19, 10642, '龙石镇', '龙石镇', 90),
(10661, 19, 10642, '邮亭镇', '邮亭镇', 95),
(10662, 19, 10642, '铁山镇', '铁山镇', 100),
(10663, 19, 10642, '高升镇', '高升镇', 105),
(10664, 19, 10642, '季家镇', '季家镇', 110),
(10665, 19, 10642, '古龙镇', '古龙镇', 115),
(10666, 19, 10642, '高坪镇', '高坪镇', 120),
(10667, 19, 10642, '双路镇', '双路镇', 125),
(10668, 19, 10642, '通桥镇', '通桥镇', 130),
(10669, 19, 10470, '黔江区', '黔江区', 35),
(10670, 19, 10669, '城区', '城区', 5),
(10671, 19, 10669, '正阳镇', '正阳镇', 10),
(10672, 19, 10669, '舟白镇', '舟白镇', 15),
(10673, 19, 10669, '阿蓬江镇', '阿蓬江镇', 20),
(10674, 19, 10669, '小南海镇', '小南海镇', 25),
(10675, 19, 10669, '鹅池镇', '鹅池镇', 30),
(10676, 19, 10669, '冯家镇', '冯家镇', 35),
(10677, 19, 10669, '黑溪镇', '黑溪镇', 40),
(10678, 19, 10669, '黄溪镇', '黄溪镇', 45),
(10679, 19, 10669, '金溪镇', '金溪镇', 50),
(10680, 19, 10669, '黎水镇', '黎水镇', 55),
(10681, 19, 10669, '邻鄂镇', '邻鄂镇', 60),
(10682, 19, 10669, '马喇镇', '马喇镇', 65),
(10683, 19, 10669, '石会镇', '石会镇', 70),
(10684, 19, 10669, '石家镇', '石家镇', 75),
(10685, 19, 10669, '濯水镇', '濯水镇', 80),
(10686, 19, 10669, '白石乡', '白石乡', 85),
(10687, 19, 10669, '白土乡', '白土乡', 90),
(10688, 19, 10669, '金洞乡', '金洞乡', 95),
(10689, 19, 10669, '蓬东乡', '蓬东乡', 100),
(10690, 19, 10669, '沙坝乡', '沙坝乡', 105),
(10691, 19, 10669, '杉岭乡', '杉岭乡', 110),
(10692, 19, 10669, '水市乡', '水市乡', 115),
(10693, 19, 10669, '水田乡', '水田乡', 120),
(10694, 19, 10669, '太极乡', '太极乡', 125),
(10695, 19, 10669, '五里乡', '五里乡', 130),
(10696, 19, 10669, '新华乡', '新华乡', 135),
(10697, 19, 10669, '中塘乡', '中塘乡', 140),
(10698, 19, 10470, '武隆县', '武隆县', 40),
(10699, 19, 10698, '县城内', '县城内', 5),
(10700, 19, 10698, '仙女山镇', '仙女山镇', 10),
(10701, 19, 10698, '巷口镇', '巷口镇', 15),
(10702, 19, 10698, '白马镇', '白马镇', 20),
(10703, 19, 10698, '火炉镇', '火炉镇', 25),
(10704, 19, 10698, '江口镇', '江口镇', 30),
(10705, 19, 10698, '平桥镇', '平桥镇', 35),
(10706, 19, 10698, '桐梓镇', '桐梓镇', 40),
(10707, 19, 10698, '土坎镇', '土坎镇', 45),
(10708, 19, 10698, '鸭江镇', '鸭江镇', 50),
(10709, 19, 10698, '羊角镇', '羊角镇', 55),
(10710, 19, 10698, '长坝镇', '长坝镇', 60),
(10711, 19, 10698, '白云乡', '白云乡', 65),
(10712, 19, 10698, '沧沟乡', '沧沟乡', 70),
(10713, 19, 10698, '凤来乡', '凤来乡', 75),
(10714, 19, 10698, '浩口乡', '浩口乡', 80),
(10715, 19, 10698, '和顺乡', '和顺乡', 85),
(10716, 19, 10698, '后坪乡', '后坪乡', 90),
(10717, 19, 10698, '黄莺乡', '黄莺乡', 95),
(10718, 19, 10698, '接龙乡', '接龙乡', 100),
(10719, 19, 10698, '庙垭乡', '庙垭乡', 105),
(10720, 19, 10698, '石桥乡', '石桥乡', 110),
(10721, 19, 10698, '双河乡', '双河乡', 115),
(10722, 19, 10698, '铁矿乡', '铁矿乡', 120),
(10723, 19, 10698, '土地乡', '土地乡', 125),
(10724, 19, 10698, '文复乡', '文复乡', 130),
(10725, 19, 10698, '赵家乡', '赵家乡', 135),
(10726, 19, 10470, '丰都县', '丰都县', 45),
(10727, 19, 10726, '县城内', '县城内', 5),
(10728, 19, 10726, '南天湖镇', '南天湖镇', 10),
(10729, 19, 10726, '许明寺镇', '许明寺镇', 15),
(10730, 19, 10726, '包鸾镇', '包鸾镇', 20),
(10731, 19, 10726, '董家镇', '董家镇', 25),
(10732, 19, 10726, '高家镇', '高家镇', 30),
(10733, 19, 10726, '虎威镇', '虎威镇', 35),
(10734, 19, 10726, '江池镇', '江池镇', 40),
(10735, 19, 10726, '龙河镇', '龙河镇', 45),
(10736, 19, 10726, '名山镇', '名山镇', 50),
(10737, 19, 10726, '三元镇', '三元镇', 55),
(10738, 19, 10726, '社坛镇', '社坛镇', 60),
(10739, 19, 10726, '十直镇', '十直镇', 65),
(10740, 19, 10726, '树人镇', '树人镇', 70),
(10741, 19, 10726, '双路镇', '双路镇', 75),
(10742, 19, 10726, '武平镇', '武平镇', 80),
(10743, 19, 10726, '兴义镇', '兴义镇', 85),
(10744, 19, 10726, '湛普镇', '湛普镇', 90),
(10745, 19, 10726, '镇江镇', '镇江镇', 95),
(10746, 19, 10726, '太平坝乡', '太平坝乡', 100),
(10747, 19, 10726, '双龙场乡', '双龙场乡', 105),
(10748, 19, 10726, '保合乡', '保合乡', 110),
(10749, 19, 10726, '崇兴乡', '崇兴乡', 115),
(10750, 19, 10726, '都督乡', '都督乡', 120),
(10751, 19, 10726, '暨龙乡', '暨龙乡', 125),
(10752, 19, 10726, '栗子乡', '栗子乡', 130),
(10753, 19, 10726, '龙孔乡', '龙孔乡', 135),
(10754, 19, 10726, '青龙乡', '青龙乡', 140),
(10755, 19, 10726, '仁沙乡', '仁沙乡', 145),
(10756, 19, 10726, '三坝乡', '三坝乡', 150),
(10757, 19, 10726, '三建乡', '三建乡', 155),
(10758, 19, 10470, '奉节县', '奉节县', 50),
(10759, 19, 10758, '永乐镇', '永乐镇', 5),
(10760, 19, 10758, '县城内', '县城内', 10),
(10761, 19, 10758, '永安镇', '永安镇', 15),
(10762, 19, 10758, '白帝镇', '白帝镇', 20),
(10763, 19, 10758, '草堂镇', '草堂镇', 25),
(10764, 19, 10758, '大树镇', '大树镇', 30),
(10765, 19, 10758, '汾河镇', '汾河镇', 35),
(10766, 19, 10758, '公平镇', '公平镇', 40),
(10767, 19, 10758, '甲高镇', '甲高镇', 45),
(10768, 19, 10758, '康乐镇', '康乐镇', 50),
(10769, 19, 10758, '青龙镇', '青龙镇', 55),
(10770, 19, 10758, '吐祥镇', '吐祥镇', 60),
(10771, 19, 10758, '新民镇', '新民镇', 65),
(10772, 19, 10758, '兴隆镇', '兴隆镇', 70),
(10773, 19, 10758, '羊市镇', '羊市镇', 75),
(10774, 19, 10758, '朱衣镇', '朱衣镇', 80),
(10775, 19, 10758, '竹园镇', '竹园镇', 85),
(10776, 19, 10758, '安坪乡', '安坪乡', 90),
(10777, 19, 10758, '冯坪乡', '冯坪乡', 95),
(10778, 19, 10758, '鹤峰乡', '鹤峰乡', 100),
(10779, 19, 10758, '红土乡', '红土乡', 105),
(10780, 19, 10758, '康坪乡', '康坪乡', 110),
(10781, 19, 10758, '龙桥乡', '龙桥乡', 115),
(10782, 19, 10758, '平安乡', '平安乡', 120),
(10783, 19, 10758, '石岗乡', '石岗乡', 125),
(10784, 19, 10758, '太和乡', '太和乡', 130),
(10785, 19, 10758, '五马乡', '五马乡', 135),
(10786, 19, 10758, '新政乡', '新政乡', 140),
(10787, 19, 10758, '岩湾乡', '岩湾乡', 145),
(10788, 19, 10758, '云雾乡', '云雾乡', 150),
(10789, 19, 10758, '长安乡', '长安乡', 155),
(10790, 19, 10470, '开县', '开县', 55),
(10791, 19, 10790, '白桥镇', '白桥镇', 5),
(10792, 19, 10790, '大德镇', '大德镇', 10),
(10793, 19, 10790, '金峰镇', '金峰镇', 15),
(10794, 19, 10790, '谭家镇', '谭家镇', 20),
(10795, 19, 10790, '天和镇', '天和镇', 25),
(10796, 19, 10790, '白泉乡', '白泉乡', 30),
(10797, 19, 10790, '县城内', '县城内', 35),
(10798, 19, 10790, '九龙山镇', '九龙山镇', 40),
(10799, 19, 10790, '大进镇', '大进镇', 45),
(10800, 19, 10790, '敦好镇', '敦好镇', 50),
(10801, 19, 10790, '高桥镇', '高桥镇', 55),
(10802, 19, 10790, '郭家镇', '郭家镇', 60),
(10803, 19, 10790, '和谦镇', '和谦镇', 65),
(10804, 19, 10790, '河堰镇', '河堰镇', 70),
(10805, 19, 10790, '厚坝镇', '厚坝镇', 75),
(10806, 19, 10790, '临江镇', '临江镇', 80),
(10807, 19, 10790, '南门镇', '南门镇', 85),
(10808, 19, 10790, '南雅镇', '南雅镇', 90),
(10809, 19, 10790, '渠口镇', '渠口镇', 95),
(10810, 19, 10790, '铁桥镇', '铁桥镇', 100),
(10811, 19, 10790, '岳溪镇', '岳溪镇', 105),
(10812, 19, 10790, '温泉镇', '温泉镇', 110),
(10813, 19, 10790, '义和镇', '义和镇', 115),
(10814, 19, 10790, '长沙镇', '长沙镇', 120),
(10815, 19, 10790, '赵家镇', '赵家镇', 125),
(10816, 19, 10790, '镇安镇', '镇安镇', 130),
(10817, 19, 10790, '中和镇', '中和镇', 135),
(10818, 19, 10790, '竹溪镇', '竹溪镇', 140),
(10819, 19, 10790, '三汇口乡', '三汇口乡', 145),
(10820, 19, 10790, '白桥乡', '白桥乡', 150),
(10821, 19, 10790, '大德乡', '大德乡', 155),
(10822, 19, 10790, '关面乡', '关面乡', 160),
(10823, 19, 10790, '金峰乡', '金峰乡', 165),
(10824, 19, 10790, '麻柳乡', '麻柳乡', 170),
(10825, 19, 10790, '满月乡', '满月乡', 175),
(10826, 19, 10790, '谭家乡', '谭家乡', 180),
(10827, 19, 10790, '天和乡', '天和乡', 185),
(10828, 19, 10790, '巫山镇', '巫山镇', 190),
(10829, 19, 10790, '五通乡', '五通乡', 195),
(10830, 19, 10790, '紫水乡', '紫水乡', 200),
(10831, 19, 10470, '云阳县', '云阳县', 60),
(10832, 19, 10831, '县城内', '县城内', 5),
(10833, 19, 10831, '云阳镇', '云阳镇', 10),
(10834, 19, 10831, '巴阳镇', '巴阳镇', 15),
(10835, 19, 10831, '凤鸣镇', '凤鸣镇', 20),
(10836, 19, 10831, '高阳镇', '高阳镇', 25),
(10837, 19, 10831, '故陵镇', '故陵镇', 30),
(10838, 19, 10831, '红狮镇', '红狮镇', 35),
(10839, 19, 10831, '黄石镇', '黄石镇', 40),
(10840, 19, 10831, '江口镇', '江口镇', 45),
(10841, 19, 10831, '龙角镇', '龙角镇', 50),
(10842, 19, 10831, '路阳镇', '路阳镇', 55),
(10843, 19, 10831, '南溪镇', '南溪镇', 60),
(10844, 19, 10831, '农坝镇', '农坝镇', 65),
(10845, 19, 10831, '盘龙镇', '盘龙镇', 70),
(10846, 19, 10831, '平安镇', '平安镇', 75),
(10847, 19, 10831, '渠马镇', '渠马镇', 80),
(10848, 19, 10831, '人和镇', '人和镇', 85),
(10849, 19, 10831, '桑坪镇', '桑坪镇', 90),
(10850, 19, 10831, '沙市镇', '沙市镇', 95),
(10851, 19, 10831, '双土镇', '双土镇', 100),
(10852, 19, 10831, '鱼泉镇', '鱼泉镇', 105),
(10853, 19, 10831, '云安镇', '云安镇', 110),
(10854, 19, 10831, '洞鹿乡', '洞鹿乡', 115),
(10855, 19, 10831, '后叶乡', '后叶乡', 120),
(10856, 19, 10831, '龙洞乡', '龙洞乡', 125),
(10857, 19, 10831, '毛坝乡', '毛坝乡', 130),
(10858, 19, 10831, '泥溪乡', '泥溪乡', 135),
(10859, 19, 10831, '票草乡', '票草乡', 140),
(10860, 19, 10831, '普安乡', '普安乡', 145),
(10861, 19, 10831, '栖霞乡', '栖霞乡', 150),
(10862, 19, 10831, '清水乡', '清水乡', 155),
(10863, 19, 10831, '上坝乡', '上坝乡', 160),
(10864, 19, 10831, '石门乡', '石门乡', 165),
(10865, 19, 10831, '双龙乡', '双龙乡', 170),
(10866, 19, 10831, '水口乡', '水口乡', 175),
(10867, 19, 10831, '外郎乡', '外郎乡', 180),
(10868, 19, 10831, '新津乡', '新津乡', 185),
(10869, 19, 10831, '堰坪乡', '堰坪乡', 190),
(10870, 19, 10831, '养鹿乡', '养鹿乡', 195),
(10871, 19, 10831, '耀灵乡', '耀灵乡', 200),
(10872, 19, 10831, '云硐乡', '云硐乡', 205),
(10873, 19, 10470, '忠县', '忠县', 65),
(10874, 19, 10873, '县城内', '县城内', 5),
(10875, 19, 10873, '忠州镇', '忠州镇', 10),
(10876, 19, 10873, '拔山镇', '拔山镇', 15),
(10877, 19, 10873, '白石镇', '白石镇', 20),
(10878, 19, 10873, '东溪镇', '东溪镇', 25),
(10879, 19, 10873, '复兴镇', '复兴镇', 30),
(10880, 19, 10873, '官坝镇', '官坝镇', 35),
(10881, 19, 10873, '花桥镇', '花桥镇', 40),
(10882, 19, 10873, '黄金镇', '黄金镇', 45),
(10883, 19, 10873, '金鸡镇', '金鸡镇', 50),
(10884, 19, 10873, '马灌镇', '马灌镇', 55),
(10885, 19, 10873, '任家镇', '任家镇', 60),
(10886, 19, 10873, '汝溪镇', '汝溪镇', 65),
(10887, 19, 10873, '三汇镇', '三汇镇', 70),
(10888, 19, 10873, '石宝镇', '石宝镇', 75),
(10889, 19, 10873, '石黄镇', '石黄镇', 80),
(10890, 19, 10873, '双桂镇', '双桂镇', 85),
(10891, 19, 10873, '乌杨镇', '乌杨镇', 90),
(10892, 19, 10873, '新生镇', '新生镇', 95),
(10893, 19, 10873, '洋渡镇', '洋渡镇', 100),
(10894, 19, 10873, '野鹤镇', '野鹤镇', 105),
(10895, 19, 10873, '永丰镇', '永丰镇', 110),
(10896, 19, 10873, '金声乡', '金声乡', 115),
(10897, 19, 10873, '磨子乡', '磨子乡', 120),
(10898, 19, 10873, '善广乡', '善广乡', 125),
(10899, 19, 10873, '石子乡', '石子乡', 130),
(10900, 19, 10873, '涂井乡', '涂井乡', 135),
(10901, 19, 10873, '兴峰乡', '兴峰乡', 140),
(10902, 19, 10873, '新立镇', '新立镇', 145),
(10903, 19, 10470, '巫溪县', '巫溪县', 70),
(10904, 19, 10903, '县城内', '县城内', 5),
(10905, 19, 10903, '城厢镇', '城厢镇', 10),
(10906, 19, 10903, '凤凰镇', '凤凰镇', 15),
(10907, 19, 10903, '古路镇', '古路镇', 20),
(10908, 19, 10903, '尖山镇', '尖山镇', 25),
(10909, 19, 10903, '宁厂镇', '宁厂镇', 30),
(10910, 19, 10903, '上磺镇', '上磺镇', 35),
(10911, 19, 10903, '文峰镇', '文峰镇', 40),
(10912, 19, 10903, '下堡镇', '下堡镇', 45),
(10913, 19, 10903, '徐家镇', '徐家镇', 50),
(10914, 19, 10903, '朝阳洞乡', '朝阳洞乡', 55),
(10915, 19, 10903, '大河乡', '大河乡', 60),
(10916, 19, 10903, '峰灵乡', '峰灵乡', 65),
(10917, 19, 10903, '花台乡', '花台乡', 70),
(10918, 19, 10903, '兰英乡', '兰英乡', 75),
(10919, 19, 10903, '菱角乡', '菱角乡', 80),
(10920, 19, 10903, '蒲莲乡', '蒲莲乡', 85),
(10921, 19, 10903, '胜利乡', '胜利乡', 90),
(10922, 19, 10903, '双阳乡', '双阳乡', 95),
(10923, 19, 10903, '塘坊乡', '塘坊乡', 100),
(10924, 19, 10903, '天星乡', '天星乡', 105),
(10925, 19, 10903, '天元乡', '天元乡', 110),
(10926, 19, 10903, '田坝乡', '田坝乡', 115),
(10927, 19, 10903, '通城乡', '通城乡', 120),
(10928, 19, 10903, '土城乡', '土城乡', 125),
(10929, 19, 10903, '乌龙乡', '乌龙乡', 130),
(10930, 19, 10903, '鱼鳞乡', '鱼鳞乡', 135),
(10931, 19, 10903, '长桂乡', '长桂乡', 140),
(10932, 19, 10903, '中岗乡', '中岗乡', 145),
(10933, 19, 10903, '中梁乡', '中梁乡', 150),
(10934, 19, 10470, '巫山县', '巫山县', 75),
(10935, 19, 10934, '县城内', '县城内', 5),
(10936, 19, 10934, '巫峡镇', '巫峡镇', 10),
(10937, 19, 10934, '大昌镇', '大昌镇', 15),
(10938, 19, 10934, '福田镇', '福田镇', 20),
(10939, 19, 10934, '官渡镇', '官渡镇', 25),
(10940, 19, 10934, '官阳镇', '官阳镇', 30),
(10941, 19, 10934, '龙溪镇', '龙溪镇', 35),
(10942, 19, 10934, '骡坪镇', '骡坪镇', 40),
(10943, 19, 10934, '庙堂乡', '庙堂乡', 45),
(10944, 19, 10934, '庙宇镇', '庙宇镇', 50),
(10945, 19, 10934, '双龙镇', '双龙镇', 55),
(10946, 19, 10934, '铜鼓镇', '铜鼓镇', 60),
(10947, 19, 10934, '抱龙镇', '抱龙镇', 65),
(10948, 19, 10934, '大溪乡', '大溪乡', 70),
(10949, 19, 10934, '当阳乡', '当阳乡', 75),
(10950, 19, 10934, '邓家乡', '邓家乡', 80),
(10951, 19, 10934, '笃坪乡', '笃坪乡', 85),
(10952, 19, 10934, '红椿乡', '红椿乡', 90),
(10953, 19, 10934, '建平乡', '建平乡', 95),
(10954, 19, 10934, '金坪乡', '金坪乡', 100),
(10955, 19, 10934, '两坪乡', '两坪乡', 105),
(10956, 19, 10934, '龙井乡', '龙井乡', 110),
(10957, 19, 10934, '培石乡', '培石乡', 115),
(10958, 19, 10934, '平河乡', '平河乡', 120),
(10959, 19, 10934, '曲尺乡', '曲尺乡', 125),
(10960, 19, 10934, '三溪乡', '三溪乡', 130),
(10961, 19, 10934, '竹贤乡', '竹贤乡', 135),
(10962, 19, 10470, '石柱县', '石柱县', 80),
(10963, 19, 10962, '王家乡', '王家乡', 5),
(10964, 19, 10962, '洗新乡', '洗新乡', 10),
(10965, 19, 10962, '新乐乡', '新乐乡', 15),
(10966, 19, 10962, '中益乡', '中益乡', 20),
(10967, 19, 10962, '县城内', '县城内', 25),
(10968, 19, 10962, '南宾镇', '南宾镇', 30),
(10969, 19, 10962, '黄水镇', '黄水镇', 35),
(10970, 19, 10962, '临溪镇', '临溪镇', 40),
(10971, 19, 10962, '龙沙镇', '龙沙镇', 45),
(10972, 19, 10962, '马武镇', '马武镇', 50),
(10973, 19, 10962, '沙子镇', '沙子镇', 55),
(10974, 19, 10962, '王场镇', '王场镇', 60),
(10975, 19, 10962, '西沱镇', '西沱镇', 65),
(10976, 19, 10962, '下路镇', '下路镇', 70),
(10977, 19, 10962, '沿溪镇', '沿溪镇', 75),
(10978, 19, 10962, '渔池镇', '渔池镇', 80),
(10979, 19, 10962, '悦崃镇', '悦崃镇', 85),
(10980, 19, 10962, '大歇乡', '大歇乡', 90),
(10981, 19, 10962, '枫木乡', '枫木乡', 95),
(10982, 19, 10962, '河嘴乡', '河嘴乡', 100),
(10983, 19, 10962, '黄鹤乡', '黄鹤乡', 105),
(10984, 19, 10962, '金铃乡', '金铃乡', 110),
(10985, 19, 10962, '金竹乡', '金竹乡', 115),
(10986, 19, 10962, '冷水乡', '冷水乡', 120),
(10987, 19, 10962, '黎场乡', '黎场乡', 125),
(10988, 19, 10962, '六塘乡', '六塘乡', 130),
(10989, 19, 10962, '龙潭乡', '龙潭乡', 135),
(10990, 19, 10962, '桥头乡', '桥头乡', 140),
(10991, 19, 10962, '三河乡', '三河乡', 145),
(10992, 19, 10962, '三益乡', '三益乡', 150),
(10993, 19, 10962, '石家乡', '石家乡', 155),
(10994, 19, 10962, '万朝乡', '万朝乡', 160),
(10995, 19, 10470, '彭水县', '彭水县', 85),
(10996, 19, 10995, '保家镇', '保家镇', 5),
(10997, 19, 10995, '高谷镇', '高谷镇', 10),
(10998, 19, 10995, '黄家镇', '黄家镇', 15),
(10999, 19, 10995, '连湖镇', '连湖镇', 20),
(11000, 19, 10995, '龙射镇', '龙射镇', 25),
(11001, 19, 10995, '鹿角镇', '鹿角镇', 30),
(11002, 19, 10995, '普子镇', '普子镇', 35),
(11003, 19, 10995, '桑柘镇', '桑柘镇', 40),
(11004, 19, 10995, '万足镇', '万足镇', 45),
(11005, 19, 10995, '郁山镇', '郁山镇', 50),
(11006, 19, 10995, '梅子垭乡', '梅子垭乡', 55),
(11007, 19, 10995, '鞍子乡', '鞍子乡', 60),
(11008, 19, 10995, '大垭乡', '大垭乡', 65),
(11009, 19, 10995, '棣棠乡', '棣棠乡', 70),
(11010, 19, 10995, '靛水乡', '靛水乡', 75),
(11011, 19, 10995, '朗溪乡', '朗溪乡', 80),
(11012, 19, 10995, '联合乡', '联合乡', 85),
(11013, 19, 10995, '龙塘乡', '龙塘乡', 90),
(11014, 19, 10995, '龙溪乡', '龙溪乡', 95),
(11015, 19, 10995, '芦塘乡', '芦塘乡', 100),
(11016, 19, 10995, '鹿鸣乡', '鹿鸣乡', 105),
(11017, 19, 10995, '平安乡', '平安乡', 110),
(11018, 19, 10995, '迁乔乡', '迁乔乡', 115),
(11019, 19, 10995, '乔梓乡', '乔梓乡', 120),
(11020, 19, 10995, '润溪乡', '润溪乡', 125),
(11021, 19, 10995, '三义乡', '三义乡', 130),
(11022, 19, 10995, '善感乡', '善感乡', 135),
(11023, 19, 10995, '县城内', '县城内', 140),
(11024, 19, 10995, '石柳乡', '石柳乡', 145),
(11025, 19, 10995, '石盘乡', '石盘乡', 150),
(11026, 19, 10995, '双龙乡', '双龙乡', 155),
(11027, 19, 10995, '太原乡', '太原乡', 160),
(11028, 19, 10995, '桐楼乡', '桐楼乡', 165),
(11029, 19, 10995, '小厂乡', '小厂乡', 170),
(11030, 19, 10995, '新田乡', '新田乡', 175),
(11031, 19, 10995, '岩东乡', '岩东乡', 180),
(11032, 19, 10995, '长滩乡', '长滩乡', 185),
(11033, 19, 10995, '诸佛乡', '诸佛乡', 190),
(11034, 19, 10995, '走马乡', '走马乡', 195),
(11035, 19, 10470, '垫江县', '垫江县', 90),
(11036, 19, 11035, '县城内', '县城内', 5),
(11037, 19, 11035, '桂溪镇', '桂溪镇', 10),
(11038, 19, 11035, '澄溪镇', '澄溪镇', 15),
(11039, 19, 11035, '高安镇', '高安镇', 20),
(11040, 19, 11035, '高峰镇', '高峰镇', 25),
(11041, 19, 11035, '鹤游镇', '鹤游镇', 30),
(11042, 19, 11035, '普顺镇', '普顺镇', 35),
(11043, 19, 11035, '沙坪镇', '沙坪镇', 40),
(11044, 19, 11035, '太平镇', '太平镇', 45),
(11045, 19, 11035, '五洞镇', '五洞镇', 50),
(11046, 19, 11035, '新民镇', '新民镇', 55),
(11047, 19, 11035, '砚台镇', '砚台镇', 60),
(11048, 19, 11035, '永安镇', '永安镇', 65),
(11049, 19, 11035, '周嘉镇', '周嘉镇', 70),
(11050, 19, 11035, '白家乡', '白家乡', 75),
(11051, 19, 11035, '包家乡', '包家乡', 80),
(11052, 19, 11035, '曹回乡', '曹回乡', 85),
(11053, 19, 11035, '大石乡', '大石乡', 90),
(11054, 19, 11035, '杠家乡', '杠家乡', 95),
(11055, 19, 11035, '坪山镇', '坪山镇', 100),
(11056, 19, 11035, '黄沙乡', '黄沙乡', 105),
(11057, 19, 11035, '裴兴乡', '裴兴乡', 110),
(11058, 19, 11035, '三溪乡', '三溪乡', 115),
(11059, 19, 11035, '沙河乡', '沙河乡', 120),
(11060, 19, 11035, '永平乡', '永平乡', 125),
(11061, 19, 11035, '长龙乡', '长龙乡', 130),
(11062, 19, 10470, '酉阳县', '酉阳县', 95),
(11063, 19, 11062, '县城内', '县城内', 5),
(11064, 19, 11062, '钟多镇', '钟多镇', 10),
(11065, 19, 11062, '苍岭镇', '苍岭镇', 15),
(11066, 19, 11062, '车田乡', '车田乡', 20),
(11067, 19, 11062, '大溪镇', '大溪镇', 25),
(11068, 19, 11062, '丁市镇', '丁市镇', 30),
(11069, 19, 11062, '泔溪镇', '泔溪镇', 35),
(11070, 19, 11062, '龚滩镇', '龚滩镇', 40),
(11071, 19, 11062, '黑水镇', '黑水镇', 45),
(11072, 19, 11062, '后溪镇', '后溪镇', 50),
(11073, 19, 11062, '李溪镇', '李溪镇', 55),
(11074, 19, 11062, '龙潭镇', '龙潭镇', 60),
(11075, 19, 11062, '麻旺镇', '麻旺镇', 65),
(11076, 19, 11062, '小河镇', '小河镇', 70),
(11077, 19, 11062, '兴隆镇', '兴隆镇', 75),
(11078, 19, 11062, '酉酬镇', '酉酬镇', 80),
(11079, 19, 11062, '南腰界乡', '南腰界乡', 85),
(11080, 19, 11062, '后坪坝乡', '后坪坝乡', 90),
(11081, 19, 11062, '板溪乡', '板溪乡', 95),
(11082, 19, 11062, '官清乡', '官清乡', 100),
(11083, 19, 11062, '花田乡', '花田乡', 105),
(11084, 19, 11062, '江丰乡', '江丰乡', 110),
(11085, 19, 11062, '可大乡', '可大乡', 115),
(11086, 19, 11062, '浪坪乡', '浪坪乡', 120),
(11087, 19, 11062, '两罾乡', '两罾乡', 125),
(11088, 19, 11062, '毛坝乡', '毛坝乡', 130),
(11089, 19, 11062, '庙溪乡', '庙溪乡', 135),
(11090, 19, 11062, '木叶乡', '木叶乡', 140),
(11091, 19, 11062, '楠木乡', '楠木乡', 145),
(11092, 19, 11062, '偏柏乡', '偏柏乡', 150),
(11093, 19, 11062, '清泉乡', '清泉乡', 155),
(11094, 19, 11062, '双泉乡', '双泉乡', 160),
(11095, 19, 11062, '天馆乡', '天馆乡', 165),
(11096, 19, 11062, '铜鼓乡', '铜鼓乡', 170),
(11097, 19, 11062, '涂市乡', '涂市乡', 175),
(11098, 19, 11062, '万木乡', '万木乡', 180),
(11099, 19, 11062, '五福乡', '五福乡', 185),
(11100, 19, 11062, '宜居乡', '宜居乡', 190),
(11101, 19, 11062, '腴地乡', '腴地乡', 195),
(11102, 19, 11062, '板桥乡', '板桥乡', 200),
(11103, 19, 10470, '秀山县', '秀山县', 100),
(11104, 19, 11103, '县城内', '县城内', 5),
(11105, 19, 11103, '清溪场镇', '清溪场镇', 10),
(11106, 19, 11103, '中和镇', '中和镇', 15),
(11107, 19, 11103, '隘口镇', '隘口镇', 20),
(11108, 19, 11103, '峨溶镇', '峨溶镇', 25),
(11109, 19, 11103, '官庄镇', '官庄镇', 30),
(11110, 19, 11103, '洪安镇', '洪安镇', 35),
(11111, 19, 11103, '兰桥镇', '兰桥镇', 40),
(11112, 19, 11103, '龙池镇', '龙池镇', 45),
(11113, 19, 11103, '梅江镇', '梅江镇', 50),
(11114, 19, 11103, '平凯镇', '平凯镇', 55),
(11115, 19, 11103, '溶溪镇', '溶溪镇', 60),
(11116, 19, 11103, '石堤镇', '石堤镇', 65),
(11117, 19, 11103, '石耶镇', '石耶镇', 70),
(11118, 19, 11103, '雅江镇', '雅江镇', 75),
(11119, 19, 11103, '巴家乡', '巴家乡', 80),
(11120, 19, 11103, '保安乡', '保安乡', 85),
(11121, 19, 11103, '岑溪乡', '岑溪乡', 90),
(11122, 19, 11103, '大溪乡', '大溪乡', 95),
(11123, 19, 11103, '干川乡', '干川乡', 100),
(11124, 19, 11103, '膏田乡', '膏田乡', 105),
(11125, 19, 11103, '官舟乡', '官舟乡', 110),
(11126, 19, 11103, '海洋乡', '海洋乡', 115),
(11127, 19, 11103, '里仁乡', '里仁乡', 120),
(11128, 19, 11103, '妙泉乡', '妙泉乡', 125),
(11129, 19, 11103, '平马乡', '平马乡', 130),
(11130, 19, 11103, '宋农乡', '宋农乡', 135),
(11131, 19, 11103, '溪口乡', '溪口乡', 140),
(11132, 19, 11103, '孝溪乡', '孝溪乡', 145),
(11133, 19, 11103, '涌洞乡', '涌洞乡', 150),
(11134, 19, 11103, '中平乡', '中平乡', 155),
(11135, 19, 11103, '钟灵乡', '钟灵乡', 160),
(11136, 19, 10470, '城口县', '城口县', 105),
(11137, 19, 11136, '县城内', '县城内', 5),
(11138, 19, 11136, '葛城镇', '葛城镇', 10);
INSERT INTO `qinggan_opt` (`id`, `group_id`, `parent_id`, `title`, `val`, `taxis`) VALUES
(11139, 19, 11136, '巴山镇', '巴山镇', 15),
(11140, 19, 11136, '高观镇', '高观镇', 20),
(11141, 19, 11136, '庙坝镇', '庙坝镇', 25),
(11142, 19, 11136, '明通镇', '明通镇', 30),
(11143, 19, 11136, '坪坝镇', '坪坝镇', 35),
(11144, 19, 11136, '修齐镇', '修齐镇', 40),
(11145, 19, 11136, '北屏乡', '北屏乡', 45),
(11146, 19, 11136, '东安乡', '东安乡', 50),
(11147, 19, 11136, '高楠乡', '高楠乡', 55),
(11148, 19, 11136, '高燕乡', '高燕乡', 60),
(11149, 19, 11136, '河鱼乡', '河鱼乡', 65),
(11150, 19, 11136, '厚坪乡', '厚坪乡', 70),
(11151, 19, 11136, '鸡鸣乡', '鸡鸣乡', 75),
(11152, 19, 11136, '岚天乡', '岚天乡', 80),
(11153, 19, 11136, '蓼子乡', '蓼子乡', 85),
(11154, 19, 11136, '龙田乡', '龙田乡', 90),
(11155, 19, 11136, '明中乡', '明中乡', 95),
(11156, 19, 11136, '双河乡', '双河乡', 100),
(11157, 19, 11136, '咸宜乡', '咸宜乡', 105),
(11158, 19, 11136, '沿河乡', '沿河乡', 110),
(11159, 19, 11136, '治平乡', '治平乡', 115),
(11160, 19, 11136, '周溪乡', '周溪乡', 120),
(11161, 19, 11136, '左岚乡', '左岚乡', 125),
(11162, 19, 10470, '璧山县', '璧山县', 110),
(11163, 19, 11162, '县城内', '县城内', 5),
(11164, 19, 11162, '青杠镇', '青杠镇', 10),
(11165, 19, 11162, '来凤镇', '来凤镇', 15),
(11166, 19, 11162, '丁家镇', '丁家镇', 20),
(11167, 19, 11162, '大路镇', '大路镇', 25),
(11168, 19, 11162, '八塘镇', '八塘镇', 30),
(11169, 19, 11162, '七塘镇', '七塘镇', 35),
(11170, 19, 11162, '河边镇', '河边镇', 40),
(11171, 19, 11162, '福禄镇', '福禄镇', 45),
(11172, 19, 11162, '大兴镇', '大兴镇', 50),
(11173, 19, 11162, '正兴镇', '正兴镇', 55),
(11174, 19, 11162, '广普镇', '广普镇', 60),
(11175, 19, 11162, '三合镇', '三合镇', 65),
(11176, 19, 11162, '健龙镇', '健龙镇', 70),
(11177, 19, 10470, '荣昌县', '荣昌县', 115),
(11178, 19, 11177, '县城内', '县城内', 5),
(11179, 19, 11177, '广顺镇', '广顺镇', 10),
(11180, 19, 11177, '安富镇', '安富镇', 15),
(11181, 19, 11177, '峰高镇', '峰高镇', 20),
(11182, 19, 11177, '双河镇', '双河镇', 25),
(11183, 19, 11177, '直升镇', '直升镇', 30),
(11184, 19, 11177, '路孔镇', '路孔镇', 35),
(11185, 19, 11177, '清江镇', '清江镇', 40),
(11186, 19, 11177, '仁义镇', '仁义镇', 45),
(11187, 19, 11177, '河包镇', '河包镇', 50),
(11188, 19, 11177, '古昌镇', '古昌镇', 55),
(11189, 19, 11177, '吴家镇', '吴家镇', 60),
(11190, 19, 11177, '观胜镇', '观胜镇', 65),
(11191, 19, 11177, '铜鼓镇', '铜鼓镇', 70),
(11192, 19, 11177, '清流镇', '清流镇', 75),
(11193, 19, 11177, '盘龙镇', '盘龙镇', 80),
(11194, 19, 11177, '远觉镇', '远觉镇', 85),
(11195, 19, 11177, '清升镇', '清升镇', 90),
(11196, 19, 11177, '荣隆镇', '荣隆镇', 95),
(11197, 19, 11177, '龙集镇', '龙集镇', 100),
(11198, 19, 10470, '铜梁县', '铜梁县', 120),
(11199, 19, 11198, '县城内', '县城内', 5),
(11200, 19, 11198, '土桥镇', '土桥镇', 10),
(11201, 19, 11198, '二坪镇', '二坪镇', 15),
(11202, 19, 11198, '水口镇', '水口镇', 20),
(11203, 19, 11198, '安居镇', '安居镇', 25),
(11204, 19, 11198, '白羊镇', '白羊镇', 30),
(11205, 19, 11198, '平滩镇', '平滩镇', 35),
(11206, 19, 11198, '石鱼镇', '石鱼镇', 40),
(11207, 19, 11198, '福果镇', '福果镇', 45),
(11208, 19, 11198, '维新镇', '维新镇', 50),
(11209, 19, 11198, '高楼镇', '高楼镇', 55),
(11210, 19, 11198, '大庙镇', '大庙镇', 60),
(11211, 19, 11198, '围龙镇', '围龙镇', 65),
(11212, 19, 11198, '华兴镇', '华兴镇', 70),
(11213, 19, 11198, '永嘉镇', '永嘉镇', 75),
(11214, 19, 11198, '安溪镇', '安溪镇', 80),
(11215, 19, 11198, '西河镇', '西河镇', 85),
(11216, 19, 11198, '太平镇', '太平镇', 90),
(11217, 19, 11198, '旧县镇', '旧县镇', 95),
(11218, 19, 11198, '虎峰镇', '虎峰镇', 100),
(11219, 19, 11198, '少云镇', '少云镇', 105),
(11220, 19, 11198, '蒲吕镇', '蒲吕镇', 110),
(11221, 19, 11198, '侣俸镇', '侣俸镇', 115),
(11222, 19, 11198, '小林乡', '小林乡', 120),
(11223, 19, 11198, '双山乡', '双山乡', 125),
(11224, 19, 11198, '庆隆乡', '庆隆乡', 130),
(11225, 19, 10470, '合川区', '合川区', 125),
(11226, 19, 11225, '城区', '城区', 5),
(11227, 19, 11225, '草街镇', '草街镇', 10),
(11228, 19, 11225, '盐井镇', '盐井镇', 15),
(11229, 19, 11225, '云门镇', '云门镇', 20),
(11230, 19, 11225, '大石镇', '大石镇', 25),
(11231, 19, 11225, '沙鱼镇', '沙鱼镇', 30),
(11232, 19, 11225, '官渡镇', '官渡镇', 35),
(11233, 19, 11225, '涞滩镇', '涞滩镇', 40),
(11234, 19, 11225, '肖家镇', '肖家镇', 45),
(11235, 19, 11225, '古楼镇', '古楼镇', 50),
(11236, 19, 11225, '三庙镇', '三庙镇', 55),
(11237, 19, 11225, '二郎镇', '二郎镇', 60),
(11238, 19, 11225, '龙凤镇', '龙凤镇', 65),
(11239, 19, 11225, '隆兴镇', '隆兴镇', 70),
(11240, 19, 11225, '铜溪镇', '铜溪镇', 75),
(11241, 19, 11225, '双凤镇', '双凤镇', 80),
(11242, 19, 11225, '狮滩镇', '狮滩镇', 85),
(11243, 19, 11225, '清平镇', '清平镇', 90),
(11244, 19, 11225, '土场镇', '土场镇', 95),
(11245, 19, 11225, '小沔镇', '小沔镇', 100),
(11246, 19, 11225, '三汇镇', '三汇镇', 105),
(11247, 19, 11225, '香龙镇', '香龙镇', 110),
(11248, 19, 11225, '钱塘镇', '钱塘镇', 115),
(11249, 19, 11225, '龙市镇', '龙市镇', 120),
(11250, 19, 11225, '燕窝镇', '燕窝镇', 125),
(11251, 19, 11225, '太和镇', '太和镇', 130),
(11252, 19, 11225, '渭沱镇', '渭沱镇', 135),
(11253, 19, 11225, '双槐镇', '双槐镇', 140),
(11254, 19, 10470, '巴南区', '巴南区', 130),
(11255, 19, 11254, '城区', '城区', 5),
(11256, 19, 11254, '南泉镇', '南泉镇', 10),
(11257, 19, 11254, '一品镇', '一品镇', 15),
(11258, 19, 11254, '南彭镇', '南彭镇', 20),
(11259, 19, 11254, '惠民镇', '惠民镇', 25),
(11260, 19, 11254, '麻柳嘴镇', '麻柳嘴镇', 30),
(11261, 19, 11254, '天星寺镇', '天星寺镇', 35),
(11262, 19, 11254, '双河口镇', '双河口镇', 40),
(11263, 19, 11254, '界石镇', '界石镇', 45),
(11264, 19, 11254, '安澜镇', '安澜镇', 50),
(11265, 19, 11254, '跳石镇', '跳石镇', 55),
(11266, 19, 11254, '木洞镇', '木洞镇', 60),
(11267, 19, 11254, '丰盛镇', '丰盛镇', 65),
(11268, 19, 11254, '二圣镇', '二圣镇', 70),
(11269, 19, 11254, '东泉镇', '东泉镇', 75),
(11270, 19, 11254, '姜家镇', '姜家镇', 80),
(11271, 19, 11254, '接龙镇', '接龙镇', 85),
(11272, 19, 11254, '石滩镇', '石滩镇', 90),
(11273, 19, 11254, '石龙镇', '石龙镇', 95),
(11274, 19, 10470, '北碚区', '北碚区', 135),
(11275, 19, 11274, '城区', '城区', 5),
(11276, 19, 11274, '东阳镇', '东阳镇', 10),
(11277, 19, 11274, '蔡家岗镇', '蔡家岗镇', 15),
(11278, 19, 11274, '童家溪镇', '童家溪镇', 20),
(11279, 19, 11274, '施家梁镇', '施家梁镇', 25),
(11280, 19, 11274, '金刀峡镇', '金刀峡镇', 30),
(11281, 19, 11274, '澄江镇', '澄江镇', 35),
(11282, 19, 11274, '水土镇', '水土镇', 40),
(11283, 19, 11274, '歇马镇', '歇马镇', 45),
(11284, 19, 11274, '天府镇', '天府镇', 50),
(11285, 19, 11274, '复兴镇', '复兴镇', 55),
(11286, 19, 11274, '静观镇', '静观镇', 60),
(11287, 19, 11274, '柳荫镇', '柳荫镇', 65),
(11288, 19, 11274, '三圣镇', '三圣镇', 70),
(11289, 19, 10470, '江津区', '江津区', 140),
(11290, 19, 11289, '城区', '城区', 5),
(11291, 19, 11289, '四面山镇', '四面山镇', 10),
(11292, 19, 11289, '支坪镇', '支坪镇', 15),
(11293, 19, 11289, '白沙镇', '白沙镇', 20),
(11294, 19, 11289, '珞璜镇', '珞璜镇', 25),
(11295, 19, 11289, '柏林镇', '柏林镇', 30),
(11296, 19, 11289, '蔡家镇', '蔡家镇', 35),
(11297, 19, 11289, '慈云镇', '慈云镇', 40),
(11298, 19, 11289, '杜市镇', '杜市镇', 45),
(11299, 19, 11289, '广兴镇', '广兴镇', 50),
(11300, 19, 11289, '嘉平镇', '嘉平镇', 55),
(11301, 19, 11289, '贾嗣镇', '贾嗣镇', 60),
(11302, 19, 11289, '李市镇', '李市镇', 65),
(11303, 19, 11289, '龙华镇', '龙华镇', 70),
(11304, 19, 11289, '石蟆镇', '石蟆镇', 75),
(11305, 19, 11289, '石门镇', '石门镇', 80),
(11306, 19, 11289, '塘河镇', '塘河镇', 85),
(11307, 19, 11289, '吴滩镇', '吴滩镇', 90),
(11308, 19, 11289, '西湖镇', '西湖镇', 95),
(11309, 19, 11289, '夏坝镇', '夏坝镇', 100),
(11310, 19, 11289, '先锋镇', '先锋镇', 105),
(11311, 19, 11289, '永兴镇', '永兴镇', 110),
(11312, 19, 11289, '油溪镇', '油溪镇', 115),
(11313, 19, 11289, '中山镇', '中山镇', 120),
(11314, 19, 11289, '朱杨镇', '朱杨镇', 125),
(11315, 19, 10470, '渝北区', '渝北区', 145),
(11316, 19, 11315, '城区', '城区', 5),
(11317, 19, 11315, '礼嘉镇', '礼嘉镇', 10),
(11318, 19, 11315, '两路镇', '两路镇', 15),
(11319, 19, 11315, '王家镇', '王家镇', 20),
(11320, 19, 11315, '悦来镇', '悦来镇', 25),
(11321, 19, 11315, '玉峰山镇', '玉峰山镇', 30),
(11322, 19, 11315, '茨竹镇', '茨竹镇', 35),
(11323, 19, 11315, '大盛镇', '大盛镇', 40),
(11324, 19, 11315, '大塆镇', '大塆镇', 45),
(11325, 19, 11315, '古路镇', '古路镇', 50),
(11326, 19, 11315, '龙兴镇', '龙兴镇', 55),
(11327, 19, 11315, '洛碛镇', '洛碛镇', 60),
(11328, 19, 11315, '木耳镇', '木耳镇', 65),
(11329, 19, 11315, '石船镇', '石船镇', 70),
(11330, 19, 11315, '统景镇', '统景镇', 75),
(11331, 19, 11315, '兴隆镇', '兴隆镇', 80),
(11332, 19, 10470, '长寿区', '长寿区', 150),
(11333, 19, 11332, '城区', '城区', 5),
(11334, 19, 11332, '长寿湖镇', '长寿湖镇', 10),
(11335, 19, 11332, '邻封镇', '邻封镇', 15),
(11336, 19, 11332, '但渡镇', '但渡镇', 20),
(11337, 19, 11332, '云集镇', '云集镇', 25),
(11338, 19, 11332, '双龙镇', '双龙镇', 30),
(11339, 19, 11332, '龙河镇', '龙河镇', 35),
(11340, 19, 11332, '石堰镇', '石堰镇', 40),
(11341, 19, 11332, '云台镇', '云台镇', 45),
(11342, 19, 11332, '海棠镇', '海棠镇', 50),
(11343, 19, 11332, '葛兰镇', '葛兰镇', 55),
(11344, 19, 11332, '新市镇', '新市镇', 60),
(11345, 19, 11332, '八颗镇', '八颗镇', 65),
(11346, 19, 11332, '洪湖镇', '洪湖镇', 70),
(11347, 19, 11332, '万顺镇', '万顺镇', 75),
(11348, 19, 10470, '永川区', '永川区', 155),
(11349, 19, 11348, '城区', '城区', 5),
(11350, 19, 11348, '双竹镇', '双竹镇', 10),
(11351, 19, 11348, '三教镇', '三教镇', 15),
(11352, 19, 11348, '大安镇', '大安镇', 20),
(11353, 19, 11348, '陈食镇', '陈食镇', 25),
(11354, 19, 11348, '板桥镇', '板桥镇', 30),
(11355, 19, 11348, '宝峰镇', '宝峰镇', 35),
(11356, 19, 11348, '临江镇', '临江镇', 40),
(11357, 19, 11348, '红炉镇', '红炉镇', 45),
(11358, 19, 11348, '吉安镇', '吉安镇', 50),
(11359, 19, 11348, '金龙镇', '金龙镇', 55),
(11360, 19, 11348, '来苏镇', '来苏镇', 60),
(11361, 19, 11348, '青峰镇', '青峰镇', 65),
(11362, 19, 11348, '三教镇', '三教镇', 70),
(11363, 19, 11348, '双石镇', '双石镇', 75),
(11364, 19, 11348, '松溉镇', '松溉镇', 80),
(11365, 19, 11348, '五间镇', '五间镇', 85),
(11366, 19, 11348, '仙龙镇', '仙龙镇', 90),
(11367, 19, 11348, '永荣镇', '永荣镇', 95),
(11368, 19, 11348, '朱沱镇', '朱沱镇', 100),
(11369, 19, 11348, '何埂镇', '何埂镇', 105),
(11370, 19, 10470, '江北区', '江北区', 160),
(11371, 19, 11370, '内环以内', '内环以内', 5),
(11372, 19, 11370, '寸滩镇', '寸滩镇', 10),
(11373, 19, 11370, '郭家沱镇', '郭家沱镇', 15),
(11374, 19, 11370, '铁山坪镇', '铁山坪镇', 20),
(11375, 19, 11370, '鱼嘴镇', '鱼嘴镇', 25),
(11376, 19, 11370, '复盛镇', '复盛镇', 30),
(11377, 19, 11370, '五宝镇', '五宝镇', 35),
(11378, 19, 11370, '大石坝镇', '大石坝镇', 40),
(11379, 19, 10470, '南岸区', '南岸区', 165),
(11380, 19, 11379, '城区', '城区', 5),
(11381, 19, 11379, '内环以内', '内环以内', 10),
(11382, 19, 11379, '茶园新区', '茶园新区', 15),
(11383, 19, 11379, '鸡冠石镇', '鸡冠石镇', 20),
(11384, 19, 11379, '长生桥镇', '长生桥镇', 25),
(11385, 19, 11379, '峡口镇', '峡口镇', 30),
(11386, 19, 11379, '广阳镇', '广阳镇', 35),
(11387, 19, 11379, '迎龙镇', '迎龙镇', 40),
(11388, 19, 10470, '九龙坡区', '九龙坡区', 170),
(11389, 19, 11388, '内环以内', '内环以内', 5),
(11390, 19, 11388, '白市驿镇', '白市驿镇', 10),
(11391, 19, 11388, '铜罐驿镇', '铜罐驿镇', 15),
(11392, 19, 11388, '华岩镇', '华岩镇', 20),
(11393, 19, 11388, '巴福镇', '巴福镇', 25),
(11394, 19, 11388, '含谷镇', '含谷镇', 30),
(11395, 19, 11388, '金凤镇', '金凤镇', 35),
(11396, 19, 11388, '石板镇', '石板镇', 40),
(11397, 19, 11388, '陶家镇', '陶家镇', 45),
(11398, 19, 11388, '西彭镇', '西彭镇', 50),
(11399, 19, 11388, '走马镇', '走马镇', 55),
(11400, 19, 10470, '沙坪坝区', '沙坪坝区', 175),
(11401, 19, 11400, '内环以内', '内环以内', 5),
(11402, 19, 11400, '陈家桥镇', '陈家桥镇', 10),
(11403, 19, 11400, '歌乐山镇', '歌乐山镇', 15),
(11404, 19, 11400, '青木关镇', '青木关镇', 20),
(11405, 19, 11400, '回龙坝镇', '回龙坝镇', 25),
(11406, 19, 11400, '大学城', '大学城', 30),
(11407, 19, 11400, '虎溪镇', '虎溪镇', 35),
(11408, 19, 11400, '西永镇', '西永镇', 40),
(11409, 19, 11400, '土主镇', '土主镇', 45),
(11410, 19, 11400, '井口镇', '井口镇', 50),
(11411, 19, 11400, '曾家镇', '曾家镇', 55),
(11412, 19, 11400, '凤凰镇', '凤凰镇', 60),
(11413, 19, 11400, '中梁镇', '中梁镇', 65),
(11414, 19, 10470, '大渡口区', '大渡口区', 180),
(11415, 19, 11414, '茄子溪镇', '茄子溪镇', 5),
(11416, 19, 11414, '建胜镇', '建胜镇', 10),
(11417, 19, 11414, '跳磴镇', '跳磴镇', 15),
(11418, 19, 11414, '内环以内', '内环以内', 20),
(11419, 19, 10470, '綦江区', '綦江区', 185),
(11420, 19, 11419, '城区', '城区', 5),
(11421, 19, 11419, '三江镇', '三江镇', 10),
(11422, 19, 11419, '安稳镇', '安稳镇', 15),
(11423, 19, 11419, '打通镇', '打通镇', 20),
(11424, 19, 11419, '丁山镇', '丁山镇', 25),
(11425, 19, 11419, '东溪镇', '东溪镇', 30),
(11426, 19, 11419, '扶欢镇', '扶欢镇', 35),
(11427, 19, 11419, '赶水镇', '赶水镇', 40),
(11428, 19, 11419, '郭扶镇', '郭扶镇', 45),
(11429, 19, 11419, '横山镇', '横山镇', 50),
(11430, 19, 11419, '隆盛镇', '隆盛镇', 55),
(11431, 19, 11419, '三角镇', '三角镇', 60),
(11432, 19, 11419, '石壕镇', '石壕镇', 65),
(11433, 19, 11419, '石角镇', '石角镇', 70),
(11434, 19, 11419, '新盛镇', '新盛镇', 75),
(11435, 19, 11419, '永城镇', '永城镇', 80),
(11436, 19, 11419, '永新镇', '永新镇', 85),
(11437, 19, 11419, '中峰镇', '中峰镇', 90),
(11438, 19, 11419, '篆塘镇', '篆塘镇', 95),
(11439, 19, 11419, '丛林镇', '丛林镇', 100),
(11440, 19, 11419, '关坝镇', '关坝镇', 105),
(11441, 19, 11419, '黑山镇', '黑山镇', 110),
(11442, 19, 11419, '金桥镇', '金桥镇', 115),
(11443, 19, 11419, '南桐镇', '南桐镇', 120),
(11444, 19, 11419, '青年镇', '青年镇', 125),
(11445, 19, 11419, '石林镇', '石林镇', 130),
(11446, 19, 11419, '万东镇', '万东镇', 135),
(11447, 19, 10470, '渝中区', '渝中区', 190),
(11448, 19, 10470, '高新区', '高新区', 195),
(11449, 19, 10470, '北部新区', '北部新区', 200),
(11450, 19, 0, '河北省', '河北省', 25),
(11451, 19, 11450, '石家庄市', '石家庄市', 5),
(11452, 19, 11451, '藁城市', '藁城市', 5),
(11453, 19, 11451, '鹿泉市', '鹿泉市', 10),
(11454, 19, 11451, '正定县', '正定县', 15),
(11455, 19, 11451, '新华区', '新华区', 20),
(11456, 19, 11451, '桥西区', '桥西区', 25),
(11457, 19, 11451, '桥东区', '桥东区', 30),
(11458, 19, 11451, '裕华区', '裕华区', 35),
(11459, 19, 11451, '长安区', '长安区', 40),
(11460, 19, 11451, '辛集市', '辛集市', 45),
(11461, 19, 11451, '晋州市', '晋州市', 50),
(11462, 19, 11451, '新乐市', '新乐市', 55),
(11463, 19, 11451, '平山县', '平山县', 60),
(11464, 19, 11451, '井陉矿区', '井陉矿区', 65),
(11465, 19, 11451, '井陉县', '井陉县', 70),
(11466, 19, 11451, '栾城县', '栾城县', 75),
(11467, 19, 11451, '行唐县', '行唐县', 80),
(11468, 19, 11451, '灵寿县', '灵寿县', 85),
(11469, 19, 11451, '高邑县', '高邑县', 90),
(11470, 19, 11451, '赵县', '赵县', 95),
(11471, 19, 11451, '赞皇县', '赞皇县', 100),
(11472, 19, 11451, '深泽县', '深泽县', 105),
(11473, 19, 11451, '无极县', '无极县', 110),
(11474, 19, 11451, '元氏县', '元氏县', 115),
(11475, 19, 11450, '邯郸市', '邯郸市', 10),
(11476, 19, 11475, '丛台区', '丛台区', 5),
(11477, 19, 11475, '邯山区', '邯山区', 10),
(11478, 19, 11475, '复兴区', '复兴区', 15),
(11479, 19, 11475, '武安市', '武安市', 20),
(11480, 19, 11475, '临漳县', '临漳县', 25),
(11481, 19, 11475, '永年县', '永年县', 30),
(11482, 19, 11475, '邯郸县', '邯郸县', 35),
(11483, 19, 11475, '峰峰矿区', '峰峰矿区', 40),
(11484, 19, 11475, '曲周县', '曲周县', 45),
(11485, 19, 11475, '馆陶县', '馆陶县', 50),
(11486, 19, 11475, '魏县', '魏县', 55),
(11487, 19, 11475, '成安县', '成安县', 60),
(11488, 19, 11475, '大名县', '大名县', 65),
(11489, 19, 11475, '涉县', '涉县', 70),
(11490, 19, 11475, '鸡泽县', '鸡泽县', 75),
(11491, 19, 11475, '邱县', '邱县', 80),
(11492, 19, 11475, '广平县', '广平县', 85),
(11493, 19, 11475, '肥乡县', '肥乡县', 90),
(11494, 19, 11475, '磁县', '磁县', 95),
(11495, 19, 11450, '邢台市', '邢台市', 15),
(11496, 19, 11495, '宁晋县', '宁晋县', 5),
(11497, 19, 11495, '威县', '威县', 10),
(11498, 19, 11495, '桥西区', '桥西区', 15),
(11499, 19, 11495, '桥东区', '桥东区', 20),
(11500, 19, 11495, '邢台县', '邢台县', 25),
(11501, 19, 11495, '南宫市', '南宫市', 30),
(11502, 19, 11495, '沙河市', '沙河市', 35),
(11503, 19, 11495, '柏乡县', '柏乡县', 40),
(11504, 19, 11495, '任县', '任县', 45),
(11505, 19, 11495, '清河县', '清河县', 50),
(11506, 19, 11495, '隆尧县', '隆尧县', 55),
(11507, 19, 11495, '临城县', '临城县', 60),
(11508, 19, 11495, '广宗县', '广宗县', 65),
(11509, 19, 11495, '临西县', '临西县', 70),
(11510, 19, 11495, '内丘县', '内丘县', 75),
(11511, 19, 11495, '平乡县', '平乡县', 80),
(11512, 19, 11495, '巨鹿县', '巨鹿县', 85),
(11513, 19, 11495, '新河县', '新河县', 90),
(11514, 19, 11495, '南和县', '南和县', 95),
(11515, 19, 11450, '保定市', '保定市', 20),
(11516, 19, 11515, '涿州市', '涿州市', 5),
(11517, 19, 11515, '定州市', '定州市', 10),
(11518, 19, 11515, '徐水县', '徐水县', 15),
(11519, 19, 11515, '高碑店市', '高碑店市', 20),
(11520, 19, 11515, '新市区', '新市区', 25),
(11521, 19, 11515, '北市区', '北市区', 30),
(11522, 19, 11515, '南市区', '南市区', 35),
(11523, 19, 11515, '安国市', '安国市', 40),
(11524, 19, 11515, '安新县', '安新县', 45),
(11525, 19, 11515, '满城县', '满城县', 50),
(11526, 19, 11515, '清苑县', '清苑县', 55),
(11527, 19, 11515, '涞水县', '涞水县', 60),
(11528, 19, 11515, '阜平县', '阜平县', 65),
(11529, 19, 11515, '定兴县', '定兴县', 70),
(11530, 19, 11515, '唐县', '唐县', 75),
(11531, 19, 11515, '高阳县', '高阳县', 80),
(11532, 19, 11515, '容城县', '容城县', 85),
(11533, 19, 11515, '涞源县', '涞源县', 90),
(11534, 19, 11515, '望都县', '望都县', 95),
(11535, 19, 11515, '易县', '易县', 100),
(11536, 19, 11515, '曲阳县', '曲阳县', 105),
(11537, 19, 11515, '蠡县', '蠡县', 110),
(11538, 19, 11515, '顺平县', '顺平县', 115),
(11539, 19, 11515, '博野县', '博野县', 120),
(11540, 19, 11515, '雄县', '雄县', 125),
(11541, 19, 11450, '张家口市', '张家口市', 25),
(11542, 19, 11541, '怀安县', '怀安县', 5),
(11543, 19, 11541, '沽源县', '沽源县', 10),
(11544, 19, 11541, '宣化区', '宣化区', 15),
(11545, 19, 11541, '宣化县', '宣化县', 20),
(11546, 19, 11541, '康保县', '康保县', 25),
(11547, 19, 11541, '张北县', '张北县', 30),
(11548, 19, 11541, '阳原县', '阳原县', 35),
(11549, 19, 11541, '赤城县', '赤城县', 40),
(11550, 19, 11541, '崇礼县', '崇礼县', 45),
(11551, 19, 11541, '尚义县', '尚义县', 50),
(11552, 19, 11541, '蔚县', '蔚县', 55),
(11553, 19, 11541, '涿鹿县', '涿鹿县', 60),
(11554, 19, 11541, '万全县', '万全县', 65),
(11555, 19, 11541, '下花园区', '下花园区', 70),
(11556, 19, 11541, '桥西区', '桥西区', 75),
(11557, 19, 11541, '桥东区', '桥东区', 80),
(11558, 19, 11541, '怀来县', '怀来县', 85),
(11559, 19, 11450, '承德市', '承德市', 30),
(11560, 19, 11559, '双滦区', '双滦区', 5),
(11561, 19, 11559, '鹰手营子矿区', '鹰手营子矿区', 10),
(11562, 19, 11559, '隆化县', '隆化县', 15),
(11563, 19, 11559, '兴隆县', '兴隆县', 20),
(11564, 19, 11559, '平泉县', '平泉县', 25),
(11565, 19, 11559, '滦平县', '滦平县', 30),
(11566, 19, 11559, '丰宁县', '丰宁县', 35),
(11567, 19, 11559, '围场县', '围场县', 40),
(11568, 19, 11559, '宽城县', '宽城县', 45),
(11569, 19, 11559, '双桥区', '双桥区', 50),
(11570, 19, 11559, '承德县', '承德县', 55),
(11571, 19, 11450, '秦皇岛市', '秦皇岛市', 35),
(11572, 19, 11571, '卢龙县', '卢龙县', 5),
(11573, 19, 11571, '青龙县', '青龙县', 10),
(11574, 19, 11571, '昌黎县', '昌黎县', 15),
(11575, 19, 11571, '北戴河区', '北戴河区', 20),
(11576, 19, 11571, '海港区', '海港区', 25),
(11577, 19, 11571, '山海关区', '山海关区', 30),
(11578, 19, 11571, '抚宁县', '抚宁县', 35),
(11579, 19, 11450, '唐山市', '唐山市', 40),
(11580, 19, 11579, '路北区', '路北区', 5),
(11581, 19, 11579, '路南区', '路南区', 10),
(11582, 19, 11579, '迁安市', '迁安市', 15),
(11583, 19, 11579, '丰润区', '丰润区', 20),
(11584, 19, 11579, '古冶区', '古冶区', 25),
(11585, 19, 11579, '开平区', '开平区', 30),
(11586, 19, 11579, '遵化市', '遵化市', 35),
(11587, 19, 11579, '丰南区', '丰南区', 40),
(11588, 19, 11579, '迁西县', '迁西县', 45),
(11589, 19, 11579, '滦南县', '滦南县', 50),
(11590, 19, 11579, '玉田县', '玉田县', 55),
(11591, 19, 11579, '曹妃甸区', '曹妃甸区', 60),
(11592, 19, 11579, '乐亭县', '乐亭县', 65),
(11593, 19, 11579, '滦县', '滦县', 70),
(11594, 19, 11450, '沧州市', '沧州市', 45),
(11595, 19, 11594, '沧县', '沧县', 5),
(11596, 19, 11594, '泊头市', '泊头市', 10),
(11597, 19, 11594, '河间市', '河间市', 15),
(11598, 19, 11594, '献县', '献县', 20),
(11599, 19, 11594, '肃宁县', '肃宁县', 25),
(11600, 19, 11594, '青县', '青县', 30),
(11601, 19, 11594, '东光县', '东光县', 35),
(11602, 19, 11594, '吴桥县', '吴桥县', 40),
(11603, 19, 11594, '南皮县', '南皮县', 45),
(11604, 19, 11594, '盐山县', '盐山县', 50),
(11605, 19, 11594, '海兴县', '海兴县', 55),
(11606, 19, 11594, '孟村县', '孟村县', 60),
(11607, 19, 11594, '运河区', '运河区', 65),
(11608, 19, 11594, '新华区', '新华区', 70),
(11609, 19, 11594, '任丘市', '任丘市', 75),
(11610, 19, 11594, '黄骅市', '黄骅市', 80),
(11611, 19, 11450, '廊坊市', '廊坊市', 50),
(11612, 19, 11611, '三河市', '三河市', 5),
(11613, 19, 11611, '广阳区', '广阳区', 10),
(11614, 19, 11611, '开发区', '开发区', 15),
(11615, 19, 11611, '固安县', '固安县', 20),
(11616, 19, 11611, '安次区', '安次区', 25),
(11617, 19, 11611, '永清县', '永清县', 30),
(11618, 19, 11611, '香河县', '香河县', 35),
(11619, 19, 11611, '大城县', '大城县', 40),
(11620, 19, 11611, '文安县', '文安县', 45),
(11621, 19, 11611, '大厂县', '大厂县', 50),
(11622, 19, 11611, '霸州市', '霸州市', 55),
(11623, 19, 11450, '衡水市', '衡水市', 55),
(11624, 19, 11623, '冀州市', '冀州市', 5),
(11625, 19, 11623, '深州市', '深州市', 10),
(11626, 19, 11623, '饶阳县', '饶阳县', 15),
(11627, 19, 11623, '枣强县', '枣强县', 20),
(11628, 19, 11623, '桃城区', '桃城区', 25),
(11629, 19, 11623, '故城县', '故城县', 30),
(11630, 19, 11623, '阜城县', '阜城县', 35),
(11631, 19, 11623, '安平县', '安平县', 40),
(11632, 19, 11623, '武邑县', '武邑县', 45),
(11633, 19, 11623, '景县', '景县', 50),
(11634, 19, 11623, '武强县', '武强县', 55),
(11635, 19, 0, '山西省', '山西省', 30),
(11636, 19, 11635, '太原市', '太原市', 5),
(11637, 19, 11636, '小店区', '小店区', 5),
(11638, 19, 11636, '迎泽区', '迎泽区', 10),
(11639, 19, 11636, '晋源区', '晋源区', 15),
(11640, 19, 11636, '万柏林区', '万柏林区', 20),
(11641, 19, 11636, '尖草坪区', '尖草坪区', 25),
(11642, 19, 11636, '杏花岭区', '杏花岭区', 30),
(11643, 19, 11636, '古交市', '古交市', 35),
(11644, 19, 11636, '阳曲县', '阳曲县', 40),
(11645, 19, 11636, '娄烦县', '娄烦县', 45),
(11646, 19, 11636, '清徐县', '清徐县', 50),
(11647, 19, 11635, '大同市', '大同市', 10),
(11648, 19, 11647, '大同县', '大同县', 5),
(11649, 19, 11647, '天镇县', '天镇县', 10),
(11650, 19, 11647, '灵丘县', '灵丘县', 15),
(11651, 19, 11647, '阳高县', '阳高县', 20),
(11652, 19, 11647, '左云县', '左云县', 25),
(11653, 19, 11647, '浑源县', '浑源县', 30),
(11654, 19, 11647, '广灵县', '广灵县', 35),
(11655, 19, 11647, '城区', '城区', 40),
(11656, 19, 11647, '新荣区', '新荣区', 45),
(11657, 19, 11647, '南郊区', '南郊区', 50),
(11658, 19, 11647, '矿区', '矿区', 55),
(11659, 19, 11635, '阳泉市', '阳泉市', 15),
(11660, 19, 11659, '盂县', '盂县', 5),
(11661, 19, 11659, '平定县', '平定县', 10),
(11662, 19, 11659, '郊区', '郊区', 15),
(11663, 19, 11659, '城区', '城区', 20),
(11664, 19, 11659, '矿区', '矿区', 25),
(11665, 19, 11635, '晋城市', '晋城市', 20),
(11666, 19, 11665, '城区', '城区', 5),
(11667, 19, 11665, '高平市', '高平市', 10),
(11668, 19, 11665, '阳城县', '阳城县', 15),
(11669, 19, 11665, '沁水县', '沁水县', 20),
(11670, 19, 11665, '陵川县', '陵川县', 25),
(11671, 19, 11665, '泽州县', '泽州县', 30),
(11672, 19, 11635, '朔州市', '朔州市', 25),
(11673, 19, 11672, '平鲁区', '平鲁区', 5),
(11674, 19, 11672, '山阴县', '山阴县', 10),
(11675, 19, 11672, '右玉县', '右玉县', 15),
(11676, 19, 11672, '应县', '应县', 20),
(11677, 19, 11672, '怀仁县', '怀仁县', 25),
(11678, 19, 11672, '朔城区', '朔城区', 30),
(11679, 19, 11635, '晋中市', '晋中市', 30),
(11680, 19, 11679, '介休市', '介休市', 5),
(11681, 19, 11679, '昔阳县', '昔阳县', 10),
(11682, 19, 11679, '祁县', '祁县', 15),
(11683, 19, 11679, '左权县', '左权县', 20),
(11684, 19, 11679, '寿阳县', '寿阳县', 25),
(11685, 19, 11679, '太谷县', '太谷县', 30),
(11686, 19, 11679, '和顺县', '和顺县', 35),
(11687, 19, 11679, '灵石县', '灵石县', 40),
(11688, 19, 11679, '平遥县', '平遥县', 45),
(11689, 19, 11679, '榆社县', '榆社县', 50),
(11690, 19, 11679, '榆次区', '榆次区', 55),
(11691, 19, 11635, '忻州市', '忻州市', 35),
(11692, 19, 11691, '原平市', '原平市', 5),
(11693, 19, 11691, '代县', '代县', 10),
(11694, 19, 11691, '神池县', '神池县', 15),
(11695, 19, 11691, '五寨县', '五寨县', 20),
(11696, 19, 11691, '五台县', '五台县', 25),
(11697, 19, 11691, '偏关县', '偏关县', 30),
(11698, 19, 11691, '宁武县', '宁武县', 35),
(11699, 19, 11691, '静乐县', '静乐县', 40),
(11700, 19, 11691, '繁峙县', '繁峙县', 45),
(11701, 19, 11691, '河曲县', '河曲县', 50),
(11702, 19, 11691, '保德县', '保德县', 55),
(11703, 19, 11691, '定襄县', '定襄县', 60),
(11704, 19, 11691, '忻府区', '忻府区', 65),
(11705, 19, 11691, '岢岚县', '岢岚县', 70),
(11706, 19, 11635, '吕梁市', '吕梁市', 40),
(11707, 19, 11706, '离石区', '离石区', 5),
(11708, 19, 11706, '孝义市', '孝义市', 10),
(11709, 19, 11706, '汾阳市', '汾阳市', 15),
(11710, 19, 11706, '文水县', '文水县', 20),
(11711, 19, 11706, '中阳县', '中阳县', 25),
(11712, 19, 11706, '兴县', '兴县', 30),
(11713, 19, 11706, '临县', '临县', 35),
(11714, 19, 11706, '方山县', '方山县', 40),
(11715, 19, 11706, '柳林县', '柳林县', 45),
(11716, 19, 11706, '岚县', '岚县', 50),
(11717, 19, 11706, '交口县', '交口县', 55),
(11718, 19, 11706, '交城县', '交城县', 60),
(11719, 19, 11706, '石楼县', '石楼县', 65),
(11720, 19, 11635, '临汾市', '临汾市', 45),
(11721, 19, 11720, '曲沃县', '曲沃县', 5),
(11722, 19, 11720, '侯马市', '侯马市', 10),
(11723, 19, 11720, '霍州市', '霍州市', 15),
(11724, 19, 11720, '汾西县', '汾西县', 20),
(11725, 19, 11720, '吉县', '吉县', 25),
(11726, 19, 11720, '安泽县', '安泽县', 30),
(11727, 19, 11720, '浮山县', '浮山县', 35),
(11728, 19, 11720, '大宁县', '大宁县', 40),
(11729, 19, 11720, '古县', '古县', 45),
(11730, 19, 11720, '隰县', '隰县', 50),
(11731, 19, 11720, '襄汾县', '襄汾县', 55),
(11732, 19, 11720, '翼城县', '翼城县', 60),
(11733, 19, 11720, '永和县', '永和县', 65),
(11734, 19, 11720, '乡宁县', '乡宁县', 70),
(11735, 19, 11720, '洪洞县', '洪洞县', 75),
(11736, 19, 11720, '蒲县', '蒲县', 80),
(11737, 19, 11720, '尧都区', '尧都区', 85),
(11738, 19, 11635, '运城市', '运城市', 50),
(11739, 19, 11738, '盐湖区', '盐湖区', 5),
(11740, 19, 11738, '河津市', '河津市', 10),
(11741, 19, 11738, '永济市', '永济市', 15),
(11742, 19, 11738, '新绛县', '新绛县', 20),
(11743, 19, 11738, '平陆县', '平陆县', 25),
(11744, 19, 11738, '垣曲县', '垣曲县', 30),
(11745, 19, 11738, '绛县', '绛县', 35),
(11746, 19, 11738, '稷山县', '稷山县', 40),
(11747, 19, 11738, '芮城县', '芮城县', 45),
(11748, 19, 11738, '夏县', '夏县', 50),
(11749, 19, 11738, '临猗县', '临猗县', 55),
(11750, 19, 11738, '万荣县', '万荣县', 60),
(11751, 19, 11738, '闻喜县', '闻喜县', 65),
(11752, 19, 11635, '长治市', '长治市', 55),
(11753, 19, 11752, '长治县', '长治县', 5),
(11754, 19, 11752, '潞城市', '潞城市', 10),
(11755, 19, 11752, '郊区', '郊区', 15),
(11756, 19, 11752, '襄垣县', '襄垣县', 20),
(11757, 19, 11752, '屯留县', '屯留县', 25),
(11758, 19, 11752, '平顺县', '平顺县', 30),
(11759, 19, 11752, '黎城县', '黎城县', 35),
(11760, 19, 11752, '壶关县', '壶关县', 40),
(11761, 19, 11752, '长子县', '长子县', 45),
(11762, 19, 11752, '武乡县', '武乡县', 50),
(11763, 19, 11752, '沁县', '沁县', 55),
(11764, 19, 11752, '沁源县', '沁源县', 60),
(11765, 19, 11752, '城区', '城区', 65),
(11766, 19, 0, '河南省', '河南省', 35),
(11767, 19, 11766, '郑州市', '郑州市', 5),
(11768, 19, 11767, '二七区', '二七区', 5),
(11769, 19, 11767, '中原区', '中原区', 10),
(11770, 19, 11767, '郑东新区', '郑东新区', 15),
(11771, 19, 11767, '管城区', '管城区', 20),
(11772, 19, 11767, '金水区', '金水区', 25),
(11773, 19, 11767, '经济开发区', '经济开发区', 30),
(11774, 19, 11767, '高新技术开发区', '高新技术开发区', 35),
(11775, 19, 11767, '新郑市', '新郑市', 40),
(11776, 19, 11767, '巩义市', '巩义市', 45),
(11777, 19, 11767, '荥阳市', '荥阳市', 50),
(11778, 19, 11767, '中牟县', '中牟县', 55),
(11779, 19, 11767, '新密市', '新密市', 60),
(11780, 19, 11767, '登封市', '登封市', 65),
(11781, 19, 11767, '惠济区', '惠济区', 70),
(11782, 19, 11767, '上街区', '上街区', 75),
(11783, 19, 11766, '开封市', '开封市', 10),
(11784, 19, 11783, '金明区', '金明区', 5),
(11785, 19, 11783, '龙亭区', '龙亭区', 10),
(11786, 19, 11783, '顺河区', '顺河区', 15),
(11787, 19, 11783, '鼓楼区', '鼓楼区', 20),
(11788, 19, 11783, '禹王台区', '禹王台区', 25),
(11789, 19, 11783, '通许县', '通许县', 30),
(11790, 19, 11783, '开封县', '开封县', 35),
(11791, 19, 11783, '杞县', '杞县', 40),
(11792, 19, 11783, '兰考县', '兰考县', 45),
(11793, 19, 11783, '尉氏县', '尉氏县', 50),
(11794, 19, 11766, '洛阳市', '洛阳市', 15),
(11795, 19, 11794, '涧西区', '涧西区', 5),
(11796, 19, 11794, '西工区', '西工区', 10),
(11797, 19, 11794, '洛龙区', '洛龙区', 15),
(11798, 19, 11794, '嵩县', '嵩县', 20),
(11799, 19, 11794, '偃师市', '偃师市', 25),
(11800, 19, 11794, '孟津县', '孟津县', 30),
(11801, 19, 11794, '汝阳县', '汝阳县', 35),
(11802, 19, 11794, '伊川县', '伊川县', 40),
(11803, 19, 11794, '洛宁县', '洛宁县', 45),
(11804, 19, 11794, '宜阳县', '宜阳县', 50),
(11805, 19, 11794, '栾川县', '栾川县', 55),
(11806, 19, 11794, '新安县', '新安县', 60),
(11807, 19, 11794, '伊滨区', '伊滨区', 65),
(11808, 19, 11794, '吉利区', '吉利区', 70),
(11809, 19, 11794, '瀍河区', '瀍河区', 75),
(11810, 19, 11794, '老城区', '老城区', 80),
(11811, 19, 11766, '平顶山市', '平顶山市', 20),
(11812, 19, 11811, '湛河区', '湛河区', 5),
(11813, 19, 11811, '卫东区', '卫东区', 10),
(11814, 19, 11811, '新华区', '新华区', 15),
(11815, 19, 11811, '汝州市', '汝州市', 20),
(11816, 19, 11811, '舞钢市', '舞钢市', 25),
(11817, 19, 11811, '郏县', '郏县', 30),
(11818, 19, 11811, '叶县', '叶县', 35),
(11819, 19, 11811, '鲁山县', '鲁山县', 40),
(11820, 19, 11811, '宝丰县', '宝丰县', 45),
(11821, 19, 11811, '石龙区', '石龙区', 50),
(11822, 19, 11766, '焦作市', '焦作市', 25),
(11823, 19, 11822, '沁阳市', '沁阳市', 5),
(11824, 19, 11822, '孟州市', '孟州市', 10),
(11825, 19, 11822, '修武县', '修武县', 15),
(11826, 19, 11822, '温县', '温县', 20),
(11827, 19, 11822, '武陟县', '武陟县', 25),
(11828, 19, 11822, '博爱县', '博爱县', 30),
(11829, 19, 11822, '山阳区', '山阳区', 35),
(11830, 19, 11822, '解放区', '解放区', 40),
(11831, 19, 11822, '马村区', '马村区', 45),
(11832, 19, 11822, '中站区', '中站区', 50),
(11833, 19, 11766, '鹤壁市', '鹤壁市', 30),
(11834, 19, 11833, '淇滨区', '淇滨区', 5),
(11835, 19, 11833, '浚县', '浚县', 10),
(11836, 19, 11833, '淇县', '淇县', 15),
(11837, 19, 11833, '鹤山区', '鹤山区', 20),
(11838, 19, 11833, '山城区', '山城区', 25),
(11839, 19, 11766, '新乡市', '新乡市', 35),
(11840, 19, 11839, '牧野区', '牧野区', 5),
(11841, 19, 11839, '红旗区', '红旗区', 10),
(11842, 19, 11839, '卫滨区', '卫滨区', 15),
(11843, 19, 11839, '卫辉市', '卫辉市', 20),
(11844, 19, 11839, '辉县市', '辉县市', 25),
(11845, 19, 11839, '新乡县', '新乡县', 30),
(11846, 19, 11839, '获嘉县', '获嘉县', 35),
(11847, 19, 11839, '原阳县', '原阳县', 40),
(11848, 19, 11839, '长垣县', '长垣县', 45),
(11849, 19, 11839, '延津县', '延津县', 50),
(11850, 19, 11839, '封丘县', '封丘县', 55),
(11851, 19, 11839, '凤泉区', '凤泉区', 60),
(11852, 19, 11766, '安阳市', '安阳市', 40),
(11853, 19, 11852, '龙安区', '龙安区', 5),
(11854, 19, 11852, '殷都区', '殷都区', 10),
(11855, 19, 11852, '文峰区', '文峰区', 15),
(11856, 19, 11852, '开发区', '开发区', 20),
(11857, 19, 11852, '北关区', '北关区', 25),
(11858, 19, 11852, '林州市', '林州市', 30),
(11859, 19, 11852, '安阳县', '安阳县', 35),
(11860, 19, 11852, '滑县', '滑县', 40),
(11861, 19, 11852, '汤阴县', '汤阴县', 45),
(11862, 19, 11852, '内黄县', '内黄县', 50),
(11863, 19, 11766, '濮阳市', '濮阳市', 45),
(11864, 19, 11863, '濮阳县', '濮阳县', 5),
(11865, 19, 11863, '南乐县', '南乐县', 10),
(11866, 19, 11863, '台前县', '台前县', 15),
(11867, 19, 11863, '清丰县', '清丰县', 20),
(11868, 19, 11863, '范县', '范县', 25),
(11869, 19, 11863, '华龙区', '华龙区', 30),
(11870, 19, 11766, '许昌市', '许昌市', 50),
(11871, 19, 11870, '魏都区', '魏都区', 5),
(11872, 19, 11870, '禹州市', '禹州市', 10),
(11873, 19, 11870, '长葛市', '长葛市', 15),
(11874, 19, 11870, '许昌县', '许昌县', 20),
(11875, 19, 11870, '鄢陵县', '鄢陵县', 25),
(11876, 19, 11870, '襄城县', '襄城县', 30),
(11877, 19, 11766, '漯河市', '漯河市', 55),
(11878, 19, 11877, '郾城区', '郾城区', 5),
(11879, 19, 11877, '临颍县', '临颍县', 10),
(11880, 19, 11877, '召陵区', '召陵区', 15),
(11881, 19, 11877, '舞阳县', '舞阳县', 20),
(11882, 19, 11877, '源汇区', '源汇区', 25),
(11883, 19, 11766, '三门峡市', '三门峡市', 60),
(11884, 19, 11883, '渑池县', '渑池县', 5),
(11885, 19, 11883, '湖滨区', '湖滨区', 10),
(11886, 19, 11883, '义马市', '义马市', 15),
(11887, 19, 11883, '灵宝市', '灵宝市', 20),
(11888, 19, 11883, '陕县', '陕县', 25),
(11889, 19, 11883, '卢氏县', '卢氏县', 30),
(11890, 19, 11766, '南阳市', '南阳市', 65),
(11891, 19, 11890, '社旗县', '社旗县', 5),
(11892, 19, 11890, '西峡县', '西峡县', 10),
(11893, 19, 11890, '卧龙区', '卧龙区', 15),
(11894, 19, 11890, '宛城区', '宛城区', 20),
(11895, 19, 11890, '邓州市', '邓州市', 25),
(11896, 19, 11890, '桐柏县', '桐柏县', 30),
(11897, 19, 11890, '方城县', '方城县', 35),
(11898, 19, 11890, '淅川县', '淅川县', 40),
(11899, 19, 11890, '镇平县', '镇平县', 45),
(11900, 19, 11890, '唐河县', '唐河县', 50),
(11901, 19, 11890, '南召县', '南召县', 55),
(11902, 19, 11890, '内乡县', '内乡县', 60),
(11903, 19, 11890, '新野县', '新野县', 65),
(11904, 19, 11766, '商丘市', '商丘市', 70),
(11905, 19, 11904, '永城市', '永城市', 5),
(11906, 19, 11904, '宁陵县', '宁陵县', 10),
(11907, 19, 11904, '虞城县', '虞城县', 15),
(11908, 19, 11904, '民权县', '民权县', 20),
(11909, 19, 11904, '夏邑县', '夏邑县', 25),
(11910, 19, 11904, '柘城县', '柘城县', 30),
(11911, 19, 11904, '睢县', '睢县', 35),
(11912, 19, 11904, '睢阳区', '睢阳区', 40),
(11913, 19, 11904, '梁园区', '梁园区', 45),
(11914, 19, 11766, '周口市', '周口市', 75),
(11915, 19, 11914, '项城市', '项城市', 5),
(11916, 19, 11914, '商水县', '商水县', 10),
(11917, 19, 11914, '淮阳县', '淮阳县', 15),
(11918, 19, 11914, '太康县', '太康县', 20),
(11919, 19, 11914, '鹿邑县', '鹿邑县', 25),
(11920, 19, 11914, '西华县', '西华县', 30),
(11921, 19, 11914, '扶沟县', '扶沟县', 35),
(11922, 19, 11914, '沈丘县', '沈丘县', 40),
(11923, 19, 11914, '郸城县', '郸城县', 45),
(11924, 19, 11914, '川汇区', '川汇区', 50),
(11925, 19, 11914, '东新区', '东新区', 55),
(11926, 19, 11914, '经济开发区', '经济开发区', 60),
(11927, 19, 11766, '驻马店市', '驻马店市', 80),
(11928, 19, 11927, '确山县', '确山县', 5),
(11929, 19, 11927, '新蔡县', '新蔡县', 10),
(11930, 19, 11927, '上蔡县', '上蔡县', 15),
(11931, 19, 11927, '泌阳县', '泌阳县', 20),
(11932, 19, 11927, '西平县', '西平县', 25),
(11933, 19, 11927, '遂平县', '遂平县', 30),
(11934, 19, 11927, '汝南县', '汝南县', 35),
(11935, 19, 11927, '平舆县', '平舆县', 40),
(11936, 19, 11927, '正阳县', '正阳县', 45),
(11937, 19, 11927, '驿城区', '驿城区', 50),
(11938, 19, 11766, '信阳市', '信阳市', 85),
(11939, 19, 11938, '潢川县', '潢川县', 5),
(11940, 19, 11938, '淮滨县', '淮滨县', 10),
(11941, 19, 11938, '息县', '息县', 15),
(11942, 19, 11938, '新县', '新县', 20),
(11943, 19, 11938, '固始县', '固始县', 25),
(11944, 19, 11938, '罗山县', '罗山县', 30),
(11945, 19, 11938, '光山县', '光山县', 35),
(11946, 19, 11938, '商城县', '商城县', 40),
(11947, 19, 11938, '平桥区', '平桥区', 45),
(11948, 19, 11938, '浉河区', '浉河区', 50),
(11949, 19, 11766, '济源市', '济源市', 90),
(11950, 19, 11949, '城区', '城区', 5),
(11951, 19, 11949, '五龙口镇', '五龙口镇', 10),
(11952, 19, 11949, '下冶镇', '下冶镇', 15),
(11953, 19, 11949, '轵城镇', '轵城镇', 20),
(11954, 19, 11949, '王屋镇', '王屋镇', 25),
(11955, 19, 11949, '思礼镇', '思礼镇', 30),
(11956, 19, 11949, '邵原镇', '邵原镇', 35),
(11957, 19, 11949, '坡头镇', '坡头镇', 40),
(11958, 19, 11949, '梨林镇', '梨林镇', 45),
(11959, 19, 11949, '克井镇', '克井镇', 50),
(11960, 19, 11949, '大峪镇', '大峪镇', 55),
(11961, 19, 11949, '承留镇', '承留镇', 60),
(11962, 19, 0, '辽宁省', '辽宁省', 40),
(11963, 19, 11962, '沈阳市', '沈阳市', 5),
(11964, 19, 11963, '苏家屯区', '苏家屯区', 5),
(11965, 19, 11963, '新民市', '新民市', 10),
(11966, 19, 11963, '法库县', '法库县', 15),
(11967, 19, 11963, '辽中县', '辽中县', 20),
(11968, 19, 11963, '康平县', '康平县', 25),
(11969, 19, 11963, '皇姑区', '皇姑区', 30),
(11970, 19, 11963, '铁西区', '铁西区', 35),
(11971, 19, 11963, '大东区', '大东区', 40),
(11972, 19, 11963, '沈河区', '沈河区', 45),
(11973, 19, 11963, '东陵区', '东陵区', 50),
(11974, 19, 11963, '于洪区', '于洪区', 55),
(11975, 19, 11963, '和平区', '和平区', 60),
(11976, 19, 11963, '浑南新区', '浑南新区', 65),
(11977, 19, 11963, '沈北新区', '沈北新区', 70),
(11978, 19, 11962, '大连市', '大连市', 10),
(11979, 19, 11978, '中山区', '中山区', 5),
(11980, 19, 11978, '沙河口区', '沙河口区', 10),
(11981, 19, 11978, '西岗区', '西岗区', 15),
(11982, 19, 11978, '甘井子区', '甘井子区', 20),
(11983, 19, 11978, '高新园区', '高新园区', 25),
(11984, 19, 11978, '大连开发区', '大连开发区', 30),
(11985, 19, 11978, '金州区', '金州区', 35),
(11986, 19, 11978, '旅顺口区', '旅顺口区', 40),
(11987, 19, 11978, '普兰店市', '普兰店市', 45),
(11988, 19, 11978, '瓦房店市', '瓦房店市', 50),
(11989, 19, 11978, '庄河市', '庄河市', 55),
(11990, 19, 11978, '长海县', '长海县', 60),
(11991, 19, 11962, '鞍山市', '鞍山市', 15),
(11992, 19, 11991, '铁东区', '铁东区', 5),
(11993, 19, 11991, '立山区', '立山区', 10),
(11994, 19, 11991, '台安县', '台安县', 15),
(11995, 19, 11991, '海城市', '海城市', 20),
(11996, 19, 11991, '岫岩县', '岫岩县', 25),
(11997, 19, 11991, '铁西区', '铁西区', 30),
(11998, 19, 11991, '千山区', '千山区', 35),
(11999, 19, 11962, '抚顺市', '抚顺市', 20),
(12000, 19, 11999, '望花区', '望花区', 5),
(12001, 19, 11999, '东洲区', '东洲区', 10),
(12002, 19, 11999, '新抚区', '新抚区', 15),
(12003, 19, 11999, '顺城区', '顺城区', 20),
(12004, 19, 11999, '抚顺县', '抚顺县', 25),
(12005, 19, 11999, '新宾县', '新宾县', 30),
(12006, 19, 11999, '清原县', '清原县', 35),
(12007, 19, 11962, '本溪市', '本溪市', 25),
(12008, 19, 12007, '桓仁县', '桓仁县', 5),
(12009, 19, 12007, '本溪县', '本溪县', 10),
(12010, 19, 12007, '平山区', '平山区', 15),
(12011, 19, 12007, '溪湖区', '溪湖区', 20),
(12012, 19, 12007, '明山区', '明山区', 25),
(12013, 19, 12007, '南芬区', '南芬区', 30),
(12014, 19, 11962, '丹东市', '丹东市', 30),
(12015, 19, 12014, '元宝区', '元宝区', 5),
(12016, 19, 12014, '振兴区', '振兴区', 10),
(12017, 19, 12014, '振安区', '振安区', 15),
(12018, 19, 12014, '东港市', '东港市', 20),
(12019, 19, 12014, '凤城市', '凤城市', 25),
(12020, 19, 12014, '宽甸县', '宽甸县', 30),
(12021, 19, 11962, '锦州市', '锦州市', 35),
(12022, 19, 12021, '凌河区', '凌河区', 5),
(12023, 19, 12021, '古塔区', '古塔区', 10),
(12024, 19, 12021, '太和区', '太和区', 15),
(12025, 19, 12021, '义县', '义县', 20),
(12026, 19, 12021, '凌海市', '凌海市', 25),
(12027, 19, 12021, '北镇市', '北镇市', 30),
(12028, 19, 12021, '黑山县', '黑山县', 35),
(12029, 19, 12021, '经济技术开发区', '经济技术开发区', 40),
(12030, 19, 11962, '葫芦岛市', '葫芦岛市', 40),
(12031, 19, 12030, '龙港区', '龙港区', 5),
(12032, 19, 12030, '连山区', '连山区', 10),
(12033, 19, 12030, '兴城市', '兴城市', 15),
(12034, 19, 12030, '绥中县', '绥中县', 20),
(12035, 19, 12030, '建昌县', '建昌县', 25),
(12036, 19, 12030, '南票区', '南票区', 30),
(12037, 19, 11962, '营口市', '营口市', 45),
(12038, 19, 12037, '西市区', '西市区', 5),
(12039, 19, 12037, '站前区', '站前区', 10),
(12040, 19, 12037, '大石桥市', '大石桥市', 15),
(12041, 19, 12037, '盖州市', '盖州市', 20),
(12042, 19, 12037, '老边区', '老边区', 25),
(12043, 19, 12037, '鲅鱼圈区', '鲅鱼圈区', 30),
(12044, 19, 11962, '盘锦市', '盘锦市', 50),
(12045, 19, 12044, '盘山县', '盘山县', 5),
(12046, 19, 12044, '大洼县', '大洼县', 10),
(12047, 19, 12044, '兴隆台区', '兴隆台区', 15),
(12048, 19, 12044, '双台子区', '双台子区', 20),
(12049, 19, 11962, '阜新市', '阜新市', 55),
(12050, 19, 12049, '阜新县', '阜新县', 5),
(12051, 19, 12049, '彰武县', '彰武县', 10),
(12052, 19, 12049, '海州区', '海州区', 15),
(12053, 19, 12049, '太平区', '太平区', 20),
(12054, 19, 12049, '细河区', '细河区', 25),
(12055, 19, 12049, '清河门区', '清河门区', 30),
(12056, 19, 12049, '新邱区', '新邱区', 35),
(12057, 19, 11962, '辽阳市', '辽阳市', 60),
(12058, 19, 12057, '辽阳县', '辽阳县', 5),
(12059, 19, 12057, '白塔区', '白塔区', 10),
(12060, 19, 12057, '文圣区', '文圣区', 15),
(12061, 19, 12057, '灯塔市', '灯塔市', 20),
(12062, 19, 12057, '太子河区', '太子河区', 25),
(12063, 19, 12057, '弓长岭区', '弓长岭区', 30),
(12064, 19, 12057, '宏伟区', '宏伟区', 35),
(12065, 19, 11962, '朝阳市', '朝阳市', 65),
(12066, 19, 12065, '凌源市', '凌源市', 5),
(12067, 19, 12065, '北票市', '北票市', 10),
(12068, 19, 12065, '喀喇沁左翼县', '喀喇沁左翼县', 15),
(12069, 19, 12065, '朝阳县', '朝阳县', 20),
(12070, 19, 12065, '双塔区', '双塔区', 25),
(12071, 19, 12065, '建平县', '建平县', 30),
(12072, 19, 12065, '龙城区', '龙城区', 35),
(12073, 19, 11962, '铁岭市', '铁岭市', 70),
(12074, 19, 12073, '银州区', '银州区', 5),
(12075, 19, 12073, '清河区', '清河区', 10),
(12076, 19, 12073, '开原市', '开原市', 15),
(12077, 19, 12073, '铁岭县', '铁岭县', 20),
(12078, 19, 12073, '西丰县', '西丰县', 25),
(12079, 19, 12073, '昌图县', '昌图县', 30),
(12080, 19, 12073, '调兵山市', '调兵山市', 35),
(12081, 19, 0, '吉林省', '吉林省', 45),
(12082, 19, 12081, '长春市', '长春市', 5),
(12083, 19, 12082, '德惠市', '德惠市', 5),
(12084, 19, 12082, '榆树市', '榆树市', 10),
(12085, 19, 12082, '九台市', '九台市', 15),
(12086, 19, 12082, '农安县', '农安县', 20),
(12087, 19, 12082, '朝阳区', '朝阳区', 25),
(12088, 19, 12082, '南关区', '南关区', 30),
(12089, 19, 12082, '宽城区', '宽城区', 35),
(12090, 19, 12082, '二道区', '二道区', 40),
(12091, 19, 12082, '双阳区', '双阳区', 45),
(12092, 19, 12082, '绿园区', '绿园区', 50),
(12093, 19, 12082, '净月区', '净月区', 55),
(12094, 19, 12082, '汽车产业开发区', '汽车产业开发区', 60),
(12095, 19, 12082, '高新技术开发区', '高新技术开发区', 65),
(12096, 19, 12082, '经济技术开发区', '经济技术开发区', 70),
(12097, 19, 12081, '吉林市', '吉林市', 10),
(12098, 19, 12097, '昌邑区', '昌邑区', 5),
(12099, 19, 12097, '龙潭区', '龙潭区', 10),
(12100, 19, 12097, '船营区', '船营区', 15),
(12101, 19, 12097, '丰满区', '丰满区', 20),
(12102, 19, 12097, '舒兰市', '舒兰市', 25),
(12103, 19, 12097, '桦甸市', '桦甸市', 30),
(12104, 19, 12097, '蛟河市', '蛟河市', 35),
(12105, 19, 12097, '磐石市', '磐石市', 40),
(12106, 19, 12097, '永吉县', '永吉县', 45),
(12107, 19, 12081, '四平市', '四平市', 15),
(12108, 19, 12107, '铁东区', '铁东区', 5),
(12109, 19, 12107, '铁西区', '铁西区', 10),
(12110, 19, 12107, '公主岭市', '公主岭市', 15),
(12111, 19, 12107, '双辽市', '双辽市', 20),
(12112, 19, 12107, '梨树县', '梨树县', 25),
(12113, 19, 12107, '伊通县', '伊通县', 30),
(12114, 19, 12081, '通化市', '通化市', 20),
(12115, 19, 12114, '东昌区', '东昌区', 5),
(12116, 19, 12114, '梅河口市', '梅河口市', 10),
(12117, 19, 12114, '集安市', '集安市', 15),
(12118, 19, 12114, '通化县', '通化县', 20),
(12119, 19, 12114, '辉南县', '辉南县', 25),
(12120, 19, 12114, '柳河县', '柳河县', 30),
(12121, 19, 12114, '二道江区', '二道江区', 35),
(12122, 19, 12081, '白山市', '白山市', 25),
(12123, 19, 12122, '浑江区', '浑江区', 5),
(12124, 19, 12122, '临江市', '临江市', 10),
(12125, 19, 12122, '江源区', '江源区', 15),
(12126, 19, 12122, '靖宇县', '靖宇县', 20),
(12127, 19, 12122, '抚松县', '抚松县', 25),
(12128, 19, 12122, '长白县', '长白县', 30),
(12129, 19, 12081, '松原市', '松原市', 30),
(12130, 19, 12129, '宁江区', '宁江区', 5),
(12131, 19, 12129, '前郭县', '前郭县', 10),
(12132, 19, 12129, '乾安县', '乾安县', 15),
(12133, 19, 12129, '长岭县', '长岭县', 20),
(12134, 19, 12129, '扶余县', '扶余县', 25),
(12135, 19, 12081, '白城市', '白城市', 35),
(12136, 19, 12135, '大安市', '大安市', 5),
(12137, 19, 12135, '洮南市', '洮南市', 10),
(12138, 19, 12135, '通榆县', '通榆县', 15),
(12139, 19, 12135, '镇赉县', '镇赉县', 20),
(12140, 19, 12135, '洮北区', '洮北区', 25),
(12141, 19, 12081, '延边州', '延边州', 40),
(12142, 19, 12141, '延吉市', '延吉市', 5),
(12143, 19, 12141, '图们市', '图们市', 10),
(12144, 19, 12141, '敦化市', '敦化市', 15),
(12145, 19, 12141, '珲春市', '珲春市', 20),
(12146, 19, 12141, '龙井市', '龙井市', 25),
(12147, 19, 12141, '和龙市', '和龙市', 30),
(12148, 19, 12141, '汪清县', '汪清县', 35),
(12149, 19, 12141, '安图县', '安图县', 40),
(12150, 19, 12081, '辽源市', '辽源市', 45),
(12151, 19, 12150, '龙山区', '龙山区', 5),
(12152, 19, 12150, '西安区', '西安区', 10),
(12153, 19, 12150, '东丰县', '东丰县', 15),
(12154, 19, 12150, '东辽县', '东辽县', 20),
(12155, 19, 0, '黑龙江省', '黑龙江省', 50),
(12156, 19, 12155, '哈尔滨市', '哈尔滨市', 5),
(12157, 19, 12156, '阿城区', '阿城区', 5),
(12158, 19, 12156, '尚志市', '尚志市', 10),
(12159, 19, 12156, '双城市', '双城市', 15),
(12160, 19, 12156, '五常市', '五常市', 20),
(12161, 19, 12156, '方正县', '方正县', 25),
(12162, 19, 12156, '宾县', '宾县', 30),
(12163, 19, 12156, '依兰县', '依兰县', 35),
(12164, 19, 12156, '巴彦县', '巴彦县', 40),
(12165, 19, 12156, '通河县', '通河县', 45),
(12166, 19, 12156, '木兰县', '木兰县', 50),
(12167, 19, 12156, '延寿县', '延寿县', 55),
(12168, 19, 12156, '呼兰区', '呼兰区', 60),
(12169, 19, 12156, '松北区', '松北区', 65),
(12170, 19, 12156, '道里区', '道里区', 70),
(12171, 19, 12156, '南岗区', '南岗区', 75),
(12172, 19, 12156, '道外区', '道外区', 80),
(12173, 19, 12156, '香坊区', '香坊区', 85);
INSERT INTO `qinggan_opt` (`id`, `group_id`, `parent_id`, `title`, `val`, `taxis`) VALUES
(12174, 19, 12156, '平房区', '平房区', 90),
(12175, 19, 12155, '齐齐哈尔市', '齐齐哈尔市', 10),
(12176, 19, 12175, '建华区', '建华区', 5),
(12177, 19, 12175, '龙沙区', '龙沙区', 10),
(12178, 19, 12175, '铁锋区', '铁锋区', 15),
(12179, 19, 12175, '梅里斯区', '梅里斯区', 20),
(12180, 19, 12175, '昂昂溪区', '昂昂溪区', 25),
(12181, 19, 12175, '富拉尔基区', '富拉尔基区', 30),
(12182, 19, 12175, '碾子山区', '碾子山区', 35),
(12183, 19, 12175, '讷河市', '讷河市', 40),
(12184, 19, 12175, '富裕县', '富裕县', 45),
(12185, 19, 12175, '拜泉县', '拜泉县', 50),
(12186, 19, 12175, '甘南县', '甘南县', 55),
(12187, 19, 12175, '依安县', '依安县', 60),
(12188, 19, 12175, '克山县', '克山县', 65),
(12189, 19, 12175, '龙江县', '龙江县', 70),
(12190, 19, 12175, '克东县', '克东县', 75),
(12191, 19, 12175, '泰来县', '泰来县', 80),
(12192, 19, 12155, '鹤岗市', '鹤岗市', 15),
(12193, 19, 12192, '兴山区', '兴山区', 5),
(12194, 19, 12192, '向阳区', '向阳区', 10),
(12195, 19, 12192, '工农区', '工农区', 15),
(12196, 19, 12192, '南山区', '南山区', 20),
(12197, 19, 12192, '兴安区', '兴安区', 25),
(12198, 19, 12192, '东山区', '东山区', 30),
(12199, 19, 12192, '萝北县', '萝北县', 35),
(12200, 19, 12192, '绥滨县', '绥滨县', 40),
(12201, 19, 12155, '双鸭山市', '双鸭山市', 20),
(12202, 19, 12201, '尖山区', '尖山区', 5),
(12203, 19, 12201, '岭东区', '岭东区', 10),
(12204, 19, 12201, '四方台区', '四方台区', 15),
(12205, 19, 12201, '宝山区', '宝山区', 20),
(12206, 19, 12201, '集贤县', '集贤县', 25),
(12207, 19, 12201, '宝清县', '宝清县', 30),
(12208, 19, 12201, '友谊县', '友谊县', 35),
(12209, 19, 12201, '饶河县', '饶河县', 40),
(12210, 19, 12155, '鸡西市', '鸡西市', 25),
(12211, 19, 12210, '恒山区', '恒山区', 5),
(12212, 19, 12210, '滴道区', '滴道区', 10),
(12213, 19, 12210, '梨树区', '梨树区', 15),
(12214, 19, 12210, '城子河区', '城子河区', 20),
(12215, 19, 12210, '麻山区', '麻山区', 25),
(12216, 19, 12210, '鸡冠区', '鸡冠区', 30),
(12217, 19, 12210, '密山市', '密山市', 35),
(12218, 19, 12210, '虎林市', '虎林市', 40),
(12219, 19, 12210, '鸡东县', '鸡东县', 45),
(12220, 19, 12155, '大庆市', '大庆市', 30),
(12221, 19, 12220, '萨尔图区', '萨尔图区', 5),
(12222, 19, 12220, '龙凤区', '龙凤区', 10),
(12223, 19, 12220, '让胡路区', '让胡路区', 15),
(12224, 19, 12220, '红岗区', '红岗区', 20),
(12225, 19, 12220, '大同区', '大同区', 25),
(12226, 19, 12220, '林甸县', '林甸县', 30),
(12227, 19, 12220, '肇州县', '肇州县', 35),
(12228, 19, 12220, '肇源县', '肇源县', 40),
(12229, 19, 12220, '杜尔伯特县', '杜尔伯特县', 45),
(12230, 19, 12155, '伊春市', '伊春市', 35),
(12231, 19, 12230, '伊春区', '伊春区', 5),
(12232, 19, 12230, '南岔区', '南岔区', 10),
(12233, 19, 12230, '友好区', '友好区', 15),
(12234, 19, 12230, '西林区', '西林区', 20),
(12235, 19, 12230, '翠峦区', '翠峦区', 25),
(12236, 19, 12230, '新青区', '新青区', 30),
(12237, 19, 12230, '美溪区', '美溪区', 35),
(12238, 19, 12230, '金山屯区', '金山屯区', 40),
(12239, 19, 12230, '五营区', '五营区', 45),
(12240, 19, 12230, '乌马河区', '乌马河区', 50),
(12241, 19, 12230, '汤旺河区', '汤旺河区', 55),
(12242, 19, 12230, '带岭区', '带岭区', 60),
(12243, 19, 12230, '乌伊岭区', '乌伊岭区', 65),
(12244, 19, 12230, '红星区', '红星区', 70),
(12245, 19, 12230, '上甘岭区', '上甘岭区', 75),
(12246, 19, 12230, '铁力市', '铁力市', 80),
(12247, 19, 12230, '嘉荫县', '嘉荫县', 85),
(12248, 19, 12155, '牡丹江市', '牡丹江市', 40),
(12249, 19, 12248, '爱民区', '爱民区', 5),
(12250, 19, 12248, '东安区', '东安区', 10),
(12251, 19, 12248, '阳明区', '阳明区', 15),
(12252, 19, 12248, '西安区', '西安区', 20),
(12253, 19, 12248, '绥芬河市', '绥芬河市', 25),
(12254, 19, 12248, '海林市', '海林市', 30),
(12255, 19, 12248, '宁安市', '宁安市', 35),
(12256, 19, 12248, '穆棱市', '穆棱市', 40),
(12257, 19, 12248, '林口县', '林口县', 45),
(12258, 19, 12248, '东宁县', '东宁县', 50),
(12259, 19, 12155, '佳木斯市', '佳木斯市', 45),
(12260, 19, 12259, '桦川县', '桦川县', 5),
(12261, 19, 12259, '抚远县', '抚远县', 10),
(12262, 19, 12259, '桦南县', '桦南县', 15),
(12263, 19, 12259, '汤原县', '汤原县', 20),
(12264, 19, 12259, '前进区', '前进区', 25),
(12265, 19, 12259, '向阳区', '向阳区', 30),
(12266, 19, 12259, '东风区', '东风区', 35),
(12267, 19, 12259, '郊区', '郊区', 40),
(12268, 19, 12259, '同江市', '同江市', 45),
(12269, 19, 12259, '富锦市', '富锦市', 50),
(12270, 19, 12155, '七台河市', '七台河市', 50),
(12271, 19, 12270, '勃利县', '勃利县', 5),
(12272, 19, 12270, '桃山区', '桃山区', 10),
(12273, 19, 12270, '新兴区', '新兴区', 15),
(12274, 19, 12270, '茄子河区', '茄子河区', 20),
(12275, 19, 12155, '黑河市', '黑河市', 55),
(12276, 19, 12275, '北安市', '北安市', 5),
(12277, 19, 12275, '五大连池市', '五大连池市', 10),
(12278, 19, 12275, '逊克县', '逊克县', 15),
(12279, 19, 12275, '孙吴县', '孙吴县', 20),
(12280, 19, 12275, '嫩江县', '嫩江县', 25),
(12281, 19, 12275, '爱辉区', '爱辉区', 30),
(12282, 19, 12155, '绥化市', '绥化市', 60),
(12283, 19, 12282, '北林区', '北林区', 5),
(12284, 19, 12282, '安达市', '安达市', 10),
(12285, 19, 12282, '肇东市', '肇东市', 15),
(12286, 19, 12282, '海伦市', '海伦市', 20),
(12287, 19, 12282, '绥棱县', '绥棱县', 25),
(12288, 19, 12282, '兰西县', '兰西县', 30),
(12289, 19, 12282, '明水县', '明水县', 35),
(12290, 19, 12282, '青冈县', '青冈县', 40),
(12291, 19, 12282, '庆安县', '庆安县', 45),
(12292, 19, 12282, '望奎县', '望奎县', 50),
(12293, 19, 12155, '大兴安岭地区', '大兴安岭地区', 65),
(12294, 19, 12293, '加格达奇区', '加格达奇区', 5),
(12295, 19, 12293, '松岭区', '松岭区', 10),
(12296, 19, 12293, '呼中区', '呼中区', 15),
(12297, 19, 12293, '呼玛县', '呼玛县', 20),
(12298, 19, 12293, '塔河县', '塔河县', 25),
(12299, 19, 12293, '漠河县', '漠河县', 30),
(12300, 19, 12293, '新林区', '新林区', 35),
(12301, 19, 0, '内蒙古自治区', '内蒙古自治区', 55),
(12302, 19, 12301, '呼和浩特市', '呼和浩特市', 5),
(12303, 19, 12302, '玉泉区', '玉泉区', 5),
(12304, 19, 12302, '赛罕区', '赛罕区', 10),
(12305, 19, 12302, '土默特左旗', '土默特左旗', 15),
(12306, 19, 12302, '和林格尔县', '和林格尔县', 20),
(12307, 19, 12302, '武川县', '武川县', 25),
(12308, 19, 12302, '托克托县', '托克托县', 30),
(12309, 19, 12302, '清水河县', '清水河县', 35),
(12310, 19, 12302, '回民区', '回民区', 40),
(12311, 19, 12302, '新城区', '新城区', 45),
(12312, 19, 12301, '包头市', '包头市', 10),
(12313, 19, 12312, '固阳县', '固阳县', 5),
(12314, 19, 12312, '土默特右旗', '土默特右旗', 10),
(12315, 19, 12312, '达茂联合旗', '达茂联合旗', 15),
(12316, 19, 12312, '东河区', '东河区', 20),
(12317, 19, 12312, '九原区', '九原区', 25),
(12318, 19, 12312, '青山区', '青山区', 30),
(12319, 19, 12312, '昆都仑区', '昆都仑区', 35),
(12320, 19, 12312, '石拐区', '石拐区', 40),
(12321, 19, 12312, '白云矿区', '白云矿区', 45),
(12322, 19, 12301, '乌海市', '乌海市', 15),
(12323, 19, 12322, '海勃湾区', '海勃湾区', 5),
(12324, 19, 12322, '海南区', '海南区', 10),
(12325, 19, 12322, '乌达区', '乌达区', 15),
(12326, 19, 12301, '赤峰市', '赤峰市', 20),
(12327, 19, 12326, '宁城县', '宁城县', 5),
(12328, 19, 12326, '敖汉旗', '敖汉旗', 10),
(12329, 19, 12326, '喀喇沁旗', '喀喇沁旗', 15),
(12330, 19, 12326, '翁牛特旗', '翁牛特旗', 20),
(12331, 19, 12326, '巴林右旗', '巴林右旗', 25),
(12332, 19, 12326, '林西县', '林西县', 30),
(12333, 19, 12326, '克什克腾旗', '克什克腾旗', 35),
(12334, 19, 12326, '巴林左旗', '巴林左旗', 40),
(12335, 19, 12326, '阿鲁科尔沁旗', '阿鲁科尔沁旗', 45),
(12336, 19, 12326, '元宝山区', '元宝山区', 50),
(12337, 19, 12326, '红山区', '红山区', 55),
(12338, 19, 12326, '松山区', '松山区', 60),
(12339, 19, 12301, '乌兰察布市', '乌兰察布市', 25),
(12340, 19, 12339, '集宁区', '集宁区', 5),
(12341, 19, 12339, '丰镇市', '丰镇市', 10),
(12342, 19, 12339, '兴和县', '兴和县', 15),
(12343, 19, 12339, '卓资县', '卓资县', 20),
(12344, 19, 12339, '商都县', '商都县', 25),
(12345, 19, 12339, '凉城县', '凉城县', 30),
(12346, 19, 12339, '化德县', '化德县', 35),
(12347, 19, 12339, '察哈尔右翼前旗', '察哈尔右翼前旗', 40),
(12348, 19, 12339, '察哈尔右翼中旗', '察哈尔右翼中旗', 45),
(12349, 19, 12339, '察哈尔右翼后旗', '察哈尔右翼后旗', 50),
(12350, 19, 12339, '四子王旗', '四子王旗', 55),
(12351, 19, 12301, '锡林郭勒盟', '锡林郭勒盟', 30),
(12352, 19, 12351, '锡林浩特市', '锡林浩特市', 5),
(12353, 19, 12351, '二连浩特市', '二连浩特市', 10),
(12354, 19, 12351, '多伦县', '多伦县', 15),
(12355, 19, 12351, '阿巴嘎旗', '阿巴嘎旗', 20),
(12356, 19, 12351, '西乌珠穆沁旗', '西乌珠穆沁旗', 25),
(12357, 19, 12351, '东乌珠穆沁旗', '东乌珠穆沁旗', 30),
(12358, 19, 12351, '苏尼特右旗', '苏尼特右旗', 35),
(12359, 19, 12351, '苏尼特左旗', '苏尼特左旗', 40),
(12360, 19, 12351, '太仆寺旗', '太仆寺旗', 45),
(12361, 19, 12351, '正镶白旗', '正镶白旗', 50),
(12362, 19, 12351, '正蓝旗', '正蓝旗', 55),
(12363, 19, 12351, '镶黄旗', '镶黄旗', 60),
(12364, 19, 12301, '呼伦贝尔市', '呼伦贝尔市', 35),
(12365, 19, 12364, '海拉尔区', '海拉尔区', 5),
(12366, 19, 12364, '满洲里市', '满洲里市', 10),
(12367, 19, 12364, '牙克石市', '牙克石市', 15),
(12368, 19, 12364, '扎兰屯市', '扎兰屯市', 20),
(12369, 19, 12364, '根河市', '根河市', 25),
(12370, 19, 12364, '额尔古纳市', '额尔古纳市', 30),
(12371, 19, 12364, '陈巴尔虎旗', '陈巴尔虎旗', 35),
(12372, 19, 12364, '阿荣旗', '阿荣旗', 40),
(12373, 19, 12364, '新巴尔虎左旗', '新巴尔虎左旗', 45),
(12374, 19, 12364, '新巴尔虎右旗', '新巴尔虎右旗', 50),
(12375, 19, 12364, '鄂伦春旗', '鄂伦春旗', 55),
(12376, 19, 12364, '莫力达瓦旗', '莫力达瓦旗', 60),
(12377, 19, 12364, '鄂温克族旗', '鄂温克族旗', 65),
(12378, 19, 12301, '鄂尔多斯市', '鄂尔多斯市', 40),
(12379, 19, 12378, '东胜区', '东胜区', 5),
(12380, 19, 12378, '准格尔旗', '准格尔旗', 10),
(12381, 19, 12378, '伊金霍洛旗', '伊金霍洛旗', 15),
(12382, 19, 12378, '乌审旗', '乌审旗', 20),
(12383, 19, 12378, '杭锦旗', '杭锦旗', 25),
(12384, 19, 12378, '鄂托克旗', '鄂托克旗', 30),
(12385, 19, 12378, '鄂托克前旗', '鄂托克前旗', 35),
(12386, 19, 12378, '达拉特旗', '达拉特旗', 40),
(12387, 19, 12378, '康巴什新区', '康巴什新区', 45),
(12388, 19, 12301, '巴彦淖尔市', '巴彦淖尔市', 45),
(12389, 19, 12388, '临河区', '临河区', 5),
(12390, 19, 12388, '五原县', '五原县', 10),
(12391, 19, 12388, '磴口县', '磴口县', 15),
(12392, 19, 12388, '杭锦后旗', '杭锦后旗', 20),
(12393, 19, 12388, '乌拉特中旗', '乌拉特中旗', 25),
(12394, 19, 12388, '乌拉特后旗 ', '乌拉特后旗 ', 30),
(12395, 19, 12388, '乌拉特前旗', '乌拉特前旗', 35),
(12396, 19, 12301, '阿拉善盟', '阿拉善盟', 50),
(12397, 19, 12396, '阿拉善右旗', '阿拉善右旗', 5),
(12398, 19, 12396, '阿拉善左旗', '阿拉善左旗', 10),
(12399, 19, 12396, '额济纳旗', '额济纳旗', 15),
(12400, 19, 12301, '兴安盟', '兴安盟', 55),
(12401, 19, 12400, '乌兰浩特市', '乌兰浩特市', 5),
(12402, 19, 12400, '阿尔山市', '阿尔山市', 10),
(12403, 19, 12400, '突泉县', '突泉县', 15),
(12404, 19, 12400, '扎赉特旗', '扎赉特旗', 20),
(12405, 19, 12400, '科尔沁右翼前旗', '科尔沁右翼前旗', 25),
(12406, 19, 12400, '科尔沁右翼中旗', '科尔沁右翼中旗', 30),
(12407, 19, 12301, '通辽市', '通辽市', 60),
(12408, 19, 12407, '科尔沁区', '科尔沁区', 5),
(12409, 19, 12407, '霍林郭勒市', '霍林郭勒市', 10),
(12410, 19, 12407, '开鲁县', '开鲁县', 15),
(12411, 19, 12407, '库伦旗', '库伦旗', 20),
(12412, 19, 12407, '奈曼旗', '奈曼旗', 25),
(12413, 19, 12407, '扎鲁特旗', '扎鲁特旗', 30),
(12414, 19, 12407, '科尔沁左翼中旗', '科尔沁左翼中旗', 35),
(12415, 19, 12407, '科尔沁左翼后旗', '科尔沁左翼后旗', 40),
(12416, 19, 0, '江苏省', '江苏省', 60),
(12417, 19, 12416, '南京市', '南京市', 5),
(12418, 19, 12417, '玄武区', '玄武区', 5),
(12419, 19, 12417, '秦淮区', '秦淮区', 10),
(12420, 19, 12417, '建邺区', '建邺区', 15),
(12421, 19, 12417, '鼓楼区', '鼓楼区', 20),
(12422, 19, 12417, '栖霞区', '栖霞区', 25),
(12423, 19, 12417, '江宁区', '江宁区', 30),
(12424, 19, 12417, '六合区', '六合区', 35),
(12425, 19, 12417, '雨花台区', '雨花台区', 40),
(12426, 19, 12417, '高淳区', '高淳区', 45),
(12427, 19, 12417, '溧水区', '溧水区', 50),
(12428, 19, 12417, '浦口区', '浦口区', 55),
(12429, 19, 12416, '徐州市', '徐州市', 10),
(12430, 19, 12429, '贾汪区', '贾汪区', 5),
(12431, 19, 12429, '金山桥开发区', '金山桥开发区', 10),
(12432, 19, 12429, '铜山经济技术开发区', '铜山经济技术开发区', 15),
(12433, 19, 12429, '八段工业园区', '八段工业园区', 20),
(12434, 19, 12429, '鼓楼区', '鼓楼区', 25),
(12435, 19, 12429, '邳州市', '邳州市', 30),
(12436, 19, 12429, '泉山区', '泉山区', 35),
(12437, 19, 12429, '新沂市', '新沂市', 40),
(12438, 19, 12429, '云龙区', '云龙区', 45),
(12439, 19, 12429, '铜山区', '铜山区', 50),
(12440, 19, 12429, '睢宁县', '睢宁县', 55),
(12441, 19, 12429, '沛县', '沛县', 60),
(12442, 19, 12429, '丰县', '丰县', 65),
(12443, 19, 12416, '连云港市', '连云港市', 15),
(12444, 19, 12443, '海州区', '海州区', 5),
(12445, 19, 12443, '新浦区', '新浦区', 10),
(12446, 19, 12443, '赣榆县', '赣榆县', 15),
(12447, 19, 12443, '连云区', '连云区', 20),
(12448, 19, 12443, '灌云县', '灌云县', 25),
(12449, 19, 12443, '东海县', '东海县', 30),
(12450, 19, 12443, '灌南县', '灌南县', 35),
(12451, 19, 12416, '淮安市', '淮安市', 20),
(12452, 19, 12451, '经济开发区', '经济开发区', 5),
(12453, 19, 12451, '楚州区', '楚州区', 10),
(12454, 19, 12451, '洪泽县', '洪泽县', 15),
(12455, 19, 12451, '金湖县', '金湖县', 20),
(12456, 19, 12451, '盱眙县', '盱眙县', 25),
(12457, 19, 12451, '清河区', '清河区', 30),
(12458, 19, 12451, '淮阴区', '淮阴区', 35),
(12459, 19, 12451, '清浦区', '清浦区', 40),
(12460, 19, 12451, '涟水县', '涟水县', 45),
(12461, 19, 12416, '宿迁市', '宿迁市', 25),
(12462, 19, 12461, '宿城区', '宿城区', 5),
(12463, 19, 12461, '沭阳县', '沭阳县', 10),
(12464, 19, 12461, '泗阳县', '泗阳县', 15),
(12465, 19, 12461, '宿豫区', '宿豫区', 20),
(12466, 19, 12461, '泗洪县', '泗洪县', 25),
(12467, 19, 12461, '宿迁经济开发区', '宿迁经济开发区', 30),
(12468, 19, 12416, '盐城市', '盐城市', 30),
(12469, 19, 12468, '射阳县', '射阳县', 5),
(12470, 19, 12468, '亭湖区', '亭湖区', 10),
(12471, 19, 12468, '盐都区', '盐都区', 15),
(12472, 19, 12468, '东台市', '东台市', 20),
(12473, 19, 12468, '大丰市', '大丰市', 25),
(12474, 19, 12468, '建湖县', '建湖县', 30),
(12475, 19, 12468, '响水县', '响水县', 35),
(12476, 19, 12468, '阜宁县', '阜宁县', 40),
(12477, 19, 12468, '滨海县', '滨海县', 45),
(12478, 19, 12416, '扬州市', '扬州市', 35),
(12479, 19, 12478, '广陵区', '广陵区', 5),
(12480, 19, 12478, '邗江区', '邗江区', 10),
(12481, 19, 12478, '宝应县', '宝应县', 15),
(12482, 19, 12478, '仪征市', '仪征市', 20),
(12483, 19, 12478, '高邮市', '高邮市', 25),
(12484, 19, 12478, '江都区', '江都区', 30),
(12485, 19, 12416, '泰州市', '泰州市', 40),
(12486, 19, 12485, '海陵区', '海陵区', 5),
(12487, 19, 12485, '高港区', '高港区', 10),
(12488, 19, 12485, '泰兴市', '泰兴市', 15),
(12489, 19, 12485, '靖江市', '靖江市', 20),
(12490, 19, 12485, '兴化市', '兴化市', 25),
(12491, 19, 12485, '姜堰市', '姜堰市', 30),
(12492, 19, 12416, '南通市', '南通市', 45),
(12493, 19, 12492, '港闸区', '港闸区', 5),
(12494, 19, 12492, '崇川区', '崇川区', 10),
(12495, 19, 12492, '通州区', '通州区', 15),
(12496, 19, 12492, '南通经济技术开发区', '南通经济技术开发区', 20),
(12497, 19, 12492, '如东县', '如东县', 25),
(12498, 19, 12492, '海安县', '海安县', 30),
(12499, 19, 12492, '如皋市', '如皋市', 35),
(12500, 19, 12492, '海门市', '海门市', 40),
(12501, 19, 12492, '启东市', '启东市', 45),
(12502, 19, 12416, '镇江市', '镇江市', 50),
(12503, 19, 12502, '润州区', '润州区', 5),
(12504, 19, 12502, '京口区', '京口区', 10),
(12505, 19, 12502, '丹徒区', '丹徒区', 15),
(12506, 19, 12502, '镇江新区', '镇江新区', 20),
(12507, 19, 12502, '丹阳市', '丹阳市', 25),
(12508, 19, 12502, '句容市', '句容市', 30),
(12509, 19, 12502, '扬中市', '扬中市', 35),
(12510, 19, 12502, '丹徒新区', '丹徒新区', 40),
(12511, 19, 12416, '常州市', '常州市', 55),
(12512, 19, 12511, '钟楼区', '钟楼区', 5),
(12513, 19, 12511, '天宁区', '天宁区', 10),
(12514, 19, 12511, '武进区', '武进区', 15),
(12515, 19, 12511, '新北区', '新北区', 20),
(12516, 19, 12511, '戚墅堰区', '戚墅堰区', 25),
(12517, 19, 12511, '金坛市', '金坛市', 30),
(12518, 19, 12511, '溧阳市', '溧阳市', 35),
(12519, 19, 12416, '无锡市', '无锡市', 60),
(12520, 19, 12519, '崇安区', '崇安区', 5),
(12521, 19, 12519, '南长区', '南长区', 10),
(12522, 19, 12519, '北塘区', '北塘区', 15),
(12523, 19, 12519, '锡山区', '锡山区', 20),
(12524, 19, 12519, '惠山区', '惠山区', 25),
(12525, 19, 12519, '新区', '新区', 30),
(12526, 19, 12519, '江阴市', '江阴市', 35),
(12527, 19, 12519, '宜兴市', '宜兴市', 40),
(12528, 19, 12519, '滨湖区', '滨湖区', 45),
(12529, 19, 12416, '苏州市', '苏州市', 65),
(12530, 19, 12529, '常熟市', '常熟市', 5),
(12531, 19, 12529, '张家港市', '张家港市', 10),
(12532, 19, 12529, '太仓市', '太仓市', 15),
(12533, 19, 12529, '相城区', '相城区', 20),
(12534, 19, 12529, '金阊区', '金阊区', 25),
(12535, 19, 12529, '虎丘区', '虎丘区', 30),
(12536, 19, 12529, '平江区', '平江区', 35),
(12537, 19, 12529, '沧浪区', '沧浪区', 40),
(12538, 19, 12529, '工业园区', '工业园区', 45),
(12539, 19, 12529, '高新区', '高新区', 50),
(12540, 19, 12529, '吴江区', '吴江区', 55),
(12541, 19, 12529, '吴中区', '吴中区', 60),
(12542, 19, 12529, '昆山市', '昆山市', 65),
(12543, 19, 0, '山东省', '山东省', 65),
(12544, 19, 12543, '济南市', '济南市', 5),
(12545, 19, 12544, '高新区', '高新区', 5),
(12546, 19, 12544, '长清区', '长清区', 10),
(12547, 19, 12544, '历城区', '历城区', 15),
(12548, 19, 12544, '天桥区', '天桥区', 20),
(12549, 19, 12544, '槐荫区', '槐荫区', 25),
(12550, 19, 12544, '历下区', '历下区', 30),
(12551, 19, 12544, '市中区', '市中区', 35),
(12552, 19, 12544, '章丘市', '章丘市', 40),
(12553, 19, 12544, '平阴县', '平阴县', 45),
(12554, 19, 12544, '济阳县', '济阳县', 50),
(12555, 19, 12544, '商河县', '商河县', 55),
(12556, 19, 12543, '青岛市', '青岛市', 10),
(12557, 19, 12556, '四方区', '四方区', 5),
(12558, 19, 12556, '市北区', '市北区', 10),
(12559, 19, 12556, '市南区', '市南区', 15),
(12560, 19, 12556, '黄岛区', '黄岛区', 20),
(12561, 19, 12556, '李沧区', '李沧区', 25),
(12562, 19, 12556, '即墨市', '即墨市', 30),
(12563, 19, 12556, '城阳区', '城阳区', 35),
(12564, 19, 12556, '崂山区', '崂山区', 40),
(12565, 19, 12556, '胶州市', '胶州市', 45),
(12566, 19, 12556, '平度市', '平度市', 50),
(12567, 19, 12556, '莱西市', '莱西市', 55),
(12568, 19, 12543, '淄博市', '淄博市', 15),
(12569, 19, 12568, '临淄区', '临淄区', 5),
(12570, 19, 12568, '张店区', '张店区', 10),
(12571, 19, 12568, '周村区', '周村区', 15),
(12572, 19, 12568, '淄川区', '淄川区', 20),
(12573, 19, 12568, '博山区', '博山区', 25),
(12574, 19, 12568, '高青县', '高青县', 30),
(12575, 19, 12568, '沂源县', '沂源县', 35),
(12576, 19, 12568, '桓台县', '桓台县', 40),
(12577, 19, 12543, '枣庄市', '枣庄市', 20),
(12578, 19, 12577, '滕州市', '滕州市', 5),
(12579, 19, 12577, '山亭区', '山亭区', 10),
(12580, 19, 12577, '台儿庄区', '台儿庄区', 15),
(12581, 19, 12577, '峄城区', '峄城区', 20),
(12582, 19, 12577, '薛城区', '薛城区', 25),
(12583, 19, 12577, '市中区', '市中区', 30),
(12584, 19, 12543, '东营市', '东营市', 25),
(12585, 19, 12584, '河口区', '河口区', 5),
(12586, 19, 12584, '广饶县', '广饶县', 10),
(12587, 19, 12584, '利津县', '利津县', 15),
(12588, 19, 12584, '垦利县', '垦利县', 20),
(12589, 19, 12584, '东营区', '东营区', 25),
(12590, 19, 12543, '潍坊市', '潍坊市', 30),
(12591, 19, 12590, '潍城区', '潍城区', 5),
(12592, 19, 12590, '奎文区', '奎文区', 10),
(12593, 19, 12590, '高新区', '高新区', 15),
(12594, 19, 12590, '寒亭区', '寒亭区', 20),
(12595, 19, 12590, '寿光市', '寿光市', 25),
(12596, 19, 12590, '青州市', '青州市', 30),
(12597, 19, 12590, '诸城市', '诸城市', 35),
(12598, 19, 12590, '安丘市', '安丘市', 40),
(12599, 19, 12590, '高密市', '高密市', 45),
(12600, 19, 12590, '昌邑市', '昌邑市', 50),
(12601, 19, 12590, '昌乐县', '昌乐县', 55),
(12602, 19, 12590, '临朐县', '临朐县', 60),
(12603, 19, 12590, '坊子区', '坊子区', 65),
(12604, 19, 12543, '烟台市', '烟台市', 35),
(12605, 19, 12604, '莱山区', '莱山区', 5),
(12606, 19, 12604, '芝罘区', '芝罘区', 10),
(12607, 19, 12604, '开发区', '开发区', 15),
(12608, 19, 12604, '福山区', '福山区', 20),
(12609, 19, 12604, '牟平区', '牟平区', 25),
(12610, 19, 12604, '龙口市', '龙口市', 30),
(12611, 19, 12604, '莱州市', '莱州市', 35),
(12612, 19, 12604, '莱阳市', '莱阳市', 40),
(12613, 19, 12604, '招远市', '招远市', 45),
(12614, 19, 12604, '蓬莱市', '蓬莱市', 50),
(12615, 19, 12604, '栖霞市', '栖霞市', 55),
(12616, 19, 12604, '海阳市', '海阳市', 60),
(12617, 19, 12604, '长岛县', '长岛县', 65),
(12618, 19, 12543, '威海市', '威海市', 40),
(12619, 19, 12618, '荣成市', '荣成市', 5),
(12620, 19, 12618, '文登市', '文登市', 10),
(12621, 19, 12618, '乳山市', '乳山市', 15),
(12622, 19, 12618, '环翠区', '环翠区', 20),
(12623, 19, 12543, '莱芜市', '莱芜市', 45),
(12624, 19, 12623, '莱城区', '莱城区', 5),
(12625, 19, 12623, '钢城区', '钢城区', 10),
(12626, 19, 12543, '德州市', '德州市', 50),
(12627, 19, 12626, '德城区', '德城区', 5),
(12628, 19, 12626, '临邑县', '临邑县', 10),
(12629, 19, 12626, '齐河县', '齐河县', 15),
(12630, 19, 12626, '乐陵市', '乐陵市', 20),
(12631, 19, 12626, '禹城市', '禹城市', 25),
(12632, 19, 12626, '陵县', '陵县', 30),
(12633, 19, 12626, '宁津县', '宁津县', 35),
(12634, 19, 12626, '武城县', '武城县', 40),
(12635, 19, 12626, '庆云县', '庆云县', 45),
(12636, 19, 12626, '平原县', '平原县', 50),
(12637, 19, 12626, '夏津县', '夏津县', 55),
(12638, 19, 12543, '临沂市', '临沂市', 55),
(12639, 19, 12638, '兰陵县', '兰陵县', 5),
(12640, 19, 12638, '兰山区', '兰山区', 10),
(12641, 19, 12638, '河东区', '河东区', 15),
(12642, 19, 12638, '沂南县', '沂南县', 20),
(12643, 19, 12638, '沂水县', '沂水县', 25),
(12644, 19, 12638, '费县', '费县', 30),
(12645, 19, 12638, '平邑县', '平邑县', 35),
(12646, 19, 12638, '蒙阴县', '蒙阴县', 40),
(12647, 19, 12638, '临沭县', '临沭县', 45),
(12648, 19, 12638, '莒南县', '莒南县', 50),
(12649, 19, 12638, '郯城县', '郯城县', 55),
(12650, 19, 12638, '罗庄区', '罗庄区', 60),
(12651, 19, 12543, '聊城市', '聊城市', 60),
(12652, 19, 12651, '东昌府区', '东昌府区', 5),
(12653, 19, 12651, '临清市', '临清市', 10),
(12654, 19, 12651, '阳谷县', '阳谷县', 15),
(12655, 19, 12651, '茌平县', '茌平县', 20),
(12656, 19, 12651, '莘县', '莘县', 25),
(12657, 19, 12651, '东阿县', '东阿县', 30),
(12658, 19, 12651, '冠县', '冠县', 35),
(12659, 19, 12651, '高唐县', '高唐县', 40),
(12660, 19, 12543, '滨州市', '滨州市', 65),
(12661, 19, 12660, '北海新区', '北海新区', 5),
(12662, 19, 12660, '滨城区', '滨城区', 10),
(12663, 19, 12660, '邹平县', '邹平县', 15),
(12664, 19, 12660, '沾化县', '沾化县', 20),
(12665, 19, 12660, '惠民县', '惠民县', 25),
(12666, 19, 12660, '博兴县', '博兴县', 30),
(12667, 19, 12660, '阳信县', '阳信县', 35),
(12668, 19, 12660, '无棣县', '无棣县', 40),
(12669, 19, 12543, '菏泽市', '菏泽市', 70),
(12670, 19, 12669, '牡丹区', '牡丹区', 5),
(12671, 19, 12669, '单县', '单县', 10),
(12672, 19, 12669, '曹县', '曹县', 15),
(12673, 19, 12669, '定陶县', '定陶县', 20),
(12674, 19, 12669, '巨野县', '巨野县', 25),
(12675, 19, 12669, '成武县', '成武县', 30),
(12676, 19, 12669, '东明县', '东明县', 35),
(12677, 19, 12669, '郓城县', '郓城县', 40),
(12678, 19, 12669, '鄄城县', '鄄城县', 45),
(12679, 19, 12543, '日照市', '日照市', 75),
(12680, 19, 12679, '岚山区', '岚山区', 5),
(12681, 19, 12679, '新市区', '新市区', 10),
(12682, 19, 12679, '五莲县', '五莲县', 15),
(12683, 19, 12679, '东港区', '东港区', 20),
(12684, 19, 12679, '莒县', '莒县', 25),
(12685, 19, 12543, '泰安市', '泰安市', 80),
(12686, 19, 12685, '东平县', '东平县', 5),
(12687, 19, 12685, '岱岳区', '岱岳区', 10),
(12688, 19, 12685, '泰山区', '泰山区', 15),
(12689, 19, 12685, '肥城市', '肥城市', 20),
(12690, 19, 12685, '新泰市', '新泰市', 25),
(12691, 19, 12685, '宁阳县', '宁阳县', 30),
(12692, 19, 12543, '济宁市', '济宁市', 85),
(12693, 19, 12692, '梁山县', '梁山县', 5),
(12694, 19, 12692, '兖州市', '兖州市', 10),
(12695, 19, 12692, '微山县', '微山县', 15),
(12696, 19, 12692, '汶上县', '汶上县', 20),
(12697, 19, 12692, '泗水县', '泗水县', 25),
(12698, 19, 12692, '嘉祥县', '嘉祥县', 30),
(12699, 19, 12692, '鱼台县', '鱼台县', 35),
(12700, 19, 12692, '金乡县', '金乡县', 40),
(12701, 19, 12692, '邹城市', '邹城市', 45),
(12702, 19, 12692, '市中区', '市中区', 50),
(12703, 19, 12692, '曲阜市', '曲阜市', 55),
(12704, 19, 12692, '高新区', '高新区', 60),
(12705, 19, 12692, '任城区', '任城区', 65),
(12706, 19, 0, '安徽省', '安徽省', 70),
(12707, 19, 12706, '铜陵市', '铜陵市', 5),
(12708, 19, 12707, '铜官山区', '铜官山区', 5),
(12709, 19, 12707, '郊区', '郊区', 10),
(12710, 19, 12707, '狮子山区', '狮子山区', 15),
(12711, 19, 12707, '铜陵县', '铜陵县', 20),
(12712, 19, 12706, '合肥市', '合肥市', 10),
(12713, 19, 12712, '包河区', '包河区', 5),
(12714, 19, 12712, '蜀山区', '蜀山区', 10),
(12715, 19, 12712, '瑶海区', '瑶海区', 15),
(12716, 19, 12712, '庐阳区', '庐阳区', 20),
(12717, 19, 12712, '滨湖新区', '滨湖新区', 25),
(12718, 19, 12712, '经济技术开发区', '经济技术开发区', 30),
(12719, 19, 12712, '高新技术开发区', '高新技术开发区', 35),
(12720, 19, 12712, '新站综合开发试验区', '新站综合开发试验区', 40),
(12721, 19, 12712, '肥西县', '肥西县', 45),
(12722, 19, 12712, '政务文化新区', '政务文化新区', 50),
(12723, 19, 12712, '巢湖市', '巢湖市', 55),
(12724, 19, 12712, '长丰县', '长丰县', 60),
(12725, 19, 12712, '肥东县', '肥东县', 65),
(12726, 19, 12712, '庐江县', '庐江县', 70),
(12727, 19, 12712, '北城新区', '北城新区', 75),
(12728, 19, 12706, '淮南市', '淮南市', 15),
(12729, 19, 12728, '淮南高新技术开发区', '淮南高新技术开发区', 5),
(12730, 19, 12728, '田家庵区', '田家庵区', 10),
(12731, 19, 12728, '大通区', '大通区', 15),
(12732, 19, 12728, '谢家集区', '谢家集区', 20),
(12733, 19, 12728, '八公山区', '八公山区', 25),
(12734, 19, 12728, '凤台县', '凤台县', 30),
(12735, 19, 12728, '潘集区', '潘集区', 35),
(12736, 19, 12706, '淮北市', '淮北市', 20),
(12737, 19, 12736, '杜集区', '杜集区', 5),
(12738, 19, 12736, '烈山区', '烈山区', 10),
(12739, 19, 12736, '濉溪县', '濉溪县', 15),
(12740, 19, 12736, '相山区', '相山区', 20),
(12741, 19, 12706, '芜湖市', '芜湖市', 25),
(12742, 19, 12741, '镜湖区', '镜湖区', 5),
(12743, 19, 12741, '弋江区', '弋江区', 10),
(12744, 19, 12741, '无为县', '无为县', 15),
(12745, 19, 12741, '芜湖县', '芜湖县', 20),
(12746, 19, 12741, '繁昌县', '繁昌县', 25),
(12747, 19, 12741, '南陵县', '南陵县', 30),
(12748, 19, 12741, '鸠江区', '鸠江区', 35),
(12749, 19, 12741, '三山区', '三山区', 40),
(12750, 19, 12706, '蚌埠市', '蚌埠市', 30),
(12751, 19, 12750, '蚌山区', '蚌山区', 5),
(12752, 19, 12750, '怀远县', '怀远县', 10),
(12753, 19, 12750, '固镇县', '固镇县', 15),
(12754, 19, 12750, '五河县', '五河县', 20),
(12755, 19, 12750, '淮上区', '淮上区', 25),
(12756, 19, 12750, '龙子湖区', '龙子湖区', 30),
(12757, 19, 12750, '禹会区', '禹会区', 35),
(12758, 19, 12706, '马鞍山市', '马鞍山市', 35),
(12759, 19, 12758, '博望区', '博望区', 5),
(12760, 19, 12758, '花山区', '花山区', 10),
(12761, 19, 12758, '雨山区', '雨山区', 15),
(12762, 19, 12758, '当涂县', '当涂县', 20),
(12763, 19, 12758, '含山县', '含山县', 25),
(12764, 19, 12758, '和县', '和县', 30),
(12765, 19, 12706, '安庆市', '安庆市', 40),
(12766, 19, 12765, '桐城市', '桐城市', 5),
(12767, 19, 12765, '宿松县', '宿松县', 10),
(12768, 19, 12765, '枞阳县', '枞阳县', 15),
(12769, 19, 12765, '太湖县', '太湖县', 20),
(12770, 19, 12765, '怀宁县', '怀宁县', 25),
(12771, 19, 12765, '岳西县', '岳西县', 30),
(12772, 19, 12765, '望江县', '望江县', 35),
(12773, 19, 12765, '潜山县', '潜山县', 40),
(12774, 19, 12765, '大观区', '大观区', 45),
(12775, 19, 12765, '宜秀区', '宜秀区', 50),
(12776, 19, 12765, '迎江区', '迎江区', 55),
(12777, 19, 12765, '开发区', '开发区', 60),
(12778, 19, 12706, '黄山市', '黄山市', 45),
(12779, 19, 12778, '徽州区', '徽州区', 5),
(12780, 19, 12778, '屯溪区', '屯溪区', 10),
(12781, 19, 12778, '休宁县', '休宁县', 15),
(12782, 19, 12778, '歙县', '歙县', 20),
(12783, 19, 12778, '黟县', '黟县', 25),
(12784, 19, 12778, '祁门县', '祁门县', 30),
(12785, 19, 12778, '黄山区', '黄山区', 35),
(12786, 19, 12706, '滁州市', '滁州市', 50),
(12787, 19, 12786, '琅琊区', '琅琊区', 5),
(12788, 19, 12786, '天长市', '天长市', 10),
(12789, 19, 12786, '明光市', '明光市', 15),
(12790, 19, 12786, '全椒县', '全椒县', 20),
(12791, 19, 12786, '来安县', '来安县', 25),
(12792, 19, 12786, '南谯区', '南谯区', 30),
(12793, 19, 12786, '定远县', '定远县', 35),
(12794, 19, 12786, '凤阳县', '凤阳县', 40),
(12795, 19, 12706, '阜阳市', '阜阳市', 55),
(12796, 19, 12795, '经济开发区', '经济开发区', 5),
(12797, 19, 12795, '界首市', '界首市', 10),
(12798, 19, 12795, '太和县', '太和县', 15),
(12799, 19, 12795, '阜南县', '阜南县', 20),
(12800, 19, 12795, '颍上县', '颍上县', 25),
(12801, 19, 12795, '临泉县', '临泉县', 30),
(12802, 19, 12795, '颍泉区', '颍泉区', 35),
(12803, 19, 12795, '颍州区', '颍州区', 40),
(12804, 19, 12795, '颍东区', '颍东区', 45),
(12805, 19, 12706, '亳州市', '亳州市', 60),
(12806, 19, 12805, '利辛县', '利辛县', 5),
(12807, 19, 12805, '蒙城县', '蒙城县', 10),
(12808, 19, 12805, '涡阳县', '涡阳县', 15),
(12809, 19, 12805, '谯城区', '谯城区', 20),
(12810, 19, 12706, '宿州市', '宿州市', 65),
(12811, 19, 12810, '经济开发区', '经济开发区', 5),
(12812, 19, 12810, '埇桥区', '埇桥区', 10),
(12813, 19, 12810, '灵璧县', '灵璧县', 15),
(12814, 19, 12810, '泗县', '泗县', 20),
(12815, 19, 12810, '萧县', '萧县', 25),
(12816, 19, 12810, '砀山县', '砀山县', 30),
(12817, 19, 12706, '池州市', '池州市', 70),
(12818, 19, 12817, '贵池区', '贵池区', 5),
(12819, 19, 12817, '东至县', '东至县', 10),
(12820, 19, 12817, '石台县', '石台县', 15),
(12821, 19, 12817, '青阳县', '青阳县', 20),
(12822, 19, 12706, '六安市', '六安市', 75),
(12823, 19, 12822, '寿县', '寿县', 5),
(12824, 19, 12822, '霍山县', '霍山县', 10),
(12825, 19, 12822, '金寨县', '金寨县', 15),
(12826, 19, 12822, '霍邱县', '霍邱县', 20),
(12827, 19, 12822, '舒城县', '舒城县', 25),
(12828, 19, 12822, '金安区', '金安区', 30),
(12829, 19, 12822, '裕安区', '裕安区', 35),
(12830, 19, 12706, '宣城市', '宣城市', 80),
(12831, 19, 12830, '旌德县', '旌德县', 5),
(12832, 19, 12830, '宁国市', '宁国市', 10),
(12833, 19, 12830, '郎溪县', '郎溪县', 15),
(12834, 19, 12830, '广德县', '广德县', 20),
(12835, 19, 12830, '绩溪县', '绩溪县', 25),
(12836, 19, 12830, '泾县', '泾县', 30),
(12837, 19, 12830, '宣州区', '宣州区', 35),
(12838, 19, 0, '浙江省', '浙江省', 75),
(12839, 19, 12838, '宁波市', '宁波市', 5),
(12840, 19, 12839, '海曙区', '海曙区', 5),
(12841, 19, 12839, '江东区', '江东区', 10),
(12842, 19, 12839, '高新科技开发区', '高新科技开发区', 15),
(12843, 19, 12839, '慈溪市', '慈溪市', 20),
(12844, 19, 12839, '北仑区', '北仑区', 25),
(12845, 19, 12839, '镇海区', '镇海区', 30),
(12846, 19, 12839, '鄞州区', '鄞州区', 35),
(12847, 19, 12839, '江北区', '江北区', 40),
(12848, 19, 12839, '余姚市', '余姚市', 45),
(12849, 19, 12839, '奉化市', '奉化市', 50),
(12850, 19, 12839, '宁海县', '宁海县', 55),
(12851, 19, 12839, '象山县', '象山县', 60),
(12852, 19, 12838, '杭州市', '杭州市', 10),
(12853, 19, 12852, '上城区', '上城区', 5),
(12854, 19, 12852, '下城区', '下城区', 10),
(12855, 19, 12852, '拱墅区', '拱墅区', 15),
(12856, 19, 12852, '西湖区', '西湖区', 20),
(12857, 19, 12852, '江干区', '江干区', 25),
(12858, 19, 12852, '下沙区', '下沙区', 30),
(12859, 19, 12852, '余杭区', '余杭区', 35),
(12860, 19, 12852, '萧山区', '萧山区', 40),
(12861, 19, 12852, '滨江区', '滨江区', 45),
(12862, 19, 12852, '临安市', '临安市', 50),
(12863, 19, 12852, '富阳市', '富阳市', 55),
(12864, 19, 12852, '桐庐县', '桐庐县', 60),
(12865, 19, 12852, '建德市', '建德市', 65),
(12866, 19, 12852, '淳安县', '淳安县', 70),
(12867, 19, 12838, '温州市', '温州市', 15),
(12868, 19, 12867, '龙湾区', '龙湾区', 5),
(12869, 19, 12867, '茶山高教园区', '茶山高教园区', 10),
(12870, 19, 12867, '瑞安市', '瑞安市', 15),
(12871, 19, 12867, '乐清市', '乐清市', 20),
(12872, 19, 12867, '鹿城区', '鹿城区', 25),
(12873, 19, 12867, '瓯海区', '瓯海区', 30),
(12874, 19, 12867, '永嘉县', '永嘉县', 35),
(12875, 19, 12867, '文成县', '文成县', 40),
(12876, 19, 12867, '平阳县', '平阳县', 45),
(12877, 19, 12867, '泰顺县', '泰顺县', 50),
(12878, 19, 12867, '洞头县', '洞头县', 55),
(12879, 19, 12867, '苍南县', '苍南县', 60),
(12880, 19, 12838, '嘉兴市', '嘉兴市', 20),
(12881, 19, 12880, '桐乡市', '桐乡市', 5),
(12882, 19, 12880, '平湖市', '平湖市', 10),
(12883, 19, 12880, '嘉善县', '嘉善县', 15),
(12884, 19, 12880, '南湖区', '南湖区', 20),
(12885, 19, 12880, '秀洲区', '秀洲区', 25),
(12886, 19, 12880, '海宁市', '海宁市', 30),
(12887, 19, 12880, '海盐县', '海盐县', 35),
(12888, 19, 12838, '湖州市', '湖州市', 25),
(12889, 19, 12888, '南浔区', '南浔区', 5),
(12890, 19, 12888, '吴兴区', '吴兴区', 10),
(12891, 19, 12888, '长兴县', '长兴县', 15),
(12892, 19, 12888, '德清县', '德清县', 20),
(12893, 19, 12888, '安吉县', '安吉县', 25),
(12894, 19, 12838, '绍兴市', '绍兴市', 30),
(12895, 19, 12894, '柯桥区', '柯桥区', 5),
(12896, 19, 12894, '越城区', '越城区', 10),
(12897, 19, 12894, '诸暨市', '诸暨市', 15),
(12898, 19, 12894, '上虞区', '上虞区', 20),
(12899, 19, 12894, '嵊州市', '嵊州市', 25),
(12900, 19, 12894, '新昌县', '新昌县', 30),
(12901, 19, 12838, '金华市', '金华市', 35),
(12902, 19, 12901, '金东区', '金东区', 5),
(12903, 19, 12901, '婺城区', '婺城区', 10),
(12904, 19, 12901, '兰溪市', '兰溪市', 15),
(12905, 19, 12901, '武义县', '武义县', 20),
(12906, 19, 12901, '浦江县', '浦江县', 25),
(12907, 19, 12901, '磐安县', '磐安县', 30),
(12908, 19, 12901, '义乌市', '义乌市', 35),
(12909, 19, 12901, '永康市', '永康市', 40),
(12910, 19, 12901, '东阳市', '东阳市', 45),
(12911, 19, 12838, '衢州市', '衢州市', 40),
(12912, 19, 12911, '柯城区', '柯城区', 5),
(12913, 19, 12911, '衢江区', '衢江区', 10),
(12914, 19, 12911, '江山市', '江山市', 15),
(12915, 19, 12911, '常山县', '常山县', 20),
(12916, 19, 12911, '开化县', '开化县', 25),
(12917, 19, 12911, '龙游县', '龙游县', 30),
(12918, 19, 12838, '丽水市', '丽水市', 45),
(12919, 19, 12918, '龙泉市', '龙泉市', 5),
(12920, 19, 12918, '缙云县', '缙云县', 10),
(12921, 19, 12918, '遂昌县', '遂昌县', 15),
(12922, 19, 12918, '松阳县', '松阳县', 20),
(12923, 19, 12918, '景宁县', '景宁县', 25),
(12924, 19, 12918, '云和县', '云和县', 30),
(12925, 19, 12918, '青田县', '青田县', 35),
(12926, 19, 12918, '莲都区', '莲都区', 40),
(12927, 19, 12918, '庆元县', '庆元县', 45),
(12928, 19, 12838, '台州市', '台州市', 50),
(12929, 19, 12928, '临海市', '临海市', 5),
(12930, 19, 12928, '三门县', '三门县', 10),
(12931, 19, 12928, '天台县', '天台县', 15),
(12932, 19, 12928, '仙居县', '仙居县', 20),
(12933, 19, 12928, '黄岩区', '黄岩区', 25),
(12934, 19, 12928, '椒江区', '椒江区', 30),
(12935, 19, 12928, '路桥区', '路桥区', 35),
(12936, 19, 12928, '温岭市', '温岭市', 40),
(12937, 19, 12928, '玉环县', '玉环县', 45),
(12938, 19, 12838, '舟山市', '舟山市', 55),
(12939, 19, 12938, '岱山县', '岱山县', 5),
(12940, 19, 12938, '嵊泗县', '嵊泗县', 10),
(12941, 19, 12938, '普陀区', '普陀区', 15),
(12942, 19, 12938, '定海区', '定海区', 20),
(12943, 19, 0, '福建省', '福建省', 80),
(12944, 19, 12943, '福州市', '福州市', 5),
(12945, 19, 12944, '台江区', '台江区', 5),
(12946, 19, 12944, '鼓楼区', '鼓楼区', 10),
(12947, 19, 12944, '晋安区', '晋安区', 15),
(12948, 19, 12944, '仓山区', '仓山区', 20),
(12949, 19, 12944, '马尾区', '马尾区', 25),
(12950, 19, 12944, '福清市', '福清市', 30),
(12951, 19, 12944, '闽侯县', '闽侯县', 35),
(12952, 19, 12944, '长乐市', '长乐市', 40),
(12953, 19, 12944, '平潭县', '平潭县', 45),
(12954, 19, 12944, '连江县', '连江县', 50),
(12955, 19, 12944, '罗源县', '罗源县', 55),
(12956, 19, 12944, '永泰县', '永泰县', 60),
(12957, 19, 12944, '闽清县', '闽清县', 65),
(12958, 19, 12943, '厦门市', '厦门市', 10),
(12959, 19, 12958, '思明区', '思明区', 5),
(12960, 19, 12958, '湖里区', '湖里区', 10),
(12961, 19, 12958, '翔安区', '翔安区', 15),
(12962, 19, 12958, '海沧区', '海沧区', 20),
(12963, 19, 12958, '集美区', '集美区', 25),
(12964, 19, 12958, '同安区', '同安区', 30),
(12965, 19, 12943, '三明市', '三明市', 15),
(12966, 19, 12965, '永安市', '永安市', 5),
(12967, 19, 12965, '明溪县', '明溪县', 10),
(12968, 19, 12965, '将乐县', '将乐县', 15),
(12969, 19, 12965, '大田县', '大田县', 20),
(12970, 19, 12965, '宁化县', '宁化县', 25),
(12971, 19, 12965, '建宁县', '建宁县', 30),
(12972, 19, 12965, '沙县', '沙县', 35),
(12973, 19, 12965, '尤溪县', '尤溪县', 40),
(12974, 19, 12965, '清流县', '清流县', 45),
(12975, 19, 12965, '泰宁县', '泰宁县', 50),
(12976, 19, 12965, '梅列区', '梅列区', 55),
(12977, 19, 12965, '三元区', '三元区', 60),
(12978, 19, 12943, '莆田市', '莆田市', 20),
(12979, 19, 12978, '仙游县', '仙游县', 5),
(12980, 19, 12978, '城厢区', '城厢区', 10),
(12981, 19, 12978, '荔城区', '荔城区', 15),
(12982, 19, 12978, '秀屿区', '秀屿区', 20),
(12983, 19, 12978, '涵江区', '涵江区', 25),
(12984, 19, 12943, '泉州市', '泉州市', 25),
(12985, 19, 12984, '泉港区', '泉港区', 5),
(12986, 19, 12984, '石狮市', '石狮市', 10),
(12987, 19, 12984, '南安市', '南安市', 15),
(12988, 19, 12984, '惠安县', '惠安县', 20),
(12989, 19, 12984, '安溪县', '安溪县', 25),
(12990, 19, 12984, '德化县', '德化县', 30),
(12991, 19, 12984, '永春县', '永春县', 35),
(12992, 19, 12984, '金门县', '金门县', 40),
(12993, 19, 12984, '洛江区', '洛江区', 45),
(12994, 19, 12984, '鲤城区', '鲤城区', 50),
(12995, 19, 12984, '丰泽区', '丰泽区', 55),
(12996, 19, 12984, '晋江市', '晋江市', 60),
(12997, 19, 12943, '漳州市', '漳州市', 30),
(12998, 19, 12997, '芗城区', '芗城区', 5),
(12999, 19, 12997, '龙文区', '龙文区', 10),
(13000, 19, 12997, '龙海市', '龙海市', 15),
(13001, 19, 12997, '平和县', '平和县', 20),
(13002, 19, 12997, '南靖县', '南靖县', 25),
(13003, 19, 12997, '诏安县', '诏安县', 30),
(13004, 19, 12997, '漳浦县', '漳浦县', 35),
(13005, 19, 12997, '华安县', '华安县', 40),
(13006, 19, 12997, '云霄县', '云霄县', 45),
(13007, 19, 12997, '东山县', '东山县', 50),
(13008, 19, 12997, '长泰县', '长泰县', 55),
(13009, 19, 12943, '南平市', '南平市', 35),
(13010, 19, 13009, '建瓯市', '建瓯市', 5),
(13011, 19, 13009, '邵武市', '邵武市', 10),
(13012, 19, 13009, '武夷山市', '武夷山市', 15),
(13013, 19, 13009, '建阳市', '建阳市', 20),
(13014, 19, 13009, '松溪县', '松溪县', 25),
(13015, 19, 13009, '顺昌县', '顺昌县', 30),
(13016, 19, 13009, '浦城县', '浦城县', 35),
(13017, 19, 13009, '政和县', '政和县', 40),
(13018, 19, 13009, '光泽县', '光泽县', 45),
(13019, 19, 13009, '延平区', '延平区', 50),
(13020, 19, 12943, '龙岩市', '龙岩市', 40),
(13021, 19, 13020, '新罗区', '新罗区', 5),
(13022, 19, 13020, '漳平市', '漳平市', 10),
(13023, 19, 13020, '长汀县', '长汀县', 15),
(13024, 19, 13020, '武平县', '武平县', 20),
(13025, 19, 13020, '永定县', '永定县', 25),
(13026, 19, 13020, '上杭县', '上杭县', 30),
(13027, 19, 13020, '连城县', '连城县', 35),
(13028, 19, 12943, '宁德市', '宁德市', 45),
(13029, 19, 13028, '蕉城区', '蕉城区', 5),
(13030, 19, 13028, '东侨开发区', '东侨开发区', 10),
(13031, 19, 13028, '福安市', '福安市', 15),
(13032, 19, 13028, '福鼎市', '福鼎市', 20),
(13033, 19, 13028, '寿宁县', '寿宁县', 25),
(13034, 19, 13028, '霞浦县', '霞浦县', 30),
(13035, 19, 13028, '柘荣县', '柘荣县', 35),
(13036, 19, 13028, '屏南县', '屏南县', 40),
(13037, 19, 13028, '古田县', '古田县', 45),
(13038, 19, 13028, '周宁县', '周宁县', 50),
(13039, 19, 0, '湖北省', '湖北省', 85),
(13040, 19, 13039, '武汉市', '武汉市', 5),
(13041, 19, 13040, '硚口区', '硚口区', 5),
(13042, 19, 13040, '武昌区', '武昌区', 10),
(13043, 19, 13040, '武汉经济技术开发区', '武汉经济技术开发区', 15),
(13044, 19, 13040, '江岸区', '江岸区', 20),
(13045, 19, 13040, '江汉区', '江汉区', 25),
(13046, 19, 13040, '蔡甸区', '蔡甸区', 30),
(13047, 19, 13040, '江夏区', '江夏区', 35),
(13048, 19, 13040, '新洲区', '新洲区', 40),
(13049, 19, 13040, '黄陂区', '黄陂区', 45),
(13050, 19, 13040, '汉阳区', '汉阳区', 50),
(13051, 19, 13040, '青山区', '青山区', 55),
(13052, 19, 13040, '洪山区', '洪山区', 60),
(13053, 19, 13040, '汉南区', '汉南区', 65),
(13054, 19, 13040, '东西湖区', '东西湖区', 70),
(13055, 19, 13039, '黄石市', '黄石市', 10),
(13056, 19, 13055, '黄石港区', '黄石港区', 5),
(13057, 19, 13055, '下陆区', '下陆区', 10),
(13058, 19, 13055, '西塞山区', '西塞山区', 15),
(13059, 19, 13055, '铁山区', '铁山区', 20),
(13060, 19, 13055, '大冶市', '大冶市', 25),
(13061, 19, 13055, '阳新县', '阳新县', 30),
(13062, 19, 13055, '经济技术开发区', '经济技术开发区', 35),
(13063, 19, 13039, '襄阳市', '襄阳市', 15),
(13064, 19, 13063, '老河口市', '老河口市', 5),
(13065, 19, 13063, '枣阳市', '枣阳市', 10),
(13066, 19, 13063, '宜城市', '宜城市', 15),
(13067, 19, 13063, '南漳县', '南漳县', 20),
(13068, 19, 13063, '保康县', '保康县', 25),
(13069, 19, 13063, '谷城县', '谷城县', 30),
(13070, 19, 13063, '樊城区', '樊城区', 35),
(13071, 19, 13063, '襄城区', '襄城区', 40),
(13072, 19, 13063, '襄州区', '襄州区', 45),
(13073, 19, 13039, '十堰市', '十堰市', 20),
(13074, 19, 13073, '丹江口市', '丹江口市', 5),
(13075, 19, 13073, '房县', '房县', 10),
(13076, 19, 13073, '竹山县', '竹山县', 15),
(13077, 19, 13073, '竹溪县', '竹溪县', 20),
(13078, 19, 13073, '郧县', '郧县', 25),
(13079, 19, 13073, '郧西县', '郧西县', 30),
(13080, 19, 13073, '茅箭区', '茅箭区', 35),
(13081, 19, 13073, '张湾区', '张湾区', 40),
(13082, 19, 13039, '荆州市', '荆州市', 25),
(13083, 19, 13082, '沙市区', '沙市区', 5),
(13084, 19, 13082, '荆州区', '荆州区', 10),
(13085, 19, 13082, '江陵县', '江陵县', 15),
(13086, 19, 13082, '洪湖市', '洪湖市', 20),
(13087, 19, 13082, '石首市', '石首市', 25),
(13088, 19, 13082, '松滋市', '松滋市', 30),
(13089, 19, 13082, '监利县', '监利县', 35),
(13090, 19, 13082, '公安县', '公安县', 40),
(13091, 19, 13039, '宜昌市', '宜昌市', 30),
(13092, 19, 13091, '伍家岗区', '伍家岗区', 5),
(13093, 19, 13091, '西陵区', '西陵区', 10),
(13094, 19, 13091, '宜都市', '宜都市', 15),
(13095, 19, 13091, '猇亭区', '猇亭区', 20),
(13096, 19, 13091, '点军区', '点军区', 25),
(13097, 19, 13091, '当阳市', '当阳市', 30),
(13098, 19, 13091, '枝江市', '枝江市', 35),
(13099, 19, 13091, '夷陵区', '夷陵区', 40),
(13100, 19, 13091, '秭归县', '秭归县', 45),
(13101, 19, 13091, '兴山县', '兴山县', 50),
(13102, 19, 13091, '远安县', '远安县', 55),
(13103, 19, 13091, '五峰土家族自治县', '五峰土家族自治县', 60),
(13104, 19, 13091, '长阳土家族自治县', '长阳土家族自治县', 65),
(13105, 19, 13039, '孝感市', '孝感市', 35),
(13106, 19, 13105, '汉川市', '汉川市', 5),
(13107, 19, 13105, '云梦县', '云梦县', 10),
(13108, 19, 13105, '大悟县', '大悟县', 15),
(13109, 19, 13105, '孝昌县', '孝昌县', 20),
(13110, 19, 13105, '孝南区', '孝南区', 25),
(13111, 19, 13105, '应城市', '应城市', 30),
(13112, 19, 13105, '安陆市', '安陆市', 35),
(13113, 19, 13039, '黄冈市', '黄冈市', 40),
(13114, 19, 13113, '黄州区', '黄州区', 5),
(13115, 19, 13113, '蕲春县', '蕲春县', 10),
(13116, 19, 13113, '麻城市', '麻城市', 15),
(13117, 19, 13113, '武穴市', '武穴市', 20),
(13118, 19, 13113, '浠水县', '浠水县', 25),
(13119, 19, 13113, '红安县', '红安县', 30),
(13120, 19, 13113, '罗田县', '罗田县', 35),
(13121, 19, 13113, '黄梅县', '黄梅县', 40),
(13122, 19, 13113, '英山县', '英山县', 45),
(13123, 19, 13113, '团风县', '团风县', 50),
(13124, 19, 13039, '咸宁市', '咸宁市', 45),
(13125, 19, 13124, '咸安区', '咸安区', 5),
(13126, 19, 13124, '赤壁市', '赤壁市', 10),
(13127, 19, 13124, '嘉鱼县', '嘉鱼县', 15),
(13128, 19, 13124, '通山县', '通山县', 20),
(13129, 19, 13124, '崇阳县', '崇阳县', 25),
(13130, 19, 13124, '通城县', '通城县', 30),
(13131, 19, 13039, '恩施州', '恩施州', 50),
(13132, 19, 13131, '恩施市', '恩施市', 5),
(13133, 19, 13131, '利川市', '利川市', 10),
(13134, 19, 13131, '建始县', '建始县', 15),
(13135, 19, 13131, '来凤县', '来凤县', 20),
(13136, 19, 13131, '巴东县', '巴东县', 25),
(13137, 19, 13131, '鹤峰县', '鹤峰县', 30),
(13138, 19, 13131, '宣恩县', '宣恩县', 35),
(13139, 19, 13131, '咸丰县', '咸丰县', 40),
(13140, 19, 13039, '鄂州市', '鄂州市', 55),
(13141, 19, 13140, '梁子湖区', '梁子湖区', 5),
(13142, 19, 13140, '华容区', '华容区', 10),
(13143, 19, 13140, '鄂城区', '鄂城区', 15),
(13144, 19, 13039, '荆门市', '荆门市', 60),
(13145, 19, 13144, '东宝区', '东宝区', 5),
(13146, 19, 13144, '掇刀区', '掇刀区', 10),
(13147, 19, 13144, '钟祥市', '钟祥市', 15),
(13148, 19, 13144, '京山县', '京山县', 20),
(13149, 19, 13144, '沙洋县', '沙洋县', 25),
(13150, 19, 13039, '随州市', '随州市', 65),
(13151, 19, 13150, '曾都区', '曾都区', 5),
(13152, 19, 13150, '广水市', '广水市', 10),
(13153, 19, 13150, '随县', '随县', 15),
(13154, 19, 13039, '潜江市', '潜江市', 70),
(13155, 19, 13154, '园林', '园林', 5),
(13156, 19, 13154, '杨市', '杨市', 10),
(13157, 19, 13154, '周矶', '周矶', 15),
(13158, 19, 13154, '广华', '广华', 20),
(13159, 19, 13154, '泰丰', '泰丰', 25),
(13160, 19, 13154, '竹根滩镇', '竹根滩镇', 30),
(13161, 19, 13154, '高石碑镇', '高石碑镇', 35),
(13162, 19, 13154, '积玉口镇', '积玉口镇', 40),
(13163, 19, 13154, '渔洋镇', '渔洋镇', 45),
(13164, 19, 13154, '王场镇', '王场镇', 50),
(13165, 19, 13154, '熊口镇', '熊口镇', 55),
(13166, 19, 13154, '老新镇', '老新镇', 60),
(13167, 19, 13154, '浩口镇', '浩口镇', 65),
(13168, 19, 13154, '张金镇', '张金镇', 70),
(13169, 19, 13154, '龙湾镇', '龙湾镇', 75),
(13170, 19, 13154, '江汉石油管理局', '江汉石油管理局', 80),
(13171, 19, 13154, '潜江经济开发区', '潜江经济开发区', 85),
(13172, 19, 13154, '西大垸管理区', '西大垸管理区', 90),
(13173, 19, 13154, '运粮湖管理区', '运粮湖管理区', 95),
(13174, 19, 13154, '周矶管理区', '周矶管理区', 100),
(13175, 19, 13154, '后湖管理区', '后湖管理区', 105),
(13176, 19, 13154, '熊口管理区', '熊口管理区', 110),
(13177, 19, 13154, '总口管理区', '总口管理区', 115),
(13178, 19, 13154, '高场原种场', '高场原种场', 120),
(13179, 19, 13154, '浩口原种场', '浩口原种场', 125),
(13180, 19, 13039, '天门市', '天门市', 75),
(13181, 19, 13180, '侨乡街道开发区', '侨乡街道开发区', 5);
INSERT INTO `qinggan_opt` (`id`, `group_id`, `parent_id`, `title`, `val`, `taxis`) VALUES
(13182, 19, 13180, '竟陵街道', '竟陵街道', 10),
(13183, 19, 13180, '杨林街道', '杨林街道', 15),
(13184, 19, 13180, '佛子山镇', '佛子山镇', 20),
(13185, 19, 13180, '多宝镇', '多宝镇', 25),
(13186, 19, 13180, '拖市镇', '拖市镇', 30),
(13187, 19, 13180, '张港镇', '张港镇', 35),
(13188, 19, 13180, '蒋场镇', '蒋场镇', 40),
(13189, 19, 13180, '汪场镇', '汪场镇', 45),
(13190, 19, 13180, '渔薪镇', '渔薪镇', 50),
(13191, 19, 13180, '黄潭镇', '黄潭镇', 55),
(13192, 19, 13180, '岳口镇', '岳口镇', 60),
(13193, 19, 13180, '横林镇', '横林镇', 65),
(13194, 19, 13180, '彭市镇', '彭市镇', 70),
(13195, 19, 13180, '麻洋镇', '麻洋镇', 75),
(13196, 19, 13180, '多祥镇', '多祥镇', 80),
(13197, 19, 13180, '干驿镇', '干驿镇', 85),
(13198, 19, 13180, '马湾镇', '马湾镇', 90),
(13199, 19, 13180, '卢市镇', '卢市镇', 95),
(13200, 19, 13180, '小板镇', '小板镇', 100),
(13201, 19, 13180, '九真镇', '九真镇', 105),
(13202, 19, 13180, '皂市镇', '皂市镇', 110),
(13203, 19, 13180, '胡市镇', '胡市镇', 115),
(13204, 19, 13180, '石河镇', '石河镇', 120),
(13205, 19, 13180, '净潭乡', '净潭乡', 125),
(13206, 19, 13180, '蒋湖农场', '蒋湖农场', 130),
(13207, 19, 13180, '白茅湖农场', '白茅湖农场', 135),
(13208, 19, 13180, '沉湖管委会', '沉湖管委会', 140),
(13209, 19, 13039, '仙桃市', '仙桃市', 80),
(13210, 19, 13209, '城区', '城区', 5),
(13211, 19, 13209, '郑场镇', '郑场镇', 10),
(13212, 19, 13209, '毛嘴镇', '毛嘴镇', 15),
(13213, 19, 13209, '豆河镇', '豆河镇', 20),
(13214, 19, 13209, '三伏潭镇', '三伏潭镇', 25),
(13215, 19, 13209, '胡场镇', '胡场镇', 30),
(13216, 19, 13209, '长埫口镇', '长埫口镇', 35),
(13217, 19, 13209, '西流河镇', '西流河镇', 40),
(13218, 19, 13209, '沙湖镇', '沙湖镇', 45),
(13219, 19, 13209, '杨林尾镇', '杨林尾镇', 50),
(13220, 19, 13209, '彭场镇', '彭场镇', 55),
(13221, 19, 13209, '张沟镇', '张沟镇', 60),
(13222, 19, 13209, '郭河镇', '郭河镇', 65),
(13223, 19, 13209, '沔城镇', '沔城镇', 70),
(13224, 19, 13209, '通海口镇', '通海口镇', 75),
(13225, 19, 13209, '陈场镇', '陈场镇', 80),
(13226, 19, 13209, '工业园区', '工业园区', 85),
(13227, 19, 13209, '九合垸原种场', '九合垸原种场', 90),
(13228, 19, 13209, '沙湖原种场', '沙湖原种场', 95),
(13229, 19, 13209, '排湖渔场', '排湖渔场', 100),
(13230, 19, 13209, '五湖渔场', '五湖渔场', 105),
(13231, 19, 13209, '赵西垸林场', '赵西垸林场', 110),
(13232, 19, 13209, '刘家垸林场', '刘家垸林场', 115),
(13233, 19, 13209, '畜禽良种场', '畜禽良种场', 120),
(13234, 19, 13039, '神农架林区', '神农架林区', 85),
(13235, 19, 13234, '松柏镇', '松柏镇', 5),
(13236, 19, 13234, '阳日镇', '阳日镇', 10),
(13237, 19, 13234, '木鱼镇', '木鱼镇', 15),
(13238, 19, 13234, '红坪镇', '红坪镇', 20),
(13239, 19, 13234, '新华镇', '新华镇', 25),
(13240, 19, 13234, '宋洛乡', '宋洛乡', 30),
(13241, 19, 13234, '九湖乡', '九湖乡', 35),
(13242, 19, 13234, '下谷坪乡', '下谷坪乡', 40),
(13243, 19, 0, '湖南省', '湖南省', 90),
(13244, 19, 13243, '长沙市', '长沙市', 5),
(13245, 19, 13244, '芙蓉区', '芙蓉区', 5),
(13246, 19, 13244, '岳麓区', '岳麓区', 10),
(13247, 19, 13244, '雨花区', '雨花区', 15),
(13248, 19, 13244, '开福区', '开福区', 20),
(13249, 19, 13244, '天心区', '天心区', 25),
(13250, 19, 13244, '浏阳市', '浏阳市', 30),
(13251, 19, 13244, '长沙县', '长沙县', 35),
(13252, 19, 13244, '宁乡县', '宁乡县', 40),
(13253, 19, 13244, '望城区', '望城区', 45),
(13254, 19, 13243, '株洲市', '株洲市', 10),
(13255, 19, 13254, '天元区', '天元区', 5),
(13256, 19, 13254, '石峰区', '石峰区', 10),
(13257, 19, 13254, '芦淞区', '芦淞区', 15),
(13258, 19, 13254, '荷塘区', '荷塘区', 20),
(13259, 19, 13254, '醴陵市', '醴陵市', 25),
(13260, 19, 13254, '株洲县', '株洲县', 30),
(13261, 19, 13254, '攸县', '攸县', 35),
(13262, 19, 13254, '茶陵县', '茶陵县', 40),
(13263, 19, 13254, '炎陵县', '炎陵县', 45),
(13264, 19, 13243, '湘潭市', '湘潭市', 15),
(13265, 19, 13264, '雨湖区', '雨湖区', 5),
(13266, 19, 13264, '岳塘区', '岳塘区', 10),
(13267, 19, 13264, '湘乡市', '湘乡市', 15),
(13268, 19, 13264, '湘潭县', '湘潭县', 20),
(13269, 19, 13264, '韶山市', '韶山市', 25),
(13270, 19, 13243, '韶山市', '韶山市', 20),
(13271, 19, 13270, '韶山市区内', '韶山市区内', 5),
(13272, 19, 13243, '衡阳市', '衡阳市', 25),
(13273, 19, 13272, '蒸湘区', '蒸湘区', 5),
(13274, 19, 13272, '石鼓区', '石鼓区', 10),
(13275, 19, 13272, '珠晖区', '珠晖区', 15),
(13276, 19, 13272, '雁峰区', '雁峰区', 20),
(13277, 19, 13272, '常宁市', '常宁市', 25),
(13278, 19, 13272, '衡阳县', '衡阳县', 30),
(13279, 19, 13272, '耒阳市', '耒阳市', 35),
(13280, 19, 13272, '衡东县', '衡东县', 40),
(13281, 19, 13272, '衡南县', '衡南县', 45),
(13282, 19, 13272, '衡山县', '衡山县', 50),
(13283, 19, 13272, '祁东县', '祁东县', 55),
(13284, 19, 13272, '南岳区', '南岳区', 60),
(13285, 19, 13243, '邵阳市', '邵阳市', 30),
(13286, 19, 13285, '大祥区', '大祥区', 5),
(13287, 19, 13285, '双清区', '双清区', 10),
(13288, 19, 13285, '北塔区', '北塔区', 15),
(13289, 19, 13285, '武冈市', '武冈市', 20),
(13290, 19, 13285, '邵东县', '邵东县', 25),
(13291, 19, 13285, '洞口县', '洞口县', 30),
(13292, 19, 13285, '新邵县', '新邵县', 35),
(13293, 19, 13285, '绥宁县', '绥宁县', 40),
(13294, 19, 13285, '新宁县', '新宁县', 45),
(13295, 19, 13285, '邵阳县', '邵阳县', 50),
(13296, 19, 13285, '隆回县', '隆回县', 55),
(13297, 19, 13285, '城步县', '城步县', 60),
(13298, 19, 13243, '岳阳市', '岳阳市', 35),
(13299, 19, 13298, '岳阳楼区', '岳阳楼区', 5),
(13300, 19, 13298, '君山区', '君山区', 10),
(13301, 19, 13298, '云溪区', '云溪区', 15),
(13302, 19, 13298, '临湘市', '临湘市', 20),
(13303, 19, 13298, '汨罗市', '汨罗市', 25),
(13304, 19, 13298, '岳阳县', '岳阳县', 30),
(13305, 19, 13298, '湘阴县', '湘阴县', 35),
(13306, 19, 13298, '华容县', '华容县', 40),
(13307, 19, 13298, '平江县', '平江县', 45),
(13308, 19, 13243, '常德市', '常德市', 40),
(13309, 19, 13308, '汉寿县', '汉寿县', 5),
(13310, 19, 13308, '石门县', '石门县', 10),
(13311, 19, 13308, '安乡县', '安乡县', 15),
(13312, 19, 13308, '鼎城区', '鼎城区', 20),
(13313, 19, 13308, '武陵区', '武陵区', 25),
(13314, 19, 13308, '津市市', '津市市', 30),
(13315, 19, 13308, '澧县', '澧县', 35),
(13316, 19, 13308, '临澧县', '临澧县', 40),
(13317, 19, 13308, '桃源县', '桃源县', 45),
(13318, 19, 13243, '张家界市', '张家界市', 45),
(13319, 19, 13318, '慈利县', '慈利县', 5),
(13320, 19, 13318, '桑植县', '桑植县', 10),
(13321, 19, 13318, '武陵源区', '武陵源区', 15),
(13322, 19, 13318, '永定区', '永定区', 20),
(13323, 19, 13243, '郴州市', '郴州市', 50),
(13324, 19, 13323, '资兴市', '资兴市', 5),
(13325, 19, 13323, '宜章县', '宜章县', 10),
(13326, 19, 13323, '安仁县', '安仁县', 15),
(13327, 19, 13323, '汝城县', '汝城县', 20),
(13328, 19, 13323, '嘉禾县', '嘉禾县', 25),
(13329, 19, 13323, '临武县', '临武县', 30),
(13330, 19, 13323, '桂东县', '桂东县', 35),
(13331, 19, 13323, '永兴县', '永兴县', 40),
(13332, 19, 13323, '桂阳县', '桂阳县', 45),
(13333, 19, 13323, '北湖区', '北湖区', 50),
(13334, 19, 13323, '苏仙区', '苏仙区', 55),
(13335, 19, 13243, '益阳市', '益阳市', 55),
(13336, 19, 13335, '南县', '南县', 5),
(13337, 19, 13335, '桃江县', '桃江县', 10),
(13338, 19, 13335, '安化县', '安化县', 15),
(13339, 19, 13335, '赫山区', '赫山区', 20),
(13340, 19, 13335, '资阳区', '资阳区', 25),
(13341, 19, 13335, '沅江市', '沅江市', 30),
(13342, 19, 13243, '永州市', '永州市', 60),
(13343, 19, 13342, '冷水滩区', '冷水滩区', 5),
(13344, 19, 13342, '祁阳县', '祁阳县', 10),
(13345, 19, 13342, '双牌县', '双牌县', 15),
(13346, 19, 13342, '道县', '道县', 20),
(13347, 19, 13342, '江永县', '江永县', 25),
(13348, 19, 13342, '江华县', '江华县', 30),
(13349, 19, 13342, '宁远县', '宁远县', 35),
(13350, 19, 13342, '新田县', '新田县', 40),
(13351, 19, 13342, '蓝山县', '蓝山县', 45),
(13352, 19, 13342, '东安县', '东安县', 50),
(13353, 19, 13342, '零陵区', '零陵区', 55),
(13354, 19, 13243, '怀化市', '怀化市', 65),
(13355, 19, 13354, '鹤城区', '鹤城区', 5),
(13356, 19, 13354, '洪江市', '洪江市', 10),
(13357, 19, 13354, '会同县', '会同县', 15),
(13358, 19, 13354, '溆浦县', '溆浦县', 20),
(13359, 19, 13354, '中方县', '中方县', 25),
(13360, 19, 13354, '辰溪县', '辰溪县', 30),
(13361, 19, 13354, '靖州县', '靖州县', 35),
(13362, 19, 13354, '通道县', '通道县', 40),
(13363, 19, 13354, '芷江县', '芷江县', 45),
(13364, 19, 13354, '新晃县', '新晃县', 50),
(13365, 19, 13354, '麻阳县', '麻阳县', 55),
(13366, 19, 13354, '沅陵县', '沅陵县', 60),
(13367, 19, 13243, '娄底市', '娄底市', 70),
(13368, 19, 13367, '娄星区', '娄星区', 5),
(13369, 19, 13367, '冷水江市', '冷水江市', 10),
(13370, 19, 13367, '涟源市', '涟源市', 15),
(13371, 19, 13367, '新化县', '新化县', 20),
(13372, 19, 13367, '双峰县', '双峰县', 25),
(13373, 19, 13243, '湘西州', '湘西州', 75),
(13374, 19, 13373, '吉首市', '吉首市', 5),
(13375, 19, 13373, '古丈县', '古丈县', 10),
(13376, 19, 13373, '龙山县', '龙山县', 15),
(13377, 19, 13373, '永顺县', '永顺县', 20),
(13378, 19, 13373, '泸溪县', '泸溪县', 25),
(13379, 19, 13373, '凤凰县', '凤凰县', 30),
(13380, 19, 13373, '花垣县', '花垣县', 35),
(13381, 19, 13373, '保靖县', '保靖县', 40),
(13382, 19, 0, '广东省', '广东省', 95),
(13383, 19, 13382, '广州市', '广州市', 5),
(13384, 19, 13383, '天河区', '天河区', 5),
(13385, 19, 13383, '海珠区', '海珠区', 10),
(13386, 19, 13383, '荔湾区', '荔湾区', 15),
(13387, 19, 13383, '越秀区', '越秀区', 20),
(13388, 19, 13383, '番禺区', '番禺区', 25),
(13389, 19, 13383, '花都区', '花都区', 30),
(13390, 19, 13383, '萝岗区', '萝岗区', 35),
(13391, 19, 13383, '白云区', '白云区', 40),
(13392, 19, 13383, '南沙区', '南沙区', 45),
(13393, 19, 13383, '黄埔区', '黄埔区', 50),
(13394, 19, 13383, '增城市', '增城市', 55),
(13395, 19, 13383, '从化市', '从化市', 60),
(13396, 19, 13383, '广州大学城', '广州大学城', 65),
(13397, 19, 13382, '深圳市', '深圳市', 10),
(13398, 19, 13397, '罗湖区', '罗湖区', 5),
(13399, 19, 13397, '福田区', '福田区', 10),
(13400, 19, 13397, '南山区', '南山区', 15),
(13401, 19, 13397, '宝安区', '宝安区', 20),
(13402, 19, 13397, '光明新区', '光明新区', 25),
(13403, 19, 13397, '龙岗区', '龙岗区', 30),
(13404, 19, 13397, '坪山新区', '坪山新区', 35),
(13405, 19, 13397, '盐田区', '盐田区', 40),
(13406, 19, 13397, '龙华区', '龙华区', 45),
(13407, 19, 13397, '大鹏新区', '大鹏新区', 50),
(13408, 19, 13382, '珠海市', '珠海市', 15),
(13409, 19, 13408, '斗门区', '斗门区', 5),
(13410, 19, 13408, '金湾区', '金湾区', 10),
(13411, 19, 13408, '香洲区', '香洲区', 15),
(13412, 19, 13382, '汕头市', '汕头市', 20),
(13413, 19, 13412, '龙湖区', '龙湖区', 5),
(13414, 19, 13412, '金平区', '金平区', 10),
(13415, 19, 13412, '澄海区', '澄海区', 15),
(13416, 19, 13412, '潮阳区', '潮阳区', 20),
(13417, 19, 13412, '潮南区', '潮南区', 25),
(13418, 19, 13412, '濠江区', '濠江区', 30),
(13419, 19, 13412, '南澳县', '南澳县', 35),
(13420, 19, 13382, '韶关市', '韶关市', 25),
(13421, 19, 13420, '武江区', '武江区', 5),
(13422, 19, 13420, '浈江区', '浈江区', 10),
(13423, 19, 13420, '南雄市', '南雄市', 15),
(13424, 19, 13420, '乐昌市', '乐昌市', 20),
(13425, 19, 13420, '仁化县', '仁化县', 25),
(13426, 19, 13420, '始兴县', '始兴县', 30),
(13427, 19, 13420, '翁源县', '翁源县', 35),
(13428, 19, 13420, '新丰县', '新丰县', 40),
(13429, 19, 13420, '乳源瑶族自治县', '乳源瑶族自治县', 45),
(13430, 19, 13420, '曲江区', '曲江区', 50),
(13431, 19, 13382, '河源市', '河源市', 30),
(13432, 19, 13431, '和平县', '和平县', 5),
(13433, 19, 13431, '龙川县', '龙川县', 10),
(13434, 19, 13431, '紫金县', '紫金县', 15),
(13435, 19, 13431, '连平县', '连平县', 20),
(13436, 19, 13431, '源城区', '源城区', 25),
(13437, 19, 13431, '东源县', '东源县', 30),
(13438, 19, 13382, '梅州市', '梅州市', 35),
(13439, 19, 13438, '梅江区', '梅江区', 5),
(13440, 19, 13438, '兴宁市', '兴宁市', 10),
(13441, 19, 13438, '梅县', '梅县', 15),
(13442, 19, 13438, '蕉岭县', '蕉岭县', 20),
(13443, 19, 13438, '大埔县', '大埔县', 25),
(13444, 19, 13438, '丰顺县', '丰顺县', 30),
(13445, 19, 13438, '五华县', '五华县', 35),
(13446, 19, 13438, '平远县', '平远县', 40),
(13447, 19, 13382, '惠州市', '惠州市', 40),
(13448, 19, 13447, '惠阳区', '惠阳区', 5),
(13449, 19, 13447, '大亚湾区', '大亚湾区', 10),
(13450, 19, 13447, '惠城区', '惠城区', 15),
(13451, 19, 13447, '惠东县', '惠东县', 20),
(13452, 19, 13447, '博罗县', '博罗县', 25),
(13453, 19, 13447, '龙门县', '龙门县', 30),
(13454, 19, 13382, '汕尾市', '汕尾市', 45),
(13455, 19, 13454, '城区', '城区', 5),
(13456, 19, 13454, '陆丰市', '陆丰市', 10),
(13457, 19, 13454, '陆河县', '陆河县', 15),
(13458, 19, 13454, '海丰县', '海丰县', 20),
(13459, 19, 13382, '东莞市', '东莞市', 50),
(13460, 19, 13459, '长安镇', '长安镇', 5),
(13461, 19, 13459, '莞城区', '莞城区', 10),
(13462, 19, 13459, '南城区', '南城区', 15),
(13463, 19, 13459, '寮步镇', '寮步镇', 20),
(13464, 19, 13459, '大岭山镇', '大岭山镇', 25),
(13465, 19, 13459, '横沥镇', '横沥镇', 30),
(13466, 19, 13459, '常平镇', '常平镇', 35),
(13467, 19, 13459, '厚街镇', '厚街镇', 40),
(13468, 19, 13459, '万江区', '万江区', 45),
(13469, 19, 13459, '樟木头镇', '樟木头镇', 50),
(13470, 19, 13459, '塘厦镇', '塘厦镇', 55),
(13471, 19, 13459, '凤岗镇', '凤岗镇', 60),
(13472, 19, 13459, '大朗镇', '大朗镇', 65),
(13473, 19, 13459, '东坑镇', '东坑镇', 70),
(13474, 19, 13459, '清溪镇', '清溪镇', 75),
(13475, 19, 13459, '企石镇', '企石镇', 80),
(13476, 19, 13459, '茶山镇', '茶山镇', 85),
(13477, 19, 13459, '东城区', '东城区', 90),
(13478, 19, 13459, '虎门镇', '虎门镇', 95),
(13479, 19, 13459, '黄江镇', '黄江镇', 100),
(13480, 19, 13459, '石排镇', '石排镇', 105),
(13481, 19, 13459, '道滘镇', '道滘镇', 110),
(13482, 19, 13459, '沙田镇', '沙田镇', 115),
(13483, 19, 13459, '高埗镇', '高埗镇', 120),
(13484, 19, 13459, '石龙镇', '石龙镇', 125),
(13485, 19, 13459, '石碣镇', '石碣镇', 130),
(13486, 19, 13459, '洪梅镇', '洪梅镇', 135),
(13487, 19, 13459, '麻涌镇', '麻涌镇', 140),
(13488, 19, 13459, '松山湖', '松山湖', 145),
(13489, 19, 13459, '桥头镇', '桥头镇', 150),
(13490, 19, 13459, '望牛墩镇', '望牛墩镇', 155),
(13491, 19, 13459, '中堂镇', '中堂镇', 160),
(13492, 19, 13459, '谢岗镇', '谢岗镇', 165),
(13493, 19, 13382, '中山市', '中山市', 55),
(13494, 19, 13493, '城区', '城区', 5),
(13495, 19, 13493, '火炬开发区', '火炬开发区', 10),
(13496, 19, 13493, '小榄镇', '小榄镇', 15),
(13497, 19, 13493, '古镇', '古镇', 20),
(13498, 19, 13493, '三乡镇', '三乡镇', 25),
(13499, 19, 13493, '民众镇', '民众镇', 30),
(13500, 19, 13493, '东凤镇', '东凤镇', 35),
(13501, 19, 13493, '板芙镇', '板芙镇', 40),
(13502, 19, 13493, '神湾镇', '神湾镇', 45),
(13503, 19, 13493, '横栏镇', '横栏镇', 50),
(13504, 19, 13493, '港口镇', '港口镇', 55),
(13505, 19, 13493, '三角镇', '三角镇', 60),
(13506, 19, 13493, '大涌镇', '大涌镇', 65),
(13507, 19, 13493, '南头镇', '南头镇', 70),
(13508, 19, 13493, '沙溪镇', '沙溪镇', 75),
(13509, 19, 13493, '坦洲镇', '坦洲镇', 80),
(13510, 19, 13493, '黄圃镇', '黄圃镇', 85),
(13511, 19, 13493, '五桂山镇', '五桂山镇', 90),
(13512, 19, 13493, '南朗镇', '南朗镇', 95),
(13513, 19, 13493, '沙朗镇', '沙朗镇', 100),
(13514, 19, 13493, '阜沙镇', '阜沙镇', 105),
(13515, 19, 13493, '东升镇', '东升镇', 110),
(13516, 19, 13382, '江门市', '江门市', 60),
(13517, 19, 13516, '台山市', '台山市', 5),
(13518, 19, 13516, '新会区', '新会区', 10),
(13519, 19, 13516, '鹤山市', '鹤山市', 15),
(13520, 19, 13516, '江海区', '江海区', 20),
(13521, 19, 13516, '蓬江区', '蓬江区', 25),
(13522, 19, 13516, '开平市', '开平市', 30),
(13523, 19, 13516, '恩平市', '恩平市', 35),
(13524, 19, 13382, '佛山市', '佛山市', 65),
(13525, 19, 13524, '顺德区', '顺德区', 5),
(13526, 19, 13524, '禅城区', '禅城区', 10),
(13527, 19, 13524, '高明区', '高明区', 15),
(13528, 19, 13524, '三水区', '三水区', 20),
(13529, 19, 13524, '南海区', '南海区', 25),
(13530, 19, 13382, '阳江市', '阳江市', 70),
(13531, 19, 13530, '江城区', '江城区', 5),
(13532, 19, 13530, '阳东县', '阳东县', 10),
(13533, 19, 13530, '阳春市', '阳春市', 15),
(13534, 19, 13530, '阳西县', '阳西县', 20),
(13535, 19, 13382, '湛江市', '湛江市', 75),
(13536, 19, 13535, '赤坎区', '赤坎区', 5),
(13537, 19, 13535, '霞山区', '霞山区', 10),
(13538, 19, 13535, '经济技术开发区', '经济技术开发区', 15),
(13539, 19, 13535, '麻章区', '麻章区', 20),
(13540, 19, 13535, '遂溪县', '遂溪县', 25),
(13541, 19, 13535, '廉江市', '廉江市', 30),
(13542, 19, 13535, '坡头区', '坡头区', 35),
(13543, 19, 13535, '雷州市', '雷州市', 40),
(13544, 19, 13535, '吴川市', '吴川市', 45),
(13545, 19, 13535, '徐闻县', '徐闻县', 50),
(13546, 19, 13382, '茂名市', '茂名市', 80),
(13547, 19, 13546, '茂南区', '茂南区', 5),
(13548, 19, 13546, '电白县', '电白县', 10),
(13549, 19, 13546, '高州市', '高州市', 15),
(13550, 19, 13546, '化州市', '化州市', 20),
(13551, 19, 13546, '茂港区', '茂港区', 25),
(13552, 19, 13546, '信宜市', '信宜市', 30),
(13553, 19, 13382, '肇庆市', '肇庆市', 85),
(13554, 19, 13553, '端州区', '端州区', 5),
(13555, 19, 13553, '四会市', '四会市', 10),
(13556, 19, 13553, '高要市', '高要市', 15),
(13557, 19, 13553, '广宁县', '广宁县', 20),
(13558, 19, 13553, '德庆县', '德庆县', 25),
(13559, 19, 13553, '怀集县', '怀集县', 30),
(13560, 19, 13553, '封开县', '封开县', 35),
(13561, 19, 13553, '鼎湖区', '鼎湖区', 40),
(13562, 19, 13382, '云浮市', '云浮市', 90),
(13563, 19, 13562, '云城区', '云城区', 5),
(13564, 19, 13562, '罗定市', '罗定市', 10),
(13565, 19, 13562, '云安县', '云安县', 15),
(13566, 19, 13562, '新兴县', '新兴县', 20),
(13567, 19, 13562, '郁南县', '郁南县', 25),
(13568, 19, 13382, '清远市', '清远市', 95),
(13569, 19, 13568, '连州市', '连州市', 5),
(13570, 19, 13568, '佛冈县', '佛冈县', 10),
(13571, 19, 13568, '阳山县', '阳山县', 15),
(13572, 19, 13568, '清新县', '清新县', 20),
(13573, 19, 13568, '连山县', '连山县', 25),
(13574, 19, 13568, '连南县', '连南县', 30),
(13575, 19, 13568, '清城区', '清城区', 35),
(13576, 19, 13568, '英德市', '英德市', 40),
(13577, 19, 13382, '潮州市', '潮州市', 100),
(13578, 19, 13577, '湘桥区', '湘桥区', 5),
(13579, 19, 13577, '枫溪区', '枫溪区', 10),
(13580, 19, 13577, '潮安县', '潮安县', 15),
(13581, 19, 13577, '饶平县', '饶平县', 20),
(13582, 19, 13382, '揭阳市', '揭阳市', 105),
(13583, 19, 13582, '东山区', '东山区', 5),
(13584, 19, 13582, '普宁市', '普宁市', 10),
(13585, 19, 13582, '榕城区', '榕城区', 15),
(13586, 19, 13582, '揭东县', '揭东县', 20),
(13587, 19, 13582, '揭西县', '揭西县', 25),
(13588, 19, 13582, '惠来县', '惠来县', 30),
(13589, 19, 0, '广西壮族自治区', '广西壮族自治区', 100),
(13590, 19, 13589, '南宁市', '南宁市', 5),
(13591, 19, 13590, '良庆区', '良庆区', 5),
(13592, 19, 13590, '江南区', '江南区', 10),
(13593, 19, 13590, '兴宁区', '兴宁区', 15),
(13594, 19, 13590, '青秀区', '青秀区', 20),
(13595, 19, 13590, '西乡塘区', '西乡塘区', 25),
(13596, 19, 13590, '横县', '横县', 30),
(13597, 19, 13590, '上林县', '上林县', 35),
(13598, 19, 13590, '隆安县', '隆安县', 40),
(13599, 19, 13590, '马山县', '马山县', 45),
(13600, 19, 13590, '武鸣县', '武鸣县', 50),
(13601, 19, 13590, '邕宁区', '邕宁区', 55),
(13602, 19, 13590, '宾阳县', '宾阳县', 60),
(13603, 19, 13589, '柳州市', '柳州市', 10),
(13604, 19, 13603, '融安县', '融安县', 5),
(13605, 19, 13603, '三江县', '三江县', 10),
(13606, 19, 13603, '融水县', '融水县', 15),
(13607, 19, 13603, '鱼峰区', '鱼峰区', 20),
(13608, 19, 13603, '城中区', '城中区', 25),
(13609, 19, 13603, '柳南区', '柳南区', 30),
(13610, 19, 13603, '柳北区', '柳北区', 35),
(13611, 19, 13603, '柳江县', '柳江县', 40),
(13612, 19, 13603, '柳城县', '柳城县', 45),
(13613, 19, 13603, '鹿寨县', '鹿寨县', 50),
(13614, 19, 13589, '桂林市', '桂林市', 15),
(13615, 19, 13614, '象山区', '象山区', 5),
(13616, 19, 13614, '恭城县', '恭城县', 10),
(13617, 19, 13614, '秀峰区', '秀峰区', 15),
(13618, 19, 13614, '叠彩区', '叠彩区', 20),
(13619, 19, 13614, '七星区', '七星区', 25),
(13620, 19, 13614, '雁山区', '雁山区', 30),
(13621, 19, 13614, '阳朔县', '阳朔县', 35),
(13622, 19, 13614, '临桂县', '临桂县', 40),
(13623, 19, 13614, '灵川县', '灵川县', 45),
(13624, 19, 13614, '全州县', '全州县', 50),
(13625, 19, 13614, '平乐县', '平乐县', 55),
(13626, 19, 13614, '兴安县', '兴安县', 60),
(13627, 19, 13614, '灌阳县', '灌阳县', 65),
(13628, 19, 13614, '荔浦县', '荔浦县', 70),
(13629, 19, 13614, '资源县', '资源县', 75),
(13630, 19, 13614, '永福县', '永福县', 80),
(13631, 19, 13614, '龙胜县', '龙胜县', 85),
(13632, 19, 13589, '梧州市', '梧州市', 20),
(13633, 19, 13632, '岑溪市', '岑溪市', 5),
(13634, 19, 13632, '苍梧县', '苍梧县', 10),
(13635, 19, 13632, '藤县', '藤县', 15),
(13636, 19, 13632, '蒙山县', '蒙山县', 20),
(13637, 19, 13632, '万秀区', '万秀区', 25),
(13638, 19, 13632, '蝶山区', '蝶山区', 30),
(13639, 19, 13632, '长洲区', '长洲区', 35),
(13640, 19, 13589, '北海市', '北海市', 25),
(13641, 19, 13640, '海城区', '海城区', 5),
(13642, 19, 13640, '银海区', '银海区', 10),
(13643, 19, 13640, '合浦县', '合浦县', 15),
(13644, 19, 13640, '铁山港区', '铁山港区', 20),
(13645, 19, 13589, '防城港市', '防城港市', 30),
(13646, 19, 13645, '防城区', '防城区', 5),
(13647, 19, 13645, '港口区', '港口区', 10),
(13648, 19, 13645, '东兴市', '东兴市', 15),
(13649, 19, 13645, '上思县', '上思县', 20),
(13650, 19, 13589, '钦州市', '钦州市', 35),
(13651, 19, 13650, '钦南区', '钦南区', 5),
(13652, 19, 13650, '钦北区', '钦北区', 10),
(13653, 19, 13650, '浦北县', '浦北县', 15),
(13654, 19, 13650, '灵山县', '灵山县', 20),
(13655, 19, 13589, '贵港市', '贵港市', 40),
(13656, 19, 13655, '港南区', '港南区', 5),
(13657, 19, 13655, '港北区', '港北区', 10),
(13658, 19, 13655, '桂平市', '桂平市', 15),
(13659, 19, 13655, '平南县', '平南县', 20),
(13660, 19, 13655, '覃塘区', '覃塘区', 25),
(13661, 19, 13589, '玉林市', '玉林市', 45),
(13662, 19, 13661, '玉州区', '玉州区', 5),
(13663, 19, 13661, '北流市', '北流市', 10),
(13664, 19, 13661, '容县', '容县', 15),
(13665, 19, 13661, '博白县', '博白县', 20),
(13666, 19, 13661, '陆川县', '陆川县', 25),
(13667, 19, 13661, '兴业县', '兴业县', 30),
(13668, 19, 13589, '贺州市', '贺州市', 50),
(13669, 19, 13668, '八步区', '八步区', 5),
(13670, 19, 13668, '钟山县', '钟山县', 10),
(13671, 19, 13668, '昭平县', '昭平县', 15),
(13672, 19, 13668, '富川县', '富川县', 20),
(13673, 19, 13668, '平桂管理区', '平桂管理区', 25),
(13674, 19, 13589, '百色市', '百色市', 55),
(13675, 19, 13674, '右江区', '右江区', 5),
(13676, 19, 13674, '平果县', '平果县', 10),
(13677, 19, 13674, '乐业县', '乐业县', 15),
(13678, 19, 13674, '田阳县', '田阳县', 20),
(13679, 19, 13674, '西林县', '西林县', 25),
(13680, 19, 13674, '田林县', '田林县', 30),
(13681, 19, 13674, '德保县', '德保县', 35),
(13682, 19, 13674, '靖西县', '靖西县', 40),
(13683, 19, 13674, '田东县', '田东县', 45),
(13684, 19, 13674, '那坡县', '那坡县', 50),
(13685, 19, 13674, '隆林县', '隆林县', 55),
(13686, 19, 13674, '凌云县', '凌云县', 60),
(13687, 19, 13589, '河池市', '河池市', 60),
(13688, 19, 13687, '宜州市', '宜州市', 5),
(13689, 19, 13687, '天峨县', '天峨县', 10),
(13690, 19, 13687, '凤山县', '凤山县', 15),
(13691, 19, 13687, '南丹县', '南丹县', 20),
(13692, 19, 13687, '东兰县', '东兰县', 25),
(13693, 19, 13687, '巴马县', '巴马县', 30),
(13694, 19, 13687, '环江县', '环江县', 35),
(13695, 19, 13687, '大化县', '大化县', 40),
(13696, 19, 13687, '都安县', '都安县', 45),
(13697, 19, 13687, '金城江区', '金城江区', 50),
(13698, 19, 13687, '罗城县', '罗城县', 55),
(13699, 19, 13589, '来宾市', '来宾市', 65),
(13700, 19, 13699, '兴宾区', '兴宾区', 5),
(13701, 19, 13699, '合山市', '合山市', 10),
(13702, 19, 13699, '忻城县', '忻城县', 15),
(13703, 19, 13699, '武宣县', '武宣县', 20),
(13704, 19, 13699, '象州县', '象州县', 25),
(13705, 19, 13699, '金秀县', '金秀县', 30),
(13706, 19, 13589, '崇左市', '崇左市', 70),
(13707, 19, 13706, '江州区', '江州区', 5),
(13708, 19, 13706, '凭祥市', '凭祥市', 10),
(13709, 19, 13706, '扶绥县', '扶绥县', 15),
(13710, 19, 13706, '大新县', '大新县', 20),
(13711, 19, 13706, '天等县', '天等县', 25),
(13712, 19, 13706, '宁明县', '宁明县', 30),
(13713, 19, 13706, '龙州县', '龙州县', 35),
(13714, 19, 0, '江西省', '江西省', 105),
(13715, 19, 13714, '南昌市', '南昌市', 5),
(13716, 19, 13715, '青云谱区', '青云谱区', 5),
(13717, 19, 13715, '西湖区', '西湖区', 10),
(13718, 19, 13715, '东湖区', '东湖区', 15),
(13719, 19, 13715, '昌北区', '昌北区', 20),
(13720, 19, 13715, '南昌县', '南昌县', 25),
(13721, 19, 13715, '进贤县', '进贤县', 30),
(13722, 19, 13715, '安义县', '安义县', 35),
(13723, 19, 13715, '青山湖区', '青山湖区', 40),
(13724, 19, 13715, '红谷滩新区', '红谷滩新区', 45),
(13725, 19, 13715, '新建县', '新建县', 50),
(13726, 19, 13715, '湾里区', '湾里区', 55),
(13727, 19, 13715, '高新区', '高新区', 60),
(13728, 19, 13714, '景德镇市', '景德镇市', 10),
(13729, 19, 13728, '珠山区', '珠山区', 5),
(13730, 19, 13728, '乐平市', '乐平市', 10),
(13731, 19, 13728, '浮梁县', '浮梁县', 15),
(13732, 19, 13728, '昌江区', '昌江区', 20),
(13733, 19, 13714, '萍乡市', '萍乡市', 15),
(13734, 19, 13733, '湘东区', '湘东区', 5),
(13735, 19, 13733, '莲花县', '莲花县', 10),
(13736, 19, 13733, '上栗县', '上栗县', 15),
(13737, 19, 13733, '芦溪县', '芦溪县', 20),
(13738, 19, 13733, '安源区', '安源区', 25),
(13739, 19, 13714, '新余市', '新余市', 20),
(13740, 19, 13739, '分宜县', '分宜县', 5),
(13741, 19, 13739, '渝水区', '渝水区', 10),
(13742, 19, 13714, '九江市', '九江市', 25),
(13743, 19, 13742, '九江县', '九江县', 5),
(13744, 19, 13742, '瑞昌市', '瑞昌市', 10),
(13745, 19, 13742, '星子县', '星子县', 15),
(13746, 19, 13742, '武宁县', '武宁县', 20),
(13747, 19, 13742, '彭泽县', '彭泽县', 25),
(13748, 19, 13742, '永修县', '永修县', 30),
(13749, 19, 13742, '修水县', '修水县', 35),
(13750, 19, 13742, '湖口县', '湖口县', 40),
(13751, 19, 13742, '德安县', '德安县', 45),
(13752, 19, 13742, '都昌县', '都昌县', 50),
(13753, 19, 13742, '共青城市', '共青城市', 55),
(13754, 19, 13742, '经济技术开发区', '经济技术开发区', 60),
(13755, 19, 13742, '八里湖新区', '八里湖新区', 65),
(13756, 19, 13742, '庐山风景名胜区', '庐山风景名胜区', 70),
(13757, 19, 13742, '庐山区', '庐山区', 75),
(13758, 19, 13742, '浔阳区', '浔阳区', 80),
(13759, 19, 13714, '鹰潭市', '鹰潭市', 30),
(13760, 19, 13759, '龙虎山风景旅游区', '龙虎山风景旅游区', 5),
(13761, 19, 13759, '余江县', '余江县', 10),
(13762, 19, 13759, '贵溪市', '贵溪市', 15),
(13763, 19, 13759, '月湖区', '月湖区', 20),
(13764, 19, 13714, '上饶市', '上饶市', 35),
(13765, 19, 13764, '德兴市', '德兴市', 5),
(13766, 19, 13764, '广丰县', '广丰县', 10),
(13767, 19, 13764, '鄱阳县', '鄱阳县', 15),
(13768, 19, 13764, '婺源县', '婺源县', 20),
(13769, 19, 13764, '余干县', '余干县', 25),
(13770, 19, 13764, '横峰县', '横峰县', 30),
(13771, 19, 13764, '弋阳县', '弋阳县', 35),
(13772, 19, 13764, '铅山县', '铅山县', 40),
(13773, 19, 13764, '玉山县', '玉山县', 45),
(13774, 19, 13764, '万年县', '万年县', 50),
(13775, 19, 13764, '信州区', '信州区', 55),
(13776, 19, 13764, '上饶县', '上饶县', 60),
(13777, 19, 13714, '宜春市', '宜春市', 40),
(13778, 19, 13777, '丰城市', '丰城市', 5),
(13779, 19, 13777, '樟树市', '樟树市', 10),
(13780, 19, 13777, '袁州区', '袁州区', 15),
(13781, 19, 13777, '高安市', '高安市', 20),
(13782, 19, 13777, '铜鼓县', '铜鼓县', 25),
(13783, 19, 13777, '靖安县', '靖安县', 30),
(13784, 19, 13777, '宜丰县', '宜丰县', 35),
(13785, 19, 13777, '奉新县', '奉新县', 40),
(13786, 19, 13777, '万载县', '万载县', 45),
(13787, 19, 13777, '上高县', '上高县', 50),
(13788, 19, 13714, '抚州市', '抚州市', 45),
(13789, 19, 13788, '南丰县', '南丰县', 5),
(13790, 19, 13788, '乐安县', '乐安县', 10),
(13791, 19, 13788, '金溪县', '金溪县', 15),
(13792, 19, 13788, '南城县', '南城县', 20),
(13793, 19, 13788, '东乡县', '东乡县', 25),
(13794, 19, 13788, '资溪县', '资溪县', 30),
(13795, 19, 13788, '宜黄县', '宜黄县', 35),
(13796, 19, 13788, '崇仁县', '崇仁县', 40),
(13797, 19, 13788, '黎川县', '黎川县', 45),
(13798, 19, 13788, '广昌县', '广昌县', 50),
(13799, 19, 13788, '临川区', '临川区', 55),
(13800, 19, 13714, '吉安市', '吉安市', 50),
(13801, 19, 13800, '青原区', '青原区', 5),
(13802, 19, 13800, '吉州区', '吉州区', 10),
(13803, 19, 13800, '井冈山市', '井冈山市', 15),
(13804, 19, 13800, '吉安县', '吉安县', 20),
(13805, 19, 13800, '永丰县', '永丰县', 25),
(13806, 19, 13800, '永新县', '永新县', 30),
(13807, 19, 13800, '新干县', '新干县', 35),
(13808, 19, 13800, '泰和县', '泰和县', 40),
(13809, 19, 13800, '峡江县', '峡江县', 45),
(13810, 19, 13800, '遂川县', '遂川县', 50),
(13811, 19, 13800, '安福县', '安福县', 55),
(13812, 19, 13800, '吉水县', '吉水县', 60),
(13813, 19, 13800, '万安县', '万安县', 65),
(13814, 19, 13714, '赣州市', '赣州市', 55),
(13815, 19, 13814, '章贡区', '章贡区', 5),
(13816, 19, 13814, '南康市', '南康市', 10),
(13817, 19, 13814, '瑞金市', '瑞金市', 15),
(13818, 19, 13814, '石城县', '石城县', 20),
(13819, 19, 13814, '安远县', '安远县', 25),
(13820, 19, 13814, '赣县', '赣县', 30),
(13821, 19, 13814, '宁都县', '宁都县', 35),
(13822, 19, 13814, '寻乌县', '寻乌县', 40),
(13823, 19, 13814, '兴国县', '兴国县', 45),
(13824, 19, 13814, '定南县', '定南县', 50),
(13825, 19, 13814, '上犹县', '上犹县', 55),
(13826, 19, 13814, '于都县', '于都县', 60),
(13827, 19, 13814, '龙南县', '龙南县', 65),
(13828, 19, 13814, '崇义县', '崇义县', 70),
(13829, 19, 13814, '大余县', '大余县', 75),
(13830, 19, 13814, '信丰县', '信丰县', 80),
(13831, 19, 13814, '全南县', '全南县', 85),
(13832, 19, 13814, '会昌县', '会昌县', 90),
(13833, 19, 0, '四川省', '四川省', 110),
(13834, 19, 13833, '成都市', '成都市', 5),
(13835, 19, 13834, '武侯区', '武侯区', 5),
(13836, 19, 13834, '金牛区', '金牛区', 10),
(13837, 19, 13834, '青羊区', '青羊区', 15),
(13838, 19, 13834, '成华区', '成华区', 20),
(13839, 19, 13834, '高新区', '高新区', 25),
(13840, 19, 13834, '锦江区', '锦江区', 30),
(13841, 19, 13834, '郫县', '郫县', 35),
(13842, 19, 13834, '双流县', '双流县', 40),
(13843, 19, 13834, '高新西区', '高新西区', 45),
(13844, 19, 13834, '龙泉驿区', '龙泉驿区', 50),
(13845, 19, 13834, '新都区', '新都区', 55),
(13846, 19, 13834, '温江区', '温江区', 60),
(13847, 19, 13834, '都江堰市', '都江堰市', 65),
(13848, 19, 13834, '彭州市', '彭州市', 70),
(13849, 19, 13834, '青白江区', '青白江区', 75),
(13850, 19, 13834, '崇州市', '崇州市', 80),
(13851, 19, 13834, '金堂县', '金堂县', 85),
(13852, 19, 13834, '新津县', '新津县', 90),
(13853, 19, 13834, '邛崃市', '邛崃市', 95),
(13854, 19, 13834, '大邑县', '大邑县', 100),
(13855, 19, 13834, '蒲江县', '蒲江县', 105),
(13856, 19, 13833, '自贡市', '自贡市', 10),
(13857, 19, 13856, '自流井区', '自流井区', 5),
(13858, 19, 13856, '沿滩区', '沿滩区', 10),
(13859, 19, 13856, '荣县', '荣县', 15),
(13860, 19, 13856, '富顺县', '富顺县', 20),
(13861, 19, 13856, '大安区', '大安区', 25),
(13862, 19, 13856, '贡井区', '贡井区', 30),
(13863, 19, 13833, '攀枝花市', '攀枝花市', 15),
(13864, 19, 13863, '仁和区', '仁和区', 5),
(13865, 19, 13863, '西区', '西区', 10),
(13866, 19, 13863, '东区', '东区', 15),
(13867, 19, 13863, '米易县', '米易县', 20),
(13868, 19, 13863, '盐边县', '盐边县', 25),
(13869, 19, 13833, '泸州市', '泸州市', 20),
(13870, 19, 13869, '纳溪区', '纳溪区', 5),
(13871, 19, 13869, '江阳区', '江阳区', 10),
(13872, 19, 13869, '龙马潭区', '龙马潭区', 15),
(13873, 19, 13869, '泸县', '泸县', 20),
(13874, 19, 13869, '合江县', '合江县', 25),
(13875, 19, 13869, '叙永县', '叙永县', 30),
(13876, 19, 13869, '古蔺县', '古蔺县', 35),
(13877, 19, 13833, '绵阳市', '绵阳市', 25),
(13878, 19, 13877, '江油市', '江油市', 5),
(13879, 19, 13877, '涪城区', '涪城区', 10),
(13880, 19, 13877, '游仙区', '游仙区', 15),
(13881, 19, 13877, '高新区', '高新区', 20),
(13882, 19, 13877, '经开区', '经开区', 25),
(13883, 19, 13877, '盐亭县', '盐亭县', 30),
(13884, 19, 13877, '三台县', '三台县', 35),
(13885, 19, 13877, '平武县', '平武县', 40),
(13886, 19, 13877, '北川县', '北川县', 45),
(13887, 19, 13877, '安县', '安县', 50),
(13888, 19, 13877, '梓潼县', '梓潼县', 55),
(13889, 19, 13833, '德阳市', '德阳市', 30),
(13890, 19, 13889, '广汉市', '广汉市', 5),
(13891, 19, 13889, '什邡市', '什邡市', 10),
(13892, 19, 13889, '旌阳区', '旌阳区', 15),
(13893, 19, 13889, '绵竹市', '绵竹市', 20),
(13894, 19, 13889, '罗江县', '罗江县', 25),
(13895, 19, 13889, '中江县', '中江县', 30),
(13896, 19, 13833, '广元市', '广元市', 35),
(13897, 19, 13896, '元坝区', '元坝区', 5),
(13898, 19, 13896, '朝天区', '朝天区', 10),
(13899, 19, 13896, '利州区', '利州区', 15),
(13900, 19, 13896, '青川县', '青川县', 20),
(13901, 19, 13896, '旺苍县', '旺苍县', 25),
(13902, 19, 13896, '剑阁县', '剑阁县', 30),
(13903, 19, 13896, '苍溪县', '苍溪县', 35),
(13904, 19, 13833, '遂宁市', '遂宁市', 40),
(13905, 19, 13904, '船山区', '船山区', 5),
(13906, 19, 13904, '射洪县', '射洪县', 10),
(13907, 19, 13904, '蓬溪县', '蓬溪县', 15),
(13908, 19, 13904, '大英县', '大英县', 20),
(13909, 19, 13904, '安居区', '安居区', 25),
(13910, 19, 13833, '内江市', '内江市', 45),
(13911, 19, 13910, '东兴区', '东兴区', 5),
(13912, 19, 13910, '资中县', '资中县', 10),
(13913, 19, 13910, '隆昌县', '隆昌县', 15),
(13914, 19, 13910, '威远县', '威远县', 20),
(13915, 19, 13910, '市中区', '市中区', 25),
(13916, 19, 13833, '乐山市', '乐山市', 50),
(13917, 19, 13916, '市中区', '市中区', 5),
(13918, 19, 13916, '峨眉山市', '峨眉山市', 10),
(13919, 19, 13916, '五通桥区', '五通桥区', 15),
(13920, 19, 13916, '沙湾区', '沙湾区', 20),
(13921, 19, 13916, '金口河区', '金口河区', 25),
(13922, 19, 13916, '夹江县', '夹江县', 30),
(13923, 19, 13916, '井研县', '井研县', 35),
(13924, 19, 13916, '犍为县', '犍为县', 40),
(13925, 19, 13916, '沐川县', '沐川县', 45),
(13926, 19, 13916, '峨边县', '峨边县', 50),
(13927, 19, 13916, '马边县', '马边县', 55),
(13928, 19, 13833, '宜宾市', '宜宾市', 55),
(13929, 19, 13928, '宜宾县', '宜宾县', 5),
(13930, 19, 13928, '南溪区', '南溪区', 10),
(13931, 19, 13928, '江安县', '江安县', 15),
(13932, 19, 13928, '长宁县', '长宁县', 20),
(13933, 19, 13928, '兴文县', '兴文县', 25),
(13934, 19, 13928, '珙县', '珙县', 30),
(13935, 19, 13928, '翠屏区', '翠屏区', 35),
(13936, 19, 13928, '高县', '高县', 40),
(13937, 19, 13928, '屏山县', '屏山县', 45),
(13938, 19, 13928, '筠连县', '筠连县', 50),
(13939, 19, 13833, '广安市', '广安市', 60),
(13940, 19, 13939, '前锋区', '前锋区', 5),
(13941, 19, 13939, '岳池县', '岳池县', 10),
(13942, 19, 13939, '武胜县', '武胜县', 15),
(13943, 19, 13939, '邻水县', '邻水县', 20),
(13944, 19, 13939, '广安区', '广安区', 25),
(13945, 19, 13939, '华蓥市', '华蓥市', 30),
(13946, 19, 13833, '南充市', '南充市', 65),
(13947, 19, 13946, '顺庆区', '顺庆区', 5),
(13948, 19, 13946, '高坪区', '高坪区', 10),
(13949, 19, 13946, '嘉陵区', '嘉陵区', 15),
(13950, 19, 13946, '西充县', '西充县', 20),
(13951, 19, 13946, '阆中市', '阆中市', 25),
(13952, 19, 13946, '南部县', '南部县', 30),
(13953, 19, 13946, '仪陇县', '仪陇县', 35),
(13954, 19, 13946, '蓬安县', '蓬安县', 40),
(13955, 19, 13946, '营山县', '营山县', 45),
(13956, 19, 13833, '达州市', '达州市', 70),
(13957, 19, 13956, '通川区', '通川区', 5),
(13958, 19, 13956, '达县', '达县', 10),
(13959, 19, 13956, '大竹县', '大竹县', 15),
(13960, 19, 13956, '渠县', '渠县', 20),
(13961, 19, 13956, '万源市', '万源市', 25),
(13962, 19, 13956, '宣汉县', '宣汉县', 30),
(13963, 19, 13956, '开江县', '开江县', 35),
(13964, 19, 13833, '巴中市', '巴中市', 75),
(13965, 19, 13964, '巴州区', '巴州区', 5),
(13966, 19, 13964, '恩阳区', '恩阳区', 10),
(13967, 19, 13964, '南江县', '南江县', 15),
(13968, 19, 13964, '平昌县', '平昌县', 20),
(13969, 19, 13964, '通江县', '通江县', 25),
(13970, 19, 13833, '雅安市', '雅安市', 80),
(13971, 19, 13970, '芦山县', '芦山县', 5),
(13972, 19, 13970, '石棉县', '石棉县', 10),
(13973, 19, 13970, '名山区', '名山区', 15),
(13974, 19, 13970, '天全县', '天全县', 20),
(13975, 19, 13970, '荥经县', '荥经县', 25),
(13976, 19, 13970, '汉源县', '汉源县', 30),
(13977, 19, 13970, '宝兴县', '宝兴县', 35),
(13978, 19, 13970, '雨城区', '雨城区', 40),
(13979, 19, 13833, '眉山市', '眉山市', 85),
(13980, 19, 13979, '仁寿县', '仁寿县', 5),
(13981, 19, 13979, '彭山县', '彭山县', 10),
(13982, 19, 13979, '洪雅县', '洪雅县', 15),
(13983, 19, 13979, '丹棱县', '丹棱县', 20),
(13984, 19, 13979, '青神县', '青神县', 25),
(13985, 19, 13979, '东坡区', '东坡区', 30),
(13986, 19, 13833, '资阳市', '资阳市', 90),
(13987, 19, 13986, '雁江区', '雁江区', 5),
(13988, 19, 13986, '安岳县', '安岳县', 10),
(13989, 19, 13986, '乐至县', '乐至县', 15),
(13990, 19, 13986, '简阳市', '简阳市', 20),
(13991, 19, 13833, '阿坝州', '阿坝州', 95),
(13992, 19, 13991, '马尔康县', '马尔康县', 5),
(13993, 19, 13991, '九寨沟县', '九寨沟县', 10),
(13994, 19, 13991, '红原县', '红原县', 15),
(13995, 19, 13991, '阿坝县', '阿坝县', 20),
(13996, 19, 13991, '理县', '理县', 25),
(13997, 19, 13991, '若尔盖县', '若尔盖县', 30),
(13998, 19, 13991, '金川县', '金川县', 35),
(13999, 19, 13991, '小金县', '小金县', 40),
(14000, 19, 13991, '黑水县', '黑水县', 45),
(14001, 19, 13991, '松潘县', '松潘县', 50),
(14002, 19, 13991, '壤塘县', '壤塘县', 55),
(14003, 19, 13991, '茂县', '茂县', 60),
(14004, 19, 13991, '汶川县', '汶川县', 65),
(14005, 19, 13833, '甘孜州', '甘孜州', 100),
(14006, 19, 14005, '康定县', '康定县', 5),
(14007, 19, 14005, '泸定县', '泸定县', 10),
(14008, 19, 14005, '九龙县', '九龙县', 15),
(14009, 19, 14005, '丹巴县', '丹巴县', 20),
(14010, 19, 14005, '道孚县', '道孚县', 25),
(14011, 19, 14005, '炉霍县', '炉霍县', 30),
(14012, 19, 14005, '色达县', '色达县', 35),
(14013, 19, 14005, '甘孜县', '甘孜县', 40),
(14014, 19, 14005, '新龙县', '新龙县', 45),
(14015, 19, 14005, '白玉县', '白玉县', 50),
(14016, 19, 14005, '德格县', '德格县', 55),
(14017, 19, 14005, '石渠县', '石渠县', 60),
(14018, 19, 14005, '雅江县', '雅江县', 65),
(14019, 19, 14005, '理塘县', '理塘县', 70),
(14020, 19, 14005, '巴塘县', '巴塘县', 75),
(14021, 19, 14005, '稻城县', '稻城县', 80),
(14022, 19, 14005, '乡城县', '乡城县', 85),
(14023, 19, 14005, '得荣县', '得荣县', 90),
(14024, 19, 13833, '凉山州', '凉山州', 105),
(14025, 19, 14024, '美姑县', '美姑县', 5),
(14026, 19, 14024, '昭觉县', '昭觉县', 10),
(14027, 19, 14024, '会理县', '会理县', 15),
(14028, 19, 14024, '会东县', '会东县', 20),
(14029, 19, 14024, '普格县', '普格县', 25),
(14030, 19, 14024, '宁南县', '宁南县', 30),
(14031, 19, 14024, '德昌县', '德昌县', 35),
(14032, 19, 14024, '冕宁县', '冕宁县', 40),
(14033, 19, 14024, '盐源县', '盐源县', 45),
(14034, 19, 14024, '金阳县', '金阳县', 50),
(14035, 19, 14024, '布拖县', '布拖县', 55),
(14036, 19, 14024, '雷波县', '雷波县', 60),
(14037, 19, 14024, '越西县', '越西县', 65),
(14038, 19, 14024, '喜德县', '喜德县', 70),
(14039, 19, 14024, '甘洛县', '甘洛县', 75),
(14040, 19, 14024, '木里县', '木里县', 80),
(14041, 19, 14024, '西昌市', '西昌市', 85),
(14042, 19, 0, '海南省', '海南省', 115),
(14043, 19, 14042, '海口市', '海口市', 5),
(14044, 19, 14043, '秀英区', '秀英区', 5),
(14045, 19, 14043, '龙华区', '龙华区', 10),
(14046, 19, 14043, '琼山区', '琼山区', 15),
(14047, 19, 14043, '美兰区', '美兰区', 20),
(14048, 19, 14042, '儋州市', '儋州市', 10),
(14049, 19, 14048, '热作学院', '热作学院', 5),
(14050, 19, 14048, '那大镇', '那大镇', 10),
(14051, 19, 14048, '富克镇', '富克镇', 15),
(14052, 19, 14048, '和庆镇', '和庆镇', 20),
(14053, 19, 14048, '南丰镇', '南丰镇', 25),
(14054, 19, 14048, '大成镇', '大成镇', 30),
(14055, 19, 14048, '雅星镇', '雅星镇', 35),
(14056, 19, 14048, '兰洋镇', '兰洋镇', 40),
(14057, 19, 14048, '光村镇', '光村镇', 45),
(14058, 19, 14048, '木棠镇', '木棠镇', 50),
(14059, 19, 14048, '海头镇', '海头镇', 55),
(14060, 19, 14048, '峨蔓镇', '峨蔓镇', 60),
(14061, 19, 14048, '三都镇', '三都镇', 65),
(14062, 19, 14048, '王五镇', '王五镇', 70),
(14063, 19, 14048, '白马井镇', '白马井镇', 75),
(14064, 19, 14048, '中和镇', '中和镇', 80),
(14065, 19, 14048, '排浦镇', '排浦镇', 85),
(14066, 19, 14048, '东成镇', '东成镇', 90),
(14067, 19, 14048, '新州镇', '新州镇', 95),
(14068, 19, 14048, '洋浦经济开发区', '洋浦经济开发区', 100),
(14069, 19, 14048, '西培农场', '西培农场', 105),
(14070, 19, 14048, '西联农场', '西联农场', 110),
(14071, 19, 14048, '蓝洋农场', '蓝洋农场', 115),
(14072, 19, 14048, '八一农场', '八一农场', 120),
(14073, 19, 14048, '西华农场', '西华农场', 125),
(14074, 19, 14048, '西庆农场', '西庆农场', 130),
(14075, 19, 14048, '西流农场', '西流农场', 135),
(14076, 19, 14048, '新盈农场', '新盈农场', 140),
(14077, 19, 14048, '龙山农场', '龙山农场', 145),
(14078, 19, 14048, '红岭农场', '红岭农场', 150),
(14079, 19, 14042, '琼海市', '琼海市', 15),
(14080, 19, 14079, '嘉积镇', '嘉积镇', 5),
(14081, 19, 14079, '万泉镇', '万泉镇', 10),
(14082, 19, 14079, '石壁镇', '石壁镇', 15),
(14083, 19, 14079, '中原镇', '中原镇', 20),
(14084, 19, 14079, '博鳌镇', '博鳌镇', 25),
(14085, 19, 14079, '阳江镇', '阳江镇', 30),
(14086, 19, 14079, '龙江镇', '龙江镇', 35),
(14087, 19, 14079, '潭门镇', '潭门镇', 40),
(14088, 19, 14079, '塔洋镇', '塔洋镇', 45),
(14089, 19, 14079, '长坡镇', '长坡镇', 50),
(14090, 19, 14079, '大路镇', '大路镇', 55),
(14091, 19, 14079, '会山镇', '会山镇', 60),
(14092, 19, 14079, '彬村山华侨农场', '彬村山华侨农场', 65),
(14093, 19, 14079, '东太农场', '东太农场', 70),
(14094, 19, 14079, '东红农场', '东红农场', 75),
(14095, 19, 14079, '东升农场', '东升农场', 80),
(14096, 19, 14079, '南俸农场', '南俸农场', 85),
(14097, 19, 14042, '万宁市', '万宁市', 20),
(14098, 19, 14097, '万城镇', '万城镇', 5),
(14099, 19, 14097, '龙滚镇', '龙滚镇', 10),
(14100, 19, 14097, '和乐镇', '和乐镇', 15),
(14101, 19, 14097, '后安镇', '后安镇', 20),
(14102, 19, 14097, '大茂镇', '大茂镇', 25),
(14103, 19, 14097, '东澳镇', '东澳镇', 30),
(14104, 19, 14097, '礼纪镇', '礼纪镇', 35),
(14105, 19, 14097, '长丰镇', '长丰镇', 40),
(14106, 19, 14097, '山根镇', '山根镇', 45),
(14107, 19, 14097, '北大镇', '北大镇', 50),
(14108, 19, 14097, '南桥镇', '南桥镇', 55),
(14109, 19, 14097, '三更罗镇', '三更罗镇', 60),
(14110, 19, 14097, '六连林场', '六连林场', 65),
(14111, 19, 14097, '东兴农场', '东兴农场', 70),
(14112, 19, 14097, '东和农场', '东和农场', 75),
(14113, 19, 14097, '新中农场', '新中农场', 80),
(14114, 19, 14097, '兴隆华侨农场', '兴隆华侨农场', 85),
(14115, 19, 14042, '东方市', '东方市', 25),
(14116, 19, 14115, '八所镇', '八所镇', 5),
(14117, 19, 14115, '东河镇', '东河镇', 10),
(14118, 19, 14115, '大田镇', '大田镇', 15),
(14119, 19, 14115, '感城镇', '感城镇', 20),
(14120, 19, 14115, '板桥镇', '板桥镇', 25),
(14121, 19, 14115, '三家镇', '三家镇', 30),
(14122, 19, 14115, '四更镇', '四更镇', 35),
(14123, 19, 14115, '新龙镇', '新龙镇', 40),
(14124, 19, 14115, '天安乡', '天安乡', 45),
(14125, 19, 14115, '江边乡', '江边乡', 50),
(14126, 19, 14115, '广坝农场', '广坝农场', 55),
(14127, 19, 14115, '东方华侨农场', '东方华侨农场', 60),
(14128, 19, 14042, '三亚市', '三亚市', 30),
(14129, 19, 14128, '崖城镇', '崖城镇', 5),
(14130, 19, 14128, '海棠湾镇', '海棠湾镇', 10),
(14131, 19, 14128, '吉阳镇', '吉阳镇', 15),
(14132, 19, 14128, '凤凰镇', '凤凰镇', 20),
(14133, 19, 14128, '天涯镇', '天涯镇', 25),
(14134, 19, 14128, '育才镇', '育才镇', 30),
(14135, 19, 14128, '河西区', '河西区', 35),
(14136, 19, 14128, '河东区', '河东区', 40),
(14137, 19, 14128, '南田农场', '南田农场', 45),
(14138, 19, 14128, '南新农场', '南新农场', 50),
(14139, 19, 14128, '南岛农场', '南岛农场', 55),
(14140, 19, 14128, '立才农场', '立才农场', 60),
(14141, 19, 14128, '南滨农场', '南滨农场', 65),
(14142, 19, 14042, '文昌市', '文昌市', 35),
(14143, 19, 14142, '文城镇', '文城镇', 5),
(14144, 19, 14142, '重兴镇', '重兴镇', 10),
(14145, 19, 14142, '蓬莱镇', '蓬莱镇', 15),
(14146, 19, 14142, '会文镇', '会文镇', 20),
(14147, 19, 14142, '东路镇', '东路镇', 25),
(14148, 19, 14142, '潭牛镇', '潭牛镇', 30),
(14149, 19, 14142, '东阁镇', '东阁镇', 35),
(14150, 19, 14142, '文教镇', '文教镇', 40),
(14151, 19, 14142, '东郊镇', '东郊镇', 45),
(14152, 19, 14142, '龙楼镇', '龙楼镇', 50),
(14153, 19, 14142, '昌洒镇', '昌洒镇', 55),
(14154, 19, 14142, '翁田镇', '翁田镇', 60),
(14155, 19, 14142, '抱罗镇', '抱罗镇', 65),
(14156, 19, 14142, '冯坡镇', '冯坡镇', 70),
(14157, 19, 14142, '锦山镇', '锦山镇', 75),
(14158, 19, 14142, '铺前镇', '铺前镇', 80),
(14159, 19, 14142, '公坡镇', '公坡镇', 85),
(14160, 19, 14142, '迈号镇', '迈号镇', 90),
(14161, 19, 14142, '清谰镇', '清谰镇', 95),
(14162, 19, 14142, '南阳镇', '南阳镇', 100),
(14163, 19, 14142, '新桥镇', '新桥镇', 105),
(14164, 19, 14142, '头苑镇', '头苑镇', 110),
(14165, 19, 14142, '宝芳乡', '宝芳乡', 115),
(14166, 19, 14142, '龙马乡', '龙马乡', 120),
(14167, 19, 14142, '湖山乡', '湖山乡', 125),
(14168, 19, 14142, '东路农场', '东路农场', 130),
(14169, 19, 14142, '南阳农场', '南阳农场', 135),
(14170, 19, 14142, '罗豆农场', '罗豆农场', 140),
(14171, 19, 14142, '橡胶研究所', '橡胶研究所', 145),
(14172, 19, 14042, '五指山市', '五指山市', 40),
(14173, 19, 14172, '通什镇', '通什镇', 5),
(14174, 19, 14172, '南圣镇', '南圣镇', 10),
(14175, 19, 14172, '毛阳镇', '毛阳镇', 15),
(14176, 19, 14172, '番阳镇', '番阳镇', 20),
(14177, 19, 14172, '畅好乡', '畅好乡', 25),
(14178, 19, 14172, '毛道乡', '毛道乡', 30),
(14179, 19, 14172, '水满乡', '水满乡', 35),
(14180, 19, 14172, '畅好农场', '畅好农场', 40),
(14181, 19, 14042, '临高县', '临高县', 45),
(14182, 19, 14181, '城区', '城区', 5),
(14183, 19, 14181, '临城镇', '临城镇', 10),
(14184, 19, 14181, '波莲镇', '波莲镇', 15),
(14185, 19, 14181, '东英镇', '东英镇', 20),
(14186, 19, 14181, '博厚镇', '博厚镇', 25),
(14187, 19, 14181, '皇桐镇', '皇桐镇', 30),
(14188, 19, 14181, '多文镇', '多文镇', 35),
(14189, 19, 14181, '和舍镇', '和舍镇', 40),
(14190, 19, 14181, '南宝镇', '南宝镇', 45),
(14191, 19, 14181, '新盈镇', '新盈镇', 50),
(14192, 19, 14181, '调楼镇', '调楼镇', 55),
(14193, 19, 14181, '加来镇', '加来镇', 60),
(14194, 19, 14181, '红华农场', '红华农场', 65),
(14195, 19, 14181, '加来农场', '加来农场', 70),
(14196, 19, 14042, '澄迈县', '澄迈县', 50),
(14197, 19, 14196, '城区', '城区', 5),
(14198, 19, 14196, '金江镇', '金江镇', 10),
(14199, 19, 14196, '老城镇', '老城镇', 15),
(14200, 19, 14196, '瑞溪镇', '瑞溪镇', 20),
(14201, 19, 14196, '永发镇', '永发镇', 25),
(14202, 19, 14196, '加乐镇', '加乐镇', 30),
(14203, 19, 14196, '文儒镇', '文儒镇', 35),
(14204, 19, 14196, '中兴镇', '中兴镇', 40),
(14205, 19, 14196, '仁兴镇', '仁兴镇', 45),
(14206, 19, 14196, '福山镇', '福山镇', 50);
INSERT INTO `qinggan_opt` (`id`, `group_id`, `parent_id`, `title`, `val`, `taxis`) VALUES
(14207, 19, 14196, '桥头镇', '桥头镇', 55),
(14208, 19, 14196, '大丰镇', '大丰镇', 60),
(14209, 19, 14196, '红光农场', '红光农场', 65),
(14210, 19, 14196, '西达农场', '西达农场', 70),
(14211, 19, 14196, '金安农场', '金安农场', 75),
(14212, 19, 14042, '定安县', '定安县', 55),
(14213, 19, 14212, '黄竹镇', '黄竹镇', 5),
(14214, 19, 14212, '城区', '城区', 10),
(14215, 19, 14212, '定城镇', '定城镇', 15),
(14216, 19, 14212, '新竹镇', '新竹镇', 20),
(14217, 19, 14212, '龙湖镇', '龙湖镇', 25),
(14218, 19, 14212, '雷鸣镇', '雷鸣镇', 30),
(14219, 19, 14212, '龙门镇', '龙门镇', 35),
(14220, 19, 14212, '龙河镇', '龙河镇', 40),
(14221, 19, 14212, '岭口镇', '岭口镇', 45),
(14222, 19, 14212, '翰林镇', '翰林镇', 50),
(14223, 19, 14212, '富文镇', '富文镇', 55),
(14224, 19, 14212, '金鸡岭农场', '金鸡岭农场', 60),
(14225, 19, 14212, '中瑞农场', '中瑞农场', 65),
(14226, 19, 14212, '南海农场', '南海农场', 70),
(14227, 19, 14042, '屯昌县', '屯昌县', 60),
(14228, 19, 14227, '县城内', '县城内', 5),
(14229, 19, 14227, '屯城镇', '屯城镇', 10),
(14230, 19, 14227, '新兴镇', '新兴镇', 15),
(14231, 19, 14227, '枫木镇', '枫木镇', 20),
(14232, 19, 14227, '乌坡镇', '乌坡镇', 25),
(14233, 19, 14227, '南吕镇', '南吕镇', 30),
(14234, 19, 14227, '南坤镇', '南坤镇', 35),
(14235, 19, 14227, '中建农场', '中建农场', 40),
(14236, 19, 14227, '坡心镇', '坡心镇', 45),
(14237, 19, 14227, '中坤农场', '中坤农场', 50),
(14238, 19, 14227, '西昌镇', '西昌镇', 55),
(14239, 19, 14042, '昌江县', '昌江县', 65),
(14240, 19, 14239, '红林农场', '红林农场', 5),
(14241, 19, 14239, '城区', '城区', 10),
(14242, 19, 14239, '石碌镇', '石碌镇', 15),
(14243, 19, 14239, '叉河镇', '叉河镇', 20),
(14244, 19, 14239, '十月田镇', '十月田镇', 25),
(14245, 19, 14239, '乌烈镇', '乌烈镇', 30),
(14246, 19, 14239, '昌化镇', '昌化镇', 35),
(14247, 19, 14239, '海尾镇', '海尾镇', 40),
(14248, 19, 14239, '七叉镇', '七叉镇', 45),
(14249, 19, 14239, '王下乡', '王下乡', 50),
(14250, 19, 14239, '海南矿业公司', '海南矿业公司', 55),
(14251, 19, 14239, '霸王岭林场', '霸王岭林场', 60),
(14252, 19, 14042, '白沙县', '白沙县', 70),
(14253, 19, 14252, '南开乡', '南开乡', 5),
(14254, 19, 14252, '阜龙乡', '阜龙乡', 10),
(14255, 19, 14252, '青松乡', '青松乡', 15),
(14256, 19, 14252, '金波乡', '金波乡', 20),
(14257, 19, 14252, '荣邦乡', '荣邦乡', 25),
(14258, 19, 14252, '城区', '城区', 30),
(14259, 19, 14252, '白沙农场', '白沙农场', 35),
(14260, 19, 14252, '牙叉镇', '牙叉镇', 40),
(14261, 19, 14252, '龙江农场', '龙江农场', 45),
(14262, 19, 14252, '七坊镇', '七坊镇', 50),
(14263, 19, 14252, '邦溪农场', '邦溪农场', 55),
(14264, 19, 14252, '邦溪镇', '邦溪镇', 60),
(14265, 19, 14252, '打安镇', '打安镇', 65),
(14266, 19, 14252, '细水乡', '细水乡', 70),
(14267, 19, 14252, '元门乡', '元门乡', 75),
(14268, 19, 14042, '琼中县', '琼中县', 75),
(14269, 19, 14268, '吊罗山乡', '吊罗山乡', 5),
(14270, 19, 14268, '黎母山林业公司', '黎母山林业公司', 10),
(14271, 19, 14268, '阳江农场', '阳江农场', 15),
(14272, 19, 14268, '乌石农场', '乌石农场', 20),
(14273, 19, 14268, '加钗农场', '加钗农场', 25),
(14274, 19, 14268, '长征农场', '长征农场', 30),
(14275, 19, 14268, '营根镇', '营根镇', 35),
(14276, 19, 14268, '湾岭镇', '湾岭镇', 40),
(14277, 19, 14268, '黎母山镇', '黎母山镇', 45),
(14278, 19, 14268, '和平镇', '和平镇', 50),
(14279, 19, 14268, '长征镇', '长征镇', 55),
(14280, 19, 14268, '红毛镇', '红毛镇', 60),
(14281, 19, 14268, '中平镇', '中平镇', 65),
(14282, 19, 14268, '上安乡', '上安乡', 70),
(14283, 19, 14268, '什运乡', '什运乡', 75),
(14284, 19, 14268, '城区', '城区', 80),
(14285, 19, 14042, '陵水县', '陵水县', 80),
(14286, 19, 14285, '吊罗山林业公司', '吊罗山林业公司', 5),
(14287, 19, 14285, '岭门农场', '岭门农场', 10),
(14288, 19, 14285, '南平农场', '南平农场', 15),
(14289, 19, 14285, '椰林镇', '椰林镇', 20),
(14290, 19, 14285, '光坡镇', '光坡镇', 25),
(14291, 19, 14285, '三才镇', '三才镇', 30),
(14292, 19, 14285, '英州镇', '英州镇', 35),
(14293, 19, 14285, '隆广镇', '隆广镇', 40),
(14294, 19, 14285, '文罗镇', '文罗镇', 45),
(14295, 19, 14285, '本号镇', '本号镇', 50),
(14296, 19, 14285, '新村镇', '新村镇', 55),
(14297, 19, 14285, '黎安镇', '黎安镇', 60),
(14298, 19, 14285, '提蒙乡', '提蒙乡', 65),
(14299, 19, 14285, '群英乡', '群英乡', 70),
(14300, 19, 14285, '城区', '城区', 75),
(14301, 19, 14042, '保亭县', '保亭县', 85),
(14302, 19, 14301, '保亭研究所', '保亭研究所', 5),
(14303, 19, 14301, '新星农场', '新星农场', 10),
(14304, 19, 14301, '金江农场', '金江农场', 15),
(14305, 19, 14301, '三道农场', '三道农场', 20),
(14306, 19, 14301, '保城镇', '保城镇', 25),
(14307, 19, 14301, '什玲镇', '什玲镇', 30),
(14308, 19, 14301, '加茂镇', '加茂镇', 35),
(14309, 19, 14301, '响水镇', '响水镇', 40),
(14310, 19, 14301, '新政镇', '新政镇', 45),
(14311, 19, 14301, '三道镇', '三道镇', 50),
(14312, 19, 14301, '六弓乡', '六弓乡', 55),
(14313, 19, 14301, '南林乡', '南林乡', 60),
(14314, 19, 14301, '毛感乡', '毛感乡', 65),
(14315, 19, 14042, '乐东县', '乐东县', 90),
(14316, 19, 14315, '尖峰岭林业公司', '尖峰岭林业公司', 5),
(14317, 19, 14315, '莺歌海盐场', '莺歌海盐场', 10),
(14318, 19, 14315, '山荣农场', '山荣农场', 15),
(14319, 19, 14315, '乐光农场', '乐光农场', 20),
(14320, 19, 14315, '抱由镇', '抱由镇', 25),
(14321, 19, 14315, '保国农场', '保国农场', 30),
(14322, 19, 14315, '万冲镇', '万冲镇', 35),
(14323, 19, 14315, '大安镇', '大安镇', 40),
(14324, 19, 14315, '志仲镇', '志仲镇', 45),
(14325, 19, 14315, '千家镇', '千家镇', 50),
(14326, 19, 14315, '九所镇', '九所镇', 55),
(14327, 19, 14315, '利国镇', '利国镇', 60),
(14328, 19, 14315, '黄流镇', '黄流镇', 65),
(14329, 19, 14315, '佛罗镇', '佛罗镇', 70),
(14330, 19, 14315, '尖峰镇', '尖峰镇', 75),
(14331, 19, 14315, '莺歌海镇', '莺歌海镇', 80),
(14332, 19, 14315, '城区', '城区', 85),
(14333, 19, 14042, '三沙市', '三沙市', 95),
(14334, 19, 14333, '中沙群岛', '中沙群岛', 5),
(14335, 19, 14333, '西沙群岛', '西沙群岛', 10),
(14336, 19, 14333, '南沙群岛', '南沙群岛', 15),
(14337, 19, 0, '贵州省', '贵州省', 120),
(14338, 19, 14337, '贵阳市', '贵阳市', 5),
(14339, 19, 14338, '南明区', '南明区', 5),
(14340, 19, 14338, '云岩区', '云岩区', 10),
(14341, 19, 14338, '花溪区', '花溪区', 15),
(14342, 19, 14338, '小河区', '小河区', 20),
(14343, 19, 14338, '白云区', '白云区', 25),
(14344, 19, 14338, '清镇市', '清镇市', 30),
(14345, 19, 14338, '开阳县', '开阳县', 35),
(14346, 19, 14338, '修文县', '修文县', 40),
(14347, 19, 14338, '息烽县', '息烽县', 45),
(14348, 19, 14338, '乌当区', '乌当区', 50),
(14349, 19, 14338, '观山湖区', '观山湖区', 55),
(14350, 19, 14337, '六盘水市', '六盘水市', 10),
(14351, 19, 14350, '盘县', '盘县', 5),
(14352, 19, 14350, '六枝特区', '六枝特区', 10),
(14353, 19, 14350, '水城县', '水城县', 15),
(14354, 19, 14350, '钟山区', '钟山区', 20),
(14355, 19, 14337, '遵义市', '遵义市', 15),
(14356, 19, 14355, '红花岗区', '红花岗区', 5),
(14357, 19, 14355, '汇川区', '汇川区', 10),
(14358, 19, 14355, '赤水市', '赤水市', 15),
(14359, 19, 14355, '仁怀市', '仁怀市', 20),
(14360, 19, 14355, '遵义县', '遵义县', 25),
(14361, 19, 14355, '桐梓县', '桐梓县', 30),
(14362, 19, 14355, '绥阳县', '绥阳县', 35),
(14363, 19, 14355, '习水县', '习水县', 40),
(14364, 19, 14355, '凤冈县', '凤冈县', 45),
(14365, 19, 14355, '正安县', '正安县', 50),
(14366, 19, 14355, '湄潭县', '湄潭县', 55),
(14367, 19, 14355, '余庆县', '余庆县', 60),
(14368, 19, 14355, '道真县', '道真县', 65),
(14369, 19, 14355, '务川县', '务川县', 70),
(14370, 19, 14337, '铜仁市', '铜仁市', 20),
(14371, 19, 14370, '碧江区', '碧江区', 5),
(14372, 19, 14370, '德江县', '德江县', 10),
(14373, 19, 14370, '江口县', '江口县', 15),
(14374, 19, 14370, '思南县', '思南县', 20),
(14375, 19, 14370, '万山区', '万山区', 25),
(14376, 19, 14370, '石阡县', '石阡县', 30),
(14377, 19, 14370, '玉屏侗族自治县', '玉屏侗族自治县', 35),
(14378, 19, 14370, '松桃苗族自治县', '松桃苗族自治县', 40),
(14379, 19, 14370, '印江土家族苗族自治县', '印江土家族苗族自治县', 45),
(14380, 19, 14370, '沿河土家族自治县', '沿河土家族自治县', 50),
(14381, 19, 14337, '毕节市', '毕节市', 25),
(14382, 19, 14381, '七星关区', '七星关区', 5),
(14383, 19, 14381, '黔西县', '黔西县', 10),
(14384, 19, 14381, '大方县', '大方县', 15),
(14385, 19, 14381, '织金县', '织金县', 20),
(14386, 19, 14381, '金沙县', '金沙县', 25),
(14387, 19, 14381, '赫章县', '赫章县', 30),
(14388, 19, 14381, '纳雍县', '纳雍县', 35),
(14389, 19, 14381, '威宁彝族回族苗族自治县', '威宁彝族回族苗族自治县', 40),
(14390, 19, 14337, '安顺市', '安顺市', 30),
(14391, 19, 14390, '西秀区', '西秀区', 5),
(14392, 19, 14390, '普定县', '普定县', 10),
(14393, 19, 14390, '平坝县', '平坝县', 15),
(14394, 19, 14390, '镇宁布依族苗族自治县', '镇宁布依族苗族自治县', 20),
(14395, 19, 14390, '关岭布依族苗族自治县', '关岭布依族苗族自治县', 25),
(14396, 19, 14390, '紫云苗族布依族自治县', '紫云苗族布依族自治县', 30),
(14397, 19, 14337, '黔西南州', '黔西南州', 35),
(14398, 19, 14397, '兴义市', '兴义市', 5),
(14399, 19, 14397, '望谟县', '望谟县', 10),
(14400, 19, 14397, '兴仁县', '兴仁县', 15),
(14401, 19, 14397, '普安县', '普安县', 20),
(14402, 19, 14397, '册亨县', '册亨县', 25),
(14403, 19, 14397, '晴隆县', '晴隆县', 30),
(14404, 19, 14397, '贞丰县', '贞丰县', 35),
(14405, 19, 14397, '安龙县', '安龙县', 40),
(14406, 19, 14337, '黔东南州', '黔东南州', 40),
(14407, 19, 14406, '凯里市', '凯里市', 5),
(14408, 19, 14406, '施秉市', '施秉市', 10),
(14409, 19, 14406, '从江县', '从江县', 15),
(14410, 19, 14406, '锦屏县', '锦屏县', 20),
(14411, 19, 14406, '镇远县', '镇远县', 25),
(14412, 19, 14406, '麻江县', '麻江县', 30),
(14413, 19, 14406, '台江县', '台江县', 35),
(14414, 19, 14406, '天柱县', '天柱县', 40),
(14415, 19, 14406, '黄平县', '黄平县', 45),
(14416, 19, 14406, '榕江县', '榕江县', 50),
(14417, 19, 14406, '剑河县', '剑河县', 55),
(14418, 19, 14406, '三穗县', '三穗县', 60),
(14419, 19, 14406, '雷山县', '雷山县', 65),
(14420, 19, 14406, '黎平县', '黎平县', 70),
(14421, 19, 14406, '岑巩县', '岑巩县', 75),
(14422, 19, 14406, '丹寨县', '丹寨县', 80),
(14423, 19, 14337, '黔南州', '黔南州', 45),
(14424, 19, 14423, '都匀市', '都匀市', 5),
(14425, 19, 14423, '福泉市', '福泉市', 10),
(14426, 19, 14423, '贵定县', '贵定县', 15),
(14427, 19, 14423, '惠水县', '惠水县', 20),
(14428, 19, 14423, '罗甸县', '罗甸县', 25),
(14429, 19, 14423, '瓮安县', '瓮安县', 30),
(14430, 19, 14423, '荔波县', '荔波县', 35),
(14431, 19, 14423, '龙里县', '龙里县', 40),
(14432, 19, 14423, '平塘县', '平塘县', 45),
(14433, 19, 14423, '长顺县', '长顺县', 50),
(14434, 19, 14423, '独山县', '独山县', 55),
(14435, 19, 14423, '三都县', '三都县', 60),
(14436, 19, 0, '云南省', '云南省', 125),
(14437, 19, 14436, '昆明市', '昆明市', 5),
(14438, 19, 14437, '盘龙区', '盘龙区', 5),
(14439, 19, 14437, '五华区', '五华区', 10),
(14440, 19, 14437, '西山区', '西山区', 15),
(14441, 19, 14437, '官渡区', '官渡区', 20),
(14442, 19, 14437, '呈贡区', '呈贡区', 25),
(14443, 19, 14437, '东川区', '东川区', 30),
(14444, 19, 14437, '安宁市', '安宁市', 35),
(14445, 19, 14437, '富民县', '富民县', 40),
(14446, 19, 14437, '嵩明县', '嵩明县', 45),
(14447, 19, 14437, '晋宁县', '晋宁县', 50),
(14448, 19, 14437, '宜良县', '宜良县', 55),
(14449, 19, 14437, '禄劝县', '禄劝县', 60),
(14450, 19, 14437, '石林县', '石林县', 65),
(14451, 19, 14437, '寻甸县', '寻甸县', 70),
(14452, 19, 14436, '曲靖市', '曲靖市', 10),
(14453, 19, 14452, '麒麟区', '麒麟区', 5),
(14454, 19, 14452, '马龙县', '马龙县', 10),
(14455, 19, 14452, '宣威市', '宣威市', 15),
(14456, 19, 14452, '富源县', '富源县', 20),
(14457, 19, 14452, '会泽县', '会泽县', 25),
(14458, 19, 14452, '陆良县', '陆良县', 30),
(14459, 19, 14452, '师宗县', '师宗县', 35),
(14460, 19, 14452, '罗平县', '罗平县', 40),
(14461, 19, 14452, '沾益县', '沾益县', 45),
(14462, 19, 14436, '玉溪市', '玉溪市', 15),
(14463, 19, 14462, '红塔区', '红塔区', 5),
(14464, 19, 14462, '华宁县', '华宁县', 10),
(14465, 19, 14462, '澄江县', '澄江县', 15),
(14466, 19, 14462, '易门县', '易门县', 20),
(14467, 19, 14462, '通海县', '通海县', 25),
(14468, 19, 14462, '江川县', '江川县', 30),
(14469, 19, 14462, '元江县', '元江县', 35),
(14470, 19, 14462, '新平县', '新平县', 40),
(14471, 19, 14462, '峨山县', '峨山县', 45),
(14472, 19, 14436, '昭通市', '昭通市', 20),
(14473, 19, 14472, '鲁甸县', '鲁甸县', 5),
(14474, 19, 14472, '绥江县', '绥江县', 10),
(14475, 19, 14472, '昭阳区', '昭阳区', 15),
(14476, 19, 14472, '镇雄县', '镇雄县', 20),
(14477, 19, 14472, '永善县', '永善县', 25),
(14478, 19, 14472, '大关县', '大关县', 30),
(14479, 19, 14472, '盐津县', '盐津县', 35),
(14480, 19, 14472, '彝良县', '彝良县', 40),
(14481, 19, 14472, '水富县', '水富县', 45),
(14482, 19, 14472, '巧家县', '巧家县', 50),
(14483, 19, 14472, '威信县', '威信县', 55),
(14484, 19, 14436, '普洱市', '普洱市', 25),
(14485, 19, 14484, '孟连县', '孟连县', 5),
(14486, 19, 14484, '思茅区', '思茅区', 10),
(14487, 19, 14484, '宁洱县', '宁洱县', 15),
(14488, 19, 14484, '景东县', '景东县', 20),
(14489, 19, 14484, '镇沅县', '镇沅县', 25),
(14490, 19, 14484, '景谷县', '景谷县', 30),
(14491, 19, 14484, '墨江县', '墨江县', 35),
(14492, 19, 14484, '澜沧县', '澜沧县', 40),
(14493, 19, 14484, '西盟县', '西盟县', 45),
(14494, 19, 14484, '江城县', '江城县', 50),
(14495, 19, 14436, '临沧市', '临沧市', 30),
(14496, 19, 14495, '双江县', '双江县', 5),
(14497, 19, 14495, '沧源县', '沧源县', 10),
(14498, 19, 14495, '临翔区', '临翔区', 15),
(14499, 19, 14495, '镇康县', '镇康县', 20),
(14500, 19, 14495, '凤庆县', '凤庆县', 25),
(14501, 19, 14495, '云县', '云县', 30),
(14502, 19, 14495, '永德县', '永德县', 35),
(14503, 19, 14495, '耿马县', '耿马县', 40),
(14504, 19, 14436, '保山市', '保山市', 35),
(14505, 19, 14504, '隆阳区', '隆阳区', 5),
(14506, 19, 14504, '施甸县', '施甸县', 10),
(14507, 19, 14504, '昌宁县', '昌宁县', 15),
(14508, 19, 14504, '龙陵县', '龙陵县', 20),
(14509, 19, 14504, '腾冲县', '腾冲县', 25),
(14510, 19, 14436, '丽江市', '丽江市', 40),
(14511, 19, 14510, '玉龙县', '玉龙县', 5),
(14512, 19, 14510, '华坪县', '华坪县', 10),
(14513, 19, 14510, '永胜县', '永胜县', 15),
(14514, 19, 14510, '宁蒗县', '宁蒗县', 20),
(14515, 19, 14510, '古城区', '古城区', 25),
(14516, 19, 14436, '文山州', '文山州', 45),
(14517, 19, 14516, '文山市', '文山市', 5),
(14518, 19, 14516, '麻栗坡县', '麻栗坡县', 10),
(14519, 19, 14516, '砚山县', '砚山县', 15),
(14520, 19, 14516, '广南县', '广南县', 20),
(14521, 19, 14516, '马关县', '马关县', 25),
(14522, 19, 14516, '富宁县', '富宁县', 30),
(14523, 19, 14516, '西畴县', '西畴县', 35),
(14524, 19, 14516, '丘北县', '丘北县', 40),
(14525, 19, 14436, '红河州', '红河州', 50),
(14526, 19, 14525, '个旧市', '个旧市', 5),
(14527, 19, 14525, '开远市', '开远市', 10),
(14528, 19, 14525, '弥勒县', '弥勒县', 15),
(14529, 19, 14525, '红河县', '红河县', 20),
(14530, 19, 14525, '绿春县', '绿春县', 25),
(14531, 19, 14525, '蒙自市', '蒙自市', 30),
(14532, 19, 14525, '泸西县', '泸西县', 35),
(14533, 19, 14525, '建水县', '建水县', 40),
(14534, 19, 14525, '元阳县', '元阳县', 45),
(14535, 19, 14525, '石屏县', '石屏县', 50),
(14536, 19, 14525, '金平县', '金平县', 55),
(14537, 19, 14525, '屏边县', '屏边县', 60),
(14538, 19, 14525, '河口县', '河口县', 65),
(14539, 19, 14436, '西双版纳州', '西双版纳州', 55),
(14540, 19, 14539, '景洪市', '景洪市', 5),
(14541, 19, 14539, '勐海县', '勐海县', 10),
(14542, 19, 14539, '勐腊县', '勐腊县', 15),
(14543, 19, 14436, '楚雄州', '楚雄州', 60),
(14544, 19, 14543, '元谋县', '元谋县', 5),
(14545, 19, 14543, '南华县', '南华县', 10),
(14546, 19, 14543, '牟定县', '牟定县', 15),
(14547, 19, 14543, '武定县', '武定县', 20),
(14548, 19, 14543, '大姚县', '大姚县', 25),
(14549, 19, 14543, '双柏县', '双柏县', 30),
(14550, 19, 14543, '禄丰县', '禄丰县', 35),
(14551, 19, 14543, '永仁县', '永仁县', 40),
(14552, 19, 14543, '姚安县', '姚安县', 45),
(14553, 19, 14543, '楚雄市', '楚雄市', 50),
(14554, 19, 14436, '大理州', '大理州', 65),
(14555, 19, 14554, '剑川县', '剑川县', 5),
(14556, 19, 14554, '弥渡县', '弥渡县', 10),
(14557, 19, 14554, '云龙县', '云龙县', 15),
(14558, 19, 14554, '洱源县', '洱源县', 20),
(14559, 19, 14554, '鹤庆县', '鹤庆县', 25),
(14560, 19, 14554, '宾川县', '宾川县', 30),
(14561, 19, 14554, '祥云县', '祥云县', 35),
(14562, 19, 14554, '永平县', '永平县', 40),
(14563, 19, 14554, '巍山县', '巍山县', 45),
(14564, 19, 14554, '漾濞县', '漾濞县', 50),
(14565, 19, 14554, '南涧县', '南涧县', 55),
(14566, 19, 14554, '大理市', '大理市', 60),
(14567, 19, 14436, '德宏州', '德宏州', 70),
(14568, 19, 14567, '芒市', '芒市', 5),
(14569, 19, 14567, '瑞丽市', '瑞丽市', 10),
(14570, 19, 14567, '盈江县', '盈江县', 15),
(14571, 19, 14567, '梁河县', '梁河县', 20),
(14572, 19, 14567, '陇川县', '陇川县', 25),
(14573, 19, 14436, '怒江州', '怒江州', 75),
(14574, 19, 14573, '泸水县', '泸水县', 5),
(14575, 19, 14573, '福贡县', '福贡县', 10),
(14576, 19, 14573, '兰坪县', '兰坪县', 15),
(14577, 19, 14573, '贡山县', '贡山县', 20),
(14578, 19, 14436, '迪庆州', '迪庆州', 80),
(14579, 19, 14578, '香格里拉县', '香格里拉县', 5),
(14580, 19, 14578, '德钦县', '德钦县', 10),
(14581, 19, 14578, '维西县', '维西县', 15),
(14582, 19, 0, '西藏自治区', '西藏自治区', 130),
(14583, 19, 14582, '拉萨市', '拉萨市', 5),
(14584, 19, 14583, '城关区', '城关区', 5),
(14585, 19, 14583, '林周县', '林周县', 10),
(14586, 19, 14583, '当雄县', '当雄县', 15),
(14587, 19, 14583, '尼木县', '尼木县', 20),
(14588, 19, 14583, '曲水县', '曲水县', 25),
(14589, 19, 14583, '堆龙德庆县', '堆龙德庆县', 30),
(14590, 19, 14583, '达孜县', '达孜县', 35),
(14591, 19, 14583, '墨竹工卡县', '墨竹工卡县', 40),
(14592, 19, 14582, '那曲地区', '那曲地区', 10),
(14593, 19, 14592, '索县', '索县', 5),
(14594, 19, 14592, '那曲县', '那曲县', 10),
(14595, 19, 14592, '嘉黎县', '嘉黎县', 15),
(14596, 19, 14592, '比如县', '比如县', 20),
(14597, 19, 14592, '聂荣县', '聂荣县', 25),
(14598, 19, 14592, '安多县', '安多县', 30),
(14599, 19, 14592, '申扎县', '申扎县', 35),
(14600, 19, 14592, '班戈县', '班戈县', 40),
(14601, 19, 14592, '巴青县', '巴青县', 45),
(14602, 19, 14592, '尼玛县', '尼玛县', 50),
(14603, 19, 14582, '山南地区', '山南地区', 15),
(14604, 19, 14603, '贡嘎县', '贡嘎县', 5),
(14605, 19, 14603, '扎囊县', '扎囊县', 10),
(14606, 19, 14603, '乃东县', '乃东县', 15),
(14607, 19, 14603, '桑日县', '桑日县', 20),
(14608, 19, 14603, '琼结县', '琼结县', 25),
(14609, 19, 14603, '曲松县', '曲松县', 30),
(14610, 19, 14603, '措美县', '措美县', 35),
(14611, 19, 14603, '洛扎县', '洛扎县', 40),
(14612, 19, 14603, '加查县', '加查县', 45),
(14613, 19, 14603, '隆子县', '隆子县', 50),
(14614, 19, 14603, '错那县', '错那县', 55),
(14615, 19, 14603, '浪卡子县', '浪卡子县', 60),
(14616, 19, 14582, '昌都地区', '昌都地区', 20),
(14617, 19, 14616, '昌都县', '昌都县', 5),
(14618, 19, 14616, '江达县', '江达县', 10),
(14619, 19, 14616, '贡觉县', '贡觉县', 15),
(14620, 19, 14616, '类乌齐县', '类乌齐县', 20),
(14621, 19, 14616, '丁青县', '丁青县', 25),
(14622, 19, 14616, '察雅县', '察雅县', 30),
(14623, 19, 14616, '八宿县', '八宿县', 35),
(14624, 19, 14616, '左贡县', '左贡县', 40),
(14625, 19, 14616, '芒康县', '芒康县', 45),
(14626, 19, 14616, '洛隆县', '洛隆县', 50),
(14627, 19, 14616, '边坝县', '边坝县', 55),
(14628, 19, 14582, '日喀则地区', '日喀则地区', 25),
(14629, 19, 14628, '聂拉木县', '聂拉木县', 5),
(14630, 19, 14628, '昂仁县', '昂仁县', 10),
(14631, 19, 14628, '日喀则市', '日喀则市', 15),
(14632, 19, 14628, '南木林县', '南木林县', 20),
(14633, 19, 14628, '江孜县', '江孜县', 25),
(14634, 19, 14628, '定日县', '定日县', 30),
(14635, 19, 14628, '萨迦县　', '萨迦县　', 35),
(14636, 19, 14628, '拉孜县', '拉孜县', 40),
(14637, 19, 14628, '谢通门县', '谢通门县', 45),
(14638, 19, 14628, '白朗县', '白朗县', 50),
(14639, 19, 14628, '仁布县', '仁布县', 55),
(14640, 19, 14628, '康马县', '康马县', 60),
(14641, 19, 14628, '定结县', '定结县', 65),
(14642, 19, 14628, '仲巴县', '仲巴县', 70),
(14643, 19, 14628, '亚东县', '亚东县', 75),
(14644, 19, 14628, '吉隆县', '吉隆县', 80),
(14645, 19, 14628, '萨嘎县', '萨嘎县', 85),
(14646, 19, 14628, '岗巴县', '岗巴县', 90),
(14647, 19, 14582, '阿里地区', '阿里地区', 30),
(14648, 19, 14647, '噶尔县', '噶尔县', 5),
(14649, 19, 14647, '普兰县', '普兰县', 10),
(14650, 19, 14647, '札达县　', '札达县　', 15),
(14651, 19, 14647, '日土县', '日土县', 20),
(14652, 19, 14647, '革吉县', '革吉县', 25),
(14653, 19, 14647, '改则县', '改则县', 30),
(14654, 19, 14647, '措勤县', '措勤县', 35),
(14655, 19, 14582, '林芝地区', '林芝地区', 35),
(14656, 19, 14655, '林芝县', '林芝县', 5),
(14657, 19, 14655, '工布江达县', '工布江达县', 10),
(14658, 19, 14655, '米林县', '米林县', 15),
(14659, 19, 14655, '墨脱县', '墨脱县', 20),
(14660, 19, 14655, '波密县', '波密县', 25),
(14661, 19, 14655, '察隅县', '察隅县', 30),
(14662, 19, 14655, '朗县', '朗县', 35),
(14663, 19, 0, '陕西省', '陕西省', 135),
(14664, 19, 14663, '西安市', '西安市', 5),
(14665, 19, 14664, '新城区', '新城区', 5),
(14666, 19, 14664, '雁塔区', '雁塔区', 10),
(14667, 19, 14664, '未央区', '未央区', 15),
(14668, 19, 14664, '长安区', '长安区', 20),
(14669, 19, 14664, '灞桥区', '灞桥区', 25),
(14670, 19, 14664, '碑林区', '碑林区', 30),
(14671, 19, 14664, '莲湖区', '莲湖区', 35),
(14672, 19, 14664, '临潼区', '临潼区', 40),
(14673, 19, 14664, '阎良区', '阎良区', 45),
(14674, 19, 14664, '杨凌农业示范区', '杨凌农业示范区', 50),
(14675, 19, 14664, '西安武警工程学院', '西安武警工程学院', 55),
(14676, 19, 14664, '高陵县', '高陵县', 60),
(14677, 19, 14664, '蓝田县', '蓝田县', 65),
(14678, 19, 14664, '户县', '户县', 70),
(14679, 19, 14664, '周至县', '周至县', 75),
(14680, 19, 14663, '铜川市', '铜川市', 10),
(14681, 19, 14680, '印台区', '印台区', 5),
(14682, 19, 14680, '宜君县', '宜君县', 10),
(14683, 19, 14680, '王益区', '王益区', 15),
(14684, 19, 14680, '耀州区', '耀州区', 20),
(14685, 19, 14663, '宝鸡市', '宝鸡市', 15),
(14686, 19, 14685, '渭滨区', '渭滨区', 5),
(14687, 19, 14685, '金台区', '金台区', 10),
(14688, 19, 14685, '岐山县', '岐山县', 15),
(14689, 19, 14685, '太白县', '太白县', 20),
(14690, 19, 14685, '凤翔县', '凤翔县', 25),
(14691, 19, 14685, '陇县', '陇县', 30),
(14692, 19, 14685, '麟游县', '麟游县', 35),
(14693, 19, 14685, '千阳县', '千阳县', 40),
(14694, 19, 14685, '扶风县', '扶风县', 45),
(14695, 19, 14685, '凤县', '凤县', 50),
(14696, 19, 14685, '眉县', '眉县', 55),
(14697, 19, 14685, '陈仓区', '陈仓区', 60),
(14698, 19, 14663, '咸阳市', '咸阳市', 20),
(14699, 19, 14698, '秦都区', '秦都区', 5),
(14700, 19, 14698, '渭城区', '渭城区', 10),
(14701, 19, 14698, '兴平市', '兴平市', 15),
(14702, 19, 14698, '礼泉县', '礼泉县', 20),
(14703, 19, 14698, '泾阳县', '泾阳县', 25),
(14704, 19, 14698, '永寿县', '永寿县', 30),
(14705, 19, 14698, '三原县', '三原县', 35),
(14706, 19, 14698, '彬县', '彬县', 40),
(14707, 19, 14698, '旬邑县', '旬邑县', 45),
(14708, 19, 14698, '长武县', '长武县', 50),
(14709, 19, 14698, '乾县', '乾县', 55),
(14710, 19, 14698, '武功县', '武功县', 60),
(14711, 19, 14698, '淳化县', '淳化县', 65),
(14712, 19, 14698, '杨陵区', '杨陵区', 70),
(14713, 19, 14663, '渭南市', '渭南市', 25),
(14714, 19, 14713, '韩城市', '韩城市', 5),
(14715, 19, 14713, '华阴市', '华阴市', 10),
(14716, 19, 14713, '蒲城县', '蒲城县', 15),
(14717, 19, 14713, '华县', '华县', 20),
(14718, 19, 14713, '潼关县', '潼关县', 25),
(14719, 19, 14713, '大荔县', '大荔县', 30),
(14720, 19, 14713, '澄城县', '澄城县', 35),
(14721, 19, 14713, '合阳县', '合阳县', 40),
(14722, 19, 14713, '白水县', '白水县', 45),
(14723, 19, 14713, '富平县', '富平县', 50),
(14724, 19, 14713, '临渭区', '临渭区', 55),
(14725, 19, 14663, '延安市', '延安市', 30),
(14726, 19, 14725, '宝塔区', '宝塔区', 5),
(14727, 19, 14725, '安塞县', '安塞县', 10),
(14728, 19, 14725, '洛川县', '洛川县', 15),
(14729, 19, 14725, '子长县', '子长县', 20),
(14730, 19, 14725, '黄陵县', '黄陵县', 25),
(14731, 19, 14725, '延长县', '延长县', 30),
(14732, 19, 14725, '宜川县', '宜川县', 35),
(14733, 19, 14725, '延川县', '延川县', 40),
(14734, 19, 14725, '甘泉县', '甘泉县', 45),
(14735, 19, 14725, '富县', '富县', 50),
(14736, 19, 14725, '志丹县', '志丹县', 55),
(14737, 19, 14725, '黄龙县', '黄龙县', 60),
(14738, 19, 14725, '吴起县', '吴起县', 65),
(14739, 19, 14663, '汉中市', '汉中市', 35),
(14740, 19, 14739, '汉台区', '汉台区', 5),
(14741, 19, 14739, '南郑县', '南郑县', 10),
(14742, 19, 14739, '城固县', '城固县', 15),
(14743, 19, 14739, '洋县', '洋县', 20),
(14744, 19, 14739, '佛坪县', '佛坪县', 25),
(14745, 19, 14739, '留坝县', '留坝县', 30),
(14746, 19, 14739, '镇巴县', '镇巴县', 35),
(14747, 19, 14739, '西乡县', '西乡县', 40),
(14748, 19, 14739, '勉县', '勉县', 45),
(14749, 19, 14739, '略阳县', '略阳县', 50),
(14750, 19, 14739, '宁强县', '宁强县', 55),
(14751, 19, 14663, '榆林市', '榆林市', 40),
(14752, 19, 14751, '清涧县', '清涧县', 5),
(14753, 19, 14751, '绥德县', '绥德县', 10),
(14754, 19, 14751, '佳县', '佳县', 15),
(14755, 19, 14751, '神木县', '神木县', 20),
(14756, 19, 14751, '府谷县', '府谷县', 25),
(14757, 19, 14751, '子洲县', '子洲县', 30),
(14758, 19, 14751, '横山县', '横山县', 35),
(14759, 19, 14751, '米脂县', '米脂县', 40),
(14760, 19, 14751, '吴堡县', '吴堡县', 45),
(14761, 19, 14751, '定边县', '定边县', 50),
(14762, 19, 14751, '榆阳区', '榆阳区', 55),
(14763, 19, 14751, '靖边县', '靖边县', 60),
(14764, 19, 14663, '商洛市', '商洛市', 45),
(14765, 19, 14764, '商州区', '商州区', 5),
(14766, 19, 14764, '镇安县', '镇安县', 10),
(14767, 19, 14764, '山阳县', '山阳县', 15),
(14768, 19, 14764, '洛南县', '洛南县', 20),
(14769, 19, 14764, '商南县', '商南县', 25),
(14770, 19, 14764, '丹凤县', '丹凤县', 30),
(14771, 19, 14764, '柞水县', '柞水县', 35),
(14772, 19, 14663, '安康市', '安康市', 50),
(14773, 19, 14772, '汉滨区', '汉滨区', 5),
(14774, 19, 14772, '紫阳县', '紫阳县', 10),
(14775, 19, 14772, '岚皋县', '岚皋县', 15),
(14776, 19, 14772, '旬阳县', '旬阳县', 20),
(14777, 19, 14772, '镇坪县', '镇坪县', 25),
(14778, 19, 14772, '平利县', '平利县', 30),
(14779, 19, 14772, '宁陕县', '宁陕县', 35),
(14780, 19, 14772, '汉阴县', '汉阴县', 40),
(14781, 19, 14772, '石泉县', '石泉县', 45),
(14782, 19, 14772, '白河县', '白河县', 50),
(14783, 19, 0, '甘肃省', '甘肃省', 140),
(14784, 19, 14783, '兰州市', '兰州市', 5),
(14785, 19, 14784, '七里河区', '七里河区', 5),
(14786, 19, 14784, '安宁区', '安宁区', 10),
(14787, 19, 14784, '城关区', '城关区', 15),
(14788, 19, 14784, '西固区', '西固区', 20),
(14789, 19, 14784, '红古区', '红古区', 25),
(14790, 19, 14784, '永登县', '永登县', 30),
(14791, 19, 14784, '榆中县', '榆中县', 35),
(14792, 19, 14784, '皋兰县', '皋兰县', 40),
(14793, 19, 14783, '金昌市', '金昌市', 10),
(14794, 19, 14793, '永昌县', '永昌县', 5),
(14795, 19, 14793, '金川区', '金川区', 10),
(14796, 19, 14783, '白银市', '白银市', 15),
(14797, 19, 14796, '白银区', '白银区', 5),
(14798, 19, 14796, '平川区', '平川区', 10),
(14799, 19, 14796, '靖远县', '靖远县', 15),
(14800, 19, 14796, '景泰县', '景泰县', 20),
(14801, 19, 14796, '会宁县', '会宁县', 25),
(14802, 19, 14783, '天水市', '天水市', 20),
(14803, 19, 14802, '麦积区', '麦积区', 5),
(14804, 19, 14802, '秦州区', '秦州区', 10),
(14805, 19, 14802, '甘谷县', '甘谷县', 15),
(14806, 19, 14802, '武山县', '武山县', 20),
(14807, 19, 14802, '清水县', '清水县', 25),
(14808, 19, 14802, '秦安县', '秦安县', 30),
(14809, 19, 14802, '张家川县', '张家川县', 35),
(14810, 19, 14783, '嘉峪关市', '嘉峪关市', 25),
(14811, 19, 14810, '长城区', '长城区', 5),
(14812, 19, 14810, '镜铁区', '镜铁区', 10),
(14813, 19, 14810, '雄关区', '雄关区', 15),
(14814, 19, 14783, '平凉市', '平凉市', 30),
(14815, 19, 14814, '静宁县', '静宁县', 5),
(14816, 19, 14814, '崆峒区', '崆峒区', 10),
(14817, 19, 14814, '华亭县', '华亭县', 15),
(14818, 19, 14814, '崇信县', '崇信县', 20),
(14819, 19, 14814, '泾川县', '泾川县', 25),
(14820, 19, 14814, '灵台县', '灵台县', 30),
(14821, 19, 14814, '镇原县', '镇原县', 35),
(14822, 19, 14814, '庄浪县', '庄浪县', 40),
(14823, 19, 14783, '庆阳市', '庆阳市', 35),
(14824, 19, 14823, '庆城县', '庆城县', 5),
(14825, 19, 14823, '西峰区', '西峰区', 10),
(14826, 19, 14823, '镇原县', '镇原县', 15),
(14827, 19, 14823, '合水县', '合水县', 20),
(14828, 19, 14823, '华池县', '华池县', 25),
(14829, 19, 14823, '环县', '环县', 30),
(14830, 19, 14823, '宁县', '宁县', 35),
(14831, 19, 14823, '正宁县', '正宁县', 40),
(14832, 19, 14783, '陇南市', '陇南市', 40),
(14833, 19, 14832, '成县', '成县', 5),
(14834, 19, 14832, '礼县', '礼县', 10),
(14835, 19, 14832, '康县', '康县', 15),
(14836, 19, 14832, '武都区', '武都区', 20),
(14837, 19, 14832, '文县', '文县', 25),
(14838, 19, 14832, '两当县', '两当县', 30),
(14839, 19, 14832, '徽县', '徽县', 35),
(14840, 19, 14832, '宕昌县', '宕昌县', 40),
(14841, 19, 14832, '西和县', '西和县', 45),
(14842, 19, 14783, '武威市', '武威市', 45),
(14843, 19, 14842, '凉州区', '凉州区', 5),
(14844, 19, 14842, '古浪县', '古浪县', 10),
(14845, 19, 14842, '天祝县', '天祝县', 15),
(14846, 19, 14842, '民勤县', '民勤县', 20),
(14847, 19, 14783, '张掖市', '张掖市', 50),
(14848, 19, 14847, '甘州区', '甘州区', 5),
(14849, 19, 14847, '山丹县', '山丹县', 10),
(14850, 19, 14847, '临泽县', '临泽县', 15),
(14851, 19, 14847, '高台县', '高台县', 20),
(14852, 19, 14847, '肃南县', '肃南县', 25),
(14853, 19, 14847, '民乐县', '民乐县', 30),
(14854, 19, 14783, '酒泉市', '酒泉市', 55),
(14855, 19, 14854, '金塔县', '金塔县', 5),
(14856, 19, 14854, '阿克塞县', '阿克塞县', 10),
(14857, 19, 14854, '肃北县', '肃北县', 15),
(14858, 19, 14854, '瓜州县', '瓜州县', 20),
(14859, 19, 14854, '肃州区', '肃州区', 25),
(14860, 19, 14854, '玉门市', '玉门市', 30),
(14861, 19, 14854, '敦煌市', '敦煌市', 35),
(14862, 19, 14783, '甘南州', '甘南州', 60),
(14863, 19, 14862, '合作市', '合作市', 5),
(14864, 19, 14862, '夏河县', '夏河县', 10),
(14865, 19, 14862, '碌曲县', '碌曲县', 15),
(14866, 19, 14862, '舟曲县', '舟曲县', 20),
(14867, 19, 14862, '玛曲县', '玛曲县', 25),
(14868, 19, 14862, '迭部县', '迭部县', 30),
(14869, 19, 14862, '临潭县', '临潭县', 35),
(14870, 19, 14862, '卓尼县', '卓尼县', 40),
(14871, 19, 14783, '临夏州', '临夏州', 65),
(14872, 19, 14871, '临夏县', '临夏县', 5),
(14873, 19, 14871, '康乐县', '康乐县', 10),
(14874, 19, 14871, '永靖县', '永靖县', 15),
(14875, 19, 14871, '和政县', '和政县', 20),
(14876, 19, 14871, '东乡族自治县', '东乡族自治县', 25),
(14877, 19, 14871, '积石山县', '积石山县', 30),
(14878, 19, 14871, '临夏市', '临夏市', 35),
(14879, 19, 14871, '广河县', '广河县', 40),
(14880, 19, 14783, '定西市', '定西市', 70),
(14881, 19, 14880, '岷县', '岷县', 5),
(14882, 19, 14880, '安定区', '安定区', 10),
(14883, 19, 14880, '通渭县', '通渭县', 15),
(14884, 19, 14880, '临洮县', '临洮县', 20),
(14885, 19, 14880, '漳县', '漳县', 25),
(14886, 19, 14880, '渭源县', '渭源县', 30),
(14887, 19, 14880, '陇西县', '陇西县', 35),
(14888, 19, 0, '青海省', '青海省', 145),
(14889, 19, 14888, '西宁市', '西宁市', 5),
(14890, 19, 14889, '湟中县', '湟中县', 5),
(14891, 19, 14889, '湟源县', '湟源县', 10),
(14892, 19, 14889, '大通县', '大通县', 15),
(14893, 19, 14889, '城中区', '城中区', 20),
(14894, 19, 14889, '城东区', '城东区', 25),
(14895, 19, 14889, '城西区', '城西区', 30),
(14896, 19, 14889, '城北区', '城北区', 35),
(14897, 19, 14888, '海东地区', '海东地区', 10),
(14898, 19, 14897, '平安县', '平安县', 5),
(14899, 19, 14897, '乐都县', '乐都县', 10),
(14900, 19, 14897, '民和县', '民和县', 15),
(14901, 19, 14897, '互助县', '互助县', 20),
(14902, 19, 14897, '化隆县', '化隆县', 25),
(14903, 19, 14897, '循化县', '循化县', 30),
(14904, 19, 14888, '海北州', '海北州', 15),
(14905, 19, 14904, '海晏县', '海晏县', 5),
(14906, 19, 14904, '祁连县', '祁连县', 10),
(14907, 19, 14904, '刚察县', '刚察县', 15),
(14908, 19, 14904, '门源县', '门源县', 20),
(14909, 19, 14888, '黄南州', '黄南州', 20),
(14910, 19, 14909, '尖扎县', '尖扎县', 5),
(14911, 19, 14909, '同仁县', '同仁县', 10),
(14912, 19, 14909, '泽库县', '泽库县', 15),
(14913, 19, 14909, '河南县', '河南县', 20),
(14914, 19, 14888, '海南州', '海南州', 25),
(14915, 19, 14914, '共和县', '共和县', 5),
(14916, 19, 14914, '同德县', '同德县', 10),
(14917, 19, 14914, '贵德县', '贵德县', 15),
(14918, 19, 14914, '兴海县', '兴海县', 20),
(14919, 19, 14914, '贵南县', '贵南县', 25),
(14920, 19, 14888, '果洛州', '果洛州', 30),
(14921, 19, 14920, '玛沁县', '玛沁县', 5),
(14922, 19, 14920, '甘德县', '甘德县', 10),
(14923, 19, 14920, '达日县', '达日县', 15),
(14924, 19, 14920, '班玛县', '班玛县', 20),
(14925, 19, 14920, '久治县', '久治县', 25),
(14926, 19, 14920, '玛多县', '玛多县', 30),
(14927, 19, 14888, '玉树州', '玉树州', 35),
(14928, 19, 14927, '玉树县', '玉树县', 5),
(14929, 19, 14927, '称多县', '称多县', 10),
(14930, 19, 14927, '囊谦县', '囊谦县', 15),
(14931, 19, 14927, '杂多县', '杂多县', 20),
(14932, 19, 14927, '治多县', '治多县', 25),
(14933, 19, 14927, '曲麻莱县', '曲麻莱县', 30),
(14934, 19, 14888, '海西州', '海西州', 40),
(14935, 19, 14934, '德令哈市', '德令哈市', 5),
(14936, 19, 14934, '乌兰县', '乌兰县', 10),
(14937, 19, 14934, '天峻县', '天峻县', 15),
(14938, 19, 14934, '都兰县', '都兰县', 20),
(14939, 19, 14934, '大柴旦行委', '大柴旦行委', 25),
(14940, 19, 14934, '冷湖行委', '冷湖行委', 30),
(14941, 19, 14934, '茫崖行委', '茫崖行委', 35),
(14942, 19, 14934, '格尔木市', '格尔木市', 40),
(14943, 19, 0, '宁夏回族自治区', '宁夏回族自治区', 150),
(14944, 19, 14943, '银川市', '银川市', 5),
(14945, 19, 14944, '灵武市', '灵武市', 5),
(14946, 19, 14944, '永宁县', '永宁县', 10),
(14947, 19, 14944, '贺兰县', '贺兰县', 15),
(14948, 19, 14944, '兴庆区', '兴庆区', 20),
(14949, 19, 14944, '金凤区', '金凤区', 25),
(14950, 19, 14944, '西夏区', '西夏区', 30),
(14951, 19, 14943, '石嘴山市', '石嘴山市', 10),
(14952, 19, 14951, '平罗县', '平罗县', 5),
(14953, 19, 14951, '惠农区', '惠农区', 10),
(14954, 19, 14951, '大武口区', '大武口区', 15),
(14955, 19, 14943, '吴忠市', '吴忠市', 15),
(14956, 19, 14955, '青铜峡市', '青铜峡市', 5),
(14957, 19, 14955, '同心县', '同心县', 10),
(14958, 19, 14955, '盐池县', '盐池县', 15),
(14959, 19, 14955, '红寺堡开发区', '红寺堡开发区', 20),
(14960, 19, 14955, '利通区', '利通区', 25),
(14961, 19, 14943, '固原市', '固原市', 20),
(14962, 19, 14961, '西吉县', '西吉县', 5),
(14963, 19, 14961, '隆德县', '隆德县', 10),
(14964, 19, 14961, '泾源县', '泾源县', 15),
(14965, 19, 14961, '彭阳县', '彭阳县', 20),
(14966, 19, 14961, '原州区', '原州区', 25),
(14967, 19, 14943, '中卫市', '中卫市', 25),
(14968, 19, 14967, '中宁县', '中宁县', 5),
(14969, 19, 14967, '海原县', '海原县', 10),
(14970, 19, 14967, '沙坡头区', '沙坡头区', 15),
(14971, 19, 0, '新疆维吾尔自治区', '新疆维吾尔自治区', 155),
(14972, 19, 14971, '乌鲁木齐市', '乌鲁木齐市', 5),
(14973, 19, 14972, '天山区', '天山区', 5),
(14974, 19, 14972, '头屯河区', '头屯河区', 10),
(14975, 19, 14972, '达坂城区', '达坂城区', 15),
(14976, 19, 14972, '米东区', '米东区', 20),
(14977, 19, 14972, '新市区', '新市区', 25),
(14978, 19, 14972, '沙依巴克区', '沙依巴克区', 30),
(14979, 19, 14972, '水磨沟区', '水磨沟区', 35),
(14980, 19, 14972, '乌鲁木齐县', '乌鲁木齐县', 40),
(14981, 19, 14971, '克拉玛依市', '克拉玛依市', 10),
(14982, 19, 14981, '克拉玛依区', '克拉玛依区', 5),
(14983, 19, 14981, '独山子区', '独山子区', 10),
(14984, 19, 14981, '乌尔禾区', '乌尔禾区', 15),
(14985, 19, 14981, '白碱滩区', '白碱滩区', 20),
(14986, 19, 14971, '石河子市', '石河子市', 15),
(14987, 19, 14986, '石河子市', '石河子市', 5),
(14988, 19, 14971, '吐鲁番地区', '吐鲁番地区', 20),
(14989, 19, 14988, '吐鲁番市', '吐鲁番市', 5),
(14990, 19, 14988, '托克逊县', '托克逊县', 10),
(14991, 19, 14988, '鄯善县', '鄯善县', 15),
(14992, 19, 14971, '哈密地区', '哈密地区', 25),
(14993, 19, 14992, '哈密市', '哈密市', 5),
(14994, 19, 14992, '巴里坤县', '巴里坤县', 10),
(14995, 19, 14992, '伊吾县', '伊吾县', 15),
(14996, 19, 14971, '和田地区', '和田地区', 30),
(14997, 19, 14996, '和田县', '和田县', 5),
(14998, 19, 14996, '和田市', '和田市', 10),
(14999, 19, 14996, '墨玉县', '墨玉县', 15),
(15000, 19, 14996, '洛浦县', '洛浦县', 20),
(15001, 19, 14996, '策勒县', '策勒县', 25),
(15002, 19, 14996, '于田县', '于田县', 30),
(15003, 19, 14996, '民丰县', '民丰县', 35),
(15004, 19, 14996, '皮山县', '皮山县', 40),
(15005, 19, 14971, '阿克苏地区', '阿克苏地区', 35),
(15006, 19, 15005, '阿拉尔市', '阿拉尔市', 5),
(15007, 19, 15005, '阿克苏市', '阿克苏市', 10),
(15008, 19, 15005, '温宿县', '温宿县', 15),
(15009, 19, 15005, '沙雅县', '沙雅县', 20),
(15010, 19, 15005, '拜城县', '拜城县', 25),
(15011, 19, 15005, '阿瓦提县', '阿瓦提县', 30),
(15012, 19, 15005, '库车县', '库车县', 35),
(15013, 19, 15005, '柯坪县', '柯坪县', 40),
(15014, 19, 15005, '新和县', '新和县', 45),
(15015, 19, 15005, '乌什县', '乌什县', 50),
(15016, 19, 14971, '喀什地区', '喀什地区', 40),
(15017, 19, 15016, '喀什市', '喀什市', 5),
(15018, 19, 15016, '巴楚县', '巴楚县', 10),
(15019, 19, 15016, '泽普县', '泽普县', 15),
(15020, 19, 15016, '伽师县', '伽师县', 20),
(15021, 19, 15016, '叶城县', '叶城县', 25),
(15022, 19, 15016, '岳普湖县', '岳普湖县', 30),
(15023, 19, 15016, '疏附县', '疏附县', 35),
(15024, 19, 15016, '疏勒县', '疏勒县', 40),
(15025, 19, 15016, '英吉沙县', '英吉沙县', 45),
(15026, 19, 15016, '麦盖提县', '麦盖提县', 50),
(15027, 19, 15016, '莎车县', '莎车县', 55),
(15028, 19, 15016, '塔什库尔干县', '塔什库尔干县', 60),
(15029, 19, 14971, '克孜勒苏州', '克孜勒苏州', 45),
(15030, 19, 15029, '阿图什市', '阿图什市', 5),
(15031, 19, 15029, '阿合奇县', '阿合奇县', 10),
(15032, 19, 15029, '乌恰县', '乌恰县', 15),
(15033, 19, 15029, '阿克陶县', '阿克陶县', 20),
(15034, 19, 14971, '巴音郭楞州', '巴音郭楞州', 50),
(15035, 19, 15034, '库尔勒市', '库尔勒市', 5),
(15036, 19, 15034, '尉犁县', '尉犁县', 10),
(15037, 19, 15034, '和静县', '和静县', 15),
(15038, 19, 15034, '博湖县', '博湖县', 20),
(15039, 19, 15034, '和硕县', '和硕县', 25),
(15040, 19, 15034, '轮台县', '轮台县', 30),
(15041, 19, 15034, '若羌县', '若羌县', 35),
(15042, 19, 15034, '且末县', '且末县', 40),
(15043, 19, 15034, '焉耆县', '焉耆县', 45),
(15044, 19, 14971, '昌吉州', '昌吉州', 55),
(15045, 19, 15044, '昌吉市', '昌吉市', 5),
(15046, 19, 15044, '阜康市', '阜康市', 10),
(15047, 19, 15044, '奇台县', '奇台县', 15),
(15048, 19, 15044, '玛纳斯县', '玛纳斯县', 20),
(15049, 19, 15044, '吉木萨尔县', '吉木萨尔县', 25),
(15050, 19, 15044, '呼图壁县', '呼图壁县', 30),
(15051, 19, 15044, '木垒县', '木垒县', 35),
(15052, 19, 14971, '博尔塔拉州', '博尔塔拉州', 60),
(15053, 19, 15052, '博乐市', '博乐市', 5),
(15054, 19, 15052, '精河县', '精河县', 10),
(15055, 19, 15052, '温泉县', '温泉县', 15),
(15056, 19, 14971, '伊犁州', '伊犁州', 65),
(15057, 19, 15056, '伊宁县', '伊宁县', 5),
(15058, 19, 15056, '伊宁市', '伊宁市', 10),
(15059, 19, 15056, '特克斯县', '特克斯县', 15),
(15060, 19, 15056, '尼勒克县', '尼勒克县', 20),
(15061, 19, 15056, '昭苏县', '昭苏县', 25),
(15062, 19, 15056, '新源县', '新源县', 30),
(15063, 19, 15056, '霍城县', '霍城县', 35),
(15064, 19, 15056, '察布查尔县', '察布查尔县', 40),
(15065, 19, 15056, '巩留县', '巩留县', 45),
(15066, 19, 15056, '奎屯市', '奎屯市', 50),
(15067, 19, 14971, '塔城地区', '塔城地区', 70),
(15068, 19, 15067, '塔城市', '塔城市', 5),
(15069, 19, 15067, '乌苏市', '乌苏市', 10),
(15070, 19, 15067, '额敏县', '额敏县', 15),
(15071, 19, 15067, '裕民县', '裕民县', 20),
(15072, 19, 15067, '沙湾县', '沙湾县', 25),
(15073, 19, 15067, '托里县', '托里县', 30),
(15074, 19, 15067, '和布克赛尔县', '和布克赛尔县', 35),
(15075, 19, 14971, '阿勒泰地区', '阿勒泰地区', 75),
(15076, 19, 15075, '北屯市', '北屯市', 5),
(15077, 19, 15075, '阿勒泰市', '阿勒泰市', 10),
(15078, 19, 15075, '富蕴县', '富蕴县', 15),
(15079, 19, 15075, '青河县', '青河县', 20),
(15080, 19, 15075, '吉木乃县', '吉木乃县', 25),
(15081, 19, 15075, '布尔津县', '布尔津县', 30),
(15082, 19, 15075, '福海县', '福海县', 35),
(15083, 19, 15075, '哈巴河县', '哈巴河县', 40),
(15084, 19, 14971, '五家渠市', '五家渠市', 80),
(15085, 19, 15084, '五家渠市', '五家渠市', 5),
(15086, 19, 14971, '阿拉尔市', '阿拉尔市', 85),
(15087, 19, 15086, '阿拉尔市', '阿拉尔市', 5),
(15088, 19, 14971, '图木舒克市', '图木舒克市', 90),
(15089, 19, 15088, '图木舒克市', '图木舒克市', 5),
(15090, 19, 0, '台湾省', '台湾省', 160),
(15091, 19, 15090, '台北', '台北', 5),
(15092, 19, 15091, '台北县', '台北县', 5),
(15093, 19, 15091, '台北市', '台北市', 10),
(15094, 19, 15090, '高雄', '高雄', 10),
(15095, 19, 15094, '市区', '市区', 5),
(15096, 19, 15094, '东港', '东港', 10),
(15097, 19, 15094, '大武', '大武', 15),
(15098, 19, 15094, '恒春', '恒春', 20),
(15099, 19, 15094, '兰屿', '兰屿', 25),
(15100, 19, 15090, '台南', '台南', 15),
(15101, 19, 15090, '台中', '台中', 20),
(15102, 19, 15090, '桃园', '桃园', 25),
(15103, 19, 15090, '新竹', '新竹', 30),
(15104, 19, 15103, '新竹县', '新竹县', 5),
(15105, 19, 15103, '新竹市', '新竹市', 10),
(15106, 19, 15103, '公馆', '公馆', 15),
(15107, 19, 15090, '宜兰', '宜兰', 35),
(15108, 19, 15090, '澎湖', '澎湖', 40),
(15109, 19, 15108, '马公', '马公', 5),
(15110, 19, 15108, '东吉屿', '东吉屿', 10),
(15111, 19, 15090, '嘉义', '嘉义', 45),
(15112, 19, 15111, '嘉义', '嘉义', 5),
(15113, 19, 15111, '阿里山', '阿里山', 10),
(15114, 19, 15111, '玉山', '玉山', 15),
(15115, 19, 15111, '新港', '新港', 20),
(15116, 19, 15090, '花莲', '花莲', 50),
(15117, 19, 15090, '台东', '台东', 55),
(15118, 19, 15090, '基隆', '基隆', 60),
(15119, 19, 15118, '彭佳屿', '彭佳屿', 5),
(15120, 19, 0, '香港特别行政区', '香港特别行政区', 165),
(15121, 19, 15120, '市区', '市区', 5),
(15122, 19, 15120, '九龙', '九龙', 10),
(15123, 19, 15120, '新界', '新界', 15),
(15124, 19, 15120, '中环', '中环', 20),
(15125, 19, 15120, '铜锣湾', '铜锣湾', 25),
(15126, 19, 0, '澳门特别行政区', '澳门特别行政区', 170),
(15127, 19, 15126, '市区内', '市区内', 5),
(15128, 1, 0, '女', '2', 20),
(15129, 13, 0, '一分钟', '60', 5),
(15130, 13, 0, '十分钟', '600', 30),
(15131, 13, 0, '三十分钟', '1800', 40),
(15132, 20, 0, 'QQ客服', 'qq', 10),
(15133, 20, 0, '微信客服', 'weixin', 20);

CREATE TABLE IF NOT EXISTS `qinggan_opt_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID ',
  `title` varchar(100) NOT NULL COMMENT '名称，用于后台管理',
  `link_symbol` varchar(10) NOT NULL COMMENT '连接字符，未设置使用英文竖线',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='可选菜单管理器' AUTO_INCREMENT=22 ;

INSERT INTO `qinggan_opt_group` (`id`, `title`, `link_symbol`) VALUES
(1, '性别', ''),
(4, '是与否', ''),
(6, '窗口打开方式', ''),
(7, '注册', ''),
(8, '邮件编码', ''),
(12, '置顶属性', ''),
(13, '等候时间', ''),
(14, '微信菜单类型', ''),
(19, '中国省市县信息', '|'),
(20, '客服类型', '');

CREATE TABLE IF NOT EXISTS `qinggan_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `sn` varchar(255) NOT NULL COMMENT '订单编号，唯一值',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID号，为0表示游客',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `price` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '金额',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币类型',
  `currency_rate` decimal(13,8) unsigned NOT NULL DEFAULT '1.00000000' COMMENT '货币汇率',
  `status` varchar(255) NOT NULL COMMENT '订单的最后状态',
  `status_title` varchar(255) NOT NULL COMMENT '订单状态说明',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `passwd` varchar(255) NOT NULL COMMENT '密码串',
  `ext` text NOT NULL COMMENT '扩展内容信息，可用于存储一些扩展信息',
  `note` text NOT NULL COMMENT '摘要',
  `email` varchar(255) NOT NULL COMMENT '邮箱，用于接收通知',
  `mobile` varchar(50) NOT NULL COMMENT '手机号，用于短信发送',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ordersn` (`sn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单中心' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `country` varchar(255) NOT NULL DEFAULT '中国' COMMENT '国家',
  `country_code` varchar(255) NOT NULL COMMENT '国家代码',
  `province` varchar(255) NOT NULL COMMENT '省信息',
  `city` varchar(255) NOT NULL COMMENT '市',
  `county` varchar(255) NOT NULL COMMENT '县',
  `address` varchar(255) NOT NULL COMMENT '地址信息（不含国家，省市县镇区信息）',
  `address2` varchar(255) NOT NULL COMMENT '第二行地址，适用于第一行地址太多补全',
  `mobile` varchar(100) NOT NULL COMMENT '手机号码',
  `tel` varchar(100) NOT NULL COMMENT '电话号码',
  `email` varchar(100) NOT NULL COMMENT '邮箱',
  `fullname` varchar(100) NOT NULL COMMENT '联系人姓名',
  `firstname` varchar(255) NOT NULL COMMENT '名字',
  `lastname` varchar(255) NOT NULL COMMENT '姓氏',
  `zipcode` varchar(50) NOT NULL COMMENT '邮编',
  `type` varchar(255) NOT NULL DEFAULT 'shipping' COMMENT '地址类型，shipping表示收货地址，billing表示账单地址',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单地址库' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_express` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID号',
  `express_id` int(11) NOT NULL DEFAULT '0' COMMENT '物流ID号',
  `code` varchar(255) NOT NULL COMMENT '物流查询编码，可用于查询快递进度',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登记时间',
  `last_query_time` int(11) NOT NULL DEFAULT '0' COMMENT '最后一次检索时间',
  `title` varchar(255) NOT NULL COMMENT '快递名称',
  `homepage` varchar(255) NOT NULL COMMENT '快递官网',
  `company` varchar(255) NOT NULL COMMENT '快递的公司全称',
  `is_end` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未结束1已结束',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单中涉及到的物流分配' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_invoice` (
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID号',
  `type` varchar(100) NOT NULL COMMENT '发票类型',
  `title` varchar(255) NOT NULL COMMENT '发票抬头',
  `content` text NOT NULL COMMENT '发票内容',
  `note` text NOT NULL COMMENT '发票的备注信息',
  PRIMARY KEY (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单发票';

CREATE TABLE IF NOT EXISTS `qinggan_order_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_express_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '定单中的物流ID',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `who` varchar(255) NOT NULL COMMENT '操作人名称（可以是公司名称，也可以是用户名，可以是物流等）',
  `note` text NOT NULL COMMENT '操作内容',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单日志，用于了解当前的订单处理进度' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_payment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `payment_id` varchar(255) NOT NULL DEFAULT '0' COMMENT '支付方式ID，数字表示网上业务支付，字母为财富支付',
  `title` varchar(255) NOT NULL COMMENT '支付方式名称',
  `price` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '支付金额',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币ID，为0使用订单默认货币',
  `currency_rate` decimal(13,8) unsigned NOT NULL DEFAULT '0.00000000' COMMENT '货币汇率',
  `startdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始支付操作',
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '支付时间',
  `ext` text NOT NULL COMMENT '其他常用扩展信息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单支付' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_price` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID号',
  `code` varchar(255) NOT NULL COMMENT '编码',
  `price` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '金额，-号表示优惠',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单金额明细清单' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID号',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `title` varchar(255) NOT NULL COMMENT '产品名称',
  `price` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '产品单价',
  `qty` int(11) NOT NULL DEFAULT '0' COMMENT '产品数量',
  `thumb` varchar(255) NOT NULL COMMENT '产品图片地址',
  `ext` text NOT NULL COMMENT '产品扩展属性',
  `weight` varchar(50) NOT NULL COMMENT '重量',
  `volume` varchar(50) NOT NULL COMMENT '体积',
  `unit` varchar(50) NOT NULL COMMENT '单位',
  `note` varchar(255) NOT NULL COMMENT '备注',
  `is_virtual` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0实物1虚拟或服务',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单的产品信息' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_order_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单ID',
  `order_payment_id` int(10) unsigned NOT NULL COMMENT 'order_payment 里的主键ID',
  `backtype` varchar(50) NOT NULL DEFAULT '_default' COMMENT '退回方式，使用_default表示原路退回',
  `sn` varchar(255) NOT NULL COMMENT '退款编号，系统生成必须是唯一的',
  `price` decimal(15,4) unsigned NOT NULL COMMENT '退款金额',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币ID',
  `currency_rate` decimal(13,8) unsigned NOT NULL DEFAULT '0.00000000' COMMENT '汇率',
  `note` varchar(255) NOT NULL COMMENT '退款理由',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0未完成，1已完成',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作时间',
  `admin_id` int(10) unsigned NOT NULL COMMENT '管理员操作ID',
  `ext` text NOT NULL COMMENT '扩展异步通知信息',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='退款记录' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_payment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '付款组',
  `code` varchar(100) NOT NULL COMMENT '标识ID',
  `title` varchar(255) NOT NULL COMMENT '主题',
  `currency` varchar(30) NOT NULL COMMENT '可使用的货币ID',
  `logo1` varchar(255) NOT NULL COMMENT 'LOGO小图',
  `logo2` varchar(255) NOT NULL COMMENT 'LOGO中图',
  `logo3` varchar(255) NOT NULL COMMENT 'LOGO大图',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态0未使用1正在使用中',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，值越小越往前靠',
  `note` text NOT NULL COMMENT '付款注意事项说明',
  `param` text NOT NULL COMMENT '参数',
  `wap` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0PC端1手机端',
  `iframe` tinyint(1) unsigned NOT NULL COMMENT '0表示跳转支付1表示嵌入支付',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='支付方案' AUTO_INCREMENT=46 ;

INSERT INTO `qinggan_payment` (`id`, `gid`, `code`, `title`, `currency`, `logo1`, `logo2`, `logo3`, `status`, `taxis`, `note`, `param`, `wap`, `iframe`) VALUES
(15, 1, 'alipay', '支付宝', 'CNY', 'res/202101/11/b58fb3e2479f7faa.png', '', '', 1, 10, '', 'a:7:{s:3:"pid";s:16:"2017122001016897";s:3:"key";s:0:"";s:6:"pubkey";s:392:"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAqnkpeLRPSw5v5cswQR5wWfxxfYnHFKs8LVXVw1GJHsEdCOihx7h4+tMz/p/oHhdYzHbtdCTaUd9YUrEa7EUbKWSCauO9aMrFglqYAs+JM7BcdDjQYZD17w5I0OdaCfJ0HsHqpkHPPiucyoFQNgJAx+2nchPNHlWB23Sw7PDIG2X3j9Hk2dm8JeoC5gDJAMiC0o5O2W8wlSNbpYEoS4uKTGL24E9QozRg+hYMYjCJF1cJUW+G76KkH47sajy1Fn4nSFIVjHqgaAG1aXDjIBo22QcEIQby8FUxQPNhIDmykr5MwKPHABVfyMO5LzafgTp2VZIIrzPBYq7qCBpRCskfvQIDAQAB";s:6:"prikey";s:1624:"MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCGH0TcEI83xvkKurV6f4l4KqrqUfzyPo4X1UDhlvt5QKAlY9o3ieocnnBy7LKKOCfJL7CyCbzi30MOt/UN+macoz6IMl6sm9II0tRu+/u5e3BQYjOBgv6+LAXMs+K37u2flBduT5HXUE5Bx+kHcv8P0hO4xskb+WVVgahCi20LtC+q6KZ+7ZFNvrAvx5LU1zlCtMrmLe2uQX6kYtBkNBUV6h6Xk8JrOMvHR0WAnZgAXKelHA89PlwvFlLwb57YLD4r6ttyuGMZdaeI7ryFeC4/NL9w1lo6Fi2SOmWsKDOf0r1YwAmBivWrmnp5Ap604YIepyGi16oqvJgcLbG/oAYZAgMBAAECggEAM776rUECUI3G5fnVLLbqDd/AY3lQcxHpdo6DYsYCrexeHS7iMU1XcsU6M0zZMXSq/PcWYApbwthKofIdbNAwKLze0mNEnancpiTZaxxzKUPTuF+66Xvl1u9bKXg5v6dCLLBRPfEbHoxQNRbw9DvM5oixrTecvdtB2nSUu1/ZqYrDYEb4FF9D/L0FLgVWRJQVwdvAzuB1LYM5fduk8UMvOeDnWwq+GN8I2GljFndeGY6BWYRneYdlBsPIlIDJKACdF0jwjCZH6WGoFAjt4dC3bUV2yEQOCb0f64M9aQXTrSZJOFrHrJus0kZXfmBgQPkLO6GgRqHYKu4URv38YxzAUQKBgQC6/geM03hDQYcDHO68mAQk9uHquVjXT2lCbp/xOTvYhjPYe+5ikeSg1RVFaRjTlvTkikSz4qIV/NeFmcP1xfwsmrnX9SR8IfkHeIqqobzY5JhzVDzNnhj5YXdip5WOUP3eT+M12LhY801va2hG6dn7sMfO/gEweUcKSsCvLqK+5QKBgQC3nl4GGwmoHa6rzCl/GKAmNQcz8IR+w+yldETc/fRambGLFlmPZdtLE7SP15Zg1lb0zmIF7vzL2/72kB0cG9GOAmd5tt/dxuxvu38IUHa04SWlldp5oLnJqc9DaFPyf3sDB/i9bpzqzRr1j77dtRYfZ53mE05NQjpiQutxIsrDJQKBgC/U4yGGxnCNxndpYzgiuoyqCkf8eVk6Gva/TXJq7YAJdCGgMe5M22q4luRWad9V8faz17cb9dIiBw9JsfKgXk0alwdC0b5fAlCC6RWUobXpY4W8uoDuO/0ujVdS/tKUrRu826Xedelq8xfZJadeEkBri/DK0IsRurZLQNaO21pxAoGAaXaytnsNHtx9mPtY0kFIqulGS9TXpR/PanDPpMbQdMFWMncR1cVBIWweB4hiPRifNVjdAF92H3kqhl/b+GsZ/6Dt4gDhsDYzUzG0Ewh0RgwTXXom1Dk2vNelzie8H8qM0v7fJZ7EzjAkTerUS+9Y14ziKmXoUYO6mPmq1X6QS2kCgYEAnyGa5/MEcl2PxW+Sra2v77LK7lX6XeWzsflIo4V+R6WGj1ADVM9c99bbal0eg/PeKzC0Utomnn03wWepFNGtDblp6Gb5OERDWx+8u38LUz4drto5i58t/YlesNOIZwj5vHd8MEO6ffR0Rw30RYMinntMBG9iR8+l0xYoOdo+x88=";s:5:"email";s:15:"admin@phpok.com";s:7:"envtype";s:7:"product";s:5:"ptype";s:12:"pagepay_link";}', 0, 0),
(19, 1, 'wxpay', '微信支付', 'CNY', '', '', '', 1, 20, '', 'a:11:{s:6:"mch_id";s:10:"1283067101";s:7:"app_key";s:6:"******";s:5:"appid";s:18:"wxd61676fe9d7468ed";s:10:"app_secret";s:32:"5239321d1305a4786f23cd106f5ab479";s:11:"device_info";s:3:"WEB";s:10:"trade_type";s:6:"native";s:8:"pem_cert";s:0:"";s:7:"pem_key";s:0:"";s:6:"pem_ca";s:0:"";s:10:"proxy_host";s:7:"0.0.0.0";s:10:"proxy_port";s:0:"";}', 0, 0),
(45, 1, 'paypal', 'Paypal', 'USD', 'res/202103/02/e7b4b7a520aed6b3.png', '', '', 1, 255, '', 'a:3:{s:2:"at";s:59:"t3ZtVLsHFKvtyCvU1B27X6gcVhxqM68Yr7b2Ub9gSgi8zxfIqlSQLs7fxf0";s:5:"payid";s:24:"suxiangkun-biz@gmail.com";s:6:"action";s:45:"https://www.sandbox.paypal.com/cgi-bin/webscr";}', 0, 0),
(40, 10, 'alipay', '支付宝', 'CNY', '', '', '', 1, 10, '', 'a:5:{s:3:"pid";s:16:"2088802450390810";s:3:"key";s:5:"*****";s:5:"email";s:15:"admin@phpok.com";s:7:"envtype";s:7:"product";s:5:"ptype";s:25:"create_direct_pay_by_user";}', 1, 0),
(42, 10, 'wxpay', '微信支付', 'CNY', '', '', '', 1, 20, '', 'a:11:{s:6:"mch_id";s:10:"1283067101";s:7:"app_key";s:32:"a6d5b10386897dab7f605228a1d04c43";s:5:"appid";s:18:"wxcc4d79b75843fe21";s:10:"app_secret";s:32:"262daad5891008396fd0896d759839d9";s:11:"device_info";s:3:"web";s:10:"trade_type";s:11:"miniprogram";s:8:"pem_cert";s:0:"";s:7:"pem_key";s:0:"";s:6:"pem_ca";s:0:"";s:10:"proxy_host";s:7:"0.0.0.0";s:10:"proxy_port";s:0:"";}', 1, 0);

CREATE TABLE IF NOT EXISTS `qinggan_payment_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` int(11) NOT NULL DEFAULT '0' COMMENT '站点ID，为0表示全部',
  `title` varchar(255) NOT NULL COMMENT '付款组名称',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不启用1启用',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，值越小越往前靠',
  `is_default` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1默认组0普通组',
  `is_wap` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0是PC端，1是手机端',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='付款组管理' AUTO_INCREMENT=11 ;

INSERT INTO `qinggan_payment_group` (`id`, `site_id`, `title`, `status`, `taxis`, `is_default`, `is_wap`) VALUES
(1, 1, '快捷支付', 1, 10, 0, 0),
(10, 1, '快捷支付', 1, 20, 0, 1);

CREATE TABLE IF NOT EXISTS `qinggan_payment_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `sn` varchar(255) NOT NULL COMMENT '支付编号',
  `type` varchar(100) NOT NULL COMMENT 'order订单,recharge充值other其他',
  `payment_id` varchar(255) NOT NULL DEFAULT '0' COMMENT '支付方式，为数字时表示payment表中的主要支付方式，为字母数字混合表示财富付款',
  `title` varchar(255) NOT NULL COMMENT '主题',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '记录时间',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '价格',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币ID',
  `currency_rate` decimal(13,8) unsigned NOT NULL DEFAULT '0.00000000' COMMENT '货币汇率',
  `content` varchar(255) NOT NULL COMMENT '内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未支付成功1已支付成功',
  `ext` text NOT NULL COMMENT '扩展',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='支付日志' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_phpok` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `title` varchar(255) NOT NULL COMMENT '标题',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `type_id` varchar(255) NOT NULL COMMENT '调用类型',
  `identifier` varchar(100) NOT NULL COMMENT '标识串，同一个站点中只能唯一',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `cateid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `ext` text NOT NULL COMMENT '扩展属性',
  `is_api` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不支持API调用，1支持',
  `sqlinfo` text NOT NULL COMMENT 'SQL语句',
  PRIMARY KEY (`id`),
  UNIQUE KEY `identifier` (`identifier`,`site_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='数据调用中心' AUTO_INCREMENT=352 ;

INSERT INTO `qinggan_phpok` (`id`, `title`, `pid`, `type_id`, `identifier`, `site_id`, `status`, `cateid`, `ext`, `is_api`, `sqlinfo`) VALUES
(18, '网站首页图片播放', 41, 'arclist', 'picplayer', 1, 1, 0, 'a:15:{s:5:"psize";s:1:"5";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:1:"*";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(19, '头部导航内容', 42, 'arclist', 'menu', 1, 1, 0, 'a:15:{s:5:"psize";s:2:"80";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:1:"*";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";s:1:"1";s:8:"title_id";s:0:"";}', 0, ''),
(20, '公司简介', 87, 'arc', 'aboutus', 1, 1, 0, 'a:15:{s:5:"psize";i:0;s:6:"offset";i:0;s:7:"is_list";i:0;s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:1:"*";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:7:"aboutus";}', 1, ''),
(21, '产品分类', 45, 'catelist', 'products_cate', 1, 1, 70, 'a:20:{s:5:"psize";b:0;s:6:"offset";b:0;s:7:"is_list";b:0;s:7:"in_text";b:0;s:4:"attr";b:0;s:11:"fields_need";b:0;s:3:"tag";b:0;s:8:"keywords";b:0;s:7:"orderby";b:0;s:4:"cate";b:0;s:8:"cate_ext";b:0;s:12:"catelist_ext";b:0;s:11:"project_ext";b:0;s:11:"sublist_ext";b:0;s:10:"parent_ext";b:0;s:13:"fields_format";b:0;s:8:"user_ext";b:0;s:4:"user";b:0;s:12:"userlist_ext";b:0;s:6:"in_sub";b:0;}', 0, ''),
(22, '最新产品', 45, 'arclist', 'new_products', 1, 1, 70, 'a:15:{s:5:"psize";s:1:"8";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:9:"ext.thumb";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:5:"thumb";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 1, ''),
(55, '友情链接', 389, 'arclist', 'link', 1, 1, 0, 'a:15:{s:5:"psize";s:2:"30";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:7:"linkurl";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:1:"*";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(91, '新闻中心', 43, 'arclist', 'news', 1, 1, 7, 'a:15:{s:5:"psize";s:1:"5";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:10:"note,thumb";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(92, '图集相册', 144, 'arclist', 'photo', 1, 1, 0, 'a:23:{s:5:"psize";s:2:"10";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:7:"in_text";i:0;s:4:"attr";b:0;s:11:"fields_need";s:9:"ext.thumb";s:3:"tag";b:0;s:8:"keywords";b:0;s:7:"orderby";b:0;s:4:"cate";b:0;s:8:"cate_ext";i:0;s:12:"catelist_ext";i:0;s:11:"project_ext";i:0;s:11:"sublist_ext";i:0;s:10:"parent_ext";i:0;s:13:"fields_format";i:0;s:8:"user_ext";i:0;s:4:"user";b:0;s:12:"userlist_ext";i:0;s:6:"in_sub";i:0;s:10:"in_project";s:1:"1";s:7:"in_cate";i:0;s:8:"title_id";b:0;}', 0, ''),
(93, '图片滚动新闻', 43, 'arclist', 'picnews', 1, 1, 7, 'a:23:{s:5:"psize";s:2:"10";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:7:"in_text";i:0;s:4:"attr";b:0;s:11:"fields_need";s:9:"ext.thumb";s:3:"tag";b:0;s:8:"keywords";b:0;s:7:"orderby";b:0;s:4:"cate";b:0;s:8:"cate_ext";i:0;s:12:"catelist_ext";i:0;s:11:"project_ext";i:0;s:11:"sublist_ext";i:0;s:10:"parent_ext";i:0;s:13:"fields_format";i:0;s:8:"user_ext";i:0;s:4:"user";b:0;s:12:"userlist_ext";i:0;s:6:"in_sub";i:0;s:10:"in_project";i:0;s:7:"in_cate";i:0;s:8:"title_id";b:0;}', 0, ''),
(94, '页脚导航', 147, 'arclist', 'footnav', 1, 1, 0, 'a:23:{s:5:"psize";s:2:"10";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:7:"in_text";s:1:"1";s:4:"attr";b:0;s:11:"fields_need";b:0;s:3:"tag";b:0;s:8:"keywords";b:0;s:7:"orderby";b:0;s:4:"cate";b:0;s:8:"cate_ext";i:0;s:12:"catelist_ext";i:0;s:11:"project_ext";i:0;s:11:"sublist_ext";i:0;s:10:"parent_ext";i:0;s:13:"fields_format";i:0;s:8:"user_ext";i:0;s:4:"user";b:0;s:12:"userlist_ext";i:0;s:6:"in_sub";i:0;s:10:"in_project";i:0;s:7:"in_cate";i:0;s:8:"title_id";b:0;}', 0, ''),
(95, '客服', 148, 'arclist', 'kefu', 1, 1, 0, 'a:13:{s:5:"psize";s:2:"50";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:4:"cate";s:0:"";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(96, '售后保障', 150, 'arc', 'after-sale-protection', 1, 1, 0, 'a:15:{s:5:"psize";i:0;s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:1:"*";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:21:"after-sale-protection";}', 0, ''),
(97, '图集相册', 144, 'arclist', 'tujixiangce', 1, 1, 154, 'a:13:{s:5:"psize";s:1:"6";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:9:"ext.thumb";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:4:"cate";s:0:"";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(98, '产品展示', 45, 'catelist', 'catelist', 1, 1, 70, 'a:15:{s:5:"psize";i:0;s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:1:"*";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 1, ''),
(99, '下载中心', 151, 'arclist', 'xiazaizhongxin', 1, 1, 197, 'a:13:{s:5:"psize";s:2:"10";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:9:"ext.dfile";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:4:"cate";s:0:"";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(104, '资讯中心', 43, 'arclist', 'titlelist', 1, 1, 7, 'a:15:{s:5:"psize";s:2:"10";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:2:"id";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 1, ''),
(105, '资讯中心', 43, 'catelist', 'news_catelist', 1, 1, 7, 'a:13:{s:5:"psize";i:0;s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:4:"cate";s:0:"";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(280, '联系我们', 87, 'arc', 'contactus', 1, 1, 0, 'a:13:{s:5:"psize";i:0;s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:0:"";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:4:"cate";s:0:"";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:6:"in_sub";i:0;s:8:"title_id";s:9:"contactus";}', 0, ''),
(282, '热门产品', 45, 'arclist', 'hot_products', 1, 1, 70, 'a:15:{s:5:"psize";s:1:"5";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:9:"ext.thumb";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:11:"l.hits DESC";s:6:"fields";s:5:"thumb";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, ''),
(290, '图片轮播【小程序】', 41, 'arclist', 'm_picplayer', 1, 1, 0, 'a:15:{s:5:"psize";s:1:"5";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:13:"ext.picmobile";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:9:"picmobile";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 1, ''),
(351, '新闻+图片', 43, 'arclist', 'news-pictures', 1, 1, 7, 'a:15:{s:5:"psize";s:1:"4";s:6:"offset";i:0;s:7:"is_list";s:1:"1";s:4:"attr";s:0:"";s:11:"fields_need";s:9:"ext.thumb";s:3:"tag";s:0:"";s:8:"keywords";s:0:"";s:7:"orderby";s:0:"";s:6:"fields";s:5:"thumb";s:13:"fields_format";i:0;s:4:"user";s:0:"";s:8:"user_ext";i:0;s:9:"usergroup";i:0;s:6:"in_sub";i:0;s:8:"title_id";s:0:"";}', 0, '');

CREATE TABLE IF NOT EXISTS `qinggan_plugins` (
  `id` varchar(100) NOT NULL COMMENT '插件ID，仅限字母，数字及下划线',
  `title` varchar(255) NOT NULL COMMENT '插件名称',
  `author` varchar(255) NOT NULL COMMENT '开发者',
  `version` varchar(50) NOT NULL COMMENT '插件版本号',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0禁用1使用',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '值越小越往前靠',
  `note` varchar(255) NOT NULL COMMENT '摘要说明',
  `param` text NOT NULL COMMENT '参数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件管理器';

INSERT INTO `qinggan_plugins` (`id`, `title`, `author`, `version`, `status`, `taxis`, `note`, `param`) VALUES
('identifier', '标识串自动生成工具', 'phpok.com', '1.0', 1, 10, '实现将“title”字段的表单数据翻译符合系统要求的标识串', 'a:5:{s:12:"youdao_appid";s:16:"1c924b4b01cb16f2";s:13:"youdao_appkey";s:32:"4vAE9hTCrSwnUF9DzApH3aNlj6a0KgCm";s:12:"youdao_https";i:0;s:11:"phpok_appid";s:1:"3";s:12:"phpok_appkey";s:16:"vhDsxyZSsHnBeXlV";}'),
('bmap', '百度地图地址编码', 'phpok', '1.0', 1, 40, '将地址转换为坐标并且前端显示', 'a:7:{s:7:"address";s:63:"广东深圳龙华区民治大道东边商务大楼13层1309室";s:6:"apikey";s:32:"5dKTKKGmwAcUXfxr1NcuXPifTqdIQvV0";s:3:"tel";s:13:"0755-23776246";s:3:"lng";s:10:"114.046985";s:3:"lat";s:9:"22.623938";s:8:"address2";s:0:"";s:7:"company";s:33:"深圳市锟铻科技有限公司";}');

CREATE TABLE IF NOT EXISTS `qinggan_popedom` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID，即自增ID',
  `gid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '所属组ID，对应sysmenu表中的ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID，仅在list中有效',
  `title` varchar(255) NOT NULL COMMENT '名称，如：添加，修改等',
  `identifier` varchar(255) NOT NULL COMMENT '字符串，如add，modify等',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='权限明细' AUTO_INCREMENT=1972 ;

INSERT INTO `qinggan_popedom` (`id`, `gid`, `pid`, `title`, `identifier`, `taxis`) VALUES
(2, 19, 0, '配置全局', 'gset', 10),
(3, 19, 0, '内容', 'set', 20),
(4, 29, 0, '添加', 'add', 10),
(5, 29, 0, '修改', 'modify', 20),
(6, 29, 0, '删除', 'delete', 30),
(7, 18, 0, '添加', 'add', 10),
(8, 18, 0, '编辑', 'modify', 20),
(9, 18, 0, '删除', 'delete', 30),
(10, 23, 0, '添加', 'add', 10),
(11, 23, 0, '编辑', 'modify', 20),
(12, 23, 0, '删除', 'delete', 30),
(14, 22, 0, 'GD配置', 'gd', 10),
(15, 22, 0, '附件分类维护', 'cate', 20),
(16, 22, 0, '批处理', 'pl', 30),
(17, 16, 0, '配置', 'config', 10),
(18, 16, 0, '安装', 'install', 20),
(19, 16, 0, '卸载', 'uninstall', 30),
(20, 16, 0, '删除', 'delete', 40),
(21, 17, 0, '添加', 'add', 20),
(22, 13, 0, '添加', 'add', 10),
(23, 13, 0, '修改', 'modify', 20),
(24, 13, 0, '删除', 'delete', 30),
(25, 13, 0, '查看', 'list', 5),
(26, 19, 0, '查看', 'list', 5),
(33, 21, 0, '查看', 'list', 10),
(34, 21, 0, '添加', 'add', 20),
(35, 21, 0, '编辑', 'modify', 30),
(36, 21, 0, '删除', 'delete', 40),
(37, 18, 0, '查看', 'list', 5),
(38, 23, 0, '查看', 'list', 5),
(40, 16, 0, '查看', 'list', 5),
(41, 17, 0, '查看', 'list', 10),
(42, 18, 0, '扩展', 'ext', 40),
(43, 19, 0, '扩展', 'ext', 30),
(44, 14, 0, '查看', 'list', 10),
(45, 14, 0, '添加', 'add', 20),
(46, 14, 0, '修改', 'modify', 30),
(47, 14, 0, '删除', 'delete', 40),
(48, 25, 0, '查看', 'list', 10),
(49, 25, 0, '配置', 'set', 20),
(52, 29, 0, '查看', 'list', 5),
(53, 27, 0, '查看', 'list', 10),
(54, 27, 0, '配置', 'set', 20),
(58, 8, 0, '查看', 'list', 10),
(59, 8, 0, '维护', 'set', 20),
(63, 6, 0, '查看', 'list', 10),
(64, 6, 0, '维护', 'set', 20),
(67, 7, 0, '查看', 'list', 10),
(68, 7, 0, '添加', 'add', 20),
(69, 7, 0, '修改', 'modify', 30),
(70, 7, 0, '删除', 'delete', 40),
(71, 28, 0, '查看', 'list', 10),
(72, 28, 0, '添加', 'add', 20),
(73, 28, 0, '修改', 'modify', 30),
(74, 28, 0, '删除', 'delete', 40),
(75, 9, 0, '查看', 'list', 10),
(76, 9, 0, '添加', 'add', 20),
(77, 9, 0, '修改', 'modify', 30),
(78, 9, 0, '启用/禁用', 'status', 40),
(79, 29, 0, '启用/禁用', 'status', 40),
(80, 14, 0, '启用/禁用', 'status', 50),
(81, 19, 0, '网站', 'site', 40),
(82, 19, 0, '域名', 'domain', 50),
(83, 16, 0, '启用/禁用', 'status', 50),
(133, 30, 0, '查看', 'list', 10),
(134, 30, 0, '设置', 'set', 20),
(135, 30, 0, '文件管理', 'filelist', 30),
(136, 30, 0, '删除', 'delete', 40),
(142, 13, 0, '审核', 'status', 40),
(143, 20, 41, '查看', 'list', 10),
(144, 20, 41, '添加', 'add', 30),
(145, 20, 41, '修改', 'modify', 40),
(146, 20, 41, '删除', 'delete', 50),
(147, 20, 41, '启用/禁用', 'status', 60),
(153, 20, 43, '查看', 'list', 10),
(154, 20, 43, '添加', 'add', 30),
(155, 20, 43, '修改', 'modify', 40),
(156, 20, 43, '删除', 'delete', 50),
(157, 20, 43, '启用/禁用', 'status', 60),
(159, 31, 0, '查看', 'list', 10),
(160, 31, 0, '删除', 'delete', 20),
(161, 31, 0, '设为默认', 'default', 30),
(162, 31, 0, '添加站点', 'add', 40),
(165, 20, 45, '查看', 'list', 10),
(166, 20, 45, '添加', 'add', 30),
(167, 20, 45, '修改', 'modify', 40),
(168, 20, 45, '删除', 'delete', 50),
(169, 20, 45, '启用/禁用', 'status', 60),
(170, 19, 0, '添加站点', 'add', 60),
(344, 32, 0, '查看', 'list', 10),
(345, 32, 0, '启用/禁用', 'status', 20),
(346, 32, 0, '删除', 'delete', 30),
(347, 32, 0, '修改', 'modify', 40),
(348, 32, 0, '回复', 'reply', 50),
(349, 20, 87, '查看', 'list', 10),
(350, 20, 87, '添加', 'add', 30),
(351, 20, 87, '修改', 'modify', 40),
(352, 20, 87, '删除', 'delete', 50),
(353, 20, 87, '启用/禁用', 'status', 60),
(388, 20, 96, '查看', 'list', 10),
(389, 20, 96, '添加', 'add', 30),
(390, 20, 96, '修改', 'modify', 40),
(391, 20, 96, '删除', 'delete', 50),
(392, 20, 96, '启用/禁用', 'status', 60),
(476, 33, 0, '查看', 'list', 10),
(477, 33, 0, '添加', 'add', 20),
(478, 33, 0, '修改', 'modify', 30),
(479, 33, 0, '删除', 'delete', 40),
(480, 33, 0, '启用/禁用', 'status', 50),
(601, 34, 0, '查看', 'list', 10),
(602, 34, 0, '添加', 'add', 20),
(603, 34, 0, '修改', 'modify', 30),
(604, 34, 0, '审核', 'status', 40),
(605, 34, 0, '删除', 'delete', 50),
(612, 20, 144, '查看', 'list', 10),
(613, 20, 144, '添加', 'add', 30),
(614, 20, 144, '修改', 'modify', 40),
(615, 20, 144, '删除', 'delete', 50),
(616, 20, 144, '启用/禁用', 'status', 60),
(617, 42, 0, '查看', 'list', 10),
(618, 42, 0, '执行', 'set', 20),
(619, 43, 0, '查看', 'list', 10),
(620, 44, 0, '查看', 'list', 10),
(621, 45, 0, '查看', 'list', 10),
(622, 45, 0, '升级', 'update', 20),
(623, 45, 0, '配置升级服务器', 'set', 30),
(624, 46, 0, '查看', 'list', 10),
(625, 9, 0, '删除', 'delete', 50),
(626, 52, 0, '查看', 'list', 10),
(627, 52, 0, '添加组', 'groupadd', 20),
(628, 52, 0, '修改组', 'groupedit', 30),
(629, 52, 0, '删除组', 'groupdelete', 40),
(630, 52, 0, '添加', 'add', 50),
(631, 52, 0, '修改', 'edit', 60),
(632, 52, 0, '删除', 'delete', 70),
(633, 52, 0, '启用/禁用', 'status', 80),
(634, 52, 0, '组启用/禁用', 'groupstatus', 35),
(635, 54, 0, '查看', 'list', 10),
(636, 54, 0, '添加', 'add', 20),
(637, 54, 0, '修改', 'modify', 30),
(638, 54, 0, '删除', 'delete', 40),
(639, 54, 0, '审核', 'status', 50),
(640, 54, 0, '排序', 'taxis', 60),
(647, 55, 0, '查看', 'list', 10),
(648, 55, 0, '更新HTML', 'create', 20),
(657, 20, 148, '查看', 'list', 10),
(658, 20, 148, '编辑', 'set', 20),
(659, 20, 148, '添加', 'add', 30),
(660, 20, 148, '修改', 'modify', 40),
(661, 20, 148, '删除', 'delete', 50),
(662, 20, 148, '启用/禁用', 'status', 60),
(1937, 20, 452, '编辑', 'set', 20),
(1936, 20, 452, '查看', 'list', 10),
(671, 20, 151, '查看', 'list', 10),
(672, 20, 151, '编辑', 'set', 20),
(673, 20, 151, '添加', 'add', 30),
(674, 20, 151, '修改', 'modify', 40),
(675, 20, 151, '删除', 'delete', 50),
(676, 20, 151, '启用/禁用', 'status', 60),
(677, 20, 152, '查看', 'list', 10),
(678, 20, 152, '编辑', 'set', 20),
(679, 20, 152, '添加', 'add', 30),
(680, 20, 152, '修改', 'modify', 40),
(681, 20, 152, '删除', 'delete', 50),
(682, 20, 152, '启用/禁用', 'status', 60),
(689, 20, 144, '编辑', 'set', 20),
(690, 57, 0, '查看', 'list', 10),
(691, 57, 0, '创建备份', 'create', 20),
(692, 57, 0, '删除备份', 'delete', 30),
(693, 57, 0, '恢复备份', 'recover', 40),
(694, 57, 0, '优化', 'optimize', 50),
(695, 57, 0, '修复', 'repair', 60),
(696, 58, 0, '查看', 'list', 10),
(697, 58, 0, '添加', 'add', 20),
(698, 58, 0, '修改', 'modify', 30),
(699, 58, 0, '删除', 'delete', 40),
(700, 18, 0, '状态', 'status', 50),
(701, 59, 0, '查看', 'list', 10),
(702, 59, 0, '设置', 'set', 20),
(703, 59, 0, '删除', 'delete', 30),
(704, 27, 0, '扩展', 'ext', 30),
(748, 62, 0, '查看', 'list', 10),
(749, 62, 0, '添加', 'add', 20),
(750, 62, 0, '编辑', 'modify', 30),
(751, 62, 0, '删除', 'delete', 40),
(752, 63, 0, '查看', 'list', 10),
(753, 63, 0, '添加', 'add', 20),
(754, 63, 0, '修改', 'modify', 30),
(755, 63, 0, '删除', 'delete', 40),
(757, 20, 43, '评论', 'comment', 80),
(758, 66, 0, '查看', 'list', 10),
(759, 66, 0, '添加', 'add', 20),
(760, 66, 0, '修改', 'modify', 30),
(761, 66, 0, '配置', 'setting', 40),
(762, 66, 0, '删除', 'delete', 60),
(763, 66, 0, '状态', 'status', 50),
(764, 67, 0, '查看', 'list', 10),
(765, 67, 0, '添加', 'add', 20),
(766, 67, 0, '修改', 'modify', 30),
(767, 67, 0, '删除', 'delete', 40),
(768, 68, 0, '查看', 'list', 10),
(769, 68, 0, '添加', 'add', 20),
(770, 68, 0, '修改', 'modify', 30),
(771, 68, 0, '删除', 'delete', 40),
(772, 77, 0, '查看', 'list', 10),
(773, 77, 0, '添加', 'add', 20),
(774, 77, 0, '修改', 'modify', 30),
(775, 77, 0, '删除', 'delete', 40),
(776, 77, 0, '状态', 'status', 50),
(777, 34, 0, '配置', 'set', 60),
(778, 31, 0, '订单配置', 'order', 50),
(779, 78, 0, '查看', 'list', 10),
(780, 78, 0, '添加', 'add', 20),
(781, 78, 0, '修改', 'modify', 30),
(782, 78, 0, '删除', 'delete', 40),
(783, 78, 0, '审核', 'status', 50),
(784, 78, 0, '设为默认', 'isdefault', 60),
(793, 80, 0, '查看', 'list', 10),
(794, 80, 0, '添加', 'add', 20),
(795, 80, 0, '修改', 'modify', 30),
(796, 80, 0, '删除', 'delete', 40),
(965, 20, 0, '查看', 'list', 10),
(966, 20, 0, '编辑', 'set', 20),
(967, 20, 0, '添加', 'add', 30),
(968, 20, 0, '修改', 'modify', 40),
(969, 20, 0, '删除', 'delete', 50),
(970, 20, 0, '启用/禁用', 'status', 60),
(971, 20, 0, '扩展', 'ext', 70),
(972, 20, 0, '评论', 'comment', 80),
(981, 20, 43, '编辑', 'set', 20),
(982, 20, 43, '扩展', 'ext', 70),
(983, 20, 311, '查看', 'list', 10),
(984, 20, 311, '添加', 'add', 30),
(985, 20, 311, '修改', 'modify', 40),
(986, 20, 311, '删除', 'delete', 50),
(987, 20, 311, '启用/禁用', 'status', 60),
(988, 20, 312, '查看', 'list', 10),
(989, 20, 312, '添加', 'add', 30),
(990, 20, 312, '修改', 'modify', 40),
(991, 20, 312, '删除', 'delete', 50),
(992, 20, 312, '启用/禁用', 'status', 60),
(993, 20, 313, '查看', 'list', 10),
(994, 20, 313, '添加', 'add', 30),
(995, 20, 313, '修改', 'modify', 40),
(996, 20, 313, '删除', 'delete', 50),
(997, 20, 313, '启用/禁用', 'status', 60),
(998, 20, 313, '评论', 'comment', 80),
(999, 20, 313, '编辑', 'set', 20),
(1000, 20, 313, '扩展', 'ext', 70),
(1001, 20, 314, '查看', 'list', 10),
(1002, 20, 314, '添加', 'add', 30),
(1003, 20, 314, '修改', 'modify', 40),
(1004, 20, 314, '删除', 'delete', 50),
(1005, 20, 314, '启用/禁用', 'status', 60),
(1006, 20, 315, '查看', 'list', 10),
(1007, 20, 315, '添加', 'add', 30),
(1008, 20, 315, '修改', 'modify', 40),
(1009, 20, 315, '删除', 'delete', 50),
(1010, 20, 315, '启用/禁用', 'status', 60),
(1011, 20, 316, '查看', 'list', 10),
(1012, 20, 316, '编辑', 'set', 20),
(1013, 20, 317, '查看', 'list', 10),
(1014, 20, 317, '编辑', 'set', 20),
(1015, 20, 318, '查看', 'list', 10),
(1016, 20, 318, '编辑', 'set', 20),
(1017, 20, 319, '查看', 'list', 10),
(1018, 20, 319, '编辑', 'set', 20),
(1019, 20, 320, '查看', 'list', 10),
(1020, 20, 320, '编辑', 'set', 20),
(1021, 20, 320, '添加', 'add', 30),
(1022, 20, 320, '修改', 'modify', 40),
(1023, 20, 320, '删除', 'delete', 50),
(1024, 20, 320, '启用/禁用', 'status', 60),
(1025, 20, 321, '查看', 'list', 10),
(1026, 20, 321, '添加', 'add', 30),
(1027, 20, 321, '修改', 'modify', 40),
(1028, 20, 321, '删除', 'delete', 50),
(1029, 20, 321, '启用/禁用', 'status', 60),
(1030, 20, 322, '查看', 'list', 10),
(1031, 20, 322, '添加', 'add', 30),
(1032, 20, 322, '修改', 'modify', 40),
(1033, 20, 322, '删除', 'delete', 50),
(1034, 20, 322, '启用/禁用', 'status', 60),
(1035, 20, 322, '编辑', 'set', 20),
(1036, 20, 323, '查看', 'list', 10),
(1037, 20, 323, '编辑', 'set', 20),
(1038, 20, 323, '添加', 'add', 30),
(1039, 20, 323, '修改', 'modify', 40),
(1040, 20, 323, '删除', 'delete', 50),
(1041, 20, 323, '启用/禁用', 'status', 60),
(1042, 20, 324, '查看', 'list', 10),
(1043, 20, 324, '编辑', 'set', 20),
(1044, 20, 324, '添加', 'add', 30),
(1045, 20, 324, '修改', 'modify', 40),
(1046, 20, 324, '删除', 'delete', 50),
(1047, 20, 324, '启用/禁用', 'status', 60),
(1048, 20, 325, '查看', 'list', 10),
(1049, 20, 325, '编辑', 'set', 20),
(1050, 20, 325, '添加', 'add', 30),
(1051, 20, 325, '修改', 'modify', 40),
(1052, 20, 325, '删除', 'delete', 50),
(1053, 20, 325, '启用/禁用', 'status', 60),
(1054, 20, 326, '编辑', 'set', 20),
(1055, 20, 326, '查看', 'list', 10),
(1056, 20, 327, '查看', 'list', 10),
(1057, 20, 327, '编辑', 'set', 20),
(1058, 20, 328, '查看', 'list', 10),
(1059, 20, 328, '编辑', 'set', 20),
(1060, 20, 328, '添加', 'add', 30),
(1061, 20, 328, '修改', 'modify', 40),
(1062, 20, 328, '删除', 'delete', 50),
(1063, 20, 328, '启用/禁用', 'status', 60),
(1064, 20, 329, '查看', 'list', 10),
(1065, 20, 329, '添加', 'add', 30),
(1066, 20, 329, '修改', 'modify', 40),
(1067, 20, 329, '删除', 'delete', 50),
(1068, 20, 329, '启用/禁用', 'status', 60),
(1069, 20, 330, '查看', 'list', 10),
(1070, 20, 330, '添加', 'add', 30),
(1071, 20, 330, '修改', 'modify', 40),
(1072, 20, 330, '删除', 'delete', 50),
(1073, 20, 330, '启用/禁用', 'status', 60),
(1074, 20, 331, '查看', 'list', 10),
(1075, 20, 331, '添加', 'add', 30),
(1076, 20, 331, '修改', 'modify', 40),
(1077, 20, 331, '删除', 'delete', 50),
(1078, 20, 331, '启用/禁用', 'status', 60),
(1079, 20, 331, '评论', 'comment', 80),
(1080, 20, 331, '编辑', 'set', 20),
(1081, 20, 331, '扩展', 'ext', 70),
(1082, 20, 332, '查看', 'list', 10),
(1083, 20, 332, '添加', 'add', 30),
(1084, 20, 332, '修改', 'modify', 40),
(1085, 20, 332, '删除', 'delete', 50),
(1086, 20, 332, '启用/禁用', 'status', 60),
(1087, 20, 333, '查看', 'list', 10),
(1088, 20, 333, '添加', 'add', 30),
(1089, 20, 333, '修改', 'modify', 40),
(1090, 20, 333, '删除', 'delete', 50),
(1091, 20, 333, '启用/禁用', 'status', 60),
(1092, 20, 334, '查看', 'list', 10),
(1093, 20, 334, '编辑', 'set', 20),
(1094, 20, 335, '查看', 'list', 10),
(1095, 20, 335, '编辑', 'set', 20),
(1096, 20, 336, '查看', 'list', 10),
(1097, 20, 336, '编辑', 'set', 20),
(1098, 20, 337, '查看', 'list', 10),
(1099, 20, 337, '编辑', 'set', 20),
(1100, 20, 338, '查看', 'list', 10),
(1101, 20, 338, '编辑', 'set', 20),
(1102, 20, 338, '添加', 'add', 30),
(1103, 20, 338, '修改', 'modify', 40),
(1104, 20, 338, '删除', 'delete', 50),
(1105, 20, 338, '启用/禁用', 'status', 60),
(1106, 20, 339, '查看', 'list', 10),
(1107, 20, 339, '添加', 'add', 30),
(1108, 20, 339, '修改', 'modify', 40),
(1109, 20, 339, '删除', 'delete', 50),
(1110, 20, 339, '启用/禁用', 'status', 60),
(1111, 20, 340, '查看', 'list', 10),
(1112, 20, 340, '添加', 'add', 30),
(1113, 20, 340, '修改', 'modify', 40),
(1114, 20, 340, '删除', 'delete', 50),
(1115, 20, 340, '启用/禁用', 'status', 60),
(1116, 20, 340, '编辑', 'set', 20),
(1117, 20, 341, '查看', 'list', 10),
(1118, 20, 341, '编辑', 'set', 20),
(1119, 20, 341, '添加', 'add', 30),
(1120, 20, 341, '修改', 'modify', 40),
(1121, 20, 341, '删除', 'delete', 50),
(1122, 20, 341, '启用/禁用', 'status', 60),
(1123, 20, 342, '查看', 'list', 10),
(1124, 20, 342, '编辑', 'set', 20),
(1125, 20, 342, '添加', 'add', 30),
(1126, 20, 342, '修改', 'modify', 40),
(1127, 20, 342, '删除', 'delete', 50),
(1128, 20, 342, '启用/禁用', 'status', 60),
(1129, 20, 343, '查看', 'list', 10),
(1130, 20, 343, '编辑', 'set', 20),
(1131, 20, 343, '添加', 'add', 30),
(1132, 20, 343, '修改', 'modify', 40),
(1133, 20, 343, '删除', 'delete', 50),
(1134, 20, 343, '启用/禁用', 'status', 60),
(1135, 20, 344, '编辑', 'set', 20),
(1136, 20, 344, '查看', 'list', 10),
(1137, 20, 345, '查看', 'list', 10),
(1138, 20, 345, '编辑', 'set', 20),
(1139, 20, 346, '查看', 'list', 10),
(1140, 20, 346, '编辑', 'set', 20),
(1141, 20, 346, '添加', 'add', 30),
(1142, 20, 346, '修改', 'modify', 40),
(1143, 20, 346, '删除', 'delete', 50),
(1144, 20, 346, '启用/禁用', 'status', 60),
(1145, 20, 347, '查看', 'list', 10),
(1146, 20, 347, '添加', 'add', 30),
(1147, 20, 347, '修改', 'modify', 40),
(1148, 20, 347, '删除', 'delete', 50),
(1149, 20, 347, '启用/禁用', 'status', 60),
(1150, 20, 348, '查看', 'list', 10),
(1151, 20, 348, '添加', 'add', 30),
(1152, 20, 348, '修改', 'modify', 40),
(1153, 20, 348, '删除', 'delete', 50),
(1154, 20, 348, '启用/禁用', 'status', 60),
(1155, 20, 349, '查看', 'list', 10),
(1156, 20, 349, '添加', 'add', 30),
(1157, 20, 349, '修改', 'modify', 40),
(1158, 20, 349, '删除', 'delete', 50),
(1159, 20, 349, '启用/禁用', 'status', 60),
(1160, 20, 349, '评论', 'comment', 80),
(1161, 20, 349, '编辑', 'set', 20),
(1162, 20, 349, '扩展', 'ext', 70),
(1163, 20, 350, '查看', 'list', 10),
(1164, 20, 350, '添加', 'add', 30),
(1165, 20, 350, '修改', 'modify', 40),
(1166, 20, 350, '删除', 'delete', 50),
(1167, 20, 350, '启用/禁用', 'status', 60),
(1168, 20, 351, '查看', 'list', 10),
(1169, 20, 351, '添加', 'add', 30),
(1170, 20, 351, '修改', 'modify', 40),
(1171, 20, 351, '删除', 'delete', 50),
(1172, 20, 351, '启用/禁用', 'status', 60),
(1173, 20, 352, '查看', 'list', 10),
(1174, 20, 352, '编辑', 'set', 20),
(1175, 20, 353, '查看', 'list', 10),
(1176, 20, 353, '编辑', 'set', 20),
(1177, 20, 354, '查看', 'list', 10),
(1178, 20, 354, '编辑', 'set', 20),
(1179, 20, 355, '查看', 'list', 10),
(1180, 20, 355, '编辑', 'set', 20),
(1181, 20, 356, '查看', 'list', 10),
(1182, 20, 356, '编辑', 'set', 20),
(1183, 20, 356, '添加', 'add', 30),
(1184, 20, 356, '修改', 'modify', 40),
(1185, 20, 356, '删除', 'delete', 50),
(1186, 20, 356, '启用/禁用', 'status', 60),
(1187, 20, 357, '查看', 'list', 10),
(1188, 20, 357, '添加', 'add', 30),
(1189, 20, 357, '修改', 'modify', 40),
(1190, 20, 357, '删除', 'delete', 50),
(1191, 20, 357, '启用/禁用', 'status', 60),
(1192, 20, 358, '查看', 'list', 10),
(1193, 20, 358, '添加', 'add', 30),
(1194, 20, 358, '修改', 'modify', 40),
(1195, 20, 358, '删除', 'delete', 50),
(1196, 20, 358, '启用/禁用', 'status', 60),
(1197, 20, 358, '编辑', 'set', 20),
(1198, 20, 359, '查看', 'list', 10),
(1199, 20, 359, '编辑', 'set', 20),
(1200, 20, 359, '添加', 'add', 30),
(1201, 20, 359, '修改', 'modify', 40),
(1202, 20, 359, '删除', 'delete', 50),
(1203, 20, 359, '启用/禁用', 'status', 60),
(1204, 20, 360, '查看', 'list', 10),
(1205, 20, 360, '编辑', 'set', 20),
(1206, 20, 360, '添加', 'add', 30),
(1207, 20, 360, '修改', 'modify', 40),
(1208, 20, 360, '删除', 'delete', 50),
(1209, 20, 360, '启用/禁用', 'status', 60),
(1210, 20, 361, '查看', 'list', 10),
(1211, 20, 361, '编辑', 'set', 20),
(1212, 20, 361, '添加', 'add', 30),
(1213, 20, 361, '修改', 'modify', 40),
(1214, 20, 361, '删除', 'delete', 50),
(1215, 20, 361, '启用/禁用', 'status', 60),
(1216, 20, 362, '编辑', 'set', 20),
(1217, 20, 362, '查看', 'list', 10),
(1218, 20, 363, '查看', 'list', 10),
(1219, 20, 363, '编辑', 'set', 20),
(1220, 20, 364, '查看', 'list', 10),
(1221, 20, 364, '编辑', 'set', 20),
(1222, 20, 364, '添加', 'add', 30),
(1223, 20, 364, '修改', 'modify', 40),
(1224, 20, 364, '删除', 'delete', 50),
(1225, 20, 364, '启用/禁用', 'status', 60),
(1307, 20, 87, '编辑', 'set', 20),
(1308, 20, 87, '扩展', 'ext', 70),
(1309, 20, 87, '评论', 'comment', 80),
(1310, 20, 45, '编辑', 'set', 20),
(1311, 20, 45, '扩展', 'ext', 70),
(1312, 20, 45, '评论', 'comment', 80),
(1345, 34, 0, '取消', 'cancel', 70),
(1346, 34, 0, '结束', 'stop', 80),
(1347, 34, 0, '完成', 'end', 90),
(1364, 88, 0, '查看', 'list', 10),
(1365, 88, 0, '添加', 'add', 20),
(1366, 88, 0, '修改', 'modify', 30),
(1367, 88, 0, '删除', 'delete', 40),
(1400, 92, 0, '查看', 'list', 10),
(1401, 92, 0, '生成', 'save', 20),
(1402, 92, 0, '删除', 'delete', 30),
(1403, 95, 0, '查看', 'list', 10),
(1404, 95, 0, '安装', 'install', 20),
(1405, 95, 0, '卸载', 'uninstall', 30),
(1406, 95, 0, '配置', 'setting', 15),
(1407, 95, 0, '远程获取', 'remote', 40),
(1426, 20, 389, '查看', 'list', 10),
(1427, 20, 389, '编辑', 'set', 20),
(1428, 20, 389, '添加', 'add', 30),
(1429, 20, 389, '修改', 'modify', 40),
(1430, 20, 389, '删除', 'delete', 50),
(1431, 20, 389, '启用/禁用', 'status', 60),
(1432, 20, 389, '扩展', 'ext', 70),
(1433, 20, 389, '评论', 'comment', 80),
(1434, 98, 0, '设置', 'setting', 10),
(1854, 121, 0, '删除', 'delete', 30),
(1853, 121, 0, '设置', 'setting', 20),
(1852, 121, 0, '查看', 'list', 10),
(1443, 20, 392, '查看', 'list', 10),
(1444, 20, 392, '添加', 'add', 30),
(1445, 20, 392, '修改', 'modify', 40),
(1446, 20, 392, '删除', 'delete', 50),
(1447, 20, 392, '启用/禁用', 'status', 60),
(1448, 20, 393, '查看', 'list', 10),
(1449, 20, 393, '添加', 'add', 30),
(1450, 20, 393, '修改', 'modify', 40),
(1451, 20, 393, '删除', 'delete', 50),
(1452, 20, 393, '启用/禁用', 'status', 60),
(1453, 20, 394, '查看', 'list', 10),
(1454, 20, 394, '添加', 'add', 30),
(1455, 20, 394, '修改', 'modify', 40),
(1456, 20, 394, '删除', 'delete', 50),
(1457, 20, 394, '启用/禁用', 'status', 60),
(1458, 20, 394, '评论', 'comment', 80),
(1459, 20, 394, '编辑', 'set', 20),
(1460, 20, 394, '扩展', 'ext', 70),
(1461, 20, 395, '查看', 'list', 10),
(1462, 20, 395, '添加', 'add', 30),
(1463, 20, 395, '修改', 'modify', 40),
(1464, 20, 395, '删除', 'delete', 50),
(1465, 20, 395, '启用/禁用', 'status', 60),
(1466, 20, 395, '编辑', 'set', 20),
(1467, 20, 395, '扩展', 'ext', 70),
(1468, 20, 395, '评论', 'comment', 80),
(1469, 20, 396, '查看', 'list', 10),
(1470, 20, 396, '添加', 'add', 30),
(1471, 20, 396, '修改', 'modify', 40),
(1472, 20, 396, '删除', 'delete', 50),
(1473, 20, 396, '启用/禁用', 'status', 60),
(1474, 20, 396, '编辑', 'set', 20),
(1475, 20, 396, '扩展', 'ext', 70),
(1476, 20, 396, '评论', 'comment', 80),
(1477, 20, 397, '查看', 'list', 10),
(1478, 20, 397, '添加', 'add', 30),
(1479, 20, 397, '修改', 'modify', 40),
(1480, 20, 397, '删除', 'delete', 50),
(1481, 20, 397, '启用/禁用', 'status', 60),
(1482, 20, 398, '查看', 'list', 10),
(1483, 20, 398, '添加', 'add', 30),
(1484, 20, 398, '修改', 'modify', 40),
(1485, 20, 398, '删除', 'delete', 50),
(1486, 20, 398, '启用/禁用', 'status', 60),
(1487, 20, 398, '编辑', 'set', 20),
(1488, 20, 399, '查看', 'list', 10),
(1489, 20, 399, '编辑', 'set', 20),
(1490, 20, 399, '添加', 'add', 30),
(1491, 20, 399, '修改', 'modify', 40),
(1492, 20, 399, '删除', 'delete', 50),
(1493, 20, 399, '启用/禁用', 'status', 60),
(1494, 20, 400, '查看', 'list', 10),
(1495, 20, 400, '编辑', 'set', 20),
(1496, 20, 400, '添加', 'add', 30),
(1497, 20, 400, '修改', 'modify', 40),
(1498, 20, 400, '删除', 'delete', 50),
(1499, 20, 400, '启用/禁用', 'status', 60),
(1500, 20, 401, '查看', 'list', 10),
(1501, 20, 401, '编辑', 'set', 20),
(1502, 20, 402, '查看', 'list', 10),
(1503, 20, 402, '编辑', 'set', 20),
(1504, 20, 402, '添加', 'add', 30),
(1505, 20, 402, '修改', 'modify', 40),
(1506, 20, 402, '删除', 'delete', 50),
(1507, 20, 402, '启用/禁用', 'status', 60),
(1508, 20, 403, '查看', 'list', 10),
(1509, 20, 403, '编辑', 'set', 20),
(1510, 20, 403, '添加', 'add', 30),
(1511, 20, 403, '修改', 'modify', 40),
(1512, 20, 403, '删除', 'delete', 50),
(1513, 20, 403, '启用/禁用', 'status', 60),
(1514, 20, 404, '查看', 'list', 10),
(1515, 20, 404, '编辑', 'set', 20),
(1516, 20, 404, '添加', 'add', 30),
(1517, 20, 404, '修改', 'modify', 40),
(1518, 20, 404, '删除', 'delete', 50),
(1519, 20, 404, '启用/禁用', 'status', 60),
(1520, 20, 404, '扩展', 'ext', 70),
(1521, 20, 404, '评论', 'comment', 80),
(1522, 20, 405, '查看', 'list', 10),
(1523, 20, 405, '编辑', 'set', 20),
(1524, 20, 405, '添加', 'add', 30),
(1525, 20, 405, '修改', 'modify', 40),
(1526, 20, 405, '删除', 'delete', 50),
(1527, 20, 405, '启用/禁用', 'status', 60),
(1528, 20, 405, '扩展', 'ext', 70),
(1529, 20, 405, '评论', 'comment', 80),
(1530, 20, 406, '查看', 'list', 10),
(1531, 20, 406, '编辑', 'set', 20),
(1532, 20, 406, '添加', 'add', 30),
(1533, 20, 406, '修改', 'modify', 40),
(1534, 20, 406, '删除', 'delete', 50),
(1535, 20, 406, '启用/禁用', 'status', 60),
(1536, 20, 406, '扩展', 'ext', 70),
(1537, 20, 406, '评论', 'comment', 80),
(1538, 20, 407, '查看', 'list', 10),
(1539, 20, 407, '添加', 'add', 30),
(1540, 20, 407, '修改', 'modify', 40),
(1541, 20, 407, '删除', 'delete', 50),
(1542, 20, 407, '启用/禁用', 'status', 60),
(1543, 20, 408, '查看', 'list', 10),
(1544, 20, 408, '添加', 'add', 30),
(1545, 20, 408, '修改', 'modify', 40),
(1546, 20, 408, '删除', 'delete', 50),
(1547, 20, 408, '启用/禁用', 'status', 60),
(1548, 20, 409, '查看', 'list', 10),
(1549, 20, 409, '添加', 'add', 30),
(1550, 20, 409, '修改', 'modify', 40),
(1551, 20, 409, '删除', 'delete', 50),
(1552, 20, 409, '启用/禁用', 'status', 60),
(1553, 20, 409, '评论', 'comment', 80),
(1554, 20, 409, '编辑', 'set', 20),
(1555, 20, 409, '扩展', 'ext', 70),
(1556, 20, 410, '查看', 'list', 10),
(1557, 20, 410, '添加', 'add', 30),
(1558, 20, 410, '修改', 'modify', 40),
(1559, 20, 410, '删除', 'delete', 50),
(1560, 20, 410, '启用/禁用', 'status', 60),
(1561, 20, 410, '编辑', 'set', 20),
(1562, 20, 410, '扩展', 'ext', 70),
(1563, 20, 410, '评论', 'comment', 80),
(1564, 20, 411, '查看', 'list', 10),
(1565, 20, 411, '添加', 'add', 30),
(1566, 20, 411, '修改', 'modify', 40),
(1567, 20, 411, '删除', 'delete', 50),
(1568, 20, 411, '启用/禁用', 'status', 60),
(1569, 20, 411, '编辑', 'set', 20),
(1570, 20, 411, '扩展', 'ext', 70),
(1571, 20, 411, '评论', 'comment', 80),
(1572, 20, 412, '查看', 'list', 10),
(1573, 20, 412, '添加', 'add', 30),
(1574, 20, 412, '修改', 'modify', 40),
(1575, 20, 412, '删除', 'delete', 50),
(1576, 20, 412, '启用/禁用', 'status', 60),
(1577, 20, 413, '查看', 'list', 10),
(1578, 20, 413, '添加', 'add', 30),
(1579, 20, 413, '修改', 'modify', 40),
(1580, 20, 413, '删除', 'delete', 50),
(1581, 20, 413, '启用/禁用', 'status', 60),
(1582, 20, 413, '编辑', 'set', 20),
(1583, 20, 414, '查看', 'list', 10),
(1584, 20, 414, '编辑', 'set', 20),
(1585, 20, 414, '添加', 'add', 30),
(1586, 20, 414, '修改', 'modify', 40),
(1587, 20, 414, '删除', 'delete', 50),
(1588, 20, 414, '启用/禁用', 'status', 60),
(1589, 20, 415, '查看', 'list', 10),
(1590, 20, 415, '编辑', 'set', 20),
(1591, 20, 415, '添加', 'add', 30),
(1592, 20, 415, '修改', 'modify', 40),
(1593, 20, 415, '删除', 'delete', 50),
(1594, 20, 415, '启用/禁用', 'status', 60),
(1595, 20, 416, '查看', 'list', 10),
(1596, 20, 416, '编辑', 'set', 20),
(1597, 20, 417, '查看', 'list', 10),
(1598, 20, 417, '编辑', 'set', 20),
(1599, 20, 417, '添加', 'add', 30),
(1600, 20, 417, '修改', 'modify', 40),
(1601, 20, 417, '删除', 'delete', 50),
(1602, 20, 417, '启用/禁用', 'status', 60),
(1603, 20, 418, '查看', 'list', 10),
(1604, 20, 418, '编辑', 'set', 20),
(1605, 20, 418, '添加', 'add', 30),
(1606, 20, 418, '修改', 'modify', 40),
(1607, 20, 418, '删除', 'delete', 50),
(1608, 20, 418, '启用/禁用', 'status', 60),
(1609, 20, 419, '查看', 'list', 10),
(1610, 20, 419, '编辑', 'set', 20),
(1611, 20, 419, '添加', 'add', 30),
(1612, 20, 419, '修改', 'modify', 40),
(1613, 20, 419, '删除', 'delete', 50),
(1614, 20, 419, '启用/禁用', 'status', 60),
(1615, 20, 419, '扩展', 'ext', 70),
(1616, 20, 419, '评论', 'comment', 80),
(1617, 20, 420, '查看', 'list', 10),
(1618, 20, 420, '编辑', 'set', 20),
(1619, 20, 420, '添加', 'add', 30),
(1620, 20, 420, '修改', 'modify', 40),
(1621, 20, 420, '删除', 'delete', 50),
(1622, 20, 420, '启用/禁用', 'status', 60),
(1623, 20, 420, '扩展', 'ext', 70),
(1624, 20, 420, '评论', 'comment', 80),
(1625, 20, 421, '查看', 'list', 10),
(1626, 20, 421, '编辑', 'set', 20),
(1627, 20, 421, '添加', 'add', 30),
(1628, 20, 421, '修改', 'modify', 40),
(1629, 20, 421, '删除', 'delete', 50),
(1630, 20, 421, '启用/禁用', 'status', 60),
(1631, 20, 421, '扩展', 'ext', 70),
(1632, 20, 421, '评论', 'comment', 80),
(1748, 95, 0, '文件查看', 'filelist', 50),
(1749, 95, 0, '文件编辑', 'fedit', 60),
(1756, 105, 0, '查看', 'list', 10),
(1757, 105, 0, '添加', 'add', 20),
(1758, 105, 0, '编辑', 'edit', 30),
(1759, 105, 0, '上传', 'upload', 40),
(1760, 105, 0, '删除', 'delete', 50),
(1771, 107, 0, '查看', 'list', 10),
(1772, 107, 0, '设置', 'setting', 20),
(1773, 108, 0, '查看', 'list', 10),
(1774, 108, 0, '添加', 'add', 20),
(1775, 108, 0, '修改', 'modify', 30),
(1776, 108, 0, '审核', 'status', 40),
(1777, 108, 0, '删除', 'delete', 50),
(1778, 108, 0, '组管理', 'group', 60),
(1909, 125, 0, '查看', 'list', 10),
(1910, 125, 0, '添加', 'add', 20),
(1911, 125, 0, '修改', 'modify', 30),
(1912, 125, 0, '状态', 'status', 40),
(1913, 125, 0, '删除', 'delete', 50),
(1928, 20, 451, '查看', 'list', 10),
(1929, 20, 451, '编辑', 'set', 20),
(1930, 20, 451, '添加', 'add', 30),
(1931, 20, 451, '修改', 'modify', 40),
(1932, 20, 451, '删除', 'delete', 50),
(1933, 20, 451, '启用/禁用', 'status', 60),
(1934, 20, 451, '扩展', 'ext', 70),
(1935, 20, 451, '评论', 'comment', 80),
(1938, 20, 452, '添加', 'add', 30),
(1939, 20, 452, '修改', 'modify', 40),
(1940, 20, 452, '删除', 'delete', 50),
(1941, 20, 452, '启用/禁用', 'status', 60),
(1942, 20, 452, '扩展', 'ext', 70),
(1943, 20, 452, '评论', 'comment', 80),
(1944, 130, 0, '查看', 'list', 10),
(1945, 130, 0, '删除', 'delete', 10),
(1946, 20, 453, '查看', 'list', 10),
(1947, 20, 453, '编辑', 'set', 20),
(1948, 20, 453, '添加', 'add', 30),
(1949, 20, 453, '修改', 'modify', 40),
(1950, 20, 453, '删除', 'delete', 50),
(1951, 20, 453, '启用/禁用', 'status', 60),
(1952, 20, 453, '扩展', 'ext', 70),
(1953, 20, 453, '评论', 'comment', 80),
(1971, 132, 0, '删除', 'delete', 40),
(1970, 132, 0, '检测', 'checking', 30),
(1969, 132, 0, '配置', 'setting', 20),
(1968, 132, 0, '查看', 'list', 10);

CREATE TABLE IF NOT EXISTS `qinggan_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID，也是应用ID',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '上一级ID',
  `site_id` mediumint(8) unsigned NOT NULL COMMENT '网站ID',
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '指定模型ID，为0表页面空白',
  `cate` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '绑定根分类ID',
  `title` varchar(255) NOT NULL COMMENT '名称',
  `nick_title` varchar(255) NOT NULL COMMENT '后台别称',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，值越小越往前靠',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不使用1使用',
  `tpl_index` varchar(255) NOT NULL COMMENT '封面页',
  `tpl_list` varchar(255) NOT NULL COMMENT '列表页',
  `tpl_content` varchar(255) NOT NULL COMMENT '详细页',
  `is_identifier` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义标识',
  `ico` varchar(255) NOT NULL COMMENT '图标',
  `orderby` text NOT NULL COMMENT '排序',
  `alias_title` varchar(255) NOT NULL COMMENT '主题别名',
  `alias_note` varchar(255) NOT NULL COMMENT '主题备注',
  `psize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0表示不限制，每页显示数量',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID号，为0表示管理员维护',
  `identifier` varchar(255) NOT NULL COMMENT '标识',
  `seo_title` varchar(255) NOT NULL COMMENT 'SEO标题',
  `seo_keywords` varchar(255) NOT NULL COMMENT 'SEO关键字',
  `seo_desc` varchar(255) NOT NULL COMMENT 'SEO描述',
  `subtopics` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否启用子主题功能',
  `is_search` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否支持搜索',
  `is_tag` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '必填Tag',
  `is_biz` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不启用电商，1启用电商',
  `is_userid` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否绑定会员',
  `is_tpl_content` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否自定义内容模板',
  `is_seo` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否默认使用seo',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '默认货币ID',
  `admin_note` text NOT NULL COMMENT '管理员备注，给编辑人员使用的',
  `hidden` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0显示1隐藏',
  `post_status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '发布模式，0不启用1启用',
  `comment_status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '启用评论功能',
  `post_tpl` varchar(255) NOT NULL COMMENT '发布页模板',
  `etpl_admin` varchar(255) NOT NULL COMMENT '通知管理员邮件模板',
  `etpl_user` varchar(255) NOT NULL COMMENT '发布邮件通知会员模板',
  `etpl_comment_admin` varchar(255) NOT NULL COMMENT '评论邮件通知管理员模板',
  `etpl_comment_user` varchar(255) NOT NULL COMMENT '评论邮件通知会员',
  `is_attr` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1启用主题属性0不启用',
  `tag` varchar(255) NOT NULL COMMENT '自身Tag设置',
  `cate_multiple` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0分类单选1分类支持多选',
  `biz_attr` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '产品属性，0不使用1使用',
  `freight` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '运费模板ID',
  `list_fields` varchar(255) NOT NULL COMMENT '列表读取长度，如为空读全部',
  `style` varchar(255) NOT NULL COMMENT 'CSS样式',
  `is_front` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否直接访问前台',
  `is_api` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0接口不可访问，1可访问',
  `psize_api` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'API接口读取的数量',
  `limit_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发布时间间隔限制，0表示不限制',
  `limit_similar` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '相似度值限制，0表示不限制',
  `is_stock` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '1启用库存，0禁用库存',
  `world_location` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '产品全球价格设置',
  `biz_service` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '1服务0实物',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `site_id` (`site_id`,`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='项目管理器' AUTO_INCREMENT=456 ;

INSERT INTO `qinggan_project` (`id`, `parent_id`, `site_id`, `module`, `cate`, `title`, `nick_title`, `taxis`, `status`, `tpl_index`, `tpl_list`, `tpl_content`, `is_identifier`, `ico`, `orderby`, `alias_title`, `alias_note`, `psize`, `uid`, `identifier`, `seo_title`, `seo_keywords`, `seo_desc`, `subtopics`, `is_search`, `is_tag`, `is_biz`, `is_userid`, `is_tpl_content`, `is_seo`, `currency_id`, `admin_note`, `hidden`, `post_status`, `comment_status`, `post_tpl`, `etpl_admin`, `etpl_user`, `etpl_comment_admin`, `etpl_comment_user`, `is_attr`, `tag`, `cate_multiple`, `biz_attr`, `freight`, `list_fields`, `style`, `is_front`, `is_api`, `psize_api`, `limit_times`, `limit_similar`, `is_stock`, `world_location`, `biz_service`) VALUES
(41, 0, 1, 21, 0, '图片播放器', '', 20, 1, '', '', '', 0, 'images/ico/picplayer.png', 'l.sort ASC,l.dateline DESC,l.id DESC', '', '', 30, 0, 'picture-player', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0),
(43, 0, 1, 22, 7, '资讯中心', '', 12, 1, '', '', '', 1, 'images/ico/article.png', 'l.sort DESC,l.dateline DESC,l.id DESC', '新闻主题', '', 20, 0, 'news', '', '', '', 0, 1, 1, 0, 1, 0, 1, 0, '<p>内容测试看对了吗</p>\r\n', 0, 0, 1, '', '', '', '', 'register_code', 0, '', 0, 0, 0, 'note,thumb', '', 1, 1, 10, 0, 0, 0, 0, 0),
(45, 0, 1, 24, 70, '产品展示', '', 50, 1, '', '', '', 0, 'images/ico/product.png', 'l.sort DESC,l.dateline DESC,l.id DESC', '产品名称', '', 15, 0, 'product', '', '', '', 0, 1, 1, 1, 0, 0, 0, 1, '', 0, 0, 1, '', '', '', '', '', 1, '', 0, 1, 5, '', '', 1, 1, 10, 0, 0, 0, 0, 0),
(87, 0, 1, 40, 0, '关于我们', '', 15, 1, '', '', 'about_content', 2, 'images/ico/about.png', 'l.sort ASC,l.dateline DESC,l.id DESC', '', '', 30, 0, 'about', '', '', '', 0, 0, 1, 0, 0, 1, 2, 0, '', 0, 0, 0, '', '', '', '', '', 0, '公司', 0, 0, 0, '', '', 1, 1, 10, 0, 0, 0, 0, 0),
(96, 0, 1, 46, 0, '在线留言', '', 70, 1, '', '', '', 0, 'images/ico/comment.png', 'l.sort DESC,l.dateline DESC,l.id DESC', '留言主题', '', 30, 0, 'book', '', '', '', 0, 0, 0, 0, 1, 0, 0, 0, '', 0, 1, 1, '', 'project_save', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 10, 30, 80, 0, 0, 0),
(144, 0, 1, 68, 154, '图集相册', '', 90, 1, '', '', '', 0, 'images/ico/photo.png', 'l.sort DESC,l.dateline DESC,l.id DESC', '', '', 30, 0, 'photo', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 1, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0),
(148, 0, 1, 64, 0, '在线客服', '', 130, 1, '', '', '', 0, 'images/ico/qq.png', 'l.sort ASC,l.dateline DESC,l.id DESC', '客服类型', '', 30, 0, 'kefu', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0),
(452, 0, 1, 111, 0, '视频平台', '', 155, 1, '', '', '', 0, 'images/ico/video.png', 'l.sort ASC,l.dateline DESC,l.id DESC', '', '', 30, 0, 'video', '', '', '', 0, 0, 3, 0, 0, 0, 1, 0, '', 0, 0, 0, '', '', '', '', '', 0, '', 0, 0, 0, 'thumb', '', 0, 0, 10, 0, 0, 0, 0, 0),
(151, 0, 1, 65, 197, '下载中心', '', 100, 1, '', 'download_list', 'download_content', 0, 'images/ico/cloud.png', 'l.sort DESC,l.dateline DESC,l.id DESC', '附件名称', '', 30, 0, 'download-center', '', '', '', 0, 1, 0, 0, 0, 0, 0, 0, '', 0, 0, 1, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0),
(152, 0, 1, 66, 201, '论坛BBS', '', 110, 1, 'bbs_index', 'bbs_list', 'bbs_detail', 0, 'images/ico/forum.png', 'ext.toplevel DESC,l.replydate DESC,l.dateline DESC,l.id DESC', '讨论主题', '', 30, 0, 'bbs', '', '', '', 0, 0, 0, 0, 1, 0, 0, 0, '', 0, 1, 1, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 10, 0, 0, 0, 0, 0),
(389, 0, 1, 77, 0, '友情链接', '', 145, 1, '', '', '', 0, 'images/ico/link.png', 'taxis ASC,id DESC', '', '', 30, 0, 'links', '', '', '', 0, 0, 0, 0, 0, 0, 0, 0, '', 0, 0, 0, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 0, 0, 0, 0, 0, 0, 0, 0),
(451, 0, 1, 110, 0, '独立页', '', 150, 1, '', '', 'single', 3, 'images/ico/article.png', 'l.sort ASC,l.dateline DESC,l.id DESC', '', '', 30, 0, 'separate-page', '', '', '', 0, 0, 3, 0, 0, 0, 0, 0, '', 0, 0, 0, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 1, 0, 10, 0, 0, 0, 0, 0),
(453, 0, 1, 112, 0, '专题平台', '', 160, 1, '', '', '', 3, 'images/ico/blog.png', 'l.sort ASC,l.dateline DESC,l.id DESC', '专题名称', '', 30, 0, 'topic', '', '', '', 0, 0, 3, 0, 0, 1, 0, 0, '', 0, 0, 0, '', '', '', '', '', 0, '', 0, 0, 0, '', '', 1, 0, 10, 0, 0, 0, 0, 0);

CREATE TABLE IF NOT EXISTS `qinggan_reply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父回复ID',
  `vouch` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '推荐评论',
  `star` tinyint(1) NOT NULL DEFAULT '3' COMMENT '星级',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `ip` varchar(255) NOT NULL COMMENT '回复人IP',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0未审核1审核',
  `session_id` varchar(255) NOT NULL COMMENT '游客标识',
  `content` text NOT NULL COMMENT '评论内容',
  `admin_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `adm_content` longtext NOT NULL COMMENT '管理员回复内容',
  `adm_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '回复时间',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0为评论，非零绑定订单ID',
  `res` varchar(255) NOT NULL COMMENT '附件ID，多个附件用英文逗号隔开',
  `vtype` varchar(255) NOT NULL DEFAULT 'title' COMMENT '主题类型，titlte表示列表中的主题，project表示项目，cate表示分类',
  `title` varchar(255) NOT NULL COMMENT '评论标题，留空从主题中读取',
  PRIMARY KEY (`id`),
  KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='主题评论表' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_res` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '资源ID',
  `cate_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `folder` varchar(255) NOT NULL COMMENT '存储目录',
  `name` varchar(255) NOT NULL COMMENT '资源文件名',
  `ext` varchar(30) NOT NULL COMMENT '资源后缀，如jpg等',
  `filename` varchar(255) NOT NULL COMMENT '文件名带路径',
  `ico` text NOT NULL COMMENT 'ICO图标文件',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `title` varchar(255) NOT NULL COMMENT '内容',
  `attr` text NOT NULL COMMENT '附件属性',
  `note` text NOT NULL COMMENT '备注',
  `session_id` varchar(100) NOT NULL COMMENT '操作者 ID，即会员ID用于检测是否有权限删除 ',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID，当该ID为时检则sesson_id，如不相同则不能删除 ',
  `download` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下载次数',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `mime_type` varchar(255) NOT NULL COMMENT '附件类型',
  PRIMARY KEY (`id`),
  KEY `ext` (`ext`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='资源ID' AUTO_INCREMENT=174 ;

INSERT INTO `qinggan_res` (`id`, `cate_id`, `folder`, `name`, `ext`, `filename`, `ico`, `addtime`, `title`, `attr`, `note`, `session_id`, `user_id`, `download`, `admin_id`, `mime_type`) VALUES
(93, 1, 'res/202101/09/', 'fdae14ad100d9ab4.jpg', 'jpg', 'res/202101/09/fdae14ad100d9ab4.jpg', 'res/_cache/_ico/93/93.jpg', 1610162087, '001', 'a:2:{s:5:"width";i:491;s:6:"height";i:313;}', '', '', 0, 0, 1, 'image/jpeg'),
(91, 1, 'res/202101/08/', '178ddf492d93f2c3.jpg', 'jpg', 'res/202101/08/178ddf492d93f2c3.jpg', 'res/_cache/_ico/91/91.jpg', 1610091274, '地图', 'a:2:{s:5:"width";i:887;s:6:"height";i:488;}', '', '', 0, 0, 1, 'image/jpeg'),
(85, 1, 'res/202101/08/', 'a9184c516ad57761.png', 'png', 'res/202101/08/a9184c516ad57761.png', 'res/_cache/_ico/85/85.png', 1610070234, 'logo', 'a:2:{s:5:"width";i:645;s:6:"height";i:135;}', '', '', 0, 0, 1, 'image/png'),
(86, 1, 'res/202101/08/', '1af887bfb2b0f7dc.png', 'png', 'res/202101/08/1af887bfb2b0f7dc.png', 'res/_cache/_ico/86/86.png', 1610070260, '108', 'a:2:{s:5:"width";i:108;s:6:"height";i:108;}', '', '', 0, 0, 1, 'image/png'),
(87, 1, 'res/202101/08/', '47133f4c14c897f7.jpg', 'jpg', 'res/202101/08/47133f4c14c897f7.jpg', 'res/_cache/_ico/87/87.jpg', 1610076986, 'banner2', 'a:2:{s:5:"width";i:1920;s:6:"height";i:500;}', '', '', 0, 0, 1, 'image/jpeg'),
(88, 1, 'res/202101/08/', '1d21a6ff5dec480b.jpg', 'jpg', 'res/202101/08/1d21a6ff5dec480b.jpg', 'res/_cache/_ico/88/88.jpg', 1610077025, 'banner1', 'a:2:{s:5:"width";i:1920;s:6:"height";i:500;}', '', '', 0, 0, 1, 'image/jpeg'),
(89, 1, 'res/202101/08/', '847cd6b34b187b9d.jpg', 'jpg', 'res/202101/08/847cd6b34b187b9d.jpg', 'res/_cache/_ico/89/89.jpg', 1610077047, 'banner3', 'a:2:{s:5:"width";i:1920;s:6:"height";i:500;}', '', '', 0, 0, 1, 'image/jpeg'),
(29, 1, 'res/202010/09/', 'dfffccef4d5241d5.png', 'png', 'res/202010/09/dfffccef4d5241d5.png', 'res/_cache/_ico/29/29.png', 1602253010, 'ia_10011', 'a:2:{s:5:"width";i:800;s:6:"height";i:800;}', '', '', 0, 0, 1, 'image/png'),
(75, 1, 'res/202010/10/', 'b3797e20497c2267.jpg', 'jpg', 'res/202010/10/b3797e20497c2267.jpg', 'res/_cache/_ico/75/75.jpg', 1602313326, 'ia2_10002', 'a:2:{s:5:"width";i:800;s:6:"height";i:800;}', '', '', 0, 0, 1, 'image/jpeg'),
(76, 1, 'res/202010/10/', '8512accd55d5675f.jpg', 'jpg', 'res/202010/10/8512accd55d5675f.jpg', 'res/_cache/_ico/76/76.jpg', 1602313896, '图片', 'a:2:{s:5:"width";i:517;s:6:"height";i:387;}', '', '', 0, 0, 1, 'image/jpeg'),
(74, 1, 'res/202010/10/', '3c71e26c622c9791.jpg', 'jpg', 'res/202010/10/3c71e26c622c9791.jpg', 'res/_cache/_ico/74/74.jpg', 1602312807, '硕黑', 'a:2:{s:5:"width";i:1080;s:6:"height";i:1080;}', '', '', 0, 0, 1, 'image/jpeg'),
(47, 1, 'res/202010/10/', '73e2b5b566c855bf.jpg', 'jpg', 'res/202010/10/73e2b5b566c855bf.jpg', 'res/_cache/_ico/47/47.jpg', 1602264299, '1', 'a:2:{s:5:"width";i:1000;s:6:"height";i:1000;}', '', '', 0, 0, 1, 'image/jpeg'),
(48, 1, 'res/202010/10/', '038a602f56d8fc91.jpg', 'jpg', 'res/202010/10/038a602f56d8fc91.jpg', 'res/_cache/_ico/48/48.jpg', 1602265843, '1', 'a:2:{s:5:"width";s:4:"1024";s:6:"height";i:1024;}', '', '', 0, 0, 1, 'image/jpeg'),
(55, 1, 'res/202010/10/', '2a6ee460dd6f0c4f.jpg', 'jpg', 'res/202010/10/2a6ee460dd6f0c4f.jpg', 'res/_cache/_ico/55/55.jpg', 1602266214, '1', 'a:2:{s:5:"width";i:800;s:6:"height";i:800;}', '', '', 0, 0, 1, 'image/jpeg'),
(77, 1, 'res/202010/10/', '6c4b71ae156dd4dd.jpg', 'jpg', 'res/202010/10/6c4b71ae156dd4dd.jpg', 'res/_cache/_ico/77/77.jpg', 1602314011, 'window-95', 'a:2:{s:5:"width";i:705;s:6:"height";i:396;}', '', '', 0, 0, 1, 'image/jpeg'),
(94, 1, 'res/202101/09/', '240c0161ee607f0e.png', 'png', 'res/202101/09/240c0161ee607f0e.png', 'res/_cache/_ico/94/94.png', 1610171846, '108', 'a:2:{s:5:"width";i:108;s:6:"height";i:108;}', '', 'lt9n3p5b5s5b39471k7jc72gq3', 0, 0, 0, 'image/png'),
(99, 1, 'res/202101/09/', '0481f02b0244c3c2.jpg', 'jpg', 'res/202101/09/0481f02b0244c3c2.jpg', 'res/_cache/_ico/99/99.jpg', 1610172116, '001', 'a:2:{s:5:"width";i:491;s:6:"height";i:313;}', '', 'lt9n3p5b5s5b39471k7jc72gq3', 0, 0, 0, 'image/jpeg'),
(100, 1, 'res/202101/09/', '0d0792fc40d8b2f9.jpg', 'jpg', 'res/202101/09/0d0792fc40d8b2f9.jpg', 'res/_cache/_ico/10/100.jpg', 1610172132, '001', 'a:2:{s:5:"width";i:491;s:6:"height";i:313;}', '', 'lt9n3p5b5s5b39471k7jc72gq3', 0, 0, 0, 'image/jpeg'),
(112, 1, 'res/202101/11/', 'c3022a336691e367.jpg', 'jpg', 'res/202101/11/c3022a336691e367.jpg', 'res/_cache/_ico/11/112.jpg', 1610368565, 'video-bg1', 'a:2:{s:5:"width";i:585;s:6:"height";i:585;}', '', '', 0, 0, 1, 'image/jpeg'),
(113, 1, 'res/202101/11/', 'b58fb3e2479f7faa.png', 'png', 'res/202101/11/b58fb3e2479f7faa.png', 'res/_cache/_ico/11/113.png', 1610373796, '支付宝', 'a:2:{s:5:"width";i:80;s:6:"height";i:80;}', '', '', 0, 0, 1, 'image/png'),
(140, 1, 'res/202103/02/', 'e7b4b7a520aed6b3.png', 'png', 'res/202103/02/e7b4b7a520aed6b3.png', 'res/_cache/_ico/14/140.png', 1614653892, 'pp-logo-100px', 'a:2:{s:5:"width";i:100;s:6:"height";i:26;}', '', '', 0, 0, 1, 'image/png');

CREATE TABLE IF NOT EXISTS `qinggan_res_cate` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '资源分类ID',
  `title` varchar(255) NOT NULL COMMENT '分类名称',
  `root` varchar(255) NOT NULL DEFAULT '/' COMMENT '存储目录',
  `folder` varchar(255) NOT NULL DEFAULT 'Ym/d/' COMMENT '存储目录格式',
  `is_default` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1默认0非默认',
  `filetypes` varchar(255) NOT NULL COMMENT '附件类型',
  `typeinfo` varchar(200) NOT NULL COMMENT '类型说明',
  `gdtypes` varchar(255) NOT NULL COMMENT '支持的GD方案，多个GD方案用英文ID分开',
  `gdall` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1支持全部GD方案0仅支持指定的GD方案',
  `ico` tinyint(1) NOT NULL DEFAULT '0' COMMENT '后台缩略图',
  `filemax` int(10) unsigned NOT NULL DEFAULT '2' COMMENT '上传文件大小限制',
  `etype` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0本地存储，其他数据则调用不同的网关存储',
  `upload_binary` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0传统上传，1二进制上传',
  `compress` int(11) NOT NULL DEFAULT '0' COMMENT '0不压缩，大于0的数值表示宽高超过时就压缩到这个值内',
  `is_front` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0前台不可用，1前台可用',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='资源分类存储' AUTO_INCREMENT=33 ;

INSERT INTO `qinggan_res_cate` (`id`, `title`, `root`, `folder`, `is_default`, `filetypes`, `typeinfo`, `gdtypes`, `gdall`, `ico`, `filemax`, `etype`, `upload_binary`, `compress`, `is_front`) VALUES
(1, '图片', 'res/', 'Ym/d/', 1, 'png,jpg,gif,jpeg', '图片', '', 1, 1, 2000, 0, 0, 0, 0),
(11, '压缩软件', 'res/soft/', 'Y/', 0, 'rar,zip', '压缩包', '', 0, 0, 2000, 0, 0, 0, 0),
(20, 'Excel', 'res/excel/', '', 0, 'xls,xlsx', 'Excel文件', '', 0, 1, 2048, 0, 0, 0, 0),
(24, '视频', 'res/', 'Ym/d/', 0, 'mp4,mpeg,webm', '视频', '', 0, 1, 2048000, 0, 0, 0, 1),
(29, '证书文件', 'res/pem/', '', 0, 'pem', 'PEM证书', '', 0, 1, 300, 0, 0, 0, 0);

CREATE TABLE IF NOT EXISTS `qinggan_search` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID',
  `title` varchar(255) CHARACTER SET utf8 NOT NULL COMMENT '关键字',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后一次执行时间',
  `hits` int(11) NOT NULL DEFAULT '0' COMMENT '搜索次数',
  `sign` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0未标记，1已标记',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`,`title`)
) ENGINE=MyISAM  DEFAULT CHARSET=gbk COMMENT='搜索数据统计' AUTO_INCREMENT=8 ;

INSERT INTO `qinggan_search` (`id`, `site_id`, `title`, `dateline`, `hits`, `sign`) VALUES
(3, 1, '网站地图', 1613671253, 1, 1),
(4, 1, '微信', 1613671253, 1, 1),
(5, 1, 'PHPOK5.6', 1613671253, 1, 1),
(6, 1, '小程序', 1613671253, 1, 1),
(7, 1, '分类管理', 1613671253, 1, 1);

CREATE TABLE IF NOT EXISTS `qinggan_session` (
  `id` varchar(32) NOT NULL COMMENT 'session_id',
  `data` varchar(20485) NOT NULL COMMENT 'session 内容，最多只能放20K',
  `lasttime` int(10) unsigned NOT NULL COMMENT '时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='SESSION操作';

CREATE TABLE IF NOT EXISTS `qinggan_site` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '应用ID',
  `domain_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '默认域名ID',
  `title` varchar(255) NOT NULL COMMENT '网站名称',
  `dir` varchar(255) NOT NULL DEFAULT '/' COMMENT '安装目录，以/结尾',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `content` text NOT NULL COMMENT '网站关闭原因',
  `is_default` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1默认站点',
  `tpl_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '模板ID',
  `url_type` enum('default','rewrite','html') NOT NULL DEFAULT 'default' COMMENT '默认，即带?等能数，rewrite是伪静态页，html为生成的静态页',
  `logo` varchar(255) NOT NULL COMMENT '网站 LOGO ',
  `meta` text NOT NULL COMMENT '扩展配置',
  `currency_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '默认货币ID',
  `register_status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0关闭注册1开启注册',
  `register_close` varchar(255) NOT NULL COMMENT '关闭注册说明',
  `login_status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0关闭登录1开启',
  `login_close` varchar(255) NOT NULL COMMENT '关闭登录说明',
  `adm_logo29` varchar(255) NOT NULL COMMENT '在后台左侧LOGO地址',
  `adm_logo180` varchar(255) NOT NULL COMMENT '登录LOGO地址',
  `lang` varchar(255) NOT NULL COMMENT '语言包',
  `api` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0不走接口',
  `api_code` varchar(255) NOT NULL COMMENT 'API验证串',
  `seo_title` varchar(255) NOT NULL COMMENT 'SEO主题',
  `seo_keywords` varchar(255) NOT NULL COMMENT 'SEO关键字',
  `seo_desc` text NOT NULL COMMENT 'SEO摘要',
  `biz_sn` varchar(255) NOT NULL COMMENT '订单号生成规则',
  `biz_payment` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '默认支付方式',
  `upload_guest` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '游客上传权限',
  `upload_user` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '会员上传权限',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='网站管理' AUTO_INCREMENT=4 ;

INSERT INTO `qinggan_site` (`id`, `domain_id`, `title`, `dir`, `status`, `content`, `is_default`, `tpl_id`, `url_type`, `logo`, `meta`, `currency_id`, `register_status`, `register_close`, `login_status`, `login_close`, `adm_logo29`, `adm_logo180`, `lang`, `api`, `api_code`, `seo_title`, `seo_keywords`, `seo_desc`, `biz_sn`, `biz_payment`, `upload_guest`, `upload_user`) VALUES
(1, 1, '锟铻科技', '/phpok/', 1, '网站关闭测试', 1, 1, 'default', 'res/202101/08/a9184c516ad57761.png', '', 1, 1, '暂停平台注册功能', 1, '暂停平台会员登录', '', '', 'cn', 0, 'py%b0d~!8~6xz5mf', '网站建设_企业网站建设_PHPOK网站建设_PHPOK企业网站建设', '网站建设,企业网站建设,PHPOK网站建设,PHPOK企业网站建设', '高效的企业网站建设系统，可实现高定制化的企业网站电商系统，实现企业网站到电子商务企业网站。定制功能更高，操作更简单！', 'prefix[P]-year-month-date-rand-user-number', 0, 1, 1);

CREATE TABLE IF NOT EXISTS `qinggan_site_domain` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `site_id` mediumint(8) unsigned NOT NULL COMMENT '网站ID',
  `domain` varchar(255) NOT NULL COMMENT '域名信息',
  `is_mobile` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1此域名强制为手机版',
  PRIMARY KEY (`id`),
  KEY `site_id` (`site_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='网站指定的域名' AUTO_INCREMENT=4 ;

INSERT INTO `qinggan_site_domain` (`id`, `site_id`, `domain`, `is_mobile`) VALUES
(1, 1, 'localhost', 0);

CREATE TABLE IF NOT EXISTS `qinggan_sysmenu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID号',
  `parent_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID，0为根菜单',
  `title` varchar(100) NOT NULL COMMENT '分类名称',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态0禁用1正常',
  `appfile` varchar(100) NOT NULL COMMENT '应用文件名，放在phpok/admin/目录下，记录不带.php',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，值越小越往前靠，可选0-255',
  `func` varchar(100) NOT NULL COMMENT '应用函数，为空使用index',
  `identifier` varchar(100) NOT NULL COMMENT '标识串，用于区分同一应用文件的不同内容',
  `ext` varchar(255) NOT NULL COMMENT '表单扩展',
  `if_system` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0常规项目，1系统项目',
  `site_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '0表示全局网站',
  `icon` varchar(255) NOT NULL COMMENT '图标路径',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='PHPOK后台系统菜单' AUTO_INCREMENT=133 ;

INSERT INTO `qinggan_sysmenu` (`id`, `parent_id`, `title`, `status`, `appfile`, `taxis`, `func`, `identifier`, `ext`, `if_system`, `site_id`, `icon`) VALUES
(1, 0, '设置', 1, 'setting', 50, '', '', '', 1, 0, ''),
(2, 0, '商务', 1, '', 20, '', '', '', 1, 0, ''),
(3, 0, '会员', 1, 'user', 30, '', '', '', 0, 0, ''),
(4, 0, '工具', 1, 'tool', 40, '', '', '', 0, 0, ''),
(5, 0, '内容', 1, 'index', 10, '', '', '', 0, 0, ''),
(6, 1, '表单选项', 1, 'opt', 30, '', '', '', 0, 0, ''),
(7, 4, '字段维护', 1, 'fields', 20, '', '', '', 0, 0, ''),
(8, 1, '模块管理', 1, 'module', 20, '', '', '', 0, 0, 'newtab'),
(9, 1, '核心配置', 1, 'system', 50, '', '', '', 1, 0, ''),
(13, 3, '会员列表', 1, 'user', 10, '', '', '', 0, 0, 'newtab'),
(14, 3, '会员组', 1, 'usergroup', 20, '', '', '', 0, 0, ''),
(16, 4, '插件中心', 1, 'plugin', 30, '', '', '', 0, 0, 'newtab'),
(18, 5, '分类管理', 1, 'cate', 30, '', '', '', 0, 0, 'folder'),
(19, 5, '全局内容', 1, 'all', 10, '', '', '', 0, 0, ''),
(20, 5, '内容管理', 1, 'list', 20, '', '', '', 0, 0, ''),
(22, 5, '资源管理', 1, 'res', 60, '', '', '', 0, 0, 'attachment'),
(23, 5, '数据调用', 1, 'call', 40, '', '', '', 0, 0, ''),
(25, 3, '会员字段', 1, 'user', 30, 'fields', '', '', 0, 0, ''),
(27, 1, '项目管理', 1, 'project', 10, '', '', '', 0, 0, 'newtab'),
(28, 4, '通知模板', 1, 'email', 40, '', '', '', 0, 0, ''),
(29, 1, '管理员维护', 1, 'admin', 80, '', '', '', 0, 0, ''),
(30, 1, '风格管理', 1, 'tpl', 60, '', '', '', 0, 0, ''),
(31, 1, '站点管理', 1, 'site', 90, '', '', '', 0, 0, ''),
(32, 5, '评论管理', 1, 'reply', 50, '', '', '', 0, 0, ''),
(33, 2, '货币及汇率', 1, 'currency', 30, '', '', '', 0, 0, ''),
(34, 2, '订单管理', 1, 'order', 10, '', '', '', 0, 0, 'newtab'),
(45, 4, '程序升级', 1, 'update', 10, '', '', '', 0, 0, 'newtab'),
(52, 2, '付款方案', 1, 'payment', 20, '', '', '', 0, 0, ''),
(57, 1, '数据库管理', 1, 'sql', 100, '', '', '', 0, 0, ''),
(58, 5, '标签管理', 1, 'tag', 70, '', '', '', 0, 0, 'tags'),
(59, 1, '伪静态页规则', 1, 'rewrite', 70, '', '', '', 0, 0, ''),
(62, 4, '附件分类管理', 1, 'rescate', 120, '', '', '', 0, 0, ''),
(63, 4, '图片规格方案', 1, 'gd', 130, '', '', '', 0, 0, ''),
(66, 3, '财富方案', 1, 'wealth', 40, '', '', '', 0, 0, ''),
(67, 2, '商品属性', 1, 'options', 40, '', '', '', 0, 0, ''),
(68, 2, '运费模板', 1, 'freight', 50, '', '', '', 0, 0, ''),
(77, 2, '物流快递', 1, 'express', 50, '', '', '', 0, 0, ''),
(78, 4, '网关路由', 1, 'gateway', 110, '', '', '', 0, 0, ''),
(80, 4, '计划任务', 1, 'task', 140, '', '', '', 0, 0, ''),
(87, 1, '日志', 1, 'log', 110, '', '', '', 0, 1, ''),
(88, 3, '会员地址库', 1, 'address', 50, '', '', '', 0, 1, ''),
(92, 5, '报表统计', 1, 'report', 80, '', '', '', 0, 1, ''),
(95, 1, '应用管理', 1, 'appsys', 115, '', '', '', 0, 1, ''),
(98, 1, '微信小程序', 1, 'wxappconfig', 120, '', '', '', 0, 1, ''),
(105, 5, '文件管理', 1, 'filemanage', 255, '', '', '', 0, 0, 'newtab'),
(107, 5, '脏字过滤', 1, 'dirtywords', 255, '', '', '', 0, 0, 'newtab'),
(108, 5, '菜单导航', 1, 'menu', 90, '', '', '', 0, 1, 'menu'),
(121, 5, '搜索关键字', 1, 'search', 100, '', '', '', 0, 1, 'search'),
(125, 5, '国家管理', 1, 'worlds', 255, '', '', '', 0, 0, ''),
(130, 5, '收藏夹管理', 1, 'fav', 255, '', '', '', 0, 0, 'newtab'),
(132, 5, '安全检测', 1, 'safecheck', 255, '', '', '', 0, 0, 'newtab');

CREATE TABLE IF NOT EXISTS `qinggan_tag` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID',
  `identifier` varchar(255) NOT NULL COMMENT '标识',
  `title` varchar(255) NOT NULL COMMENT '名称',
  `url` varchar(255) NOT NULL COMMENT '关键字网址',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0原窗口打开，1新窗口打开',
  `hits` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击次数',
  `alt` varchar(255) NOT NULL COMMENT '链接里的提示',
  `is_global` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否全局状态1是0否',
  `replace_count` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '替换次数',
  `seo_title` varchar(255) NOT NULL COMMENT 'SEO标题',
  `seo_keywords` varchar(255) NOT NULL COMMENT 'SEO关键字',
  `seo_desc` varchar(255) NOT NULL COMMENT 'SEO描述',
  `tpl` varchar(255) NOT NULL COMMENT '模板名称',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='关键字管理器' AUTO_INCREMENT=19 ;

INSERT INTO `qinggan_tag` (`id`, `site_id`, `identifier`, `title`, `url`, `target`, `hits`, `alt`, `is_global`, `replace_count`, `seo_title`, `seo_keywords`, `seo_desc`, `tpl`) VALUES
(1, 1, '', '服务器', '', 0, 0, '', 0, 0, '', '', '', ''),
(2, 1, '', '并发', '', 0, 0, '', 0, 0, '', '', '', ''),
(3, 1, '', '处理能力', '', 0, 1, '', 0, 0, '', '', '', ''),
(4, 1, '', 'windows 95', '', 0, 0, '', 0, 0, '', '', '', ''),
(5, 1, '', '操作系统', '', 0, 0, '', 0, 0, '', '', '', ''),
(6, 1, '', '浏览器', '', 0, 1, '', 0, 0, '', '', '', ''),
(7, 1, '', 'IE', '', 0, 0, '', 0, 0, '', '', '', ''),
(8, 1, '', 'Chrome', '', 0, 1, '', 0, 0, '', '', '', ''),
(9, 1, '', '代沟', '', 0, 0, '', 0, 0, '', '', '', ''),
(10, 1, '', '大数据', '', 0, 0, '', 0, 0, '', '', '', ''),
(11, 1, '', '知识', '', 0, 0, '', 0, 0, '', '', '', ''),
(12, 1, '', 'phpok', '', 0, 2, '', 0, 0, '', '', '', ''),
(13, 1, '', '升级包', '', 0, 0, '', 0, 0, '', '', '', ''),
(14, 1, '', '公司', '', 0, 1, '', 0, 0, '', '', '', ''),
(15, 1, '', '协议', '', 0, 1, '', 0, 0, '', '', '', ''),
(16, 1, '', '隐私', '', 0, 1, '', 0, 0, '', '', '', ''),
(17, 1, '', '保密', '', 0, 2, '', 0, 0, '', '', '', ''),
(18, 1, '', '注册', '', 0, 7, '', 0, 0, '', '', '', '');

CREATE TABLE IF NOT EXISTS `qinggan_tag_node` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '关联的TagID',
  `identifier` varchar(255) NOT NULL COMMENT '标识变量名，在同一个标签里不能重复',
  `title` varchar(255) NOT NULL COMMENT '节点名称',
  `psize` int(11) NOT NULL DEFAULT '0' COMMENT '默认文章数，用于未指定时自动读取的数量',
  `ids` text NOT NULL COMMENT '文章ID，多个ID用英文逗号隔开',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '为1表示读列表，为0表示随机从ids里选择一篇读取（如果有多个）',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0未启用，1启用',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '项目ID',
  `cid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '值越小越往前排，最大不超过255',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='标签节点管理器' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_tag_stat` (
  `title_id` varchar(200) NOT NULL COMMENT '主题ID，以p开头的表示项目ID，以c开头的表示分类ID',
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'TAG标签ID',
  PRIMARY KEY (`title_id`,`tag_id`),
  KEY `title_id` (`title_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Tag主题统计';

INSERT INTO `qinggan_tag_stat` (`title_id`, `tag_id`) VALUES
('12', 12),
('12', 13),
('13', 6),
('13', 7),
('13', 8),
('14', 4),
('14', 5),
('15', 9),
('15', 10),
('16', 11),
('17', 1),
('17', 2),
('17', 3),
('41', 15),
('41', 16),
('41', 17),
('41', 18),
('p87', 14);

CREATE TABLE IF NOT EXISTS `qinggan_task` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `year` varchar(9) NOT NULL COMMENT '年份',
  `month` varchar(5) NOT NULL COMMENT '月',
  `day` varchar(5) NOT NULL COMMENT '日',
  `hour` varchar(5) NOT NULL COMMENT '时',
  `minute` varchar(5) NOT NULL COMMENT '分',
  `second` varchar(5) NOT NULL COMMENT '秒',
  `exec_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '开始执行时间',
  `stop_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结束时间',
  `action` varchar(100) NOT NULL COMMENT '执行动作脚本',
  `param` varchar(255) NOT NULL COMMENT '参数',
  `only_once` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1表示仅执行一次',
  `is_lock` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未锁定1已锁定',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='计划任务' AUTO_INCREMENT=250 ;

CREATE TABLE IF NOT EXISTS `qinggan_tpl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(100) NOT NULL COMMENT '模板名称',
  `author` varchar(100) NOT NULL COMMENT '开发者名称',
  `folder` varchar(100) NOT NULL DEFAULT 'www' COMMENT '模板目录',
  `refresh_auto` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1自动判断更新刷新0不刷新',
  `refresh` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1强制刷新0普通刷新',
  `ext` varchar(20) NOT NULL DEFAULT 'html' COMMENT '后缀',
  `folder_change` varchar(255) NOT NULL COMMENT '更改目录',
  `phpfolder` varchar(200) NOT NULL COMMENT 'PHP执行文件目录',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='模板管理' AUTO_INCREMENT=5 ;

INSERT INTO `qinggan_tpl` (`id`, `title`, `author`, `folder`, `refresh_auto`, `refresh`, `ext`, `folder_change`, `phpfolder`) VALUES
(1, '默认风格', 'phpok.com', 'www', 1, 0, 'html', 'css,images,js', 'phpinc');

CREATE TABLE IF NOT EXISTS `qinggan_user` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID，即会员ID',
  `group_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '主要会员组',
  `user` varchar(100) NOT NULL COMMENT '会员账号',
  `pass` varchar(100) NOT NULL COMMENT '会员密码',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '状态ID，0未审核1正常2锁定',
  `regtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `email` varchar(200) NOT NULL COMMENT '邮箱，可用于取回密码',
  `mobile` varchar(50) NOT NULL COMMENT '手机或电话',
  `code` varchar(255) NOT NULL COMMENT '验证串，可用于取回密码',
  `avatar` varchar(255) NOT NULL COMMENT '会员头像',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='会员管理' AUTO_INCREMENT=57 ;

INSERT INTO `qinggan_user` (`id`, `group_id`, `user`, `pass`, `status`, `regtime`, `email`, `mobile`, `code`, `avatar`) VALUES
(23, 7, 'admin', '2f276632df95f2d6c6db7255a6e94e26:94', 1, 1438668082, '40782502@qq.com', '18928475011', 'U2335232', 'res/202105/13/2790ca2d70da7a89.jpg'),
(56, 2, 'demo', 'a3e8e97e846e709187da94e01d22c051:9b', 1, 1621045141, 'demo@demo.lcom', '15818533971', 'U56', '');

CREATE TABLE IF NOT EXISTS `qinggan_user_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `country` varchar(255) NOT NULL DEFAULT '中国' COMMENT '国家',
  `province` varchar(255) NOT NULL COMMENT '省信息',
  `city` varchar(255) NOT NULL COMMENT '市',
  `county` varchar(255) NOT NULL COMMENT '县',
  `address` varchar(255) NOT NULL COMMENT '地址信息（不含国家，省市县镇区信息）',
  `address2` varchar(255) NOT NULL COMMENT '楼层房号',
  `mobile` varchar(100) NOT NULL COMMENT '手机号码',
  `tel` varchar(100) NOT NULL COMMENT '电话号码',
  `email` varchar(100) NOT NULL COMMENT '邮箱',
  `fullname` varchar(100) NOT NULL COMMENT '联系人姓名',
  `zipcode` varchar(50) NOT NULL COMMENT '邮编',
  `is_default` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1表示默认地址，0为常规',
  `firstname` varchar(255) NOT NULL COMMENT '名字',
  `lastname` varchar(255) NOT NULL COMMENT '姓氏',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员地址库' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_user_autologin` (
  `id` int(10) unsigned NOT NULL COMMENT '会员ID',
  `code` varchar(255) NOT NULL COMMENT '随机码，用于生成验签，以确保单点登录模式',
  `logintime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='系统自动登录验签模式';

CREATE TABLE IF NOT EXISTS `qinggan_user_ext` (
  `id` int(10) unsigned NOT NULL COMMENT '会员ID',
  `fullname` varchar(255) NOT NULL DEFAULT '' COMMENT '姓名',
  `bgcolor` varchar(255) NOT NULL DEFAULT '' COMMENT '背景色',
  `bgimg` varchar(255) NOT NULL DEFAULT '' COMMENT '背景图片',
  `gender` varchar(255) NOT NULL DEFAULT '未知' COMMENT '性别',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员扩展字段';

INSERT INTO `qinggan_user_ext` (`id`, `fullname`, `bgcolor`, `bgimg`, `gender`) VALUES
(23, '苏相锟', '', '', '未知'),
(56, '', '', '', '未知');

CREATE TABLE IF NOT EXISTS `qinggan_user_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员组ID',
  `title` varchar(255) NOT NULL COMMENT '会员组名称',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '0不使用1使用',
  `is_default` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1为会员注册默认组',
  `is_guest` tinyint(1) NOT NULL DEFAULT '0' COMMENT '游客组',
  `is_open` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '1开放供用户选择，0不开放',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序',
  `register_status` varchar(100) NOT NULL COMMENT '1通过0审核email邮件code邀请码mobile手机',
  `tbl_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '关联验证串项目',
  `tpl_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '通知模板ID',
  `fields` text NOT NULL COMMENT '会员字段，多个字段用英文逗号隔开',
  `popedom` longtext NOT NULL COMMENT '权限，包括读写及评论审核',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='会员组信息管理' AUTO_INCREMENT=8 ;

INSERT INTO `qinggan_user_group` (`id`, `title`, `status`, `is_default`, `is_guest`, `is_open`, `taxis`, `register_status`, `tbl_id`, `tpl_id`, `fields`, `popedom`) VALUES
(2, '普通会员', 1, 1, 0, 1, 10, 'code', 0, 17, 'fullname,gender', 'a:1:{i:1;s:159:"read:43,read:87,read:41,read:45,read:96,post:96,read:144,read:151,read:152,post:152,post1:152,reply:152,reply1:152,read:148,read:389,read:451,read:452,read:453";}'),
(3, '游客组', 1, 0, 1, 0, 200, '', 0, 0, '', 'a:1:{i:1;s:333:"read:43,read:87,read:41,read:42,read:147,read:45,read:150,read:96,post:96,read:144,read:151,read:152,read:148,read:386,post:386,read:389,read:390,read:439,read:440,read:443,read:444,read:445,read:448,read:450,post:450,reply:450,post1:450,reply1:450,read:449,post:449,reply:449,post1:449,reply1:449,read:451,read:452,read:453,read:454";}'),
(7, 'VIP会员', 1, 0, 0, 0, 255, '0', 0, 37, 'fullname,gender', 'a:1:{i:1;s:196:"read:43,read:87,read:41,read:45,read:96,post:96,post1:96,reply:96,reply1:96,read:144,read:151,read:152,post:152,post1:152,reply:152,reply1:152,read:148,read:389,read:451,read:452,read:453,read:454";}');

CREATE TABLE IF NOT EXISTS `qinggan_user_relation` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `introducer` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '介绍人ID',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '介绍时间'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员介绍关系图';

INSERT INTO `qinggan_user_relation` (`uid`, `introducer`, `dateline`) VALUES
(56, 23, 1621045141);

CREATE TABLE IF NOT EXISTS `qinggan_wealth` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '财富ID',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '站点ID',
  `title` varchar(100) NOT NULL COMMENT '财产名称',
  `identifier` varchar(100) NOT NULL COMMENT '标识，仅限英文字符',
  `unit` varchar(100) NOT NULL COMMENT '单位名称',
  `dnum` tinyint(1) NOT NULL DEFAULT '0' COMMENT '保留几位小数，为0表示只取整数',
  `ifpay` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否支持充值',
  `pay_ratio` float unsigned NOT NULL DEFAULT '0' COMMENT '兑换比例，即1元可以兑换多少，为0不支持充值，为1表示1：1，不支持小数',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0不使用1使用',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序，0-255，越小越往前靠',
  `ifcash` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否抵现，即允许财富当现金使用',
  `cash_ratio` float unsigned NOT NULL DEFAULT '0' COMMENT '抵现比例，即100财富值可抵用多少元',
  `ifcheck` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否审核，为1时表示获取到的财富需要管理员审核后才行',
  `min_val` float unsigned NOT NULL DEFAULT '0' COMMENT '最低使用值',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='财富类型' AUTO_INCREMENT=8 ;

INSERT INTO `qinggan_wealth` (`id`, `site_id`, `title`, `identifier`, `unit`, `dnum`, `ifpay`, `pay_ratio`, `status`, `taxis`, `ifcash`, `cash_ratio`, `ifcheck`, `min_val`) VALUES
(1, 1, '积分', 'integral', '点', 2, 0, 0, 1, 10, 1, 1, 0, 100),
(6, 1, '余额', 'cash', '元', 2, 1, 1, 1, 20, 1, 100, 0, 1);

CREATE TABLE IF NOT EXISTS `qinggan_wealth_info` (
  `wid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '方案ID',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '主题ID或会员ID或分类ID或项目ID',
  `lasttime` int(11) NOT NULL DEFAULT '0' COMMENT '最后一次更新时间',
  `val` float unsigned NOT NULL DEFAULT '0' COMMENT '最小财富为0，不考虑负数情况',
  PRIMARY KEY (`wid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='财富内容';

CREATE TABLE IF NOT EXISTS `qinggan_wealth_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `wid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '财富ID',
  `rule_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '规则ID',
  `goal_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '目标会员ID',
  `mid` varchar(100) NOT NULL COMMENT '主键ID关联',
  `val` float NOT NULL DEFAULT '0' COMMENT '不带负号表示增加，带负号表示减去',
  `note` varchar(255) NOT NULL COMMENT '操作摘要',
  `appid` enum('admin','www','api') NOT NULL DEFAULT 'www' COMMENT '来自哪个接口',
  `dateline` int(11) NOT NULL DEFAULT '0' COMMENT '写入时间',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID，为0非会员',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID，为0非管理员',
  `ctrlid` varchar(100) NOT NULL COMMENT '控制器ID',
  `funcid` varchar(100) NOT NULL COMMENT '方法ID',
  `url` varchar(255) NOT NULL COMMENT '执行的URL',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未审核1已审核',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='财富获取或消耗日志' AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `qinggan_wealth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则ID',
  `wid` int(10) unsigned NOT NULL COMMENT '财产ID',
  `action` varchar(255) NOT NULL COMMENT '触发动作',
  `val` varchar(255) NOT NULL DEFAULT '0' COMMENT '值，负值表示减，大于0表示加，支持计算如price*2',
  `goal` varchar(255) NOT NULL DEFAULT 'user' COMMENT '目标类型user用户，agent1一级代理',
  `taxis` tinyint(3) unsigned NOT NULL DEFAULT '255' COMMENT '排序',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0不限制，其他限制这条规则仅在此会员组下的会员有效',
  `uids` varchar(255) NOT NULL COMMENT '多个会员ID用英文逗号隔开',
  `qty_type` varchar(255) NOT NULL DEFAULT 'order' COMMENT 'order指订单数，product指产品数',
  `qty` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0不限，其他值是在订单数量或产品数量值',
  `price_type` varchar(255) NOT NULL DEFAULT 'order' COMMENT 'order指订单价格，product指产品价格',
  `price` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0不限，其他值指订单或产品价格时有效',
  `project_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0不限制，其他值限制项目',
  `title_id` varchar(255) NOT NULL COMMENT '主题限制，多个主题用英文逗号隔开，建议不超过30个主题',
  `goal_group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0不限，其他限制目标会员组ID',
  `goal_uids` varchar(255) NOT NULL COMMENT '目标会员ID，多个会员ID用英文逗号隔开',
  `if_stop` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0不中止，1中止',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='财富生成规则' AUTO_INCREMENT=24 ;

INSERT INTO `qinggan_wealth_rule` (`id`, `wid`, `action`, `val`, `goal`, `taxis`, `group_id`, `uids`, `qty_type`, `qty`, `price_type`, `price`, `project_id`, `title_id`, `goal_group_id`, `goal_uids`, `if_stop`) VALUES
(2, 1, 'register', '50', 'user', 10, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(4, 1, 'register', '20', 'introducer', 20, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(5, 1, 'login', '10', 'user', 30, 7, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(12, 1, 'content', '1', 'user', 40, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(13, 1, 'comment', '5', 'user', 50, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(14, 1, 'payment', 'price', 'user', 60, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(15, 1, 'post', '10', 'user', 70, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(16, 1, 'register', '10', 'introducer2', 25, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(17, 1, 'register', '5', 'introducer3', 28, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(18, 1, 'payment', 'price*0.6', 'introducer', 62, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(19, 1, 'payment', 'price*0.3', 'introducer2', 65, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(20, 1, 'payment', 'price*0.1', 'introducer3', 68, 0, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(21, 1, 'login', '5', 'user', 35, 2, '', 'order', 0, 'order', 0, 0, '', 0, '', 0),
(22, 1, 'login', '100', 'introducer', 36, 7, '', 'order', 0, 'order', 0, 0, '', 7, '', 0),
(23, 1, 'login', '75', 'introducer', 37, 7, '', 'order', 0, 'order', 0, 0, '', 2, '', 0);

CREATE TABLE IF NOT EXISTS `qinggan_world_location` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pid` int(11) unsigned DEFAULT '0' COMMENT '父ID',
  `name` varchar(255) DEFAULT NULL COMMENT '中文名称',
  `name_en` varchar(255) DEFAULT NULL COMMENT '英文名称',
  `code` varchar(50) DEFAULT NULL COMMENT '代码',
  `code2` varchar(10) NOT NULL COMMENT '2位国际编码',
  `status` tinyint(1) unsigned DEFAULT '0' COMMENT '默认是否显示1，隐藏0',
  `excise_rate` decimal(10,4) NOT NULL DEFAULT '0.0000' COMMENT '消费税税率，值都是小于1的',
  `tariff_rate` decimal(10,4) unsigned NOT NULL DEFAULT '0.0000' COMMENT '关税税率，无关税请留0值',
  `lang_code` varchar(10) NOT NULL COMMENT '执行的语言包',
  `site_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '锁定站点ID，为0表示默认',
  `tpl_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '模板风格文件，为0读取默认板风格',
  `taxis` int(10) unsigned NOT NULL DEFAULT '255' COMMENT '值越小越往前排',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '货币ID，为0使用站点默认',
  `freight_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '运费计算方式',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='全球地区库' AUTO_INCREMENT=4173 ;

INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(1, 0, '亚洲', 'Asia Pacific', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2, 0, '欧洲', 'Europe', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3, 0, '非洲', 'Africa', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4, 0, '美洲', 'Americas', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(5, 0, '南美', 'South America', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(6, 0, '大洋洲', 'Oceania', NULL, '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(7, 1, '中国', 'China', 'CN', '', 1, '0.0000', '0.0000', 'cn', 0, 0, 255, 0, 0),
(8, 2, '阿尔巴尼亚', 'Albania', 'ALB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(9, 3, '阿尔及利亚', 'Algeria', 'DZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(10, 1, '阿富汗', 'Afghanistan', 'AFG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(11, 4, '阿根廷', 'Argentina', 'ARG', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(12, 1, '阿拉伯联合酋长国', 'United Arab Emirates', 'ARE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(13, 4, '阿鲁巴', 'Aruba', 'ABW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(14, 1, '阿曼', 'Oman', 'OMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(15, 1, '阿塞拜疆', 'Azerbaijan', 'AZE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(16, 3, '阿森松岛', 'Ascension Island', 'ASC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(17, 3, '埃及', 'Egypt', 'EGY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(18, 3, '埃塞俄比亚', 'Ethiopia', 'ETH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(19, 2, '爱尔兰', 'Ireland', 'IRL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(20, 2, '爱沙尼亚', 'Estonia', 'EST', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(21, 2, '安道尔', 'Andorra', 'AND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(22, 3, '安哥拉', 'Angola', 'AGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(23, 4, '安圭拉', 'Anguilla', 'AIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(25, 1, '澳大利亚', 'Australia', 'AUS', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(26, 2, '奥地利', 'Austria', 'AUT', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(27, 2, '奥兰群岛', 'Aland lslands', 'ALA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(28, 4, '巴巴多斯岛', 'Barbados', 'BRB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(29, 6, '巴布亚新几内亚', 'Papua New Guinea', 'PNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(30, 4, '巴哈马', 'Bahamas', 'BHS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(31, 1, '巴基斯坦', 'Pakistan', 'PAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(32, 4, '巴拉圭', 'Paraguay', 'PRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(33, 1, '巴勒斯坦', 'Palestinian Authority', 'PSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(34, 1, '巴林', 'Bahrain', 'BHR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(35, 4, '巴拿马', 'Panama', 'PAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(36, 4, '巴西', 'Brazil', 'BRA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(37, 2, '白俄罗斯', 'White Russia', 'BLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(38, 4, '百慕大', 'Bermuda', 'BMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(39, 2, '保加利亚', 'Bulgaria', 'BGR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(40, 4, '北马里亚纳群岛', 'Northern Mariana Islands', 'MNP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(41, 3, '贝宁', 'Benin', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(42, 2, '比利时', 'Belgium', 'BEL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(43, 2, '冰岛', 'Iceland', 'ISL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(44, 4, '波多黎各', 'Puerto Rico', 'PRI', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(45, 2, '波兰', 'Poland', 'POL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(46, 4, '玻利维亚', 'Bolivia', 'BOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(47, 2, '波斯尼亚和黑塞哥维那', 'Bosnia and Herzegovina', 'BIH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(48, 3, '博茨瓦纳', 'Botswana', 'BWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(49, 4, '伯利兹', 'Belize', 'BLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(50, 1, '不丹', 'Bhutan', 'BTN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(51, 3, '布基纳法索', 'Burkina Faso', 'BFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(52, 3, '布隆迪', 'Burundi', 'BDI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(53, 2, '布韦岛', 'Bouvet Island', 'BVT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(54, 1, '朝鲜', 'North Korea', 'PRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(55, 2, '丹麦', 'Denmark', 'DNK', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(56, 2, '德国', 'Deutschland', 'DEU', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(57, 1, '东帝汶', 'Timor-Leste', 'TLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(58, 3, '多哥', 'Togo', 'TGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(59, 4, '多米尼加', 'Dominica', 'DMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(60, 4, '多米尼加共和国', 'Dominican Republic', 'DOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(61, 2, '俄罗斯', 'Russia', 'RUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(62, 4, '厄瓜多尔', 'Ecuador', 'ECU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(63, 3, '厄立特里亚', 'Eritrea', 'ERI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(64, 2, '法国', 'France', 'FRA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(65, 2, '法罗群岛', 'Faroe Islands', 'FRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(66, 6, '法属波利尼西亚', 'Frech Polynesia', 'PYF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(67, 4, '法属圭亚那', 'French Guiana', 'GUF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(68, 2, '法属南部领地', 'French Southern and Antarctic Lands', 'ATF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(69, 2, '梵蒂冈', 'Vatican City', 'VAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(70, 1, '菲律宾', 'Philippines', 'PHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(71, 6, '斐济', 'Fiji Islands', 'FJI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(72, 2, '芬兰', 'Finland', 'FIN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(73, 3, '佛得角', 'Cape Verde', 'CPV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(74, 2, '弗兰克群岛', 'Falkland Islands', 'FLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(75, 3, '冈比亚', 'Gambia', 'GMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(76, 3, '刚果', 'Congo', 'COG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(77, 3, '刚果民主共和国', 'Congo(DRC)', 'COD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(78, 4, '哥伦比亚', 'Colombia', 'COL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(79, 4, '哥斯达黎加', 'Costa Rica', 'CRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(80, 2, '格恩西岛', 'Guernsey', 'GGY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(81, 4, '格林纳达', 'Grenada', 'GRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(82, 4, '格陵兰', 'Greenland', 'GRL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(83, 4, '古巴', 'Cuba', 'CUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(84, 4, '瓜德罗普', 'Guadeloupe', 'GLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(85, 6, '关岛', 'Guam', 'GUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(86, 4, '圭亚那', 'Guyana', 'GUY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(87, 1, '哈萨克斯坦', 'Kazakhstan', 'KAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(88, 4, '海地', 'Haiti', 'HTI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(89, 1, '韩国', 'Korea', 'KOR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(90, 2, '荷兰', 'Netherlands', 'NLD', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(91, 4, '荷属安地列斯', 'Netherlands Antilles', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(92, 6, '赫德和麦克唐纳群岛', 'Heard Island and McDonald Islands', 'HMD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(93, 4, '洪都拉斯', 'Honduras', 'HND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(94, 6, '基里巴斯', 'Kiribati', 'KIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(95, 3, '吉布提', 'Djibouti', 'DJI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(96, 1, '吉尔吉斯斯坦', 'Kyrgyzstan', 'KGZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(97, 3, '几内亚', 'Guinea', 'GIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(98, 3, '几内亚比绍', 'Guinea-Bissau', 'GNB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(99, 4, '加拿大', 'Canada', 'CAN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(100, 3, '加纳', 'Ghana', 'GHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(101, 3, '加蓬', 'Gabon', 'GAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(102, 1, '柬埔寨', 'Cambodia', 'KHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(103, 2, '捷克共和国', 'Czech Republic', 'CZE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(104, 3, '津巴布韦', 'Zimbabwe', 'ZWE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(105, 3, '喀麦隆', 'Cameroon', 'CMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(106, 1, '卡塔尔', 'Qatar', 'QAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(107, 4, '开曼群岛', 'Cayman Islands', 'CYM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(108, 6, '科科斯群岛', 'Cocos(Keeling)Islands', 'CCK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(109, 3, '科摩罗', 'Comoros', 'COM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(110, 3, '科特迪瓦', 'Cote d''Ivoire', 'CIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(111, 1, '科威特', 'Kuwait', 'KWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(112, 2, '克罗地亚', 'Croatia', 'HRV', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(113, 3, '肯尼亚', 'Kenya', 'KEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(114, 6, '库克群岛', 'Cook Islands', 'COK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(115, 2, '拉脱维亚', 'Latvia', 'LVA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(116, 3, '莱索托', 'Lesotho', 'LSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(117, 1, '老挝', 'Laos', 'LAO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(118, 1, '黎巴嫩', 'Lebanon', 'LBN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(119, 3, '利比里亚', 'Liberia', 'LBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(120, 3, '利比亚', 'Libya', 'LBY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(121, 2, '立陶宛', 'Lithuania', 'LTU', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(122, 2, '列支敦士登', 'Liechtenstein', 'LIE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(123, 2, '留尼旺岛', 'Reunion', 'REU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(124, 2, '卢森堡', 'Luxembourg', 'LUX', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(125, 3, '卢旺达', 'Rwanda', 'RWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(126, 2, '罗马尼亚', 'Romania', 'ROU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(127, 3, '马达加斯加', 'Madagascar', 'MDG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(128, 1, '马尔代夫', 'Maldives', 'MDV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(129, 2, '马耳他', 'Malta', 'MLT', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(130, 3, '马拉维', 'Malawi', 'MWI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(131, 1, '马来西亚', 'Malaysia', 'MYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(132, 3, '马里', 'Mali', 'MLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(133, 2, '马其顿', 'Macedonia,Former Yugoslav Republic of', 'MKD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(134, 6, '马绍尔群岛', 'Marshall Islands', 'MHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(135, 4, '马提尼克', 'Martinique', 'MTQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(136, 3, '马约特岛', 'Mayotte', 'MYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(137, 2, '曼岛', 'Isle of Man', 'IMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(138, 3, '毛里求斯', 'Mauritius', 'MUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(139, 3, '毛里塔尼亚', 'Mauritania', 'MRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(140, 4, '美国', 'United States', 'USA', '', 1, '0.0000', '0.0000', 'en_US', 0, 0, 255, 2, 0),
(141, 6, '美属萨摩亚', 'American Samoa', 'ASM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(142, 4, '美属外岛', 'United States Minor Outlying Islands', 'UMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(143, 1, '蒙古', 'Mongolia', 'MNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(144, 4, '蒙特塞拉特', 'Montserrat', 'MSR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(145, 1, '孟加拉', 'Bangladesh', 'BGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(146, 6, '密克罗尼西亚', 'Micronesia', 'FSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(147, 4, '秘鲁', 'Peru', 'PER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(148, 1, '缅甸', 'Myanmar', 'MMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(149, 2, '摩尔多瓦', 'Moldova', 'MDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(150, 3, '摩洛哥', 'Morocco', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(151, 2, '摩纳哥', 'Monaco', 'MCO', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(152, 3, '莫桑比克', 'Mozambique', 'MOZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(153, 4, '墨西哥', 'Mexico', 'MEX', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(154, 3, '纳米比亚', 'Namibia', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(155, 3, '南非', 'South Africa', 'ZAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(156, 0, '南极洲', 'Antarctica', 'ATA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(158, 6, '瑙鲁', 'Nauru', 'NRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(159, 1, '尼泊尔', 'Nepal', 'NPL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(160, 4, '尼加拉瓜', 'Nicaragua', 'NIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(161, 3, '尼日尔', 'Niger', 'NER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(162, 3, '尼日利亚', 'Nigeria', 'NGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(163, 6, '纽埃', 'Niue', 'NIU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(164, 2, '挪威', 'Norway', 'NOR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(165, 4, '诺福克', 'Norfolk Island', 'NFK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(166, 6, '帕劳群岛', 'Palau', 'PLW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(167, 6, '皮特凯恩', 'Pitcairn Islands', 'PCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(168, 2, '葡萄牙', 'Portugal', 'PRT', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(170, 1, '日本', 'Japan', 'JPN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(171, 2, '瑞典', 'Sweden', 'SWE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(172, 2, '瑞士', 'Switzerland', 'CHE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(173, 4, '萨尔瓦多', 'El Salvador', 'SLV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(174, 6, '萨摩亚', 'Samoa', 'WSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(175, 2, '塞尔维亚,黑山', 'Serbia,Montenegro', 'SCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(176, 3, '塞拉利昂', 'Sierra Leone', 'SLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(177, 3, '塞内加尔', 'Senegal', 'SEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(178, 1, '塞浦路斯', 'Cyprus', 'CYP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(179, 3, '塞舌尔', 'Seychelles', 'SYC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(180, 1, '沙特阿拉伯', 'Saudi Arabia', 'SAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(181, 6, '圣诞岛', 'Christmas Island', 'CXR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(182, 3, '圣多美和普林西比', 'Sao Tome and Principe', 'STP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(183, 3, '圣赫勒拿', 'St.Helena', 'SHN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(184, 4, '圣基茨和尼维斯', 'St.Kitts and Nevis', 'KNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(185, 4, '圣卢西亚', 'St.Lucia', 'LCA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(186, 2, '圣马力诺', 'San Marino', 'SMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(187, 4, '圣皮埃尔和米克隆群岛', 'St.Pierre and Miquelon', 'SPM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(188, 4, '圣文森特和格林纳丁斯', 'St.Vincent and the Grenadines', 'VCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(189, 1, '斯里兰卡', 'Sri Lanka', 'LKA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(190, 2, '斯洛伐克', 'Slovakia', 'SVK', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(191, 2, '斯洛文尼亚', 'Slovenia', 'SVN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(192, 2, '斯瓦尔巴和扬马廷', 'Svalbard and Jan Mayen', 'SJM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(193, 3, '斯威士兰', 'Swaziland', 'SWZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(194, 3, '苏丹', 'Sudan', 'SDN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(195, 4, '苏里南', 'Suriname', 'SUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(196, 6, '所罗门群岛', 'Solomon Islands', 'SLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(197, 3, '索马里', 'Somalia', 'SOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(198, 1, '塔吉克斯坦', 'Tajikistan', 'TJK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(199, 1, '泰国', 'Thailand', 'THA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(200, 3, '坦桑尼亚', 'Tanzania', 'TZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(201, 6, '汤加', 'Tonga', 'TON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(202, 4, '特克斯和凯克特斯群岛', 'Turks and Caicos Islands', 'TCA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(203, 4, '特里斯坦达昆哈', 'Tristan da Cunha', 'TAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(204, 4, '特立尼达和多巴哥', 'Trinidad and Tobago', 'TTO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(205, 3, '突尼斯', 'Tunisia', 'TUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(206, 6, '图瓦卢', 'Tuvalu', 'TUV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(207, 1, '土耳其', 'Turkey', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(208, 1, '土库曼斯坦', 'Turkmenistan', 'TKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(209, 6, '托克劳', 'Tokelau', 'TKL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(210, 6, '瓦利斯和福图纳', 'Wallis and Futuna', 'WLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(211, 6, '瓦努阿图', 'Vanuatu', 'VUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(212, 4, '危地马拉', 'Guatemala', 'GTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(213, 4, '维尔京群岛，美属', 'Virgin Islands', 'VIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(214, 4, '维尔京群岛，英属', 'Virgin Islands,British', 'VGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(215, 4, '委内瑞拉', 'Venezuela', 'VEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(216, 1, '文莱', 'Brunei', 'BRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(217, 3, '乌干达', 'Uganda', 'UGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(218, 2, '乌克兰', 'Ukraine', 'UKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(219, 4, '乌拉圭', 'Uruguay', 'URY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(220, 1, '乌兹别克斯坦', 'Uzbekistan', 'UZB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(221, 2, '西班牙', 'Spain', 'ESP', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(222, 2, '希腊', 'Greece', 'GRC', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(223, 1, '新加坡', 'Singapore', 'SGP', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(224, 6, '新喀里多尼亚', 'New Caledonia', 'NCL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(225, 1, '新西兰', 'New Zealand', 'NZL', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(226, 2, '匈牙利', 'Hungary', 'HUN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(227, 1, '叙利亚', 'Syria', 'SYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(228, 4, '牙买加', 'Jamaica', 'JAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(229, 1, '亚美尼亚', 'Armenia', 'ARM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(230, 1, '也门', 'Yemen', 'YEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(231, 1, '伊拉克', 'Iraq', 'IRQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(232, 1, '伊朗', 'Iran', 'IRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(233, 1, '以色列', 'Israel', 'ISR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(234, 2, '意大利', 'Italy', 'ITA', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(235, 1, '印度', 'India', 'IND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(236, 1, '印度尼西亚', 'Indonesia', 'IDN', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(237, 2, '英国', 'United Kingdom', 'GBR', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(238, 3, '英属印度洋领地', 'British Indian Ocean Territory', 'IOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(239, 1, '约旦', 'Jordan', 'JOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(240, 1, '越南', 'Vietnam', 'VNM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(241, 3, '赞比亚', 'Zambia', 'ZMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(242, 2, '泽西岛', 'Jersey', 'JEY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(243, 3, '乍得', 'Chad', 'TCD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(244, 3, '直布罗陀', 'Gibraltar', 'GIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(245, 4, '智利', 'Chile', 'CHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(246, 3, '中非共和国', 'Central African Republic', 'CAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(247, 7, '北京', 'Beijing', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(248, 7, '天津', 'Tianjin', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(249, 7, '河北', 'Hebei', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(250, 7, '山西', 'Shanxi', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(251, 7, '内蒙古', 'Inner Mongolia', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(252, 7, '辽宁', 'Liaoning', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(253, 7, '吉林', 'Jilin', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(254, 7, '黑龙江', 'Heilongjiang', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(255, 7, '上海', 'Shanghai', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(256, 7, '江苏', 'Jiangsu', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(257, 7, '浙江', 'Zhejiang', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(258, 7, '安徽', 'Anhui', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(259, 7, '福建', 'Fujian', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(260, 7, '江西', 'Jiangxi', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(261, 7, '山东', 'Shandong', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(262, 7, '河南', 'Henan', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(263, 7, '湖北', 'Hubei', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(264, 7, '湖南', 'Hunan', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(265, 7, '广东', 'Guangdong', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(266, 7, '广西', 'Guangxi', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(267, 7, '海南', 'Hainan', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(268, 7, '重庆', 'Chongqing', '50', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(269, 7, '四川', 'Sichuan', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(270, 7, '贵州', 'Guizhou', '52', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(271, 7, '云南', 'Yunnan', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(272, 7, '西藏', 'Tibet', '54', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(273, 7, '陕西', 'Shaanxi', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(274, 7, '甘肃', 'Gansu', '62', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(275, 7, '青海', 'Qinghai', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(276, 7, '宁夏', 'Ningxia', '64', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(277, 7, '新疆', 'Xinjiang', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(278, 1, '台湾（中国）', 'Taiwan(China)', '71', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(279, 1, '香港（中国）', 'HongKong(China)', '81', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(280, 1, '澳门（中国）', 'Macao(China)', '82', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(281, 25, '北部地区', 'Northern Territory', 'NT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(282, 25, '堪培拉', 'Canberra', 'ACT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(283, 25, '昆士兰', 'Queensland', 'QLD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(284, 25, '南澳大利亚', 'South Australia', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(285, 25, '塔斯马尼亚', 'Tasmania', 'TAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(286, 25, '维多利亚', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(287, 25, '西澳大利亚', 'Western Australia', 'WA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(288, 25, '新南威尔士', 'New South Wales', 'NSW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(289, 89, '大邱', 'Daegu', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(290, 89, '大田', 'Daejeon', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(291, 89, '釜山', 'Busan', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(292, 89, '光州', 'Gwangju', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(293, 89, '济州特别自治道', 'Jeju-do', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(294, 89, '江原道', 'Gangwon-do', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(295, 89, '京畿道', 'Gyeonggi-do', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(296, 89, '庆尚北道', 'Chungcheongbuk-do', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(297, 89, '庆尚南道', 'Chungcheongnam-do', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(298, 89, '全罗北道', 'Gyeongsangbuk-do', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(299, 89, '全罗南道', 'Gyeongsangnam-do', '48', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(300, 89, '仁川', 'Incheon', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(301, 89, '首尔', 'Seoul', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(302, 89, '蔚山', 'Ulsan', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(303, 89, '忠清北道', 'Jeollabuk-do', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(304, 89, '忠清南道', 'Jeollanam-do', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(305, 131, '槟榔屿', 'Pulau Pinang', 'PH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(306, 131, '玻璃市', 'Perlis', 'PS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(307, 131, '丁加奴', 'Terengganu', 'TR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(308, 131, '吉打', 'Kedah', 'KD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(309, 131, '吉兰丹', 'Kelantan', 'KN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(310, 131, '吉隆坡', 'Kuala Lumpur', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(311, 131, '马六甲', 'Malacca', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(312, 131, '纳闽', 'Labuan', 'LB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(313, 131, '彭亨', 'Pahang', 'PG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(314, 131, '霹雳', 'Perak', 'PK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(315, 131, '柔佛', 'Johor', 'JH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(316, 131, '森美兰', 'Negeri Sembilan', 'NS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(317, 131, '沙巴', 'Sabah', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(318, 131, '沙捞越', 'Sarawak', 'SR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(319, 131, '雪兰莪', 'Selangor', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(320, 140, '阿肯色', 'Arkansas', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(321, 140, '阿拉巴马', 'Alabama', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(322, 140, '阿拉斯加', 'Alaska', 'AK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(323, 140, '爱达荷', 'Idaho', 'ID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(324, 140, '爱荷华', 'Iowa', 'IA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(325, 140, '北达科他', 'North Dakota', 'ND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(326, 140, '北卡罗来纳', 'North Carolina', 'NC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(327, 140, '宾夕法尼亚', 'Pennsylvania', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(328, 140, '德克萨斯', 'Texas', 'TX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(329, 140, '俄亥俄', 'Ohio', 'OH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(330, 140, '俄克拉荷马', 'Oklahoma', 'OK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(331, 140, '俄勒冈', 'Oregon', 'OR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(332, 140, '佛罗里达', 'Florida', 'FL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(333, 140, '佛蒙特', 'Vermont', 'VT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(334, 140, '哥伦比亚特区', 'District of Columbia', 'DC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(335, 140, '华盛顿', 'Washington', 'WA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(336, 140, '怀俄明', 'Wyoming', 'WY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(337, 140, '加利福尼亚', 'California', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(338, 140, '堪萨斯', 'Kansas', 'KS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(339, 140, '康涅狄格', 'Connecticut', 'CT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(340, 140, '科罗拉多', 'Colorado', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(341, 140, '肯塔基', 'Kentucky', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(342, 140, '路易斯安那', 'Louisiana', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(343, 140, '罗德岛', 'Rhode Island', 'RI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(344, 140, '马里兰', 'Maryland', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(345, 140, '马萨诸塞', 'Massachusetts', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(346, 140, '蒙大拿', 'Montana', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(347, 140, '密苏里', 'Missouri', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(348, 140, '密西西比', 'Mississippi', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(349, 140, '密歇根', 'Michigan', 'MI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(350, 140, '缅因', 'Maine', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(351, 140, '明尼苏达', 'Minnesota', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(352, 140, '南达科他', 'South Dakota', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(353, 140, '南卡罗来纳', 'South Carolina', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(354, 140, '内布拉斯加', 'Nebraska', 'NE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(355, 140, '内华达', 'Nevada', 'NV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(356, 140, '纽约', 'New York', 'NY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(357, 140, '特拉华', 'Delaware', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(358, 140, '田纳西', 'Tennessee', 'TN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(359, 140, '威斯康星', 'Wisconsin', 'WI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(360, 140, '维吉尼亚', 'Virginia', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(361, 140, '西佛吉尼亚', 'West Virginia', 'WV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(362, 140, '夏威夷', 'Hawaii', 'HI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(363, 140, '新罕布什尔', 'New Hampshire', 'NH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(364, 140, '新墨西哥', 'New Mexico', 'NM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(365, 140, '新泽西', 'New Jersey', 'NJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(366, 140, '亚利桑那', 'Arizona', 'AZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(367, 140, '伊利诺斯', 'Illinois', 'IL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(368, 140, '印第安那', 'Indiana', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(369, 140, '犹他', 'Utah', 'UT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(370, 140, '佐治亚', 'Georgia', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(371, 237, '北爱尔兰', 'Northern Ireland', 'NIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(372, 237, '苏格兰', 'Scotland', 'SCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(373, 237, '威尔士', 'Wales', 'WLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(374, 237, '英格兰', 'England', 'ENG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(375, 8, '爱尔巴桑', 'Elbasan', 'EL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(376, 8, '迪勃拉', 'Diber', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(377, 8, '地拉那', 'Tirane', 'TR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(378, 8, '都拉斯', 'Durres', 'DR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(379, 8, '发罗拉', 'Vlore', 'VL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(380, 8, '费里', 'Fier', 'FR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(381, 8, '吉诺卡斯特', 'Gjirokaster', 'GJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(382, 8, '科尔察', 'Korce', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(383, 8, '库克斯', 'Kukes', 'KU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(384, 8, '莱什', 'Lezhe', 'LE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(385, 8, '培拉特', 'Berat', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(386, 8, '斯库台', 'Shkoder', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(387, 9, '阿德拉尔', 'Adrar', 'ADR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(388, 9, '阿尔及尔', 'Alger', 'ALG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(389, 9, '艾因·德夫拉', 'Ain Defla', 'ADE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(390, 9, '艾因·蒂姆尚特', 'Ain Temouchent', 'ATE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(391, 9, '安纳巴', 'Annaba', 'AAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(392, 9, '奥兰', 'Oran', 'ORA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(393, 9, '巴特纳', 'Batna', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(394, 9, '贝贾亚', 'Bejaia', 'BJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(395, 9, '贝沙尔', 'Bechar', 'BEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(396, 9, '贝伊德', 'El Bayadh', 'EBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(397, 9, '比斯克拉', 'Biskra', 'BIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(398, 9, '布尔吉·布阿雷里吉', 'Bordj Bou Arreridj', 'BOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(399, 9, '布利达', 'Blida', 'BLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(400, 9, '布迈德斯', 'Boumerdes', 'BOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(401, 9, '布依拉', 'Bouira', 'BOA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(402, 9, '蒂巴扎', 'Tipaza', 'TIP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(403, 9, '蒂斯姆西勒特', 'Tissemsilt', 'TIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(404, 9, '盖尔达耶', 'Ghardaia', 'GHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(405, 9, '盖尔马', 'Guelma', 'GUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(406, 9, '罕西拉', 'Khenchela', 'KHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(407, 9, '赫利赞', 'Relizane', 'REL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(408, 9, '吉杰尔', 'Jijel', 'JIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(409, 9, '杰勒法', 'Djelfa', 'DJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(410, 9, '君士坦丁', 'Constantine', 'CZL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(411, 9, '拉格瓦特', 'Laghouat', 'LAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(412, 9, '马斯卡拉', 'Mascara', 'MUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(413, 9, '麦迪亚', 'Medea', 'MED', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(414, 9, '密拉', 'Mila', 'MIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(415, 9, '莫斯塔加纳姆', 'Mostaganem', 'MOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(416, 9, '姆西拉', 'Msila', 'MSI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(417, 9, '纳阿马', 'Naama', 'NAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(418, 9, '塞蒂夫', 'Setif', 'SET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(419, 9, '赛伊达', 'Saida', 'SAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(420, 9, '斯基克达', 'Skikda', 'SKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(421, 9, '苏克·阿赫拉斯', 'Souk Ahras', 'SAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(422, 9, '塔里夫', 'El Tarf', 'ETA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(423, 9, '塔曼拉塞特', 'Tamanghasset', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(424, 9, '特贝萨', 'Tebessa', 'TEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(425, 9, '特莱姆森', 'Tlemcen', 'TLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(426, 9, '提济乌祖', 'Tizi Ouzou', 'IOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(427, 9, '提亚雷特', 'Tiaret', 'TIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(428, 9, '廷杜夫', 'Tindouf', 'TIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(429, 9, '瓦德', 'El Oued', 'EOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(430, 9, '瓦尔格拉', 'Ouargla', 'OUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(431, 9, '乌姆布阿基', 'Oum el Bouaghi', 'OEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(432, 9, '西迪贝勒阿贝斯', 'Sidi Bel Abbes', 'SBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(433, 9, '谢里夫', 'Chlef', 'CHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(434, 9, '伊利齐', 'Illizi', 'ILL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(435, 10, '赫拉特', 'Herat', 'HEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(436, 10, '喀布尔', 'Kabul', 'KBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(437, 10, '坎大哈', 'Kandahar', 'KDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(438, 10, '马扎里沙里夫', 'Mazar-i Sharif', 'MZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(439, 11, '巴拉那', 'Parana', 'PRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(440, 11, '别德马', 'Viedma', 'VDM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(441, 11, '波萨达斯', 'Posadas', 'PSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(442, 11, '布兰卡港', 'Bahia Blanca', 'BHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(443, 11, '布宜诺斯艾利斯', 'Buenos Aires', 'BUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(444, 11, '福莫萨', 'Formosa', 'FMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(445, 11, '胡胡伊', 'Jujuy', 'JUJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(446, 11, '卡塔马卡', 'Catamarca', 'CTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(447, 11, '科尔多瓦', 'Cordoba', 'COR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(448, 11, '科连特斯', 'Corrientes', 'CNQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(449, 11, '克劳斯城', 'Villa Krause', 'VLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(450, 11, '肯考迪娅', 'Concordia', 'COC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(451, 11, '拉里奥哈', 'La Rioja', 'IRJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(452, 11, '拉普拉塔', 'La Plata', 'LPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(453, 11, '雷西斯滕匹亚', 'Resistencia', 'RES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(454, 11, '里奥加耶戈斯', 'Rio Gallegos', 'RGL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(455, 11, '里奥夸尔托', 'Rio Cuarto', 'RCU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(456, 11, '里瓦达维亚海军准将城', 'Comodoro Rivadavia', 'CRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(457, 11, '罗萨里奥', 'Rosario', 'ROS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(458, 11, '罗森', 'Rawson', 'RWO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(459, 11, '马德普拉塔', 'Mar del Plata', 'MDQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(460, 11, '门多萨', 'Mendoza', 'MDZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(461, 11, '内乌肯', 'Neuquen', 'NQN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(462, 11, '萨尔塔', 'Salta', 'SLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(463, 11, '圣地亚哥-德尔埃斯特罗', 'Santiago del Estero', 'SDE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(464, 11, '圣菲', 'Santa Fe', 'SFN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(465, 11, '圣胡安', 'San Juan', 'UAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(466, 11, '圣拉斐尔', 'San Rafael', 'AFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(467, 11, '圣路易斯', 'San Luis', 'LUQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(468, 11, '圣罗莎', 'Santa Rosa', 'RSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(469, 11, '圣米格尔-德图库曼', 'San Miguel de Tucuman', 'SMC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(470, 11, '圣尼古拉斯', 'San Nicolas', 'SNS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(471, 11, '特雷利乌', 'Trelew', 'REL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(472, 11, '乌斯怀亚', 'Ushuaia', 'USH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(473, 12, '阿布扎比', 'Abu Dhabi', 'AZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(474, 12, '艾因', 'Al l''Ayn', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(475, 12, '迪拜', 'Dubai', 'DU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(476, 12, '沙迦', 'Ash Shariqah', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(477, 14, '巴提奈地区', 'Al-Batinah', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(478, 14, '达希莱地区', 'Az-Zahirah', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(479, 14, '东部地区', 'Ash-Sharqiyah', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(480, 14, '马斯喀特省', 'Masqat', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(481, 14, '穆桑达姆省', 'Musandam', 'MU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(482, 14, '内地地区', 'Ad-Dakhiliyah', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(483, 14, '中部地区', 'Al-Wusta', 'WU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(484, 14, '佐法尔省', 'Zufar', 'ZU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(485, 15, '阿布歇隆', 'Abseron', 'ABS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(486, 15, '哈奇马斯', 'Xacmaz', 'XAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(487, 15, '卡尔巴卡尔', 'Kalbacar', 'KAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(488, 15, '卡扎赫', 'Qazax', 'QAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(489, 15, '连科兰', 'Lankaran', 'LAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(490, 15, '密尔-卡拉巴赫', 'Mil-Qarabax', 'MQA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(491, 15, '穆甘-萨连', 'Mugan-Salyan', 'MSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(492, 15, '纳戈尔诺－卡拉巴赫', 'Nagorni-Qarabax', 'NQA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(493, 15, '纳希切万', 'Naxcivan', 'NX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(494, 15, '普利亚拉克斯', 'Priaraks', 'PRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(495, 15, '舍基', 'Saki', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(496, 15, '苏姆盖特', 'Sumqayit', 'SMC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(497, 15, '锡尔万', 'Sirvan', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(498, 15, '占贾', 'Ganca', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(499, 17, '阿斯旺', 'Aswan', 'ASW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(500, 17, '古尔代盖', 'Al Ghurdaqah', 'GBY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(501, 17, '开罗', 'Cairo', 'CAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(502, 17, '苏布拉开马', 'Shubra al Khaymah', 'SKH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(503, 17, '亚历山大', 'Alexandria', 'ALY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(504, 18, '阿法尔', 'Afar', 'AF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(505, 18, '阿姆哈拉', 'Amara', 'AH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(506, 18, '奥罗米亚', 'Oromiya', 'OR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(507, 18, '宾香古尔', 'Binshangul Gumuz', 'BG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(508, 18, '德雷达瓦', 'Dire Dawa', 'DD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(509, 18, '甘贝拉各族', 'Gambela Hizboch', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(510, 18, '哈勒里民族', 'Hareri  Hizb', 'HR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(511, 18, '南方各族', 'YeDebub Biheroch', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(512, 18, '索马里', 'Sumale', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(513, 18, '提格雷', 'Tigray', 'TG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(514, 18, '亚的斯亚贝巴', 'Adis abeba', 'AA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(515, 19, '奥法利', 'Offaly', 'OF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(516, 19, '蒂珀雷里', 'Tipperary', 'TP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(517, 19, '都柏林', 'Dublin', 'DB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(518, 19, '多内加尔', 'Donegal', 'DG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(519, 19, '戈尔韦', 'Galway', 'GW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(520, 19, '基尔代尔', 'Kildare', 'KD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(521, 19, '基尔肯尼', 'Kilkenny', 'KK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(522, 19, '卡范', 'Cavan', 'CV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(523, 19, '卡洛', 'Carlow', 'CW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(524, 19, '凯里', 'Kerry', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(525, 19, '科克', 'Cork', 'CK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(526, 19, '克莱尔', 'Clare', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(527, 19, '朗福德', 'Longford', 'LF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(528, 19, '劳斯', 'Louth', 'LT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(529, 19, '崂斯', 'Laois', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(530, 19, '利默里克', 'Limerick', 'LM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(531, 19, '利特里姆', 'Leitrim', 'LR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(532, 19, '罗斯康芒', 'Roscommon', 'RC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(533, 19, '梅奥', 'Mayo', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(534, 19, '米斯', 'Meath', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(535, 19, '莫内根', 'Monaghan', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(536, 19, '斯莱戈', 'Sligo', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(537, 19, '威克洛', 'Wicklow', 'WK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(538, 19, '韦克斯福德', 'Wexford', 'WX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(539, 19, '沃特福德', 'Waterford', 'WF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(540, 19, '西米斯', 'Westmeath', 'WM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(541, 20, '贝尔瓦', 'Polva', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(542, 20, '哈留', 'Harju', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(543, 20, '拉普拉', 'Rapla', '70', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(544, 20, '里亚内', 'Laane', '57', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(545, 20, '帕尔努', 'Parnu', '67', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(546, 20, '萨雷', 'Saare', '74', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(547, 20, '塔尔图', 'Tartu', '78', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(548, 20, '瓦尔加', 'Valga', '82', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(549, 20, '维良地', 'Viljandi', '84', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(550, 20, '维鲁', 'Laane-Viru', '59', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(551, 20, '沃鲁', 'Voru', '86', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(552, 20, '希尤', 'Hiiu', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(553, 20, '耶尔韦', 'Jarva', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(554, 20, '耶盖瓦', 'Jogeva', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(555, 20, '依达－维鲁', 'Ida-Viru', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(556, 21, '安道尔城', 'Andorra la Vella', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(557, 21, '奥尔迪诺', 'Ordino', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(558, 21, '恩坎普', 'Encamp', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(559, 21, '卡尼略', 'Canillo', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(560, 21, '莱塞斯卡尔德－恩戈尔达', 'Escaldes-Engordany', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(561, 21, '马萨纳', 'La Massana', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(562, 21, '圣胡利娅－德洛里亚', 'Sant Julia de Laria', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(563, 22, '北宽扎', 'Cuanza Norte', 'CNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(564, 22, '北隆达', 'Lunda Norte', 'LNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(565, 22, '本戈', 'Bengo', 'BGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(566, 22, '本格拉', 'Benguela', 'BGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(567, 22, '比耶', 'Bie', 'BIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(568, 22, '卡宾达', 'Cabinda', 'CAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(569, 22, '库内内', 'Cunene', 'CNN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(570, 22, '宽多库邦戈', 'Cuando Cubango', 'CCU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(571, 22, '罗安达', 'Luanda', 'LUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(572, 22, '马兰热', 'Malanje', 'MAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(573, 22, '莫希科', 'Moxico', 'MOX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(574, 22, '纳米贝', 'Namibe', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(575, 22, '南宽扎', 'Cuanza Sul', 'CUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(576, 22, '南隆达', 'Lunda Sul', 'LSU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(577, 22, '万博', 'Huambo', 'HUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(578, 22, '威拉', 'Huila', 'HUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(579, 22, '威热', 'Uige', 'UIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(580, 22, '扎伊尔', 'Zaire', 'ZAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(581, 26, '布尔根兰', 'Burgenland', 'BUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(582, 26, '蒂罗尔', 'Tyrol', 'TYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(583, 26, '福拉尔贝格', 'Vorarlberg', 'VOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(584, 26, '克恩顿', 'Carinthia', 'CAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(585, 26, '萨尔茨堡', 'Salzburg', 'SZG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(586, 26, '上奥地利', 'Upper Austria', 'UAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(587, 26, '施蒂利亚', 'Styria', 'STY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(588, 26, '维也纳', 'Vienna', 'VDD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(589, 26, '下奥地利', 'Lower Austria', 'LAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(590, 29, '北部', 'Northern', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(591, 29, '布干维尔', 'Bougainville', 'BV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(592, 29, '东部高地', 'Eastern Highlands', 'EH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(593, 29, '东塞皮克', 'East Sepik', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(594, 29, '东新不列颠', 'East New Britain', 'EB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(595, 29, '恩加', 'Enga', 'EN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(596, 29, '海湾', 'Gulf', 'GU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(597, 29, '马当', 'Madang', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(598, 29, '马努斯', 'Manus', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(599, 29, '米尔恩湾', 'Milne Bay', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(600, 29, '莫尔兹比港', 'Port Moresby', 'NC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(601, 29, '莫罗贝', 'Morobe', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(602, 29, '南部高地', 'Southern Highlands', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(603, 29, '钦布', 'Simbu', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(604, 29, '桑道恩', 'Sandaun', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(605, 29, '西部', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(606, 29, '西部高地', 'Western Highlands', 'WH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(607, 29, '西新不列颠', 'West New Britain', 'WB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(608, 29, '新爱尔兰', 'New Ireland', 'NI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(609, 31, '白沙瓦', 'Peshawar', 'PEW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(610, 31, '费萨拉巴德', 'Faisalabad', 'LYP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(611, 31, '故吉软瓦拉', 'Gujranwala', 'GUJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(612, 31, '海德拉巴', 'Hyderabad', 'HDD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(613, 31, '卡拉奇', 'Karachi', 'KCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(614, 31, '拉合尔', 'Lahore', 'LHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(615, 31, '拉瓦尔品第', 'Rawalpindi', 'RWP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(616, 31, '木尔坦', 'Multan', 'MUX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(617, 31, '伊斯兰堡', 'Islamabad', 'ISB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(618, 32, '阿曼拜', 'Amambay', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(619, 32, '阿耶斯总统省', 'Presidente Hayes', 'PH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(620, 32, '巴拉瓜里', 'Paraguari', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(621, 32, '博克龙', 'Boqueron', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(622, 32, '瓜伊拉', 'Guaira', 'GU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(623, 32, '卡瓜苏', 'Caaguazu', 'CG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(624, 32, '卡嫩迪尤', 'Canindeyu', 'CN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(625, 32, '卡萨帕', 'Caazapa', 'CZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(626, 32, '康塞普西翁', 'Concepcion', 'CC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(627, 32, '科迪勒拉', 'Cordillera', 'CD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(628, 32, '米西奥内斯', 'Misiones', 'MI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(629, 32, '涅恩布库', 'Neembucu', 'NE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(630, 32, '上巴拉圭', 'Alto Paraguay', 'AG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(631, 32, '上巴拉那', 'Alto Parana', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(632, 32, '圣佩德罗', 'San Pedro', 'SP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(633, 32, '亚松森特别区', 'Asuncion', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(634, 32, '伊塔普亚', 'Itapua', 'IT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(635, 32, '中央', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(636, 33, '加沙地带', 'Gaza Strip', 'GZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(637, 33, '西岸', 'West Bank', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(638, 34, '北部', 'Ash-Shamaliyah', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(639, 34, '哈德', 'Al-Hadd', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(640, 34, '哈马德', 'Hammad', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(641, 34, '里法', 'Ar-Rifa', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(642, 34, '麦纳麦', 'Al-Manamah', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(643, 34, '穆哈拉格', 'Al-Muharraq', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(644, 34, '西部', 'Al-Gharbiyah', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(645, 34, '伊萨城', 'Isa', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(646, 34, '中部', 'Al-Wusta', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(647, 36, '阿克里', 'Acre', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(648, 36, '阿拉戈斯', 'Alagoas', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(649, 36, '阿马帕', 'Amapa', 'AP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(650, 36, '巴拉那', 'Parana', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(651, 36, '巴西利亚', 'Brasilia', 'BSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(652, 36, '巴伊亚', 'Bahia', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(653, 36, '北里奥格兰德', 'Rio Grande do Norte', 'RN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(654, 36, '伯南布哥', 'Pernambuco', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(655, 36, '戈亚斯', 'Goias', 'GO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(656, 36, '朗多尼亚', 'Rondonia', 'RO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(657, 36, '里约热内卢', 'Rio de Janeiro', 'RJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(658, 36, '罗赖马', 'Roraima', 'RR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(659, 36, '马拉尼昂', 'Maranhao', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(660, 36, '马托格罗索', 'Mato Grosso', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(661, 36, '米纳斯吉拉斯', 'Minas Gerais', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(662, 36, '南里奥格兰德', 'Rio Grande do Sul', 'RS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(663, 36, '南马托格罗索', 'Mato Grosso do Sul', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(664, 36, '帕拉', 'Para', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(665, 36, '帕拉伊巴', 'Paraiba', 'PB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(666, 36, '皮奥伊', 'Piaui', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(667, 36, '塞阿拉', 'Ceara', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(668, 36, '塞尔希培', 'Sergipe', 'SE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(669, 36, '圣埃斯皮里图', 'Espirito Santo', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(670, 36, '圣保罗', 'Sao Paulo', 'SP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(671, 36, '圣卡塔琳娜', 'Santa Catarina', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(672, 36, '托坎廷斯', 'Tocantins', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(673, 36, '亚马孙', 'Amazonas', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(674, 37, '布列斯特', 'Bresckaja', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(675, 37, '戈梅利', 'Homelskaja', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(676, 37, '格罗德诺', 'Hrodzenskaja', 'HR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(677, 37, '明斯克市', 'Minsk', 'MI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(678, 37, '莫吉廖夫', 'Mahileuskaja', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(679, 37, '维捷布斯克', 'Vicebskaja', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(680, 39, '布尔加斯', 'Burgas', 'BOJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(681, 39, '卡斯科伏', 'Khaskovo', 'KHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(682, 39, '鲁塞', 'Ruse', 'ROU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(683, 39, '洛维奇', 'Lovech', 'LVP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(684, 39, '蒙塔纳', 'Montana', 'OZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(685, 39, '普罗夫迪夫', 'Plovdiv', 'PDV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(686, 39, '索非亚', 'Sofiya', 'SOF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(687, 39, '索非亚市', 'Grad Sofiya', 'GSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(688, 39, '瓦尔纳', 'Varna', 'VAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(689, 41, '阿黎博里', 'Alibori', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(690, 41, '阿塔科拉', 'Atakora', 'AK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(691, 41, '滨海', 'Littoral', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(692, 41, '波希康市', 'Bohicon', 'BOH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(693, 41, '博尔古', 'Borgou', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(694, 41, '大西洋', 'Atlantique', 'AQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(695, 41, '高原', 'Plateau', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(696, 41, '库福', 'Kouffo', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(697, 41, '莫诺', 'Mono', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(698, 41, '丘陵', 'Collines', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(699, 41, '韦梅', 'Oueme', 'OU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(700, 41, '峡谷', 'Donga', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(701, 41, '祖', 'Zou', 'ZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(702, 42, '埃诺', 'Hainaut', 'WHT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(703, 42, '安特卫普', 'Antwerpen', 'VAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(704, 42, '布拉班特-瓦隆', 'Brabant-Wallone', 'WBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(705, 42, '布鲁塞尔', 'Brussels', 'BRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(706, 42, '东佛兰德', 'Oost-Vlaanderen', 'VOV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(707, 42, '佛兰芒-布拉班特', 'Vlaams-Brabant', 'VBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(708, 42, '列日', 'Liege', 'WLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(709, 42, '林堡', 'Limburg', 'VLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(710, 42, '卢森堡', 'Luxembourg', 'WLX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(711, 42, '那慕尔', 'Namur', 'WNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(712, 42, '西佛兰德', 'West-Vlaanderen', 'VWV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(713, 45, '埃尔布隆格', 'Elbląg', 'ELB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(714, 45, '奥尔什丁', 'Olsztyn', 'OLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(715, 45, '奥斯特罗文卡', 'Ostrołeka', 'OSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(716, 45, '比得哥什', 'Bydgoszcz', 'BZG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(717, 45, '彼得库夫', 'Piotrkow', 'PIO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(718, 45, '比托姆', 'Bytom', 'BYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(719, 45, '比亚瓦波德拉斯卡', 'Biała Podlaska', 'BAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(720, 45, '比亚维斯托克', 'Białystok', 'BIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(721, 45, '波莱', 'Opole', 'OPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(722, 45, '波兹南', 'Poznan', 'POZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(723, 45, '达布罗瓦戈尼察', 'Dabrowa Gornicza', 'DAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(724, 45, '大波兰地区戈茹夫', 'Gorzow Wlkp', 'GOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(725, 45, '弗罗茨瓦夫', 'Wroclaw', 'WRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(726, 45, '弗沃茨瓦韦克', 'Wlocławek', 'WLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(727, 45, '格但斯克', 'Gdansk', 'GDN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(728, 45, '格丁尼亚', 'Gdynia', 'GDY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(729, 45, '格利维采', 'Gliwice', 'GWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(730, 45, '格鲁琼兹', 'Grudziadz', 'GRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(731, 45, '海乌姆', 'Chełm', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(732, 45, '华沙', 'Warszawa', 'WAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(733, 45, '霍茹夫', 'Chorzow', 'CHZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(734, 45, '卡利什', 'Kalisz', 'KAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(735, 45, '卡托维兹', 'Katowice', 'KTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(736, 45, '凯尔采', 'Kielce', 'KLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(737, 45, '科宁', 'Konin', 'KON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(738, 45, '科沙林', 'Koszalin', 'OSZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(739, 45, '克拉科夫', 'Krakow', 'KRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(740, 45, '克罗斯诺', 'Krosno', 'KRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(741, 45, '拉多姆', 'Radom', 'RDM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(742, 45, '莱格尼察', 'Legnica', 'LEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(743, 45, '莱什诺', 'Leszno', 'LEZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(744, 45, '卢布林', 'Lublin', 'LUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(745, 45, '鲁达', 'Ruda Sl', 'RDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(746, 45, '罗兹', 'Lodz', 'LOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(747, 45, '绿山城', 'Zielona Gora', 'IEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(748, 45, '米什洛维采', 'Mysłowice', 'MYL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(749, 45, '皮瓦', 'Piła', 'PIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(750, 45, '普热梅希尔', 'Przemysl', 'PRZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(751, 45, '普沃茨克', 'Plock', 'PLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(752, 45, '切哈努夫', 'Ciechanow', 'CIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(753, 45, '热舒夫', 'Rzeszow', 'RZE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(754, 45, '什切青', 'Szczecin', 'SZZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(755, 45, '斯凯尔涅维采', 'Skierniewice', 'SKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(756, 45, '斯武普斯克', 'Slupsk', 'SLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(757, 45, '苏瓦乌基', 'Suwałki', 'SWL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(758, 45, '索波特', 'Sopot', 'SOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(759, 45, '索斯诺维茨', 'Sosnowiec', 'SWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(760, 45, '塔尔努夫', 'Tarnow', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(761, 45, '塔尔诺布热格', 'Tarnobrzeg', 'QEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(762, 45, '特切', 'Tychy', 'TYY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(763, 45, '托伦', 'Torun', 'TOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(764, 45, '瓦乌布日赫', 'Walbrzych', 'WZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(765, 45, '沃姆扎', 'Lomza', 'QOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(766, 45, '希米亚诺维采', 'Siemianowice Sl', 'SOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(767, 45, '希维诺乌伊希切', 'Swinoujscie', 'SWI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(768, 45, '希维托赫洛维采', 'Swietochłowice', 'SWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(769, 45, '谢德尔采', 'Siedlce', 'SDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(770, 45, '谢拉兹', 'Sieradz', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(771, 45, '新松奇', 'Nowy Sacz', 'NOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(772, 45, '雅沃兹诺', 'Jaworzno', 'JAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(773, 45, '耶莱尼亚古拉', 'Jelenia Gora', 'JEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(774, 45, '扎布热', 'Zabrze', 'ZAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(775, 45, '扎莫希奇', 'Zamosc', 'ZAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(776, 46, '奥尔托', 'El Alto', 'ALT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(777, 46, '奥鲁罗', 'Oruro', 'ORU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(778, 46, '贝尼', 'El Beni', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(779, 46, '波多西', 'Potosi', 'POI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(780, 46, '基拉科洛', 'Quillacollo', 'QUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(781, 46, '科恰班巴', 'Cochabamba', 'CBB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(782, 46, '拉巴斯', 'La Paz', 'LPB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(783, 46, '潘多', 'Pando', 'PAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(784, 46, '丘基萨卡', 'Chuquisaca', 'CHU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(785, 46, '萨卡巴', 'Sacaba', 'SAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(786, 46, '圣克鲁斯', 'Santa Cruz', 'SRZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(787, 46, '塔里哈', 'Tarija', 'TJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(788, 47, '波萨维纳', 'Posavski', 'FPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(789, 47, '波斯尼亚－波德里涅', 'Bosansko-Podrinjski', 'FBP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(790, 47, '多米斯拉夫格勒', 'Tomislavgrad', 'FTO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(791, 47, '黑塞哥维那－涅雷特瓦', 'Hercegovacko-Neretvanski', 'FHN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(792, 47, '萨拉热窝', 'Sarajevo', 'FSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(793, 47, '图兹拉－波德里涅', 'Tuzlanski-Podrinjski', 'FTU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(794, 47, '乌纳－萨纳', 'Unsko-Sanski', 'FUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(795, 47, '西波斯尼亚', 'Hercegovacko-Bosanski', 'FHB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(796, 47, '西黑塞哥维那', 'Zapadno-Hercegovaki', 'FZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(797, 47, '泽尼察－多博伊', 'Zenicko-Dobojski', 'FZE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(798, 47, '中波斯尼亚', 'Srednjo-Bosanski', 'FSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(799, 49, '伯利兹', 'Belize', 'BZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(800, 49, '橘园', 'Orange Walk', 'OW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(801, 49, '卡约', 'Cayo', 'CY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(802, 49, '科罗萨尔', 'Corozal', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(803, 49, '斯坦港', 'Stann Creek', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(804, 49, '托莱多', 'Toledo', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(805, 51, '巴雷', 'Bale', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(806, 51, '巴姆', 'Bam', 'BAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(807, 51, '巴瓦', 'Banwa', 'BAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(808, 51, '巴泽加', 'Bazega', 'BAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(809, 51, '波尼', 'Poni', 'PON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(810, 51, '布尔古', 'Boulgou', 'BLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(811, 51, '布尔基恩德', 'Boulkiemde', 'BOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(812, 51, '布古里巴', 'Bougouriba', 'BOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(813, 51, '冈祖尔古', 'Ganzourgou', 'GAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(814, 51, '古尔马', 'Gourma', 'GOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(815, 51, '济罗', 'Ziro', 'ZIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(816, 51, '卡焦戈', 'Kadiogo', 'KAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(817, 51, '凯内杜古', 'Kenedougou', 'KEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(818, 51, '科蒙加里', 'Komondjari', 'KOO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(819, 51, '科莫埃', 'Comoe', 'COM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(820, 51, '孔皮恩加', 'Kompienga', 'KOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(821, 51, '孔西', 'Kossi', 'KOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(822, 51, '库尔佩罗戈', 'Koulpelogo', 'KOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(823, 51, '库尔维奥戈', 'Kourweogo', 'KOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(824, 51, '库里滕加', 'Kouritenga', 'KOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(825, 51, '雷拉巴', 'Leraba', 'LER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(826, 51, '罗卢姆', 'Loroum', 'LOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(827, 51, '穆翁', 'Mouhoun', 'MOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(828, 51, '纳门滕加', 'Namentenga', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(829, 51, '纳乌里', 'Nahouri', 'NAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(830, 51, '纳亚拉', 'Nayala', 'NAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(831, 51, '尼亚尼亚', 'Gnagna', 'GNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(832, 51, '努姆比埃尔', 'Noumbiel', 'NOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(833, 51, '帕索雷', 'Passore', 'PAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(834, 51, '塞诺', 'Seno', 'SEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(835, 51, '桑吉', 'Sanguie', 'SAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(836, 51, '桑马滕加', 'Sanmatenga', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(837, 51, '苏鲁', 'Sourou', 'SOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(838, 51, '苏姆', 'Soum', 'SOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(839, 51, '塔波阿', 'Tapoa', 'TAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(840, 51, '图伊', 'Tuy', 'TUY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(841, 51, '乌埃', 'Houet', 'HOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(842, 51, '乌布里滕加', 'Oubritenga', 'OUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(843, 51, '乌达兰', 'Oudalan', 'OUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(844, 51, '锡西里', 'Sissili', 'SIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(845, 51, '亚加', 'Yagha', 'YAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(846, 51, '亚滕加', 'Yatenga', 'YAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(847, 51, '伊奥巴', 'Ioba', 'IOA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(848, 51, '宗德韦奥戈', 'Zoundweogo', 'ZOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(849, 51, '宗多马', 'Zondoma', 'ZOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(850, 52, '布班扎', 'Bubanza', 'BB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(851, 52, '布鲁里', 'Bururi', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(852, 52, '布琼布拉城市', 'Bujumbura Mairie', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(853, 52, '布琼布拉乡村', 'Bujumbura Rural', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(854, 52, '恩戈齐', 'Ngozi', 'NG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(855, 52, '基龙多', 'Kirundo', 'KI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(856, 52, '基特加', 'Gitega', 'GI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(857, 52, '卡鲁济', 'Karuzi', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(858, 52, '卡扬扎', 'Kayanza', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(859, 52, '坎库佐', 'Cankuzo', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(860, 52, '鲁塔纳', 'Rutana', 'RT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(861, 52, '鲁伊吉', 'Ruyigi', 'RY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(862, 52, '马坎巴', 'Makamba', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(863, 52, '穆拉姆维亚', 'Muramvya', 'MU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(864, 52, '穆瓦洛', 'Mwaro', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(865, 52, '穆因加', 'Muyinga', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(866, 52, '锡比托凯', 'Cibitoke', 'CI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(867, 54, '海州', 'Haeju', 'HAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(868, 54, '惠山', 'Hyesan', 'HYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(869, 54, '江界', 'Kanggye', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(870, 54, '开城', 'Kaesong', 'KSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(871, 54, '罗先', 'Naseon', 'NAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(872, 54, '南浦', 'Namp''o', 'NAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(873, 54, '平壤', 'Pyongyang', 'FNJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(874, 54, '清津', 'Ch''ongjin', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(875, 54, '沙里院', 'Sariwon', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(876, 54, '咸兴', 'Hamhung', 'HAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(877, 54, '新义州', 'Sinuiju', 'SII', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(878, 54, '元山', 'Wonsan', 'WON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(879, 55, '奥胡斯', 'Aarhus', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(880, 55, '北日德兰', 'Nordjylland', 'VSV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(881, 55, '博恩霍尔姆', 'Bornholm', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(882, 55, '菲特烈堡', 'Frederiksborg', 'FRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(883, 55, '菲茵', 'Fyn', 'FY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(884, 55, '哥本哈根', 'Copenhagen', 'CPH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(885, 55, '里伯', 'Ribe', 'RIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(886, 55, '灵克宾', 'Ringkoebing', 'RKG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(887, 55, '罗斯基勒', 'Roskilde', 'RKE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(888, 55, '南日德兰', 'Soenderjylland', 'VBI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(889, 55, '斯多斯特姆', 'Storstroem', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(890, 55, '维堡', 'Viborg', 'VIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(891, 55, '维厄勒', 'Vejle', 'VEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(892, 55, '西希兰', 'Vestsjaelland', 'VS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(893, 56, '阿恩斯贝格', 'Arnsberg', 'ARN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(894, 56, '爱尔福特', 'Erfurt', 'ERF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(895, 56, '安斯巴格', 'Ansbach', 'ANS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(896, 56, '奥格斯堡', 'Augsburg', 'AGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(897, 56, '柏林', 'Berlin', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(898, 56, '拜伊罗特', 'Bayreuth', 'BYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(899, 56, '比勒费尔德', 'Bielefeld', 'BFE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(900, 56, '波茨坦', 'Potsdam', 'POT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(901, 56, '波鸿', 'Bochum', 'BOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(902, 56, '不来梅', 'Bremen', 'HB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(903, 56, '不伦瑞克', 'Brunswick', 'BRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(904, 56, '达姆施塔特', 'Darmstadt', 'DAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(905, 56, '代特莫尔特', 'Detmold', 'DET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(906, 56, '德累斯顿', 'Dresden', 'DRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(907, 56, '德绍', 'Dessau', 'DES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(908, 56, '杜塞尔多夫', 'Dusseldorf', 'DUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(909, 56, '法兰克福', 'Frankfurt', 'FFO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(910, 56, '弗赖堡', 'Freiburg', 'FBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(911, 56, '哈雷', 'Halle', 'HAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(912, 56, '汉堡', 'Hamburg', 'HH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(913, 56, '汉诺威', 'Hannover', 'HAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(914, 56, '基尔', 'Kiel', 'KEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(915, 56, '吉森', 'GieBen', 'GBN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(916, 56, '卡尔斯鲁厄', 'Karlsruhe', 'KAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(917, 56, '卡塞尔', 'Kassel', 'KAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(918, 56, '开姆尼斯', 'Chemnitz', 'CHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(919, 56, '科布伦次', 'Koblenz', 'KOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(920, 56, '科隆', 'Cologne', 'CGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(921, 56, '莱比锡', 'Leipzig', 'LEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(922, 56, '兰茨胡特', 'Landshut', 'LDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(923, 56, '吕讷堡', 'Luneburg', 'LBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(924, 56, '马格德堡', 'Magdeburg', 'MAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(925, 56, '曼海姆', 'Mannheim', 'MHG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(926, 56, '美因兹', 'Mainz', 'MAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(927, 56, '明斯特', 'Muenster', 'MUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(928, 56, '慕尼黑', 'Munich', 'MUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(929, 56, '纽伦堡', 'Nuremberg', 'NUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(930, 56, '什未林', 'Schwerin', 'SWH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(931, 56, '斯图加特', 'Stuttgart', 'STR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(932, 56, '特里尔', 'Trier', 'TRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(933, 56, '威斯巴登', 'Wiesbaden', 'WIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(934, 56, '维尔茨堡', 'Wuerzburg', 'WUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(935, 57, '阿伊莱乌', 'Aileu', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(936, 57, '阿伊纳罗', 'Ainaro', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(937, 57, '埃尔梅拉', 'Ermera', 'ER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(938, 57, '安贝诺', 'Ambeno', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(939, 57, '包考', 'Baucau', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(940, 57, '博博纳罗', 'Bobonaro', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(941, 57, '帝力', 'Dili', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(942, 57, '科瓦利马', 'Kovalima', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(943, 57, '劳滕', 'Lautem', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(944, 57, '利基卡', 'Liquica', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(945, 57, '马纳图托', 'Manatuto', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(946, 57, '马努法伊', 'Manofahi', 'MF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(947, 57, '维克克', 'Viqueque', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(948, 58, '滨海区', 'Maritime', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(949, 58, '草原区', 'Savanes', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(950, 58, '高原区', 'Plateaux', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(951, 58, '卡拉区', 'Kara', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(952, 58, '中部区', 'Centre', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(953, 61, '阿巴坎', 'Abakan', 'ABA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(954, 61, '阿尔汉格尔斯克', 'Arkhangelsk', 'ARK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(955, 61, '阿金斯科耶', 'Aginskoye', 'AGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(956, 61, '阿纳德尔', 'Anadyr', 'DYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(957, 61, '阿斯特拉罕', 'Astrakhan', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(958, 61, '埃利斯塔', 'Elista', 'ESL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(959, 61, '奥廖尔', 'Orel', 'ORL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(960, 61, '奥伦堡', 'Orenburg', 'ORE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(961, 61, '巴尔瑙尔', 'Barnaul', 'BAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(962, 61, '奔萨', 'Penza', 'PNZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(963, 61, '彼得罗巴甫洛夫斯克', 'Petropavlovsk-Kamchatskiy', 'PKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(964, 61, '彼得罗扎沃茨克', 'Petrozavodsk', 'PES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(965, 61, '彼尔姆', 'Perm', 'PER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(966, 61, '比罗比詹', 'Birobidzan', 'BBZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(967, 61, '别尔哥罗德', 'Belgorod', 'BEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(968, 61, '伯力', 'Chabarovsk', 'COK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(969, 61, '布拉戈维申斯克', 'Blagoveshchensk', 'BQS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(970, 61, '布良斯克', 'Bryansk', 'BRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(971, 61, '车里雅宾斯克', 'Chelyabinsk', 'CHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(972, 61, '赤塔', 'Chita', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(973, 61, '顿河畔罗斯托夫', 'Rostov-na-Donu', 'ROS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(974, 61, '鄂木斯克', 'Omsk', 'OMS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(975, 61, '伏尔加格勒', 'Volgograd', 'VOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(976, 61, '弗拉基米尔', 'Vladimir', 'VMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(977, 61, '弗拉季高加索', 'Vladikavkaz', 'VLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(978, 61, '戈尔诺－阿尔泰斯克', 'Gorno-Altajsk', 'GOA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(979, 61, '格罗兹尼', 'Grozny', 'GRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(980, 61, '海参崴', 'Vladivostok', 'VVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(981, 61, '汉特－曼西斯克', 'Khanty-Mansiysk', 'KHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(982, 61, '基洛夫', 'Kirov', 'KIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(983, 61, '加里宁格勒', 'Kaliningrad', 'KGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(984, 61, '喀山', 'Kazan', 'KZN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(985, 61, '卡卢加', 'Kaluga', 'KLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(986, 61, '科斯特罗马', 'Kostroma', 'KOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(987, 61, '克拉斯诺达尔', 'Krasnodar', 'KRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(988, 61, '克拉斯诺亚尔斯克', 'Krasnojarsk', 'KYA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(989, 61, '克麦罗沃', 'Kemerovo', 'KEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(990, 61, '克孜勒', 'Kyzyl', 'KYZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(991, 61, '库德姆卡尔', 'Kudymkar', 'KUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(992, 61, '库尔干', 'Kurgan', 'KRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(993, 61, '库尔斯克', 'Kursk', 'URS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(994, 61, '利佩茨克', 'Lipeck', 'LIP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(995, 61, '梁赞', 'Ryazan', 'RYA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(996, 61, '马哈奇卡拉', 'Makhachkala', 'MCX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(997, 61, '马加丹', 'Magadan', 'MAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(998, 61, '马加斯', 'Magas', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(999, 61, '迈科普', 'Maykop', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1000, 61, '摩尔曼斯克', 'Murmansk', 'MMK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1001, 61, '莫斯科', 'Moscow', 'MOW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1002, 61, '纳尔奇克', 'Nalchik', 'NAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1003, 61, '纳里扬马尔', 'Naryan-Mar', 'NNM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1004, 61, '南萨哈林斯克', 'Juzno-Sachalinsk', 'JSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1005, 61, '诺夫哥罗德', 'Velikij Novgorod', 'VUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1006, 61, '帕拉纳', 'Palana', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1007, 61, '普斯科夫', 'Pskov', 'PSK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1008, 61, '切博克萨雷', 'Cheboksary', 'CSY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1009, 61, '切尔克斯克', 'Cherkessk', 'CKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1010, 61, '秋明', 'Tyumen', 'TYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1011, 61, '萨拉托夫', 'Saratov', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1012, 61, '萨兰斯克', 'Saransk', 'SKX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1013, 61, '萨列哈尔德', 'Salekhard', 'SLY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1014, 61, '萨马拉', 'Samara', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1015, 61, '瑟克特夫卡尔', 'Syktyvkar', 'SCW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1016, 61, '圣彼得堡', 'St. Peterburg', 'SPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1017, 61, '斯摩棱斯克', 'Smolensk', 'LNX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1018, 61, '斯塔夫罗波尔', 'Stavropol', 'STA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1019, 61, '坦波夫', 'Tambov', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1020, 61, '特维尔', 'Tver', 'TVE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1021, 61, '图拉', 'Tula', 'TUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1022, 61, '托木斯克', 'Tomsk', 'TOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1023, 61, '沃罗涅什', 'Voronezh', 'VOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1024, 61, '沃洛格达', 'Vologda', 'VLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1025, 61, '乌法', 'Ufa', 'UFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1026, 61, '乌兰乌德', 'Ulan-Ude', 'UUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1027, 61, '乌里扬诺夫斯克', 'Uljanovsk', 'ULY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1028, 61, '乌斯季奥尔登斯基', 'Ust-Ordynsky', 'UOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1029, 61, '下诺夫哥罗德', 'Niznij Novgorod', 'GOJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1030, 61, '新西伯利亚', 'Novosibirsk', 'NVS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1031, 61, '雅库茨克', 'Jakutsk', 'JAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1032, 61, '雅罗斯拉夫尔', 'Jaroslavl', 'JAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1033, 61, '叶卡捷林堡', 'Jekaterinburg', 'JEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1034, 61, '伊尔库茨克', 'Irkutsk', 'IKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1035, 61, '伊热夫斯克', 'Izhevsk', 'IJK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1036, 61, '伊万诺沃', 'Ivanovo', 'IVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1037, 61, '约什卡尔奥拉', 'Yoshkar-Ola', 'YOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1038, 62, '阿苏艾', 'Azuay', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1039, 62, '埃尔奥罗', 'El Oro', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1040, 62, '埃斯梅拉尔达斯', 'Esmeraldas', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1041, 62, '玻利瓦尔', 'Bolivar', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1042, 62, '瓜亚斯', 'Guayas', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1043, 62, '加拉帕戈斯', 'Galapagos', 'W', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1044, 62, '卡尔奇', 'Carchi', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1045, 62, '卡尼亚尔', 'Canar', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1046, 62, '科托帕希', 'Cotopaxi', 'X', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1047, 62, '洛哈', 'Loja', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1048, 62, '洛斯里奥斯', 'Los Rios', 'R', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1049, 62, '马纳比', 'Manabi', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1050, 62, '莫罗纳－圣地亚哥', 'Morona-Santiago', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1051, 62, '纳波，奥雷利亚纳', 'Napo, Orellana', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1052, 62, '帕斯塔萨', 'Pastaza', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1053, 62, '皮钦查', 'Pichincha', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1054, 62, '钦博拉索', 'Chimborazo', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1055, 62, '萨莫拉－钦奇佩', 'Zamora-Chinchipe', 'Z', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1056, 62, '苏昆毕奥斯', 'Sucumbios', 'U', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1057, 62, '通古拉瓦', 'Tungurahua', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1058, 62, '因巴布拉', 'Imbabura', 'I', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1059, 63, '安塞巴', 'Anseba', 'KE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1060, 63, '北红海', 'Semenawi Keyih Bahri', 'SK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1061, 63, '加什·巴尔卡', 'Gash Barka', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1062, 63, '南部', 'Debub', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1063, 63, '南红海', 'Debubawi Keyih Bahri', 'DK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1064, 63, '中部', 'Maekel', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1065, 64, '阿尔勒', 'Arles', 'ARL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1066, 64, '阿雅克修', 'Ajaccio', 'AJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1067, 64, '艾克斯', 'Aix-en-Provence', 'QXB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1068, 64, '奥尔良', 'Orleans', 'ORR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1069, 64, '巴黎', 'Paris', 'PAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1070, 64, '贝桑松', 'Besancon', 'BSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1071, 64, '第戎', 'Dijon', 'DIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1072, 64, '弗雷瑞斯', 'Frejus', 'FRJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1073, 64, '卡昂', 'Caen', 'CFR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1074, 64, '雷恩', 'Rennes', 'RNS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1075, 64, '里昂', 'Lyon', 'LIO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1076, 64, '里尔', 'Lille', 'LLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1077, 64, '利摩日', 'Limoges', 'LIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1078, 64, '鲁昂', 'Rouen', 'URO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1079, 64, '马赛', 'Marseille', 'MRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1080, 64, '梅斯', 'Metz', 'MZM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1081, 64, '蒙彼利埃', 'Montpellier', 'MPL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1082, 64, '南特', 'Nantes', 'NTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1083, 64, '尼斯', 'Nice', 'NCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1084, 64, '沙隆', 'Chalons-en-Champagne', 'CSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1085, 64, '图卢兹', 'Toulouse', 'TLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1086, 64, '瓦朗斯', 'Valence', 'VAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1087, 64, '亚眠', 'Amiens', 'AMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1088, 70, '达沃', 'Davao', 'DOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1089, 70, '卡卢坎', 'Caloocan', 'CAO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1090, 70, '马尼拉', 'Manila', 'MNL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1091, 70, '宿务', 'Cebu', 'CEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1092, 72, '埃斯波', 'Espoo', 'ESP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1093, 72, '奥卢', 'Oulu', 'OLU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1094, 72, '波里', 'Pori', 'POR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1095, 72, '博尔沃', 'Porvoo', 'PRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1096, 72, '海门林纳', 'Hameenlinna', 'HMY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1097, 72, '赫尔辛基', 'Helsinki', 'HEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1098, 72, '卡亚尼', 'Kajaani', 'KAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1099, 72, '科科拉', 'Kokkola', 'KOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(1100, 72, '科特卡', 'Kotka', 'KTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1101, 72, '库奥皮奥', 'Kuopio', 'KUO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1102, 72, '拉赫蒂', 'Lahti', 'LHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1103, 72, '拉彭兰塔', 'Lappeenranta', 'LPP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1104, 72, '罗瓦涅米', 'Rovaniemi', 'RVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1105, 72, '玛丽港', 'Mariehamn', 'MHQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1106, 72, '米凯利', 'Mikkeli', 'MIK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1107, 72, '坦佩雷', 'Tampere', 'TMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1108, 72, '图尔库', 'Turku', 'TKU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1109, 72, '瓦萨', 'Vaasa', 'VAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1110, 72, '万塔', 'Vantaa', 'VAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1111, 72, '约恩苏', 'Joensuu', 'JOE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1112, 73, '保尔', 'Paul', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1113, 73, '波多诺伏', 'Porto Novo', 'PN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1114, 73, '博阿维斯塔岛', 'Boa Vista', 'BV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1115, 73, '布拉瓦岛', 'Brava', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1116, 73, '大里贝拉', 'Ribeira Grande', 'RG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1117, 73, '福古岛', 'Fogo', 'FO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1118, 73, '马尤岛', 'Maio', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1119, 73, '莫斯特罗', 'Mosteiros', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1120, 73, '普拉亚', 'Praia', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1121, 73, '萨尔岛', 'Sal', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1122, 73, '圣安唐岛', 'Santo Antao', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1123, 73, '圣地亚哥岛', 'Santiago', 'IA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1124, 73, '圣多明戈', 'Sao Domingos', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1125, 73, '圣菲利普', 'Sao Filipe', 'SF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1126, 73, '圣卡塔琳娜', 'Santa Catarina', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1127, 73, '圣克鲁斯', 'Santa Cruz', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1128, 73, '圣米戈尔', 'Sao Miguel', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1129, 73, '圣尼古拉岛', 'Sao Nicolau', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1130, 73, '圣维森特岛', 'Sao Vicente', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1131, 73, '塔拉法尔', 'Tarrafal', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1132, 78, '阿劳卡', 'Arauca', 'ARA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1133, 78, '安提奥基亚', 'Antioquia', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1134, 78, '北桑坦德', 'Norte de Santander', 'NDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1135, 78, '波哥大首都区', 'Bogota', 'BDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1136, 78, '博利瓦尔', 'Bolivar', 'BOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1137, 78, '博亚卡', 'Boyaca', 'BOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1138, 78, '大西洋', 'Atlantico', 'ATL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1139, 78, '瓜维亚雷', 'Guaviare', 'GVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1140, 78, '瓜希拉', 'La Guajira', 'GJR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1141, 78, '瓜伊尼亚', 'Guainia', 'GNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1142, 78, '金迪奥', 'Quindio', 'QUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1143, 78, '卡尔达斯', 'Caldas', 'CAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1144, 78, '卡克塔', 'Caqueta', 'CAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1145, 78, '卡萨纳雷', 'Casanare', 'CAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1146, 78, '考卡', 'Cauca', 'CAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1147, 78, '考卡山谷', 'Valle del Cauca', 'VDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1148, 78, '科尔多巴', 'Cordoba', 'COR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1149, 78, '昆迪纳马卡', 'Cundinamarca', 'CAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1150, 78, '利萨拉尔达', 'Risaralda', 'RIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1151, 78, '马格达雷那', 'Magdalena', 'MAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1152, 78, '梅塔', 'Meta', 'MET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1153, 78, '纳里尼奥', 'Narino', 'NAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1154, 78, '普图马约', 'Putumayo', 'PUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1155, 78, '乔科', 'Choco', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1156, 78, '塞萨尔', 'Cesar', 'CES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1157, 78, '桑坦德', 'Santander', 'SAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1158, 78, '圣安德烈斯-普罗维登西亚', 'San Andres y Providencia', 'SAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1159, 78, '苏克雷', 'Sucre', 'SUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1160, 78, '托利马', 'Tolima', 'TOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1161, 78, '维查达', 'Vichada', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1162, 78, '沃佩斯', 'Vaupes', 'VAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1163, 78, '乌伊拉', 'Huila', 'HUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1164, 78, '亚马孙', 'Amazonas', 'AMZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1165, 79, '阿拉胡埃拉', 'Alajuela', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1166, 79, '埃雷迪亚', 'Heredia', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1167, 79, '瓜纳卡斯特', 'Guanacaste', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1168, 79, '卡塔戈', 'Cartago', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1169, 79, '利蒙', 'Limon', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1170, 79, '蓬塔雷纳斯', 'Puntarenas', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1171, 79, '圣何塞', 'San Jose', 'SJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1172, 83, '奥尔金', 'Holguin', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1173, 83, '比那尔德里奥', 'Pinar del Rio', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1174, 83, '比亚克拉拉', 'Villa Clara', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1175, 83, '格拉玛', 'Granma', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1176, 83, '关塔那摩', 'Guantanamo', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1177, 83, '哈瓦那', 'La Habana', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1178, 83, '哈瓦那城', 'Ciudad de la Habana', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1179, 83, '卡马圭', 'Camaguey', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1180, 83, '拉斯图纳斯', 'Las Tunas', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1181, 83, '马坦萨斯', 'Matanzas', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1182, 83, '马亚里', 'Mayari', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1183, 83, '曼萨尼罗', 'Manzanillo', 'MZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1184, 83, '青年岛特区', 'Isla de la Juventud', '99', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1185, 83, '圣地亚哥', 'Santiago de Cuba', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1186, 83, '圣斯皮里图斯', 'Sancti Spiritus', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1187, 83, '西恩富戈斯', 'Cienfuegos', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1188, 83, '谢戈德阿维拉', 'Ciego de Avila', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1189, 86, '埃塞奎博群岛-西德梅拉拉', 'Essequibo Islands-West Demerara', 'EW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1190, 86, '巴里马-瓦伊尼', 'Barima-Waini', 'BW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1191, 86, '波默伦-苏佩纳姆', 'Pomeroon-Supenaam', 'PM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1192, 86, '波塔罗-锡帕鲁尼', 'Potaro-Siparuni', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1193, 86, '德梅拉拉-马海卡', 'Demerara-Mahaica', 'DM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1194, 86, '东伯比斯-科兰太因', 'East Berbice-Corentyne', 'EC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1195, 86, '库尤尼-马扎鲁尼', 'Cuyuni-Mazaruni', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1196, 86, '马海卡-伯比斯', 'Mahaica-Berbice', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1197, 86, '上德梅拉拉-伯比斯', 'Upper Demerara-Berbice', 'UD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1198, 86, '上塔库图-上埃塞奎博', 'Upper Takutu-Upper Essequibo', 'UT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1199, 87, '阿尔卡累克', 'Arkalyk', 'AYK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1200, 87, '阿克莫拉', 'Aqmola', 'AKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1201, 87, '阿克苏', 'Aksu', 'AKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1202, 87, '阿克托别', 'Aqtobe', 'AKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1203, 87, '阿拉木图', 'Almaty', 'ALA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1204, 87, '阿雷斯', 'Arys', 'ARY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1205, 87, '阿斯塔纳市', 'Astana', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1206, 87, '阿特劳', 'Atyrau', 'ATY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1207, 87, '埃基巴斯图兹', 'Ekibastuz', 'EKB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1208, 87, '巴尔喀什', 'Balkhash', 'BXH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1209, 87, '巴甫洛达尔', 'Pavlodar', 'PAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1210, 87, '北哈萨克斯坦', 'Soltustik Qazaqstan', 'SEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1211, 87, '东哈萨克斯坦', 'Shyghys Qazaqstan', 'VOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1212, 87, '济良诺夫斯克', 'Zyryanovsk', 'ZYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1213, 87, '江布尔', 'Zhambyl', 'DMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1214, 87, '杰兹卡兹甘', 'Zhezkazgan', 'DZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1215, 87, '卡拉干达', 'Qaraghandy', 'KAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1216, 87, '卡拉扎尔', 'Karazhal', 'KZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1217, 87, '卡普恰盖', 'Kapchagay', 'KAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1218, 87, '科斯塔奈', 'Qostanay', 'KST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1219, 87, '克孜勒奥尔达', 'Qyzylorda', 'KZY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1220, 87, '肯套', 'Kentau', 'KEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1221, 87, '库尔恰托夫', 'Kurchatov', 'KUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1222, 87, '利萨科夫斯克', 'Lisakovsk', 'LKK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1223, 87, '列宁诺戈尔斯克', 'Leninogorsk', 'LEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1224, 87, '鲁德内', 'Rudny', 'RUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1225, 87, '曼格斯套', 'Mangghystau', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1226, 87, '南哈萨克斯坦', 'Ongtustik Qazaqstan', 'KGT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1227, 87, '萨兰', 'Saran', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1228, 87, '塞梅伊', 'Semey', 'SEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1229, 87, '沙赫京斯克', 'Shakhtinsk', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1230, 87, '斯捷普诺戈尔斯克', 'Stepnogorsk', 'STE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1231, 87, '铁克利', 'Tekeli', 'TEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1232, 87, '铁米尔套', 'Temirtau', 'TEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1233, 87, '突厥斯坦', 'Turkestan', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1234, 87, '西哈萨克斯坦', 'Batys Qazaqstan', 'ZAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1235, 87, '扎纳奥津', 'Zhanaozen', 'ZHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1236, 90, '阿尔梅勒', 'Almere', 'AER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1237, 90, '阿默斯福特', 'Amersfoort', 'AME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1238, 90, '阿姆斯特丹', 'Amsterdam', 'AMS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1239, 90, '阿纳姆', 'Arnhem', 'ARN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1240, 90, '阿珀尔多伦', 'Apeldoorn', 'APE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1241, 90, '阿森', 'Assen', 'ASS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1242, 90, '埃德', 'Ede', 'EDE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1243, 90, '埃门', 'Emmen', 'EMM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1244, 90, '埃因霍芬', 'Eindhoven', 'EIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1245, 90, '布雷达', 'Breda', 'BRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1246, 90, '蒂尔堡', 'Tilburg', 'TLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1247, 90, '多德雷赫特', 'Dordrecht', 'DOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1248, 90, '恩斯赫德', 'Enschede', 'ENS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1249, 90, '格罗宁根', 'Groningen', 'GRQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1250, 90, '哈勒姆', 'Haarlem', 'HRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1251, 90, '海牙', 'Hague', 'HAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1252, 90, '霍夫多尔普', 'Hoofddorp', 'HFD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1253, 90, '莱顿', 'Leiden', 'LID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1254, 90, '莱利斯塔德', 'Lelystad', 'LEY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1255, 90, '鹿特丹', 'Rotterdam', 'RTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1256, 90, '吕伐登', 'Leeuwarden', 'LWR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1257, 90, '马斯特里赫特', 'Maastricht', 'MST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1258, 90, '米德尔堡', 'Middelburg', 'MDL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1259, 90, '奈梅亨', 'Nijmegen', 'NIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1260, 90, '斯海尔托亨博思', '''s-Hertogenbosch', 'HTB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1261, 90, '乌得勒支', 'Utrecht', 'UTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1262, 90, '兹沃勒', 'Zwolle', 'ZWO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1263, 90, '佐特尔梅', 'Zoetermeer', 'ZTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1264, 93, '阿特兰蒂达', 'Atlantida', 'AT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1265, 93, '埃尔帕拉伊索', 'El Paraiso', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1266, 93, '奥科特佩克', 'Ocotepeque', 'OC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1267, 93, '奥兰乔', 'Olancho', 'OL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1268, 93, '弗朗西斯科-莫拉桑', 'Francisco Morazan', 'FM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1269, 93, '格拉西亚斯-阿迪奥斯', 'Gracias a Dios', 'GD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1270, 93, '海湾群岛', 'Islas de la Bahia', 'IB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1271, 93, '科尔特斯', 'Cortes', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1272, 93, '科隆', 'Colon', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1273, 93, '科马亚瓜', 'Comayagua', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1274, 93, '科潘', 'Copan', 'CP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1275, 93, '拉巴斯', 'La Paz', 'PZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1276, 93, '伦皮拉', 'Lempira', 'LE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1277, 93, '乔卢特卡', 'Choluteca', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1278, 93, '乔罗马', 'Choloma', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1279, 93, '山谷', 'Valle', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1280, 93, '圣巴巴拉', 'Santa Barbara', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1281, 93, '因蒂布卡', 'Intibuca', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1282, 93, '约罗', 'Yoro', 'YO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1283, 94, '菲尼克斯群岛', 'Phoenix Islands', 'PHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1284, 94, '吉尔伯特群岛', 'Gilberts Islands', 'GIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1285, 94, '莱恩群岛', 'Line Islands', 'LIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1286, 95, '阿里萨比赫区', 'Ali Sabih', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1287, 95, '奥博克区', 'Obock', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1288, 95, '迪基勒区', 'Dikhil', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1289, 95, '塔朱拉区', 'Tadjoura', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1290, 96, '奥什', 'Osh', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1291, 96, '巴特肯', 'Batken', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1292, 96, '比什凯克市', 'Bishkek', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1293, 96, '楚河', 'Chuy', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1294, 96, '贾拉拉巴德', 'Jalal-Abad', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1295, 96, '卡拉巴尔塔', 'Karabalta', 'KBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1296, 96, '卡拉库尔', 'Kara-Kol', 'KKO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1297, 96, '坎特', 'Kant', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1298, 96, '科克扬加克', 'Kok-Jangak', 'KJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1299, 96, '迈利赛', 'Mailuu-Suu', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1300, 96, '纳伦', 'Naryn', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1301, 96, '苏卢克图', 'Suluktu', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1302, 96, '塔拉斯', 'Talas', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1303, 96, '塔什库梅尔', 'Tash-Kumyr', 'TK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1304, 96, '乌兹根', 'Uzgen', 'UG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1305, 96, '伊塞克湖', 'Ysyk-Kol', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1306, 97, '博凯', 'Boke', 'BOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1307, 97, '恩泽雷科雷', 'Nzerekore', 'NZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1308, 97, '法拉纳', 'Faranah', 'FRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1309, 97, '金迪亚', 'Kindia', 'KND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1310, 97, '康康', 'Kankan', 'KNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1311, 97, '科纳克里', 'Conakry', 'CNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1312, 97, '拉贝', 'Labe', 'LAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1313, 97, '玛木', 'Mamou', 'MAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1314, 99, '阿伯茨福', 'Abbotsford', 'ABB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1315, 99, '埃德蒙顿', 'Edmonton', 'EDM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1316, 99, '奥沙瓦', 'Oshawa', 'OSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1317, 99, '巴里', 'Barrie', 'BAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1318, 99, '布列塔尼角', 'Cape Breton', 'CBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1319, 99, '多伦多', 'Toronto', 'TOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1320, 99, '弗雷德里顿', 'Fredericton', 'FRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1321, 99, '圭尔夫', 'Guelph', 'GLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1322, 99, '哈利法克斯', 'Halifax', 'HAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1323, 99, '哈密尔顿', 'Hamilton', 'HAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1324, 99, '怀特霍斯', 'Whitehorse', 'YXY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1325, 99, '基劳纳', 'Kelowna', 'KWL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1326, 99, '基奇纳', 'Brampton', 'BRP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1327, 99, '金斯敦', 'Kingston', 'KGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1328, 99, '卡里加里', 'Calgary', 'CAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1329, 99, '魁北克', 'Quebec', 'QUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1330, 99, '里贾纳', 'Regina', 'REG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1331, 99, '伦敦', 'London', 'LOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1332, 99, '蒙特利尔', 'Montreal', 'MTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1333, 99, '萨德伯里', 'Sudbury', 'SUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1334, 99, '萨斯卡通', 'Saskatoon', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1335, 99, '三河城', 'Trois-Rivieres', 'TRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1336, 99, '桑德贝', 'Thunder Bay', 'THU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1337, 99, '舍布鲁克', 'Sherbrooke', 'SBE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1338, 99, '圣卡塔琳娜', 'St. Catharines', 'SCA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1339, 99, '圣约翰斯', 'Saint-John''s', 'SJB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1340, 99, '维多利亚', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1341, 99, '温哥华', 'Vancouver', 'VAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1342, 99, '温尼伯', 'Winnipeg', 'WNP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1343, 99, '温莎', 'Windsor', 'WDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1344, 99, '渥太华', 'Ottawa', 'OTT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1345, 99, '夏洛特敦', 'Charlottetown', 'CHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1346, 99, '耶洛奈夫', 'Yellowknife', 'YZF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1347, 99, '伊魁特', 'Iqaluit', 'IQL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1348, 100, '阿散蒂', 'Ashanti', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1349, 100, '奥布阿西', 'Obuasi', 'OBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1350, 100, '北部', 'Northern', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1351, 100, '布朗阿哈福', 'Brong Ahafo', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1352, 100, '大阿克拉', 'Greater Accra', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1353, 100, '东部', 'Eastern', 'EA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1354, 100, '上东部', 'Upper East', 'UE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1355, 100, '上西部', 'Upper West', 'UW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1356, 100, '沃尔特', 'Volta', 'VO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1357, 100, '西部', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1358, 100, '中部', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1359, 101, '奥果韦-洛洛', 'Ogooue-Lolo', 'OL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1360, 101, '奥果韦-伊温多', 'Ogooue-Ivindo', 'OI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1361, 101, '滨海奥果韦', 'Ogooue-Maritime', 'OM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1362, 101, '恩古涅', 'Ngounie', 'NG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1363, 101, '河口', 'Estuaire', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1364, 101, '尼扬加', 'Nyanga', 'NY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1365, 101, '上奥果韦', 'Haut-Ogooue', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1366, 101, '沃勒-恩特姆', 'Woleu-Ntem', 'WN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1367, 101, '中奥果韦', 'Moyen-Ogooue', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1368, 102, '奥多棉吉', 'Otdar Mean Chey', 'OC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1369, 102, '白马市', 'Krong Keb', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1370, 102, '柏威夏', 'Preah Vihear', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1371, 102, '拜林市', 'Krong Pailin', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1372, 102, '班迭棉吉', 'Banteay Mean Chey', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1373, 102, '磅清扬', 'Kampong Chhnang', 'KZC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1374, 102, '磅士卑', 'Kampong Spoe', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1375, 102, '磅同', 'Kampong Thum', 'KZK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1376, 102, '磅湛', 'Kampong Cham', 'KM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1377, 102, '波罗勉', 'Prey Veng', 'PG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1378, 102, '茶胶', 'Takev', 'TK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1379, 102, '柴桢', 'Svay Rieng', 'SVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1380, 102, '干丹', 'Kandal', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1381, 102, '戈公', 'Kaoh Kong', 'KKZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1382, 102, '贡布', 'Kampot', 'KMT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1383, 102, '金边市', 'Phnum Penh', 'PNH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1384, 102, '桔井', 'Kracheh', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1385, 102, '腊塔纳基里', 'Rotanak Kiri', 'RBE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1386, 102, '马德望', 'Bat Dambang', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1387, 102, '蒙多基里', 'Mondol Kiri', 'MWV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1388, 102, '菩萨', 'Pouthĭsat', 'PO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1389, 102, '上丁', 'Stoeng Treng', 'TNX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1390, 102, '西哈努克市', 'Krong Preah', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1391, 102, '暹粒', 'Siem Reab', 'REP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1392, 103, '奥洛穆茨', 'Olomoucky', 'OL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1393, 103, '比尔森', 'Plzensky', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1394, 103, '布拉格直辖市', 'Prague', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1395, 103, '赫拉德茨-克拉洛韦', 'Kralovehradecky', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1396, 103, '卡罗维发利', 'Karlovarsky', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1397, 103, '利贝雷克', 'Liberecky', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1398, 103, '摩拉维亚-西里西亚', 'Moravskoslezsky', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1399, 103, '南摩拉维亚', 'Jihomoravsky', 'JC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1400, 103, '帕尔杜比采', 'Pardubicky', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1401, 103, '维索基纳', 'Vysocina', 'VY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1402, 103, '乌斯季', 'Ustecky', 'US', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1403, 103, '中捷克', 'Stredocesky', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1404, 103, '兹林', 'Zlinsky', 'ZL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1405, 104, '北马塔贝莱兰', 'Matabeleland North', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1406, 104, '布拉瓦约', 'Bulawayo', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1407, 104, '东马绍纳兰', 'Mashonaland East', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1408, 104, '哈拉雷', 'Harare', 'HA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1409, 104, '马尼卡兰', 'Manicaland', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1410, 104, '马斯温戈', 'Masvingo', 'MV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1411, 104, '南马塔贝莱兰', 'Matabeleland South', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1412, 104, '西马绍纳兰', 'Mashonaland West', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1413, 104, '中部', 'Midlands', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1414, 104, '中马绍纳兰', 'Mashonaland Central', 'MC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1415, 105, '阿达马瓦', 'Adamaoua', 'ADA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1416, 105, '北部', 'Nord', 'NOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1417, 105, '北端', 'Extreme-Nord', 'EXN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1418, 105, '滨海', 'Littoral', 'LIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1419, 105, '东部', 'Est', 'EST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1420, 105, '南部', 'Sud', 'SUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1421, 105, '西北', 'Nord-Oueste', 'NOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1422, 105, '西部', 'Ouest', 'OUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1423, 105, '西南', 'Sud-Oueste', 'SOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1424, 105, '中央', 'Centre', 'CEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1425, 106, '北部', 'Madinat ach Shamal', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1426, 106, '多哈', 'Ad Dawhah', 'DW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1427, 106, '古韦里耶', 'Al Ghuwariyah', 'GW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1428, 106, '豪尔', 'Al Khawr', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1429, 106, '杰里扬拜特奈', 'Jariyan al Batnah', 'JB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1430, 106, '赖扬', 'Ar Rayyan', 'RN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1431, 106, '沃克拉', 'Al Wakrah', 'WK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1432, 106, '乌姆锡拉勒', 'Umm Salal', 'UL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1433, 106, '朱迈利耶', 'Al Jumaliyah', 'JM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1434, 110, '阿涅比', 'Agnebi', 'AG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1435, 110, '巴芬', 'Bafing', 'BF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1436, 110, '邦达马河谷', 'Vallee du Bandama', 'VB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1437, 110, '登盖莱', 'Denguele', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1438, 110, '恩济－科莫埃', 'Nzi-Comoe', 'NC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1439, 110, '弗罗马格尔', 'Fromager', 'FR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1440, 110, '湖泊', 'Lacs', 'LC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1441, 110, '马拉韦', 'Marahoue', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1442, 110, '南邦达马', 'Sud-Bandama', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1443, 110, '南科莫埃', 'Sud-Comoe', 'SC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1444, 110, '萨桑德拉', 'Haut-Sassandra', 'HT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1445, 110, '萨瓦纳', 'Savanes', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1446, 110, '山地', 'Montagnes', 'DH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1447, 110, '沃罗杜古', 'Worodougou', 'WR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1448, 110, '下萨桑德拉', 'Bas-Sassandra', 'BS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1449, 110, '泻湖', 'Lagunes', 'LG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1450, 110, '赞赞', 'Zanzan', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1451, 110, '中卡瓦利', 'Moyen-Cavally', 'MV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1452, 110, '中科莫埃', 'Moyen-Comoe', 'MC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1453, 112, '奥西耶克-巴拉尼亚', 'Osjecko-Baranjska', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1454, 112, '别洛瓦尔-比洛戈拉', 'Bjelovarsko-Bilogorska', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1455, 112, '滨海和山区', 'Primorsko-Goranska', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1456, 112, '波热加-斯拉沃尼亚', 'Pozega-Slavonia', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1457, 112, '布罗德-波萨维纳', 'Brodsko-Posavska', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1458, 112, '杜布罗夫斯克-内雷特瓦', 'Dubrovacko-Neretvanska', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1459, 112, '卡尔洛瓦茨', 'Karlovacka', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1460, 112, '科普里夫尼察-克里热夫齐', 'Koprivnicko-Krizevacka', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1461, 112, '克拉皮纳-扎戈列', 'Krapinsko-Zagorska', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1462, 112, '利卡-塞尼', 'Licko-Senjska', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1463, 112, '梅吉穆列', 'Medimurska', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1464, 112, '萨格勒布', 'Zagrebacka', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1465, 112, '萨格勒布市', 'Grad Zagreb', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1466, 112, '斯普利特-达尔马提亚', 'Splitsko-Dalmatinska', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1467, 112, '瓦拉日丁', 'Varazdinska', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1468, 112, '维罗维蒂察-波德拉维纳', 'Viroviticko-Podravska', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1469, 112, '武科瓦尔-斯里耶姆', 'Vukovarsko-Srijemska', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1470, 112, '希贝尼克-克宁', 'Sibensko-Kninska', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1471, 112, '锡萨克-莫斯拉维纳', 'Sisacko-Moslavacka', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1472, 112, '伊斯特拉', 'Istarska', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1473, 112, '扎达尔', 'Zadarska', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1474, 113, '埃尔格约-马拉奎特', 'Elgeyo-Marakwet', 'EMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1475, 113, '巴林戈', 'Baringo', 'BAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1476, 113, '邦戈马', 'Bungoma', 'BUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1477, 113, '博美特', 'Bomet', 'BOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1478, 113, '布希亚', 'Busia', 'BUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1479, 113, '恩布', 'Embu', 'EMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1480, 113, '霍马湾', 'Homa Bay', 'HOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1481, 113, '基安布', 'Kiambu', 'KIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1482, 113, '基里菲', 'Kilifi', 'KIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1483, 113, '基里尼亚加', 'Kirinyaga', 'KIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1484, 113, '基苏木', 'Kisumu', 'KIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1485, 113, '基图伊', 'Kitui', 'KIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1486, 113, '基西', 'Kisii', 'KII', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1487, 113, '加里萨', 'Garissa', 'GAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1488, 113, '卡卡梅加', 'Kakamega', 'KAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1489, 113, '卡耶亚多', 'Kajiado', 'KAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1490, 113, '凯里乔', 'Kericho', 'KEY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1491, 113, '夸勒', 'Kwale', 'KWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1492, 113, '拉木', 'Lamu', 'LAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1493, 113, '莱基皮亚', 'Laikipia', 'LAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1494, 113, '马查科斯', 'Machakos', 'MAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1495, 113, '马瓜尼', 'Makueni', 'MAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1496, 113, '马萨布布', 'Marsabit', 'RBT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1497, 113, '曼德拉', 'Mandera', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1498, 113, '梅鲁', 'Meru', 'MER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1499, 113, '蒙巴萨', 'Mombasa', 'MOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1500, 113, '米戈利', 'Migori', 'MIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1501, 113, '穆兰卡', 'Muranga', 'MUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1502, 113, '纳库鲁', 'Nakuru', 'NUU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1503, 113, '纳罗克', 'Narok', 'NAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1504, 113, '南迪', 'Nandi', 'NAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1505, 113, '内罗毕', 'Nairobi', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1506, 113, '尼蒂', 'Nithi', 'NIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1507, 113, '尼亚米拉', 'Nyamira', 'NYM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1508, 113, '年达鲁阿', 'Nyandarua', 'NYN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1509, 113, '涅里', 'Nyeri', 'NYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1510, 113, '桑布卢', 'Samburu', 'UAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1511, 113, '塔纳河', 'Tana River', 'TRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1512, 113, '泰塔塔维塔', 'Taita-Taveta', 'TTA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1513, 113, '特兰斯-恩佐亚', 'Trans-Nzoia', 'TNZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1514, 113, '图尔卡纳', 'Turkana', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1515, 113, '瓦吉尔', 'Wajir', 'WJR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1516, 113, '瓦辛基苏', 'Uasin Gishu', 'UGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1517, 113, '韦希加', 'Vihiga', 'VIH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1518, 113, '西波克特', 'West Pokot', 'WPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1519, 113, '夏亚', 'Siaya', 'SIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1520, 113, '伊希约洛', 'Isiolo', 'ISI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1521, 113, '中央', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1522, 115, '阿卢克斯内', 'Aluksnes', 'ALU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1523, 115, '爱兹克劳克雷', 'Aizkraukles', 'AIZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1524, 115, '奥格雷', 'Ogres', 'OGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1525, 115, '巴尔维', 'Balvu', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1526, 115, '包斯卡', 'Bauskas', 'BAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1527, 115, '采西斯', 'Cesu', 'CES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1528, 115, '多贝莱', 'Dobeles', 'DOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1529, 115, '古尔贝内', 'Gulbenes', 'GUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1530, 115, '杰卡布皮尔斯', 'Jekabpils', 'JEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1531, 115, '克拉斯拉瓦', 'Kraslavas', 'KRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1532, 115, '库尔迪加', 'Kuldigas', 'KUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1533, 115, '雷泽克内', 'Rezeknes', 'RZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1534, 115, '里加', 'Rigas', 'RGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1535, 115, '利耶帕亚', 'Liepajas', 'LPK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1536, 115, '林巴济', 'Limbazu', 'LIM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1537, 115, '卢扎', 'Ludzas', 'LUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1538, 115, '马多纳', 'Madonas', 'MAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1539, 115, '普雷利', 'Preilu', 'PRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1540, 115, '萨尔杜斯', 'Saldus', 'SAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1541, 115, '塔尔西', 'Talsu', 'TAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1542, 115, '陶格夫皮尔斯', 'Daugavpils', 'DGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1543, 115, '图库马', 'Tukuma', 'TUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1544, 115, '瓦尔加', 'Valkas', 'VLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1545, 115, '瓦尔米耶拉', 'Valmieras', 'VLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1546, 115, '文茨皮尔斯', 'Ventspils', 'VSL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1547, 115, '叶尔加瓦', 'Jelgavas', 'JGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1548, 116, '伯里亚', 'Berea', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1549, 116, '布塔布泰', 'Butha-Buthe', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1550, 116, '古廷', 'Quthing', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1551, 116, '加查斯内克', 'Qachas Nek', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1552, 116, '莱里贝', 'Leribe', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1553, 116, '马费滕', 'Mafeteng', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1554, 116, '马塞卢', 'Maseru', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1555, 116, '莫哈莱斯胡克', 'Mohales Hoek', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1556, 116, '莫霍特隆', 'Mokhotlong', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1557, 116, '塔巴采卡', 'Thaba-Tseka', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1558, 117, '阿速坡', 'Attapu', 'AT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1559, 117, '波里坎赛', 'Bolikhamxai', 'BL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1560, 117, '博乔', 'Bokeo', 'BK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1561, 117, '川圹', 'Xiangkhoang', 'XI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1562, 117, '丰沙里', 'Phongsali', 'PH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1563, 117, '甘蒙', 'Khammouan', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1564, 117, '华潘', 'Houaphan', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1565, 117, '琅勃拉邦', 'Louangphrabang', 'LP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1566, 117, '琅南塔', 'Louang Namtha', 'LM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1567, 117, '赛宋本行政特区', 'Xaisomboun', 'XN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1568, 117, '色贡', 'Xekong', 'XE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1569, 117, '沙拉湾', 'Saravan', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1570, 117, '沙湾拿吉', 'Savannakhet', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1571, 117, '沙耶武里', 'Xaignabouri', 'XA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1572, 117, '万象', 'Vientiane', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1573, 117, '乌多姆赛', 'Oudomxai', 'OU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1574, 117, '占巴塞', 'Champasak', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1575, 118, '北部', 'Ash-Shamal', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1576, 118, '贝卡', 'Al-Biqa', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1577, 118, '贝鲁特', 'Bayrut', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1578, 118, '黎巴嫩山', 'Jabal Lubnan', 'JL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1579, 118, '奈拜提耶市', 'An-Nabatiyah', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1580, 118, '南部', 'Al-Janub', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1581, 119, '巴波卢', 'Gbarpolu', 'GBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1582, 119, '邦', 'Bong', 'BG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1583, 119, '博波卢', 'Bopolu', 'BOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1584, 119, '博米', 'Bomi', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1585, 119, '大巴萨', 'Grand Bassa', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1586, 119, '大吉德', 'Grand Gedeh', 'GG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1587, 119, '大角山', 'Grand Cape Mount', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1588, 119, '大克鲁', 'Grand Kru', 'GK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1589, 119, '菲什敦', 'Fish Town', 'FT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1590, 119, '吉河', 'River Gee', 'RG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1591, 119, '里弗塞斯', 'River Cess', 'RI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1592, 119, '洛法', 'Lofa', 'LO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1593, 119, '马吉比', 'Margibi', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1594, 119, '马里兰', 'Maryland', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1595, 119, '蒙特塞拉多', 'Montserrado', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1596, 119, '宁巴', 'Nimba', 'NI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1597, 119, '锡诺', 'Sinoe', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1598, 121, '阿利图斯', 'Alytus', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1599, 121, '考纳斯', 'Kaunas', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1600, 121, '克莱佩达', 'Klaipeda', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1601, 121, '马里扬泊列', 'Marijampole', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1602, 121, '帕涅韦日斯', 'Panevezys', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1603, 121, '陶拉格', 'Taurages', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1604, 121, '特尔希艾', 'Telsiu', 'TE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1605, 121, '维尔纽斯', 'Vilnius', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1606, 121, '乌田纳', 'Utenos', 'UT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1607, 121, '希奥利艾', 'Siauliai', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1608, 121, '亚克曼', 'Akmenes', 'AKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1609, 124, '迪基希', 'Diekirch', 'DD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1610, 124, '格雷文马赫', 'Grevenmacher', 'GG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1611, 124, '卢森堡', 'Luxembourg', 'LL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1612, 125, '比温巴', 'Byumba', 'BY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1613, 125, '布塔雷', 'Butare', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1614, 125, '恩延扎', 'Nyanza', 'NY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1615, 125, '基本古', 'Kibungo', 'KG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1616, 125, '基布耶', 'Kibuye', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1617, 125, '基加利-恩加利', 'Kigali-Ngali', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1618, 125, '基加利市', 'Kigali-Ville', 'KV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1619, 125, '吉孔戈罗', 'Gikongoro', 'GK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1620, 125, '吉塞尼', 'Gisenyi', 'GS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1621, 125, '吉塔拉马', 'Gitarama', 'GT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1622, 125, '卡布加', 'Kabuga', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1623, 125, '卢瓦马加纳', 'Rwamagana', 'RW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1624, 125, '鲁汉戈', 'Ruhango', 'RH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1625, 125, '鲁亨盖里', 'Ruhengeri', 'RU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1626, 125, '尚古古', 'Cyangugu', 'CY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1627, 125, '乌姆塔拉', 'Umutara', 'UM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1628, 126, '阿尔巴尤利亚', 'Alba Iulia', 'AL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1629, 126, '阿拉德', 'Arad', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1630, 126, '奥拉迪亚', 'Oradea', 'OR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1631, 126, '巴克乌', 'Bacau', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(1632, 126, '巴亚马雷', 'Baia Mare', 'BM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1633, 126, '比斯特里察', 'Bistrita', 'BN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1634, 126, '博托沙尼', 'Botosani', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1635, 126, '布加勒斯特', 'Bucuresti', 'BC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1636, 126, '布拉索夫', 'Brasov', 'BS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1637, 126, '布勒伊拉', 'Braila', 'BL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1638, 126, '布泽乌', 'Buzau', 'BZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1639, 126, '德罗贝塔-塞维林堡', 'Drobeta-Turnu Severin', 'DT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1640, 126, '德瓦', 'Deva', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1641, 126, '蒂米什瓦拉', 'Timisoara', 'TI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1642, 126, '福克沙尼', 'Focsani', 'FO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1643, 126, '加拉茨', 'Galati', 'GL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1644, 126, '久尔久', 'Giurgiu', 'GG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1645, 126, '康斯坦察', 'Constanta', 'CT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1646, 126, '克拉约瓦', 'Craiova', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1647, 126, '克勒拉希', 'Calarasi', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1648, 126, '克卢日纳波卡', 'Cluj-Napoca', 'CN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1649, 126, '勒姆尼库沃尔恰', 'XRimnicu Vilcea', 'VI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1650, 126, '雷希察', 'Resita', 'RE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1651, 126, '梅尔库里亚丘克', 'Miercurea-Ciuc', 'MC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1652, 126, '皮特什蒂', 'Pitesti', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1653, 126, '皮亚特拉尼亚姆茨', 'Piatra Neamt', 'PN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1654, 126, '普洛耶什蒂', 'Ploiesti', 'PL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1655, 126, '萨图·马雷', 'Satu Mare', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1656, 126, '圣格奥尔基', 'Sfantu-Gheorghe', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1657, 126, '斯拉蒂纳', 'Slatina', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1658, 126, '斯洛博齐亚', 'Slobozia', 'SB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1659, 126, '苏恰瓦', 'Suceava', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1660, 126, '特尔戈维什泰', 'Targovişte', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1661, 126, '特尔古穆列什', 'Tirgu Mures', 'TM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1662, 126, '特尔古日乌', 'Tirgu-Jiu', 'TJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1663, 126, '图尔恰', 'Tulcea', 'TU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1664, 126, '瓦斯卢伊', 'Vaslui', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1665, 126, '锡比乌', 'Sibiu', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1666, 126, '雅西', 'Iasi', 'IS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1667, 126, '亚厉山德里亚', 'Alexandria', 'AD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1668, 126, '扎勒乌', 'Zalau', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1669, 127, '安齐拉纳纳', 'Antsiranana', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1670, 127, '菲亚纳兰楚阿', 'Fianarantsoa', 'FN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1671, 127, '马哈赞加', 'Mahajanga', 'MJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1672, 127, '塔那那利佛', 'Antananarivo', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1673, 127, '图阿马西拉', 'Toamasina', 'TM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1674, 127, '图利亚拉', 'Toliary', 'TL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1675, 128, '阿杜', 'Addu Atoll', 'ADD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1676, 128, '北阿里', 'North Ari Atoll', 'AAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1677, 128, '北蒂拉杜马蒂', 'North Thiladhunmathi', 'THD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1678, 128, '北马洛斯马杜卢', 'North Maalhosmadhulu', 'MAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1679, 128, '北米拉杜马杜卢', 'North Miladhunmadhulu', 'MLD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1680, 128, '北尼兰杜', 'North Nilandhe Atoll', 'NAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1681, 128, '北苏瓦迪瓦', 'North Huvadhu Atoll', 'HAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1682, 128, '法迪福卢', 'Faadhippolhu', 'FAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1683, 128, '费利杜', 'Felidhu Atoll', 'FEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1684, 128, '福阿穆拉库', 'Foammulah', 'FMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1685, 128, '哈杜马蒂', 'Hadhdhunmathi', 'HDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1686, 128, '科卢马杜卢', 'Kolhumadulu', 'KLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1687, 128, '马累', 'Male', 'MAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1688, 128, '马累岛', 'Male Atoll', 'MAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1689, 128, '穆拉库', 'Mulakatholhu', 'MUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1690, 128, '南阿里', 'South Ari Atoll', 'AAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1691, 128, '南蒂拉杜马蒂', 'South Thiladhunmathi', 'THU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1692, 128, '南马洛斯马杜卢', 'South Maalhosmadulu', 'MAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1693, 128, '南米拉杜马杜卢', 'South Miladhunmadhulu', 'MLU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1694, 128, '南尼兰杜', 'South Nilandhe Atoll', 'NAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1695, 128, '南苏瓦迪瓦', 'South Huvadhu Atoll', 'HAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1696, 130, '北部区', 'Northern', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1697, 130, '南部区', 'Southern', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1698, 130, '中央区', 'Central', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1699, 132, '巴马科首都区', 'Bamako', 'CD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1700, 132, '基达尔', 'Kidal', 'KD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1701, 132, '加奥', 'Gao', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1702, 132, '卡伊', 'Kayes', 'KY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1703, 132, '库利科罗', 'Koulikoro', 'KL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1704, 132, '莫普提', 'Mopti', 'MP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1705, 132, '塞古', 'Segou', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1706, 132, '通布图', 'Tombouctou', 'TB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1707, 132, '锡卡索', 'Sikasso', 'SK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1708, 139, '阿德拉尔', 'Adrar', 'AD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1709, 139, '阿萨巴', 'El-Acaba', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1710, 139, '卜拉克纳', 'Brakna', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1711, 139, '东胡德', 'Hodh el-Gharbi', 'HG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1712, 139, '戈尔戈勒', 'Gorgol', 'GO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1713, 139, '吉迪马卡', 'Guidimaka', 'GM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1714, 139, '努瓦迪布湾', 'Dakhlet Nouadhibou', 'DN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1715, 139, '努瓦克肖特特区', 'Nouakchott', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1716, 139, '塔甘特', 'Tagant', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1717, 139, '特拉扎', 'Trarza', 'TR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1718, 139, '提里斯-宰穆尔', 'Tiris Zemmour', 'TZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1719, 139, '西胡德', 'Hodh ech-Chargui', 'HC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1720, 139, '因希里', 'Inchiri', 'IN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1721, 141, '阿纳', 'Aana', 'AAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1722, 141, '阿图阿', 'Atua', 'ATU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1723, 141, '艾加伊勒泰', 'Aigaile Tai', 'AIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1724, 141, '法塞莱莱阿加', 'Faasaleleaga', 'FAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1725, 141, '加盖福毛加', 'Gagaifomauga', 'GFG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1726, 141, '加加埃毛加', 'Gagaemauga', 'GMG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1727, 141, '帕劳利', 'Palauli', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1728, 141, '萨图帕伊泰阿', 'Satupaitea', 'SAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1729, 141, '萨瓦伊岛', 'Savaii', 'SAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1730, 141, '图阿马萨加', 'Tuamasaga', 'TUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1731, 141, '瓦奥福诺蒂', 'Vaao Fonoti', 'VAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1732, 141, '韦西加诺', 'Vaisigano', 'VAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1733, 141, '乌波卢岛', 'Upolu', 'UPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1734, 143, '巴彦洪格尔', 'Bayanhongor', '69', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1735, 143, '巴彦乌勒盖', 'Bayan-Ulgiy', '71', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1736, 143, '布尔干', 'Bulgan', '67', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1737, 143, '达尔汗乌勒', 'Darhan-Uul', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1738, 143, '东方', 'Dornod', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1739, 143, '东戈壁', 'Dornogovi', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1740, 143, '鄂尔浑', 'Orhon', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1741, 143, '戈壁阿尔泰', 'Govi-Altay', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1742, 143, '戈壁苏木贝尔', 'Govisumber', '64', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1743, 143, '后杭爱', 'Arhangay', '73', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1744, 143, '科布多', 'Hovd', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1745, 143, '肯特', 'Hentiy', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1746, 143, '库苏古尔', 'Hovsgol', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1747, 143, '南戈壁', 'Umnogovi', 'UMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1748, 143, '前杭爱', 'Uvorhangay', 'UVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1749, 143, '色楞格', 'Selenge', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1750, 143, '苏赫巴托尔', 'Suhbaatar', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1751, 143, '乌布苏', 'Uvs', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1752, 143, '乌兰巴托市', 'Ulaanbaatar hot', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1753, 143, '扎布汗', 'Dzavhan', '57', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1754, 143, '中戈壁', 'Dundgovi', '59', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1755, 143, '中央', 'Tov', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1756, 145, '达卡', 'Dhaka', 'DAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1757, 145, '吉大港', 'Chittagong', 'CGP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1758, 145, '库尔纳', 'Khulna', 'KHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1759, 147, '阿雷基帕', 'Arequipa', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1760, 147, '阿普里马克', 'Apurimac', 'AP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1761, 147, '阿亚库乔', 'Ayacucho', 'AY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1762, 147, '安卡什', 'Ancash', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1763, 147, '胡利亚卡', 'Juliaca', 'JUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1764, 147, '胡宁', 'Junin', 'JU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1765, 147, '卡哈马卡', 'Cajamarca', 'CJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1766, 147, '卡亚俄', 'Callao', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1767, 147, '库斯科', 'Cusco', 'CU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1768, 147, '拉利伯塔德', 'La Libertad', 'LD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1769, 147, '兰巴耶克', 'Lambayeque', 'LY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1770, 147, '利马', 'Lima', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1771, 147, '洛雷托', 'Loreto', 'LO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1772, 147, '马德雷德迪奥斯', 'Madre de Dios', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1773, 147, '莫克瓜', 'Moquegua', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1774, 147, '帕斯科', 'Pasco', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1775, 147, '皮乌拉', 'Piura', 'PI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1776, 147, '普诺', 'Puno', 'PU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1777, 147, '钦博特', 'Chimbote', 'CHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1778, 147, '钦查阿尔塔', 'Chincha Alta', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1779, 147, '圣马丁', 'San Martin', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1780, 147, '苏拉纳', 'Sullana', 'SUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1781, 147, '塔克纳', 'Tacna', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1782, 147, '通贝斯', 'Tumbes', 'TU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1783, 147, '瓦努科', 'Huanuco', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1784, 147, '万卡维利卡', 'Huancavelica', 'HV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1785, 147, '乌卡亚利', 'Ucayali', 'UC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1786, 147, '亚马孙', 'Amazonas', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1787, 147, '伊卡', 'Ica', 'IC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1788, 148, '勃固省', 'Bago', 'BG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1789, 148, '掸邦', 'Shan', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1790, 148, '德林达依省', 'Tanintharyi', 'TN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1791, 148, '克伦邦', 'Kayin', 'KN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1792, 148, '克钦邦', 'Kachin', 'KC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1793, 148, '克耶邦', 'Kayah', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1794, 148, '马圭省', 'Magway', 'MG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1795, 148, '曼德勒省', 'Mandalay', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1796, 148, '孟邦', 'Mon', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1797, 148, '钦邦', 'Chin', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1798, 148, '若开邦', 'Rakhine', 'RK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1799, 148, '实皆省', 'Sagaing', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1800, 148, '仰光省', 'Yangon', 'YG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1801, 148, '伊洛瓦底省', 'Ayeyarwady', 'AY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1802, 150, '丹吉尔', 'Tangier', 'TGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1803, 150, '得土安', 'Tetouan', 'TET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1804, 150, '非斯', 'Fes', 'FES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1805, 150, '卡萨布兰卡', 'Casablanca', 'CBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1806, 150, '拉巴特', 'Rabat', 'RSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1807, 150, '马拉喀什', 'Marrakech', 'MRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1808, 150, '梅克内斯', 'Meknes', 'MKN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1809, 150, '乌季达', 'Oujda', 'OUJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1810, 150, '西撒哈拉', 'Western Sahara', 'WSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1811, 153, '阿瓜斯卡连斯特', 'Aguascalientes', 'AGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1812, 153, '阿卡普尔科', 'Acapulco', 'ACA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1813, 153, '埃莫西约', 'Hermosillo', 'HMO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1814, 153, '埃佩切', 'Campeche', 'CAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1815, 153, '奥夫雷贡城', 'Obregon', 'OBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1816, 153, '奥里萨巴', 'Orizaba', 'ORI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1817, 153, '巴利城', 'Valles', 'VHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1818, 153, '巴亚尔塔港', 'Puerto Vallarta', 'PVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1819, 153, '比利亚埃尔莫萨', 'Villahermosa', 'VSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1820, 153, '波萨里卡', 'Poza Rica de Hidalgo', 'PRH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1821, 153, '蒂华纳', 'Tijuana', 'TIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1822, 153, '杜兰戈', 'Durango', 'DUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1823, 153, '恩塞纳达', 'Ensenada', 'ESE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1824, 153, '瓜达拉哈拉', 'Guadalajara', 'GDL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1825, 153, '瓜纳华托', 'Guanajuato', 'GUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1826, 153, '哈拉帕', 'Jalapa', 'JAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1827, 153, '华雷斯', 'Juarez', 'JUZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1828, 153, '华雷斯港', 'Benito Juare', 'BJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1829, 153, '卡门', 'Carmen', 'CAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1830, 153, '科利马', 'Colima', 'COL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1831, 153, '克雷塔罗', 'Queretaro', 'QUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1832, 153, '库埃纳瓦卡', 'Cuernavaca', 'CVC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1833, 153, '库利阿坎', 'Culiacan', 'CUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1834, 153, '夸察夸拉克斯', 'Coatzacoalcos', 'COA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1835, 153, '拉巴斯', 'La Paz', 'LAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1836, 153, '莱昂', 'Leon', 'LEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1837, 153, '雷诺萨', 'Reynosa', 'REX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1838, 153, '洛斯莫奇斯', 'Los Mochis', 'LMM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1839, 153, '马萨特兰', 'Mazatlan', 'MZT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1840, 153, '马塔莫罗斯', 'Matamoros', 'MAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1841, 153, '梅里达', 'Merida', 'MID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1842, 153, '蒙克洛瓦', 'Monclova', 'LOV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1843, 153, '蒙特雷', 'Monterrey', 'MTY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1844, 153, '莫雷利亚', 'Morelia', 'MLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1845, 153, '墨西哥城', 'Mexico City', 'MEX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1846, 153, '墨西卡利', 'Mexicali', 'MXL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1847, 153, '诺加莱斯', 'Nogales', 'NOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1848, 153, '帕丘卡', 'Pachuca', 'PAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1849, 153, '普埃布拉', 'Puebla', 'PUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1850, 153, '奇尔潘辛戈', 'Chilpancingo', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1851, 153, '奇瓦瓦', 'Chihuahua', 'CHH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1852, 153, '切图马尔', 'Cheturnal', 'CTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1853, 153, '萨尔蒂约', 'Saltillo', 'SLW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1854, 153, '萨卡特卡斯', 'Zacatecas', 'ZAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1855, 153, '塞拉亚', 'Celaya', 'CLY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1856, 153, '圣路易斯波托亚', 'San Luis Potosi', 'SLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1857, 153, '塔帕丘拉', 'Tapachula', 'TAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1858, 153, '坦皮科', 'Tampico', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1859, 153, '特拉斯卡拉', 'Tlaxcala', 'TLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1860, 153, '特皮克', 'Tepic', 'TPQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1861, 153, '特瓦坎', 'Tehuacan', 'TCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1862, 153, '图斯特拉-古铁雷斯', 'Tuxtla Gutierrez', 'TGZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1863, 153, '托雷翁', 'Torreon', 'TRC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1864, 153, '托卢卡', 'Toluca', 'TLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1865, 153, '瓦哈卡', 'Oaxaca', 'OAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1866, 153, '维多利亚城', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1867, 153, '韦拉克鲁斯', 'Veracruz', 'VER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1868, 153, '乌鲁阿潘', 'Uruapan', 'UPN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1869, 153, '新拉雷多', 'Nuevo Laredo', 'NLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1870, 153, '伊拉普阿托', 'Irapuato', 'IRP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1871, 154, '埃龙戈', 'Erongo', 'ER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1872, 154, '奥汉圭纳', 'Ohangwena', 'OW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1873, 154, '奥卡万戈', 'Okavango', 'KV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1874, 154, '奥马赫科', 'Omaheke', 'OK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1875, 154, '奥姆沙蒂', 'Omusati', 'OT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1876, 154, '奥乔宗蒂约巴', 'Otjozondjupa', 'OJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1877, 154, '奥沙纳', 'Oshana', 'ON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1878, 154, '奥希科托', 'Oshikoto', 'OO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1879, 154, '哈达普', 'Hardap', 'HA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1880, 154, '霍马斯', 'Khomas', 'KH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1881, 154, '卡拉斯', 'Karas', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1882, 154, '卡普里维', 'Caprivi', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1883, 154, '库内内', 'Kunene', 'KU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1884, 155, '阿平顿', 'Upington', 'UTN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1885, 155, '艾利弗山', 'Mount Ayliff', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1886, 155, '彼德马里茨堡', 'Pietermaritzburg', 'PZB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1887, 155, '彼德斯堡', 'Pietersburg', 'PTG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1888, 155, '比勒陀利亚', 'Pretoria', 'PRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1889, 155, '比索', 'Bisho', 'BIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1890, 155, '布雷达斯多普', 'Bredasdorp', 'BDD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1891, 155, '布隆方丹', 'Bloemfontein', 'BFN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1892, 155, '布隆克斯特斯普利特', 'Bronkhorstspruit', 'BHT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1893, 155, '德阿尔', 'De Aar', 'DAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1894, 155, '德班', 'Durban', 'DUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1895, 155, '邓迪', 'Dundee', 'DUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1896, 155, '东巴克利', 'Barkley East', 'BAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1897, 155, '东伦敦', 'East London', 'ELS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1898, 155, '弗雷堡', 'Vryburg', 'VRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1899, 155, '弗里尼欣', 'Vereeniging', 'VGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1900, 155, '格罗布莱斯达尔', 'Groblersdal', 'GBD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1901, 155, '基雅尼', 'Giyani', 'GIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1902, 155, '金伯利', 'Kimberley', 'KIM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1903, 155, '开普敦', 'Cape Town', 'CPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1904, 155, '克莱克斯多普', 'Klerksdorp', 'KXE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1905, 155, '库鲁曼', 'Kuruman', 'KMH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1906, 155, '昆士敦', 'Queenstown', 'UTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1907, 155, '莱迪史密斯', 'Ladysmith', 'LAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1908, 155, '兰德方丹', 'Randfontein', 'RFT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1909, 155, '理查兹湾', 'Richards Bay', 'RCB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1910, 155, '利斯滕堡', 'Rustenburg', 'RSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1911, 155, '米德尔堡', 'Middelburg', 'MDB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1912, 155, '姆库泽', 'Mkuze', 'MZQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1913, 155, '穆里斯堡', 'Moorreesburg', 'MOO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1914, 155, '内尔斯普雷特', 'Nelspruit', 'NLP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1915, 155, '尼尔斯特隆', 'Nylstroom', 'NYL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1916, 155, '纽卡斯尔', 'Newcastle', 'NCS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1917, 155, '乔治', 'George', 'GRJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1918, 155, '萨索尔堡', 'Sasolburg', 'SAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1919, 155, '瑟孔达', 'Secunda', 'ZEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1920, 155, '特克索波', 'Ixopo', 'IXO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1921, 155, '特隆普斯堡', 'Trompsburg', 'TPB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1922, 155, '跳羚', 'Springbok', 'SBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1923, 155, '图拉马哈谢', 'Thulamahashe', 'TLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1924, 155, '托霍延杜', 'Thohoyandou', 'THY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1925, 155, '韦茨肖克', 'Witsieshoek', 'WSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1926, 155, '韦尔科姆', 'Welkom', 'WEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1927, 155, '乌伦迪', 'Ulundi', 'ULD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1928, 155, '乌姆塔塔', 'Umtata', 'UTT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1929, 155, '伍斯特', 'Worcester', 'WOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1930, 155, '西博福特', 'Beaufort West', 'BEW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1931, 155, '谢普斯通港', 'Port Shepstone', 'PSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1932, 155, '伊丽莎白港', 'Port Elizabeth', 'PLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1933, 155, '约翰内斯堡', 'Johannesburg', 'JNB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1934, 159, '巴格马蒂', 'Bagmati', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1935, 159, '道拉吉里', 'Dhawalagiri', 'DH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1936, 159, '甘达基', 'Gandaki', 'GA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1937, 159, '戈西', 'Kosi', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1938, 159, '格尔纳利', 'Karnali', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1939, 159, '贾纳克布尔', 'Janakpur', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1940, 159, '拉布蒂', 'Rapti', 'RA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1941, 159, '蓝毗尼', 'Lumbini', 'LU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1942, 159, '马哈卡利', 'Mahakali', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1943, 159, '梅吉', 'Mechi', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1944, 159, '纳拉亚尼', 'Narayani', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1945, 159, '佩里', 'Bheri', 'BH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1946, 159, '萨加玛塔', 'Sogarmatha', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1947, 159, '塞蒂', 'Seti', 'SE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1948, 160, '埃斯特利', 'Esteli', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1949, 160, '北大西洋', 'Atlantico Norte', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1950, 160, '博阿科', 'Boaco', 'BO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1951, 160, '格拉纳达', 'Granada', 'GR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1952, 160, '卡拉索', 'Carazo', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1953, 160, '莱昂', 'Leon', 'LE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1954, 160, '里瓦斯', 'Rivas', 'RV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1955, 160, '马德里斯', 'Madriz', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1956, 160, '马那瓜', 'Managua', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1957, 160, '马萨亚', 'Masaya', 'MS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1958, 160, '马塔加尔帕', 'Matagalpa', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1959, 160, '南大西洋', 'Atlantico Sur', 'AS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1960, 160, '奇南德加', 'Chinandega', 'CD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1961, 160, '琼塔莱斯', 'Chontales', 'CT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1962, 160, '圣胡安河', 'Rio San Juan', 'SJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1963, 160, '希诺特加', 'Jinotega', 'JI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1964, 160, '新塞哥维亚', 'Nueva Segovia', 'NS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1965, 161, '阿加德兹', 'Agadez', 'AJY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1966, 161, '迪法', 'Diffa', 'DIF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1967, 161, '蒂拉贝里', 'Tillaberi', 'TIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1968, 161, '多索', 'Dosso', 'DSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1969, 161, '津德尔', 'Zinder', 'ZND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1970, 161, '马拉迪', 'Maradi', 'MFQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1971, 161, '尼亚美市', 'Niamey C.U.', 'NIM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1972, 161, '塔瓦', 'Tahoua', 'THZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1973, 162, '阿比亚', 'Abuja', 'ABV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1974, 162, '奥博莫绍', 'Ogbomosho', 'OGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1975, 162, '卡诺', 'Kano', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1976, 162, '拉各斯', 'Lagos', 'LOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1977, 162, '伊巴丹', 'Ibadan', 'IBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1978, 164, '阿克什胡斯', 'Akershus', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1979, 164, '奥普兰', 'Oppland', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1980, 164, '奥斯陆市', 'Oslo', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1981, 164, '北特伦德拉格', 'Nord-Trondelag', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1982, 164, '布斯克吕', 'Buskerud', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1983, 164, '东阿格德尔', 'Aust-Agder', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1984, 164, '东福尔', 'Ostfold', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1985, 164, '芬马克', 'Finnmark', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1986, 164, '海德马克', 'Hedmark', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1987, 164, '霍达兰', 'Hordaland', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1988, 164, '罗加兰', 'Rogaland', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1989, 164, '默勒－鲁姆斯达尔', 'More og Romsdal', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1990, 164, '南特伦德拉格', 'Sor-Trondelag', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1991, 164, '诺尔兰', 'Nordland', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1992, 164, '松恩－菲尤拉讷', 'Sogn og Fjordane', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1993, 164, '泰勒马克', 'Telemark', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1994, 164, '特罗姆斯', 'Troms', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1995, 164, '西阿格德尔', 'Vest-Agder', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1996, 164, '西福尔', 'Vestfold', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1997, 168, '滨海阿连特茹', 'Alentejo Litoral', 'ALL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1998, 168, '滨海皮尼亚尔', 'Pinhal Litoral', 'PLT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(1999, 168, '波尔图', 'Porto', 'VDP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2000, 168, '杜罗', 'Douro', 'MDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2001, 168, '恩特拉杜罗伏日', 'Entre Douro e Vouga', 'EDV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2002, 168, '法鲁', 'Faro', 'FAO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2003, 168, '丰沙尔', 'Funchal', 'FUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2004, 168, '卡瓦多', 'Cavado', 'CAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2005, 168, '科瓦贝拉', 'Cova da Beira', 'CLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2006, 168, '里斯本', 'Lisboa', 'LIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2007, 168, '利巴特茹', 'Leziria do Tejo', 'LTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2008, 168, '梅地奥特茹', 'Medio Tejo', 'MTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2009, 168, '米尼奥-利马', 'Minho-Lima', 'MLI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2010, 168, '内贝拉北', 'Beira Interior Norte', 'BIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2011, 168, '内贝拉南', 'Beira Interior Sul', 'BIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2012, 168, '内皮尼亚尔北', 'Pinhal Interior Norte', 'PIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2013, 168, '内皮尼亚尔南', 'Pinhal Interior Sul', 'PIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2014, 168, '蓬塔德尔加达', 'Ponta Delgada', 'PDL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2015, 168, '塞图巴尔半岛', 'Peninsula de Setubal', 'PSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2016, 168, '山后', 'Serra da Estrela', 'SES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2017, 168, '上阿连特茹', 'Alto Alentejo', 'AAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2018, 168, '上特拉斯山', 'Alto Tros-os-Montes', 'ATM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2019, 168, '塔梅加', 'Tamega', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2020, 168, '万福', 'Ave', 'AES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2021, 168, '西部', 'Oeste', 'OES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2022, 168, '下阿连特茹', 'Baixo Alentejo', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2023, 168, '下伏日', 'Baixo Vouga', 'BVO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2024, 168, '下蒙德古', 'Baixo Mondego', 'BMO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2025, 168, '中阿连特茹', 'Alentejo Central', 'ALC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2026, 170, '爱媛', 'Ehime', '38', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2027, 170, '爱知', 'Aichi', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2028, 170, '北海道', 'Hokkaido', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2029, 170, '兵库', 'Hyogo', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2030, 170, '冲绳', 'Okinawa', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2031, 170, '茨城', 'Ibaraki', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2032, 170, '大阪', 'Osaka', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2033, 170, '大分', 'Oita', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2034, 170, '岛根', 'Shimane', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2035, 170, '徳岛', 'Tokushima', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2036, 170, '东京', 'Tokyo', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2037, 170, '福岛', 'Fukushima', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2038, 170, '福冈', 'Fukuoka', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2039, 170, '福井', 'Fukui', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2040, 170, '富山', 'Toyama', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2041, 170, '冈山', 'Okayama', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2042, 170, '高知', 'Kochi', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2043, 170, '宮城', 'Miyagi', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2044, 170, '宫崎', 'Miyazaki', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2045, 170, '广岛', 'Hiroshima', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2046, 170, '和歌山', 'Wakayama', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2047, 170, '京都', 'Kyoto', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2048, 170, '静冈', 'Shizuoka', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2049, 170, '枥木', 'Tochigi', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2050, 170, '鹿儿岛', 'Kagoshima', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2051, 170, '奈良', 'Nara', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2052, 170, '鸟取', 'Tottori', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2053, 170, '岐阜', 'Gifu', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2054, 170, '埼玉', 'Saitama', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2055, 170, '千叶', 'Chiba', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2056, 170, '青森', 'Aomori', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2057, 170, '秋田', 'Akita', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2058, 170, '群马', 'Gunma', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2059, 170, '三重', 'Mie', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2060, 170, '山口', 'Yamaguchi', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2061, 170, '山梨', 'Yamanashi', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2062, 170, '山形', 'Yamagata', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2063, 170, '神奈川', 'Kanagawa', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2064, 170, '石川', 'Ishikawa', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2065, 170, '香川', 'Kagawa', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2066, 170, '新潟', 'Niigata', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2067, 170, '熊本', 'Kumamoto', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2068, 170, '岩手', 'Iwate', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2069, 170, '长崎', 'Nagasaki', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2070, 170, '长野', 'Nagano', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2071, 170, '滋贺', 'Shiga', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2072, 170, '佐贺', 'Saga', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2073, 171, '北博滕', 'Norrbottens', 'BD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2074, 171, '布莱金厄', 'Blekinge', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2075, 171, '达拉纳', 'Dalarnas', 'DLN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2076, 171, '东约特兰', 'Ustergotland', 'UGL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2077, 171, '厄勒布鲁', 'Orebro', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2078, 171, '哥得兰', 'Gotlands', 'I', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2079, 171, '哈兰', 'Hallands', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2080, 171, '卡尔马', 'Kalmar', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2081, 171, '克鲁努贝里', 'Kronobergs', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2082, 171, '南曼兰', 'Sodermanlands', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2083, 171, '斯德哥尔摩', 'Stockholms', 'AB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2084, 171, '斯科耐', 'Skane', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2085, 171, '韦姆兰', 'Varmlands', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2086, 171, '乌普萨拉', 'Uppsala', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2087, 171, '西博滕', 'Vasterbottens', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2088, 171, '西曼兰', 'Vastmanlands', 'U', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2089, 171, '西诺尔兰', 'Vasternorrlands', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2090, 171, '西约特兰', 'Vastra Gotalands', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2091, 171, '延雪平', 'Jonkopings', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2092, 171, '耶夫勒堡', 'Gavleborgs', 'X', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2093, 171, '耶姆特兰', 'Jamtlands', 'Z', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2094, 172, '阿尔高', 'Aargau', 'AG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2095, 172, '巴塞尔城市', 'Basel－Sstadt', 'BS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2096, 172, '巴塞尔乡村', 'Basel Landschaft', 'BL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2097, 172, '伯尔尼', 'Bern', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2098, 172, '楚格', 'Zug', 'ZG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2099, 172, '弗里堡', 'Freiburg', 'FR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2100, 172, '格拉鲁斯', 'Glarus', 'GL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2101, 172, '格劳宾登', 'Graubünden', 'GR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2102, 172, '卢塞恩', 'Luzern', 'LU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2103, 172, '洛桑', 'Lausanne', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2104, 172, '纳沙泰尔', 'Neuchatel', 'NE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2105, 172, '内阿彭策尔', 'Appenzell Innerrhodn', 'AI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2106, 172, '日内瓦', 'Geneve', 'GE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2107, 172, '汝拉', 'Jura', 'JU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2108, 172, '沙夫豪森', 'Schaffhausen', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2109, 172, '上瓦尔登', 'Obwalden', 'OW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2110, 172, '圣加仑', 'St.Gallen', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2111, 172, '施维茨', 'Schwyz', 'SZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2112, 172, '苏黎世', 'Zurich', 'ZH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2113, 172, '索洛图恩', 'Solothurn', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2114, 172, '提契诺', 'Ticino', 'TI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2115, 172, '图尔高', 'Thurgau', 'TG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2116, 172, '瓦莱', 'Wallis', 'VS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2117, 172, '外阿彭策尔', 'Appenzell Ausserrhon', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2118, 172, '沃', 'Vaud', 'VD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2119, 172, '乌里', 'Uri', 'UR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2120, 172, '下瓦尔登', 'Nidwalden', 'NW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2121, 173, '阿波帕', 'Apopa', 'APO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2122, 173, '阿瓦查潘', 'Ahuachapan', 'AH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2123, 173, '滨海', 'Litoral', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2124, 173, '查拉特南戈', 'Chalatenango', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2125, 173, '德尔加多', 'Delgado', 'DE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2126, 173, '基埃-恩特姆', 'Kie-Ntem', 'KN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2127, 173, '卡瓦尼亚斯', 'Cabanas', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2128, 173, '库斯卡特兰', 'Cuscatlan', 'CU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2129, 173, '拉巴斯', 'La Paz', 'PZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2130, 173, '拉利伯塔德', 'La Libertad', 'LB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2131, 173, '拉乌尼翁', 'La Union', 'UN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2132, 173, '梅基卡诺斯', 'Mejicanos', 'MEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2133, 173, '莫拉桑', 'Morazan', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2134, 173, '圣安娜', 'Santa Ana', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2135, 173, '圣米格尔', 'San Miguel', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2136, 173, '圣萨尔瓦多', 'San Salvador', 'SS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2137, 173, '圣维森特', 'San Vicente', 'SV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2138, 173, '松索纳特', 'Sonsonate', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2139, 173, '索亚潘戈', 'Soyapango', 'SOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2140, 173, '韦莱-恩萨斯', 'Wele-Nzas', 'WN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2141, 173, '乌苏卢坦', 'Usulutan', 'US', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2142, 173, '伊洛潘戈', 'Ilopango', 'IL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2143, 173, '中南', 'Centro Sur', 'CS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2144, 175, '贝尔格莱德', 'Beograd', 'BEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2145, 175, '波德戈里察', 'Podgorica', 'POD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2146, 175, '克拉古涅瓦茨', 'Kragujevac', 'KGV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2147, 175, '尼什', 'Nis', 'INI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2148, 175, '诺维萨德', 'Novi Sad', 'NVS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2149, 175, '普里什蒂纳', 'Pristina', 'PRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2150, 175, '苏博蒂察', 'Subotica', 'SUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2151, 175, '泽蒙', 'Zemun', 'ZEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2152, 176, '北部', 'Northern', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2153, 176, '东部', 'Eastern', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2154, 176, '南部', 'Southern', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2155, 176, '西部区', 'Western', 'W', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2156, 177, '达喀尔', 'Dakar', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2157, 177, '法蒂克', 'Fatick', 'FA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2158, 177, '济金绍尔', 'Ziguinchor', 'ZI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2159, 177, '捷斯', 'Thies', 'TH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2160, 177, '久尔贝勒', 'Diourbel', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2161, 177, '考拉克', 'Kaolack', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2162, 177, '科尔达', 'Kolda', 'KO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2163, 177, '卢加', 'Louga', 'LO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2164, 177, '马塔姆', 'Matam', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2165, 177, '圣路易', 'Saint-Louis', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2166, 177, '坦巴昆达', 'Tambacounda', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(2167, 178, '法马古斯塔', 'Famagusta', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2168, 178, '凯里尼亚', 'Kyrenia', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2169, 178, '拉纳卡', 'Larnaca', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2170, 178, '利马索尔', 'Limassol', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2171, 178, '尼科西亚', 'Nicosia', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2172, 178, '帕福斯', 'Pafos', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2173, 180, '阿尔阿尔', 'Arar', 'ARA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2174, 180, '艾卜哈', 'Abha', 'AHB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2175, 180, '巴哈', 'Al Bahah', 'BH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2176, 180, '布赖代', 'Buraydah', 'BUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2177, 180, '达曼', 'Dammam', 'DAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2178, 180, '哈费尔巴廷', 'Hafar al-Batin', 'HBT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2179, 180, '哈伊勒', 'Hail', 'HL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2180, 180, '海米斯穆谢特', 'Khamis Mushayt', 'KMX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2181, 180, '海耶', 'Al-Kharj', 'AKH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2182, 180, '胡富夫', 'Al-Hufuf', 'HFF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2183, 180, '吉达', 'Jiddah', 'JED', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2184, 180, '吉赞', 'Jizan', 'JZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2185, 180, '利雅得', 'Riyad', 'RD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2186, 180, '麦地那', 'Medina', 'MED', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2187, 180, '麦加', 'Makkah', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2188, 180, '姆巴拉兹', 'Al-Mubarraz', 'MBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2189, 180, '纳季兰', 'Najran', 'NR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2190, 180, '塞卡卡', 'Sakaka', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2191, 180, '塔布克', 'Tabuk', 'TB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2192, 180, '塔伊夫', 'At Tarif', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2193, 180, '延布', 'Yanbu al-Bahr', 'YNB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2194, 180, '朱拜勒', 'Al-Jubayl', 'JBI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2195, 189, '阿努拉德普勒', 'Anuradhapura', 'ADP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2196, 189, '安帕赖', 'Ampara', 'AMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2197, 189, '巴杜勒', 'Badulla', 'BAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2198, 189, '拜蒂克洛', 'Batticaloa', 'BTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2199, 189, '波隆纳鲁沃', 'Polonnaruwa', 'POL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2200, 189, '汉班托特', 'Hambantota', 'HBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2201, 189, '基里诺奇', 'Kilinochchi', 'KIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2202, 189, '加勒', 'Galle', 'GAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2203, 189, '加姆珀哈', 'Gampaha', 'GAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2204, 189, '贾夫纳', 'Jaffna', 'JAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2205, 189, '卡卢特勒', 'Kalutara', 'KLT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2206, 189, '凯格勒', 'Kegalle', 'KEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2207, 189, '康提', 'Kandy', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2208, 189, '科伦坡', 'Colombo', 'CMB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2209, 189, '库鲁内格勒', 'Kurunegala', 'KUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2210, 189, '拉特纳普勒', 'Ratnapura', 'RAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2211, 189, '马纳尔', 'Mannar', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2212, 189, '马特莱', 'Matale', 'MAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2213, 189, '马特勒', 'Matara', 'MAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2214, 189, '莫讷勒格勒', 'Monaragala', 'MON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2215, 189, '穆莱蒂武', 'Mullathivu', 'MUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2216, 189, '努沃勒埃利耶', 'Nuwara Eliya', 'NUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2217, 189, '普塔勒姆', 'Puttalam', 'PUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2218, 189, '亭可马里', 'Trincomalee', 'TRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2219, 189, '瓦武尼亚', 'Vavuniya', 'VAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2220, 190, '班斯卡-比斯特里察', 'Banskobystricky', 'BBY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2221, 190, '布拉迪斯拉发', 'Bratislavsky', 'BTS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2222, 190, '科希策', 'Koricky', 'KOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2223, 190, '尼特拉', 'Nitriansky', 'NRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2224, 190, '普雷绍夫', 'Prerovsky', 'POV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2225, 190, '日利纳', 'Rilinsky', 'RIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2226, 190, '特尔纳瓦', 'Trnavsky', 'TNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2227, 190, '特伦钦', 'Trenriansky', 'TRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2228, 191, '奥巴尔诺-克拉', 'Obalno-kraska', 'OKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2229, 191, '奥斯雷德涅斯洛文', 'Osrednjeslovenska', 'OSR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2230, 191, '波德拉夫', 'Podravska', 'POD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2231, 191, '波穆尔', 'Pomurska', 'POM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2232, 191, '多雷尼', 'Dolenjska', 'DLJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2233, 191, '戈雷尼', 'Gorenjska', 'GSZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2234, 191, '戈里', 'Goriska', 'GSK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2235, 191, '科洛', 'Koroska', 'KOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2236, 191, '诺特拉尼', 'Notranjsko-kraska', 'NKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2237, 191, '萨维尼', 'Savinjska', 'SAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2238, 191, '斯波德涅波萨夫', 'Spodnjeposavska', 'SPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2239, 191, '扎萨夫', 'Zasavska', 'ZAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2240, 194, '北部', 'Ash-Shamaliyah', 'ASH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2241, 194, '赤道', 'Al-Istiwaiyah', 'SIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2242, 194, '达尔富尔', 'Darfur', 'SDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2243, 194, '东部', 'Ash-Sharqiyah', 'SHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2244, 194, '加扎勒河', 'Bahr al-Ghazal', 'SBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2245, 194, '喀土穆', 'Al-Khartum', 'KRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2246, 194, '科尔多凡', 'Kurdufan', 'GKU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2247, 194, '上尼罗', 'Aali an-Nil', 'ANB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2248, 194, '中部', 'Al Wasta', 'WDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2249, 195, '布罗科蓬多', 'Brokopondo', 'BR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2250, 195, '科罗尼', 'Coronie', 'CR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2251, 195, '科默韦讷', 'Commewijne', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2252, 195, '马罗韦讷', 'Marowijne', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2253, 195, '尼克里', 'Nickerie', 'NI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2254, 195, '帕拉', 'Para', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2255, 195, '帕拉马里博', 'Paramaribo', 'PM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2256, 195, '萨拉马卡', 'Saramacca', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2257, 195, '瓦尼卡', 'Wanica', 'WA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2258, 195, '西帕里韦尼', 'Sipaliwini', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2259, 196, '瓜达尔卡纳尔', 'Guadalcanal', 'GC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2260, 196, '霍尼亚拉', 'Honiara', 'HO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2261, 196, '拉纳尔和贝罗纳', 'Rennell and Bellona', 'RB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2262, 196, '马基拉', 'Makira', 'MK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2263, 196, '马莱塔', 'Malaita', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2264, 196, '乔伊索', 'Choiseul', 'CH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2265, 196, '泰莫图', 'Temotu', 'TM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2266, 196, '西部', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2267, 196, '伊萨贝尔', 'Isabel', 'IS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2268, 196, '中部群岛', 'Central Islands', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2269, 198, '杜尚别', 'Dushanbe', 'DYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2270, 198, '霍罗格', 'Khorugh', 'KHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2271, 198, '卡尼巴达姆', 'Kanibadam', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2272, 198, '科法尔尼洪', 'Kofarnihon', 'KOF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2273, 198, '苦盏', 'Khujand', 'KHU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2274, 198, '库尔干-秋别', 'Kurgan-Tjube', 'KTJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2275, 198, '库洛布', 'Kulob', 'KLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2276, 198, '洛贡', 'Rogun', 'RGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2277, 198, '努雷克', 'Nurek', 'NUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2278, 198, '彭吉肯特', 'Pendzhikent', 'PJK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2279, 198, '萨班特', 'Sarband', 'SBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2280, 198, '塔博沙尔', 'Taboshar', 'TBS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2281, 198, '图尔孙扎德', 'Tursunzade', 'TSZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2282, 198, '乌拉秋别', 'Ura-Tjube', 'UTJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2283, 198, '伊斯法拉', 'Isfara', 'ISF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2284, 199, '安纳乍能', 'Amnat Charoen', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2285, 199, '巴蜀', 'Prachuap Khiri Khan', '77', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2286, 199, '巴吞他尼', 'Pathum Thani', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2287, 199, '巴真', 'Prachin Buri', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2288, 199, '北碧', 'Kanchanaburi', '71', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2289, 199, '北标', 'Saraburi', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2290, 199, '北大年', 'Pattani', '94', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2291, 199, '北揽', 'Samut Prakan', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2292, 199, '北榄坡', 'Nakhon Sawan', '60', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2293, 199, '北柳', 'Chachoengsao', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2294, 199, '碧差汶', 'Phetchabun', '76', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2295, 199, '博达伦', 'Phatthalung', '93', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2296, 199, '猜那', 'Chai Nat', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2297, 199, '猜也奔', 'Chaiyaphum', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2298, 199, '程逸', 'Uttaradit', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2299, 199, '春蓬', 'Chumphon', '86', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2300, 199, '春武里', 'Chon Buri', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2301, 199, '达', 'Tak', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2302, 199, '达叻', 'Trat', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2303, 199, '大城', 'Phra Nakhon Si Ayutthaya', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2304, 199, '董里', 'Trang', '92', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2305, 199, '佛丕', 'Phetchaburi', '78', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2306, 199, '佛统', 'Nakhon Pathom', '73', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2307, 199, '甘烹碧', 'Kamphaeng Phet', '62', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2308, 199, '红统', 'Ang Thong', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2309, 199, '华富里', 'Lop Buri', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2310, 199, '加拉信', 'Kalasin', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2311, 199, '甲米', 'Krabi', '81', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2312, 199, '尖竹汶', 'Chanthaburi', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2313, 199, '孔敬', 'Khon Kaen', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2314, 199, '拉农', 'Rayong', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2315, 199, '廊开', 'Nong Khai', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2316, 199, '廊莫那浦', 'Nong Bua Lamphu', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2317, 199, '叻丕', 'Ratchaburi', '70', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2318, 199, '黎', 'Loei', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2319, 199, '黎逸', 'Roi Et', '45', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2320, 199, '龙仔厝', 'Samut Sakhon', '74', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2321, 199, '罗勇', 'Ranong', '85', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2322, 199, '洛坤', 'Nakhon Si Thammarat', '80', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2323, 199, '玛哈沙拉堪', 'Maha Sarakham', '44', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2324, 199, '曼谷', 'Bangkok', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2325, 199, '莫达汉', 'Mukdahan', '49', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2326, 199, '那空那育', 'Nakhon Nayok', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2327, 199, '那空帕农', 'Nakhon Phanom', '48', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2328, 199, '难', 'Nan', '55', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2329, 199, '南奔', 'Lamphun', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2330, 199, '暖武里', 'Nonthaburi', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2331, 199, '帕', 'Phrae', '54', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2332, 199, '帕尧', 'Phayao', '56', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2333, 199, '攀牙', 'Phangnga', '82', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2334, 199, '彭世洛', 'Phitsanulok', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2335, 199, '披集', 'Phichit', '66', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2336, 199, '普吉', 'Phuket', '83', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2337, 199, '清莱', 'Chiang Rai', '57', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2338, 199, '清迈', 'Chiang Mai', '50', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2339, 199, '色军', 'Sakon Nakhon', '47', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2340, 199, '沙敦', 'Satun', '91', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2341, 199, '沙缴', 'Sa Kaeo', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2342, 199, '四色菊', 'Si sa ket', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2343, 199, '宋卡', 'Songkhla', '90', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2344, 199, '素可泰', 'Sukhothai', '64', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2345, 199, '素叻', 'Surat Thani', '84', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2346, 199, '素林', 'Surin', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2347, 199, '素攀武里', 'Suphan Buri', '72', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2348, 199, '陶公', 'Narathiwat', '96', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2349, 199, '乌隆', 'Udon Thani', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2350, 199, '乌泰他尼', 'Uthai Thani', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2351, 199, '乌汶', 'Ubon Ratchathani', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2352, 199, '武里南', 'Buri Ram', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2353, 199, '信武里', 'Sing Buri', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2354, 199, '耶梭通', 'Yasothon', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2355, 199, '也拉', 'Yala', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2356, 199, '夜丰颂', 'Mae Hong Son', '58', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2357, 199, '夜功', 'Samut Songkhram', '75', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2358, 200, '阿鲁沙', 'Arusha', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2359, 200, '奔巴北', 'Kaskazini Pemba', 'PN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2360, 200, '奔巴南', 'Kusini Pemba', 'PS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2361, 200, '滨海', 'Pwani', 'PW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2362, 200, '达累斯萨拉姆', 'Dar es Salaam', 'DS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2363, 200, '多多马', 'Dodoma', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2364, 200, '基戈马', 'Kigoma', 'KI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2365, 200, '卡盖拉', 'Kagera', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2366, 200, '林迪', 'Lindi', 'LN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2367, 200, '鲁夸', 'Rukwa', 'RK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2368, 200, '鲁伍马', 'Ruvuma', 'RV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2369, 200, '马腊', 'Mara', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2370, 200, '曼亚拉', 'Manyara', 'MY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2371, 200, '莫洛戈罗', 'Morogoro', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2372, 200, '姆贝亚', 'Mbeya', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2373, 200, '姆特瓦拉', 'Mtwara', 'MT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2374, 200, '姆万扎', 'Mwanza', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2375, 200, '乞力马扎罗', 'Kilimanjaro', 'KJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2376, 200, '桑给巴尔', 'Zanzibar', 'ZN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2377, 200, '桑给巴尔北', 'Kaskazini Unguja', 'UN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2378, 200, '桑给巴尔南', 'Kusini Unguja', 'US', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2379, 200, '桑给巴尔市和西', 'Mjini Magharibi', 'MM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2380, 200, '塔波拉', 'Tabora', 'TB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2381, 200, '坦噶', 'Tanga', 'TN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2382, 200, '辛吉达', 'Singida', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2383, 200, '欣延加', 'Shinyanga', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2384, 200, '伊林加', 'Iringa', 'IR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2385, 201, '埃瓦', 'Eua', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2386, 201, '哈派', 'Haapai', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2387, 201, '纽阿斯', 'Niuas', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2388, 201, '汤加塔布', 'Tongatapu', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2389, 201, '瓦瓦乌', 'Vavau', 'V', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2390, 205, '艾尔亚奈', 'Ariana', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2391, 205, '巴杰', 'Beja', 'BJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2392, 205, '本阿鲁斯', 'Ben Arous', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2393, 205, '比塞大', 'Bizerte', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2394, 205, '吉比利', 'Kebili', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2395, 205, '加贝斯', 'Gabes', 'GB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2396, 205, '加夫萨', 'Gafsa', 'GF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2397, 205, '坚杜拜', 'Jendouba', 'JE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2398, 205, '卡夫', 'Le Kef', 'LK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2399, 205, '卡塞林', 'Kasserine', 'KS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2400, 205, '凯鲁万', 'Kairouan', 'KR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2401, 205, '马赫迪耶', 'Mahdia', 'MH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2402, 205, '马努巴', 'Manouba', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2403, 205, '梅德宁', 'Medenine', 'ME', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2404, 205, '莫纳斯提尔', 'Monastir', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2405, 205, '纳布勒', 'Nabeul', 'NA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2406, 205, '斯法克斯', 'Sfax', 'SF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2407, 205, '苏塞', 'Sousse', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2408, 205, '泰塔温', 'Tataouine', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2409, 205, '突尼斯', 'Tunis', 'TU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2410, 205, '托泽尔', 'Tozeur', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2411, 205, '西迪布济德', 'Sidi Bouzid', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2412, 205, '锡勒亚奈', 'Siliana', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2413, 205, '宰格万', 'Zaghouan', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2414, 207, '阿达纳', 'Adana', 'ADA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2415, 207, '阿德亚曼', 'Adiyaman', 'ADI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2416, 207, '阿尔达罕', 'Ardahan', 'ARD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2417, 207, '阿尔特温', 'Artvin', 'ART', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2418, 207, '阿菲永', 'Afyon', 'AFY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2419, 207, '阿克萨赖', 'Aksaray', 'AKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2420, 207, '阿勒', 'Agri', 'AGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2421, 207, '阿马西亚', 'Amasya', 'AMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2422, 207, '埃迪尔内', 'Edirne', 'EDI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2423, 207, '埃尔津詹', 'Erzincan', 'EZC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2424, 207, '埃尔祖鲁姆', 'Erzurum', 'EZR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2425, 207, '埃拉泽', 'Elazig', 'ELA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2426, 207, '埃斯基谢希尔', 'Eskisehir', 'ESK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2427, 207, '艾登', 'Aydin', 'AYI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2428, 207, '安卡拉', 'Ankara', 'ANK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2429, 207, '安塔利亚', 'Antalya', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2430, 207, '奥尔杜', 'Ordu', 'ORD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2431, 207, '巴尔腾', 'Bartin', 'BAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2432, 207, '巴勒克埃西尔', 'Balikesir', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2433, 207, '巴特曼', 'Batman', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2434, 207, '巴伊布尔特', 'Bayburt', 'BAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2435, 207, '比莱吉克', 'Bilecik', 'BIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2436, 207, '比特利斯', 'Bitlis', 'BIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2437, 207, '宾格尔', 'Bingol', 'BIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2438, 207, '博卢', 'Bolu', 'BOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2439, 207, '布尔杜尔', 'Burdur', 'BRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2440, 207, '布尔萨', 'Bursa', 'BRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2441, 207, '昌克勒', 'Cankiri', 'CKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2442, 207, '代尼兹利', 'Denizli', 'DEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2443, 207, '迪亚巴克尔', 'Diyarbakir', 'DIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2444, 207, '凡', 'Van', 'VAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2445, 207, '哈卡里', 'Hakkari', 'HKR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2446, 207, '哈塔伊', 'Hatay', 'HTY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2447, 207, '基利斯', 'Kilis', 'KLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2448, 207, '吉雷松', 'Giresun', 'GIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2449, 207, '加济安泰普', 'Gaziantep', 'GAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2450, 207, '居米什哈内', 'Gumushane', 'GMS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2451, 207, '卡尔斯', 'Kars', 'KRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2452, 207, '卡赫拉曼马拉什', 'Kahraman Maras', 'KAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2453, 207, '卡拉比克', 'Karabuk', 'KRB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2454, 207, '卡拉曼', 'Karaman', 'KRM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2455, 207, '卡斯塔莫努', 'Kastamonu', 'KAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2456, 207, '开塞利', 'Kayseri', 'KAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2457, 207, '科贾埃利', 'Kocaeli', 'KOC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2458, 207, '柯克拉雷利', 'Kirklareli', 'KLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2459, 207, '科尼亚', 'Konya', 'KON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2460, 207, '克尔谢希尔', 'Kirsehir', 'KRH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2461, 207, '克勒克卡莱', 'Kirikkale', 'KRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2462, 207, '拉飞', 'Urfa', 'URF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2463, 207, '里泽', 'Rize', 'RIZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2464, 207, '马尔丁', 'Mardin', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2465, 207, '马拉蒂亚', 'Malatya', 'MAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2466, 207, '马尼萨', 'Manisa', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2467, 207, '穆拉', 'Mugla', 'MUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2468, 207, '穆什', 'Mus', 'MUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2469, 207, '内夫谢希尔', 'Nevsehir', 'NEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2470, 207, '尼代', 'Nigde', 'NIG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2471, 207, '恰纳卡莱', 'Canakkale', 'CKL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2472, 207, '乔鲁姆', 'Corum', 'COR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2473, 207, '屈塔希亚', 'Kutahya', 'KUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2474, 207, '萨卡里亚', 'Sakarya', 'SAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2475, 207, '萨姆松', 'Samsun', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2476, 207, '泰基尔达', 'Tekirdag', 'TEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2477, 207, '特拉布宗', 'Trabzon', 'TRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2478, 207, '通杰利', 'Tunceli', 'TUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2479, 207, '托卡特', 'Tokat', 'TOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2480, 207, '乌萨克', 'Usak', 'USK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2481, 207, '锡尔纳克', 'Sirnak', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2482, 207, '锡尔特', 'Siirt', 'SII', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2483, 207, '锡诺普', 'Sinop', 'SIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2484, 207, '锡瓦斯', 'Sivas', 'SIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2485, 207, '伊迪尔', 'Igdir', 'IGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2486, 207, '伊切尔', 'Icel', 'ICE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2487, 207, '伊斯帕尔塔', 'Isparta', 'ISP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2488, 207, '伊斯坦布尔', 'Istanbul', 'IST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2489, 207, '伊兹密尔', 'Izmir', 'IZM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2490, 207, '约兹加特', 'Yozgat', 'YOZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2491, 207, '宗古尔达克', 'Zonguldak', 'ZON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2492, 208, '阿哈尔', 'Ahal', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2493, 208, '阿什哈巴德市', 'Ashgabat', 'ASB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2494, 208, '巴尔坎', 'Balkan', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2495, 208, '达沙古兹', 'Dashoguz', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2496, 208, '列巴普', 'Lebap', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2497, 208, '马雷', 'Mary', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2498, 208, '涅比特达格', 'Nebitdag', 'NEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2499, 211, '马朗帕', 'Malampa', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2500, 211, '彭纳马', 'Penama', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2501, 211, '桑马', 'Sanma', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2502, 211, '塔菲阿', 'Tafea', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2503, 211, '托尔巴', 'Torba', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2504, 211, '谢法', 'Shefa', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2505, 212, '埃尔普罗格雷索', 'El Progreso', 'PR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2506, 212, '埃斯昆特拉', 'Escuintla', 'ES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2507, 212, '哈拉帕', 'Jalapa', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2508, 212, '胡蒂亚帕', 'Jutiapa', 'JU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2509, 212, '基切', 'Quiche', 'QC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2510, 212, '克萨尔特南戈', 'Quetzaltenango', 'QZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2511, 212, '雷塔卢莱乌', 'Retalhuleu', 'RE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2512, 212, '米克斯科', 'Mixco', 'MIX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2513, 212, '佩滕', 'Peten', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2514, 212, '奇基穆拉', 'Chiquimula', 'CQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2515, 212, '奇马尔特南戈', 'Chimaltenango', 'CM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2516, 212, '萨卡帕', 'Zacapa', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2517, 212, '萨卡特佩克斯', 'Sacatepequez', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2518, 212, '上韦拉帕斯', 'Alta Verapaz', 'AV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2519, 212, '圣罗莎', 'Santa Rosa', 'SR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2520, 212, '圣马科斯', 'San Marcos', 'SM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2521, 212, '苏奇特佩克斯', 'Suchitepequez', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2522, 212, '索洛拉', 'Solola', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2523, 212, '托托尼卡潘', 'Totonicapan', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2524, 212, '危地马拉', 'Guatemala', 'GU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2525, 212, '韦韦特南戈', 'Huehuetenango', 'HU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2526, 212, '下韦拉帕斯', 'Baja Verapaz', 'BV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2527, 212, '新城', 'Villa Nueva', 'VIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2528, 212, '伊萨瓦尔', 'Izabal', 'IZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2529, 215, '阿拉瓜', 'Aragua', 'D', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2530, 215, '阿马库罗三角洲', 'Delta Amacuro', 'Y', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2531, 215, '阿普雷', 'Apure', 'C', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2532, 215, '安索阿特吉', 'Anzoategui', 'B', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2533, 215, '巴里纳斯', 'Barinas', 'E', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2534, 215, '玻利瓦尔', 'Bolivar', 'F', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2535, 215, '波图格萨', 'Portuguesa', 'P', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2536, 215, '法尔孔', 'Falcon', 'I', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2537, 215, '瓜里科', 'Guarico', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2538, 215, '加拉加斯', 'Caracas', 'A', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2539, 215, '卡拉沃沃', 'Carabobo', 'G', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2540, 215, '科赫德斯', 'Cojedes', 'H', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2541, 215, '拉腊', 'Lara', 'K', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2542, 215, '联邦属地', 'Dependencias Federales', 'W', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2543, 215, '梅里达', 'Merida', 'L', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2544, 215, '米兰达', 'Miranda', 'M', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2545, 215, '莫纳加斯', 'Monagas', 'N', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2546, 215, '苏克雷', 'Sucre', 'R', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2547, 215, '苏利亚', 'Zulia', 'V', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2548, 215, '塔奇拉', 'Tachira', 'S', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2549, 215, '特鲁希略', 'Trujillo', 'T', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2550, 215, '新埃斯帕塔', 'Estado Nueva Esparta', 'O', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2551, 215, '亚拉奎', 'Yaracuy', 'U', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2552, 215, '亚马孙', 'Amazonas', 'Z', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2553, 217, '阿鲁阿', 'Arua', 'ARU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2554, 217, '阿帕克', 'Apac', 'APC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2555, 217, '阿朱马尼', 'Adjumani', 'ADJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2556, 217, '本迪布焦', 'Bundibugyo', 'BUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2557, 217, '布吉里', 'Bugiri', 'BUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2558, 217, '布西亚', 'Busia', 'BUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2559, 217, '布谢尼', 'Bushenyi', 'BSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2560, 217, '恩通加莫', 'Ntungamo', 'NTU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2561, 217, '古卢', 'Gulu', 'GUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2562, 217, '霍伊马', 'Hoima', 'HOI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2563, 217, '基巴莱', 'Kibaale', 'KBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2564, 217, '基博加', 'Kiboga', 'KIB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2565, 217, '基恩乔乔', 'Kyenjojo', 'KYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2566, 217, '基索罗', 'Kisoro', 'KIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2567, 217, '基特古姆', 'Kitgum', 'KIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2568, 217, '金贾', 'Jinja', 'JIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2569, 217, '卡巴莱', 'Kabale', 'KBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2570, 217, '卡巴罗莱', 'Kabarole', 'KAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2571, 217, '卡贝拉马伊多', 'Kaberamaido', 'KAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2572, 217, '卡兰加拉', 'Kalangala', 'KAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2573, 217, '卡姆文盖', 'Kamwenge', 'KAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2574, 217, '卡穆利', 'Kamuli', 'KML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2575, 217, '卡农古', 'Kanungu', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2576, 217, '卡普乔鲁瓦', 'Kapchorwa', 'KPC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2577, 217, '卡塞塞', 'Kasese', 'KAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2578, 217, '卡塔奎', 'Katakwi', 'KTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2579, 217, '卡永加', 'Kayunga', 'KAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2580, 217, '坎帕拉', 'Kampala', 'KMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2581, 217, '科蒂多', 'Kotido', 'KOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2582, 217, '库米', 'Kumi', 'KUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2583, 217, '拉卡伊', 'Rakai', 'RAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2584, 217, '利拉', 'Lira', 'LIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2585, 217, '卢韦罗', 'Luwero', 'LUW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2586, 217, '鲁昆吉里', 'Rukungiri', 'RUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2587, 217, '马萨卡', 'Masaka', 'MAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2588, 217, '马辛迪', 'Masindi', 'MSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2589, 217, '马尤盖', 'Mayuge', 'MAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2590, 217, '莫罗托', 'Moroto', 'MRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2591, 217, '莫约', 'Moyo', 'MOY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2592, 217, '姆巴拉拉', 'Mbarara', 'MBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2593, 217, '姆巴莱', 'Mbale', 'MBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2594, 217, '姆皮吉', 'Mpigi', 'MPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2595, 217, '穆本德', 'Mubende', 'MUB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2596, 217, '穆科诺', 'Mukono', 'MUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2597, 217, '纳卡皮里皮里特', 'Nakapiripirit', 'NAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2598, 217, '纳卡松戈拉', 'Nakasongola', 'NKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2599, 217, '内比', 'Nebbi', 'NEB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2600, 217, '帕德尔', 'Pader', 'PAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2601, 217, '帕利萨', 'Pallisa', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2602, 217, '森巴布莱', 'Sembabule', 'SEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2603, 217, '索罗提', 'Soroti', 'SOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2604, 217, '托罗罗', 'Tororo', 'TOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2605, 217, '瓦基索', 'Wakiso', 'WAK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2606, 217, '锡龙科', 'Sironko', 'SIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2607, 217, '伊甘加', 'Iganga', 'IGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2608, 217, '永贝', 'Yumbe', 'YUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2609, 218, '敖德萨', 'Odessa', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2610, 218, '波尔塔瓦', 'Poltava', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2611, 218, '第聂伯罗波得罗夫斯克', 'Dnipropetrovsk', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2612, 218, '顿涅茨克', 'Donetsk', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2613, 218, '哈尔科夫', 'Kharkiv', '63', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2614, 218, '赫尔松州', 'Khersonsrka', '65', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2615, 218, '赫梅利尼茨基', 'Khmelnytsky', '68', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2616, 218, '基辅', 'Kyiv', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2617, 218, '基洛夫格勒', 'Kirovohrad', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2618, 218, '捷尔诺波尔', 'Ternopil', '61', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2619, 218, '克里米亚自治共和国', 'Respublika Krym', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2620, 218, '利沃夫', 'Lviv', '46', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2621, 218, '卢甘斯克', 'Luhansk', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2622, 218, '罗夫诺', 'Rivne', '56', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2623, 218, '尼古拉耶夫', 'Mykolayiv', '48', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2624, 218, '切尔卡瑟', 'Cherkasy', '71', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2625, 218, '切尔尼戈夫', 'Chernihiv', '74', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2626, 218, '切尔诺夫策', 'Chernivtsi', '77', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2627, 218, '日托米尔', 'Zhytomyr', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2628, 218, '苏梅', 'Sumy', '59', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2629, 218, '外喀尔巴阡', 'Zakarpatska', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2630, 218, '文尼察', 'Vinnytsya', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2631, 218, '沃伦', 'Volyn', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2632, 218, '伊万－弗兰科夫州', 'Ivano-Frankivsk', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2633, 218, '扎波罗热', 'Zaporizhzhya', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2634, 219, '阿蒂加斯', 'Artigas', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2635, 219, '杜拉斯诺', 'Durazno', 'DU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2636, 219, '佛罗里达', 'Florida', 'FA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2637, 219, '弗洛雷斯', 'Flores', 'FS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2638, 219, '卡内洛内斯', 'Canelones', 'CA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2639, 219, '科洛尼亚', 'Colonia', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2640, 219, '拉瓦耶哈', 'Lavalleja', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2641, 219, '里韦拉', 'Rivera', 'RV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2642, 219, '罗恰', 'Rocha', 'RO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2643, 219, '马尔多纳多', 'Maldonado', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2644, 219, '蒙得维的亚', 'Montevideo', 'MO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2645, 219, '内格罗河', 'Rio Negro', 'RN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2646, 219, '派桑杜', 'Paysandu', 'PA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2647, 219, '萨尔托', 'Salto', 'SL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2648, 219, '塞罗拉尔戈', 'Cerro Largo', 'CL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2649, 219, '三十三人', 'Treinta y Tres', 'TT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2650, 219, '圣何塞', 'San Jose', 'SJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2651, 219, '索里亚诺', 'Soriano', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2652, 219, '塔夸伦博', 'Tacuarembo', 'TAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2653, 220, '安集延', 'Andijon', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2654, 220, '布哈拉', 'Buxoro', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2655, 220, '费尔干纳', 'Fargona', 'FA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2656, 220, '花拉子模', 'Xorazm', 'XO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2657, 220, '吉扎克', 'Jizzax', 'JI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2658, 220, '卡拉卡尔帕克斯坦共和国', 'Qoraqalpogiston', 'QR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2659, 220, '卡什卡达里亚', 'Qasqadaryo', 'QA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2660, 220, '纳曼干', 'Namangan', 'NG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2661, 220, '纳沃伊', 'Navoiy', 'NW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2662, 220, '撒马尔罕', 'Samarqand', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2663, 220, '苏尔汉河', 'Surxondaryo', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2664, 220, '塔什干', 'Toshkent', 'TK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2665, 220, '塔什干市', 'Toshkent Shahri', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2666, 220, '锡尔河', 'Sirdaryo', 'SI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2667, 221, '阿尔梅里亚', 'Almeria', 'LEI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2668, 221, '阿尔瓦塞特', 'Albacete', 'ALB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2669, 221, '阿拉瓦', 'Alava', 'ALA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2670, 221, '阿利坎特', 'Alicante', 'ALC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2671, 221, '阿斯图利亚斯', 'Asturias', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2672, 221, '阿维拉', 'Avila', 'AVI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2673, 221, '奥伦塞', 'Orense', 'ORE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2674, 221, '巴达霍斯', 'Badajoz', 'BJZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2675, 221, '巴利阿里', 'Baleares', 'BLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2676, 221, '巴利亚多利德', 'Valladolid', 'VLL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2677, 221, '巴伦西亚', 'Valencia', 'VLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2678, 221, '巴塞罗那', 'Barcelona', 'BCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2679, 221, '比斯开', 'Vizcaya', 'VSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2680, 221, '布尔戈斯', 'Burgos', 'BUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2681, 221, '格拉纳达', 'Granada', 'GRX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2682, 221, '瓜达拉哈拉', 'Guadalajara', 'GUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2683, 221, '哈恩', 'Jaen', 'JAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2684, 221, '赫罗纳', 'Gerona', 'GRO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2685, 221, '吉普斯夸', 'Guipuzcoa', 'GUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2686, 221, '加的斯', 'Cadiz', 'CAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2687, 221, '卡塞雷斯', 'Caceres', 'CCS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2688, 221, '卡斯蒂利亚', 'Cludad Real', 'CIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2689, 221, '卡斯特利翁', 'Castellon', 'CAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2690, 221, '科尔多瓦', 'Cordoba', 'ODB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2691, 221, '昆卡', 'Cuenca', 'CUE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2692, 221, '拉科鲁尼亚', 'La Coruna', 'LCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2693, 221, '拉里奥哈', 'La Rioja', 'ARL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2694, 221, '拉斯帕尔马斯', 'Las Palmas', 'LPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2695, 221, '莱昂', 'Leon', 'LEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2696, 221, '莱里达', 'Lleida', 'LLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2697, 221, '卢戈', 'Provincia de Lugo', 'LGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2698, 221, '马德里', 'Madrid', 'MAD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2699, 221, '马拉加', 'Malaga', 'AGP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2700, 221, '穆尔西亚', 'Murcia', 'MJV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2701, 221, '纳瓦拉', 'Navarra', 'NVV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2702, 221, '帕伦西亚', 'Palencia', 'PAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2703, 221, '蓬特韦德拉', 'Provincia de Pontevedra', 'PEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2704, 221, '萨拉戈萨', 'Zaragoza', 'ZAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2705, 221, '萨拉曼卡', 'Salamanca', 'SLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2706, 221, '萨莫拉', 'Zamora', 'ZMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2707, 221, '塞哥维亚', 'Segovia', 'SEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(2708, 221, '塞维利亚', 'Sevilla', 'SVQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2709, 221, '桑坦德', 'Santander', 'SDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2710, 221, '圣克鲁斯-德特内里费', 'Santa Cruz de Tenerife', 'SCT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2711, 221, '索里亚', 'Soria', 'SOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2712, 221, '塔拉戈纳', 'Tarragona', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2713, 221, '特鲁埃尔', 'Teruel', 'TER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2714, 221, '托莱多', 'Toledo', 'TOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2715, 221, '韦尔瓦', 'Huelva', 'HUV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2716, 221, '韦斯卡', 'Huesca', 'HUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2717, 222, '比雷埃夫斯', 'Peiraievs', 'PRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2718, 222, '多德卡尼斯', 'Dodecanese', 'DO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2719, 222, '干尼亚', 'Chanion', 'CHQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2720, 222, '基克拉迪', 'Cyclades', 'CY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2721, 222, '拉西锡', 'Lasithiou', 'LST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2722, 222, '莱斯博斯', 'Lesbos', 'LES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2723, 222, '雷西姆农', 'Rethymnis', 'RET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2724, 222, '萨摩斯', 'Samos', 'SMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2725, 222, '雅典', 'Athens', 'ATH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2726, 222, '伊拉克里翁', 'Irakleiou', 'HER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2727, 225, '奥克兰', 'Auckland', 'AUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2728, 225, '北岸', 'North Shore', 'NSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2729, 225, '北帕默斯顿', 'Palmerston North', 'PMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2730, 225, '北远', 'Far North', 'FNR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2731, 225, '布莱尼姆', 'Blenheim', 'BHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2732, 225, '达尼丁', 'Dunedin', 'DUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2733, 225, '格雷茅斯', 'Greymouth', 'GMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2734, 225, '哈密尔顿', 'Hamilton', 'HLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2735, 225, '黑斯廷斯', 'Hastings', 'HAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2736, 225, '怀塔科拉', 'Waitakere', 'WAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2737, 225, '吉斯伯恩', 'Gisborne', 'GIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2738, 225, '凯帕拉', 'Kaipara', 'KAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2739, 225, '克赖斯特彻奇', 'Christchurch', 'CHC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2740, 225, '里士满', 'Richmond', 'RMD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2741, 225, '马努考', 'Manukau', 'MNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2742, 225, '纳尔逊', 'Nelson', 'NSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2743, 225, '内皮尔', 'Napier', 'NPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2744, 225, '斯特拉特福德', 'Stratford', 'STR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2745, 225, '陶马鲁努伊', 'Taumarunui', 'TAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2746, 225, '瓦卡塔尼', 'Whakatane', 'WHK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2747, 225, '旺阿雷', 'Whangarei', 'WRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2748, 225, '旺格努伊', 'Wanganui', 'WAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2749, 225, '新普利茅斯', 'New Plymouth', 'NPL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2750, 225, '因弗卡吉尔', 'Invercargill', 'IVC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2751, 226, '巴兰尼亚', 'Baranya', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2752, 226, '巴奇-基什孔', 'Bacs-Kiskun', 'BK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2753, 226, '包尔绍德-奥包乌伊-曾普伦', 'Borsod-Abauj-Zemplen', 'BZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2754, 226, '贝凯什', 'Bekes', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2755, 226, '布达佩斯', 'Budapest', 'BU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2756, 226, '费耶尔', 'Fejer', 'FE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2757, 226, '豪伊杜-比豪尔', 'Hajdu-Bihar', 'HB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2758, 226, '赫维什', 'Heves', 'HE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2759, 226, '加兹-纳杰孔-索尔诺克', 'Jasz-Nagykun-Szolnok', 'JN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2760, 226, '杰尔-莫松-肖普朗', 'Gyor-Moson-Sopron', 'GS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2761, 226, '科马罗姆', 'Komarom-Esztergom', 'KE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2762, 226, '诺格拉德', 'Nograd', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2763, 226, '佩斯', 'Pest', 'PE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2764, 226, '琼格拉德', 'Csongrad', 'CS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2765, 226, '绍莫吉', 'Somogy', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2766, 226, '索博尔奇-索特马尔-贝拉格', 'Szabolcs-Szatmar-Bereg', 'SZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2767, 226, '托尔瑙', 'Tolna', 'TO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2768, 226, '维斯普雷姆', 'Veszprem', 'VE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2769, 226, '沃什', 'Vas', 'VA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2770, 226, '佐洛', 'Zala', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2771, 227, '阿勒颇', 'Halab', 'HL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2772, 227, '大马士革', 'Rif Dimashq', 'RD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2773, 227, '大马士革市', 'Madinat Dimashq', 'DI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2774, 227, '代尔祖尔', 'Dayr az Zawr', 'DZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2775, 227, '德拉', 'Dara', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2776, 227, '哈马', 'Hamah', 'HM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2777, 227, '哈塞克', 'Al Hasakah', 'HA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2778, 227, '霍姆斯', 'Hims', 'HI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2779, 227, '加布', 'Al Ghab', 'GH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2780, 227, '卡米什利', 'Al-Qamishli', 'QA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2781, 227, '库奈特拉', 'Al Qunaytirah', 'QU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2782, 227, '拉卡', 'Ar Raqqah', 'RQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2783, 227, '拉塔基亚', 'Al Ladhiqiyah', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2784, 227, '苏韦达', 'As Suwayda', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2785, 227, '塔尔图斯', 'Tartus', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2786, 227, '伊德利卜', 'Idlib', 'ID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2787, 228, '波特兰', 'Portland', 'POR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2788, 228, '汉诺威', 'Hanover', 'HAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2789, 228, '金斯敦', 'Kingston', 'KIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2790, 228, '克拉伦登', 'Clarendon', 'CLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2791, 228, '曼彻斯特', 'Manchester', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2792, 228, '圣安德鲁斯', 'St. Andrews', 'AND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2793, 228, '圣安娜', 'St. Ann', 'ANN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2794, 228, '圣凯瑟琳', 'St. Catherine', 'CAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2795, 228, '圣玛丽', 'St. Mary', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2796, 228, '圣托马斯', 'St. Thomas', 'THO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2797, 228, '圣伊丽莎白', 'St. Elizabeth', 'ELI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2798, 228, '圣詹姆斯', 'St. James', 'JAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2799, 228, '特里洛尼', 'Trelawny', 'TRL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2800, 228, '西摩兰', 'Westmoreland', 'WML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2801, 229, '阿尔马维尔', 'Armavir', 'ARM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2802, 229, '阿拉加措特恩', 'Aragacotn', 'AGT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2803, 229, '阿拉拉特', 'Ararat', 'ARA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2804, 229, '埃里温市', 'Yerevan', 'EVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2805, 229, '格加尔库尼克', 'Gelarkunik', 'GEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2806, 229, '科泰克', 'Kotayk', 'KOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2807, 229, '洛里', 'Lorri', 'LOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2808, 229, '塔武什', 'Tavus', 'TAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2809, 229, '瓦约茨·佐尔', 'VayocJor', 'VAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2810, 229, '希拉克', 'Shirak', 'SHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2811, 229, '休尼克', 'Syunik', 'SYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2812, 230, '阿比扬', 'Abyan', 'AB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2813, 230, '阿姆兰', 'Amran Sana', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2814, 230, '贝达', 'Al-Bayda', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2815, 230, '达利', 'Ad-Dali', 'DA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2816, 230, '哈德拉毛', 'Hadramawt', 'HD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2817, 230, '哈杰', 'Hajjah', 'HJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2818, 230, '荷台达', 'Al-Hudaydah', 'HU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2819, 230, '焦夫', 'Al-Jawf', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2820, 230, '拉赫季', 'Lahij', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2821, 230, '马里卜', 'Marib', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2822, 230, '迈赫拉', 'Al-Mahrah', 'MR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2823, 230, '迈赫维特', 'Al-Mahwit', 'MW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2824, 230, '萨达', 'Sadah', 'SD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2825, 230, '萨那', 'Sana', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2826, 230, '赛文', 'Seiyun', 'GXF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2827, 230, '舍卜沃', 'Shabwah', 'SH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2828, 230, '塔伊兹', 'Taizz', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2829, 230, '希赫尔', 'Ash-Shihr', 'ASR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2830, 230, '亚丁', 'Adan', 'AD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2831, 230, '伊卜', 'Ibb', 'IB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2832, 230, '扎玛尔', 'Dhamar', 'DH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2833, 233, '阿什杜德', 'Ashdod', 'ASH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2834, 233, '贝尔谢巴', 'Beersheba', 'BEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2835, 233, '贝特雁', 'Bat Yam', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2836, 233, '海法', 'Haifa', 'HFA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2837, 233, '霍隆', 'Holon', 'HOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2838, 233, '内坦亚', 'Netanya', 'NAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2839, 233, '特拉维夫', 'Tel Aviv-Yafo', 'TLV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2840, 233, '耶路撒冷', 'Jerusalem', 'J', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2841, 234, '阿斯蒂', 'Asti', 'AST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2842, 234, '阿斯科利皮切诺', 'Ascoli Piceno', 'ASP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2843, 234, '安科纳', 'Ancona', 'AOI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2844, 234, '奥尔比亚', 'Olbia-Tempio', 'OLB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2845, 234, '奥里斯塔诺', 'Oristano', 'QOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2846, 234, '奥斯塔', 'Aosta', 'AOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2847, 234, '巴勒莫', 'Palermo', 'PMO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2848, 234, '巴里', 'Bari', 'BRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2849, 234, '贝加莫', 'Bergamo', 'BGO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2850, 234, '贝内文托', 'Benevento', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2851, 234, '比萨', 'Pisa', 'PSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2852, 234, '波代诺内', 'Pordenone', 'PRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2853, 234, '波坦察', 'Potenza', 'QPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2854, 234, '博洛尼亚', 'Bologna', 'BLQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2855, 234, '布拉', 'Biella', 'BIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2856, 234, '布雷西亚', 'Brescia', 'BRC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2857, 234, '布林迪西', 'Brindisi', 'BDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2858, 234, '的里雅斯特', 'Trieste', 'TRS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2859, 234, '都灵', 'Turin', 'TRN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2860, 234, '费拉拉', 'Ferrara', 'FRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2861, 234, '佛罗伦萨', 'Firenze', 'FLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2862, 234, '福贾', 'Foggia', 'FOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2863, 234, '卡利亚里', 'Cagliari', 'CAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2864, 234, '卡塞塔', 'Caserta', 'CST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2865, 234, '卡塔尼亚', 'Catania', 'CTA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2866, 234, '卡坦扎罗', 'Catanzaro', 'QCZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2867, 234, '坎波巴索', 'Campobasso', 'COB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2868, 234, '科摩', 'Como', 'CIY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2869, 234, '科森扎', 'Cosenza', 'QCS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2870, 234, '克罗托内', 'Crotone', 'CRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2871, 234, '库内奥', 'Cuneo', 'CUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2872, 234, '拉奎拉', 'L''Aquila', 'LAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2873, 234, '拉斯佩齐亚', 'La Spezia', 'SPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2874, 234, '莱科', 'Lecco', 'LCO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2875, 234, '莱切', 'Lecce', 'LCC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2876, 234, '雷焦艾米利亚', 'Reggio Emilia', 'RNE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2877, 234, '雷焦卡拉布里亚', 'Reggio Calabria', 'REG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2878, 234, '里窝那', 'Livorno', 'LIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2879, 234, '罗马', 'Roma', 'ROM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2880, 234, '马萨', 'Massa-Carrara', 'MCR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2881, 234, '马泰拉', 'Matera', 'MTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2882, 234, '蒙扎', 'Monza e Brianza', 'MZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2883, 234, '米兰', 'Milano', 'MIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2884, 234, '摩德纳', 'Modena', 'MOD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2885, 234, '墨西拿', 'Messina', 'MSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2886, 234, '那不勒斯', 'Naples', 'NAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2887, 234, '努奥罗', 'Nuoro', 'QNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2888, 234, '诺瓦拉', 'Novara', 'NVR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2889, 234, '帕尔马', 'Parma', 'PMF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2890, 234, '帕维亚', 'Pavia', 'PAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2891, 234, '佩鲁贾', 'Perugia', 'PEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2892, 234, '热那亚', 'Genova', 'CAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2893, 234, '萨莱诺', 'Salerno', 'SAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2894, 234, '萨萨里', 'Sassari', 'QSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2895, 234, '萨沃纳', 'Savona', 'SVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2896, 234, '塔兰托', 'Taranto', 'TAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2897, 234, '特拉帕尼', 'Trapani', 'TPS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2898, 234, '特伦托', 'Trento', 'TRT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2899, 234, '威尼斯', 'Venice', 'VCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2900, 234, '韦尔切利', 'Vercelli', 'VRL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2901, 234, '维泰博', 'Viterbo', 'VIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2902, 234, '乌迪内', 'Udine', 'UDN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2903, 234, '锡拉库扎', 'Syracuse', 'SYR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2904, 234, '锡耶纳', 'Siena', 'SNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2905, 234, '亚历山德里亚', 'Alessandria', 'ALE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2906, 234, '伊塞尔尼亚', 'Isernia', 'ISE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2907, 235, '艾藻尔', 'Aizawl', 'AJL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2908, 235, '班加罗尔', 'Bangalore', 'BLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2909, 235, '本地治里', 'Pondicherry', 'PNY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2910, 235, '博帕尔', 'Bhopal', 'BHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2911, 235, '布巴内斯瓦尔', 'Bhubaneswar', 'BBI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2912, 235, '昌迪加尔', 'Chandigarh', 'IXC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2913, 235, '达曼', 'Daman', 'DAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2914, 235, '第乌', 'Diu', 'DIU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2915, 235, '甘托克', 'Gangtok', 'GTO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2916, 235, '哥印拜陀', 'Coimbatore', 'CJB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2917, 235, '加尔各答', 'Calcutta', 'CCU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2918, 235, '加里加尔', 'Karaikal', 'KRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2919, 235, '贾巴尔普尔', 'Jabalpur', 'JLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2920, 235, '贾朗达尔', 'Jalandhar', 'JUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2921, 235, '焦特布尔', 'Jodhpur', 'JDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2922, 235, '金奈', 'Chennai', 'MAA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2923, 235, '卡瓦拉蒂', 'Kavaratti', 'KVA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2924, 235, '科希马', 'Kohima', 'KOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2925, 235, '马埃', 'Mahe', 'MAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2926, 235, '马杜赖', 'Madurai', 'IXM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2927, 235, '森伯尔布尔', 'Sambalpur', 'SLR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2928, 235, '特里凡得琅', 'Trivandrum', 'TRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2929, 235, '乌代布尔', 'Udaipur', 'UDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2930, 235, '西隆', 'Shillong', 'SHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2931, 235, '锡尔萨瓦', 'Silvassa', 'SIL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2932, 235, '新德里', 'New Delhi', 'ICD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2933, 235, '亚南', 'Yanam', 'SRV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2934, 235, '因帕尔', 'Imphal', 'IMF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2935, 235, '印多尔', 'Indore', 'IDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2936, 235, '斋普尔', 'Jaipur', 'JAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2937, 236, '巴厘', 'Bali', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2938, 236, '邦加－勿里洞群岛', 'Kepulauan Bangka Belitung', 'BB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2939, 236, '北苏拉威西', 'Sulawesi Utara', 'SA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2940, 236, '北苏门答腊', 'Sumatera Utara', 'SU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2941, 236, '大雅加达首都特区', 'Daerah Tingkat I Kalimantan Barat', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2942, 236, '东加里曼丹', 'Kalimantan Timur', 'KI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2943, 236, '东南苏拉威西', 'Sulawesi Tenggara', 'SG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2944, 236, '东努沙登加拉', 'Nusa Tenggara Timur', 'NT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2945, 236, '东爪哇', 'Java Timur', 'JI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2946, 236, '廖内', 'Riau', 'RI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2947, 236, '马鲁古', 'Maluku', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2948, 236, '明古鲁', 'Bengkulu', 'BE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2949, 236, '楠榜', 'Lampung', 'LA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2950, 236, '南加里曼丹', 'Kalimantan Selatan', 'KS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2951, 236, '南苏拉威西', 'Sulawesi Selatan', 'SN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2952, 236, '南苏门答腊', 'Sumatera Selatan', 'SS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2953, 236, '日惹特区', 'Daerah Istimewa Yogyakarta', 'YO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2954, 236, '万丹', 'Banten', 'BT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2955, 236, '西努沙登加拉', 'Nusa Tenggara Barat', 'NB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2956, 236, '西苏门答腊', 'Sumatera Barat', 'SR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2957, 236, '西爪哇', 'Java Barat', 'JB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2958, 236, '雅加达', 'Jakarta Raya', 'JK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2959, 236, '亚齐', 'Aceh', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2960, 236, '伊里安查亚', 'Irian Jaya', 'IJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2961, 236, '占碑', 'Jambi', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2962, 236, '中加里曼丹', 'Kalimantan Tengah', 'KT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2963, 236, '中苏拉威西', 'Sulawesi Tengah', 'ST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2964, 236, '中爪哇', 'Java Tengah', 'JT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2965, 239, '阿吉隆', 'Allun', 'AJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2966, 239, '安曼', 'Amman', 'AM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2967, 239, '拜勒加', 'Balqa', 'BA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2968, 239, '杰拉什', 'Jarash', 'JA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2969, 239, '卡拉克', 'Karak', 'KA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2970, 239, '鲁赛法', 'Rusayfah', 'RU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2971, 239, '马安', 'Maan', 'MN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2972, 239, '马德巴', 'Madaba', 'MD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2973, 239, '马夫拉克', 'Mafraq', 'MF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2974, 239, '塔菲拉', 'Tafiela', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2975, 239, '亚喀巴', 'Aqaba', 'AQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2976, 239, '伊尔比德', 'Irbid', 'IR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2977, 239, '扎尔卡', 'Zarqa', 'ZA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2978, 240, '海防', 'Haiphong', 'HP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2979, 240, '河内', 'Hanoi', 'HI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2980, 240, '胡志明市', 'Ho Chi Minh City', 'HC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2981, 241, '北方', 'Northern', 'NO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2982, 241, '东方', 'Eastern', 'EA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2983, 241, '卢阿普拉', 'Luapula', 'LP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2984, 241, '卢萨卡', 'Lusaka', 'LK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2985, 241, '南方', 'Southern', 'SO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2986, 241, '铜带', 'Copperbelt', 'CB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2987, 241, '西北', 'North-Western', 'NW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2988, 241, '西方', 'Western', 'WE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2989, 241, '中央', 'Central', 'CE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2990, 245, '阿劳卡尼亚大区', 'Region de la Araucania', 'AR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2991, 245, '阿塔卡马大区', 'Region de Atacama', 'AT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2992, 245, '安托法加斯塔大区', 'Region de Antofagasta', 'AN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2993, 245, '比奥比奥大区', 'Region del Biobio', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2994, 245, '复活节岛', 'Libertador', 'LI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2995, 245, '湖大区', 'Region de los Lagos', 'LL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2996, 245, '科金博大区', 'Region de Coquimbo', 'CO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2997, 245, '马乌莱大区', 'Region del Maule', 'ML', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2998, 245, '麦哲伦-智利南极大区', 'Magallanes y Antartica Chilena', 'MA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(2999, 245, '圣地亚哥', 'Metropolitana de Santiago', 'RM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3000, 245, '塔拉帕卡大区', 'Region de Tarapaca', 'TA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3001, 245, '瓦尔帕莱索大区', 'Region de Valparaiso', 'VS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3002, 245, '伊瓦涅斯将军的艾森大区', 'Region de Alsen del General Carlos Ibanez del', 'AI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3003, 246, '巴明吉-班戈兰', 'Bamingui-Bangoran', 'BB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3004, 246, '班吉直辖市', 'Bangui', 'BGF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3005, 246, '宾博', 'Bimbo', 'BI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3006, 246, '凯莫', 'Kemo', 'KG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3007, 246, '洛巴伊', 'Lobaye', 'LB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3008, 246, '曼贝雷-卡代', 'Mambere-Kadei', 'HS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3009, 246, '姆博穆', 'Mbomou', 'MB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3010, 246, '纳纳-格里比齐', 'Nana-Gribizi', 'KB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3011, 246, '纳纳-曼贝雷', 'Nana-Mambere', 'NM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3012, 246, '桑加-姆巴埃雷', 'Sangha-Mbaere', 'SE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3013, 246, '上科托', 'Haute-Kotto', 'HK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3014, 246, '上姆博穆', 'Haut-Mbomou', 'HM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3015, 246, '瓦卡', 'Ouaka', 'UK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3016, 246, '瓦卡加', 'Vakaga', 'VK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3017, 246, '瓦姆', 'Ouham', 'AC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3018, 246, '瓦姆-彭代', 'Ouham-Pende', 'OP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3019, 246, '翁贝拉-姆波科', 'Ombella-Mpoko', 'MP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3020, 246, '下科托', 'Basse-Kotto', 'BK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3021, 247, '东城', 'Dongcheng', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3022, 247, '西城', 'Xicheng', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3023, 247, '朝阳', 'Chaoyang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3024, 247, '丰台', 'Fengtai', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3025, 247, '石景山', 'Shijingshan', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3026, 247, '海淀', 'Haidian', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3027, 247, '门头沟', 'Mentougou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3028, 247, '房山', 'Fangshan', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3029, 247, '通州', 'Tongzhou', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3030, 247, '顺义', 'Shunyi', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3031, 247, '昌平', 'Changping', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3032, 247, '大兴', 'Daxing', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3033, 247, '平谷', 'Pinggu', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3034, 247, '怀柔', 'Huairou', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3035, 247, '密云', 'Miyun', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3036, 247, '延庆', 'Yanqing', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3037, 248, '和平', 'Heping', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3038, 248, '河东', 'Hedong', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3039, 248, '河西', 'Hexi', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3040, 248, '南开', 'Nankai', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3041, 248, '河北', 'Hebei', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3042, 248, '红桥', 'Hongqiao', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3043, 248, '滨海新区', 'Binghaixinqu', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3044, 248, '东丽', 'Dongli', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3045, 248, '西青', 'Xiqing', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3046, 248, '津南', 'Jinnan', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3047, 248, '北辰', 'Beichen', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3048, 248, '宁河', 'Ninghe', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3049, 248, '武清', 'Wuqing', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3050, 248, '静海', 'Jinghai', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3051, 248, '宝坻', 'Baodi', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3052, 248, '蓟县', 'Jixian', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3053, 249, '石家庄', 'Shijiazhuang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3054, 249, '唐山', 'Tangshan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3055, 249, '秦皇岛', 'Qinhuangdao', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3056, 249, '邯郸', 'Handan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3057, 249, '邢台', 'Xingtai', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3058, 249, '保定', 'Baoding', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3059, 249, '张家口', 'Zhangjiakou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3060, 249, '承德', 'Chengde', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3061, 249, '沧州', 'Cangzhou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3062, 249, '廊坊', 'Langfang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3063, 249, '衡水', 'Hengshui', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3064, 250, '太原', 'Taiyuan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3065, 250, '大同', 'Datong', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3066, 250, '阳泉', 'Yangquan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3067, 250, '长治', 'Changzhi', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3068, 250, '晋城', 'Jincheng', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3069, 250, '朔州', 'Shuozhou', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3070, 250, '晋中', 'Jinzhong', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3071, 250, '运城', 'Yuncheng', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3072, 250, '忻州', 'Xinzhou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3073, 250, '临汾', 'Linfen', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3074, 250, '吕梁', 'luliang', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3075, 251, '呼和浩特', 'Hohhot', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3076, 251, '包头', 'Baotou', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3077, 251, '乌海', 'Wuhai', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3078, 251, '赤峰', 'Chifeng', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3079, 251, '通辽', 'Tongliao', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3080, 251, '鄂尔多斯', 'Ordos', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3081, 251, '呼伦贝尔', 'Hulun Buir', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3082, 251, '巴彦淖尔', 'Bayannur', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3083, 251, '乌兰察布', 'Ulan Qab', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3084, 251, '兴安', 'Xing''an', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3085, 251, '锡林郭勒', 'Xilin Gol', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3086, 251, '阿拉善', 'Alxa', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3087, 252, '沈阳', 'Shenyang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3088, 252, '大连', 'Dalian', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3089, 252, '鞍山', 'Anshan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3090, 252, '抚顺', 'Fushun', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3091, 252, '本溪', 'Benxi', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3092, 252, '丹东', 'Dandong', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3093, 252, '锦州', 'Jinzhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3094, 252, '营口', 'Yingkou', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3095, 252, '阜新', 'Fuxin', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3096, 252, '辽阳', 'Liaoyang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3097, 252, '盘锦', 'Panjin', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3098, 252, '铁岭', 'Tieling', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3099, 252, '朝阳', 'Chaoyang', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3100, 252, '葫芦岛', 'Huludao', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3101, 253, '长春', 'Changchun', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3102, 253, '吉林', 'Jilin', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3103, 253, '四平', 'Siping', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3104, 253, '辽源', 'Liaoyuan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3105, 253, '通化', 'Tonghua', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3106, 253, '白山', 'Baishan', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3107, 253, '松原', 'Songyuan', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3108, 253, '白城', 'Baicheng', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3109, 253, '延边', 'Yanbian Korean Autonomous Prefecture', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3110, 254, '哈尔滨', 'Harbin', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3111, 254, '齐齐哈尔', 'Qiqihar', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3112, 254, '鸡西', 'Jixi', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3113, 254, '鹤岗', 'Hegang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3114, 254, '双鸭山', 'Shuangyashan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3115, 254, '大庆', 'Daqing', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3116, 254, '伊春', 'Yichun', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3117, 254, '佳木斯', 'Jiamusi', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3118, 254, '七台河', 'Qitaihe', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3119, 254, '牡丹江', 'Mudanjiang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3120, 254, '黑河', 'Heihe', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3121, 254, '绥化', 'Suihua', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3122, 254, '大兴安岭', 'Da Hinggan Ling', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3123, 255, '黄浦', 'Huangpu', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3124, 255, '卢湾', 'Luwan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3125, 255, '徐汇', 'Xuhui', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3126, 255, '长宁', 'Changning', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3127, 255, '静安', 'Jing''an', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3128, 255, '普陀', 'Putuo', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3129, 255, '闸北', 'Zhabei', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3130, 255, '虹口', 'Hongkou', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3131, 255, '杨浦', 'Yangpu', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3132, 255, '闵行', 'Minhang', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3133, 255, '宝山', 'Baoshan', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3134, 255, '嘉定', 'Jiading', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3135, 255, '浦东新区', 'Pudong New Area', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3136, 255, '金山', 'Jinshan', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3137, 255, '松江', 'Songjiang', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3138, 255, '奉贤', 'Fengxian', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3139, 255, '青浦', 'Qingpu', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3140, 255, '崇明', 'Chongming', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3141, 256, '南京', 'Nanjing', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3142, 256, '无锡', 'Wuxi', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3143, 256, '徐州', 'Xuzhou', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3144, 256, '常州', 'Changzhou', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3145, 256, '苏州', 'Suzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3146, 256, '南通', 'Nantong', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3147, 256, '连云港', 'Lianyungang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3148, 256, '淮安', 'Huai''an', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3149, 256, '盐城', 'Yancheng', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3150, 256, '扬州', 'Yangzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3151, 256, '镇江', 'Zhenjiang', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3152, 256, '泰州', 'Taizhou', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3153, 256, '宿迁', 'Suqian', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3154, 257, '杭州', 'Hangzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3155, 257, '宁波', 'Ningbo', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3156, 257, '温州', 'Wenzhou', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3157, 257, '嘉兴', 'Jiaxing', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3158, 257, '湖州', 'Huzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3159, 257, '绍兴', 'Shaoxing', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3160, 257, '金华', 'Jinhua', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3161, 257, '衢州', 'Quzhou', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3162, 257, '舟山', 'Zhoushan', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3163, 257, '台州', 'Taizhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3164, 257, '丽水', 'Lishui', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3165, 258, '合肥', 'Hefei', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3166, 258, '芜湖', 'Wuhu', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3167, 258, '蚌埠', 'Bengbu', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3168, 258, '淮南', 'Huainan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3169, 258, '马鞍山', 'Ma''anshan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3170, 258, '淮北', 'Huaibei', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3171, 258, '铜陵', 'Tongling', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3172, 258, '安庆', 'Anqing', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3173, 258, '黄山', 'Huangshan', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3174, 258, '滁州', 'Chuzhou', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3175, 258, '阜阳', 'Fuyang', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3176, 258, '宿州', 'Suzhou', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3177, 258, '六安', 'Lu''an', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3178, 258, '亳州', 'Bozhou', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3179, 258, '池州', 'Chizhou', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3180, 258, '宣城', 'Xuancheng', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3181, 259, '福州', 'Fuzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3182, 259, '厦门', 'Xiamen', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3183, 259, '莆田', 'Putian', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3184, 259, '三明', 'Sanming', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3185, 259, '泉州', 'Quanzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3186, 259, '漳州', 'Zhangzhou', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3187, 259, '南平', 'Nanping', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3188, 259, '龙岩', 'Longyan', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3189, 259, '宁德', 'Ningde', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3190, 260, '南昌', 'Nanchang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3191, 260, '景德镇', 'Jingdezhen', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3192, 260, '萍乡', 'Pingxiang', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3193, 260, '九江', 'Jiujiang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3194, 260, '新余', 'Xinyu', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3195, 260, '鹰潭', 'Yingtan', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3196, 260, '赣州', 'Ganzhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3197, 260, '吉安', 'Ji''an', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3198, 260, '宜春', 'Yichun', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3199, 260, '抚州', 'Fuzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3200, 260, '上饶', 'Shangrao', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3201, 261, '济南', 'Jinan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3202, 261, '青岛', 'Qingdao', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3203, 261, '淄博', 'Zibo', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3204, 261, '枣庄', 'Zaozhuang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3205, 261, '东营', 'Dongying', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3206, 261, '烟台', 'Yantai', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3207, 261, '潍坊', 'Weifang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3208, 261, '济宁', 'Jining', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3209, 261, '泰安', 'Tai''an', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3210, 261, '威海', 'Weihai', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3211, 261, '日照', 'Rizhao', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3212, 261, '莱芜', 'Laiwu', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3213, 261, '临沂', 'Linyi', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3214, 261, '德州', 'Dezhou', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3215, 261, '聊城', 'Liaocheng', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3216, 261, '滨州', 'Binzhou', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3217, 261, '菏泽', 'Heze', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3218, 262, '郑州', 'Zhengzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3219, 262, '开封', 'Kaifeng', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3220, 262, '洛阳', 'Luoyang', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3221, 262, '平顶山', 'Pingdingshan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3222, 262, '安阳', 'Anyang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3223, 262, '鹤壁', 'Hebi', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3224, 262, '新乡', 'Xinxiang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3225, 262, '焦作', 'Jiaozuo', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3226, 262, '濮阳', 'Puyang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3227, 262, '许昌', 'Xuchang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3228, 262, '漯河', 'Luohe', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3229, 262, '三门峡', 'Sanmenxia', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3230, 262, '南阳', 'Nanyang', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3231, 262, '商丘', 'Shangqiu', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3232, 262, '信阳', 'Xinyang', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3233, 262, '周口', 'Zhoukou', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3234, 262, '驻马店', 'Zhumadian', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3235, 262, '济源', 'Jiyuan', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3236, 263, '武汉', 'Wuhan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3237, 263, '黄石', 'Huangshi', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3238, 263, '十堰', 'Shiyan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3239, 263, '宜昌', 'Yichang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3240, 263, '襄阳', 'Xiangyang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3241, 263, '鄂州', 'Ezhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3242, 263, '荆门', 'Jingmen', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3243, 263, '孝感', 'Xiaogan', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3244, 263, '荆州', 'Jingzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3245, 263, '黄冈', 'Huanggang', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3246, 263, '咸宁', 'Xianning', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3247, 263, '随州', 'Suizhou', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3248, 263, '恩施', 'Enshi Tujia-Miao Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3249, 263, '仙桃', 'Xiantao', '94', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3250, 263, '潜江', 'Qianjiang', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3251, 263, '天门', 'Tianmen', '96', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3252, 263, '神农架', 'Shennongjia', 'A21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3253, 264, '长沙', 'Changsha', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3254, 264, '株洲', 'Zhuzhou', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3255, 264, '湘潭', 'Xiangtan', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3256, 264, '衡阳', 'Hengyang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3257, 264, '邵阳', 'Shaoyang', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(3258, 264, '岳阳', 'Yueyang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3259, 264, '常德', 'Changde', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3260, 264, '张家界', 'Zhangjiajie', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3261, 264, '益阳', 'Yiyang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3262, 264, '郴州', 'Chenzhou', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3263, 264, '永州', 'Yongzhou', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3264, 264, '怀化', 'Huaihua', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3265, 264, '娄底', 'Loudi', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3266, 264, '湘西', 'Xiangxi Tujia-Miao Autonomous Prefecture', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3267, 265, '广州', 'Guangzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3268, 265, '韶关', 'Shaoguan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3269, 265, '深圳', 'Shenzhen', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3270, 265, '珠海', 'Zhuhai', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3271, 265, '汕头', 'Shantou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3272, 265, '佛山', 'Foshan', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3273, 265, '江门', 'Jiangmen', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3274, 265, '湛江', 'Zhanjiang', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3275, 265, '茂名', 'Maoming', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3276, 265, '肇庆', 'Zhaoqing', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3277, 265, '惠州', 'Huizhou', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3278, 265, '梅州', 'Meizhou', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3279, 265, '汕尾', 'Shanwei', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3280, 265, '河源', 'Heyuan', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3281, 265, '阳江', 'Yangjiang', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3282, 265, '清远', 'Qingyuan', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3283, 265, '东莞', 'Dongguan', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3284, 265, '中山', 'Zhongshan', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3285, 265, '潮州', 'Chaozhou', '51', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3286, 265, '揭阳', 'Jieyang', '52', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3287, 265, '云浮', 'Yunfu', '53', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3288, 266, '南宁', 'Nanning', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3289, 266, '柳州', 'Liuzhou', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3290, 266, '桂林', 'Guilin', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3291, 266, '梧州', 'Wuzhou', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3292, 266, '北海', 'Beihai', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3293, 266, '防城港', 'Fangchenggang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3294, 266, '钦州', 'Qinzhou', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3295, 266, '贵港', 'Guigang', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3296, 266, '玉林', 'Yulin', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3297, 266, '百色', 'Baise', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3298, 266, '贺州', 'Hezhou', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3299, 266, '河池', 'Hechi', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3300, 266, '来宾', 'Laibin', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3301, 266, '崇左', 'Chongzuo', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3302, 267, '海口', 'Haikou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3303, 267, '三亚', 'Sanya', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3304, 267, '三沙', 'Shansha', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3305, 267, '五指山', 'Wuzhishan', '91', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3306, 267, '琼海', 'Qionghai', '92', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3307, 267, '儋州', 'Danzhou', '93', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3308, 267, '文昌', 'Wenchang', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3309, 267, '万宁', 'Wanning', '96', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3310, 267, '东方', 'Dongfang', '97', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3311, 267, '定安', 'Ding''an', 'A25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3312, 267, '屯昌', 'Tunchang', 'A26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3313, 267, '澄迈', 'Cengmai', 'A27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3314, 267, '临高', 'Lingao', 'A28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3315, 267, '白沙', 'Baisha Li Autonomous County', 'A30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3316, 267, '昌江', 'Jiang Li Autonomous County', 'A31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3317, 267, '乐东', 'Ledong Li Autonomous County', 'A33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3318, 267, '陵水', 'Lingshui Li Autonomous County', 'A34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3319, 267, '保亭', 'Baoting Li-Miao Autonomous County', 'A35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3320, 267, '琼中', 'Qiongzhong Li-Miao Autonomous County', 'A36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3321, 268, '万州', 'Wanzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3322, 268, '涪陵', 'Fuling', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3323, 268, '渝中', 'Yuzhong', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3324, 268, '大渡口', 'Dadukou', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3325, 268, '江北', 'Jiangbei', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3326, 268, '沙坪坝', 'Shapingba', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3327, 268, '九龙坡', 'Jiulongpo', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3328, 268, '南岸', 'Nan''an', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3329, 268, '北碚', 'Beibei', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3330, 268, '两江新区', 'Kaixian', '85', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3331, 268, '万盛', 'Wansheng', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3332, 268, '双桥', 'Shuangqiao', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3333, 268, '渝北', 'Yubei', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3334, 268, '巴南', 'Ba''nan', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3335, 268, '长寿', 'Changshou', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3336, 268, '綦江', 'Qijiang', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3337, 268, '潼南', 'Tongnan', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3338, 268, '铜梁', 'Tongliang', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3339, 268, '大足', 'Dazu', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3340, 268, '荣昌', 'Rongchang', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3341, 268, '璧山', 'Bishan', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3342, 268, '梁平', 'Liangping', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3343, 268, '城口', 'Chengkou', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3344, 268, '丰都', 'Fengdu', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3345, 268, '垫江', 'Dianjiang', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3346, 268, '武隆', 'Wulong', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3347, 268, '忠县', 'Zhongxian', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3348, 268, '开县', 'Kaixian', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3349, 268, '云阳', 'Yunyang', '35', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3350, 268, '奉节', 'Fengjie', '36', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3351, 268, '巫山', 'Wushan', '37', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3352, 268, '巫溪', 'Wuxi', '38', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3353, 268, '黔江', 'Qianjiang', '39', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3354, 268, '石柱', 'Shizhu Tujia Autonomous Country', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3355, 268, '秀山', 'Xiushan Tujia-Miao Autonomous Country', '41', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3356, 268, '酉阳', 'Youyang Tujia-Miao Autonomous Country', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3357, 268, '彭水', 'Pengshui Miao-Tujia Autonomous Country', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3358, 268, '江津', 'Jiangjin', '81', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3359, 268, '合川', 'Hechuan', '82', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3360, 268, '永川', 'Yongchuan', '83', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3361, 268, '南川', 'Liangjiangxinqu', '84', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3362, 269, '成都', 'Chengdu', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3363, 269, '自贡', 'Zigong', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3364, 269, '攀枝花', 'Panzhihua', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3365, 269, '泸州', 'Luzhou', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3366, 269, '德阳', 'Deyang', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3367, 269, '绵阳', 'Mianyang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3368, 269, '广元', 'Guangyuan', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3369, 269, '遂宁', 'Suining', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3370, 269, '内江', 'Neijiang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3371, 269, '乐山', 'Leshan', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3372, 269, '南充', 'Nanchong', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3373, 269, '眉山', 'Meishan', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3374, 269, '宜宾', 'Yibin', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3375, 269, '广安', 'Guang''an', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3376, 269, '达州', 'Dazhou', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3377, 269, '雅安', 'Ya''an', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3378, 269, '巴中', 'Bazhong', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3379, 269, '资阳', 'Ziyang', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3380, 269, '阿坝', 'Aba Tibetan-Qiang Autonomous Prefecture', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3381, 269, '甘孜', 'Garze Tibetan Autonomous Prefecture', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3382, 269, '凉山', 'Liangshan Yi Autonomous Prefecture', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3383, 270, '贵阳', 'Guiyang', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3384, 270, '六盘水', 'Liupanshui', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3385, 270, '遵义', 'Zunyi', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3386, 270, '安顺', 'Anshun', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3387, 270, '铜仁', 'Tongren', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3388, 270, '黔西南', 'Qianxinan Buyi-Miao Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3389, 270, '毕节', 'Bijie', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3390, 270, '黔东南', 'Qiandongnan Miao-Dong Autonomous Prefecture', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3391, 270, '黔南', 'Qiannan Buyi Autonomous Prefecture', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3392, 271, '昆明', 'Kunming', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3393, 271, '曲靖', 'Qujing', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3394, 271, '玉溪', 'Yuxi', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3395, 271, '保山', 'Baoshan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3396, 271, '昭通', 'Zhaotong', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3397, 271, '丽江', 'Lijiang', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3398, 271, '普洱', 'Pu''er', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3399, 271, '临沧', 'Lincang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3400, 271, '楚雄', 'Chuxiong Yi Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3401, 271, '红河', 'Honghe Hani-Yi Autonomous Prefecture', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3402, 271, '文山', 'Wenshan Zhuang-Miao Autonomous Prefecture', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3403, 271, '西双版纳', 'Xishuangbanna Dai Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3404, 271, '大理', 'Dali Bai Autonomous Prefecture', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3405, 271, '德宏', 'Dehong Dai-Jingpo Autonomous Prefecture', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3406, 271, '怒江', 'Nujiang Lisu Autonomous Prefecture', '33', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3407, 271, '迪庆', 'Diqing Tibetan Autonomous Prefecture', '34', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3408, 272, '拉萨', 'Lhasa', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3409, 272, '昌都', 'Qamdo', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3410, 272, '山南', 'Shannan', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3411, 272, '日喀则', 'Xigaze', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3412, 272, '那曲', 'Nagqu', '24', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3413, 272, '阿里', 'Ngari', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3414, 272, '林芝', 'Nyingchi', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3415, 273, '西安', 'Xi''an', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3416, 273, '铜川', 'Tongchuan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3417, 273, '宝鸡', 'Baoji', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3418, 273, '咸阳', 'Xianyang', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3419, 273, '渭南', 'Weinan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3420, 273, '延安', 'Yan''an', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3421, 273, '汉中', 'Hanzhong', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3422, 273, '榆林', 'Yulin', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3423, 273, '安康', 'Ankang', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3424, 273, '商洛', 'Shangluo', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3425, 274, '兰州市', 'Lanzhou', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3426, 274, '嘉峪关', 'Jinchang', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3427, 274, '金昌', 'Baiyin', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3428, 274, '白银', 'Tianshui', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3429, 274, '天水', 'Jiayuguan', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3430, 274, '武威', 'Wuwei', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3431, 274, '张掖', 'Zhangye', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3432, 274, '平凉', 'Pingliang', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3433, 274, '酒泉', 'Jiuquan', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3434, 274, '庆阳', 'Qingyang', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3435, 274, '定西', 'Dingxi', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3436, 274, '陇南', 'Longnan', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3437, 274, '临夏', 'Linxia Hui Autonomous Prefecture', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3438, 274, '甘南', 'Gannan Tibetan Autonomous Prefecture', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3439, 275, '西宁', 'Xining', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3440, 275, '海东', 'Haidong', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3441, 275, '海北', 'Haibei Tibetan Autonomous Prefecture', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3442, 275, '黄南', 'Huangnan Tibetan Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3443, 275, '海南', 'Hainan Tibetan Autonomous Prefecture', '25', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3444, 275, '果洛', 'Guoluo Tibetan Autonomous Prefecture', '26', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3445, 275, '玉树', 'Yushu Tibetan Autonomous Prefecture', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3446, 275, '海西', 'Haixi Mongol-Tibetan Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3447, 276, '银川', 'Yinchuan', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3448, 276, '石嘴山', 'Shizuishan', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3449, 276, '吴忠', 'Wuzhong', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3450, 276, '固原', 'Guyuan', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3451, 276, '中卫', 'Zhongwei', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3452, 277, '乌鲁木齐', 'Urumqi', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3453, 277, '克拉玛依', 'Karamay', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3454, 277, '吐鲁番', 'Turpan', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3455, 277, '哈密', 'Hami', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3456, 277, '昌吉', 'Changji Hui Autonomous Prefecture', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3457, 277, '博尔塔拉', 'Bortala Mongol Autonomous Prefecture', '27', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3458, 277, '巴音郭楞', 'Bayingolin Mongol Autonomous Prefecture', '28', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3459, 277, '阿克苏', 'Aksu', '29', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3460, 277, '克孜勒苏', 'Kizilsu Kirgiz Autonomous Prefecture', '30', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3461, 277, '喀什', 'Kashi', '31', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3462, 277, '和田', 'Hotan', '32', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3463, 277, '伊犁', 'Ili Kazakh Autonomous Prefecture', '40', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3464, 277, '塔城', 'Tacheng', '42', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3465, 277, '阿勒泰', 'Altay', '43', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3466, 277, '石河子', 'Shihezi', '91', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3467, 277, '阿拉尔', 'Alar', '92', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3468, 277, '图木舒克', 'Tumsuk', '93', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3469, 277, '五家渠', 'Wujiaqu', '94', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3470, 277, '北屯', 'Beitun', '95', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3471, 278, '台北市', 'Taipei City', '1', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3472, 278, '高雄市', 'Kaohsiung City', '2', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3473, 278, '基隆市', 'Keelung City', '3', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3474, 278, '台中市', 'Taichung City', '4', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3475, 278, '台南市', 'Tainan City', '5', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3476, 278, '新竹市', 'Hsinchu City', '6', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3477, 278, '嘉义市', 'Chiayi City', '7', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3478, 278, '台北县', 'Taipei County', '8', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3479, 278, '宜兰县', 'Ilan County', '9', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3480, 278, '桃园县', 'Taoyuan County', '10', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3481, 278, '新竹县', 'Hsinchu County', '11', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3482, 278, '苗栗县', 'Miaoli County', '12', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3483, 278, '台中县', 'Taichung County', '13', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3484, 278, '彰化县', 'Changhwa County', '14', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3485, 278, '南投县', 'Nantou County', '15', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3486, 278, '云林县', 'Yunnlin County', '16', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3487, 278, '嘉义县', 'Chiayi County', '17', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3488, 278, '台南县', 'Tainan County', '18', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3489, 278, '高雄县', 'Kaohsiung County', '19', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3490, 278, '屏东县', 'Pingtung County', '20', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3491, 278, '台东县', 'Taitung County', '22', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3492, 278, '花莲县', 'Hualian County', '23', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3493, 278, '澎湖县', 'Penghu County', '21', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3494, 279, '中西区', 'NaN', 'HCW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3495, 279, '东区', 'NaN', 'HEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3496, 279, '九龙城区', 'NaN', 'KKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3497, 279, '观塘区', 'NaN', 'KKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3498, 279, '南区', 'NaN', 'HSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3499, 279, '深水埗区', 'NaN', 'KSS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3500, 279, '黄大仙区', 'NaN', 'KWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3501, 279, '湾仔区', 'NaN', 'HWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3502, 279, '油尖旺区', 'NaN', 'KYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3503, 279, '离岛区', 'NaN', 'NIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3504, 279, '葵青区', 'NaN', 'NKT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3505, 279, '北区', 'NaN', 'NNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3506, 279, '西贡区', 'NaN', 'NSK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3507, 279, '沙田区', 'NaN', 'NST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3508, 279, '屯门区', 'NaN', 'NTM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3509, 279, '大埔区', 'NaN', 'NTP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3510, 279, '荃湾区', 'NaN', 'NTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3511, 279, '元朗区', 'NaN', 'NYL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3512, 280, '花地玛堂区', 'NaN', 'OLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3513, 280, '圣安多尼堂区', 'NaN', 'ANT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3514, 280, '大堂区', 'NaN', 'CAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3515, 280, '望德堂区', 'NaN', 'LAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3516, 280, '风顺堂区', 'NaN', 'LAZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3517, 280, '氹仔', 'NaN', 'TPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3518, 280, '路环', 'NaN', 'CLN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3519, 281, '北帕默斯顿', 'Palmerston', 'PAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3520, 281, '达尔文', 'Darwin', 'DRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3521, 282, '堪培拉', 'Canberra', 'CBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3522, 283, '布里斯班', 'Brisbane', 'BNE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3523, 283, '黄金海岸', 'Gold Coast', 'OOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3524, 283, '凯恩斯', 'Cairns', 'CNS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3525, 283, '日光海岸', 'Caloundra', 'CUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3526, 283, '汤斯维尔', 'Townsville', 'TSV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3527, 283, '图文巴', 'Toowoomba', 'TWB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3528, 284, '阿德莱德', 'Adelaide', 'ADL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3529, 284, '奥古斯塔港', 'Port Augusta', 'PUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3530, 284, '甘比亚山', 'Mount Gambier', 'MGB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3531, 284, '怀阿拉', 'Whyalla', 'WAY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3532, 284, '林肯港', 'Port Lincoln', 'PLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3533, 284, '默里布里奇', 'Murray Bridge', 'MYB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3534, 284, '皮里港', 'Port Pirie', 'PPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3535, 284, '维克托港', 'Victor Harbor', 'VHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3536, 285, '伯尼港', 'Burnie', 'BWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3537, 285, '德文波特', 'Devonport', 'DPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3538, 285, '霍巴特', 'Hobart', 'HBA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3539, 285, '朗塞斯顿', 'Launceston', 'LST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3540, 286, '吉朗', 'Geelong', 'GEX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3541, 286, '墨尔本', 'Melbourne', 'MEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3542, 287, '奥尔巴尼', 'Albany', 'ALH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3543, 287, '班伯里', 'Bunbury', 'BUY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3544, 287, '弗里曼特尔港', 'Fremantle', 'FRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3545, 287, '杰拉尔顿', 'Geraldton', 'GET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3546, 287, '卡尔古利', 'Kalgoorlie', 'KGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3547, 287, '曼哲拉', 'Mandurah', 'MDU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3548, 287, '珀斯', 'Perth', 'PER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3549, 288, '纽卡斯尔', 'Newcastle', 'NTL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3550, 288, '伍伦贡', 'Wollongong', 'WOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3551, 288, '悉尼', 'Sydney', 'HBS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3552, 289, '达城郡', 'Dalseong-gun', 'DSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3553, 289, '大邱', 'Daegu', 'TAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3554, 289, '寿城区', 'Suseong-gu', 'SUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3555, 294, '春川市', 'Chuncheon', 'CHC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3556, 294, '东海市', 'Donghae', 'TGH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3557, 294, '高城郡', 'Goseong County', 'GSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3558, 294, '横城郡', 'Hoengseong County', 'HSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3559, 294, '洪川郡', 'Hongcheon County', 'HCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3560, 294, '华川郡', 'Hwacheon County', 'HCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3561, 294, '江陵市', 'Gangneung', 'KAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3562, 294, '旌善郡', 'Jeongseon County', 'JSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3563, 294, '麟蹄郡', 'Inje County', 'IJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3564, 294, '宁越郡', 'Yeongwol County', 'YWL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3565, 294, '平昌郡', 'Pyeongchang County', 'POG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3566, 294, '三陟市', 'Samcheok', 'SUK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3567, 294, '束草市', 'Sokcho', 'SHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3568, 294, '太白市', 'Taebaek', 'TBK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3569, 294, '铁原郡', 'Cheorwon County', 'CWN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3570, 294, '襄阳郡', 'Yangyang County', 'YNY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3571, 294, '杨口郡', 'Yanggu County', 'YGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3572, 294, '原州市', 'Wonju', 'WJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3573, 295, '安城市', 'Anseong', 'ASG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3574, 295, '安山市', 'Ansan', 'ASN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3575, 295, '安养市', 'Anyang', 'ANY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3576, 295, '抱川市', 'Pocheon', 'POC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3577, 295, '城南市', 'Seongnam', 'SEO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3578, 295, '东豆川市', 'Dongducheon', 'DDC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3579, 295, '富川市', 'Bucheon', 'BCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3580, 295, '高阳市', 'Goyang', 'GYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3581, 295, '光明市', 'Gwangmyeong', 'GMG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3582, 295, '广州市', 'Gwangju', 'KWU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3583, 295, '果川市', 'Gwacheon', 'GCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3584, 295, '河南市', 'Hanam', 'HNM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3585, 295, '华城市', 'Hwaseong', 'HCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3586, 295, '加平郡', 'Gapyeong County', 'GPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3587, 295, '金浦市', 'Gimpo', 'GMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3588, 295, '九里市', 'Guri', 'GRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3589, 295, '军浦市', 'Gunpo', 'GUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3590, 295, '骊州郡', 'Yeoju County', 'YJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3591, 295, '利川市', 'Icheon', 'ICE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3592, 295, '涟川郡', 'Yeoncheon County', 'YCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3593, 295, '龙仁市', 'Yongin', 'YNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3594, 295, '南杨州市', 'Namyangju', 'NYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3595, 295, '平泽市', 'Pyeongtaek', 'PTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3596, 295, '坡州市', 'Paju', 'PJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3597, 295, '始兴市', 'Siheung', 'SHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3598, 295, '水原市', 'Suwon', 'SUO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3599, 295, '乌山市', 'Osan', 'OSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3600, 295, '扬平郡', 'Yangpyeong County', 'YPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3601, 295, '杨州市', 'Yangju', 'YYU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3602, 295, '仪旺市', 'Uiwang', 'UWN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3603, 295, '议政府市', 'Uijeongbu', 'UIJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3604, 296, '安东市', 'Andong', 'ADG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3605, 296, '奉化郡', 'Bonghwa County', 'BHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3606, 296, '高灵郡', 'Goryeong County', 'GRG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3607, 296, '龟尾市', 'Gumi', 'KUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3608, 296, '金泉市', 'Gimcheon', 'KMC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3609, 296, '军威郡', 'Gunwi County', 'GWI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3610, 296, '醴泉郡', 'Yecheon County', 'YEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3611, 296, '浦项市', 'Pohang', 'KPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3612, 296, '漆谷郡', 'Chilgok County', 'CGK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3613, 296, '淸道郡', 'Cheongdo County', 'CDO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3614, 296, '靑松郡', 'Cheongsong County', 'CSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3615, 296, '庆山市', 'Gyeongsan', 'GYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3616, 296, '庆州市', 'Gyeongju', 'GJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3617, 296, '荣州市', 'Yeongju', 'YEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3618, 296, '尙州市', 'Sangju', 'SJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3619, 296, '蔚珍郡', 'Uljin County', 'UJN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3620, 296, '闻庆市', 'Mungyeong', 'MGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3621, 296, '星州郡', 'Seongju County', 'SEJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3622, 296, '义城郡', 'Uiseong County', 'USG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3623, 296, '英阳郡', 'Yeongyang County', 'YYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3624, 296, '盈德郡', 'Yeongdeok County', 'YDK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3625, 296, '永川市', 'Yeongcheon', 'YCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3626, 296, '郁陵郡', 'Ulleung County', 'ULG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3627, 297, '昌宁郡', 'Changnyeong County', 'CNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3628, 297, '昌原市', 'Changwon', 'CHW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3629, 297, '固城郡', 'Goseong County', 'GSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3630, 297, '河东郡', 'Hadong County', 'HDG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3631, 297, '金海市', 'Gimhae', 'KMH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3632, 297, '晋州市', 'Jinju', 'HIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3633, 297, '居昌郡', 'Geochang County', 'GCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3634, 297, '巨济市', 'Geoje', 'KJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3635, 297, '梁山市', 'Yangsan', 'YSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3636, 297, '马山市', 'Masan', 'MAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3637, 297, '密阳市', 'Miryang', 'MIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3638, 297, '南海郡', 'Namhae County', 'NHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3639, 297, '山淸郡', 'Sancheong County', 'SCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3640, 297, '泗川市', 'Sacheon', 'SAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3641, 297, '统营市', 'Tongyeong', 'TYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3642, 297, '陜川郡', 'Hapcheon County', 'HCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3643, 297, '咸安郡', 'Haman County', 'HAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3644, 297, '咸阳郡', 'Hamyang County', 'HYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3645, 297, '宜宁郡', 'Uiryeong County', 'URG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3646, 297, '鎭海市', 'Jinhae', 'CHF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3647, 298, '淳昌郡', 'Sunchang County', 'SCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3648, 298, '扶安郡', 'Buan County', 'PUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3649, 298, '高敞郡', 'Gochang County', 'GCG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3650, 298, '金堤市', 'Gimje', 'GJE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3651, 298, '井邑市', 'Jeongeup', 'JEO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3652, 298, '茂朱郡', 'Muju County', 'MJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3653, 298, '南原市', 'Namwon', 'NWN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3654, 298, '全州市', 'Jeonju', 'JNJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3655, 298, '群山市', 'Gunsan', 'KUV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3656, 298, '任实郡', 'Imsil County', 'ISL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3657, 298, '完州郡', 'Wanju County', 'WAJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3658, 298, '益山市', 'Iksan', 'IKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3659, 298, '长水郡', 'Jangsu County', 'JSU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3660, 298, '鎭安郡', 'Jinan County', 'JAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3661, 299, '宝城郡', 'Boseong County', 'BSG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3662, 299, '高兴郡', 'Goheung County', 'GHG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3663, 299, '谷城郡', 'Gokseong County', 'GSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3664, 299, '莞岛郡', 'Wando County', 'WND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3665, 299, '光阳市', 'Gwangyang', 'KAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3666, 299, '海南郡', 'Haenam County', 'HAE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3667, 299, '和顺郡', 'Hwasun County', 'HSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3668, 299, '康津郡', 'Gangjin County', 'GJN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3669, 299, '丽水市', 'Yeosu', 'YOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3670, 299, '灵光郡', 'Yeonggwang County', 'YGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3671, 299, '灵岩郡', 'Yeongam County', 'YAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3672, 299, '罗州市', 'Naju', 'NJU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3673, 299, '木浦市', 'Mokpo', 'MOK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3674, 299, '求礼郡', 'Gurye County', 'GRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3675, 299, '顺天市', 'Suncheon', 'SYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3676, 299, '潭阳郡', 'Damyang County', 'DYA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3677, 299, '务安郡', 'Muan County', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3678, 299, '咸平郡', 'Hampyeong County', 'HPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3679, 299, '新安郡', 'Sinan County', 'SAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3680, 299, '长城郡', 'Jangseong County', 'JSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3681, 299, '长兴郡', 'Jangheung County', 'JHG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3682, 299, '珍岛郡', 'Jindo County', 'JDO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3683, 303, '报恩郡', 'Boeun County', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3684, 303, '曾坪郡', 'Jeungpyeong County', 'JYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3685, 303, '丹阳郡', 'Danyang County', 'DYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3686, 303, '堤川市', 'Jecheon', 'JCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3687, 303, '槐山郡', 'Goesan County', 'GSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3688, 303, '淸原郡', 'Cheongwon County', 'CWO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3689, 303, '淸州市', 'Cheongju', 'CJJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3690, 303, '沃川郡', 'Okcheon County', 'OCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3691, 303, '阴城郡', 'Eumseong County', 'ESG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3692, 303, '永同郡', 'Yeongdong County', 'YDG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3693, 303, '鎭川郡', 'Jincheon County', 'JCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3694, 303, '忠州市', 'Chungju', 'CHU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3695, 304, '保宁市', 'Boryeong', 'BOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3696, 304, '扶余郡', 'Buyeo County', 'BYO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3697, 304, '公州市', 'Gongju', 'GOJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3698, 304, '洪城郡', 'Hongseong County', 'HSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3699, 304, '鸡龙市', 'Gyeryong', 'GYE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3700, 304, '锦山郡', 'Geumsan County', 'GSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3701, 304, '礼山郡', 'Yesan County', 'YOS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3702, 304, '论山市', 'Nonsan', 'NSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3703, 304, '青阳郡', 'Cheongyang County', 'CYG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3704, 304, '瑞山市', 'Seosan', 'SSA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3705, 304, '舒川郡', 'Seocheon County', 'SCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3706, 304, '泰安郡', 'Taean County', 'TAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3707, 304, '唐津郡', 'Dangjin County', 'TJI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3708, 304, '天安市', 'Cheonan', 'CHO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3709, 304, '牙山市', 'Asan', 'ASA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3710, 304, '燕岐郡', 'Yeongi County', 'YGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3711, 305, '北海', 'Butterworth', 'BWH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3712, 305, '槟城', 'George Town', 'PEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3713, 305, '大山脚', 'Bukit Mertajam', 'BMJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3714, 305, '高渊', 'Nibong Tebal', 'NTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3715, 306, '加央', 'Kangar', 'KGR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3716, 307, '甘马挽', 'Kemaman', 'KEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3717, 307, '瓜拉丁加奴', 'Kuala Terengganu', 'TGG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3718, 307, '龙运', 'Dungun', 'DGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3719, 307, '马江', 'Marang', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3720, 307, '实兆', 'Setiu', 'SET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3721, 307, '乌鲁', 'Hulu', 'HUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3722, 307, '勿述', 'Besut', 'BES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3723, 308, '巴东得腊', 'Padang Terap', 'PGT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3724, 308, '笨筒', 'Pendang', 'PEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3725, 308, '浮罗交怡', 'Langkawi', 'LGK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3726, 308, '哥打士打', 'Kota Setar', 'KOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3727, 308, '古邦巴素', 'Kubang Pasu', 'KPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3728, 308, '瓜拉姆达', 'Kuala Muda', 'KMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3729, 308, '华玲', 'Baling', 'BLZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3730, 308, '居林', 'Kulim', 'KLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3731, 308, '万拉峇鲁', 'Bandar Baharu', 'BMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3732, 309, '巴西富地', 'Pasir Putih', 'PPU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3733, 309, '巴西马', 'Pasir Mas', 'PMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3734, 309, '丹那美拉', 'Tanah Merah', 'TMR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3735, 309, '道北', 'Tumpat', 'TUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3736, 309, '登卓', 'Bachok', 'BAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3737, 309, '哥打巴鲁', 'Kota Bharu', 'KBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3738, 309, '瓜拉吉赖', 'Kuala Krai', 'KUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3739, 309, '话望生', 'Gua Musang', 'GMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3740, 309, '马樟', 'Machang', 'MAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3741, 309, '日里', 'Jeli', 'JEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3742, 310, '吉隆坡', 'Kuala Lumpur', 'KUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3743, 311, '马六甲市', 'Melaka', 'MEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3744, 311, '亚罗牙也', 'Alor Gajah', 'AOG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3745, 311, '野新', 'Jasin', 'JAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3746, 312, '纳闽', 'Labuan', 'LBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3747, 312, '维多利亚', 'Victoria', 'VIC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3748, 313, '百乐', 'Bera', 'BER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3749, 313, '北根', 'Pekan', 'PEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3750, 313, '淡马鲁', 'Temerloh', 'TEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3751, 313, '而连突', 'Jerantut', 'JER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3752, 313, '关丹', 'Kuantan', 'KUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3753, 313, '金马仑高原', 'Cameron Highlands', 'CAH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3754, 313, '劳勿', 'Raub', 'RAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3755, 313, '立卑', 'Kuala Lipis', 'KUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3756, 313, '马兰', 'Maran', 'MAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3757, 313, '文冬', 'Bentong', 'BEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3758, 313, '云冰', 'Rompin', 'TOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3759, 314, '安顺', 'Teluk Intan', 'TAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3760, 314, '丹绒马', 'Tanjung Malim', 'TAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3761, 314, '和丰', 'Sungai Siput', 'SSP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3762, 314, '紅土坎', 'Lumut', 'LUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3763, 314, '华都牙也', 'Batu Gajah', 'BGA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3764, 314, '江沙', 'Kuala Kangsar', 'KAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3765, 314, '太平', 'Taiping', 'TPG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3766, 314, '怡保', 'Ipoh', 'IPH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3767, 315, '笨珍', 'Pontian', 'POW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3768, 315, '丰盛港', 'Mersing', 'MEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3769, 315, '哥打丁宜', 'Kota Tinggi', 'KTI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3770, 315, '居銮', 'Kluang', 'KLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3771, 315, '峇株巴辖', 'Batu Pahat', 'BAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3772, 315, '麻坡', 'Muar', 'MUA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3773, 315, '昔加末', 'Segamat', 'SGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3774, 315, '新山', 'Johor Bahru', 'JHB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3775, 316, '波德申', 'Port Dickson', 'PDI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3776, 316, '淡边', 'Tampin', 'TAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3777, 316, '芙蓉', 'Seremban', 'SRB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3778, 316, '瓜拉庇劳', 'Kuala Pilah', 'KPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3779, 316, '林茂', 'Rembau', 'REM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3780, 316, '仁保', 'Jempol', 'JEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3781, 316, '日叻务', 'Jelebu', 'JEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3782, 317, '吧巴', 'Papar', 'PAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3783, 317, '保佛', 'Beaufort', 'BEF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3784, 317, '比鲁兰', 'Beluran', 'BEL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3785, 317, '必达士', 'Pitas', 'PIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3786, 317, '兵南邦', 'Penampang', 'PMP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3787, 317, '担布南', 'Tambunan', 'TAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3788, 317, '丹南', 'Tenom', 'TEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3789, 317, '斗湖', 'Tawau', 'TAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3790, 317, '斗亚兰', 'Tuaran', 'TUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3791, 317, '哥打基纳巴鲁', 'Kota Kinabalu', 'BKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3792, 317, '哥打马鲁都', 'Kota Marudu', 'KMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3793, 317, '根地咬', 'Keningau', 'KEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3794, 317, '古达', 'Kudat', 'KUD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3795, 317, '古打毛律', 'Kota Belud', 'KBD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3796, 317, '古纳', 'Kunak', 'KUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3797, 317, '瓜拉班尤', 'Kuala Penyu', 'KPU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3798, 317, '京那巴登岸', 'Kinabatangan', 'KBT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);
INSERT INTO `qinggan_world_location` (`id`, `pid`, `name`, `name_en`, `code`, `code2`, `status`, `excise_rate`, `tariff_rate`, `lang_code`, `site_id`, `tpl_id`, `taxis`, `currency_id`, `freight_id`) VALUES
(3799, 317, '兰脑', 'Ranau', 'RNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3800, 317, '拿笃', 'Lahad Datu', 'LDU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3801, 317, '纳巴湾', 'Nabawan', 'NAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3802, 317, '山打根', 'Sandakan', 'SDK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3803, 317, '西比陶', 'Sipitang', 'SPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3804, 317, '仙本那', 'Semporna', 'SMM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3805, 318, '古晋', 'Kuching', 'KCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3806, 318, '加帛', 'Kapit', 'KPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3807, 318, '林梦', 'Limbang', 'LMN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3808, 318, '美里', 'Miri', 'MYY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3809, 318, '民都鲁', 'Bintulu', 'BTU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3810, 318, '木胶', 'Mukah', 'MKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3811, 318, '木中', 'Betong', 'BTG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3812, 318, '三马拉汉', 'Samarahan', 'SMH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3813, 318, '斯里阿曼', 'Sri Aman', 'SAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3814, 318, '泗里街', 'Sarikei', 'SAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3815, 318, '泗务', 'Sibu', 'SBW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3816, 319, '八打灵', 'Petaling', 'PJA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3817, 319, '鹅麦', 'Gombak', 'GOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3818, 319, '瓜拉冷岳', 'Kuala Langat', 'KLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3819, 319, '瓜拉雪兰莪', 'Kuala Selangor', 'KSL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3820, 319, '沙白安南', 'Sabak Bernam', 'SBM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3821, 319, '乌鲁冷岳', 'Hulu Langat', 'HUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3822, 319, '乌鲁雪兰莪', 'Hulu Selangor', 'HUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3823, 319, '雪邦', 'Sepang', 'SEP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3824, 320, '费耶特维尔', 'Fayetteville', 'FYV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3825, 320, '史密斯堡', 'Fort Smith', 'FSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3826, 320, '小石城', 'Little Rock', 'LIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3827, 321, '伯明罕', 'Birmingham', 'BHM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3828, 321, '蒙哥马利', 'Montgomery', 'MGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3829, 321, '莫比尔', 'Mobile', 'MOB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3830, 322, '安克雷奇', 'Anchorage', 'ANC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3831, 322, '费尔班克斯', 'Fairbanks', 'FAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3832, 322, '朱诺', 'Juneau', 'JNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3833, 323, '爱达荷福尔斯', 'Idaho Falls', 'IDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3834, 323, '波卡特洛', 'Pocatello', 'PIH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3835, 323, '博伊西', 'Boise', 'BOI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3836, 323, '布莱克富特', 'Blackfoot', 'BLK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3837, 323, '科达伦', 'Coeur d''Alene', 'COE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3838, 323, '刘易斯顿', 'Lewiston', 'LWS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3839, 323, '莫斯科', 'Moscow', 'MJL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3840, 323, '墨菲', 'Murphy', 'ZMU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3841, 323, '楠帕', 'Nampa', 'NPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3842, 323, '岂彻姆', 'Ketchum', 'QKM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3843, 323, '森瓦利', 'Sun Valley', 'SVY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3844, 323, '亚美利加瀑布城', 'American Falls', 'YAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3845, 324, '达文波特', 'Davenport', 'DVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3846, 324, '得梅因', 'Des Moines', 'DSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3847, 324, '锡达拉皮兹', 'Cedar Rapids', 'CID', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3848, 325, '俾斯麦', 'Bismarck', 'BIS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3849, 325, '大福克斯', 'Grand Forks', 'GFK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3850, 325, '法戈', 'Fargo', 'FAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3851, 325, '迈诺特', 'Minot', 'MOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3852, 326, '艾许维尔', 'Asheville', 'AEV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3853, 326, '杜罕', 'Durham', 'DHH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3854, 326, '格林斯伯勒', 'Greensboro', 'GBO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3855, 326, '教堂山', 'Chapel Hill', 'CHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3856, 326, '罗利', 'Raleigh', 'RAG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3857, 326, '洛利杜罕都会区', 'Raleigh-Durham', 'RDU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3858, 326, '夏洛特', 'Charlotte', 'CRQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3859, 327, '阿伦敦', 'Allentown', 'AEW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3860, 327, '费城', 'Philadephia', 'PHL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3861, 327, '匹兹堡', 'Pittsburgh', 'PIT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3862, 328, '埃尔帕索', 'El Paso', 'ELP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3863, 328, '奥斯汀', 'Austin', 'AUS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3864, 328, '达拉斯', 'Dallas', 'DAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3865, 328, '哥帕斯基斯蒂', 'Corpus Christi', 'CRP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3866, 328, '交维斯顿', 'Galveston', 'GLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3867, 328, '拉雷多', 'Laredo', 'LRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3868, 328, '麦亚伦', 'McAllen', 'TXC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3869, 328, '圣安东尼奥', 'San Antonio', 'SAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3870, 328, '休斯敦', 'Houston', 'HOU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3871, 329, '代顿', 'Dayton', 'DYT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3872, 329, '哥伦布', 'Columbus', 'CZX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3873, 329, '克利夫兰', 'Cleveland', 'CLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3874, 329, '托莱多', 'Toledo', 'TOL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3875, 329, '辛辛那提', 'Cincinnati', 'CVG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3876, 330, '俄克拉荷马城', 'Oklahoma City', 'OKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3877, 330, '诺曼', 'Norman', 'OUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3878, 330, '塔尔萨', 'Tulsa', 'TUL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3879, 331, '本德', 'Bend', 'BZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3880, 331, '波特兰', 'Portland', 'PDX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3881, 331, '达尔斯', 'The Dalles', 'DLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3882, 331, '达拉斯', 'Dallas', 'DAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3883, 331, '蒂拉穆克', 'Tillamook', 'TLM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3884, 331, '格兰茨帕斯', 'Grant''s Pass', 'XFX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3885, 331, '胡德里弗', 'Hood River', 'HDX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3886, 331, '火山口湖', 'Crater Lake', 'CTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3887, 331, '科瓦利斯', 'Corvallis', 'YCV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3888, 331, '库斯贝', 'Coos Bay', 'COB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3889, 331, '梅德福', 'Medford', 'MFR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3890, 331, '塞勒姆', 'Salem', 'SLE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3891, 331, '圣海伦斯', 'St Helens', 'STH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3892, 331, '斯普林菲尔德', 'Springfield', 'SPY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3893, 331, '尤金', 'Eugene', 'EUG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3894, 332, '奥兰多', 'Orlando', 'ORL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3895, 332, '基韦斯特', 'Key West', 'EYW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3896, 332, '杰克逊维尔', 'Jacksonville', 'JAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3897, 332, '卡纳维尔角', 'Cape Canaveral', 'CPV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3898, 332, '罗德岱堡', 'Fort Lauderdale', 'FLL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3899, 332, '迈阿密', 'Miami', 'MIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3900, 332, '圣彼德斯堡市', 'St. Petersburg', 'PIE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3901, 332, '塔拉哈西', 'Tallahassee', 'TLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3902, 332, '坦帕', 'Tampa', 'TPA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3903, 333, '伯灵顿', 'Burlington', 'BTV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3904, 333, '拉特兰', 'Rutland', 'RUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3905, 333, '南伯灵顿', 'South Burlington', 'ZBR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3906, 334, '华盛顿哥伦比亚特区', 'Washington D.C.', 'WAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3907, 335, '斯波坎', 'Spokane', 'GEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3908, 335, '塔科马', 'Tacoma', 'TTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3909, 335, '西雅图', 'Seattle', 'SEA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3910, 336, '埃文斯顿', 'Evanston', 'EVD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3911, 336, '卡斯珀', 'Casper', 'CPR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3912, 336, '拉勒米', 'Laramie', 'LAR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3913, 336, '罗克斯普林斯', 'Rock Springs', 'RKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3914, 336, '夏延', 'Cheyenne', 'CYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3915, 336, '谢里登', 'Sheridan', 'SHR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3916, 337, '旧金山', 'San Francisco', 'SFO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3917, 337, '洛杉矶', 'Los Angeles', 'LAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3918, 337, '圣迭戈', 'San Diego', 'SAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3919, 337, '圣何塞', 'San Jose', 'SJC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3920, 338, '阿比林', 'Abilene', 'ABZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3921, 338, '奥弗兰公园', 'Overland Park', 'OVL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3922, 338, '哈钦森', 'Hutchinson', 'HCH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3923, 338, '堪萨斯城', 'Kansas City', 'KCK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3924, 338, '莱文沃思', 'Leavenworth', 'XIA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3925, 338, '劳伦斯', 'Lawrence', 'LWC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3926, 338, '曼哈顿', 'Manhattan', 'MHK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3927, 338, '托皮卡', 'Topeka', 'TOP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3928, 338, '威奇托', 'Wichita', 'ICT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3929, 339, '布里奇波特', 'Bridgeport', 'BDR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3930, 339, '达里恩', 'Darien', 'DAQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3931, 339, '格林尼治', 'Greenwich', 'GRH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3932, 339, '哈特福德', 'Hartford', 'HFD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3933, 339, '米德尔顿', 'Middletown', 'XIN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3934, 339, '纽黑文', 'New Haven', 'HVN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3935, 339, '韦斯特波特', 'Westport', 'WPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3936, 339, '沃特伯里', 'Waterbury', 'WAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3937, 339, '新不列颠', 'New Britain', 'NWT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3938, 340, '阿斯彭', 'Aspen', 'ASE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3939, 340, '奥罗拉', 'Aurora', 'AUX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3940, 340, '博尔德', 'Boulder', 'WBU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3941, 340, '大章克申', 'Grand Junction', 'GJT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3942, 340, '丹佛', 'Denver', 'DEN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3943, 340, '柯林斯堡', 'Fort Collins', 'FNL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3944, 340, '科罗拉多斯普林斯', 'Colorado Springs', 'COS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3945, 340, '韦尔', 'Vail', 'VAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3946, 341, '列克星敦', 'Lexington', 'LEX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3947, 341, '路易斯维尔', 'Louisville', 'LUI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3948, 341, '欧文斯伯勒', 'Owensboro', 'OWB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3949, 342, '巴吞鲁日', 'Baton Rouge', 'BTR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3950, 342, '什里夫波特', 'Shreveport', 'SHV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3951, 342, '新奥尔良', 'New Orleans', 'MSY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3952, 343, '波塔基特', 'Pawtucket', 'PAW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3953, 343, '克兰斯顿', 'Cranston', 'CQH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3954, 343, '纽波特', 'Newport', 'NPO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3955, 343, '普罗维登斯', 'Providence', 'PVD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3956, 343, '韦斯特利', 'Westerly', 'WST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3957, 343, '文索基特', 'Woonsocket', 'SFN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3958, 343, '沃威克', 'Warwick', 'UZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3959, 344, '巴尔的摩', 'Balitmore', 'BAL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3960, 344, '盖瑟斯堡', 'Gaithersburg', 'GAI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3961, 344, '罗克维尔', 'Rockville', 'RKV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3962, 345, '波士顿', 'Boston', 'BZD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3963, 345, '斯普林菲尔德', 'Springfield', 'SFY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3964, 345, '伍斯特', 'Worcester', 'ORH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3965, 346, '比灵斯', 'Billings', 'BGS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3966, 346, '大瀑布村', 'Great Falls', 'GTF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3967, 346, '米苏拉', 'Missoula', 'MSO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3968, 347, '哥伦比亚', 'Columbia', 'COV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3969, 347, '杰佛逊市', 'Jefferson City', 'JEF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3970, 347, '堪萨斯城', 'Kansas City', 'MKC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3971, 347, '圣路易斯', 'Sanit Louis', 'STL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3972, 347, '斯普林菲尔德', 'Springfield', 'SGF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3973, 348, '比洛克西', 'Biloxi', 'BIX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3974, 348, '格尔夫波特', 'Gulfport', 'GPT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3975, 348, '格林维尔', 'Greenville', 'GLH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3976, 348, '哈蒂斯堡', 'Hattiesburg', 'HBG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3977, 348, '杰克逊', 'Jackson', 'JAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3978, 348, '默里迪恩', 'Meridian', 'MEI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3979, 348, '维克斯堡', 'Vicksburg', 'VKS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3980, 349, '安娜堡', 'Ann Arbor', 'ARB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3981, 349, '巴特尔克里克', 'Battle Creek', 'BTL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3982, 349, '贝城', 'Bay City', 'BCY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3983, 349, '大急流城', 'Grand Rapids', 'GRR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3984, 349, '迪尔伯恩', 'Dearborn', 'DEO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3985, 349, '底特律', 'Detroit', 'DET', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3986, 349, '弗林特', 'Flint', 'FNT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3987, 349, '怀恩多特', 'Wyandotte', 'WYD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3988, 349, '卡拉马袓', 'Kalamazoo', 'AZO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3989, 349, '兰辛', 'Lansing', 'LAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3990, 349, '马斯基根', 'Muskegon', 'MKG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3991, 349, '庞菷亚克', 'Pontiac', 'PTK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3992, 349, '萨吉诺', 'Saginaw', 'SGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3993, 349, '苏圣玛丽', 'Sault Ste Marie', 'SSM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3994, 349, '沃伦', 'Warren', 'WAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3995, 349, '休伦港', 'Port Huron', 'PHN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3996, 350, '班戈', 'Bangor', 'BNQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3997, 350, '波特兰', 'Portland', 'POL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3998, 350, '刘易斯顿', 'Lewiston', 'QLW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(3999, 351, '罗切斯特', 'Rochester', 'RST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4000, 351, '明尼阿波利斯', 'Minneapolis', 'MES', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4001, 351, '圣保罗', 'Saint Paul', 'STP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4002, 352, '阿伯丁', 'Aberdeen', 'ABK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4003, 352, '拉皮德城', 'Rapid City', 'RAP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4004, 352, '苏福尔斯', 'Sioux Falls', 'FSD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4005, 353, '北查尔斯顿', 'North Charleston', 'NTS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4006, 353, '查尔斯顿', 'Charleston', 'CHS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4007, 353, '哥伦比亚', 'Columbia', 'COV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4008, 354, '奥马哈', 'Omaha', 'OMA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4009, 354, '贝尔维尤', 'Bellevue', 'XDE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4010, 354, '林肯', 'Lincoln', 'LNK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4011, 355, '埃尔科', 'Elko', 'EKO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4012, 355, '北拉斯维加斯', 'North Las Vegas', 'NVS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4013, 355, '弗吉尼亚城', 'Virginia City', 'VGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4014, 355, '亨德森', 'Henderson', 'HNZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4015, 355, '卡森城', 'Carson City', 'CSN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4016, 355, '拉斯维加斯', 'Las Vegas', 'LAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4017, 355, '里诺', 'Reno', 'RNO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4018, 355, '斯帕克斯', 'Sparks', 'SPK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4019, 356, '布法罗', 'Buffalo', 'FFO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4020, 356, '罗切斯特', 'Rochester', 'ROC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4021, 356, '纽约市', 'New York', 'QEE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4022, 357, '多佛', 'Dover', 'DOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4023, 357, '纽瓦克', 'Newark', 'NWK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4024, 357, '威明顿', 'Wilmington', 'ILG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4025, 358, '布利斯托', 'Bristol', 'BSJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4026, 358, '查塔努加', 'Chattanooga', 'CHA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4027, 358, '金斯波特', 'Kingsport', 'TRI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4028, 358, '孟菲斯', 'Memphis', 'MEM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4029, 358, '纳什维尔', 'Nashville', 'BNA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4030, 358, '诺克斯维尔', 'Knoxville', 'TYS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4031, 358, '三城区', 'Tri-City Area', 'YTC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4032, 358, '士麦那', 'Smyrna', 'MQY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4033, 358, '斯普林希尔', 'Spring Hill', 'RGI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4034, 358, '约翰逊城', 'Johnson City', 'JCY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4035, 359, '阿普尓顿', 'Appleton', 'ATW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4036, 359, '奥什科什', 'Oshkosh', 'OSH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4037, 359, '格林贝', 'Green Bay', 'GBK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4038, 359, '基诺沙', 'Kenosha', 'ENW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4039, 359, '拉克罗斯', 'LaCrosse', 'LSE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4040, 359, '拉辛', 'Racine', 'RAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4041, 359, '马尼托沃克', 'Manitowoc', 'MTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4042, 359, '迈迪逊', 'Madison', 'QMD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4043, 359, '密尔沃基', 'Milwaukee', 'MKE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4044, 359, '欧克莱尓', 'Eau Claire', 'EAU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4045, 359, '沃索', 'Wausau', 'AUW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4046, 359, '希博伊根', 'Sheboygan', 'SBM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4047, 360, '弗吉尼亚比奇', 'Virginia Beach', 'VAB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4048, 360, '诺福克', 'Norfolk', 'ORF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4049, 360, '切萨皮克', 'Chesapeake', 'HTW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4050, 361, '查尔斯顿', 'Charleston', 'CRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4051, 361, '亨廷顿', 'Huntington', 'HNU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4052, 361, '帕克斯堡', 'Parkersburg', 'PKB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4053, 362, '凯卢阿', 'Kailua', 'KHH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4054, 362, '檀香山', 'Honolulu', 'HNL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4055, 362, '希洛', 'Hilo', 'ITO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4056, 363, '康科德', 'Concord', 'CON', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4057, 363, '曼彻斯特', 'Manchester', 'MHT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4058, 363, '纳舒厄', 'Nashua', 'ASH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4059, 364, '阿尔伯克基', 'Albuquerque', 'ABQ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4060, 364, '拉斯克鲁塞斯', 'Las Cruces', 'LRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4061, 364, '罗斯韦尔', 'Roswell', 'ROW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4062, 364, '圣菲', 'Santa Fe', 'SAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4063, 365, '纽瓦克', 'Newark', 'NRK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4064, 365, '帕特森', 'Paterson', 'PAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4065, 365, '泽西城', 'Jersey City', 'JEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4066, 366, '凤凰城', 'Phoenix', 'PHX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4067, 366, '格兰代尔', 'Glendale', 'GDA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4068, 366, '梅萨', 'Mesa', 'MQA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4069, 366, '史卡兹代尔', 'Scottsdale', 'STZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4070, 366, '坦普', 'Tempe', 'TPE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4071, 366, '图森', 'Tucson', 'TUC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4072, 366, '优玛', 'Yuma', 'YUM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4073, 367, '奥尔顿', 'Alton', 'ALN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4074, 367, '奥罗拉', 'Aurora', 'AUZ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4075, 367, '布卢明顿', 'Bloomington', 'BLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4076, 367, '丹维尓', 'Danville', 'DVI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4077, 367, '迪卡尔布', 'De Kalb', 'DEK', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4078, 367, '迪凯持', 'Decatur', 'DEC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4079, 367, '东圣路易斯', 'East St Louis', 'ESL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4080, 367, '厄巴纳-香槟', 'Champaign-Urbana', 'CMI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4081, 367, '盖尔斯堡', 'Galesburg', 'GSU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4082, 367, '卡本代尔', 'Carbondale', 'MDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4083, 367, '罗克艾兰', 'Rock Island', 'RKI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4084, 367, '罗克福德', 'Rockford', 'RFD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4085, 367, '诺黙尔', 'Normal', 'NOM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4086, 367, '皮奥里亚', 'Peoria', 'PLA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4087, 367, '森特勒利亚', 'Centralia', 'CRA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4088, 367, '斯普林菲尔德', 'Springfield', 'SPI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4089, 367, '沃其根', 'Waukegan', 'UGN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4090, 367, '芝加哥', 'Chicago', 'CHI', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4091, 368, '埃文斯维尔', 'Evansville', 'EVV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4092, 368, '韦恩堡', 'Fort Wayne', 'FWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4093, 368, '印第安纳波利斯', 'Indianapolis', 'IND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4094, 369, '奥格登', 'Ogden', 'OGD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4095, 369, '雷登', 'Layton', 'LTJ', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4096, 369, '欧仁', 'Orem', 'OEU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4097, 369, '帕克城', 'Park City', 'PAC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4098, 369, '普罗沃', 'Provo', 'PVU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4099, 369, '圣乔治', 'St.George', 'SGU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4100, 369, '西瓦利城', 'West Valley City', 'WVC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4101, 369, '盐湖城', 'Salt Lake City', 'SLC', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4102, 370, '奥古斯塔', 'Augusta', 'AUT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4103, 370, '哥伦布', 'Columbus', 'CZX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4104, 370, '梅肯', 'Macon', 'MCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4105, 370, '沙瓦纳', 'Savannah', 'SAV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4106, 370, '亚特兰大', 'Atlanta', 'TAT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4107, 371, '贝尔法斯特', 'Belfast', 'BFS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4108, 371, '德里', 'Derry', 'DRY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4109, 371, '利斯本', 'Lisburn', 'LSB', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4110, 371, '纽里', 'Newry', 'NYM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4111, 372, '阿伯丁', 'Aberdeen', 'ABD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4112, 372, '爱丁堡', 'Edinburgh', 'EDH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4113, 372, '丹迪', 'Dundee', 'DND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4114, 372, '格拉斯哥', 'Glasgow', 'GLG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4115, 372, '斯特灵', 'Stirling', 'STG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4116, 372, '因弗内斯', 'Inverness', 'INV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4117, 373, '班戈', 'Bangor', 'BAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4118, 373, '卡迪夫', 'Cardiff', 'CDF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4119, 373, '纽波特', 'Newport', 'NWP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4120, 373, '斯旺西', 'Swansea', 'SWA', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4121, 374, '埃克塞特', 'Exeter', 'EXE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4122, 374, '巴斯', 'Bath', 'BAS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4123, 374, '彼得伯勒', 'Peterborough', 'PTE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4124, 374, '伯明翰', 'Birmingham', 'BIR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4125, 374, '布拉德福德', 'Bradford', 'BRD', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4126, 374, '布莱顿与赫福', 'Brighton & Hove', 'BNH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4127, 374, '布里斯托尔', 'Bristol', 'BST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4128, 374, '德比', 'Derby', 'DER', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4129, 374, '德罕', 'Durham', 'DUR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4130, 374, '格洛斯特', 'Gloucester', 'GLO', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4131, 374, '赫尔河畔京斯敦', 'Kingston upon Hull', 'KUH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4132, 374, '赫里福德', 'Hereford', 'HAF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4133, 374, '剑桥', 'Cambridge', 'CAM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4134, 374, '卡莱尔', 'Carlisle', 'CAX', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4135, 374, '坎特伯雷', 'Canterbury', 'CNG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4136, 374, '考文垂', 'Coventry', 'COV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4137, 374, '兰开斯特', 'Lancaster', 'LAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4138, 374, '里彭', 'Ripon', 'RIP', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4139, 374, '利奇菲尔德', 'Lichfield', 'LHF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4140, 374, '利物浦', 'Liverpool', 'LIV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4141, 374, '利茲', 'Leeds', 'LDS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4142, 374, '列斯特', 'Leicester', 'LCE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4143, 374, '林肯', 'Lincoln', 'LCN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4144, 374, '伦敦', 'London', 'LND', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4145, 374, '曼彻斯特', 'Manchester', 'MAN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4146, 374, '南安普敦', 'Southampton', 'STH', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4147, 374, '牛津', 'Oxford', 'OXF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4148, 374, '纽卡斯尔', 'Newcastle', 'NCL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4149, 374, '诺丁汉', 'Nottingham', 'NGM', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4150, 374, '诺里奇', 'Norwich', 'NRW', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4151, 374, '朴茨茅斯', 'Portsmouth', 'POR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4152, 374, '普雷斯顿', 'Preston', 'PRE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4153, 374, '普利茅斯', 'Plymouth', 'PLY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4154, 374, '奇切斯特', 'Chichester', 'CST', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4155, 374, '切斯特', 'Chester', 'CEG', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4156, 374, '桑德兰', 'Sunderland', 'SUN', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4157, 374, '圣阿本斯', 'Saint Albans', 'TBL', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4158, 374, '索尔斯堡', 'Salisbury', 'SLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4159, 374, '索福特', 'Salford', 'SLF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4160, 374, '特鲁罗', 'Truro', 'TRU', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4161, 374, '特伦特河畔斯多克', 'Stoke-on-Trent', 'SOT', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4162, 374, '威尔斯', 'Wells', 'WLS', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4163, 374, '韦克菲尔德', 'Wakefield', 'WKF', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4164, 374, '温彻斯特', 'Winchester', 'WNE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4165, 374, '伍尔弗汉普顿', 'Wolverhampton', 'WOV', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4166, 374, '伍斯特', 'Worcester', 'WOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4167, 374, '谢菲尔德', 'Sheffield', 'SHE', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4168, 374, '伊利', 'Ely', 'ELY', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4169, 374, '约克', 'York', 'YOR', '', 0, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4171, 0, '中东', 'Middle East', 'AE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0),
(4172, 4171, '阿拉伯联合酋长国', 'UAE', 'AE', '', 1, '0.0000', '0.0000', '', 0, 0, 255, 0, 0);

CREATE TABLE IF NOT EXISTS `qinggan_world_price` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `region_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '国家ID（地区ID）',
  `tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `price` decimal(15,4) NOT NULL DEFAULT '0.0000' COMMENT '价格',
  `vtype` varchar(10) NOT NULL COMMENT '类型，price价格，freight运费，excise消费税，tariff关税',
  PRIMARY KEY (`id`),
  KEY `region_id` (`region_id`,`tid`,`vtype`) USING BTREE
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='针对不同国家实现不同的价格' AUTO_INCREMENT=6 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
