<?php
/**
 * CKeditor 上传组件
 * @作者 qinggan <admin@phpok.com>
 * @主页 http://www.phpok.com
 * @版本 5.x
 * @许可 http://www.phpok.com/lgpl.html PHPOK开源授权协议：GNU Lesser General Public License
 * @时间 2021年5月13日
**/

/**
 * 安全限制，防止直接访问
**/
if(!defined("PHPOK_SET")){
	exit("<h1>Access Denied</h1>");
}

class ckeditor_control extends phpok_control
{
	public function __construct()
	{
		parent::control();
	}


	public function video_f()
	{
		$id = $this->get('id');
		if(!$id){
			$this->ckerror(P_Lang('未指定要插入的附件'));
		}
		$rs = $this->model('res')->get_one($id);
		if(!$rs){
			$this->ckerror(P_Lang('附件不存在'));
		}
		$filename = $rs['filename'];
		if(!$filename){
			$this->ckerror(P_Lang('附件不存在'));
		}
		if(substr($filename,0,7) != 'http://' && substr($filename,0,8) != 'https://'){
			$filename = $this->config['url'].$filename;
		}
		$this->ckhtml($filename);
	}

	/**
	 * 在弹出CKeditor图片选择器时插入图片
	**/
	public function image_f()
	{
		$id = $this->get('id');
		if(!$id){
			$this->ckerror(P_Lang('未指定要插入的附件'));
		}
		$rs = $this->model('res')->get_one($id);
		if(!$rs){
			$this->ckerror(P_Lang('附件不存在'));
		}
		$gd_rs = $this->model('gd')->get_editor_default();
		if($gd_rs && $rs['gd'] && $rs['gd'][$gd_rs['identifier']]){
			$filename = $rs['gd'][$gd_rs['identifier']];
		}else{
			$filename = $rs['filename'];
		}
		if(!$filename){
			$this->ckerror(P_Lang('附件不存在'));
		}
		$this->ckhtml($filename);
	}

	private function upError($error='')
	{
		$data = array();
		$data['uploaded'] = 0;
		$data['error'] = array('message'=>$error);
		echo $this->lib('json')->encode($data);
		exit;
	}

	private function upOk($filename,$title='')
	{
		$data = array();
		$data['uploaded'] = 1;
		$data['fileName'] = $title;
		$data['url'] = $filename;
		echo $this->lib('json')->encode($data);
		exit;
	}

	private function ckerror($error='')
	{
		$callback = $this->get('callback');
		if(!$callback){
			$callback = $this->get('CKEditorFuncNum');
		}
		$html  = "<script type=\"text/javascript\">\n";
		$html .= "window.opener.CKEDITOR.tools.callFunction(".$callback.",'','".$error."');window.close();\n";
		$html .= "</script>";
		echo $html;
		exit;
	}

	private function ckhtml($filename='')
	{
		$callback = $this->get('callback');
		if(!$callback){
			$callback = $this->get('CKEditorFuncNum');
		}
		$html  = "<script type=\"text/javascript\">\n";
		$html .= "window.opener.CKEDITOR.tools.callFunction(".$callback.",'".$filename."','');window.close();\n";
		$html .= "</script>";
		echo $html;
		exit;
	}

	/**
	 * 图片上传操作
	**/
	public function imgupload_f()
	{
		$rs = $this->lib('upload')->getfile('upload');
		if($rs['status'] != 'ok'){
			$tip = $rs['error'] ? $rs['error'] : '附件上传失败';
			$this->upError($tip);
		}
		$array = array();
		$array["cate_id"] = $rs['cate']['id'];
		$array["folder"] = $rs['folder'];
		$array["name"] = basename($rs['filename']);
		$array["ext"] = $rs['ext'];
		$array["filename"] = $rs['filename'];
		$array["addtime"] = $this->time;
		$array["title"] = $rs['title'];
		$array['admin_id'] = $this->session->val('admin_id');
		$array["mime_type"] = $rs['mime_type'];
		$arraylist = array("jpg","gif","png","jpeg","webp");
		if(in_array($rs["ext"],$arraylist)){
			$img_ext = getimagesize($this->dir_root.$rs['filename']);
			$my_ext = array("width"=>$img_ext[0],"height"=>$img_ext[1]);
			$array["attr"] = serialize($my_ext);
		}
		$id = $this->model('res')->save($array);
		if(!$id){
			$this->lib('file')->rm($this->dir_root.$rs['filename']);
			$this->upError(P_Lang('图片存储失败'));
		}
		$this->model('res')->gd_update($id);
		$rs = $this->model('res')->get_one($id);
		$gd_rs = $this->model('gd')->get_editor_default();
		if($gd_rs && $rs['gd'] && $rs['gd'][$gd_rs['identifier']]){
			$filename = $rs[$gd_rs['identifier']];
		}else{
			$filename = $rs['filename'];
		}
		$this->upOk($filename,$rs['title']);
	}

	/**
	 * 浏览器图片预览
	**/
	public function imglist_f()
	{
		$ext = array();
		$ext['CKEditor'] = $this->get('CKEditor');
		$ext['CKEditorFuncNum'] = $this->get('CKEditorFuncNum');
		$ext['langCode'] = $this->get('langCode');
		$this->assign('CKEditorFuncNum',$ext['CKEditorFuncNum']);
		$formurl = $pageurl = $this->url('ckeditor','imglist',http_build_query($ext));
		$pageid = $this->get($this->config["pageid"],"int");
		if(!$pageid){
			$pageid = 1;
		}
		$psize = $this->config['psize'];
		$offset = ($pageid - 1) * $psize;
		$condition = "ext IN ('gif','jpg','png','jpeg','webp') ";
		if($this->session->val('user_id')){
			$condition .= " AND user_id='".$this->session->val('user_id')."' ";
		}else{
			$condition .= " AND session_id='".$this->session->sessid()."' ";
		}
		$gd_rs = $this->model('gd')->get_editor_default();
		$keywords = $this->get('keywords');
		if($keywords){
			$condition .= " AND (filename LIKE '%".$keywords."%' OR title LIKE '%".$keywords."%') ";
			$this->assign('keywords',$keywords);
			$pageurl .= "&keywords=".rawurlencode($keywords);
		}
		$total = $this->model('res')->edit_pic_total($condition,$gd_rs);
		if(!$total){
			$this->error(P_Lang('没有图片'));
		}
		$rslist = $this->model('res')->edit_pic_list($condition,$offset,$psize,$gd_rs);
		if($rslist){
			$piclist = array();
			foreach($rslist as $key=>$value){
				$tmp = array('url'=>$value['filename'],'ico'=>$value['ico'],'mtime'=>$value['addtime'],'title'=>$value['title'],'id'=>$value['id']);
				if($value['attr']){
					$attr = is_string($value['attr']) ? unserialize($value['attr']) : $value['attr'];
					$tmp['width'] = $attr['width'];
					$tmp['height'] = $attr['height'];
				}
				$piclist[] = $tmp;
			}
			$this->assign('rslist',$piclist);
		}
		$string = 'home='.P_Lang('首页').'&prev='.P_Lang('上一页').'&next='.P_Lang('下一页').'&last='.P_Lang('尾页').'&half=3';
		$string.= '&add='.P_Lang('数量：').'(total)/(psize)'.P_Lang('，').P_Lang('页码：').'(num)/(total_page)&always=1';
		$pagelist = phpok_page($pageurl,$total,$pageid,$psize,$string);
		$this->assign("pagelist",$pagelist);
		$this->assign("pageurl",$pageurl);
		$this->assign('formurl',$formurl);
		$this->view($this->dir_phpok.'open/ckeditor_imglist.html','abs-file');
	}
}
