tinymce.PluginManager.add("map", function(editor, url) {
    var douPlugin = url;
 
    var openDialog = function () {
        return editor.windowManager.open({
          title: '百度地图',
          size: 'medium',
          body: {
            type: 'panel',  
            items: [{  
                type: 'htmlpanel',  
                html: '<iframe id="baiduMap" src="' + url + '/dialog.html"  frameborder="0" style="width:760px; height:440px"></iframe>'
            }]
          },
          buttons: [
            {
              type: 'cancel',
              text: 'Close'
            },
            {
              type: 'submit',
              text: 'Insert',
              primary: true
            }
          ],
          onSubmit: function (api) {
            var baiduMap = document.getElementById("baiduMap").contentWindow.document;
            var txtlatitude = baiduMap.getElementById("txtlatitude").value; // 维度
            var txtLongitude = baiduMap.getElementById("txtLongitude").value; // 经度
            var txtZoom = baiduMap.getElementById("txtZoom").value; // 缩放
            if(baiduMap.getElementById("txtDynamic").checked) {
                editor.insertContent("<iframe class=\"ueditor_baidumap\" src=\"" + url + "/show.html#center=" + txtLongitude + "," + txtlatitude + "&zoom=" + txtZoom +"&width=600%&height=400&markers=" + txtLongitude + "," + txtlatitude + "&title=DouPHP&markerStyles=l,A\" frameborder=\"0\" width=\"600%\" height=\"400\"></iframe>")
            } else {
                editor.insertContent("<img width=\"600\" height=\"400\" src=\"http://api.map.baidu.com/staticimage?center=" + txtLongitude + "," + txtlatitude + "&zoom=" + txtZoom +"&width=600&height=400&markers=" + txtLongitude + "," + txtlatitude + "&title=DouPHP\">")
            }
            api.close();
          }
        });
    };
    
    editor.ui.registry.addButton("map", {
        tooltip: '百度地图',
        icon: 'embed-page',
        onAction: function () {
          openDialog();
        }
    }),
    editor.ui.registry.addMenuItem("map", {
        text: "百度地图",
        context: "tools",
        onclick: function() {
            openDialog();
        }
    })
});