<?php
/***
 *----------------------------------------------------------------------------*
 * 版权所有 2010-2016 HuCart.COM，并保留所有权利。
 * 此程序是HuCart的一部分。  
 * 根据MIT许可证授权(在软件和软件的所有副本中都必须包含版权声明和许可声明。)
 * 官方网址:http://www.hucart.com
 *
 * 对于完整的版权和许可证信息，请参阅MIT-LICENSE.TXT
 * 程序的再发布必须保留以上版权声明。
 *
 *@author pgmk<pgmk@hucart.com>
 *@copyright pgmk<pgmk@hucart.com>
 *@link http://www.hucart.com
 *@license The MIT License.
 *----------------------------------------------------------------------------*
**/
if (!defined('HUCART_COM')) exit('HuCart.COM No direct script access allowed');
class Article  extends HC_Controller
{

	function __construct()
	{
		parent::__construct();
		$this -> load_db();
		$this -> load_lang('www/article');
		$this -> load('helper');     	 	//加载辅助类
		$this -> load_model('ads'); 		//加载模型
		$this -> load_model('web_config'); 	//加载模型
		$web_config = $this -> web_config_mod -> get_sys_config();
		$this -> set_view_dir( $web_config['temp'] -> dir );
		$this -> view -> assign('web_config', $web_config);


		$this -> view -> assign('menu_info',$this -> web_config_mod -> get_web_menu());
		$this -> view -> assign('ads_info', $this -> ads_mod -> get_ads( '1,2,3,4,5,6,7,8,9,10,11'  ));
		$this -> view -> assign('user_link',$this -> session -> get_user_link( $this->lang['user_link'] ));
		

		$this -> load_model('personal'); //加载模型
		$art_sort = $this -> personal_mod  -> get_sort('art_sort');
		
		//var_dump($art_sort);
		
		$this -> view -> assign('art_sort',$art_sort);
		
		$contact_arr =  $this -> helper -> build_contact( $web_config );
		$this -> view -> assign('contact_arr',$contact_arr);
		
		//var_dump($web_info);
		//var_dump($GLOBALS);
	}
	

	
	function info_list()
	{
	 
		$id 		= $this -> input -> get["id"];
		$page_num 	= $this -> input -> get["page"];
		
		if($this -> input -> req["type"]  !='' )
		{
			//$endArray["type"] = $this -> input -> req["type"];
		}
		
		$newkeywordval  = $this -> input -> req["newkeyword"];
		
		if( $newkeywordval=='' and $this -> input -> req["keyword"] )
		{  
			$newkeywordval  = $this -> input -> req["keyword"]; 
			
		}



		if($newkeywordval != '')
		{ 	
			$newkeywordval  = urldecode($newkeywordval); 
			$addurl 	   .= '&newkeywordval='.urlencode($newkeywordval);
			$whereadd 	   .= " AND ( art_title  LIKE  '%".$newkeywordval."%' )";
			//关键字入库处理
			$keyid = $this -> helper -> addKeyword($newkeywordval);
			
			//$endArray["keyword"] = urlencode($newkeywordval) ;
		}
		
		
		$addurl 		= '';
		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'artlist' ORDER BY `per_id`  ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		$this -> personal_mod -> get_column($infoper["per_column"]);

		$webtitle = $this->lang['web_title'];
		
		//处理你现在的位置
 
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/article.html">资讯中心</a></li>';

		
		$page_size = 20 ;
		
		if( $page_num  > 1 )
		{
			$limit_num = ceil( ( $page_num -1 ) * $page_size );
		}else{
			$page_num  = 1;
			$limit_num = 0 ;
		}

		$addpage = '';
		
		if( $sid > 0 and  $sid !='2' )
		{
			//$endArray["sid"] = $sid;
		} 

		if( $id != '' )
		{
			$seletsort = " SELECT sort_id,sort_name  FROM ".$this -> db -> prefix."art_sort WHERE sort_id = ".$id." or  sort_parent_id = ".$id ;
			$sortInfo  = $this -> db ->  select_info($seletsort);
			$sinid 	   = '';
			$addpage   = '&id='.$id;

			foreach( (array)$sortInfo as $skey => $sval )
			{
				if( $sval["sort_id"]== $id )
				{
					$webtitle 	= $sortval = $sval["sort_name"];
					$now_address = $now_address. '<li><a href="'.BASE_WEBURL.'/index.php?/article-info_list-'.$id.'.html">'.$sval["sort_name"].'</a></li>';
				}
				if($skey==0)
				{
					$sinid = $sval["sort_id"];
				}else{
					$sinid .= ','.$sval["sort_id"];
				}
			}

			
		    $sql_query = "SELECT art_id, art_title ,art_small_title, art_color, art_bolder, art_view, art_description,left(art_detail ,200) as art_detailsmall , art_up_time ,s.sort_name ,s.sort_id  FROM  ".$this -> db -> prefix."article as a left join  ".$this -> db -> prefix."art_sort as s on a.sort_id = s.sort_id  WHERE art_sys_file ='' and  art_delete = 0 and  art_enabled = 1 and  a.sort_id in ( ".$sinid." ) ".$whereadd."  GROUP BY  art_id ORDER BY art_up_time DESC, `art_id` LIMIT  $limit_num , $page_size ";
			$sql_querycount 	= "SELECT count(1) as CNUM  FROM  ".$this -> db -> prefix."article as a   WHERE art_sys_file ='' and  art_delete = 0 and   art_enabled = 1  and   a.sort_id in ( ".$sinid." ) ".$whereadd." ORDER BY `art_id`  ";
		
		}else{
		 	$sql_query 		= "SELECT art_id, art_title , art_small_title, art_color, art_bolder, art_view, art_description,left(art_detail ,300) as art_detailsmall , art_up_time ,s.sort_name ,s.sort_id  FROM  ".$this -> db -> prefix."article  as a left join  ".$this -> db -> prefix."art_sort as s on a.sort_id = s.sort_id  WHERE art_sys_file ='' and  art_delete = 0 and  art_enabled = 1 ".$whereadd."  GROUP BY  art_id ORDER BY art_up_time DESC,  `art_id` LIMIT  $limit_num , $page_size ";
			$sql_querycount = "SELECT count(1) as CNUM  FROM  ".$this -> db -> prefix."article as a   WHERE art_sys_file ='' and  art_delete = 0 and  art_enabled = 1  ".$whereadd." ORDER BY `art_id`  ";
		}
		
		$info = $this -> db -> select_info($sql_query);
		
		foreach((array)$info as $artkey => $artval)
		{
			
			if($info[$artkey]["art_small_title"]!='')
			{
				$info[$artkey]["art_title"]=  $artval["art_small_title"];
			}
			
			$info[$artkey]["get_url"]= $this -> helper  -> build_url( $valid = $artval["art_id"],'art',$endArray);

			$styleval = '';
			if($artval["art_bolder"]=='1')
			{
				$styleval = "font-weight:bold;";
			}
			if($artval["art_color"]!='')
			{
				$styleval .= "color:".$artval["art_color"];
			}
			if($styleval!=''){
				$info[$artkey]["art_style"] = 'style="'.$styleval.'"';
			}
			
			
			if($info[$artkey]["art_description"]=='')
			{
				$info[$artkey]["art_description"]= strip_tags($artval["art_detailsmall"]);
			}else{
				$info[$artkey]["art_description"]= strip_tags($artval["art_description"]);
			}
		}

		
		
		$infocount 	= $this -> db -> select_one($sql_querycount);
		
		if($sid> 0 ){
			$url = BASE_WEBURL.'/index.php?/article-info_list-'.$sid.'.html';
		}else{
			$url = BASE_WEBURL.'/index.php?/article-list.html';
		}

 		$this -> load('page',$this->lang['page']);

		$page_str    = $this -> page -> buildpage_str( $url , $page_num  , $page_size  , $result_count = $infocount["CNUM"] , $endArray);

		
		$this -> view -> assign('sortval',$sortval);
		$this -> view -> assign('page_str',$page_str);
		$this -> view -> assign('info',$info);
		$this -> view -> assign('webtitle',$webtitle);
		$this -> view -> assign('now_address',$now_address);
		
		if($sid !='' or $page_num!='' or  $newkeywordval !='')
		{
			$cache_id = $sid.'p'.$page_num.'k'.$keyid;
		}
		
		$this -> view -> display('art_list.tpl',$cache_id);	
	}


	function show()
	{
		$id 		= intval($this -> input -> get["id"]);
		$page_num 	= $this -> input -> get["page"];
		
		if($page_num==''){ $page_num = 1;}

		$webtitle = $this->lang['web_title'];
		
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/article.html">资讯中心</a></li>';
		
		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'art' ORDER BY `per_id`  ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		
		$this -> personal_mod -> get_column( $infoper["per_column"] );

		if( $id > 0 )
		{
			$sql_query 		= " SELECT a.* ,s.sort_name  FROM  ".$this -> db -> prefix."article as a ,".$this -> db -> prefix."art_sort  as s  WHERE a.sort_id = s.sort_id and  art_delete = 0 and a.art_enabled = 1  and a.art_id = ".$id." ORDER BY a.`art_id`  ";
			$infodetail 	= $this -> db -> select_one($sql_query);
			$infodetail['art_up_time'] 	=  date("Y-m-d",$infodetail["art_up_time"]);
			$reinfodetail 	= $this -> get_content( $infodetail["art_detail"], $page = $page_num);
			$infodetail["art_detail"] = $this -> helper -> restrval( $reinfodetail["reInfo"]) ;
			
			$webtitle  		= $infodetail["art_title"];
			if($infodetail["sort_name"]!='')
			{
				$now_address = $now_address.'<li><a href="'.BASE_WEBURL.'/index.php?/article-info_list-'.$infodetail["sort_id"].'.html">'.$infodetail["sort_name"].'</a></li><li>'.$infodetail["art_title"].'</li>';
			}
			
			if($infodetail["art_keyword"]!='')
			{
				$infodetail["art_tag"] = $this -> expKeyword( $infodetail["art_keyword"] );
				//http://www.wwwtest.cn/index.php?/article-list.html&page=2&type=search&keyword=%E4%BA%91%E5%8D%97
			}
			$this -> load_model('comemt'); 	//加载模型	
			
			$commentInfo = $this -> comemt_mod  -> get_comemt( $id , $Num = 10 , $type = 'article');
			$this -> view -> assign('commentInfo',$commentInfo);

			$url = BASE_WEBURL.'/index.php?/article-'.$id.'.html';
			$this -> load('page',$this->lang['page']);
			$page_str 	= $this -> page -> buildpage_str( $url , $page_num = $page_num , $page_size = 1 , $result_count = $reinfodetail["pageCount"]);
			
			//浏览量 + 1
			$sqlup = " UPDATE ".$this -> db -> prefix."article set art_view = art_view +1 WHERE art_id = ".$id ; 
			$this -> db -> query_sql($sqlup);
			
			
			//查询上一篇
			$prosql 	= " SELECT art_id, art_title  FROM ".$this -> db -> prefix."article WHERE  art_id < ".$id." GROUP BY art_id   ORDER BY art_id  DESC ";
			$Prodetail 	= $this -> db ->  select_one($prosql);
			$Prodetail["get_url"]= $this -> helper  -> build_url( $valid = $Prodetail["art_id"],'art');
			
			//查询下一篇
			$nextsql 	= " SELECT art_id, art_title  FROM ".$this -> db -> prefix."article WHERE  art_id > ".$id." GROUP BY art_id  ORDER BY art_id  ";
			$Nextdetail = $this -> db ->  select_one($nextsql);
			$Nextdetail["get_url"]= $this -> helper  -> build_url( $valid = $Nextdetail["art_id"],'art');
			
			$cache_id = $id.'d'.$page_num;
			
			
			$this -> view -> assign('webtitle',$webtitle);
			$this -> view -> assign('infodetail',$infodetail);
			$this -> view -> assign('page_str',$page_str);	//分页
			$this -> view -> assign('now_address',$now_address);
			$this -> view -> assign('Prodetail',$Prodetail);
			$this -> view -> assign('Nextdetail',$Nextdetail);
			$this -> view -> display('art.tpl',$cache_id);
			
		}else{
			$this -> error('404');
		}
	
	}
	
	function topic()
	{
		$id 		= trim($this -> input -> get["id"]);
		$page_num 	= $this -> input -> get["page"];
		 
		if($page_num==''){ $page_num = 1;}

		$webtitle = $this->lang['web_title'];
		
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li>';

		//左则自定义内容
		$sql_query 	= " SELECT per_id,per_column,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'art' ORDER BY `per_id`  ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		
		$this -> personal_mod -> get_column( $infoper["per_column"] );

		if( $id !='' )
		{
			$sql_query 		= "SELECT a.* ,s.sort_name  FROM  ".$this -> db -> prefix."article as a LEFT JOIN ".$this -> db -> prefix."art_sort  as s ON a.sort_id = s.sort_id WHERE  art_delete = 0 and a.art_enabled = 1  and a.art_sys_file = '".$id."' ORDER BY a.`art_id`  ";
			$infodetail 	= $this -> db -> select_one($sql_query);
			
			$infodetail['art_up_time'] 	=  date("Y-m-d",$infodetail["art_up_time"]);
			
			if($infodetail['art_id']!=''){
			$reinfodetail 	= $this -> get_content( $infodetail["art_detail"], $page = $page_num);
			
			$infodetail["art_detail"] = $this -> helper -> restrval( $reinfodetail["reInfo"]) ;

			$webtitle  		= $infodetail["art_title"];
			if($infodetail["sort_name"]!='')
			{
				$now_address = $now_address. '<li><a href="'.BASE_WEBURL.'/index.php?/article-info_list-'.$infodetail["sort_id"].'.html">'.$infodetail["sort_name"].'</a></li><li>'.$infodetail["art_title"].'</li>';
			}

			if($infodetail["art_keyword"]!='')
			{
				$infodetail["art_tag"] = $this -> expKeyword( $infodetail["art_keyword"] );
			}

			$this -> load_model('comemt'); 	//加载模型	
			
			$commentInfo = $this -> comemt_mod  -> get_comemt( $infodetail['art_id'] , $Num = 10 , $type = 'article');
			$this -> view -> assign('commentInfo',$commentInfo);

			$url = BASE_WEBURL.'/index.php?/article-topic-'.$id.'.html';
			
			$this -> load('page',$this->lang['page']);
			$page_str 	= $this -> page -> buildpage_str( $url , $page_num = $page_num , $page_size = 1 , $result_count = $reinfodetail["pageCount"]);
			
			//浏览量 + 1
			$sqlup = "UPDATE ".$this -> db -> prefix."article set art_view = art_view +1 WHERE art_sys_file = '".$id."'" ; 
			$this -> db -> query_sql($sqlup);
			
			
			//查询上一篇
			$prosql 	= "SELECT art_id, art_title  FROM ".$this -> db -> prefix."article WHERE  art_id < ".$infodetail['art_id']." GROUP BY art_id   ORDER BY art_id  DESC ";
			$Prodetail 	= $this -> db ->  select_one($prosql);
			$Prodetail["get_url"]= $this -> helper  -> build_url( $valid = $Prodetail["art_id"],'art');
			
			//查询下一篇
			$nextsql 	= "SELECT art_id, art_title  FROM ".$this -> db -> prefix."article WHERE  art_id > ".$infodetail['art_id']." GROUP BY art_id  ORDER BY art_id  ";
			$Nextdetail = $this -> db ->  select_one($nextsql);
			$Nextdetail["get_url"]= $this -> helper  -> build_url( $valid = $Nextdetail["art_id"],'art');
			
			$cache_id = $id.'d'.$page_num;
			
			
			$this -> view -> assign('webtitle',$webtitle);
			$this -> view -> assign('infodetail',$infodetail);
			$this -> view -> assign('page_str',$page_str);	//分页
			$this -> view -> assign('now_address',$now_address);
			$this -> view -> assign('Prodetail',$Prodetail);
			$this -> view -> assign('Nextdetail',$Nextdetail);
			$this -> view -> display('art.tpl',$cache_id);
			}else{
				$this -> error('404');
			}
		}else{
			$this -> error('404');
		}
	
	}

	
	
	function expKeyword( $keyval )
	{
 		$keyarray =  explode(" ", $keyval );
		$k = 0;
		$rearray = array();
		foreach((array)$keyarray  as $key => $val)
		{
			$karray = array();
			$karray = 	explode(",", $val );
			
			foreach((array)$karray as $ka => $kv)
			{
				if($kv !='' )
				{
					$restr .= "<a href='".BASE_WEBURL."/index.php?/article-list.html&type=search&keyword=".urlencode($kv)."' >".$kv."</a>&nbsp;";
				}
			}
		}
		
		return $restr; 
	}

	//分页程序
	function get_content($content, $page=1)
	{  
		$page = $page ? intval($page) : 1;
		
		$reArticle = array(  'reInfo' => array(), 'pageCount' => 1 );
		
		if(!empty($content))
		{  
			$pattern = "/<div style=\"page-break-after: always;?\">\s*<span style=\"display: none;?\">&nbsp;<\/span>\s*<\/div>/";
			$contents = preg_split($pattern, $content);  
			$reArticle['pageCount'] = count($contents); 
			($page > $reArticle['pageCount']) && $page = $reArticle['pageCount'];  
			$reArticle['reInfo'] = $contents[$page - 1];
			
		}else{
			return false;
		}
		
		return $reArticle; 
	}
	
	function act_default()
	{
		$webtitle = $this->lang['web_title'];
		
		//处理你现在的位置
		$now_address = '<li><a href="'.BASE_WEBURL.'/">'.$this->lang['home'].'</a></li><li><a href="'.BASE_WEBURL.'/index.php?/article.html">资讯中心</a></li>';
		//查询一级菜单分类数量
 
				$selet_sort = " SELECT sort_id,sort_name  FROM ".$this -> db -> prefix."art_sort WHERE  sort_parent_id = 0 and sort_id <> 1 " ;
				$sortInfo  = $this -> db ->  select_info( $selet_sort );

				foreach( (array)$sortInfo as $skey => $sval )
				{

					$info[$skey]["title"] 	= $sortval = $sval["sort_name"];
					$info[$skey]["url"] 	= BASE_WEBURL.'/index.php?/article-info_list-'.$sval["sort_id"].'.html';

					$sinid = $sval["sort_id"];



				$sql_query = " SELECT art_id, art_title ,art_small_title, art_color, art_bolder,art_up_time FROM  ".$this -> db -> prefix."article   WHERE art_sys_file ='' and  art_delete = 0 and  art_enabled = 1 and  sort_id in ( ".$sinid." )  GROUP BY  art_id ORDER BY art_up_time DESC, `art_id` LIMIT  0 , 10 ";
				$info[$skey]["Arr"] = $this -> db -> select_info($sql_query);
				
				foreach( (array)$info[$skey]["Arr"] as $keykey => $keyval )	
				{
					$styleval = '';
					if($keyval["art_bolder"]=='1')
					{
						$styleval = "font-weight:bold;";
					}
					if($keyval["art_color"]!='')
					{
						$styleval .= "color:".$keyval["art_color"];
					}
					if($styleval!=''){
						$info[$skey]["Arr"][$keykey]["art_style"] = 'style="'.$styleval.'"';
					}
					$info[$skey]["Arr"][$keykey]["art_up_time"] = date("Y-m-d",$keyval['art_up_time']);
				}
				
		}
		
		$this -> view -> assign('webtitle',$webtitle);
		$this -> view -> assign('now_address',$now_address);
		
		$this -> view -> assign('info',$info); 
		$this -> view -> display('art_index.tpl',$cache_id);
		
	}	
}

