<?php
//HC购物车类
class Cart{
    public $cart_value = null ;
    public function __construct(){
        if(!isset($_SESSION['cart'])){
            $_SESSION['cart'] = array();
        }
        return $this-> cart_value;
    }


	private function get_rowid($id='',$opts=array())
	{
		if(!empty($opts)){
			return md5($id.implode('',$opts));
		}else{
			return md5($id);
		}
	}
	
    /*
    添加商品  
	$item_data = array(
    'id'      => 'sku_123ABC',
    'num'     => 1,
    'price'   => 39.95,
    'name'    => 'T-Shirt',
    'opts' 	  => array('Size' => 'L', 'Color' => 'Red')
	);
    id - 你的商店里的每件商品都必须有一个唯一的标识符。典型的标识符是库存量单位（SKU）或者其它类似的标识符。
    num - 购买的数量。
    price - 商品的价格。
    name - 商品的名称。
    opts(是options简写) - 标识商品的任何附加属性。必须通过数组来传递。
    */

	
	public  function add_item( $item_data = array() ){
        
		if(!empty($item_data))
		{
			if(!empty($item_data['id'])){
                            $this->add_one_item( $item_data );
			}else{
				foreach($item_data as $ikey => $ival )
				{
					if($ival['id']){
                                            $this->add_one_item( $ival );
					}
				}
			}
		}else{
			return false;
		}
    }
	
	private function add_one_item($item_data=array())
	{
		if(!empty($item_data['id']) &&  $item_data['num']){
			$rowid = $this->get_rowid($item_data['id'],$item_data['opts']);
			if(array_key_exists($rowid,$_SESSION['cart'])){ //如果该商品已存在则直接加其数量
				$_SESSION['cart'][$rowid]['num'] = $_SESSION['cart'][$rowid]['num'] + 1;
			}else{
				$_SESSION['cart'][$rowid] = $item_data;
			}

		}else{
			return false;
		}
	}
 
    /*
    修改购物车中的商品数量
    int $id 商品主键
    int $num 某商品修改后的数量，即直接把某商品
    的数量改为$num
    */
    public function modNum($id,$num=1) {
        if (!isset($_SESSION['cart'][$id])) {
            return false;
        }
        $_SESSION['cart'][$id]['num'] = $num;
    }
 
    /*
    商品数量+1
    */
    public function insert_num($id,$num=1) {
        if (isset($_SESSION['cart'][$id])) {
            $_SESSION['cart'][$id]['num'] += $num;
        }
    }
 
    /*
    商品数量-1
    */
    public function decNum($id,$num=1) {
        if (isset($_SESSION['cart'][$id])) {
            $_SESSION['cart'][$id]['num'] -= $num;
        }
 
        //如果减少后，数量为0，则把这个商品删掉
        if ($_SESSION['cart'][$id]['num'] <1) {
            $this->delItem($id);
        }
    }
 
    /*
    删除商品
    */
    public function delItem($id) {
        unset($_SESSION['cart'][$id]);
    }
     
    /*
    获取单个商品
    */
    public function getItem($id) {
        return $_SESSION['cart'][$id];
    }
 
    /*
    查询购物车中商品的种类
    */
    public function getCnt() {
        return count($_SESSION['cart']);
    }
     
    /*
    查询购物车中商品的个数
    */
    public function getNum(){
        if ($this->getCnt() == 0) {
            //种数为0，个数也为0
            return 0;
        }
 
        $sum = 0;
        $data = $_SESSION['cart'];
        foreach ($data as $item) {
            $sum += $item['num'];
        }
        return $sum;
    }
 
    /*
    购物车中商品的总金额
    */
    public function getPrice() {
        //数量为0，价钱为0
        if ($this->getCnt() == 0) {
            return 0;
        }
        $price = 0.00;
        $data = $_SESSION['cart'];
        foreach ($data as $item) {
            $price += $item['num'] * $item['price'];
        }
        return sprintf("%01.2f", $price);
    }
 
    /*
    清空购物车
    */
    public function clear() {
        $_SESSION['cart'] = array();
    }
}