<?php
/***
 *----------------------------------------------------------------------------*
 *
 *@author pgmk<pgmk@hucart.com>
 *@copyright pgmk<pgmk@hucart.com>
 *@link http://www.hucart.com
 *@license The MIT License.
 *----------------------------------------------------------------------------*
**/
if (!defined('HUCART_COM')) exit('HuCart.COM No direct script access allowed');
class Index  extends HC_Controller
{
	function __construct()
	{
		parent::__construct();

		$this -> load_lang('www/index');
		$this -> load_db();
		$this -> load('helper');     	
		$this -> load_model('ads'); 		
		$this -> load_model('web_config'); 	
		$web_config = $this -> web_config_mod -> get_sys_config();
		
		$this -> set_view_dir( $web_config['temp'] -> dir );
		
		//var_dump($web_config['web_close']);
		//var_dump($web_config['web_close_val']);
		//exit();
		$this -> view -> assign('web_config', $web_config);

		$this -> view -> assign('menu_info',$this -> web_config_mod -> get_web_menu());
		$adInfo = $this -> ads_mod -> get_ads( $instr = '1,2,3,4,5,6,7,8,9,10' );
		
		//var_dump($adInfo);
		
		$this -> view -> assign('ads_info', $adInfo);
		$this -> view -> assign('user_link',$this -> session -> get_user_link( $this->lang['user_link'] ));
		
	}
	
	
	function act_default()
	{
		
		$this -> load_model('slide'); 
		$slide_info = $this->slide_mod->get_slide( 'index' );
		//var_dump( $slide_info );
		$this -> view ->assign('slide_info', $slide_info);
		
		$infoper = array();
		
		//公司简介
		$com_info = $this->com_info();
		//var_dump($com_info);
		$this -> view ->assign('com_info', $com_info);

		//产品分类信息
		$this -> load_model('pro_sort'); 
		$pro_sort_info = $this->pro_sort_mod->get_sort(7,"and prs_parent_id = 0");
		
		//var_dump($pro_sort_info);
		$this -> view ->assign('pro_sort_info', $pro_sort_info);
		
		//产品信息
		$pro_info = $this->pro_info();
		$this -> view ->assign('pro_info', $pro_info);
		
		
		$art_info = $this->art_info();
		$this -> view ->assign('art_info', $art_info);
		
		//图库分类
		$this -> load_model('pic'); 
		$pic_info = $this->pic_mod->get_pic_list();
		$this -> view ->assign('pic_info', $pic_info);
		//var_dump($pic_info);
		
		$sql_query 	= " SELECT per_id,per_main  FROM  ".$this -> db -> prefix."personal  WHERE per_type = 'index' ORDER BY `per_id`  ";	
		$infoper 	= $this -> db ->  select_one($sql_query);
		$this -> load_model('personal'); 
		$all_info = $this -> personal_mod -> get_per_item( $infoper );
		if($typeval !='' )
		{
			$cache_id = $typeval;
		}
		
		
		$this -> view ->assign('all_info', $all_info);
		
		
		$cache_id = $cache_id."index";

		$this -> view -> display('index.tpl',$cache_id);
	}


	function com_info()
	{
	
		$sql_info = " SELECT art_id,art_title ,art_description ,art_detail,art_pic  FROM  ".$this -> db -> prefix."article   WHERE art_sys_file = 'company' and art_enabled = 1 AND art_delete =0   LIMIT 1  ";
		$info = $this -> db -> select_one( $sql_info );
		$com_info = array();
		
		if ($info['art_id'] !='')
		{ 

		   		$com_info["art_title"] 				= $info["art_title"];
				if($info["art_description"]){
					$com_info["art_description"] 	= mb_substr($info["art_description"],0,200);
				}else{
					$com_info["art_description"] 	= mb_substr($info["art_detail"],0,200);
				}
				$com_info["art_pic"] 				= $info["art_pic"];
				$com_info["get_url"] 				= BASE_WEBURL.'?/company.html';	
		}
		return $com_info;
	}
	
	function art_info()
	{

		$sql = "SELECT a.art_id, a.art_title,a.art_up_time,s.sort_name FROM ".$this -> db -> prefix."article as a left join ".$this -> db -> prefix."art_sort as s on s.sort_id = a.sort_id WHERE a.art_enabled = 1 and s.sort_enabled = 1 and a.art_sys_file = '' and a.sort_id not in ( 2 ) and  a.sort_id not in ( select `sort_id` from ".$this -> db -> prefix."art_sort where sort_enabled = 2 )  GROUP BY a.art_id ORDER BY  a.art_list , a.art_up_time desc  LIMIT 10 ";
		$info 	 = $this -> db -> select_info($sql);
		
		$artInfo = array();

		foreach ((array)$info as $row)
		{
				$artInfo[$row["art_id"]]['art_id'] 		= $row["art_id"] ; 
				$artInfo[$row["art_id"]]['art_title'] 	= $row["art_title"] ;
				$artInfo[$row["art_id"]]["get_url"]		= $this -> helper  -> build_url( $valid = $row["art_id"],'art');
				$artInfo[$row["art_id"]]['art_up_time']  = date("Y-m-d",$row["art_up_time"]) ; 
		}
		
		return $artInfo;
	}

	function pro_info()
	{
		$sql = " SELECT  pro_id, pro_name, pro_img,pro_sell_price  FROM  ".$this -> db -> prefix."product  WHERE pro_delete = 0 AND pro_enabled = 1 ORDER BY  pro_up_time desc LIMIT 8";  //, paddtime 
		$info 	 = $this -> db -> select_info($sql);
		$pro_info = array();	
		foreach ((array)$info as $pkey => $row)
		{
				$pro_info[$pkey]["pro_img"]  = $this -> helper -> build_img( $row["pro_img"] ) ;
				$pro_info[$pkey]["pro_sell_price"]  =  $row["pro_sell_price"] ; 
				$pro_info[$pkey]["pro_name"] = $row["pro_name"];
				$pro_info[$pkey]["pro_id"] 	 = $row["pro_id"];
				$pro_info[$pkey]["get_url"]	 = $this -> helper  -> build_url( $valid = $row["pro_id"],'pro');
		}
		return $pro_info;
	}

}
