<?php 
class cn2tw
{
    /**
     * translate cn to tw.
     * 
     * @param  string    $content 
     * @static
     * @access public
     * @return string
     */
    public static function translate($content)
    {
        $cn2twDict = array
            (
                '它' => '牠',
                '㑇' => '㑳',
                '𪨊' => '㞞',
                '㟆' => '㠏',
                '㨫' => '㩜',
                '𫂈' => '䉬',
                '䌶' => '䊷',
                '䌺' => '䋙',
                '䌾' => '䋻',
                '𦈖' => '䌈',
                '䞍' => '䝼',
                '𩏼' => '䪏',
                '𩐀' => '䪗',
                '𩏿' => '䪘',
                '𩖗' => '䫴',
                '𩙮' => '䬘',
                '𩙯' => '䬝',
                '𩠇' => '䭀',
                '𩠈' => '䭃',
                '𩧭' => '䭿',
                '𩧰' => '䮝',
                '𩨁' => '䮞',
                '𩧿' => '䮠',
                '𩨏' => '䮳',
                '𩧪' => '䮾',
                '䯅' => '䯀',
                '鲃' => '䰾',
                '𩾈' => '䱙',
                '𩾊' => '䱬',
                '𩾋' => '䱰',
                '䲣' => '䱷',
                '䲝' => '䱽',
                '鳚' => '䲁',
                '𪉂' => '䲰',
                '𪎈' => '䴬',
                '𪎋' => '䴴',
                '丢' => '丟',
                '并' => '併',
                '干' => '榦',
                '乱' => '亂',
                '亘' => '亙',
                '亚' => '亞',
                '伫' => '佇',
                '布' => '佈',
                '占' => '佔',
                '来' => '來',
                '仑' => '崙',
                '侣' => '侶',
                '俣' => '俁',
                '系' => '繫',
                '伣' => '俔',
                '侠' => '俠',
                '伥' => '倀',
                '俩' => '倆',
                '俫' => '倈',
                '仓' => '倉',
                '个' => '箇',
                '们' => '們',
                '幸' => '倖',
                '伦' => '倫',
                '伟' => '偉',
                '侧' => '側',
                '侦' => '偵',
                '伪' => '僞',
                '杰' => '傑',
                '伧' => '傖',
                '伞' => '傘',
                '备' => '備',
                '家' => '傢',
                '佣' => '傭',
                '偬' => '傯',
                '传' => '傳',
                '伛' => '傴',
                '债' => '債',
                '伤' => '傷',
                '倾' => '傾',
                '偻' => '僂',
                '仅' => '僅',
                '佥' => '僉',
                '侨' => '僑',
                '仆' => '僕',
                '侥' => '僥',
                '偾' => '僨',
                '雇' => '僱',
                '价' => '價',
                '仪' => '儀',
                '侬' => '儂',
                '亿' => '億',
                '侩' => '儈',
                '俭' => '儉',
                '傧' => '儐',
                '俦' => '儔',
                '侪' => '儕',
                '尽' => '盡',
                '偿' => '償',
                '优' => '優',
                '储' => '儲',
                '俪' => '儷',
                '㑩' => '儸',
                '傩' => '儺',
                '傥' => '儻',
                '俨' => '儼',
                '凶' => '兇',
                '兑' => '兌',
                '儿' => '兒',
                '兖' => '兗',
                '内' => '內',
                '两' => '兩',
                '册' => '冊',
                '幂' => '冪',
                '净' => '淨',
                '冻' => '凍',
                '𪞝' => '凙',
                '凛' => '凜',
                '凯' => '凱',
                '别' => '彆',
                '删' => '刪',
                '刭' => '剄',
                '则' => '則',
                '克' => '剋',
                '刹' => '剎',
                '刬' => '剗',
                '刚' => '剛',
                '剥' => '剝',
                '剐' => '剮',
                '剀' => '剴',
                '创' => '創',
                '铲' => '鏟',
                '划' => '劃',
                '剧' => '劇',
                '刘' => '劉',
                '刽' => '劊',
                '刿' => '劌',
                '剑' => '劍',
                '㓥' => '劏',
                '剂' => '劑',
                '㔉' => '劚',
                '劲' => '勁',
                '动' => '動',
                '务' => '務',
                '勋' => '勳',
                '胜' => '勝',
                '劳' => '勞',
                '势' => '勢',
                '勚' => '勩',
                '劢' => '勱',
                '励' => '勵',
                '劝' => '勸',
                '匀' => '勻',
                '匦' => '匭',
                '汇' => '滙',
                '匮' => '匱',
                '区' => '區',
                '协' => '協',
                '却' => '卻',
                '即' => '卽',
                '厍' => '厙',
                '厕' => '廁',
                '历' => '歷',
                '厌' => '厭',
                '厉' => '厲',
                '厣' => '厴',
                '参' => '蔘',
                '叁' => '叄',
                '丛' => '叢',
                '咤' => '吒',
                '吴' => '吳',
                '呐' => '吶',
                '吕' => '呂',
                '呙' => '咼',
                '员' => '員',
                '呗' => '唄',
                '吣' => '唚',
                '问' => '問',
                '启' => '啟',
                '哑' => '啞',
                '唡' => '啢',
                '㖞' => '喎',
                '唤' => '喚',
                '丧' => '喪',
                '吃' => '喫',
                '乔' => '喬',
                '单' => '單',
                '哟' => '喲',
                '呛' => '嗆',
                '啬' => '嗇',
                '唝' => '嗊',
                '吗' => '嗎',
                '呜' => '嗚',
                '唢' => '嗩',
                '𠮶' => '嗰',
                '哔' => '嗶',
                '𪡏' => '嗹',
                '叹' => '歎',
                '喽' => '嘍',
                '呕' => '嘔',
                '啧' => '嘖',
                '尝' => '嚐',
                '唛' => '嘜',
                '哗' => '嘩',
                '唠' => '嘮',
                '啸' => '嘯',
                '叽' => '嘰',
                '哓' => '嘵',
                '呒' => '嘸',
                '啴' => '嘽',
                '恶' => '惡',
                '嘘' => '噓',
                '㖊' => '噚',
                '咝' => '噝',
                '哒' => '噠',
                '哝' => '噥',
                '哕' => '噦',
                '嗳' => '噯',
                '哙' => '噲',
                '喷' => '噴',
                '吨' => '噸',
                '当' => '當',
                '咛' => '嚀',
                '吓' => '嚇',
                '哜' => '嚌',
                '噜' => '嚕',
                '啮' => '嚙',
                '咽' => '嚥',
                '呖' => '嚦',
                '咙' => '嚨',
                '向' => '曏',
                '亸' => '嚲',
                '喾' => '嚳',
                '严' => '嚴',
                '嘤' => '嚶',
                '啭' => '囀',
                '嗫' => '囁',
                '嚣' => '囂',
                '冁' => '囅',
                '呓' => '囈',
                '苏' => '蘇',
                '嘱' => '囑',
                '囱' => '囪',
                '囵' => '圇',
                '国' => '國',
                '围' => '圍',
                '园' => '園',
                '圆' => '圓',
                '图' => '圖',
                '团' => '糰',
                '𪢮' => '圞',
                '埯' => '垵',
                '垭' => '埡',
                '采' => '採',
                '执' => '執',
                '坚' => '堅',
                '垩' => '堊',
                '垴' => '堖',
                '埚' => '堝',
                '尧' => '堯',
                '报' => '報',
                '场' => '場',
                '块' => '塊',
                '茔' => '塋',
                '垲' => '塏',
                '埘' => '塒',
                '涂' => '塗',
                '冢' => '塚',
                '坞' => '塢',
                '埙' => '塤',
                '尘' => '塵',
                '堑' => '塹',
                '垫' => '墊',
                '坠' => '墜',
                '堕' => '墮',
                '坛' => '罎',
                '坟' => '墳',
                '墙' => '牆',
                '垦' => '墾',
                '𡒄' => '壈',
                '垱' => '壋',
                '压' => '壓',
                '垒' => '壘',
                '圹' => '壙',
                '垆' => '壚',
                '坏' => '壞',
                '垄' => '壟',
                '垅' => '壠',
                '坜' => '壢',
                '坝' => '壩',
                '壮' => '壯',
                '壶' => '壺',
                '壸' => '壼',
                '寿' => '壽',
                '够' => '夠',
                '梦' => '夢',
                '伙' => '夥',
                '夹' => '夾',
                '奂' => '奐',
                '奥' => '奧',
                '奁' => '奩',
                '夺' => '奪',
                '奖' => '獎',
                '奋' => '奮',
                '姹' => '奼',
                '妆' => '妝',
                '姗' => '姍',
                '奸' => '姦',
                '娱' => '娛',
                '娄' => '婁',
                '妇' => '婦',
                '娅' => '婭',
                '娲' => '媧',
                '妫' => '嬀',
                '媪' => '媼',
                '妈' => '媽',
                '妪' => '嫗',
                '妩' => '嫵',
                '娴' => '嫻',
                '婳' => '嫿',
                '娆' => '嬈',
                '婵' => '嬋',
                '娇' => '嬌',
                '嫱' => '嬙',
                '嫒' => '嬡',
                '嬷' => '嬤',
                '嫔' => '嬪',
                '婴' => '嬰',
                '婶' => '嬸',
                '娈' => '孌',
                '孙' => '孫',
                '学' => '學',
                '孪' => '孿',
                '宫' => '宮',
                '寝' => '寢',
                '实' => '實',
                '宁' => '寧',
                '审' => '審',
                '写' => '寫',
                '宽' => '寬',
                '宠' => '寵',
                '宝' => '寶',
                '将' => '將',
                '专' => '專',
                '寻' => '尋',
                '对' => '對',
                '导' => '導',
                '尴' => '尷',
                '届' => '屆',
                '尸' => '屍',
                '屃' => '屓',
                '屉' => '屜',
                '屡' => '屢',
                '层' => '層',
                '屦' => '屨',
                '𪨗' => '屩',
                '属' => '屬',
                '冈' => '岡',
                '岘' => '峴',
                '岛' => '島',
                '峡' => '峽',
                '崃' => '崍',
                '昆' => '崑',
                '岗' => '崗',
                '峥' => '崢',
                '岽' => '崬',
                '岚' => '嵐',
                '岁' => '𡻕',
                '嵝' => '嶁',
                '崭' => '嶄',
                '岖' => '嶇',
                '嵚' => '嶔',
                '崂' => '嶗',
                '峤' => '嶠',
                '峣' => '嶢',
                '峄' => '嶧',
                '崄' => '嶮',
                '岙' => '嶴',
                '嵘' => '嶸',
                '岭' => '嶺',
                '屿' => '嶼',
                '岳' => '嶽',
                '岿' => '巋',
                '峦' => '巒',
                '巅' => '巔',
                '岩' => '巖',
                '巯' => '巰',
                '卺' => '巹',
                '帅' => '帥',
                '师' => '師',
                '帐' => '帳',
                '带' => '帶',
                '帧' => '幀',
                '帏' => '幃',
                '帼' => '幗',
                '帻' => '幘',
                '帜' => '幟',
                '币' => '幣',
                '帮' => '幫',
                '帱' => '幬',
                '么' => '麽',
                '几' => '幾',
                '库' => '庫',
                '厢' => '廂',
                '厩' => '廄',
                '厦' => '廈',
                '厨' => '廚',
                '厮' => '廝',
                '庙' => '廟',
                '厂' => '廠',
                '庑' => '廡',
                '废' => '廢',
                '广' => '廣',
                '廪' => '廩',
                '庐' => '廬',
                '厅' => '廳',
                '弑' => '弒',
                '吊' => '弔',
                '弪' => '弳',
                '张' => '張',
                '强' => '強',
                '弹' => '彈',
                '弥' => '瀰',
                '弯' => '彎',
                '彝' => '彞',
                '彦' => '彥',
                '后' => '後',
                '径' => '徑',
                '从' => '從',
                '徕' => '徠',
                '复' => '複',
                '征' => '徵',
                '彻' => '徹',
                '恒' => '恆',
                '耻' => '恥',
                '悦' => '悅',
                '悮' => '悞',
                '怅' => '悵',
                '闷' => '悶',
                '恼' => '惱',
                '恽' => '惲',
                '恻' => '惻',
                '爱' => '愛',
                '惬' => '愜',
                '悫' => '慤',
                '怆' => '愴',
                '恺' => '愷',
                '忾' => '愾',
                '栗' => '慄',
                '态' => '態',
                '愠' => '慍',
                '惨' => '慘',
                '惭' => '慚',
                '恸' => '慟',
                '惯' => '慣',
                '怄' => '慪',
                '怂' => '慫',
                '虑' => '慮',
                '悭' => '慳',
                '庆' => '慶',
                '戚' => '鏚',
                '欲' => '慾',
                '忧' => '憂',
                '惫' => '憊',
                '怜' => '憐',
                '凭' => '憑',
                '愦' => '憒',
                '惮' => '憚',
                '愤' => '憤',
                '悯' => '憫',
                '怃' => '憮',
                '宪' => '憲',
                '忆' => '憶',
                '恳' => '懇',
                '应' => '應',
                '怿' => '懌',
                '懔' => '懍',
                '蒙' => '矇',
                '怼' => '懟',
                '懑' => '懣',
                '恹' => '懨',
                '惩' => '懲',
                '懒' => '懶',
                '怀' => '懷',
                '悬' => '懸',
                '忏' => '懺',
                '惧' => '懼',
                '慑' => '懾',
                '恋' => '戀',
                '戆' => '戇',
                '戋' => '戔',
                '戗' => '戧',
                '戬' => '戩',
                '战' => '戰',
                '戯' => '戱',
                '戏' => '戲',
                '户' => '戶',
                '抛' => '拋',
                '拼' => '拚',
                '捝' => '挩',
                '挲' => '挱',
                '挟' => '挾',
                '舍' => '捨',
                '扪' => '捫',
                '挨' => '捱',
                '卷' => '捲',
                '扫' => '掃',
                '抡' => '掄',
                '挜' => '掗',
                '挣' => '掙',
                '挂' => '掛',
                '拣' => '揀',
                '扬' => '揚',
                '换' => '換',
                '挥' => '揮',
                '损' => '損',
                '摇' => '搖',
                '捣' => '搗',
                '揾' => '搵',
                '抢' => '搶',
                '掴' => '摑',
                '掼' => '摜',
                '搂' => '摟',
                '挚' => '摯',
                '抠' => '摳',
                '抟' => '摶',
                '折' => '摺',
                '掺' => '摻',
                '捞' => '撈',
                '挦' => '撏',
                '撑' => '撐',
                '挠' => '撓',
                '㧑' => '撝',
                '挢' => '撟',
                '掸' => '撣',
                '拨' => '撥',
                '抚' => '撫',
                '扑' => '撲',
                '揿' => '撳',
                '挞' => '撻',
                '挝' => '撾',
                '捡' => '撿',
                '拥' => '擁',
                '掳' => '擄',
                '择' => '擇',
                '击' => '擊',
                '挡' => '擋',
                '㧟' => '擓',
                '担' => '擔',
                '据' => '據',
                '挤' => '擠',
                '拟' => '擬',
                '摈' => '擯',
                '拧' => '擰',
                '搁' => '擱',
                '掷' => '擲',
                '扩' => '擴',
                '撷' => '擷',
                '摆' => '擺',
                '擞' => '擻',
                '撸' => '擼',
                '扰' => '擾',
                '摅' => '攄',
                '撵' => '攆',
                '拢' => '攏',
                '拦' => '攔',
                '撄' => '攖',
                '搀' => '攙',
                '撺' => '攛',
                '携' => '攜',
                '摄' => '攝',
                '攒' => '攢',
                '挛' => '攣',
                '摊' => '攤',
                '搅' => '攪',
                '揽' => '攬',
                '败' => '敗',
                '叙' => '敘',
                '敌' => '敵',
                '数' => '數',
                '敛' => '斂',
                '毙' => '斃',
                '斓' => '斕',
                '斩' => '斬',
                '断' => '斷',
                '于' => '於',
                '旗' => '旂',
                '既' => '旣',
                '升' => '陞',
                '时' => '時',
                '晋' => '晉',
                '昼' => '晝',
                '晕' => '暈',
                '晖' => '暉',
                '旸' => '暘',
                '畅' => '暢',
                '暂' => '暫',
                '晔' => '曄',
                '昙' => '曇',
                '晓' => '曉',
                '暧' => '曖',
                '旷' => '曠',
                '昽' => '曨',
                '晒' => '曬',
                '书' => '書',
                '会' => '會',
                '胧' => '朧',
                '术' => '術',
                '东' => '東',
                '锨' => '鍁',
                '栅' => '柵',
                '杆' => '桿',
                '栀' => '梔',
                '枧' => '梘',
                '条' => '條',
                '枭' => '梟',
                '棁' => '梲',
                '弃' => '棄',
                '棋' => '棊',
                '枨' => '棖',
                '枣' => '棗',
                '栋' => '棟',
                '' => '棡',
                '栈' => '棧',
                '栖' => '棲',
                '梾' => '棶',
                '桠' => '椏',
                '杨' => '楊',
                '枫' => '楓',
                '桢' => '楨',
                '业' => '業',
                '极' => '極',
                '杩' => '榪',
                '荣' => '榮',
                '榅' => '榲',
                '桤' => '榿',
                '构' => '構',
                '枪' => '槍',
                '杠' => '槓',
                '梿' => '槤',
                '椠' => '槧',
                '椁' => '槨',
                '桨' => '槳',
                '桩' => '樁',
                '乐' => '樂',
                '枞' => '樅',
                '梁' => '樑',
                '楼' => '樓',
                '标' => '標',
                '枢' => '樞',
                '样' => '樣',
                '朴' => '樸',
                '树' => '樹',
                '桦' => '樺',
                '桡' => '橈',
                '桥' => '橋',
                '机' => '機',
                '椭' => '橢',
                '横' => '橫',
                '檩' => '檁',
                '柽' => '檉',
                '档' => '檔',
                '桧' => '檜',
                '槚' => '檟',
                '检' => '檢',
                '樯' => '檣',
                '梼' => '檮',
                '台' => '颱',
                '槟' => '檳',
                '柠' => '檸',
                '槛' => '檻',
                '柜' => '櫃',
                '橹' => '櫓',
                '榈' => '櫚',
                '栉' => '櫛',
                '椟' => '櫝',
                '橼' => '櫞',
                '栎' => '櫟',
                '橱' => '櫥',
                '槠' => '櫧',
                '栌' => '櫨',
                '枥' => '櫪',
                '橥' => '櫫',
                '榇' => '櫬',
                '蘖' => '櫱',
                '栊' => '櫳',
                '榉' => '欅',
                '樱' => '櫻',
                '栏' => '欄',
                '权' => '權',
                '椤' => '欏',
                '栾' => '欒',
                '榄' => '欖',
                '棂' => '欞',
                '钦' => '欽',
                '欧' => '歐',
                '欤' => '歟',
                '欢' => '歡',
                '归' => '歸',
                '殁' => '歿',
                '残' => '殘',
                '殒' => '殞',
                '殇' => '殤',
                '㱮' => '殨',
                '殚' => '殫',
                '僵' => '殭',
                '殓' => '殮',
                '殡' => '殯',
                '㱩' => '殰',
                '歼' => '殲',
                '杀' => '殺',
                '壳' => '殼',
                '毁' => '譭',
                '殴' => '毆',
                '毵' => '毿',
                '牦' => '氂',
                '毡' => '氈',
                '氇' => '氌',
                '气' => '氣',
                '氢' => '氫',
                '氩' => '氬',
                '氲' => '氳',
                '污' => '汙',
                '决' => '決',
                '没' => '沒',
                '冲' => '衝',
                '况' => '況',
                '溯' => '遡',
                '泄' => '洩',
                '汹' => '洶',
                '浃' => '浹',
                '泾' => '涇',
                '凉' => '涼',
                '凄' => '淒',
                '泪' => '淚',
                '渌' => '淥',
                '凌' => '淩',
                '沦' => '淪',
                '渊' => '淵',
                '涞' => '淶',
                '浅' => '淺',
                '涣' => '渙',
                '减' => '減',
                '涡' => '渦',
                '测' => '測',
                '浑' => '渾',
                '凑' => '湊',
                '浈' => '湞',
                '涌' => '湧',
                '汤' => '湯',
                '沩' => '潙',
                '准' => '準',
                '沟' => '溝',
                '温' => '溫',
                '沧' => '滄',
                '灭' => '滅',
                '涤' => '滌',
                '荥' => '滎',
                '沪' => '滬',
                '滞' => '滯',
                '渗' => '滲',
                '卤' => '鹵',
                '浒' => '滸',
                '浐' => '滻',
                '滚' => '滾',
                '满' => '滿',
                '渔' => '漁',
                '沤' => '漚',
                '汉' => '漢',
                '涟' => '漣',
                '渍' => '漬',
                '涨' => '漲',
                '溆' => '漵',
                '渐' => '漸',
                '浆' => '漿',
                '颍' => '潁',
                '泼' => '潑',
                '洁' => '潔',
                '潜' => '潛',
                '润' => '潤',
                '浔' => '潯',
                '溃' => '潰',
                '滗' => '潷',
                '涠' => '潿',
                '涩' => '澀',
                '浇' => '澆',
                '涝' => '澇',
                '沄' => '澐',
                '涧' => '澗',
                '渑' => '澠',
                '泽' => '澤',
                '滪' => '澦',
                '泶' => '澩',
                '浍' => '澮',
                '淀' => '澱',
                '㳠' => '澾',
                '浊' => '濁',
                '浓' => '濃',
                '湿' => '濕',
                '泞' => '濘',
                '济' => '濟',
                '涛' => '濤',
                '滥' => '濫',
                '潍' => '濰',
                '滨' => '濱',
                '溅' => '濺',
                '泺' => '濼',
                '滤' => '濾',
                '滢' => '瀅',
                '渎' => '瀆',
                '㲿' => '瀇',
                '泻' => '瀉',
                '沈' => '瀋',
                '浏' => '瀏',
                '濒' => '瀕',
                '泸' => '瀘',
                '沥' => '瀝',
                '潇' => '瀟',
                '潆' => '瀠',
                '潴' => '瀦',
                '泷' => '瀧',
                '濑' => '瀨',
                '潋' => '瀲',
                '澜' => '瀾',
                '沣' => '灃',
                '滠' => '灄',
                '洒' => '灑',
                '漓' => '灕',
                '滩' => '灘',
                '灏' => '灝',
                '漤' => '灠',
                '湾' => '灣',
                '滦' => '灤',
                '滟' => '灧',
                '灾' => '災',
                '为' => '爲',
                '乌' => '烏',
                '烃' => '烴',
                '无' => '無',
                '炼' => '鍊',
                '炜' => '煒',
                '烟' => '煙',
                '茕' => '煢',
                '焕' => '煥',
                '烦' => '煩',
                '炀' => '煬',
                '㶽' => '煱',
                '煴' => '熅',
                '荧' => '熒',
                '炝' => '熗',
                '热' => '熱',
                '颎' => '熲',
                '炽' => '熾',
                '烨' => '燁',
                '灯' => '燈',
                '炖' => '燉',
                '烧' => '燒',
                '烫' => '燙',
                '焖' => '燜',
                '营' => '營',
                '灿' => '燦',
                '烛' => '燭',
                '烩' => '燴',
                '㶶' => '燶',
                '烬' => '燼',
                '焘' => '燾',
                '烁' => '爍',
                '炉' => '爐',
                '烂' => '爛',
                '争' => '爭',
                '爷' => '爺',
                '尔' => '爾',
                '牍' => '牘',
                '牵' => '牽',
                '荦' => '犖',
                '犊' => '犢',
                '牺' => '犧',
                '状' => '狀',
                '狭' => '狹',
                '狈' => '狽',
                '狰' => '猙',
                '犹' => '猶',
                '狲' => '猻',
                '犸' => '獁',
                '呆' => '獃',
                '狱' => '獄',
                '狮' => '獅',
                '独' => '獨',
                '狯' => '獪',
                '猃' => '獫',
                '狝' => '獮',
                '狞' => '獰',
                '㺍' => '獱',
                '获' => '穫',
                '猎' => '獵',
                '犷' => '獷',
                '兽' => '獸',
                '獭' => '獺',
                '献' => '獻',
                '猕' => '獼',
                '猡' => '玀',
                '现' => '現',
                '珐' => '琺',
                '珲' => '琿',
                '玮' => '瑋',
                '玚' => '瑒',
                '琐' => '瑣',
                '瑶' => '瑤',
                '莹' => '瑩',
                '玛' => '瑪',
                '玱' => '瑲',
                '𪻐' => '瑽',
                '琏' => '璉',
                '玑' => '璣',
                '瑷' => '璦',
                '珰' => '璫',
                '环' => '環',
                '玺' => '璽',
                '琼' => '瓊',
                '珑' => '瓏',
                '璎' => '瓔',
                '瓒' => '瓚',
                '瓯' => '甌',
                '瓮' => '甕',
                '产' => '産',
                '亩' => '畝',
                '毕' => '畢',
                '画' => '畵',
                '异' => '異',
                '畴' => '疇',
                '叠' => '疊',
                '痉' => '痙',
                '酸' => '痠',
                '疴' => '痾',
                '痖' => '瘂',
                '疯' => '瘋',
                '疡' => '瘍',
                '痪' => '瘓',
                '瘗' => '瘞',
                '疮' => '瘡',
                '疟' => '瘧',
                '瘆' => '瘮',
                '疭' => '瘲',
                '瘘' => '瘻',
                '疗' => '療',
                '痨' => '癆',
                '痫' => '癇',
                '瘅' => '癉',
                '愈' => '癒',
                '疠' => '癘',
                '瘪' => '癟',
                '痴' => '癡',
                '痒' => '癢',
                '疖' => '癤',
                '症' => '癥',
                '疬' => '癧',
                '癞' => '癩',
                '癣' => '癬',
                '瘿' => '癭',
                '瘾' => '癮',
                '痈' => '癰',
                '瘫' => '癱',
                '癫' => '癲',
                '发' => '髮',
                '皑' => '皚',
                '疱' => '皰',
                '皲' => '皸',
                '皱' => '皺',
                '杯' => '盃',
                '盗' => '盜',
                '盏' => '盞',
                '监' => '監',
                '盘' => '盤',
                '卢' => '盧',
                '荡' => '蕩',
                '眦' => '眥',
                '众' => '衆',
                '𪾢' => '睍',
                '困' => '睏',
                '睁' => '睜',
                '睐' => '睞',
                '眍' => '瞘',
                '䁖' => '瞜',
                '瞒' => '瞞',
                '了' => '瞭',
                '瞆' => '瞶',
                '睑' => '瞼',
                '眬' => '矓',
                '瞩' => '矚',
                '矫' => '矯',
                '朱' => '硃',
                '硁' => '硜',
                '硖' => '硤',
                '砗' => '硨',
                '砚' => '硯',
                '埼' => '碕',
                '硕' => '碩',
                '砀' => '碭',
                '砜' => '碸',
                '确' => '確',
                '码' => '碼',
                '硙' => '磑',
                '砖' => '磚',
                '碜' => '磣',
                '碛' => '磧',
                '矶' => '磯',
                '硗' => '磽',
                '硷' => '礆',
                '础' => '礎',
                '碍' => '礙',
                '矿' => '礦',
                '砺' => '礪',
                '砾' => '礫',
                '矾' => '礬',
                '砻' => '礱',
                '算' => '祘',
                '禄' => '祿',
                '祸' => '禍',
                '祯' => '禎',
                '祎' => '禕',
                '祃' => '禡',
                '御' => '禦',
                '禅' => '禪',
                '礼' => '禮',
                '祢' => '禰',
                '祷' => '禱',
                '秃' => '禿',
                '籼' => '秈',
                '税' => '稅',
                '秆' => '稈',
                '䅉' => '稏',
                '棱' => '稜',
                '禀' => '稟',
                '种' => '種',
                '称' => '稱',
                '谷' => '穀',
                '稣' => '穌',
                '积' => '積',
                '颖' => '穎',
                '秾' => '穠',
                '穑' => '穡',
                '秽' => '穢',
                '稳' => '穩',
                '稆' => '穭',
                '窝' => '窩',
                '洼' => '窪',
                '穷' => '窮',
                '窑' => '窯',
                '窎' => '窵',
                '窭' => '窶',
                '窥' => '窺',
                '窜' => '竄',
                '窍' => '竅',
                '窦' => '竇',
                '灶' => '竈',
                '窃' => '竊',
                '竖' => '豎',
                '竞' => '競',
                '笔' => '筆',
                '笋' => '筍',
                '笕' => '筧',
                '䇲' => '筴',
                '笺' => '箋',
                '筝' => '箏',
                '节' => '節',
                '范' => '範',
                '筑' => '築',
                '箧' => '篋',
                '筼' => '篔',
                '笃' => '篤',
                '筛' => '篩',
                '筚' => '篳',
                '箦' => '簀',
                '篓' => '簍',
                '蓑' => '簑',
                '箪' => '簞',
                '简' => '簡',
                '篑' => '簣',
                '箫' => '簫',
                '筜' => '簹',
                '签' => '籤',
                '帘' => '簾',
                '篮' => '籃',
                '筹' => '籌',
                '箓' => '籙',
                '箨' => '籜',
                '籁' => '籟',
                '笼' => '籠',
                '笾' => '籩',
                '簖' => '籪',
                '篱' => '籬',
                '箩' => '籮',
                '吁' => '籲',
                '粤' => '粵',
                '糁' => '糝',
                '粪' => '糞',
                '粮' => '糧',
                '粝' => '糲',
                '籴' => '糴',
                '粜' => '糶',
                '纟' => '糹',
                '纠' => '糾',
                '纪' => '紀',
                '纣' => '紂',
                '约' => '約',
                '红' => '紅',
                '纡' => '紆',
                '纥' => '紇',
                '纨' => '紈',
                '纫' => '紉',
                '纹' => '紋',
                '纳' => '納',
                '纽' => '紐',
                '纾' => '紓',
                '纯' => '純',
                '纰' => '紕',
                '纼' => '紖',
                '纱' => '紗',
                '纮' => '紘',
                '纸' => '紙',
                '级' => '級',
                '纷' => '紛',
                '纭' => '紜',
                '纴' => '紝',
                '纺' => '紡',
                '䌷' => '紬',
                '扎' => '紮',
                '细' => '細',
                '绂' => '紱',
                '绁' => '紲',
                '绅' => '紳',
                '纻' => '紵',
                '绍' => '紹',
                '绀' => '紺',
                '绋' => '紼',
                '绐' => '紿',
                '绌' => '絀',
                '终' => '終',
                '组' => '組',
                '䌹' => '絅',
                '绊' => '絆',
                '绗' => '絎',
                '结' => '結',
                '绝' => '絶',
                '绦' => '縧',
                '绔' => '絝',
                '绞' => '絞',
                '络' => '絡',
                '绚' => '絢',
                '给' => '給',
                '绒' => '絨',
                '绖' => '絰',
                '统' => '統',
                '丝' => '絲',
                '绛' => '絳',
                '绢' => '絹',
                '𫄨' => '絺',
                '绑' => '綁',
                '绡' => '綃',
                '绠' => '綆',
                '绨' => '綈',
                '绣' => '繡',
                '绤' => '綌',
                '绥' => '綏',
                '䌼' => '綐',
                '经' => '經',
                '综' => '綜',
                '缍' => '綞',
                '绿' => '緑',
                '绸' => '綢',
                '绻' => '綣',
                '线' => '線',
                '绶' => '綬',
                '维' => '維',
                '绹' => '綯',
                '绾' => '綰',
                '纲' => '綱',
                '网' => '網',
                '绷' => '繃',
                '缀' => '綴',
                '彩' => '綵',
                '纶' => '綸',
                '绺' => '綹',
                '绮' => '綺',
                '绽' => '綻',
                '绰' => '綽',
                '绫' => '綾',
                '绵' => '綿',
                '绲' => '緄',
                '缁' => '緇',
                '紧' => '緊',
                '绯' => '緋',
                '绪' => '緒',
                '绬' => '緓',
                '绱' => '鞝',
                '缃' => '緗',
                '缄' => '緘',
                '缂' => '緙',
                '缉' => '緝',
                '缎' => '緞',
                '缔' => '締',
                '缗' => '緡',
                '缘' => '緣',
                '缌' => '緦',
                '编' => '編',
                '缓' => '緩',
                '缅' => '緬',
                '纬' => '緯',
                '缑' => '緱',
                '缈' => '緲',
                '练' => '練',
                '缏' => '緶',
                '缇' => '緹',
                '致' => '緻',
                '萦' => '縈',
                '缙' => '縉',
                '缢' => '縊',
                '缒' => '縋',
                '绉' => '縐',
                '缣' => '縑',
                '缊' => '縕',
                '缞' => '縗',
                '缚' => '縛',
                '缜' => '縝',
                '缟' => '縞',
                '缛' => '縟',
                '县' => '縣',
                '缝' => '縫',
                '缡' => '縭',
                '缩' => '縮',
                '纵' => '縱',
                '缧' => '縲',
                '䌸' => '縳',
                '纤' => '纖',
                '缦' => '縵',
                '絷' => '縶',
                '缕' => '縷',
                '缥' => '縹',
                '总' => '總',
                '绩' => '績',
                '缫' => '繅',
                '缪' => '繆',
                '穗' => '繐',
                '缯' => '繒',
                '织' => '織',
                '缮' => '繕',
                '缭' => '繚',
                '绕' => '繞',
                '缋' => '繢',
                '绳' => '繩',
                '绘' => '繪',
                '茧' => '繭',
                '缰' => '韁',
                '缳' => '繯',
                '缲' => '繰',
                '缴' => '繳',
                '䍁' => '繸',
                '绎' => '繹',
                '继' => '繼',
                '缤' => '繽',
                '缱' => '繾',
                '䍀' => '繿',
                '𫄸' => '纁',
                '缬' => '纈',
                '纩' => '纊',
                '续' => '續',
                '累' => '纍',
                '缠' => '纏',
                '缨' => '纓',
                '才' => '纔',
                '缵' => '纘',
                '缆' => '纜',
                '钵' => '鉢',
                '罂' => '罌',
                '罚' => '罰',
                '骂' => '駡',
                '罢' => '罷',
                '罗' => '羅',
                '罴' => '羆',
                '羁' => '羈',
                '芈' => '羋',
                '羟' => '羥',
                '羡' => '羨',
                '义' => '義',
                '习' => '習',
                '翘' => '翹',
                '耧' => '耬',
                '耢' => '耮',
                '圣' => '聖',
                '闻' => '聞',
                '联' => '聯',
                '聪' => '聰',
                '声' => '聲',
                '耸' => '聳',
                '聩' => '聵',
                '聂' => '聶',
                '职' => '職',
                '聍' => '聹',
                '听' => '聽',
                '聋' => '聾',
                '肃' => '肅',
                '胁' => '脅',
                '脉' => '脈',
                '胫' => '脛',
                '唇' => '脣',
                '脱' => '脫',
                '胀' => '脹',
                '肾' => '腎',
                '胨' => '腖',
                '脶' => '腡',
                '脑' => '腦',
                '肿' => '腫',
                '脚' => '腳',
                '肠' => '腸',
                '腽' => '膃',
                '肤' => '膚',
                '胶' => '膠',
                '腻' => '膩',
                '胆' => '膽',
                '脍' => '膾',
                '脓' => '膿',
                '脸' => '臉',
                '脐' => '臍',
                '膑' => '臏',
                '腊' => '臘',
                '胪' => '臚',
                '脏' => '髒',
                '脔' => '臠',
                '臜' => '臢',
                '卧' => '臥',
                '临' => '臨',
                '与' => '與',
                '兴' => '興',
                '举' => '舉',
                '旧' => '舊',
                '馆' => '館',
                '舱' => '艙',
                '舣' => '艤',
                '舰' => '艦',
                '舻' => '艫',
                '艰' => '艱',
                '艳' => '豔',
                '刍' => '芻',
                '苎' => '苧',
                '兹' => '茲',
                '荆' => '荊',
                '庄' => '莊',
                '茎' => '莖',
                '荚' => '莢',
                '苋' => '莧',
                '华' => '華',
                '庵' => '菴',
                '苌' => '萇',
                '莱' => '萊',
                '万' => '萬',
                '莴' => '萵',
                '叶' => '葉',
                '荭' => '葒',
                '荮' => '葤',
                '苇' => '葦',
                '药' => '藥',
                '荤' => '葷',
                '莼' => '蓴',
                '莳' => '蒔',
                '莅' => '蒞',
                '苍' => '蒼',
                '荪' => '蓀',
                '盖' => '蓋',
                '莲' => '蓮',
                '苁' => '蓯',
                '荜' => '蓽',
                '卜' => '蔔',
                '蒌' => '蔞',
                '蒋' => '蔣',
                '葱' => '蔥',
                '茑' => '蔦',
                '荫' => '蔭',
                '荨' => '蕁',
                '蒇' => '蕆',
                '荞' => '蕎',
                '荬' => '蕒',
                '芸' => '蕓',
                '莸' => '蕕',
                '荛' => '蕘',
                '蒉' => '蕢',
                '芜' => '蕪',
                '萧' => '蕭',
                '蓣' => '蕷',
                '蕰' => '薀',
                '荟' => '薈',
                '蓟' => '薊',
                '芗' => '薌',
                '姜' => '薑',
                '蔷' => '薔',
                '荙' => '薘',
                '莶' => '薟',
                '荐' => '薦',
                '萨' => '薩',
                '䓕' => '薳',
                '苧' => '薴',
                '荠' => '薺',
                '蓝' => '藍',
                '荩' => '藎',
                '艺' => '藝',
                '薮' => '藪',
                '蕴' => '蘊',
                '苈' => '藶',
                '蔼' => '藹',
                '蔺' => '藺',
                '蕲' => '蘄',
                '芦' => '蘆',
                '苹' => '蘋',
                '藓' => '蘚',
                '蔹' => '蘞',
                '茏' => '蘢',
                '兰' => '蘭',
                '蓠' => '蘺',
                '萝' => '蘿',
                '蔂' => '虆',
                '处' => '處',
                '虚' => '虛',
                '虏' => '虜',
                '号' => '號',
                '亏' => '虧',
                '虬' => '虯',
                '蛱' => '蛺',
                '蜕' => '蛻',
                '蚬' => '蜆',
                '蚀' => '蝕',
                '猬' => '蝟',
                '虾' => '蝦',
                '蜗' => '蝸',
                '蛳' => '螄',
                '蚂' => '螞',
                '萤' => '螢',
                '䗖' => '螮',
                '蝼' => '螻',
                '螀' => '螿',
                '蛰' => '蟄',
                '蝈' => '蟈',
                '螨' => '蟎',
                '虮' => '蟣',
                '蝉' => '蟬',
                '蛲' => '蟯',
                '虫' => '蟲',
                '蛏' => '蟶',
                '蚁' => '蟻',
                '蝇' => '蠅',
                '虿' => '蠆',
                '蝎' => '蠍',
                '蛴' => '蠐',
                '蝾' => '蠑',
                '蜡' => '蠟',
                '蛎' => '蠣',
                '蟏' => '蠨',
                '蛊' => '蠱',
                '蚕' => '蠶',
                '蛮' => '蠻',
                '蔑' => '衊',
                '同' => '衕',
                '胡' => '鬍',
                '卫' => '衛',
                '只' => '隻',
                '衮' => '袞',
                '袅' => '裊',
                '里' => '裡',
                '补' => '補',
                '装' => '裝',
                '制' => '製',
                '裈' => '褌',
                '袆' => '褘',
                '裤' => '褲',
                '裢' => '褳',
                '褛' => '褸',
                '亵' => '褻',
                '𫌀' => '襀',
                '幞' => '襆',
                '裥' => '襇',
                '袯' => '襏',
                '袄' => '襖',
                '裣' => '襝',
                '裆' => '襠',
                '褴' => '襤',
                '袜' => '襪',
                '䙓' => '襬',
                '衬' => '襯',
                '袭' => '襲',
                '见' => '見',
                '觃' => '覎',
                '规' => '規',
                '觅' => '覓',
                '视' => '視',
                '觇' => '覘',
                '觋' => '覡',
                '觍' => '覥',
                '觎' => '覦',
                '亲' => '親',
                '觊' => '覬',
                '觏' => '覯',
                '觐' => '覲',
                '觑' => '覷',
                '觉' => '覺',
                '𫌨' => '覼',
                '览' => '覽',
                '觌' => '覿',
                '观' => '觀',
                '觞' => '觴',
                '觯' => '觶',
                '触' => '觸',
                '讠' => '訁',
                '订' => '訂',
                '讣' => '訃',
                '计' => '計',
                '讯' => '訊',
                '讧' => '訌',
                '讨' => '討',
                '讦' => '訐',
                '𫍙' => '訑',
                '讱' => '訒',
                '训' => '訓',
                '讪' => '訕',
                '讫' => '訖',
                '托' => '託',
                '记' => '記',
                '讹' => '訛',
                '讶' => '訝',
                '讼' => '訟',
                '䜣' => '訢',
                '诀' => '訣',
                '讷' => '訥',
                '讻' => '訩',
                '访' => '訪',
                '设' => '設',
                '许' => '許',
                '诉' => '訴',
                '诃' => '訶',
                '诊' => '診',
                '注' => '註',
                '诂' => '詁',
                '诋' => '詆',
                '讵' => '詎',
                '诈' => '詐',
                '诒' => '詒',
                '诏' => '詔',
                '评' => '評',
                '诐' => '詖',
                '诇' => '詗',
                '诎' => '詘',
                '诅' => '詛',
                '词' => '詞',
                '咏' => '詠',
                '诩' => '詡',
                '询' => '詢',
                '诣' => '詣',
                '试' => '試',
                '诗' => '詩',
                '诧' => '詫',
                '诟' => '詬',
                '诡' => '詭',
                '诠' => '詮',
                '诘' => '詰',
                '话' => '話',
                '该' => '該',
                '详' => '詳',
                '诜' => '詵',
                '诙' => '詼',
                '诖' => '詿',
                '诔' => '誄',
                '诛' => '誅',
                '诓' => '誆',
                '夸' => '誇',
                '志' => '誌',
                '认' => '認',
                '诳' => '誑',
                '诶' => '誒',
                '诞' => '誕',
                '诱' => '誘',
                '诮' => '誚',
                '语' => '語',
                '诚' => '誠',
                '诫' => '誡',
                '诬' => '誣',
                '误' => '誤',
                '诰' => '誥',
                '诵' => '誦',
                '诲' => '誨',
                '说' => '説',
                '谁' => '誰',
                '课' => '課',
                '谇' => '誶',
                '诽' => '誹',
                '谊' => '誼',
                '訚' => '誾',
                '调' => '調',
                '谄' => '諂',
                '谆' => '諄',
                '谈' => '談',
                '诿' => '諉',
                '请' => '請',
                '诤' => '諍',
                '诹' => '諏',
                '诼' => '諑',
                '谅' => '諒',
                '论' => '論',
                '谂' => '諗',
                '谀' => '諛',
                '谍' => '諜',
                '谞' => '諝',
                '谝' => '諞',
                '诨' => '諢',
                '谔' => '諤',
                '谛' => '諦',
                '谐' => '諧',
                '谏' => '諫',
                '谕' => '諭',
                '咨' => '諮',
                '𫍰' => '諰',
                '讳' => '諱',
                '谙' => '諳',
                '谌' => '諶',
                '讽' => '諷',
                '诸' => '諸',
                '谚' => '諺',
                '谖' => '諼',
                '诺' => '諾',
                '谋' => '謀',
                '谒' => '謁',
                '谓' => '謂',
                '誊' => '謄',
                '诌' => '謅',
                '谎' => '謊',
                '谜' => '謎',
                '𫍲' => '謏',
                '谧' => '謐',
                '谑' => '謔',
                '谡' => '謖',
                '谤' => '謗',
                '谦' => '謙',
                '谥' => '謚',
                '讲' => '講',
                '谢' => '謝',
                '谣' => '謡',
                '谟' => '謨',
                '谪' => '謫',
                '谬' => '謬',
                '谫' => '譾',
                '讴' => '謳',
                '谨' => '謹',
                '谩' => '謾',
                '䜧' => '譅',
                '证' => '證',
                '𫍢' => '譊',
                '谲' => '譎',
                '讥' => '譏',
                '谮' => '譖',
                '识' => '識',
                '谯' => '譙',
                '谭' => '譚',
                '谱' => '譜',
                '谵' => '譫',
                '译' => '譯',
                '议' => '議',
                '谴' => '譴',
                '护' => '護',
                '诪' => '譸',
                '誉' => '譽',
                '读' => '讀',
                '变' => '變',
                '仇' => '讎',
                '谗' => '讒',
                '让' => '讓',
                '谰' => '讕',
                '谶' => '讖',
                '赞' => '贊',
                '谠' => '讜',
                '谳' => '讞',
                '岂' => '豈',
                '丰' => '豐',
                '猪' => '豬',
                '豮' => '豶',
                '猫' => '貓',
                '䝙' => '貙',
                '贝' => '貝',
                '贞' => '貞',
                '贠' => '貟',
                '负' => '負',
                '财' => '財',
                '贡' => '貢',
                '贫' => '貧',
                '货' => '貨',
                '贩' => '販',
                '贪' => '貪',
                '贯' => '貫',
                '责' => '責',
                '贮' => '貯',
                '贳' => '貰',
                '赀' => '貲',
                '贰' => '貳',
                '贵' => '貴',
                '贬' => '貶',
                '买' => '買',
                '贷' => '貸',
                '贶' => '貺',
                '费' => '費',
                '贴' => '貼',
                '贻' => '貽',
                '贸' => '貿',
                '贺' => '賀',
                '贲' => '賁',
                '赂' => '賂',
                '赁' => '賃',
                '贿' => '賄',
                '赅' => '賅',
                '资' => '資',
                '贾' => '賈',
                '贼' => '賊',
                '赈' => '賑',
                '赊' => '賒',
                '宾' => '賓',
                '赇' => '賕',
                '赒' => '賙',
                '赉' => '賚',
                '赐' => '賜',
                '赏' => '賞',
                '赔' => '賠',
                '赓' => '賡',
                '贤' => '賢',
                '卖' => '賣',
                '贱' => '賤',
                '赋' => '賦',
                '赕' => '賧',
                '质' => '質',
                '赍' => '齎',
                '账' => '賬',
                '赌' => '賭',
                '䞐' => '賰',
                '赖' => '賴',
                '赗' => '賵',
                '赚' => '賺',
                '赙' => '賻',
                '购' => '購',
                '赛' => '賽',
                '赜' => '賾',
                '贽' => '贄',
                '赘' => '贅',
                '赟' => '贇',
                '赠' => '贈',
                '赝' => '贗',
                '赡' => '贍',
                '赢' => '贏',
                '赆' => '贐',
                '赃' => '贜',
                '赑' => '贔',
                '赎' => '贖',
                '赣' => '贛',
                '赪' => '赬',
                '赶' => '趕',
                '赵' => '趙',
                '趋' => '趨',
                '趱' => '趲',
                '迹' => '跡',
                '践' => '踐',
                '踊' => '踴',
                '跄' => '蹌',
                '跸' => '蹕',
                '蹒' => '蹣',
                '踪' => '蹤',
                '跷' => '蹺',
                '𫏋' => '蹻',
                '跶' => '躂',
                '趸' => '躉',
                '踌' => '躊',
                '跻' => '躋',
                '跃' => '躍',
                '踯' => '躑',
                '跞' => '躒',
                '踬' => '躓',
                '蹰' => '躕',
                '跹' => '躚',
                '蹑' => '躡',
                '蹿' => '躥',
                '躜' => '躦',
                '躏' => '躪',
                '躯' => '軀',
                '车' => '車',
                '轧' => '軋',
                '轨' => '軌',
                '军' => '軍',
                '𫐄' => '軏',
                '轪' => '軑',
                '轩' => '軒',
                '轫' => '軔',
                '轭' => '軛',
                '软' => '軟',
                '轷' => '軤',
                '𫐉' => '軨',
                '轸' => '軫',
                '轱' => '軲',
                '轴' => '軸',
                '轵' => '軹',
                '轺' => '軺',
                '轲' => '軻',
                '轶' => '軼',
                '轼' => '軾',
                '较' => '較',
                '辂' => '輅',
                '辁' => '輇',
                '辀' => '輈',
                '载' => '載',
                '轾' => '輊',
                '辄' => '輒',
                '挽' => '輓',
                '辅' => '輔',
                '轻' => '輕',
                '𫐐' => '輗',
                '辆' => '輛',
                '辎' => '輜',
                '辉' => '輝',
                '辋' => '輞',
                '辍' => '輟',
                '辊' => '輥',
                '辇' => '輦',
                '辈' => '輩',
                '轮' => '輪',
                '辌' => '輬',
                '𫐓' => '輮',
                '辑' => '輯',
                '辏' => '輳',
                '输' => '輸',
                '辐' => '輻',
                '辗' => '輾',
                '舆' => '輿',
                '辒' => '轀',
                '毂' => '轂',
                '辖' => '轄',
                '辕' => '轅',
                '辘' => '轆',
                '转' => '轉',
                '辙' => '轍',
                '轿' => '轎',
                '辚' => '轔',
                '轰' => '轟',
                '辔' => '轡',
                '轹' => '轢',
                '𫐆' => '轣',
                '轳' => '轤',
                '办' => '辦',
                '辞' => '辭',
                '辫' => '辮',
                '辩' => '辯',
                '农' => '農',
                '回' => '迴',
                '迳' => '逕',
                '这' => '這',
                '连' => '連',
                '周' => '週',
                '进' => '進',
                '游' => '遊',
                '运' => '運',
                '过' => '過',
                '达' => '達',
                '违' => '違',
                '遥' => '遙',
                '逊' => '遜',
                '递' => '遞',
                '远' => '遠',
                '适' => '適',
                '迟' => '遲',
                '迁' => '遷',
                '选' => '選',
                '遗' => '遺',
                '辽' => '遼',
                '迈' => '邁',
                '还' => '還',
                '迩' => '邇',
                '边' => '邊',
                '逻' => '邏',
                '逦' => '邐',
                '郏' => '郟',
                '邮' => '郵',
                '郓' => '鄆',
                '乡' => '鄉',
                '邹' => '鄒',
                '邬' => '鄔',
                '郧' => '鄖',
                '邓' => '鄧',
                '郑' => '鄭',
                '邻' => '鄰',
                '郸' => '鄲',
                '邺' => '鄴',
                '郐' => '鄶',
                '邝' => '鄺',
                '酂' => '酇',
                '郦' => '酈',
                '酝' => '醞',
                '丑' => '醜',
                '糖' => '醣',
                '医' => '醫',
                '酱' => '醬',
                '酰' => '醯',
                '酦' => '醱',
                '酿' => '釀',
                '衅' => '釁',
                '酾' => '釃',
                '酽' => '釅',
                '释' => '釋',
                '厘' => '釐',
                '钅' => '釒',
                '钆' => '釓',
                '钇' => '釔',
                '钌' => '釕',
                '钊' => '釗',
                '钉' => '釘',
                '钋' => '釙',
                '针' => '針',
                '钓' => '釣',
                '钐' => '釤',
                '钏' => '釧',
                '钒' => '釩',
                '𨰿' => '釳',
                '钗' => '釵',
                '钍' => '釷',
                '钕' => '釹',
                '钎' => '釺',
                '䥺' => '釾',
                '钯' => '鈀',
                '钫' => '鈁',
                '钘' => '鈃',
                '钭' => '鈄',
                '𫓧' => '鈇',
                '钚' => '鈈',
                '钠' => '鈉',
                '𨱂' => '鈋',
                '钝' => '鈍',
                '钩' => '鉤',
                '钤' => '鈐',
                '钣' => '鈑',
                '钑' => '鈒',
                '钞' => '鈔',
                '钮' => '鈕',
                '钧' => '鈞',
                '𨱁' => '鈠',
                '钙' => '鈣',
                '钬' => '鈥',
                '钛' => '鈦',
                '钪' => '鈧',
                '铌' => '鈮',
                '𨱄' => '鈯',
                '铈' => '鈰',
                '𨱃' => '鈲',
                '钶' => '鈳',
                '铃' => '鈴',
                '钴' => '鈷',
                '钹' => '鈸',
                '铍' => '鈹',
                '钰' => '鈺',
                '钸' => '鈽',
                '铀' => '鈾',
                '钿' => '鈿',
                '钾' => '鉀',
                '𨱅' => '鉁',
                '钜' => '鉅',
                '铊' => '鉈',
                '铉' => '鉉',
                '铇' => '鉋',
                '铋' => '鉍',
                '铂' => '鉑',
                '钷' => '鉕',
                '钳' => '鉗',
                '铆' => '鉚',
                '铅' => '鉛',
                '钺' => '鉞',
                '钲' => '鉦',
                '钼' => '鉬',
                '钽' => '鉭',
                '铏' => '鉶',
                '铰' => '鉸',
                '铒' => '鉺',
                '铬' => '鉻',
                '铪' => '鉿',
                '银' => '銀',
                '铳' => '銃',
                '铜' => '銅',
                '铚' => '銍',
                '铣' => '銑',
                '铨' => '銓',
                '铢' => '銖',
                '铭' => '銘',
                '铫' => '銚',
                '铦' => '銛',
                '衔' => '銜',
                '铑' => '銠',
                '铷' => '銣',
                '铱' => '銥',
                '铟' => '銦',
                '铵' => '銨',
                '铥' => '銩',
                '铕' => '銪',
                '铯' => '銫',
                '铐' => '銬',
                '铞' => '銱',
                '锐' => '鋭',
                '𨱇' => '銶',
                '销' => '銷',
                '锈' => '鏽',
                '锑' => '銻',
                '锉' => '銼',
                '铝' => '鋁',
                '锒' => '鋃',
                '锌' => '鋅',
                '钡' => '鋇',
                '𨱈' => '鋉',
                '铤' => '鋌',
                '铗' => '鋏',
                '锋' => '鋒',
                '铻' => '鋙',
                '锊' => '鋝',
                '锓' => '鋟',
                '铘' => '鋣',
                '锄' => '鋤',
                '锃' => '鋥',
                '锔' => '鋦',
                '锇' => '鋨',
                '铓' => '鋩',
                '铺' => '鋪',
                '铖' => '鋮',
                '锆' => '鋯',
                '锂' => '鋰',
                '铽' => '鋱',
                '锍' => '鋶',
                '锯' => '鋸',
                '钢' => '鋼',
                '锞' => '錁',
                '𨱋' => '錂',
                '录' => '録',
                '锖' => '錆',
                '锫' => '錇',
                '锩' => '錈',
                '铔' => '錏',
                '锥' => '錐',
                '锕' => '錒',
                '锟' => '錕',
                '锤' => '鎚',
                '锱' => '錙',
                '铮' => '錚',
                '锛' => '錛',
                '锬' => '錟',
                '锭' => '錠',
                '锜' => '錡',
                '钱' => '錢',
                '锦' => '錦',
                '锚' => '錨',
                '锠' => '錩',
                '锡' => '錫',
                '锢' => '錮',
                '错' => '錯',
                '锰' => '錳',
                '表' => '錶',
                '铼' => '錸',
                '锝' => '鍀',
                '锪' => '鍃',
                '𨱉' => '鍄',
                '钔' => '鍆',
                '锴' => '鍇',
                '锳' => '鍈',
                '锅' => '鍋',
                '镀' => '鍍',
                '锷' => '鍔',
                '铡' => '鍘',
                '钖' => '鍚',
                '锻' => '鍛',
                '锽' => '鍠',
                '锸' => '鍤',
                '锲' => '鍥',
                '锘' => '鍩',
                '锹' => '鍬',
                '𨱎' => '鍮',
                '锾' => '鍰',
                '键' => '鍵',
                '锶' => '鍶',
                '锗' => '鍺',
                '钟' => '鐘',
                '镁' => '鎂',
                '锿' => '鎄',
                '镅' => '鎇',
                '镑' => '鎊',
                '镰' => '鐮',
                '镕' => '鎔',
                '锁' => '鎖',
                '镉' => '鎘',
                '镈' => '鎛',
                '𨱏' => '鎝',
                '镃' => '鎡',
                '钨' => '鎢',
                '蓥' => '鎣',
                '镏' => '鎦',
                '铠' => '鎧',
                '铩' => '鎩',
                '锼' => '鎪',
                '镐' => '鎬',
                '鎮' => '鎭',
                '镇' => '鎮',
                '𨱍' => '鎯',
                '镒' => '鎰',
                '镋' => '鎲',
                '镍' => '鎳',
                '镓' => '鎵',
                '𨰾' => '鎷',
                '镌' => '鐫',
                '镎' => '鎿',
                '镞' => '鏃',
                '𨱌' => '鏆',
                '镟' => '鏇',
                '链' => '鏈',
                '𨱒' => '鏉',
                '镆' => '鏌',
                '镙' => '鏍',
                '镠' => '鏐',
                '镝' => '鏑',
                '铿' => '鏗',
                '锵' => '鏘',
                '镗' => '鏜',
                '镘' => '鏝',
                '镛' => '鏞',
                '镜' => '鏡',
                '镖' => '鏢',
                '镂' => '鏤',
                '𫓩' => '鏦',
                '錾' => '鏨',
                '镚' => '鏰',
                '铧' => '鏵',
                '镤' => '鏷',
                '镪' => '鏹',
                '䥽' => '鏺',
                '铙' => '鐃',
                '铴' => '鐋',
                '𫔎' => '鐍',
                '𨱓' => '鐎',
                '𨱔' => '鐏',
                '镣' => '鐐',
                '铹' => '鐒',
                '镦' => '鐓',
                '镡' => '鐔',
                '镫' => '鐙',
                '镢' => '钁',
                '镨' => '鐠',
                '䦅' => '鐥',
                '锎' => '鐦',
                '锏' => '鐧',
                '镄' => '鐨',
                '䦃' => '鐯',
                '镯' => '鐲',
                '镭' => '鐳',
                '铁' => '鐵',
                '镮' => '鐶',
                '铎' => '鐸',
                '铛' => '鐺',
                '镱' => '鐿',
                '铸' => '鑄',
                '镬' => '鑊',
                '镔' => '鑌',
                '鉴' => '鑒',
                '镲' => '鑔',
                '锧' => '鑕',
                '镴' => '鑞',
                '铄' => '鑠',
                '镳' => '鑣',
                '镥' => '鑥',
                '镧' => '鑭',
                '钥' => '鑰',
                '镵' => '鑱',
                '镶' => '鑲',
                '镊' => '鑷',
                '镩' => '鑹',
                '锣' => '鑼',
                '钻' => '鑽',
                '銮' => '鑾',
                '凿' => '鑿',
                '旋' => '镟',
                '长' => '長',
                '门' => '門',
                '闩' => '閂',
                '闪' => '閃',
                '闫' => '閆',
                '闬' => '閈',
                '闭' => '閉',
                '开' => '開',
                '闶' => '閌',
                '𨸂' => '閍',
                '闳' => '閎',
                '闰' => '閏',
                '𨸃' => '閐',
                '闲' => '閒',
                '间' => '間',
                '闵' => '閔',
                '闸' => '閘',
                '阂' => '閡',
                '阁' => '閣',
                '合' => '閤',
                '阀' => '閥',
                '闺' => '閨',
                '闽' => '閩',
                '阃' => '閫',
                '阆' => '閬',
                '闾' => '閭',
                '阅' => '閲',
                '阊' => '閶',
                '阉' => '閹',
                '阎' => '閻',
                '阏' => '閼',
                '阍' => '閽',
                '阈' => '閾',
                '阌' => '閿',
                '阒' => '闃',
                '板' => '闆',
                '闱' => '闈',
                '阔' => '闊',
                '阕' => '闋',
                '阑' => '闌',
                '阇' => '闍',
                '阗' => '闐',
                '阘' => '闒',
                '闿' => '闓',
                '阖' => '闔',
                '阙' => '闕',
                '闯' => '闖',
                '关' => '關',
                '阚' => '闞',
                '阓' => '闠',
                '阐' => '闡',
                '辟' => '闢',
                '阛' => '闤',
                '闼' => '闥',
                '陉' => '陘',
                '陕' => '陝',
                '阵' => '陣',
                '阴' => '陰',
                '陈' => '陳',
                '陆' => '陸',
                '阳' => '陽',
                '陧' => '隉',
                '队' => '隊',
                '阶' => '階',
                '陨' => '隕',
                '际' => '際',
                '随' => '隨',
                '险' => '險',
                '隐' => '隱',
                '陇' => '隴',
                '隶' => '隸',
                '隽' => '雋',
                '虽' => '雖',
                '双' => '雙',
                '雏' => '雛',
                '杂' => '雜',
                '鸡' => '鷄',
                '离' => '離',
                '难' => '難',
                '云' => '雲',
                '电' => '電',
                '霡' => '霢',
                '雾' => '霧',
                '霁' => '霽',
                '雳' => '靂',
                '霭' => '靄',
                '灵' => '靈',
                '靓' => '靚',
                '静' => '靜',
                '腼' => '靦',
                '靥' => '靨',
                '鼗' => '鞀',
                '巩' => '鞏',
                '秋' => '鞦',
                '鞒' => '鞽',
                '鞑' => '韃',
                '千' => '韆',
                '鞯' => '韉',
                '韦' => '韋',
                '韧' => '韌',
                '韨' => '韍',
                '韩' => '韓',
                '韪' => '韙',
                '韬' => '韜',
                '鞲' => '韝',
                '韫' => '韞',
                '韵' => '韻',
                '响' => '響',
                '页' => '頁',
                '顶' => '頂',
                '顷' => '頃',
                '项' => '項',
                '顺' => '順',
                '顸' => '頇',
                '须' => '鬚',
                '顼' => '頊',
                '颂' => '頌',
                '颀' => '頎',
                '颃' => '頏',
                '预' => '預',
                '顽' => '頑',
                '颁' => '頒',
                '顿' => '頓',
                '颇' => '頗',
                '领' => '領',
                '颌' => '頜',
                '颉' => '頡',
                '颐' => '頤',
                '颏' => '頦',
                '头' => '頭',
                '颒' => '頮',
                '颊' => '頰',
                '颋' => '頲',
                '颕' => '頴',
                '颔' => '頷',
                '颈' => '頸',
                '颓' => '頽',
                '频' => '頻',
                '𩖖' => '顃',
                '颗' => '顆',
                '题' => '題',
                '额' => '額',
                '颚' => '顎',
                '颜' => '顔',
                '颙' => '顒',
                '颛' => '顓',
                '愿' => '願',
                '颡' => '顙',
                '颠' => '顛',
                '类' => '類',
                '颟' => '顢',
                '颢' => '顥',
                '顾' => '顧',
                '颤' => '顫',
                '颥' => '顬',
                '显' => '顯',
                '颦' => '顰',
                '颅' => '顱',
                '颞' => '顳',
                '颧' => '顴',
                '风' => '風',
                '飐' => '颭',
                '飑' => '颮',
                '飒' => '颯',
                '𩙥' => '颰',
                '刮' => '颳',
                '飓' => '颶',
                '𩙪' => '颷',
                '飔' => '颸',
                '飏' => '颺',
                '飖' => '颻',
                '飕' => '颼',
                '𩙫' => '颾',
                '飗' => '飀',
                '飘' => '飄',
                '飙' => '飆',
                '飚' => '飈',
                '飞' => '飛',
                '饣' => '飠',
                '饥' => '饑',
                '饤' => '飣',
                '饦' => '飥',
                '饨' => '飩',
                '饪' => '飪',
                '饫' => '飫',
                '饬' => '飭',
                '饭' => '飯',
                '飧' => '飱',
                '饮' => '飲',
                '饴' => '飴',
                '饲' => '飼',
                '饱' => '飽',
                '饰' => '飾',
                '饳' => '飿',
                '饺' => '餃',
                '饸' => '餄',
                '饼' => '餅',
                '饷' => '餉',
                '养' => '養',
                '饵' => '餌',
                '饹' => '餎',
                '饻' => '餏',
                '饽' => '餑',
                '馁' => '餒',
                '饿' => '餓',
                '𫗦' => '餔',
                '馂' => '餕',
                '饾' => '餖',
                '𫗧' => '餗',
                '余' => '餘',
                '肴' => '餚',
                '馄' => '餛',
                '馃' => '餜',
                '饯' => '餞',
                '馅' => '餡',
                '𫗠' => '餦',
                '𫗮' => '餭',
                '糇' => '餱',
                '饧' => '餳',
                '喂' => '餵',
                '馉' => '餶',
                '馇' => '餷',
                '𩠌' => '餸',
                '馎' => '餺',
                '饩' => '餼',
                '馏' => '餾',
                '馊' => '餿',
                '馌' => '饁',
                '馍' => '饃',
                '馒' => '饅',
                '馐' => '饈',
                '馑' => '饉',
                '馓' => '饊',
                '馈' => '饋',
                '馔' => '饌',
                '饶' => '饒',
                '飨' => '饗',
                '𫗴' => '饘',
                '餍' => '饜',
                '馋' => '饞',
                '馕' => '饢',
                '马' => '馬',
                '驭' => '馭',
                '冯' => '馮',
                '驮' => '馱',
                '驰' => '馳',
                '驯' => '馴',
                '驲' => '馹',
                '驳' => '駁',
                '𫘝' => '駃',
                '𩧨' => '駎',
                '驻' => '駐',
                '驽' => '駑',
                '驹' => '駒',
                '驵' => '駔',
                '驾' => '駕',
                '骀' => '駘',
                '驸' => '駙',
                '𩧫' => '駚',
                '驶' => '駛',
                '驼' => '駝',
                '驷' => '駟',
                '骈' => '駢',
                '𩧲' => '駧',
                '𩧴' => '駩',
                '骇' => '駭',
                '骃' => '駰',
                '骆' => '駱',
                '𩧺' => '駶',
                '骎' => '駸',
                '𫘣' => '駻',
                '骏' => '駿',
                '骋' => '騁',
                '骍' => '騂',
                '𫘤' => '騃',
                '骓' => '騅',
                '骔' => '騌',
                '骒' => '騍',
                '骑' => '騎',
                '骐' => '騏',
                '𩨀' => '騔',
                '骛' => '騖',
                '骗' => '騙',
                '𩨊' => '騚',
                '𩨃' => '騝',
                '𩨈' => '騟',
                '𫘨' => '騠',
                '骙' => '騤',
                '䯄' => '騧',
                '𩨄' => '騪',
                '骞' => '騫',
                '骘' => '騭',
                '骝' => '騮',
                '腾' => '騰',
                '驺' => '騶',
                '骚' => '騷',
                '骟' => '騸',
                '骡' => '騾',
                '蓦' => '驀',
                '骜' => '驁',
                '骖' => '驂',
                '骠' => '驃',
                '骢' => '驄',
                '驱' => '驅',
                '骅' => '驊',
                '𩧯' => '驋',
                '骕' => '驌',
                '骁' => '驍',
                '骣' => '驏',
                '骄' => '驕',
                '验' => '驗',
                '惊' => '驚',
                '驿' => '驛',
                '骤' => '驟',
                '驴' => '驢',
                '骧' => '驤',
                '骥' => '驥',
                '骦' => '驦',
                '骊' => '驪',
                '骉' => '驫',
                '肮' => '骯',
                '髅' => '髏',
                '体' => '體',
                '髌' => '髕',
                '髋' => '髖',
                '松' => '鬆',
                '鬓' => '鬢',
                '斗' => '鬥',
                '闹' => '鬧',
                '哄' => '鬨',
                '阋' => '鬩',
                '阄' => '鬮',
                '郁' => '鬱',
                '魉' => '魎',
                '魇' => '魘',
                '鱼' => '魚',
                '鱽' => '魛',
                '𫚉' => '魟',
                '鱾' => '魢',
                '𩽹' => '魥',
                '鲀' => '魨',
                '鲁' => '魯',
                '鲂' => '魴',
                '鱿' => '魷',
                '鲄' => '魺',
                '鲅' => '鮁',
                '鲆' => '鮃',
                '𫚒' => '鮄',
                '鲌' => '鮊',
                '鲉' => '鮋',
                '鲏' => '鮍',
                '鲇' => '鯰',
                '鲐' => '鮐',
                '鲍' => '鮑',
                '鲋' => '鮒',
                '鲊' => '鮓',
                '𩾀' => '鮕',
                '鲒' => '鮚',
                '鲘' => '鮜',
                '鲞' => '鯗',
                '鲕' => '鮞',
                '𩽾' => '鮟',
                '䲟' => '鮣',
                '鲖' => '鮦',
                '鲔' => '鮪',
                '鲛' => '鮫',
                '鲑' => '鮭',
                '鲜' => '鮮',
                '𫚔' => '鮰',
                '鲓' => '鮳',
                '鲪' => '鮶',
                '𩾃' => '鮸',
                '鲝' => '鮺',
                '鲧' => '鯀',
                '鲠' => '鯁',
                '𩾁' => '鯄',
                '𫚙' => '鯆',
                '鲩' => '鯇',
                '鲤' => '鯉',
                '鲨' => '鯊',
                '鲬' => '鯒',
                '鲻' => '鯔',
                '鲯' => '鯕',
                '鲭' => '鯖',
                '鲷' => '鯛',
                '鲴' => '鯝',
                '鲱' => '鯡',
                '鲵' => '鯢',
                '鲲' => '鯤',
                '鲳' => '鯧',
                '鲸' => '鯨',
                '鲮' => '鯪',
                '鲰' => '鯫',
                '𩾇' => '鯱',
                '鲺' => '鯴',
                '𩽼' => '鯶',
                '鳀' => '鯷',
                '鲫' => '鯽',
                '鳊' => '鯿',
                '鳈' => '鰁',
                '鲗' => '鰂',
                '鳂' => '鰃',
                '䲠' => '鰆',
                '鲽' => '鰈',
                '鳇' => '鰉',
                '䲡' => '鰌',
                '鳅' => '鰍',
                '鲾' => '鰏',
                '鳄' => '鱷',
                '鳆' => '鰒',
                '鳃' => '鰓',
                '鳒' => '鰜',
                '鳑' => '鰟',
                '鳋' => '鰠',
                '鲥' => '鰣',
                '𫚕' => '鰤',
                '鳏' => '鰥',
                '䲢' => '鰧',
                '鳎' => '鰨',
                '鳐' => '鰩',
                '鳍' => '鰭',
                '鳁' => '鰮',
                '鲢' => '鰱',
                '鳌' => '鰲',
                '鳓' => '鰳',
                '鳘' => '鰵',
                '鲦' => '鰷',
                '鲣' => '鰹',
                '鲹' => '鰺',
                '鳗' => '鰻',
                '鳛' => '鰼',
                '鳔' => '鰾',
                '鳉' => '鱂',
                '鳙' => '鱅',
                '𩾌' => '鱇',
                '鳕' => '鱈',
                '鳖' => '鱉',
                '鳟' => '鱒',
                '鳝' => '鱔',
                '鳜' => '鱖',
                '鳞' => '鱗',
                '鲟' => '鱘',
                '鲼' => '鱝',
                '鲎' => '鱟',
                '鲙' => '鱠',
                '鳣' => '鱣',
                '鳡' => '鱤',
                '鳢' => '鱧',
                '鲿' => '鱨',
                '鲚' => '鱭',
                '𫚈' => '鱮',
                '鳠' => '鱯',
                '鲈' => '鱸',
                '鲡' => '鱺',
                '鸟' => '鳥',
                '凫' => '鳬',
                '鸠' => '鳩',
                '鸤' => '鳲',
                '凤' => '鳳',
                '鸣' => '鳴',
                '鸢' => '鳶',
                '𫛛' => '鳷',
                '𪉃' => '鳼',
                '䴓' => '鳾',
                '𫛞' => '鴃',
                '鸩' => '鴆',
                '鸨' => '鴇',
                '鸦' => '鴉',
                '鸰' => '鴒',
                '鸵' => '鴕',
                '𫁡' => '鴗',
                '鸳' => '鴛',
                '𪉈' => '鴜',
                '鸲' => '鴝',
                '鸮' => '鴞',
                '鸱' => '鴟',
                '鸪' => '鴣',
                '鸯' => '鴦',
                '鸭' => '鴨',
                '鸸' => '鴯',
                '鸹' => '鴰',
                '𪉆' => '鴲',
                '鸻' => '鴴',
                '䴕' => '鴷',
                '鸿' => '鴻',
                '鸽' => '鴿',
                '䴔' => '鵁',
                '鸺' => '鵂',
                '鸼' => '鵃',
                '鹀' => '鵐',
                '鹃' => '鵑',
                '鹆' => '鵒',
                '鹁' => '鵓',
                '𪉍' => '鵚',
                '鹈' => '鵜',
                '鹅' => '鵝',
                '鹄' => '鵠',
                '鹉' => '鵡',
                '鹌' => '鵪',
                '鹏' => '鵬',
                '鹐' => '鵮',
                '鹎' => '鵯',
                '雕' => '鵰',
                '鹊' => '鵲',
                '鹓' => '鵷',
                '鹍' => '鵾',
                '䴖' => '鶄',
                '鸫' => '鶇',
                '鹑' => '鶉',
                '鹒' => '鶊',
                '𫛶' => '鶒',
                '鹋' => '鶓',
                '鹙' => '鶖',
                '𫛸' => '鶗',
                '鹕' => '鶘',
                '鹗' => '鶚',
                '鹖' => '鶡',
                '鹛' => '鶥',
                '鹜' => '鶩',
                '䴗' => '鶪',
                '鸧' => '鶬',
                '莺' => '鶯',
                '鹟' => '鶲',
                '鹤' => '鶴',
                '鹠' => '鶹',
                '鹡' => '鶺',
                '鹘' => '鶻',
                '鹣' => '鶼',
                '鹚' => '鷀',
                '鹢' => '鷁',
                '鹞' => '鷂',
                '䴘' => '鷈',
                '鹝' => '鷊',
                '鹧' => '鷓',
                '𪉑' => '鷔',
                '鹥' => '鷖',
                '鸥' => '鷗',
                '鸷' => '鷙',
                '鹨' => '鷚',
                '鸶' => '鷥',
                '鹪' => '鷦',
                '𪉊' => '鷨',
                '鹔' => '鷫',
                '鹩' => '鷯',
                '鹫' => '鷲',
                '鹇' => '鷳',
                '鹬' => '鷸',
                '鹰' => '鷹',
                '鹭' => '鷺',
                '鸴' => '鷽',
                '䴙' => '鷿',
                '㶉' => '鸂',
                '鹯' => '鸇',
                '𫛢' => '鸋',
                '鹱' => '鸌',
                '鹲' => '鸏',
                '鸬' => '鸕',
                '鹴' => '鸘',
                '鹦' => '鸚',
                '鹳' => '鸛',
                '鹂' => '鸝',
                '鸾' => '鸞',
                '咸' => '鹹',
                '鹾' => '鹺',
                '碱' => '鹼',
                '盐' => '鹽',
                '丽' => '麗',
                '麦' => '麥',
                '𪎊' => '麨',
                '麸' => '麩',
                '面' => '麵',
                '曲' => '麴',
                '𪎉' => '麲',
                '𪎌' => '麳',
                '黄' => '黃',
                '黉' => '黌',
                '点' => '點',
                '党' => '黨',
                '黪' => '黲',
                '霉' => '黴',
                '黡' => '黶',
                '黩' => '黷',
                '黾' => '黽',
                '鼋' => '黿',
                '鼍' => '鼉',
                '冬' => '鼕',
                '鼹' => '鼴',
                '齄' => '齇',
                '齐' => '齊',
                '斋' => '齋',
                '齑' => '齏',
                '齿' => '齒',
                '龀' => '齔',
                '龁' => '齕',
                '龂' => '齗',
                '龅' => '齙',
                '龇' => '齜',
                '龃' => '齟',
                '龆' => '齠',
                '龄' => '齡',
                '出' => '齣',
                '龈' => '齦',
                '龊' => '齪',
                '龉' => '齬',
                '龋' => '齲',
                '腭' => '齶',
                '龌' => '齷',
                '龙' => '龍',
                '厐' => '龎',
                '庞' => '龐',
                '龚' => '龔',
                '龛' => '龕',
                '龟' => '龜',
                '㛟' => '𡞵',
                '㛿' => '𡠹',
                '㛠' => '𡢃',
                '㻘' => '𤪺',
                '㻏' => '𤫩',
                '䑽' => '𦪙',
                '䙊' => '𧜵',
                '䘛' => '𧝞',
                '𫍟' => '𧦧',
                '䜥' => '𧩙',
                '䞌' => '𧵳',
                '䢂' => '𨋢',
                '𨱀' => '𨥛',
                '䦀' => '𨦫',
                '䦁' => '𨧜',
                '𨱊' => '𨧱',
                '𨱐' => '𨫒',
                '𨱕' => '𨮂',
                '䥿' => '𨯅',
                '𩏾' => '𩎢',
                '𩏽' => '𩏪',
                '𩖕' => '𩓣',
                '𩙦' => '𩗀',
                '𩙧' => '𩗡',
                '𩙩' => '𩘀',
                '𩙭' => '𩘝',
                '𩙨' => '𩘹',
                '𩙬' => '𩘺',
                '𩙰' => '𩙈',
                '𩠆' => '𩜦',
                '𩠋' => '𩝔',
                '䭪' => '𩞯',
                '𩠅' => '𩟐',
                '𩧦' => '𩡺',
                '𩧬' => '𩢡',
                '𩧵' => '𩢴',
                '𩧳' => '𩢸',
                '𩧮' => '𩢾',
                '𩧶' => '𩣏',
                '䯃' => '𩣑',
                '𩧻' => '𩣵',
                '𩧼' => '𩣺',
                '𩧩' => '𩤊',
                '𩨆' => '𩤙',
                '𩨉' => '𩤲',
                '𩨅' => '𩤸',
                '𩨋' => '𩥄',
                '𩨍' => '𩥇',
                '𩧱' => '𩥉',
                '𩨌' => '𩥑',
                '𩨐' => '𩧆',
                '𩽺' => '𩵩',
                '𩽻' => '𩵹',
                '䲞' => '𩶘',
                '𩽿' => '𩶰',
                '𩽽' => '𩶱',
                '𩾄' => '𩷰',
                '𩾅' => '𩸃',
                '𩾆' => '𩸦',
                '𩾎' => '𩽇',
                '𪉄' => '𩿪',
                '𪉅' => '𪀦',
                '𪉋' => '𪀾',
                '𪉉' => '𪁈',
                '𪉌' => '𪁖',
                '𪉎' => '𪂆',
                '𪉐' => '𪃍',
                '𪉏' => '𪃏',
                '𪉔' => '𪄆',
                '𪉒' => '𪄕',
                '𪉕' => '𪇳',
                '𪚏' => '𪘀',
                '𪚐' => '𪘯',
                '軿' => '𫚒',
                '《易乾' => '《易乾',
                '不着痕迹' => '不著痕跡',
                '不着边际' => '不著邊際',
                '与着' => '與著',
                '与著书' => '與著書',
                '与著作' => '與著作',
                '与著名' => '與著名',
                '与著录' => '與著錄',
                '与著称' => '與著稱',
                '与著者' => '與著者',
                '与著述' => '與著述',
                '丑着' => '丑著',
                '丑著书' => '丑著書',
                '丑著作' => '丑著作',
                '丑著名' => '丑著名',
                '丑著录' => '丑著錄',
                '丑著称' => '丑著稱',
                '丑著者' => '丑著者',
                '丑著述' => '丑著述',
                '专著' => '專著',
                '临着' => '臨著',
                '临著书' => '臨著書',
                '临著作' => '臨著作',
                '临著名' => '臨著名',
                '临著录' => '臨著錄',
                '临著称' => '臨著稱',
                '临著者' => '臨著者',
                '临著述' => '臨著述',
                '丽着' => '麗著',
                '丽著书' => '麗著書',
                '丽著作' => '麗著作',
                '丽著名' => '麗著名',
                '丽著录' => '麗著錄',
                '丽著称' => '麗著稱',
                '丽著者' => '麗著者',
                '丽著述' => '麗著述',
                '乐着' => '樂著',
                '乐著书' => '樂著書',
                '乐著作' => '樂著作',
                '乐著名' => '樂著名',
                '乐著录' => '樂著錄',
                '乐著称' => '樂著稱',
                '乐著者' => '樂著者',
                '乐著述' => '樂著述',
                '乘着' => '乘著',
                '乘著书' => '乘著書',
                '乘著作' => '乘著作',
                '乘著名' => '乘著名',
                '乘著录' => '乘著錄',
                '乘著称' => '乘著稱',
                '乘著者' => '乘著者',
                '乘著述' => '乘著述',
                '乾上乾下' => '乾上乾下',
                '乾为天' => '乾為天',
                '乾为阳' => '乾為陽',
                '乾九' => '乾九',
                '乾乾' => '乾乾',
                '乾亨' => '乾亨',
                '乾仪' => '乾仪',
                '乾位' => '乾位',
                '乾健' => '乾健',
                '乾健也' => '乾健也',
                '乾元' => '乾元',
                '乾光' => '乾光',
                '乾兴' => '乾興',
                '乾冈' => '乾岡',
                '乾刘' => '乾刘',
                '乾刚' => '乾刚',
                '乾务' => '乾务',
                '乾化' => '乾化',
                '乾卦' => '乾卦',
                '乾县' => '乾縣',
                '乾台' => '乾台',
                '乾吉' => '乾吉',
                '乾启' => '乾启',
                '乾命' => '乾命',
                '乾和' => '乾和',
                '乾嘉' => '乾嘉',
                '乾图' => '乾图',
                '乾坤' => '乾坤',
                '乾城' => '乾城',
                '乾基' => '乾基',
                '乾天也' => '乾天也',
                '乾始' => '乾始',
                '乾姓' => '乾姓',
                '乾宁' => '乾宁',
                '乾宅' => '乾宅',
                '乾宇' => '乾宇',
                '乾安' => '乾安',
                '乾定' => '乾定',
                '乾封' => '乾封',
                '乾居' => '乾居',
                '乾岗' => '乾岗',
                '乾巛' => '乾巛',
                '乾州' => '乾州',
                '乾式' => '乾式',
                '乾录' => '乾录',
                '乾律' => '乾律',
                '乾德' => '乾德',
                '乾心' => '乾心',
                '乾忠' => '乾忠',
                '乾文' => '乾文',
                '乾断' => '乾断',
                '乾方' => '乾方',
                '乾施' => '乾施',
                '乾旦' => '乾旦',
                '乾明' => '乾明',
                '乾昧' => '乾昧',
                '乾晖' => '乾晖',
                '乾景' => '乾景',
                '乾晷' => '乾晷',
                '乾曜' => '乾曜',
                '乾构' => '乾構',
                '乾枢' => '乾樞',
                '乾栋' => '乾棟',
                '乾步' => '乾步',
                '乾氏' => '乾氏',
                '乾沓和' => '乾沓和',
                '乾沓婆' => '乾沓婆',
                '乾泉' => '乾泉',
                '乾淳' => '乾淳',
                '乾清宫' => '乾清宫',
                '乾渥' => '乾渥',
                '乾灵' => '乾灵',
                '乾男' => '乾男',
                '乾皋' => '乾皋',
                '乾盛世' => '乾盛世',
                '乾矢' => '乾矢',
                '乾祐' => '乾祐',
                '乾穹' => '乾穹',
                '乾窦' => '乾窦',
                '乾竺' => '乾竺',
                '乾笃' => '乾笃',
                '乾符' => '乾符',
                '乾策' => '乾策',
                '乾精' => '乾精',
                '乾红' => '乾红',
                '乾纲' => '乾纲',
                '乾纽' => '乾紐',
                '乾络' => '乾络',
                '乾统' => '乾统',
                '乾维' => '乾维',
                '乾罗' => '乾罗',
                '乾花' => '乾花',
                '乾荫' => '乾荫',
                '乾行' => '乾行',
                '乾衡' => '乾衡',
                '乾覆' => '乾覆',
                '乾象' => '乾象',
                '乾象历' => '乾象历',
                '乾贞' => '乾貞',
                '乾贶' => '乾贶',
                '乾车' => '乾車',
                '乾轴' => '乾軸',
                '乾通' => '乾通',
                '乾造' => '乾造',
                '乾道' => '乾道',
                '乾鉴' => '乾鉴',
                '乾钧' => '乾鈞',
                '乾闼' => '乾闥',
                '乾陀' => '乾陀',
                '乾陵' => '乾陵',
                '乾隆' => '乾隆',
                '乾音' => '乾音',
                '乾顾' => '乾顧',
                '乾风' => '乾風',
                '乾首' => '乾首',
                '乾马' => '乾马',
                '乾鹄' => '乾鹄',
                '乾鹊' => '乾鹊',
                '乾龙' => '乾龙',
                '乾，健也' => '乾，健也',
                '乾，天也' => '乾，天也',
                '争着' => '爭著',
                '争著书' => '爭著書',
                '争著作' => '爭著作',
                '争著名' => '爭著名',
                '争著录' => '爭著錄',
                '争著称' => '爭著稱',
                '争著者' => '爭著者',
                '争著述' => '爭著述',
                '五箇山' => '五箇山',
                '亮着' => '亮著',
                '亮著书' => '亮著書',
                '亮著作' => '亮著作',
                '亮著名' => '亮著名',
                '亮著录' => '亮著錄',
                '亮著称' => '亮著稱',
                '亮著者' => '亮著者',
                '亮著述' => '亮著述',
                '仗着' => '仗著',
                '仗著书' => '仗著書',
                '仗著作' => '仗著作',
                '仗著名' => '仗著名',
                '仗著录' => '仗著錄',
                '仗著称' => '仗著稱',
                '仗著者' => '仗著者',
                '仗著述' => '仗著述',
                '代表着' => '代表著',
                '代表著书' => '代表著書',
                '代表著作' => '代表著作',
                '代表著名' => '代表著名',
                '代表著录' => '代表著錄',
                '代表著称' => '代表著稱',
                '代表著者' => '代表著者',
                '代表著述' => '代表著述',
                '以微知著' => '以微知著',
                '仰屋著书' => '仰屋著書',
                '仿佛' => '彷彿',
                '伙计' => '夥計',
                '传着' => '傳著',
                '传著书' => '傳著書',
                '传著作' => '傳著作',
                '传著名' => '傳著名',
                '传著录' => '傳著錄',
                '传著称' => '傳著稱',
                '传著者' => '傳著者',
                '传著述' => '傳著述',
                '伴着' => '伴著',
                '伴著书' => '伴著書',
                '伴著作' => '伴著作',
                '伴著名' => '伴著名',
                '伴著录' => '伴著錄',
                '伴著称' => '伴著稱',
                '伴著者' => '伴著者',
                '伴著述' => '伴著述',
                '低着' => '低著',
                '低著书' => '低著書',
                '低著作' => '低著作',
                '低著名' => '低著名',
                '低著录' => '低著錄',
                '低著称' => '低著稱',
                '低著者' => '低著者',
                '低著述' => '低著述',
                '住着' => '住著',
                '住著书' => '住著書',
                '住著作' => '住著作',
                '住著名' => '住著名',
                '住著录' => '住著錄',
                '住著称' => '住著稱',
                '住著者' => '住著者',
                '住著述' => '住著述',
                '佛头著粪' => '佛頭著糞',
                '侏罗纪' => '侏儸紀',
                '侧着' => '側著',
                '侧著书' => '側著書',
                '侧著作' => '側著作',
                '侧著名' => '側著名',
                '侧著录' => '側著錄',
                '侧著称' => '側著稱',
                '侧著者' => '側著者',
                '侧著述' => '側著述',
                '保护着' => '保護著',
                '保障着' => '保障著',
                '保障著书' => '保障著書',
                '保障著作' => '保障著作',
                '保障著名' => '保障著名',
                '保障著录' => '保障著錄',
                '保障著称' => '保障著稱',
                '保障著者' => '保障著者',
                '保障著述' => '保障著述',
                '信着' => '信著',
                '信著书' => '信著書',
                '信著作' => '信著作',
                '信著名' => '信著名',
                '信著录' => '信著錄',
                '信著称' => '信著稱',
                '信著者' => '信著者',
                '信著述' => '信著述',
                '候着' => '候著',
                '候著书' => '候著書',
                '候著作' => '候著作',
                '候著名' => '候著名',
                '候著录' => '候著錄',
                '候著称' => '候著稱',
                '候著者' => '候著者',
                '候著述' => '候著述',
                '借助' => '藉助',
                '借口' => '藉口',
                '借手' => '藉手',
                '借故' => '藉故',
                '借机' => '藉機',
                '借此' => '藉此',
                '借由' => '藉由',
                '借着' => '借著',
                '借端' => '藉端',
                '借著书' => '借著書',
                '借著作' => '借著作',
                '借著名' => '借著名',
                '借著录' => '借著錄',
                '借著称' => '借著稱',
                '借著者' => '借著者',
                '借著述' => '借著述',
                '借词' => '藉詞',
                '做着' => '做著',
                '做著书' => '做著書',
                '做著作' => '做著作',
                '做著名' => '做著名',
                '做著录' => '做著錄',
                '做著称' => '做著稱',
                '做著者' => '做著者',
                '做著述' => '做著述',
                '偷着' => '偷著',
                '偷著书' => '偷著書',
                '偷著作' => '偷著作',
                '偷著名' => '偷著名',
                '偷著录' => '偷著錄',
                '偷著称' => '偷著稱',
                '偷著者' => '偷著者',
                '偷著述' => '偷著述',
                '傢俬' => '傢俬',
                '光着' => '光著',
                '光著书' => '光著書',
                '光著作' => '光著作',
                '光著名' => '光著名',
                '光著录' => '光著錄',
                '光著称' => '光著稱',
                '光著者' => '光著者',
                '光著述' => '光著述',
                '关着' => '關著',
                '关著书' => '關著書',
                '关著作' => '關著作',
                '关著名' => '關著名',
                '关著录' => '關著錄',
                '关著称' => '關著稱',
                '关著者' => '關著者',
                '关著述' => '關著述',
                '冀着' => '冀著',
                '冀著书' => '冀著書',
                '冀著作' => '冀著作',
                '冀著名' => '冀著名',
                '冀著录' => '冀著錄',
                '冀著称' => '冀著稱',
                '冀著者' => '冀著者',
                '冀著述' => '冀著述',
                '冒着' => '冒著',
                '冒著书' => '冒著書',
                '冒著作' => '冒著作',
                '冒著名' => '冒著名',
                '冒著录' => '冒著錄',
                '冒著称' => '冒著稱',
                '冒著者' => '冒著者',
                '冒著述' => '冒著述',
                '写着' => '寫著',
                '写著书' => '寫著書',
                '写著作' => '寫著作',
                '写著名' => '寫著名',
                '写著录' => '寫著錄',
                '写著称' => '寫著稱',
                '写著者' => '寫著者',
                '写著述' => '寫著述',
                '凉着' => '涼著',
                '凉著书' => '涼著書',
                '凉著作' => '涼著作',
                '凉著名' => '涼著名',
                '凉著录' => '涼著錄',
                '凉著称' => '涼著稱',
                '凉著者' => '涼著者',
                '凉著述' => '涼著述',
                '凭借' => '憑藉',
                '制着' => '制著',
                '制著书' => '制著書',
                '制著作' => '制著作',
                '制著名' => '制著名',
                '制著录' => '制著錄',
                '制著称' => '制著稱',
                '制著者' => '制著者',
                '制著述' => '制著述',
                '刻着' => '刻著',
                '刻著书' => '刻著書',
                '刻著作' => '刻著作',
                '刻著名' => '刻著名',
                '刻著录' => '刻著錄',
                '刻著称' => '刻著稱',
                '刻著者' => '刻著者',
                '刻著述' => '刻著述',
                '办着' => '辦著',
                '办著书' => '辦著書',
                '办著作' => '辦著作',
                '办著名' => '辦著名',
                '办著录' => '辦著錄',
                '办著称' => '辦著稱',
                '办著者' => '辦著者',
                '办著述' => '辦著述',
                '动着' => '動著',
                '动著书' => '動著書',
                '动著作' => '動著作',
                '动著名' => '動著名',
                '动著录' => '動著錄',
                '动著称' => '動著稱',
                '动著者' => '動著者',
                '动著述' => '動著述',
                '努力着' => '努力著',
                '努力著书' => '努力著書',
                '努力著作' => '努力著作',
                '努力著名' => '努力著名',
                '努力著录' => '努力著錄',
                '努力著称' => '努力著稱',
                '努力著者' => '努力著者',
                '努力著述' => '努力著述',
                '努着' => '努著',
                '努著书' => '努著書',
                '努著作' => '努著作',
                '努著名' => '努著名',
                '努著录' => '努著錄',
                '努著称' => '努著稱',
                '努著者' => '努著者',
                '努著述' => '努著述',
                '卓著' => '卓著',
                '印着' => '印著',
                '印著书' => '印著書',
                '印著作' => '印著作',
                '印著名' => '印著名',
                '印著录' => '印著錄',
                '印著称' => '印著稱',
                '印著者' => '印著者',
                '印著述' => '印著述',
                '卷舌' => '卷舌',
                '压着' => '壓著',
                '压著书' => '壓著書',
                '压著作' => '壓著作',
                '压著名' => '壓著名',
                '压著录' => '壓著錄',
                '压著称' => '壓著稱',
                '压著者' => '壓著者',
                '压著述' => '壓著述',
                '原著' => '原著',
                '去着' => '去著',
                '去著书' => '去著書',
                '去著作' => '去著作',
                '去著名' => '去著名',
                '去著录' => '去著錄',
                '去著称' => '去著稱',
                '去著者' => '去著者',
                '去著述' => '去著述',
                '反反复复' => '反反覆覆',
                '反复' => '反覆',
                '受着' => '受著',
                '受著书' => '受著書',
                '受著作' => '受著作',
                '受著名' => '受著名',
                '受著录' => '受著錄',
                '受著称' => '受著稱',
                '受著者' => '受著者',
                '受著述' => '受著述',
                '变着' => '變著',
                '变著书' => '變著書',
                '变著作' => '變著作',
                '变著名' => '變著名',
                '变著录' => '變著錄',
                '变著称' => '變著稱',
                '变著者' => '變著者',
                '变著述' => '變著述',
                '叫着' => '叫著',
                '叫著书' => '叫著書',
                '叫著作' => '叫著作',
                '叫著名' => '叫著名',
                '叫著录' => '叫著錄',
                '叫著称' => '叫著稱',
                '叫著者' => '叫著者',
                '叫著述' => '叫著述',
                '可穿著' => '可穿著',
                '叱吒' => '叱吒',
                '吃衣著饭' => '吃衣著飯',
                '合著' => '合著',
                '名著' => '名著',
                '向着' => '向著',
                '向著书' => '向著書',
                '向著作' => '向著作',
                '向著名' => '向著名',
                '向著录' => '向著錄',
                '向著称' => '向著稱',
                '向著者' => '向著者',
                '向著述' => '向著述',
                '含着' => '含著',
                '含著书' => '含著書',
                '含著作' => '含著作',
                '含著名' => '含著名',
                '含著录' => '含著錄',
                '含著称' => '含著稱',
                '含著者' => '含著者',
                '含著述' => '含著述',
                '听着' => '聽著',
                '听著书' => '聽著書',
                '听著作' => '聽著作',
                '听著名' => '聽著名',
                '听著录' => '聽著錄',
                '听著称' => '聽著稱',
                '听著者' => '聽著者',
                '听著述' => '聽著述',
                '吴其濬' => '吳其濬',
                '吹着' => '吹著',
                '吹著书' => '吹著書',
                '吹著作' => '吹著作',
                '吹著名' => '吹著名',
                '吹著录' => '吹著錄',
                '吹著称' => '吹著稱',
                '吹著者' => '吹著者',
                '吹著述' => '吹著述',
                '周易乾' => '周易乾',
                '味着' => '味著',
                '味著书' => '味著書',
                '味著作' => '味著作',
                '味著名' => '味著名',
                '味著录' => '味著錄',
                '味著称' => '味著稱',
                '味著者' => '味著者',
                '味著述' => '味著述',
                '呼幺喝六' => '呼幺喝六',
                '响着' => '響著',
                '响著书' => '響著書',
                '响著作' => '響著作',
                '响著名' => '響著名',
                '响著录' => '響著錄',
                '响著称' => '響著稱',
                '响著者' => '響著者',
                '响著述' => '響著述',
                '哪吒' => '哪吒',
                '哭着' => '哭著',
                '哭著书' => '哭著書',
                '哭著作' => '哭著作',
                '哭著名' => '哭著名',
                '哭著录' => '哭著錄',
                '哭著称' => '哭著稱',
                '哭著者' => '哭著者',
                '哭著述' => '哭著述',
                '唱着' => '唱著',
                '唱著书' => '唱著書',
                '唱著作' => '唱著作',
                '唱著名' => '唱著名',
                '唱著录' => '唱著錄',
                '唱著称' => '唱著稱',
                '唱著者' => '唱著者',
                '唱著述' => '唱著述',
                '喝着' => '喝著',
                '喝著书' => '喝著書',
                '喝著作' => '喝著作',
                '喝著名' => '喝著名',
                '喝著录' => '喝著錄',
                '喝著称' => '喝著稱',
                '喝著者' => '喝著者',
                '喝著述' => '喝著述',
                '嚷着' => '嚷著',
                '嚷著书' => '嚷著書',
                '嚷著作' => '嚷著作',
                '嚷著名' => '嚷著名',
                '嚷著录' => '嚷著錄',
                '嚷著称' => '嚷著稱',
                '嚷著者' => '嚷著者',
                '嚷著述' => '嚷著述',
                '回复' => '回覆',
                '因着' => '因著',
                '因著〈' => '因著〈',
                '因著《' => '因著《',
                '因著书' => '因著書',
                '因著作' => '因著作',
                '因著名' => '因著名',
                '因著录' => '因著錄',
                '因著称' => '因著稱',
                '因著者' => '因著者',
                '因著述' => '因著述',
                '困着' => '困著',
                '困著书' => '困著書',
                '困著作' => '困著作',
                '困著名' => '困著名',
                '困著录' => '困著錄',
                '困著称' => '困著稱',
                '困著者' => '困著者',
                '困著述' => '困著述',
                '围着' => '圍著',
                '围著书' => '圍著書',
                '围著作' => '圍著作',
                '围著名' => '圍著名',
                '围著录' => '圍著錄',
                '围著称' => '圍著稱',
                '围著者' => '圍著者',
                '围著述' => '圍著述',
                '土著' => '土著',
                '在着' => '在著',
                '在著书' => '在著書',
                '在著作' => '在著作',
                '在著名' => '在著名',
                '在著录' => '在著錄',
                '在著称' => '在著稱',
                '在著者' => '在著者',
                '在著述' => '在著述',
                '坐着' => '坐著',
                '坐著书' => '坐著書',
                '坐著作' => '坐著作',
                '坐著名' => '坐著名',
                '坐著录' => '坐著錄',
                '坐著称' => '坐著稱',
                '坐著者' => '坐著者',
                '坐著述' => '坐著述',
                '坤乾' => '坤乾',
                '备着' => '備著',
                '备著书' => '備著書',
                '备著作' => '備著作',
                '备著名' => '備著名',
                '备著录' => '備著錄',
                '备著称' => '備著稱',
                '备著者' => '備著者',
                '备著述' => '備著述',
                '天道为乾' => '天道為乾',
                '夹着' => '夾著',
                '夹著书' => '夾著書',
                '夹著作' => '夾著作',
                '夹著名' => '夾著名',
                '夹著录' => '夾著錄',
                '夹著称' => '夾著稱',
                '夹著者' => '夾著者',
                '夹著述' => '夾著述',
                '奧区' => '奧區',
                '姓幺' => '姓幺',
                '存摺' => '存摺',
                '孤着' => '孤著',
                '孤著书' => '孤著書',
                '孤著作' => '孤著作',
                '孤著名' => '孤著名',
                '孤著录' => '孤著錄',
                '孤著称' => '孤著稱',
                '孤著者' => '孤著者',
                '孤著述' => '孤著述',
                '学着' => '學著',
                '学著书' => '學著書',
                '学著作' => '學著作',
                '学著名' => '學著名',
                '学著录' => '學著錄',
                '学著称' => '學著稱',
                '学著者' => '學著者',
                '学著述' => '學著述',
                '守着' => '守著',
                '守著书' => '守著書',
                '守著作' => '守著作',
                '守著名' => '守著名',
                '守著录' => '守著錄',
                '守著称' => '守著稱',
                '守著者' => '守著者',
                '守著述' => '守著述',
                '定着' => '定著',
                '定著书' => '定著書',
                '定著作' => '定著作',
                '定著名' => '定著名',
                '定著录' => '定著錄',
                '定著称' => '定著稱',
                '定著者' => '定著者',
                '定著述' => '定著述',
                '对着' => '對著',
                '对著书' => '對著書',
                '对著作' => '對著作',
                '对著名' => '對著名',
                '对著录' => '對著錄',
                '对著称' => '對著稱',
                '对著者' => '對著者',
                '对著述' => '對著述',
                '寻着' => '尋著',
                '寻著书' => '尋著書',
                '寻著作' => '尋著作',
                '寻著名' => '尋著名',
                '寻著录' => '尋著錄',
                '寻著称' => '尋著稱',
                '寻著者' => '尋著者',
                '寻著述' => '尋著述',
                '将军抽車' => '將軍抽車',
                '尼乾陀' => '尼乾陀',
                '展着' => '展著',
                '展著书' => '展著書',
                '展著作' => '展著作',
                '展著名' => '展著名',
                '展著录' => '展著錄',
                '展著称' => '展著稱',
                '展著者' => '展著者',
                '展著述' => '展著述',
                '巨著' => '巨著',
                '带着' => '帶著',
                '带著书' => '帶著書',
                '带著作' => '帶著作',
                '带著名' => '帶著名',
                '带著录' => '帶著錄',
                '带著称' => '帶著稱',
                '带著者' => '帶著者',
                '带著述' => '帶著述',
                '帮着' => '幫著',
                '帮著书' => '幫著書',
                '帮著作' => '幫著作',
                '帮著名' => '幫著名',
                '帮著录' => '幫著錄',
                '帮著称' => '幫著稱',
                '帮著者' => '幫著者',
                '帮著述' => '幫著述',
                '干干净净' => '乾乾淨淨',
                '干干脆脆' => '乾乾脆脆',
                '干泉水' => '乾泉水',
                '干着' => '幹著',
                '幺二三' => '幺二三',
                '幺元' => '幺元',
                '幺凤' => '么鳳',
                '幺半群' => '幺半群',
                '幺厮' => '幺厮',
                '幺叔' => '幺叔',
                '幺妈' => '幺媽',
                '幺妹' => '幺妹',
                '幺姓' => '幺姓',
                '幺姨' => '幺姨',
                '幺娘' => '幺孃',
                '幺小' => '么小',
                '幺氏' => '么氏',
                '幺爸' => '幺爸',
                '幺爹' => '么爹',
                '幺篇' => '幺篇',
                '幺舅' => '幺舅',
                '幺蛾子' => '幺蛾子',
                '幺谦' => '幺謙',
                '幺麽' => '么麼',
                '幺麽小丑' => '么麼小丑',
                '庇护着' => '庇護著',
                '应着' => '應著',
                '应著书' => '應著書',
                '应著作' => '應著作',
                '应著名' => '應著名',
                '应著录' => '應著錄',
                '应著称' => '應著稱',
                '应著者' => '應著者',
                '应著述' => '應著述',
                '康乾' => '康乾',
                '康着' => '康著',
                '康著书' => '康著書',
                '康著作' => '康著作',
                '康著名' => '康著名',
                '康著录' => '康著錄',
                '康著称' => '康著稱',
                '康著者' => '康著者',
                '康著述' => '康著述',
                '开着' => '開著',
                '开著书' => '開著書',
                '开著作' => '開著作',
                '开著名' => '開著名',
                '开著录' => '開著錄',
                '开著称' => '開著稱',
                '开著者' => '開著者',
                '开著述' => '開著述',
                '张法乾' => '張法乾',
                '当着' => '當著',
                '当著书' => '當著書',
                '当著作' => '當著作',
                '当著名' => '當著名',
                '当著录' => '當著錄',
                '当著称' => '當著稱',
                '当著者' => '當著者',
                '当著述' => '當著述',
                '彰明较著' => '彰明較著',
                '待着' => '待著',
                '待著书' => '待著書',
                '待著作' => '待著作',
                '待著名' => '待著名',
                '待著录' => '待著錄',
                '待著称' => '待著稱',
                '待著者' => '待著者',
                '待著述' => '待著述',
                '得着' => '得著',
                '得著书' => '得著書',
                '得著作' => '得著作',
                '得著名' => '得著名',
                '得著录' => '得著錄',
                '得著称' => '得著稱',
                '得著者' => '得著者',
                '得著述' => '得著述',
                '循着' => '循著',
                '循著书' => '循著書',
                '循著作' => '循著作',
                '循著名' => '循著名',
                '循著录' => '循著錄',
                '循著称' => '循著稱',
                '循著者' => '循著者',
                '循著述' => '循著述',
                '心着' => '心著',
                '心著书' => '心著書',
                '心著作' => '心著作',
                '心著名' => '心著名',
                '心著录' => '心著錄',
                '心著称' => '心著稱',
                '心著者' => '心著者',
                '心著述' => '心著述',
                '忍着' => '忍著',
                '忍著书' => '忍著書',
                '忍著作' => '忍著作',
                '忍著名' => '忍著名',
                '忍著录' => '忍著錄',
                '忍著称' => '忍著稱',
                '忍著者' => '忍著者',
                '忍著述' => '忍著述',
                '志着' => '志著',
                '志著书' => '志著書',
                '志著作' => '志著作',
                '志著名' => '志著名',
                '志著录' => '志著錄',
                '志著称' => '志著稱',
                '志著者' => '志著者',
                '志著述' => '志著述',
                '忙着' => '忙著',
                '忙著书' => '忙著書',
                '忙著作' => '忙著作',
                '忙著名' => '忙著名',
                '忙著录' => '忙著錄',
                '忙著称' => '忙著稱',
                '忙著者' => '忙著者',
                '忙著述' => '忙著述',
                '怀着' => '懷著',
                '怀著书' => '懷著書',
                '怀著作' => '懷著作',
                '怀著名' => '懷著名',
                '怀著录' => '懷著錄',
                '怀著称' => '懷著稱',
                '怀著者' => '懷著者',
                '怀著述' => '懷著述',
                '急着' => '急著',
                '急著书' => '急著書',
                '急著作' => '急著作',
                '急著名' => '急著名',
                '急著录' => '急著錄',
                '急著称' => '急著稱',
                '急著者' => '急著者',
                '急著述' => '急著述',
                '性着' => '性著',
                '性著书' => '性著書',
                '性著作' => '性著作',
                '性著名' => '性著名',
                '性著录' => '性著錄',
                '性著称' => '性著稱',
                '性著者' => '性著者',
                '性著述' => '性著述',
                '恋着' => '戀著',
                '恋著书' => '戀著書',
                '恋著作' => '戀著作',
                '恋著名' => '戀著名',
                '恋著录' => '戀著錄',
                '恋著称' => '戀著稱',
                '恋著者' => '戀著者',
                '恋著述' => '戀著述',
                '恩威并著' => '恩威並著',
                '悠着' => '悠著',
                '悠著书' => '悠著書',
                '悠著作' => '悠著作',
                '悠著名' => '悠著名',
                '悠著录' => '悠著錄',
                '悠著称' => '悠著稱',
                '悠著者' => '悠著者',
                '悠著述' => '悠著述',
                '惯着' => '慣著',
                '惯著书' => '慣著書',
                '惯著作' => '慣著作',
                '惯著名' => '慣著名',
                '惯著录' => '慣著錄',
                '惯著称' => '慣著稱',
                '惯著者' => '慣著者',
                '惯著述' => '慣著述',
                '想着' => '想著',
                '想著书' => '想著書',
                '想著作' => '想著作',
                '想著名' => '想著名',
                '想著录' => '想著錄',
                '想著称' => '想著稱',
                '想著者' => '想著者',
                '想著述' => '想著述',
                '战着' => '戰著',
                '战著书' => '戰著書',
                '战著作' => '戰著作',
                '战著名' => '戰著名',
                '战著录' => '戰著錄',
                '战著称' => '戰著稱',
                '战著者' => '戰著者',
                '战著述' => '戰著述',
                '戴着' => '戴著',
                '戴著书' => '戴著書',
                '戴著作' => '戴著作',
                '戴著名' => '戴著名',
                '戴著录' => '戴著錄',
                '戴著称' => '戴著稱',
                '戴著者' => '戴著者',
                '戴著述' => '戴著述',
                '扎着' => '扎著',
                '扎著书' => '扎著書',
                '扎著作' => '扎著作',
                '扎著名' => '扎著名',
                '扎著录' => '扎著錄',
                '扎著称' => '扎著稱',
                '扎著者' => '扎著者',
                '扎著述' => '扎著述',
                '打着' => '打著',
                '打著书' => '打著書',
                '打著作' => '打著作',
                '打著名' => '打著名',
                '打著录' => '打著錄',
                '打著称' => '打著稱',
                '打著者' => '打著者',
                '打著述' => '打著述',
                '扛着' => '扛著',
                '扛著书' => '扛著書',
                '扛著作' => '扛著作',
                '扛著名' => '扛著名',
                '扛著录' => '扛著錄',
                '扛著称' => '扛著稱',
                '扛著者' => '扛著者',
                '扛著述' => '扛著述',
                '执著' => '執著',
                '找不着' => '找不著',
                '找不著书' => '找不著書',
                '找不著作' => '找不著作',
                '找不著名' => '找不著名',
                '找不著录' => '找不著錄',
                '找不著称' => '找不著稱',
                '找不著者' => '找不著者',
                '找不著述' => '找不著述',
                '抓着' => '抓著',
                '抓著书' => '抓著書',
                '抓著作' => '抓著作',
                '抓著名' => '抓著名',
                '抓著录' => '抓著錄',
                '抓著称' => '抓著稱',
                '抓著者' => '抓著者',
                '抓著述' => '抓著述',
                '护着' => '護著',
                '护著书' => '護著書',
                '护著作' => '護著作',
                '护著名' => '護著名',
                '护著录' => '護著錄',
                '护著称' => '護著稱',
                '护著者' => '護著者',
                '护著述' => '護著述',
                '披着' => '披著',
                '披著书' => '披著書',
                '披著作' => '披著作',
                '披著名' => '披著名',
                '披著录' => '披著錄',
                '披著称' => '披著稱',
                '披著者' => '披著者',
                '披著述' => '披著述',
                '抬着' => '抬著',
                '抬著书' => '抬著書',
                '抬著作' => '抬著作',
                '抬著名' => '抬著名',
                '抬著录' => '抬著錄',
                '抬著称' => '抬著稱',
                '抬著者' => '抬著者',
                '抬著述' => '抬著述',
                '抱着' => '抱著',
                '抱著书' => '抱著書',
                '抱著作' => '抱著作',
                '抱著名' => '抱著名',
                '抱著录' => '抱著錄',
                '抱著称' => '抱著稱',
                '抱著者' => '抱著者',
                '抱著述' => '抱著述',
                '拉着' => '拉著',
                '拉著书' => '拉著書',
                '拉著作' => '拉著作',
                '拉著名' => '拉著名',
                '拉著录' => '拉著錄',
                '拉著称' => '拉著稱',
                '拉著者' => '拉著者',
                '拉著述' => '拉著述',
                '拉链' => '拉鍊',
                '拎着' => '拎著',
                '拎著书' => '拎著書',
                '拎著作' => '拎著作',
                '拎著名' => '拎著名',
                '拎著录' => '拎著錄',
                '拎著称' => '拎著稱',
                '拎著者' => '拎著者',
                '拎著述' => '拎著述',
                '拖着' => '拖著',
                '拖著书' => '拖著書',
                '拖著作' => '拖著作',
                '拖著名' => '拖著名',
                '拖著录' => '拖著錄',
                '拖著称' => '拖著稱',
                '拖著者' => '拖著者',
                '拖著述' => '拖著述',
                '拙著' => '拙著',
                '拚命' => '拚命',
                '拚搏' => '拚搏',
                '拚死' => '拚死',
                '拼着' => '拼著',
                '拼著书' => '拼著書',
                '拼著作' => '拼著作',
                '拼著名' => '拼著名',
                '拼著录' => '拼著錄',
                '拼著称' => '拼著稱',
                '拼著者' => '拼著者',
                '拼著述' => '拼著述',
                '拿着' => '拿著',
                '拿著书' => '拿著書',
                '拿著作' => '拿著作',
                '拿著名' => '拿著名',
                '拿著录' => '拿著錄',
                '拿著称' => '拿著稱',
                '拿著者' => '拿著者',
                '拿著述' => '拿著述',
                '持着' => '持著',
                '持著书' => '持著書',
                '持著作' => '持著作',
                '持著名' => '持著名',
                '持著录' => '持著錄',
                '持著称' => '持著稱',
                '持著者' => '持著者',
                '持著述' => '持著述',
                '挑着' => '挑著',
                '挑著书' => '挑著書',
                '挑著作' => '挑著作',
                '挑著名' => '挑著名',
                '挑著录' => '挑著錄',
                '挑著称' => '挑著稱',
                '挑著者' => '挑著者',
                '挑著述' => '挑著述',
                '挡着' => '擋著',
                '挡著书' => '擋著書',
                '挡著作' => '擋著作',
                '挡著名' => '擋著名',
                '挡著录' => '擋著錄',
                '挡著称' => '擋著稱',
                '挡著者' => '擋著者',
                '挡著述' => '擋著述',
                '挣着' => '掙著',
                '挣著书' => '掙著書',
                '挣著作' => '掙著作',
                '挣著名' => '掙著名',
                '挣著录' => '掙著錄',
                '挣著称' => '掙著稱',
                '挣著者' => '掙著者',
                '挣著述' => '掙著述',
                '挥着' => '揮著',
                '挥著书' => '揮著書',
                '挥著作' => '揮著作',
                '挥著名' => '揮著名',
                '挥著录' => '揮著錄',
                '挥著称' => '揮著稱',
                '挥著者' => '揮著者',
                '挥著述' => '揮著述',
                '挨着' => '挨著',
                '挨著书' => '挨著書',
                '挨著作' => '挨著作',
                '挨著名' => '挨著名',
                '挨著录' => '挨著錄',
                '挨著称' => '挨著稱',
                '挨著者' => '挨著者',
                '挨著述' => '挨著述',
                '捆着' => '捆著',
                '捆著书' => '捆著書',
                '捆著作' => '捆著作',
                '捆著名' => '捆著名',
                '捆著录' => '捆著錄',
                '捆著称' => '捆著稱',
                '捆著者' => '捆著者',
                '捆著述' => '捆著述',
                '据着' => '據著',
                '据著书' => '據著書',
                '据著作' => '據著作',
                '据著名' => '據著名',
                '据著录' => '據著錄',
                '据著称' => '據著稱',
                '据著者' => '據著者',
                '据著述' => '據著述',
                '掖着' => '掖著',
                '掖著书' => '掖著書',
                '掖著作' => '掖著作',
                '掖著名' => '掖著名',
                '掖著录' => '掖著錄',
                '掖著称' => '掖著稱',
                '掖著者' => '掖著者',
                '掖著述' => '掖著述',
                '接着' => '接著',
                '接著书' => '接著書',
                '接著作' => '接著作',
                '接著名' => '接著名',
                '接著录' => '接著錄',
                '接著称' => '接著稱',
                '接著者' => '接著者',
                '接著述' => '接著述',
                '揉着' => '揉著',
                '揉著书' => '揉著書',
                '揉著作' => '揉著作',
                '揉著名' => '揉著名',
                '揉著录' => '揉著錄',
                '揉著称' => '揉著稱',
                '揉著者' => '揉著者',
                '揉著述' => '揉著述',
                '提着' => '提著',
                '提著书' => '提著書',
                '提著作' => '提著作',
                '提著名' => '提著名',
                '提著录' => '提著錄',
                '提著称' => '提著稱',
                '提著者' => '提著者',
                '提著述' => '提著述',
                '搂着' => '摟著',
                '搂著书' => '摟著書',
                '搂著作' => '摟著作',
                '搂著名' => '摟著名',
                '搂著录' => '摟著錄',
                '搂著称' => '摟著稱',
                '搂著者' => '摟著者',
                '搂著述' => '摟著述',
                '摆着' => '擺著',
                '摆著书' => '擺著書',
                '摆著作' => '擺著作',
                '摆著名' => '擺著名',
                '摆著录' => '擺著錄',
                '摆著称' => '擺著稱',
                '摆著者' => '擺著者',
                '摆著述' => '擺著述',
                '撰著' => '撰著',
                '撼着' => '撼著',
                '撼著书' => '撼著書',
                '撼著作' => '撼著作',
                '撼著名' => '撼著名',
                '撼著录' => '撼著錄',
                '撼著称' => '撼著稱',
                '撼著者' => '撼著者',
                '撼著述' => '撼著述',
                '敞着' => '敞著',
                '敞著书' => '敞著書',
                '敞著作' => '敞著作',
                '敞著名' => '敞著名',
                '敞著录' => '敞著錄',
                '敞著称' => '敞著稱',
                '敞著者' => '敞著者',
                '敞著述' => '敞著述',
                '数着' => '數著',
                '数著书' => '數著書',
                '数著作' => '數著作',
                '数著名' => '數著名',
                '数著录' => '數著錄',
                '数著称' => '數著稱',
                '数著者' => '數著者',
                '数著述' => '數著述',
                '斗着' => '斗著',
                '斗著书' => '斗著書',
                '斗著作' => '斗著作',
                '斗著名' => '斗著名',
                '斗著录' => '斗著錄',
                '斗著称' => '斗著稱',
                '斗著者' => '斗著者',
                '斗著述' => '斗著述',
                '斥着' => '斥著',
                '斥著书' => '斥著書',
                '斥著作' => '斥著作',
                '斥著名' => '斥著名',
                '斥著录' => '斥著錄',
                '斥著称' => '斥著稱',
                '斥著者' => '斥著者',
                '斥著述' => '斥著述',
                '新著' => '新著',
                '新著龙虎门' => '新著龍虎門',
                '於世成' => '於世成',
                '於乎' => '於乎',
                '於乙于同' => '於乙于同',
                '於乙宇同' => '於乙宇同',
                '於于同' => '於于同',
                '於哲' => '於哲',
                '於夫罗' => '於夫羅',
                '於姓' => '於姓',
                '於宇同' => '於宇同',
                '於崇文' => '於崇文',
                '於志贺' => '於志贺',
                '於戏' => '於戲',
                '於梨华' => '於梨华',
                '於氏' => '於氏',
                '於潜县' => '於潜县',
                '於祥玉' => '於祥玉',
                '於菟' => '於菟',
                '於贤德' => '於賢德',
                '於除鞬' => '於除鞬',
                '旋乾转坤' => '旋乾轉坤',
                '旷若发矇' => '曠若發矇',
                '昂着' => '昂著',
                '昂著书' => '昂著書',
                '昂著作' => '昂著作',
                '昂著名' => '昂著名',
                '昂著录' => '昂著錄',
                '昂著称' => '昂著稱',
                '昂著者' => '昂著者',
                '昂著述' => '昂著述',
                '易·乾' => '易·乾',
                '易经·乾' => '易经·乾',
                '易经乾' => '易经乾',
                '映着' => '映著',
                '映著书' => '映著書',
                '映著作' => '映著作',
                '映著名' => '映著名',
                '映著录' => '映著錄',
                '映著称' => '映著稱',
                '映著者' => '映著者',
                '映著述' => '映著述',
                '昭著' => '昭著',
                '显著' => '显著',
                '晃着' => '晃著',
                '晃著书' => '晃著書',
                '晃著作' => '晃著作',
                '晃著名' => '晃著名',
                '晃著录' => '晃著錄',
                '晃著称' => '晃著稱',
                '晃著者' => '晃著者',
                '晃著述' => '晃著述',
                '暗着' => '暗著',
                '暗著书' => '暗著書',
                '暗著作' => '暗著作',
                '暗著名' => '暗著名',
                '暗著录' => '暗著錄',
                '暗著称' => '暗著稱',
                '暗著者' => '暗著者',
                '暗著述' => '暗著述',
                '有着' => '有著',
                '有著书' => '有著書',
                '有著作' => '有著作',
                '有著名' => '有著名',
                '有著录' => '有著錄',
                '有著称' => '有著稱',
                '有著者' => '有著者',
                '有著述' => '有著述',
                '望着' => '望著',
                '望著书' => '望著書',
                '望著作' => '望著作',
                '望著名' => '望著名',
                '望著录' => '望著錄',
                '望著称' => '望著稱',
                '望著者' => '望著者',
                '望著述' => '望著述',
                '朝乾夕惕' => '朝乾夕惕',
                '朝着' => '朝著',
                '朝著书' => '朝著書',
                '朝著作' => '朝著作',
                '朝著名' => '朝著名',
                '朝著录' => '朝著錄',
                '朝著称' => '朝著稱',
                '朝著者' => '朝著者',
                '朝著述' => '朝著述',
                '本着' => '本著',
                '本著书' => '本著書',
                '本著作' => '本著作',
                '本著名' => '本著名',
                '本著录' => '本著錄',
                '本著称' => '本著稱',
                '本著者' => '本著者',
                '本著述' => '本著述',
                '朴於宇同' => '朴於宇同',
                '杀着' => '殺著',
                '杀著书' => '殺著書',
                '杀著作' => '殺著作',
                '杀著名' => '殺著名',
                '杀著录' => '殺著錄',
                '杀著称' => '殺著稱',
                '杀著者' => '殺著者',
                '杀著述' => '殺著述',
                '杂着' => '雜著',
                '杂著书' => '雜著書',
                '杂著作' => '雜著作',
                '杂著名' => '雜著名',
                '杂著录' => '雜著錄',
                '杂著称' => '雜著稱',
                '杂著者' => '雜著者',
                '杂著述' => '雜著述',
                '李乾德' => '李乾德',
                '李乾顺' => '李乾顺',
                '李泽钜' => '李澤鉅',
                '来着' => '來著',
                '来著书' => '來著書',
                '来著作' => '來著作',
                '来著名' => '來著名',
                '来著录' => '來著錄',
                '来著称' => '來著稱',
                '来著者' => '來著者',
                '来著述' => '來著述',
                '杨幺' => '楊幺',
                '枕着' => '枕著',
                '枕著书' => '枕著書',
                '枕著作' => '枕著作',
                '枕著名' => '枕著名',
                '枕著录' => '枕著錄',
                '枕著称' => '枕著稱',
                '枕著者' => '枕著者',
                '枕著述' => '枕著述',
                '柳诒徵' => '柳诒徵',
                '标志着' => '標誌著',
                '梦着' => '夢著',
                '梦著书' => '夢著書',
                '梦著作' => '夢著作',
                '梦著名' => '夢著名',
                '梦著录' => '夢著錄',
                '梦著称' => '夢著稱',
                '梦著者' => '夢著者',
                '梦著述' => '夢著述',
                '梳着' => '梳著',
                '梳著书' => '梳著書',
                '梳著作' => '梳著作',
                '梳著名' => '梳著名',
                '梳著录' => '梳著錄',
                '梳著称' => '梳著稱',
                '梳著者' => '梳著者',
                '梳著述' => '梳著述',
                '樊於期' => '樊於期',
                '氆氌' => '氆氌',
                '求着' => '求著',
                '求著书' => '求著書',
                '求著作' => '求著作',
                '求著名' => '求著名',
                '求著录' => '求著錄',
                '求著称' => '求著稱',
                '求著者' => '求著者',
                '求著述' => '求著述',
                '沉没' => '沈沒',
                '沉着' => '沉著',
                '沉积' => '沈積',
                '沉船' => '沈船',
                '沉著书' => '沉著書',
                '沉著作' => '沉著作',
                '沉著名' => '沉著名',
                '沉著录' => '沉著錄',
                '沉著称' => '沉著稱',
                '沉著者' => '沉著者',
                '沉著述' => '沉著述',
                '沉默' => '沈默',
                '沿着' => '沿著',
                '沿著书' => '沿著書',
                '沿著作' => '沿著作',
                '沿著名' => '沿著名',
                '沿著录' => '沿著錄',
                '沿著称' => '沿著稱',
                '沿著者' => '沿著者',
                '沿著述' => '沿著述',
                '泛滥' => '氾濫',
                '洗练' => '洗鍊',
                '活着' => '活著',
                '活著书' => '活著書',
                '活著作' => '活著作',
                '活著名' => '活著名',
                '活著录' => '活著錄',
                '活著称' => '活著稱',
                '活著者' => '活著者',
                '活著述' => '活著述',
                '流着' => '流著',
                '流著书' => '流著書',
                '流著作' => '流著作',
                '流著名' => '流著名',
                '流著录' => '流著錄',
                '流著称' => '流著稱',
                '流著者' => '流著者',
                '流著述' => '流著述',
                '流露着' => '流露著',
                '浮着' => '浮著',
                '浮著书' => '浮著書',
                '浮著作' => '浮著作',
                '浮著名' => '浮著名',
                '浮著录' => '浮著錄',
                '浮著称' => '浮著稱',
                '浮著者' => '浮著者',
                '浮著述' => '浮著述',
                '润着' => '潤著',
                '润著书' => '潤著書',
                '润著作' => '潤著作',
                '润著名' => '潤著名',
                '润著录' => '潤著錄',
                '润著称' => '潤著稱',
                '润著者' => '潤著者',
                '润著述' => '潤著述',
                '涵着' => '涵著',
                '涵著书' => '涵著書',
                '涵著作' => '涵著作',
                '涵著名' => '涵著名',
                '涵著录' => '涵著錄',
                '涵著称' => '涵著稱',
                '涵著者' => '涵著者',
                '涵著述' => '涵著述',
                '渴着' => '渴著',
                '渴著书' => '渴著書',
                '渴著作' => '渴著作',
                '渴著名' => '渴著名',
                '渴著录' => '渴著錄',
                '渴著称' => '渴著稱',
                '渴著者' => '渴著者',
                '渴著述' => '渴著述',
                '溢着' => '溢著',
                '溢著书' => '溢著書',
                '溢著作' => '溢著作',
                '溢著名' => '溢著名',
                '溢著录' => '溢著錄',
                '溢著称' => '溢著稱',
                '溢著者' => '溢著者',
                '溢著述' => '溢著述',
                '演着' => '演著',
                '演著书' => '演著書',
                '演著作' => '演著作',
                '演著名' => '演著名',
                '演著录' => '演著錄',
                '演著称' => '演著稱',
                '演著者' => '演著者',
                '演著述' => '演著述',
                '漫着' => '漫著',
                '漫著书' => '漫著書',
                '漫著作' => '漫著作',
                '漫著名' => '漫著名',
                '漫著录' => '漫著錄',
                '漫著称' => '漫著稱',
                '漫著者' => '漫著者',
                '漫著述' => '漫著述',
                '点着' => '點著',
                '点著作' => '點著作',
                '点著名' => '點著名',
                '点著录' => '點著錄',
                '点著称' => '點著稱',
                '点著者' => '點著者',
                '点著述' => '點著述',
                '烧着' => '燒著',
                '烧著作' => '燒著作',
                '烧著名' => '燒著名',
                '烧著录' => '燒著錄',
                '烧著称' => '燒著稱',
                '烧著者' => '燒著者',
                '烧著述' => '燒著述',
                '照着' => '照著',
                '照著书' => '照著書',
                '照著作' => '照著作',
                '照著名' => '照著名',
                '照著录' => '照著錄',
                '照著称' => '照著稱',
                '照著者' => '照著者',
                '照著述' => '照著述',
                '爱护着' => '愛護著',
                '爱着' => '愛著',
                '爱著书' => '愛著書',
                '爱著作' => '愛著作',
                '爱著名' => '愛著名',
                '爱著录' => '愛著錄',
                '爱著称' => '愛著稱',
                '爱著者' => '愛著者',
                '爱著述' => '愛著述',
                '牵着' => '牽著',
                '牵著书' => '牽著書',
                '牵著作' => '牽著作',
                '牵著名' => '牽著名',
                '牵著录' => '牽著錄',
                '牵著称' => '牽著稱',
                '牵著者' => '牽著者',
                '牵著述' => '牽著述',
                '犯不着' => '犯不著',
                '独着' => '獨著',
                '独著书' => '獨著書',
                '独著作' => '獨著作',
                '独著名' => '獨著名',
                '独著录' => '獨著錄',
                '独著称' => '獨著稱',
                '独著者' => '獨著者',
                '独著述' => '獨著述',
                '猜着' => '猜著',
                '猜着书' => '猜著書',
                '猜著作' => '猜著作',
                '猜著名' => '猜著名',
                '猜著录' => '猜著錄',
                '猜著称' => '猜著稱',
                '猜著者' => '猜著者',
                '猜著述' => '猜著述',
                '玩着' => '玩著',
                '甜着' => '甜著',
                '甜著书' => '甜著書',
                '甜著作' => '甜著作',
                '甜著名' => '甜著名',
                '甜著录' => '甜著錄',
                '甜著称' => '甜著稱',
                '甜著者' => '甜著者',
                '甜著述' => '甜著述',
                '用不着' => '用不著',
                '用不着书' => '用不著書',
                '用不著作' => '用不著作',
                '用不著名' => '用不著名',
                '用不著录' => '用不著錄',
                '用不著称' => '用不著稱',
                '用不著者' => '用不著者',
                '用不著述' => '用不著述',
                '用着' => '用著',
                '用著书' => '用著書',
                '用著作' => '用著作',
                '用著名' => '用著名',
                '用著录' => '用著錄',
                '用著称' => '用著稱',
                '用著者' => '用著者',
                '用著述' => '用著述',
                '留着' => '留著',
                '留着书' => '留著書',
                '留著作' => '留著作',
                '留著名' => '留著名',
                '留著录' => '留著錄',
                '留著称' => '留著稱',
                '留著者' => '留著者',
                '留著述' => '留著述',
                '疑着' => '疑著',
                '疑著书' => '疑著書',
                '疑著作' => '疑著作',
                '疑著名' => '疑著名',
                '疑著录' => '疑著錄',
                '疑著称' => '疑著稱',
                '疑著者' => '疑著者',
                '疑著述' => '疑著述',
                '癥瘕' => '癥瘕',
                '皱着' => '皺著',
                '皱著书' => '皺著書',
                '皱著作' => '皺著作',
                '皱著名' => '皺著名',
                '皱著录' => '皺著錄',
                '皱著称' => '皺著稱',
                '皱著者' => '皺著者',
                '皱著述' => '皺著述',
                '盛着' => '盛著',
                '盛著书' => '盛著書',
                '盛著作' => '盛著作',
                '盛著名' => '盛著名',
                '盛著录' => '盛著錄',
                '盛著称' => '盛著稱',
                '盛著者' => '盛著者',
                '盛著述' => '盛著述',
                '盯着' => '盯著',
                '盯着书' => '盯著書',
                '盯著作' => '盯著作',
                '盯著名' => '盯著名',
                '盯著录' => '盯著錄',
                '盯著称' => '盯著稱',
                '盯著者' => '盯著者',
                '盯著述' => '盯著述',
                '盾着' => '盾著',
                '盾著书' => '盾著書',
                '盾著作' => '盾著作',
                '盾著名' => '盾著名',
                '盾著录' => '盾著錄',
                '盾著称' => '盾著稱',
                '盾著者' => '盾著者',
                '盾著述' => '盾著述',
                '看着' => '看著',
                '看着书' => '看著書',
                '看著作' => '看著作',
                '看著名' => '看著名',
                '看著录' => '看著錄',
                '看著称' => '看著稱',
                '看著者' => '看著者',
                '看著述' => '看著述',
                '着业' => '著業',
                '着丝' => '著絲',
                '着么' => '著么',
                '着人' => '著人',
                '着什么急' => '著什么急',
                '着他' => '著他',
                '着令' => '著令',
                '着位' => '著位',
                '着体' => '著體',
                '着你' => '著你',
                '着便' => '著便',
                '着凉' => '著涼',
                '着力' => '著力',
                '着劲' => '著勁',
                '着号' => '著號',
                '着呢' => '著呢',
                '着哩' => '著哩',
                '着地' => '著地',
                '着墨' => '著墨',
                '着声' => '著聲',
                '着处' => '著處',
                '着她' => '著她',
                '着妳' => '著妳',
                '着姓' => '著姓',
                '着它' => '著它',
                '着定' => '著定',
                '着实' => '著實',
                '着己' => '著己',
                '着帐' => '著帳',
                '着床' => '著床',
                '着庸' => '著庸',
                '着式' => '著式',
                '着录' => '著錄',
                '着心' => '著心',
                '着志' => '著志',
                '着忙' => '著忙',
                '着急' => '著急',
                '着恼' => '著惱',
                '着惊' => '著驚',
                '着想' => '著想',
                '着意' => '著意',
                '着慌' => '著慌',
                '着我' => '著我',
                '着手' => '著手',
                '着抹' => '著抹',
                '着摸' => '著摸',
                '着撰' => '著撰',
                '着数' => '著數',
                '着明' => '著明',
                '着末' => '著末',
                '着极' => '著極',
                '着格' => '著格',
                '着棋' => '著棋',
                '着槁' => '著槁',
                '着气' => '著氣',
                '着法' => '著法',
                '着浅' => '著淺',
                '着火' => '著火',
                '着然' => '著然',
                '着甚' => '著甚',
                '着生' => '著生',
                '着疑' => '著疑',
                '着白' => '著白',
                '着相' => '著相',
                '着眼' => '著眼',
                '着着' => '著著',
                '着祂' => '著祂',
                '着积' => '著積',
                '着稿' => '著稿',
                '着笔' => '著筆',
                '着籍' => '著籍',
                '着紧' => '著緊',
                '着緑' => '著緑',
                '着绊' => '著絆',
                '着绩' => '著績',
                '着绯' => '著緋',
                '着绿' => '著綠',
                '着肉' => '著肉',
                '着脚' => '著腳',
                '着舰' => '著艦',
                '着色' => '著色',
                '着节' => '著節',
                '着花' => '著花',
                '着莫' => '著莫',
                '着落' => '著落',
                '着藁' => '著藁',
                '着衣' => '著衣',
                '着装' => '著裝',
                '着要' => '著要',
                '着警' => '著警',
                '着趣' => '著趣',
                '着边' => '著邊',
                '着迷' => '著迷',
                '着迹' => '著跡',
                '着重' => '著重',
                '着録' => '著録',
                '着闻' => '著聞',
                '着陆' => '著陸',
                '着雝' => '著雝',
                '着鞭' => '著鞭',
                '着题' => '著題',
                '着魔' => '著魔',
                '睡不着' => '睡不著',
                '睡不著书' => '睡不著書',
                '睡不著作' => '睡不著作',
                '睡不著名' => '睡不著名',
                '睡不著录' => '睡不著錄',
                '睡不著称' => '睡不著稱',
                '睡不著者' => '睡不著者',
                '睡不著述' => '睡不著述',
                '睡着' => '睡著',
                '睡著书' => '睡著書',
                '睡著作' => '睡著作',
                '睡著名' => '睡著名',
                '睡著录' => '睡著錄',
                '睡著称' => '睡著稱',
                '睡著者' => '睡著者',
                '睡著述' => '睡著述',
                '睹微知著' => '睹微知著',
                '睾丸' => '睪丸',
                '瞒着' => '瞞著',
                '瞒著书' => '瞞著書',
                '瞒著作' => '瞞著作',
                '瞒著名' => '瞞著名',
                '瞒著录' => '瞞著錄',
                '瞒著称' => '瞞著稱',
                '瞒著者' => '瞞著者',
                '瞒著述' => '瞞著述',
                '瞧着' => '瞧著',
                '瞧着书' => '瞧著書',
                '瞧著作' => '瞧著作',
                '瞧著名' => '瞧著名',
                '瞧著录' => '瞧著錄',
                '瞧著称' => '瞧著稱',
                '瞧著者' => '瞧著者',
                '瞧著述' => '瞧著述',
                '瞪着' => '瞪著',
                '瞪著书' => '瞪著書',
                '瞪著作' => '瞪著作',
                '瞪著名' => '瞪著名',
                '瞪著录' => '瞪著錄',
                '瞪著称' => '瞪著稱',
                '瞪著者' => '瞪著者',
                '瞪著述' => '瞪著述',
                '瞭望' => '瞭望',
                '石碁镇' => '石碁鎮',
                '福着' => '福著',
                '福著书' => '福著書',
                '福著作' => '福著作',
                '福著名' => '福著名',
                '福著录' => '福著錄',
                '福著称' => '福著稱',
                '福著者' => '福著者',
                '福著述' => '福著述',
                '穀梁' => '穀梁',
                '空着' => '空著',
                '空著书' => '空著書',
                '空著作' => '空著作',
                '空著名' => '空著名',
                '空著录' => '空著錄',
                '空著称' => '空著稱',
                '空著者' => '空著者',
                '空著述' => '空著述',
                '穿着' => '穿著',
                '穿著书' => '穿著書',
                '穿著作' => '穿著作',
                '穿著名' => '穿著名',
                '穿著录' => '穿著錄',
                '穿著称' => '穿著稱',
                '穿著者' => '穿著者',
                '穿著述' => '穿著述',
                '竖着' => '豎著',
                '竖著书' => '豎著書',
                '竖著作' => '豎著作',
                '竖著名' => '豎著名',
                '竖著录' => '豎著錄',
                '竖著称' => '豎著稱',
                '竖著者' => '豎著者',
                '竖著述' => '豎著述',
                '站着' => '站著',
                '站著书' => '站著書',
                '站著作' => '站著作',
                '站著名' => '站著名',
                '站著录' => '站著錄',
                '站著称' => '站著稱',
                '站著者' => '站著者',
                '站著述' => '站著述',
                '笑着' => '笑著',
                '笑著书' => '笑著書',
                '笑著作' => '笑著作',
                '笑著名' => '笑著名',
                '笑著录' => '笑著錄',
                '笑著称' => '笑著稱',
                '笑著者' => '笑著者',
                '笑著述' => '笑著述',
                '答复' => '答覆',
                '管着' => '管著',
                '管著书' => '管著書',
                '管著作' => '管著作',
                '管著名' => '管著名',
                '管著录' => '管著錄',
                '管著称' => '管著稱',
                '管著者' => '管著者',
                '管著述' => '管著述',
                '绑着' => '綁著',
                '绑著书' => '綁著書',
                '绑著作' => '綁著作',
                '绑著名' => '綁著名',
                '绑著录' => '綁著錄',
                '绑著称' => '綁著稱',
                '绑著者' => '綁著者',
                '绑著述' => '綁著述',
                '绕着' => '繞著',
                '绕著书' => '繞著書',
                '绕著作' => '繞著作',
                '绕著名' => '繞著名',
                '绕著录' => '繞著錄',
                '绕著称' => '繞著稱',
                '绕著者' => '繞著者',
                '绕著述' => '繞著述',
                '编著' => '編著',
                '缠着' => '纏著',
                '缠著书' => '纏著書',
                '缠著作' => '纏著作',
                '缠著名' => '纏著名',
                '缠著录' => '纏著錄',
                '缠著称' => '纏著稱',
                '缠著者' => '纏著者',
                '缠著述' => '纏著述',
                '罩着' => '罩著',
                '罩著书' => '罩著書',
                '罩著作' => '罩著作',
                '罩著名' => '罩著名',
                '罩著录' => '罩著錄',
                '罩著称' => '罩著稱',
                '罩著者' => '罩著者',
                '罩著述' => '罩著述',
                '美着' => '美著',
                '美著书' => '美著書',
                '美著作' => '美著作',
                '美著名' => '美著名',
                '美著录' => '美著錄',
                '美著称' => '美著稱',
                '美著者' => '美著者',
                '美著述' => '美著述',
                '耀着' => '耀著',
                '耀著书' => '耀著書',
                '耀著作' => '耀著作',
                '耀著名' => '耀著名',
                '耀著录' => '耀著錄',
                '耀著称' => '耀著稱',
                '耀著者' => '耀著者',
                '耀著述' => '耀著述',
                '老幺' => '老幺',
                '考着' => '考著',
                '考著书' => '考著書',
                '考著作' => '考著作',
                '考著名' => '考著名',
                '考著录' => '考著錄',
                '考著称' => '考著稱',
                '考著者' => '考著者',
                '考著述' => '考著述',
                '肉干干' => '肉乾乾',
                '肘手链足' => '肘手鍊足',
                '背着' => '背著',
                '背著书' => '背著書',
                '背著作' => '背著作',
                '背著名' => '背著名',
                '背著录' => '背著錄',
                '背著称' => '背著稱',
                '背著者' => '背著者',
                '背著述' => '背著述',
                '胶着' => '膠著',
                '胶著书' => '膠著書',
                '胶著作' => '膠著作',
                '胶著名' => '膠著名',
                '胶著录' => '膠著錄',
                '胶著称' => '膠著稱',
                '胶著者' => '膠著者',
                '胶著述' => '膠著述',
                '艺着' => '藝著',
                '艺著书' => '藝著書',
                '艺著作' => '藝著作',
                '艺著名' => '藝著名',
                '艺著录' => '藝著錄',
                '艺著称' => '藝著稱',
                '艺著者' => '藝著者',
                '艺著述' => '藝著述',
                '苦着' => '苦著',
                '苦著书' => '苦著書',
                '苦著作' => '苦著作',
                '苦著名' => '苦著名',
                '苦著录' => '苦著錄',
                '苦著称' => '苦著稱',
                '苦著者' => '苦著者',
                '苦著述' => '苦著述',
                '苧烯' => '薴烯',
                '获着' => '獲著',
                '获著书' => '獲著書',
                '获著作' => '獲著作',
                '获著名' => '獲著名',
                '获著录' => '獲著錄',
                '获著称' => '獲著稱',
                '获著者' => '獲著者',
                '获著述' => '獲著述',
                '萧乾' => '萧乾',
                '落着' => '落著',
                '落著书' => '落著書',
                '落著作' => '落著作',
                '落著名' => '落著名',
                '落著录' => '落著錄',
                '落著称' => '落著稱',
                '落著者' => '落著者',
                '落著述' => '落著述',
                '著书' => '著書',
                '著书立说' => '著書立說',
                '著作' => '著作',
                '著名' => '著名',
                '著录规则' => '著錄規則',
                '著文' => '著文',
                '著有' => '著有',
                '著称' => '著稱',
                '著者' => '著者',
                '著身' => '著身',
                '著述' => '著述',
                '蒙着' => '蒙著',
                '蒙著书' => '蒙著書',
                '蒙著作' => '蒙著作',
                '蒙著名' => '蒙著名',
                '蒙著录' => '蒙著錄',
                '蒙著称' => '蒙著稱',
                '蒙著者' => '蒙著者',
                '蒙著述' => '蒙著述',
                '藏着' => '藏著',
                '藏著书' => '藏著書',
                '藏著作' => '藏著作',
                '藏著名' => '藏著名',
                '藏著录' => '藏著錄',
                '藏著称' => '藏著稱',
                '藏著者' => '藏著者',
                '藏著述' => '藏著述',
                '蘸着' => '蘸著',
                '蘸著书' => '蘸著書',
                '蘸著作' => '蘸著作',
                '蘸著名' => '蘸著名',
                '蘸著录' => '蘸著錄',
                '蘸著称' => '蘸著稱',
                '蘸著者' => '蘸著者',
                '蘸著述' => '蘸著述',
                '行着' => '行著',
                '行著书' => '行著書',
                '行著作' => '行著作',
                '行著名' => '行著名',
                '行著录' => '行著錄',
                '行著称' => '行著稱',
                '行著者' => '行著者',
                '行著述' => '行著述',
                '衣着' => '衣著',
                '衣著书' => '衣著書',
                '衣著作' => '衣著作',
                '衣著名' => '衣著名',
                '衣著录' => '衣著錄',
                '衣著称' => '衣著稱',
                '衣著者' => '衣著者',
                '衣著述' => '衣著述',
                '装着' => '裝著',
                '装著书' => '裝著書',
                '装著作' => '裝著作',
                '装著名' => '裝著名',
                '装著录' => '裝著錄',
                '装著称' => '裝著稱',
                '装著者' => '裝著者',
                '装著述' => '裝著述',
                '裹着' => '裹著',
                '裹著书' => '裹著書',
                '裹著作' => '裹著作',
                '裹著名' => '裹著名',
                '裹著录' => '裹著錄',
                '裹著称' => '裹著稱',
                '裹著者' => '裹著者',
                '裹著述' => '裹著述',
                '覆蓋' => '覆蓋',
                '见微知著' => '見微知著',
                '见着' => '見著',
                '见著书' => '見著書',
                '见著作' => '見著作',
                '见著名' => '見著名',
                '见著录' => '見著錄',
                '见著称' => '見著稱',
                '见著者' => '見著者',
                '见著述' => '見著述',
                '视微知著' => '視微知著',
                '言幾析理' => '言幾析理',
                '记着' => '記著',
                '记著书' => '記著書',
                '记著作' => '記著作',
                '记著名' => '記著名',
                '记著录' => '記著錄',
                '记著称' => '記著稱',
                '记著者' => '記著者',
                '记著述' => '記著述',
                '论著' => '論著',
                '译著' => '譯著',
                '试着' => '試著',
                '试著书' => '試著書',
                '试著作' => '試著作',
                '试著名' => '試著名',
                '试著录' => '試著錄',
                '试著称' => '試著稱',
                '试著者' => '試著者',
                '试著述' => '試著述',
                '语着' => '語著',
                '语著书' => '語著書',
                '语著作' => '語著作',
                '语著名' => '語著名',
                '语著录' => '語著錄',
                '语著称' => '語著稱',
                '语著者' => '語著者',
                '语著述' => '語著述',
                '豫着' => '豫著',
                '豫著书' => '豫著書',
                '豫著作' => '豫著作',
                '豫著名' => '豫著名',
                '豫著录' => '豫著錄',
                '豫著称' => '豫著稱',
                '豫著者' => '豫著者',
                '豫著述' => '豫著述',
                '贞着' => '貞著',
                '贞著书' => '貞著書',
                '贞著作' => '貞著作',
                '贞著名' => '貞著名',
                '贞著录' => '貞著錄',
                '贞著称' => '貞著稱',
                '贞著者' => '貞著者',
                '贞著述' => '貞著述',
                '走着' => '走著',
                '走著书' => '走著書',
                '走著作' => '走著作',
                '走著名' => '走著名',
                '走著录' => '走著錄',
                '走著称' => '走著稱',
                '走著者' => '走著者',
                '走著述' => '走著述',
                '赶着' => '趕著',
                '赶著书' => '趕著書',
                '赶著作' => '趕著作',
                '赶著名' => '趕著名',
                '赶著录' => '趕著錄',
                '赶著称' => '趕著稱',
                '赶著者' => '趕著者',
                '赶著述' => '趕著述',
                '趴着' => '趴著',
                '趴著书' => '趴著書',
                '趴著作' => '趴著作',
                '趴著名' => '趴著名',
                '趴著录' => '趴著錄',
                '趴著称' => '趴著稱',
                '趴著者' => '趴著者',
                '趴著述' => '趴著述',
                '跃着' => '躍著',
                '跃著书' => '躍著書',
                '跃著作' => '躍著作',
                '跃著名' => '躍著名',
                '跃著录' => '躍著錄',
                '跃著称' => '躍著稱',
                '跃著者' => '躍著者',
                '跃著述' => '躍著述',
                '跑着' => '跑著',
                '跑著书' => '跑著書',
                '跑著作' => '跑著作',
                '跑著名' => '跑著名',
                '跑著录' => '跑著錄',
                '跑著称' => '跑著稱',
                '跑著者' => '跑著者',
                '跑著述' => '跑著述',
                '跟着' => '跟著',
                '跟著书' => '跟著書',
                '跟著作' => '跟著作',
                '跟著名' => '跟著名',
                '跟著录' => '跟著錄',
                '跟著称' => '跟著稱',
                '跟著者' => '跟著者',
                '跟著述' => '跟著述',
                '跪着' => '跪著',
                '跪著书' => '跪著書',
                '跪著作' => '跪著作',
                '跪著名' => '跪著名',
                '跪著录' => '跪著錄',
                '跪著称' => '跪著稱',
                '跪著者' => '跪著者',
                '跪著述' => '跪著述',
                '跳着' => '跳著',
                '跳著书' => '跳著書',
                '跳著作' => '跳著作',
                '跳著名' => '跳著名',
                '跳著录' => '跳著錄',
                '跳著称' => '跳著稱',
                '跳著者' => '跳著者',
                '跳著述' => '跳著述',
                '踌躇滿志' => '躊躇滿志',
                '踏着' => '踏著',
                '踏著书' => '踏著書',
                '踏著作' => '踏著作',
                '踏著名' => '踏著名',
                '踏著录' => '踏著錄',
                '踏著称' => '踏著稱',
                '踏著者' => '踏著者',
                '踏著述' => '踏著述',
                '踩着' => '踩著',
                '踩著书' => '踩著書',
                '踩著作' => '踩著作',
                '踩著名' => '踩著名',
                '踩著录' => '踩著錄',
                '踩著称' => '踩著稱',
                '踩著者' => '踩著者',
                '踩著述' => '踩著述',
                '身着' => '身著',
                '身著书' => '身著書',
                '身著作' => '身著作',
                '身著名' => '身著名',
                '身著录' => '身著錄',
                '身著称' => '身著稱',
                '身著者' => '身著者',
                '身著述' => '身著述',
                '躺着' => '躺著',
                '躺著书' => '躺著書',
                '躺著作' => '躺著作',
                '躺著名' => '躺著名',
                '躺著录' => '躺著錄',
                '躺著称' => '躺著稱',
                '躺著者' => '躺著者',
                '躺著述' => '躺著述',
                '转着' => '轉著',
                '转著书' => '轉著書',
                '转著作' => '轉著作',
                '转著名' => '轉著名',
                '转著录' => '轉著錄',
                '转著称' => '轉著稱',
                '转著者' => '轉著者',
                '转著述' => '轉著述',
                '载着' => '載著',
                '载著书' => '載著書',
                '载著作' => '載著作',
                '载著名' => '載著名',
                '载著录' => '載著錄',
                '载著称' => '載著稱',
                '载著者' => '載著者',
                '载著述' => '載著述',
                '较著' => '較著',
                '达着' => '達著',
                '达著书' => '達著書',
                '达著作' => '達著作',
                '达著名' => '達著名',
                '达著录' => '達著錄',
                '达著称' => '達著稱',
                '达著者' => '達著者',
                '达著述' => '達著述',
                '远着' => '遠著',
                '远著书' => '遠著書',
                '远著作' => '遠著作',
                '远著名' => '遠著名',
                '远著录' => '遠著錄',
                '远著称' => '遠著稱',
                '远著者' => '遠著者',
                '远著述' => '遠著述',
                '连着' => '連著',
                '连著书' => '連著書',
                '连著作' => '連著作',
                '连著名' => '連著名',
                '连著录' => '連著錄',
                '连著称' => '連著稱',
                '连著者' => '連著者',
                '连著述' => '連著述',
                '迫着' => '迫著',
                '追着' => '追著',
                '追著书' => '追著書',
                '追著作' => '追著作',
                '追著名' => '追著名',
                '追著录' => '追著錄',
                '追著称' => '追著稱',
                '追著者' => '追著者',
                '追著述' => '追著述',
                '逆着' => '逆著',
                '逆著书' => '逆著書',
                '逆著作' => '逆著作',
                '逆著名' => '逆著名',
                '逆著录' => '逆著錄',
                '逆著称' => '逆著稱',
                '逆著者' => '逆著者',
                '逆著述' => '逆著述',
                '逼着' => '逼著',
                '逼著书' => '逼著書',
                '逼著作' => '逼著作',
                '逼著名' => '逼著名',
                '逼著录' => '逼著錄',
                '逼著称' => '逼著稱',
                '逼著者' => '逼著者',
                '逼著述' => '逼著述',
                '遇着' => '遇著',
                '遇著书' => '遇著書',
                '遇著作' => '遇著作',
                '遇著名' => '遇著名',
                '遇著录' => '遇著錄',
                '遇著称' => '遇著稱',
                '遇著者' => '遇著者',
                '遇著述' => '遇著述',
                '遗著' => '遺著',
                '那麽' => '那麽',
                '郭子乾' => '郭子乾',
                '配着' => '配著',
                '配著书' => '配著書',
                '配著作' => '配著作',
                '配著名' => '配著名',
                '配著录' => '配著錄',
                '配著称' => '配著稱',
                '配著者' => '配著者',
                '配著述' => '配著述',
                '酿着' => '釀著',
                '酿著书' => '釀著書',
                '酿著作' => '釀著作',
                '酿著名' => '釀著名',
                '酿著录' => '釀著錄',
                '酿著称' => '釀著稱',
                '酿著者' => '釀著者',
                '酿著述' => '釀著述',
                '醯壶' => '醯壶',
                '醯酱' => '醯醬',
                '醯醋' => '醯醋',
                '醯醢' => '醯醢',
                '醯鸡' => '醯雞',
                '重复' => '重覆',
                '金链' => '金鍊',
                '铁链' => '鐵鍊',
                '铰链' => '鉸鍊',
                '银链' => '銀鍊',
                '铺着' => '鋪著',
                '铺著书' => '鋪著書',
                '铺著作' => '鋪著作',
                '铺著名' => '鋪著名',
                '铺著录' => '鋪著錄',
                '铺著称' => '鋪著稱',
                '铺著者' => '鋪著者',
                '铺著述' => '鋪著述',
                '链子' => '鍊子',
                '链条' => '鍊條',
                '链锁' => '鍊鎖',
                '链锤' => '鍊錘',
                '锁链' => '鎖鍊',
                '锺锻' => '鍾鍛',
                '锻锺' => '鍛鍾',
                '闫怀礼' => '閻懷禮',
                '闭着' => '閉著',
                '闭著书' => '閉著書',
                '闭著作' => '閉著作',
                '闭著名' => '閉著名',
                '闭著录' => '閉著錄',
                '闭著称' => '閉著稱',
                '闭著者' => '閉著者',
                '闭著述' => '閉著述',
                '闲着' => '閑著',
                '闲著书' => '閑著書',
                '闲著作' => '閑著作',
                '闲著名' => '閑著名',
                '闲著录' => '閑著錄',
                '闲著称' => '閑著稱',
                '闲著者' => '閑著者',
                '闲著述' => '閑著述',
                '阿部正瞭' => '阿部正瞭',
                '附着' => '附著',
                '附睾' => '附睪',
                '附著书' => '附著書',
                '附著作' => '附著作',
                '附著名' => '附著名',
                '附著录' => '附著錄',
                '附著称' => '附著稱',
                '附著者' => '附著者',
                '附著述' => '附著述',
                '陋着' => '陋著',
                '陋著书' => '陋著書',
                '陋著作' => '陋著作',
                '陋著名' => '陋著名',
                '陋著录' => '陋著錄',
                '陋著称' => '陋著稱',
                '陋著者' => '陋著者',
                '陋著述' => '陋著述',
                '陪着' => '陪著',
                '陪著书' => '陪著書',
                '陪著作' => '陪著作',
                '陪著名' => '陪著名',
                '陪著录' => '陪著錄',
                '陪著称' => '陪著稱',
                '陪著者' => '陪著者',
                '陪著述' => '陪著述',
                '陳堵' => '陳堵',
                '陳禕' => '陳禕',
                '随着' => '隨著',
                '随著书' => '隨著書',
                '随著作' => '隨著作',
                '随著名' => '隨著名',
                '随著录' => '隨著錄',
                '随著称' => '隨著稱',
                '随著者' => '隨著者',
                '随著述' => '隨著述',
                '隔着' => '隔著',
                '隔著书' => '隔著書',
                '隔著作' => '隔著作',
                '隔著名' => '隔著名',
                '隔著录' => '隔著錄',
                '隔著称' => '隔著稱',
                '隔著者' => '隔著者',
                '隔著述' => '隔著述',
                '隱睾' => '隱睪',
                '雅着' => '雅著',
                '雅著书' => '雅著書',
                '雅著作' => '雅著作',
                '雅著名' => '雅著名',
                '雅著录' => '雅著錄',
                '雅著称' => '雅著稱',
                '雅著者' => '雅著者',
                '雅著述' => '雅著述',
                '雍乾' => '雍乾',
                '靠着' => '靠著',
                '靠著作' => '靠著作',
                '靠著名' => '靠著名',
                '靠著录' => '靠著錄',
                '靠著称' => '靠著稱',
                '靠著者' => '靠著者',
                '靠著述' => '靠著述',
                '顶着' => '頂著',
                '顶著书' => '頂著書',
                '顶著作' => '頂著作',
                '顶著名' => '頂著名',
                '顶著录' => '頂著錄',
                '顶著称' => '頂著稱',
                '顶著者' => '頂著者',
                '顶著述' => '頂著述',
                '项链' => '項鍊',
                '顺着' => '順著',
                '顺著书' => '順著書',
                '顺著作' => '順著作',
                '顺著名' => '順著名',
                '顺著录' => '順著錄',
                '顺著称' => '順著稱',
                '顺著者' => '順著者',
                '顺著述' => '順著述',
                '领着' => '領著',
                '领著书' => '領著書',
                '领著作' => '領著作',
                '领著名' => '領著名',
                '领著录' => '領著錄',
                '领著称' => '領著稱',
                '领著者' => '領著者',
                '领著述' => '領著述',
                '飘着' => '飄著',
                '飘著书' => '飄著書',
                '飘著作' => '飄著作',
                '飘著名' => '飄著名',
                '飘著录' => '飄著錄',
                '飘著称' => '飄著稱',
                '飘著者' => '飄著者',
                '飘著述' => '飄著述',
                '飭令' => '飭令',
                '驾着' => '駕著',
                '驾著书' => '駕著書',
                '驾著作' => '駕著作',
                '驾著名' => '駕著名',
                '驾著录' => '駕著錄',
                '驾著称' => '駕著稱',
                '驾著者' => '駕著者',
                '驾著述' => '駕著述',
                '骂着' => '罵著',
                '骂著书' => '罵著書',
                '骂著作' => '罵著作',
                '骂著名' => '罵著名',
                '骂著录' => '罵著錄',
                '骂著称' => '罵著稱',
                '骂著者' => '罵著者',
                '骂著述' => '罵著述',
                '骑着' => '騎著',
                '骑著书' => '騎著書',
                '骑著作' => '騎著作',
                '骑著名' => '騎著名',
                '骑著录' => '騎著錄',
                '骑著称' => '騎著稱',
                '骑著者' => '騎著者',
                '骑著述' => '騎著述',
                '骗着' => '騙著',
                '骗著书' => '騙著書',
                '骗著作' => '騙著作',
                '骗著名' => '騙著名',
                '骗著录' => '騙著錄',
                '骗著称' => '騙著稱',
                '骗著者' => '騙著者',
                '骗著述' => '騙著述',
                '高着' => '高著',
                '高著书' => '高著書',
                '高著作' => '高著作',
                '高著名' => '高著名',
                '高著录' => '高著錄',
                '高著称' => '高著稱',
                '高著者' => '高著者',
                '高著述' => '高著述',
                '髭着' => '髭著',
                '髭著书' => '髭著書',
                '髭著作' => '髭著作',
                '髭著名' => '髭著名',
                '髭著录' => '髭著錄',
                '髭著称' => '髭著稱',
                '髭著者' => '髭著者',
                '髭著述' => '髭著述',
                '鬱姓' => '鬱姓',
                '鬱氏' => '鬱氏',
                '魏徵' => '魏徵',
                '鱼干干' => '魚乾乾',
                '鲶鱼' => '鯰魚',
                '麯崇裕' => '麯崇裕',
                '麴义' => '麴义',
                '麴英' => '麴英',
                '麽氏' => '麽氏',
                '麽麽' => '麼麼',
                '黏着' => '黏著',
                '黏著书' => '黏著書',
                '黏著作' => '黏著作',
                '黏著名' => '黏著名',
                '黏著录' => '黏著錄',
                '黏著称' => '黏著稱',
                '黏著者' => '黏著者',
                '黏著述' => '黏著述',
            );
        return strtr($content, $cn2twDict);
    }

    /**
     * translate  tw to cn.
     * 
     * @param  string    $content 
     * @static
     * @access public
     * @return string
     */
    public static function reverse($content)
    {
        $cn2twDict = array
            (
                '它' => '牠',
                '㑇' => '㑳',
                '𪨊' => '㞞',
                '㟆' => '㠏',
                '㨫' => '㩜',
                '𫂈' => '䉬',
                '䌶' => '䊷',
                '䌺' => '䋙',
                '䌾' => '䋻',
                '𦈖' => '䌈',
                '䞍' => '䝼',
                '𩏼' => '䪏',
                '𩐀' => '䪗',
                '𩏿' => '䪘',
                '𩖗' => '䫴',
                '𩙮' => '䬘',
                '𩙯' => '䬝',
                '𩠇' => '䭀',
                '𩠈' => '䭃',
                '𩧭' => '䭿',
                '𩧰' => '䮝',
                '𩨁' => '䮞',
                '𩧿' => '䮠',
                '𩨏' => '䮳',
                '𩧪' => '䮾',
                '䯅' => '䯀',
                '鲃' => '䰾',
                '𩾈' => '䱙',
                '𩾊' => '䱬',
                '𩾋' => '䱰',
                '䲣' => '䱷',
                '䲝' => '䱽',
                '鳚' => '䲁',
                '𪉂' => '䲰',
                '𪎈' => '䴬',
                '𪎋' => '䴴',
                '丢' => '丟',
                '并' => '併',
                '干' => '榦',
                '乱' => '亂',
                '亘' => '亙',
                '亚' => '亞',
                '伫' => '佇',
                '布' => '佈',
                '占' => '佔',
                '来' => '來',
                '仑' => '崙',
                '侣' => '侶',
                '俣' => '俁',
                '系' => '繫',
                '伣' => '俔',
                '侠' => '俠',
                '伥' => '倀',
                '俩' => '倆',
                '俫' => '倈',
                '仓' => '倉',
                '个' => '箇',
                '们' => '們',
                '幸' => '倖',
                '伦' => '倫',
                '伟' => '偉',
                '侧' => '側',
                '侦' => '偵',
                '伪' => '僞',
                '杰' => '傑',
                '伧' => '傖',
                '伞' => '傘',
                '备' => '備',
                '家' => '傢',
                '佣' => '傭',
                '偬' => '傯',
                '传' => '傳',
                '伛' => '傴',
                '债' => '債',
                '伤' => '傷',
                '倾' => '傾',
                '偻' => '僂',
                '仅' => '僅',
                '佥' => '僉',
                '侨' => '僑',
                '仆' => '僕',
                '侥' => '僥',
                '偾' => '僨',
                '雇' => '僱',
                '价' => '價',
                '仪' => '儀',
                '侬' => '儂',
                '亿' => '億',
                '侩' => '儈',
                '俭' => '儉',
                '傧' => '儐',
                '俦' => '儔',
                '侪' => '儕',
                '尽' => '盡',
                '偿' => '償',
                '优' => '優',
                '储' => '儲',
                '俪' => '儷',
                '㑩' => '儸',
                '傩' => '儺',
                '傥' => '儻',
                '俨' => '儼',
                '凶' => '兇',
                '兑' => '兌',
                '儿' => '兒',
                '兖' => '兗',
                '内' => '內',
                '两' => '兩',
                '册' => '冊',
                '幂' => '冪',
                '净' => '淨',
                '冻' => '凍',
                '𪞝' => '凙',
                '凛' => '凜',
                '凯' => '凱',
                '别' => '彆',
                '删' => '刪',
                '刭' => '剄',
                '则' => '則',
                '克' => '剋',
                '刹' => '剎',
                '刬' => '剗',
                '刚' => '剛',
                '剥' => '剝',
                '剐' => '剮',
                '剀' => '剴',
                '创' => '創',
                '铲' => '鏟',
                '划' => '劃',
                '剧' => '劇',
                '刘' => '劉',
                '刽' => '劊',
                '刿' => '劌',
                '剑' => '劍',
                '㓥' => '劏',
                '剂' => '劑',
                '㔉' => '劚',
                '劲' => '勁',
                '动' => '動',
                '务' => '務',
                '勋' => '勳',
                '胜' => '勝',
                '劳' => '勞',
                '势' => '勢',
                '勚' => '勩',
                '劢' => '勱',
                '励' => '勵',
                '劝' => '勸',
                '匀' => '勻',
                '匦' => '匭',
                '汇' => '滙',
                '匮' => '匱',
                '区' => '區',
                '协' => '協',
                '却' => '卻',
                '即' => '卽',
                '厍' => '厙',
                '厕' => '廁',
                '历' => '歷',
                '厌' => '厭',
                '厉' => '厲',
                '厣' => '厴',
                '参' => '蔘',
                '叁' => '叄',
                '丛' => '叢',
                '咤' => '吒',
                '吴' => '吳',
                '呐' => '吶',
                '吕' => '呂',
                '呙' => '咼',
                '员' => '員',
                '呗' => '唄',
                '吣' => '唚',
                '问' => '問',
                '启' => '啟',
                '哑' => '啞',
                '唡' => '啢',
                '㖞' => '喎',
                '唤' => '喚',
                '丧' => '喪',
                '吃' => '喫',
                '乔' => '喬',
                '单' => '單',
                '哟' => '喲',
                '呛' => '嗆',
                '啬' => '嗇',
                '唝' => '嗊',
                '吗' => '嗎',
                '呜' => '嗚',
                '唢' => '嗩',
                '𠮶' => '嗰',
                '哔' => '嗶',
                '𪡏' => '嗹',
                '叹' => '歎',
                '喽' => '嘍',
                '呕' => '嘔',
                '啧' => '嘖',
                '尝' => '嚐',
                '唛' => '嘜',
                '哗' => '嘩',
                '唠' => '嘮',
                '啸' => '嘯',
                '叽' => '嘰',
                '哓' => '嘵',
                '呒' => '嘸',
                '啴' => '嘽',
                '恶' => '惡',
                '嘘' => '噓',
                '㖊' => '噚',
                '咝' => '噝',
                '哒' => '噠',
                '哝' => '噥',
                '哕' => '噦',
                '嗳' => '噯',
                '哙' => '噲',
                '喷' => '噴',
                '吨' => '噸',
                '当' => '當',
                '咛' => '嚀',
                '吓' => '嚇',
                '哜' => '嚌',
                '噜' => '嚕',
                '啮' => '嚙',
                '咽' => '嚥',
                '呖' => '嚦',
                '咙' => '嚨',
                '向' => '曏',
                '亸' => '嚲',
                '喾' => '嚳',
                '严' => '嚴',
                '嘤' => '嚶',
                '啭' => '囀',
                '嗫' => '囁',
                '嚣' => '囂',
                '冁' => '囅',
                '呓' => '囈',
                '苏' => '蘇',
                '嘱' => '囑',
                '囱' => '囪',
                '囵' => '圇',
                '国' => '國',
                '围' => '圍',
                '园' => '園',
                '圆' => '圓',
                '图' => '圖',
                '团' => '糰',
                '𪢮' => '圞',
                '埯' => '垵',
                '垭' => '埡',
                '采' => '採',
                '执' => '執',
                '坚' => '堅',
                '垩' => '堊',
                '垴' => '堖',
                '埚' => '堝',
                '尧' => '堯',
                '报' => '報',
                '场' => '場',
                '块' => '塊',
                '茔' => '塋',
                '垲' => '塏',
                '埘' => '塒',
                '涂' => '塗',
                '冢' => '塚',
                '坞' => '塢',
                '埙' => '塤',
                '尘' => '塵',
                '堑' => '塹',
                '垫' => '墊',
                '坠' => '墜',
                '堕' => '墮',
                '坛' => '罎',
                '坟' => '墳',
                '墙' => '牆',
                '垦' => '墾',
                '𡒄' => '壈',
                '垱' => '壋',
                '压' => '壓',
                '垒' => '壘',
                '圹' => '壙',
                '垆' => '壚',
                '坏' => '壞',
                '垄' => '壟',
                '垅' => '壠',
                '坜' => '壢',
                '坝' => '壩',
                '壮' => '壯',
                '壶' => '壺',
                '壸' => '壼',
                '寿' => '壽',
                '够' => '夠',
                '梦' => '夢',
                '伙' => '夥',
                '夹' => '夾',
                '奂' => '奐',
                '奥' => '奧',
                '奁' => '奩',
                '夺' => '奪',
                '奖' => '獎',
                '奋' => '奮',
                '姹' => '奼',
                '妆' => '妝',
                '姗' => '姍',
                '奸' => '姦',
                '娱' => '娛',
                '娄' => '婁',
                '妇' => '婦',
                '娅' => '婭',
                '娲' => '媧',
                '妫' => '嬀',
                '媪' => '媼',
                '妈' => '媽',
                '妪' => '嫗',
                '妩' => '嫵',
                '娴' => '嫻',
                '婳' => '嫿',
                '娆' => '嬈',
                '婵' => '嬋',
                '娇' => '嬌',
                '嫱' => '嬙',
                '嫒' => '嬡',
                '嬷' => '嬤',
                '嫔' => '嬪',
                '婴' => '嬰',
                '婶' => '嬸',
                '娈' => '孌',
                '孙' => '孫',
                '学' => '學',
                '孪' => '孿',
                '宫' => '宮',
                '寝' => '寢',
                '实' => '實',
                '宁' => '寧',
                '审' => '審',
                '写' => '寫',
                '宽' => '寬',
                '宠' => '寵',
                '宝' => '寶',
                '将' => '將',
                '专' => '專',
                '寻' => '尋',
                '对' => '對',
                '导' => '導',
                '尴' => '尷',
                '届' => '屆',
                '尸' => '屍',
                '屃' => '屓',
                '屉' => '屜',
                '屡' => '屢',
                '层' => '層',
                '屦' => '屨',
                '𪨗' => '屩',
                '属' => '屬',
                '冈' => '岡',
                '岘' => '峴',
                '岛' => '島',
                '峡' => '峽',
                '崃' => '崍',
                '昆' => '崑',
                '岗' => '崗',
                '峥' => '崢',
                '岽' => '崬',
                '岚' => '嵐',
                '岁' => '𡻕',
                '嵝' => '嶁',
                '崭' => '嶄',
                '岖' => '嶇',
                '嵚' => '嶔',
                '崂' => '嶗',
                '峤' => '嶠',
                '峣' => '嶢',
                '峄' => '嶧',
                '崄' => '嶮',
                '岙' => '嶴',
                '嵘' => '嶸',
                '岭' => '嶺',
                '屿' => '嶼',
                '岳' => '嶽',
                '岿' => '巋',
                '峦' => '巒',
                '巅' => '巔',
                '岩' => '巖',
                '巯' => '巰',
                '卺' => '巹',
                '帅' => '帥',
                '师' => '師',
                '帐' => '帳',
                '带' => '帶',
                '帧' => '幀',
                '帏' => '幃',
                '帼' => '幗',
                '帻' => '幘',
                '帜' => '幟',
                '币' => '幣',
                '帮' => '幫',
                '帱' => '幬',
                '么' => '麽',
                '几' => '幾',
                '库' => '庫',
                '厢' => '廂',
                '厩' => '廄',
                '厦' => '廈',
                '厨' => '廚',
                '厮' => '廝',
                '庙' => '廟',
                '厂' => '廠',
                '庑' => '廡',
                '废' => '廢',
                '广' => '廣',
                '廪' => '廩',
                '庐' => '廬',
                '厅' => '廳',
                '弑' => '弒',
                '吊' => '弔',
                '弪' => '弳',
                '张' => '張',
                '强' => '強',
                '弹' => '彈',
                '弥' => '瀰',
                '弯' => '彎',
                '彝' => '彞',
                '彦' => '彥',
                '后' => '後',
                '径' => '徑',
                '从' => '從',
                '徕' => '徠',
                '复' => '複',
                '征' => '徵',
                '彻' => '徹',
                '恒' => '恆',
                '耻' => '恥',
                '悦' => '悅',
                '悮' => '悞',
                '怅' => '悵',
                '闷' => '悶',
                '恼' => '惱',
                '恽' => '惲',
                '恻' => '惻',
                '爱' => '愛',
                '惬' => '愜',
                '悫' => '慤',
                '怆' => '愴',
                '恺' => '愷',
                '忾' => '愾',
                '栗' => '慄',
                '态' => '態',
                '愠' => '慍',
                '惨' => '慘',
                '惭' => '慚',
                '恸' => '慟',
                '惯' => '慣',
                '怄' => '慪',
                '怂' => '慫',
                '虑' => '慮',
                '悭' => '慳',
                '庆' => '慶',
                '戚' => '鏚',
                '欲' => '慾',
                '忧' => '憂',
                '惫' => '憊',
                '怜' => '憐',
                '凭' => '憑',
                '愦' => '憒',
                '惮' => '憚',
                '愤' => '憤',
                '悯' => '憫',
                '怃' => '憮',
                '宪' => '憲',
                '忆' => '憶',
                '恳' => '懇',
                '应' => '應',
                '怿' => '懌',
                '懔' => '懍',
                '蒙' => '矇',
                '怼' => '懟',
                '懑' => '懣',
                '恹' => '懨',
                '惩' => '懲',
                '懒' => '懶',
                '怀' => '懷',
                '悬' => '懸',
                '忏' => '懺',
                '惧' => '懼',
                '慑' => '懾',
                '恋' => '戀',
                '戆' => '戇',
                '戋' => '戔',
                '戗' => '戧',
                '戬' => '戩',
                '战' => '戰',
                '戯' => '戱',
                '戏' => '戲',
                '户' => '戶',
                '抛' => '拋',
                '拼' => '拚',
                '捝' => '挩',
                '挲' => '挱',
                '挟' => '挾',
                '舍' => '捨',
                '扪' => '捫',
                '挨' => '捱',
                '卷' => '捲',
                '扫' => '掃',
                '抡' => '掄',
                '挜' => '掗',
                '挣' => '掙',
                '挂' => '掛',
                '拣' => '揀',
                '扬' => '揚',
                '换' => '換',
                '挥' => '揮',
                '损' => '損',
                '摇' => '搖',
                '捣' => '搗',
                '揾' => '搵',
                '抢' => '搶',
                '掴' => '摑',
                '掼' => '摜',
                '搂' => '摟',
                '挚' => '摯',
                '抠' => '摳',
                '抟' => '摶',
                '折' => '摺',
                '掺' => '摻',
                '捞' => '撈',
                '挦' => '撏',
                '撑' => '撐',
                '挠' => '撓',
                '㧑' => '撝',
                '挢' => '撟',
                '掸' => '撣',
                '拨' => '撥',
                '抚' => '撫',
                '扑' => '撲',
                '揿' => '撳',
                '挞' => '撻',
                '挝' => '撾',
                '捡' => '撿',
                '拥' => '擁',
                '掳' => '擄',
                '择' => '擇',
                '击' => '擊',
                '挡' => '擋',
                '㧟' => '擓',
                '担' => '擔',
                '据' => '據',
                '挤' => '擠',
                '拟' => '擬',
                '摈' => '擯',
                '拧' => '擰',
                '搁' => '擱',
                '掷' => '擲',
                '扩' => '擴',
                '撷' => '擷',
                '摆' => '擺',
                '擞' => '擻',
                '撸' => '擼',
                '扰' => '擾',
                '摅' => '攄',
                '撵' => '攆',
                '拢' => '攏',
                '拦' => '攔',
                '撄' => '攖',
                '搀' => '攙',
                '撺' => '攛',
                '携' => '攜',
                '摄' => '攝',
                '攒' => '攢',
                '挛' => '攣',
                '摊' => '攤',
                '搅' => '攪',
                '揽' => '攬',
                '败' => '敗',
                '叙' => '敘',
                '敌' => '敵',
                '数' => '數',
                '敛' => '斂',
                '毙' => '斃',
                '斓' => '斕',
                '斩' => '斬',
                '断' => '斷',
                '于' => '於',
                '旗' => '旂',
                '既' => '旣',
                '升' => '陞',
                '时' => '時',
                '晋' => '晉',
                '昼' => '晝',
                '晕' => '暈',
                '晖' => '暉',
                '旸' => '暘',
                '畅' => '暢',
                '暂' => '暫',
                '晔' => '曄',
                '昙' => '曇',
                '晓' => '曉',
                '暧' => '曖',
                '旷' => '曠',
                '昽' => '曨',
                '晒' => '曬',
                '书' => '書',
                '会' => '會',
                '胧' => '朧',
                '术' => '術',
                '东' => '東',
                '锨' => '鍁',
                '栅' => '柵',
                '杆' => '桿',
                '栀' => '梔',
                '枧' => '梘',
                '条' => '條',
                '枭' => '梟',
                '棁' => '梲',
                '弃' => '棄',
                '棋' => '棊',
                '枨' => '棖',
                '枣' => '棗',
                '栋' => '棟',
                '' => '棡',
                '栈' => '棧',
                '栖' => '棲',
                '梾' => '棶',
                '桠' => '椏',
                '杨' => '楊',
                '枫' => '楓',
                '桢' => '楨',
                '业' => '業',
                '极' => '極',
                '杩' => '榪',
                '荣' => '榮',
                '榅' => '榲',
                '桤' => '榿',
                '构' => '構',
                '枪' => '槍',
                '杠' => '槓',
                '梿' => '槤',
                '椠' => '槧',
                '椁' => '槨',
                '桨' => '槳',
                '桩' => '樁',
                '乐' => '樂',
                '枞' => '樅',
                '梁' => '樑',
                '楼' => '樓',
                '标' => '標',
                '枢' => '樞',
                '样' => '樣',
                '朴' => '樸',
                '树' => '樹',
                '桦' => '樺',
                '桡' => '橈',
                '桥' => '橋',
                '机' => '機',
                '椭' => '橢',
                '横' => '橫',
                '檩' => '檁',
                '柽' => '檉',
                '档' => '檔',
                '桧' => '檜',
                '槚' => '檟',
                '检' => '檢',
                '樯' => '檣',
                '梼' => '檮',
                '台' => '颱',
                '槟' => '檳',
                '柠' => '檸',
                '槛' => '檻',
                '柜' => '櫃',
                '橹' => '櫓',
                '榈' => '櫚',
                '栉' => '櫛',
                '椟' => '櫝',
                '橼' => '櫞',
                '栎' => '櫟',
                '橱' => '櫥',
                '槠' => '櫧',
                '栌' => '櫨',
                '枥' => '櫪',
                '橥' => '櫫',
                '榇' => '櫬',
                '蘖' => '櫱',
                '栊' => '櫳',
                '榉' => '欅',
                '樱' => '櫻',
                '栏' => '欄',
                '权' => '權',
                '椤' => '欏',
                '栾' => '欒',
                '榄' => '欖',
                '棂' => '欞',
                '钦' => '欽',
                '欧' => '歐',
                '欤' => '歟',
                '欢' => '歡',
                '归' => '歸',
                '殁' => '歿',
                '残' => '殘',
                '殒' => '殞',
                '殇' => '殤',
                '㱮' => '殨',
                '殚' => '殫',
                '僵' => '殭',
                '殓' => '殮',
                '殡' => '殯',
                '㱩' => '殰',
                '歼' => '殲',
                '杀' => '殺',
                '壳' => '殼',
                '毁' => '譭',
                '殴' => '毆',
                '毵' => '毿',
                '牦' => '氂',
                '毡' => '氈',
                '氇' => '氌',
                '气' => '氣',
                '氢' => '氫',
                '氩' => '氬',
                '氲' => '氳',
                '污' => '汙',
                '决' => '決',
                '没' => '沒',
                '冲' => '衝',
                '况' => '況',
                '溯' => '遡',
                '泄' => '洩',
                '汹' => '洶',
                '浃' => '浹',
                '泾' => '涇',
                '凉' => '涼',
                '凄' => '淒',
                '泪' => '淚',
                '渌' => '淥',
                '凌' => '淩',
                '沦' => '淪',
                '渊' => '淵',
                '涞' => '淶',
                '浅' => '淺',
                '涣' => '渙',
                '减' => '減',
                '涡' => '渦',
                '测' => '測',
                '浑' => '渾',
                '凑' => '湊',
                '浈' => '湞',
                '涌' => '湧',
                '汤' => '湯',
                '沩' => '潙',
                '准' => '準',
                '沟' => '溝',
                '温' => '溫',
                '沧' => '滄',
                '灭' => '滅',
                '涤' => '滌',
                '荥' => '滎',
                '沪' => '滬',
                '滞' => '滯',
                '渗' => '滲',
                '卤' => '鹵',
                '浒' => '滸',
                '浐' => '滻',
                '滚' => '滾',
                '满' => '滿',
                '渔' => '漁',
                '沤' => '漚',
                '汉' => '漢',
                '涟' => '漣',
                '渍' => '漬',
                '涨' => '漲',
                '溆' => '漵',
                '渐' => '漸',
                '浆' => '漿',
                '颍' => '潁',
                '泼' => '潑',
                '洁' => '潔',
                '潜' => '潛',
                '润' => '潤',
                '浔' => '潯',
                '溃' => '潰',
                '滗' => '潷',
                '涠' => '潿',
                '涩' => '澀',
                '浇' => '澆',
                '涝' => '澇',
                '沄' => '澐',
                '涧' => '澗',
                '渑' => '澠',
                '泽' => '澤',
                '滪' => '澦',
                '泶' => '澩',
                '浍' => '澮',
                '淀' => '澱',
                '㳠' => '澾',
                '浊' => '濁',
                '浓' => '濃',
                '湿' => '濕',
                '泞' => '濘',
                '济' => '濟',
                '涛' => '濤',
                '滥' => '濫',
                '潍' => '濰',
                '滨' => '濱',
                '溅' => '濺',
                '泺' => '濼',
                '滤' => '濾',
                '滢' => '瀅',
                '渎' => '瀆',
                '㲿' => '瀇',
                '泻' => '瀉',
                '沈' => '瀋',
                '浏' => '瀏',
                '濒' => '瀕',
                '泸' => '瀘',
                '沥' => '瀝',
                '潇' => '瀟',
                '潆' => '瀠',
                '潴' => '瀦',
                '泷' => '瀧',
                '濑' => '瀨',
                '潋' => '瀲',
                '澜' => '瀾',
                '沣' => '灃',
                '滠' => '灄',
                '洒' => '灑',
                '漓' => '灕',
                '滩' => '灘',
                '灏' => '灝',
                '漤' => '灠',
                '湾' => '灣',
                '滦' => '灤',
                '滟' => '灧',
                '灾' => '災',
                '为' => '爲',
                '乌' => '烏',
                '烃' => '烴',
                '无' => '無',
                '炼' => '鍊',
                '炜' => '煒',
                '烟' => '煙',
                '茕' => '煢',
                '焕' => '煥',
                '烦' => '煩',
                '炀' => '煬',
                '㶽' => '煱',
                '煴' => '熅',
                '荧' => '熒',
                '炝' => '熗',
                '热' => '熱',
                '颎' => '熲',
                '炽' => '熾',
                '烨' => '燁',
                '灯' => '燈',
                '炖' => '燉',
                '烧' => '燒',
                '烫' => '燙',
                '焖' => '燜',
                '营' => '營',
                '灿' => '燦',
                '烛' => '燭',
                '烩' => '燴',
                '㶶' => '燶',
                '烬' => '燼',
                '焘' => '燾',
                '烁' => '爍',
                '炉' => '爐',
                '烂' => '爛',
                '争' => '爭',
                '爷' => '爺',
                '尔' => '爾',
                '牍' => '牘',
                '牵' => '牽',
                '荦' => '犖',
                '犊' => '犢',
                '牺' => '犧',
                '状' => '狀',
                '狭' => '狹',
                '狈' => '狽',
                '狰' => '猙',
                '犹' => '猶',
                '狲' => '猻',
                '犸' => '獁',
                '呆' => '獃',
                '狱' => '獄',
                '狮' => '獅',
                '独' => '獨',
                '狯' => '獪',
                '猃' => '獫',
                '狝' => '獮',
                '狞' => '獰',
                '㺍' => '獱',
                '获' => '穫',
                '猎' => '獵',
                '犷' => '獷',
                '兽' => '獸',
                '獭' => '獺',
                '献' => '獻',
                '猕' => '獼',
                '猡' => '玀',
                '现' => '現',
                '珐' => '琺',
                '珲' => '琿',
                '玮' => '瑋',
                '玚' => '瑒',
                '琐' => '瑣',
                '瑶' => '瑤',
                '莹' => '瑩',
                '玛' => '瑪',
                '玱' => '瑲',
                '𪻐' => '瑽',
                '琏' => '璉',
                '玑' => '璣',
                '瑷' => '璦',
                '珰' => '璫',
                '环' => '環',
                '玺' => '璽',
                '琼' => '瓊',
                '珑' => '瓏',
                '璎' => '瓔',
                '瓒' => '瓚',
                '瓯' => '甌',
                '瓮' => '甕',
                '产' => '産',
                '亩' => '畝',
                '毕' => '畢',
                '画' => '畵',
                '异' => '異',
                '畴' => '疇',
                '叠' => '疊',
                '痉' => '痙',
                '酸' => '痠',
                '疴' => '痾',
                '痖' => '瘂',
                '疯' => '瘋',
                '疡' => '瘍',
                '痪' => '瘓',
                '瘗' => '瘞',
                '疮' => '瘡',
                '疟' => '瘧',
                '瘆' => '瘮',
                '疭' => '瘲',
                '瘘' => '瘻',
                '疗' => '療',
                '痨' => '癆',
                '痫' => '癇',
                '瘅' => '癉',
                '愈' => '癒',
                '疠' => '癘',
                '瘪' => '癟',
                '痴' => '癡',
                '痒' => '癢',
                '疖' => '癤',
                '症' => '癥',
                '疬' => '癧',
                '癞' => '癩',
                '癣' => '癬',
                '瘿' => '癭',
                '瘾' => '癮',
                '痈' => '癰',
                '瘫' => '癱',
                '癫' => '癲',
                '发' => '髮',
                '皑' => '皚',
                '疱' => '皰',
                '皲' => '皸',
                '皱' => '皺',
                '杯' => '盃',
                '盗' => '盜',
                '盏' => '盞',
                '监' => '監',
                '盘' => '盤',
                '卢' => '盧',
                '荡' => '蕩',
                '眦' => '眥',
                '众' => '衆',
                '𪾢' => '睍',
                '困' => '睏',
                '睁' => '睜',
                '睐' => '睞',
                '眍' => '瞘',
                '䁖' => '瞜',
                '瞒' => '瞞',
                '了' => '瞭',
                '瞆' => '瞶',
                '睑' => '瞼',
                '眬' => '矓',
                '瞩' => '矚',
                '矫' => '矯',
                '朱' => '硃',
                '硁' => '硜',
                '硖' => '硤',
                '砗' => '硨',
                '砚' => '硯',
                '埼' => '碕',
                '硕' => '碩',
                '砀' => '碭',
                '砜' => '碸',
                '确' => '確',
                '码' => '碼',
                '硙' => '磑',
                '砖' => '磚',
                '碜' => '磣',
                '碛' => '磧',
                '矶' => '磯',
                '硗' => '磽',
                '硷' => '礆',
                '础' => '礎',
                '碍' => '礙',
                '矿' => '礦',
                '砺' => '礪',
                '砾' => '礫',
                '矾' => '礬',
                '砻' => '礱',
                '算' => '祘',
                '禄' => '祿',
                '祸' => '禍',
                '祯' => '禎',
                '祎' => '禕',
                '祃' => '禡',
                '御' => '禦',
                '禅' => '禪',
                '礼' => '禮',
                '祢' => '禰',
                '祷' => '禱',
                '秃' => '禿',
                '籼' => '秈',
                '税' => '稅',
                '秆' => '稈',
                '䅉' => '稏',
                '棱' => '稜',
                '禀' => '稟',
                '种' => '種',
                '称' => '稱',
                '谷' => '穀',
                '稣' => '穌',
                '积' => '積',
                '颖' => '穎',
                '秾' => '穠',
                '穑' => '穡',
                '秽' => '穢',
                '稳' => '穩',
                '稆' => '穭',
                '窝' => '窩',
                '洼' => '窪',
                '穷' => '窮',
                '窑' => '窯',
                '窎' => '窵',
                '窭' => '窶',
                '窥' => '窺',
                '窜' => '竄',
                '窍' => '竅',
                '窦' => '竇',
                '灶' => '竈',
                '窃' => '竊',
                '竖' => '豎',
                '竞' => '競',
                '笔' => '筆',
                '笋' => '筍',
                '笕' => '筧',
                '䇲' => '筴',
                '笺' => '箋',
                '筝' => '箏',
                '节' => '節',
                '范' => '範',
                '筑' => '築',
                '箧' => '篋',
                '筼' => '篔',
                '笃' => '篤',
                '筛' => '篩',
                '筚' => '篳',
                '箦' => '簀',
                '篓' => '簍',
                '蓑' => '簑',
                '箪' => '簞',
                '简' => '簡',
                '篑' => '簣',
                '箫' => '簫',
                '筜' => '簹',
                '签' => '籤',
                '帘' => '簾',
                '篮' => '籃',
                '筹' => '籌',
                '箓' => '籙',
                '箨' => '籜',
                '籁' => '籟',
                '笼' => '籠',
                '笾' => '籩',
                '簖' => '籪',
                '篱' => '籬',
                '箩' => '籮',
                '吁' => '籲',
                '粤' => '粵',
                '糁' => '糝',
                '粪' => '糞',
                '粮' => '糧',
                '粝' => '糲',
                '籴' => '糴',
                '粜' => '糶',
                '纟' => '糹',
                '纠' => '糾',
                '纪' => '紀',
                '纣' => '紂',
                '约' => '約',
                '红' => '紅',
                '纡' => '紆',
                '纥' => '紇',
                '纨' => '紈',
                '纫' => '紉',
                '纹' => '紋',
                '纳' => '納',
                '纽' => '紐',
                '纾' => '紓',
                '纯' => '純',
                '纰' => '紕',
                '纼' => '紖',
                '纱' => '紗',
                '纮' => '紘',
                '纸' => '紙',
                '级' => '級',
                '纷' => '紛',
                '纭' => '紜',
                '纴' => '紝',
                '纺' => '紡',
                '䌷' => '紬',
                '扎' => '紮',
                '细' => '細',
                '绂' => '紱',
                '绁' => '紲',
                '绅' => '紳',
                '纻' => '紵',
                '绍' => '紹',
                '绀' => '紺',
                '绋' => '紼',
                '绐' => '紿',
                '绌' => '絀',
                '终' => '終',
                '组' => '組',
                '䌹' => '絅',
                '绊' => '絆',
                '绗' => '絎',
                '结' => '結',
                '绝' => '絶',
                '绦' => '縧',
                '绔' => '絝',
                '绞' => '絞',
                '络' => '絡',
                '绚' => '絢',
                '给' => '給',
                '绒' => '絨',
                '绖' => '絰',
                '统' => '統',
                '丝' => '絲',
                '绛' => '絳',
                '绢' => '絹',
                '𫄨' => '絺',
                '绑' => '綁',
                '绡' => '綃',
                '绠' => '綆',
                '绨' => '綈',
                '绣' => '繡',
                '绤' => '綌',
                '绥' => '綏',
                '䌼' => '綐',
                '经' => '經',
                '综' => '綜',
                '缍' => '綞',
                '绿' => '緑',
                '绸' => '綢',
                '绻' => '綣',
                '线' => '線',
                '绶' => '綬',
                '维' => '維',
                '绹' => '綯',
                '绾' => '綰',
                '纲' => '綱',
                '网' => '網',
                '绷' => '繃',
                '缀' => '綴',
                '彩' => '綵',
                '纶' => '綸',
                '绺' => '綹',
                '绮' => '綺',
                '绽' => '綻',
                '绰' => '綽',
                '绫' => '綾',
                '绵' => '綿',
                '绲' => '緄',
                '缁' => '緇',
                '紧' => '緊',
                '绯' => '緋',
                '绪' => '緒',
                '绬' => '緓',
                '绱' => '鞝',
                '缃' => '緗',
                '缄' => '緘',
                '缂' => '緙',
                '缉' => '緝',
                '缎' => '緞',
                '缔' => '締',
                '缗' => '緡',
                '缘' => '緣',
                '缌' => '緦',
                '编' => '編',
                '缓' => '緩',
                '缅' => '緬',
                '纬' => '緯',
                '缑' => '緱',
                '缈' => '緲',
                '练' => '練',
                '缏' => '緶',
                '缇' => '緹',
                '致' => '緻',
                '萦' => '縈',
                '缙' => '縉',
                '缢' => '縊',
                '缒' => '縋',
                '绉' => '縐',
                '缣' => '縑',
                '缊' => '縕',
                '缞' => '縗',
                '缚' => '縛',
                '缜' => '縝',
                '缟' => '縞',
                '缛' => '縟',
                '县' => '縣',
                '缝' => '縫',
                '缡' => '縭',
                '缩' => '縮',
                '纵' => '縱',
                '缧' => '縲',
                '䌸' => '縳',
                '纤' => '纖',
                '缦' => '縵',
                '絷' => '縶',
                '缕' => '縷',
                '缥' => '縹',
                '总' => '總',
                '绩' => '績',
                '缫' => '繅',
                '缪' => '繆',
                '穗' => '繐',
                '缯' => '繒',
                '织' => '織',
                '缮' => '繕',
                '缭' => '繚',
                '绕' => '繞',
                '缋' => '繢',
                '绳' => '繩',
                '绘' => '繪',
                '茧' => '繭',
                '缰' => '韁',
                '缳' => '繯',
                '缲' => '繰',
                '缴' => '繳',
                '䍁' => '繸',
                '绎' => '繹',
                '继' => '繼',
                '缤' => '繽',
                '缱' => '繾',
                '䍀' => '繿',
                '𫄸' => '纁',
                '缬' => '纈',
                '纩' => '纊',
                '续' => '續',
                '累' => '纍',
                '缠' => '纏',
                '缨' => '纓',
                '才' => '纔',
                '缵' => '纘',
                '缆' => '纜',
                '钵' => '鉢',
                '罂' => '罌',
                '罚' => '罰',
                '骂' => '駡',
                '罢' => '罷',
                '罗' => '羅',
                '罴' => '羆',
                '羁' => '羈',
                '芈' => '羋',
                '羟' => '羥',
                '羡' => '羨',
                '义' => '義',
                '习' => '習',
                '翘' => '翹',
                '耧' => '耬',
                '耢' => '耮',
                '圣' => '聖',
                '闻' => '聞',
                '联' => '聯',
                '聪' => '聰',
                '声' => '聲',
                '耸' => '聳',
                '聩' => '聵',
                '聂' => '聶',
                '职' => '職',
                '聍' => '聹',
                '听' => '聽',
                '聋' => '聾',
                '肃' => '肅',
                '胁' => '脅',
                '脉' => '脈',
                '胫' => '脛',
                '唇' => '脣',
                '脱' => '脫',
                '胀' => '脹',
                '肾' => '腎',
                '胨' => '腖',
                '脶' => '腡',
                '脑' => '腦',
                '肿' => '腫',
                '脚' => '腳',
                '肠' => '腸',
                '腽' => '膃',
                '肤' => '膚',
                '胶' => '膠',
                '腻' => '膩',
                '胆' => '膽',
                '脍' => '膾',
                '脓' => '膿',
                '脸' => '臉',
                '脐' => '臍',
                '膑' => '臏',
                '腊' => '臘',
                '胪' => '臚',
                '脏' => '髒',
                '脔' => '臠',
                '臜' => '臢',
                '卧' => '臥',
                '临' => '臨',
                '与' => '與',
                '兴' => '興',
                '举' => '舉',
                '旧' => '舊',
                '馆' => '館',
                '舱' => '艙',
                '舣' => '艤',
                '舰' => '艦',
                '舻' => '艫',
                '艰' => '艱',
                '艳' => '豔',
                '刍' => '芻',
                '苎' => '苧',
                '兹' => '茲',
                '荆' => '荊',
                '庄' => '莊',
                '茎' => '莖',
                '荚' => '莢',
                '苋' => '莧',
                '华' => '華',
                '庵' => '菴',
                '苌' => '萇',
                '莱' => '萊',
                '万' => '萬',
                '莴' => '萵',
                '叶' => '葉',
                '荭' => '葒',
                '荮' => '葤',
                '苇' => '葦',
                '药' => '藥',
                '荤' => '葷',
                '莼' => '蓴',
                '莳' => '蒔',
                '莅' => '蒞',
                '苍' => '蒼',
                '荪' => '蓀',
                '盖' => '蓋',
                '莲' => '蓮',
                '苁' => '蓯',
                '荜' => '蓽',
                '卜' => '蔔',
                '蒌' => '蔞',
                '蒋' => '蔣',
                '葱' => '蔥',
                '茑' => '蔦',
                '荫' => '蔭',
                '荨' => '蕁',
                '蒇' => '蕆',
                '荞' => '蕎',
                '荬' => '蕒',
                '芸' => '蕓',
                '莸' => '蕕',
                '荛' => '蕘',
                '蒉' => '蕢',
                '芜' => '蕪',
                '萧' => '蕭',
                '蓣' => '蕷',
                '蕰' => '薀',
                '荟' => '薈',
                '蓟' => '薊',
                '芗' => '薌',
                '姜' => '薑',
                '蔷' => '薔',
                '荙' => '薘',
                '莶' => '薟',
                '荐' => '薦',
                '萨' => '薩',
                '䓕' => '薳',
                '苧' => '薴',
                '荠' => '薺',
                '蓝' => '藍',
                '荩' => '藎',
                '艺' => '藝',
                '薮' => '藪',
                '蕴' => '蘊',
                '苈' => '藶',
                '蔼' => '藹',
                '蔺' => '藺',
                '蕲' => '蘄',
                '芦' => '蘆',
                '苹' => '蘋',
                '藓' => '蘚',
                '蔹' => '蘞',
                '茏' => '蘢',
                '兰' => '蘭',
                '蓠' => '蘺',
                '萝' => '蘿',
                '蔂' => '虆',
                '处' => '處',
                '虚' => '虛',
                '虏' => '虜',
                '号' => '號',
                '亏' => '虧',
                '虬' => '虯',
                '蛱' => '蛺',
                '蜕' => '蛻',
                '蚬' => '蜆',
                '蚀' => '蝕',
                '猬' => '蝟',
                '虾' => '蝦',
                '蜗' => '蝸',
                '蛳' => '螄',
                '蚂' => '螞',
                '萤' => '螢',
                '䗖' => '螮',
                '蝼' => '螻',
                '螀' => '螿',
                '蛰' => '蟄',
                '蝈' => '蟈',
                '螨' => '蟎',
                '虮' => '蟣',
                '蝉' => '蟬',
                '蛲' => '蟯',
                '虫' => '蟲',
                '蛏' => '蟶',
                '蚁' => '蟻',
                '蝇' => '蠅',
                '虿' => '蠆',
                '蝎' => '蠍',
                '蛴' => '蠐',
                '蝾' => '蠑',
                '蜡' => '蠟',
                '蛎' => '蠣',
                '蟏' => '蠨',
                '蛊' => '蠱',
                '蚕' => '蠶',
                '蛮' => '蠻',
                '蔑' => '衊',
                '同' => '衕',
                '胡' => '鬍',
                '卫' => '衛',
                '只' => '隻',
                '衮' => '袞',
                '袅' => '裊',
                '里' => '裡',
                '补' => '補',
                '装' => '裝',
                '制' => '製',
                '裈' => '褌',
                '袆' => '褘',
                '裤' => '褲',
                '裢' => '褳',
                '褛' => '褸',
                '亵' => '褻',
                '𫌀' => '襀',
                '幞' => '襆',
                '裥' => '襇',
                '袯' => '襏',
                '袄' => '襖',
                '裣' => '襝',
                '裆' => '襠',
                '褴' => '襤',
                '袜' => '襪',
                '䙓' => '襬',
                '衬' => '襯',
                '袭' => '襲',
                '见' => '見',
                '觃' => '覎',
                '规' => '規',
                '觅' => '覓',
                '视' => '視',
                '觇' => '覘',
                '觋' => '覡',
                '觍' => '覥',
                '觎' => '覦',
                '亲' => '親',
                '觊' => '覬',
                '觏' => '覯',
                '觐' => '覲',
                '觑' => '覷',
                '觉' => '覺',
                '𫌨' => '覼',
                '览' => '覽',
                '觌' => '覿',
                '观' => '觀',
                '觞' => '觴',
                '觯' => '觶',
                '触' => '觸',
                '讠' => '訁',
                '订' => '訂',
                '讣' => '訃',
                '计' => '計',
                '讯' => '訊',
                '讧' => '訌',
                '讨' => '討',
                '讦' => '訐',
                '𫍙' => '訑',
                '讱' => '訒',
                '训' => '訓',
                '讪' => '訕',
                '讫' => '訖',
                '托' => '託',
                '记' => '記',
                '讹' => '訛',
                '讶' => '訝',
                '讼' => '訟',
                '䜣' => '訢',
                '诀' => '訣',
                '讷' => '訥',
                '讻' => '訩',
                '访' => '訪',
                '设' => '設',
                '许' => '許',
                '诉' => '訴',
                '诃' => '訶',
                '诊' => '診',
                '注' => '註',
                '诂' => '詁',
                '诋' => '詆',
                '讵' => '詎',
                '诈' => '詐',
                '诒' => '詒',
                '诏' => '詔',
                '评' => '評',
                '诐' => '詖',
                '诇' => '詗',
                '诎' => '詘',
                '诅' => '詛',
                '词' => '詞',
                '咏' => '詠',
                '诩' => '詡',
                '询' => '詢',
                '诣' => '詣',
                '试' => '試',
                '诗' => '詩',
                '诧' => '詫',
                '诟' => '詬',
                '诡' => '詭',
                '诠' => '詮',
                '诘' => '詰',
                '话' => '話',
                '该' => '該',
                '详' => '詳',
                '诜' => '詵',
                '诙' => '詼',
                '诖' => '詿',
                '诔' => '誄',
                '诛' => '誅',
                '诓' => '誆',
                '夸' => '誇',
                '志' => '誌',
                '认' => '認',
                '诳' => '誑',
                '诶' => '誒',
                '诞' => '誕',
                '诱' => '誘',
                '诮' => '誚',
                '语' => '語',
                '诚' => '誠',
                '诫' => '誡',
                '诬' => '誣',
                '误' => '誤',
                '诰' => '誥',
                '诵' => '誦',
                '诲' => '誨',
                '说' => '説',
                '谁' => '誰',
                '课' => '課',
                '谇' => '誶',
                '诽' => '誹',
                '谊' => '誼',
                '訚' => '誾',
                '调' => '調',
                '谄' => '諂',
                '谆' => '諄',
                '谈' => '談',
                '诿' => '諉',
                '请' => '請',
                '诤' => '諍',
                '诹' => '諏',
                '诼' => '諑',
                '谅' => '諒',
                '论' => '論',
                '谂' => '諗',
                '谀' => '諛',
                '谍' => '諜',
                '谞' => '諝',
                '谝' => '諞',
                '诨' => '諢',
                '谔' => '諤',
                '谛' => '諦',
                '谐' => '諧',
                '谏' => '諫',
                '谕' => '諭',
                '咨' => '諮',
                '𫍰' => '諰',
                '讳' => '諱',
                '谙' => '諳',
                '谌' => '諶',
                '讽' => '諷',
                '诸' => '諸',
                '谚' => '諺',
                '谖' => '諼',
                '诺' => '諾',
                '谋' => '謀',
                '谒' => '謁',
                '谓' => '謂',
                '誊' => '謄',
                '诌' => '謅',
                '谎' => '謊',
                '谜' => '謎',
                '𫍲' => '謏',
                '谧' => '謐',
                '谑' => '謔',
                '谡' => '謖',
                '谤' => '謗',
                '谦' => '謙',
                '谥' => '謚',
                '讲' => '講',
                '谢' => '謝',
                '谣' => '謡',
                '谟' => '謨',
                '谪' => '謫',
                '谬' => '謬',
                '谫' => '譾',
                '讴' => '謳',
                '谨' => '謹',
                '谩' => '謾',
                '䜧' => '譅',
                '证' => '證',
                '𫍢' => '譊',
                '谲' => '譎',
                '讥' => '譏',
                '谮' => '譖',
                '识' => '識',
                '谯' => '譙',
                '谭' => '譚',
                '谱' => '譜',
                '谵' => '譫',
                '译' => '譯',
                '议' => '議',
                '谴' => '譴',
                '护' => '護',
                '诪' => '譸',
                '誉' => '譽',
                '读' => '讀',
                '变' => '變',
                '仇' => '讎',
                '谗' => '讒',
                '让' => '讓',
                '谰' => '讕',
                '谶' => '讖',
                '赞' => '贊',
                '谠' => '讜',
                '谳' => '讞',
                '岂' => '豈',
                '丰' => '豐',
                '猪' => '豬',
                '豮' => '豶',
                '猫' => '貓',
                '䝙' => '貙',
                '贝' => '貝',
                '贞' => '貞',
                '贠' => '貟',
                '负' => '負',
                '财' => '財',
                '贡' => '貢',
                '贫' => '貧',
                '货' => '貨',
                '贩' => '販',
                '贪' => '貪',
                '贯' => '貫',
                '责' => '責',
                '贮' => '貯',
                '贳' => '貰',
                '赀' => '貲',
                '贰' => '貳',
                '贵' => '貴',
                '贬' => '貶',
                '买' => '買',
                '贷' => '貸',
                '贶' => '貺',
                '费' => '費',
                '贴' => '貼',
                '贻' => '貽',
                '贸' => '貿',
                '贺' => '賀',
                '贲' => '賁',
                '赂' => '賂',
                '赁' => '賃',
                '贿' => '賄',
                '赅' => '賅',
                '资' => '資',
                '贾' => '賈',
                '贼' => '賊',
                '赈' => '賑',
                '赊' => '賒',
                '宾' => '賓',
                '赇' => '賕',
                '赒' => '賙',
                '赉' => '賚',
                '赐' => '賜',
                '赏' => '賞',
                '赔' => '賠',
                '赓' => '賡',
                '贤' => '賢',
                '卖' => '賣',
                '贱' => '賤',
                '赋' => '賦',
                '赕' => '賧',
                '质' => '質',
                '赍' => '齎',
                '账' => '賬',
                '赌' => '賭',
                '䞐' => '賰',
                '赖' => '賴',
                '赗' => '賵',
                '赚' => '賺',
                '赙' => '賻',
                '购' => '購',
                '赛' => '賽',
                '赜' => '賾',
                '贽' => '贄',
                '赘' => '贅',
                '赟' => '贇',
                '赠' => '贈',
                '赝' => '贗',
                '赡' => '贍',
                '赢' => '贏',
                '赆' => '贐',
                '赃' => '贜',
                '赑' => '贔',
                '赎' => '贖',
                '赣' => '贛',
                '赪' => '赬',
                '赶' => '趕',
                '赵' => '趙',
                '趋' => '趨',
                '趱' => '趲',
                '迹' => '跡',
                '践' => '踐',
                '踊' => '踴',
                '跄' => '蹌',
                '跸' => '蹕',
                '蹒' => '蹣',
                '踪' => '蹤',
                '跷' => '蹺',
                '𫏋' => '蹻',
                '跶' => '躂',
                '趸' => '躉',
                '踌' => '躊',
                '跻' => '躋',
                '跃' => '躍',
                '踯' => '躑',
                '跞' => '躒',
                '踬' => '躓',
                '蹰' => '躕',
                '跹' => '躚',
                '蹑' => '躡',
                '蹿' => '躥',
                '躜' => '躦',
                '躏' => '躪',
                '躯' => '軀',
                '车' => '車',
                '轧' => '軋',
                '轨' => '軌',
                '军' => '軍',
                '𫐄' => '軏',
                '轪' => '軑',
                '轩' => '軒',
                '轫' => '軔',
                '轭' => '軛',
                '软' => '軟',
                '轷' => '軤',
                '𫐉' => '軨',
                '轸' => '軫',
                '轱' => '軲',
                '轴' => '軸',
                '轵' => '軹',
                '轺' => '軺',
                '轲' => '軻',
                '轶' => '軼',
                '轼' => '軾',
                '较' => '較',
                '辂' => '輅',
                '辁' => '輇',
                '辀' => '輈',
                '载' => '載',
                '轾' => '輊',
                '辄' => '輒',
                '挽' => '輓',
                '辅' => '輔',
                '轻' => '輕',
                '𫐐' => '輗',
                '辆' => '輛',
                '辎' => '輜',
                '辉' => '輝',
                '辋' => '輞',
                '辍' => '輟',
                '辊' => '輥',
                '辇' => '輦',
                '辈' => '輩',
                '轮' => '輪',
                '辌' => '輬',
                '𫐓' => '輮',
                '辑' => '輯',
                '辏' => '輳',
                '输' => '輸',
                '辐' => '輻',
                '辗' => '輾',
                '舆' => '輿',
                '辒' => '轀',
                '毂' => '轂',
                '辖' => '轄',
                '辕' => '轅',
                '辘' => '轆',
                '转' => '轉',
                '辙' => '轍',
                '轿' => '轎',
                '辚' => '轔',
                '轰' => '轟',
                '辔' => '轡',
                '轹' => '轢',
                '𫐆' => '轣',
                '轳' => '轤',
                '办' => '辦',
                '辞' => '辭',
                '辫' => '辮',
                '辩' => '辯',
                '农' => '農',
                '回' => '迴',
                '迳' => '逕',
                '这' => '這',
                '连' => '連',
                '周' => '週',
                '进' => '進',
                '游' => '遊',
                '运' => '運',
                '过' => '過',
                '达' => '達',
                '违' => '違',
                '遥' => '遙',
                '逊' => '遜',
                '递' => '遞',
                '远' => '遠',
                '适' => '適',
                '迟' => '遲',
                '迁' => '遷',
                '选' => '選',
                '遗' => '遺',
                '辽' => '遼',
                '迈' => '邁',
                '还' => '還',
                '迩' => '邇',
                '边' => '邊',
                '逻' => '邏',
                '逦' => '邐',
                '郏' => '郟',
                '邮' => '郵',
                '郓' => '鄆',
                '乡' => '鄉',
                '邹' => '鄒',
                '邬' => '鄔',
                '郧' => '鄖',
                '邓' => '鄧',
                '郑' => '鄭',
                '邻' => '鄰',
                '郸' => '鄲',
                '邺' => '鄴',
                '郐' => '鄶',
                '邝' => '鄺',
                '酂' => '酇',
                '郦' => '酈',
                '酝' => '醞',
                '丑' => '醜',
                '糖' => '醣',
                '医' => '醫',
                '酱' => '醬',
                '酰' => '醯',
                '酦' => '醱',
                '酿' => '釀',
                '衅' => '釁',
                '酾' => '釃',
                '酽' => '釅',
                '释' => '釋',
                '厘' => '釐',
                '钅' => '釒',
                '钆' => '釓',
                '钇' => '釔',
                '钌' => '釕',
                '钊' => '釗',
                '钉' => '釘',
                '钋' => '釙',
                '针' => '針',
                '钓' => '釣',
                '钐' => '釤',
                '钏' => '釧',
                '钒' => '釩',
                '𨰿' => '釳',
                '钗' => '釵',
                '钍' => '釷',
                '钕' => '釹',
                '钎' => '釺',
                '䥺' => '釾',
                '钯' => '鈀',
                '钫' => '鈁',
                '钘' => '鈃',
                '钭' => '鈄',
                '𫓧' => '鈇',
                '钚' => '鈈',
                '钠' => '鈉',
                '𨱂' => '鈋',
                '钝' => '鈍',
                '钩' => '鉤',
                '钤' => '鈐',
                '钣' => '鈑',
                '钑' => '鈒',
                '钞' => '鈔',
                '钮' => '鈕',
                '钧' => '鈞',
                '𨱁' => '鈠',
                '钙' => '鈣',
                '钬' => '鈥',
                '钛' => '鈦',
                '钪' => '鈧',
                '铌' => '鈮',
                '𨱄' => '鈯',
                '铈' => '鈰',
                '𨱃' => '鈲',
                '钶' => '鈳',
                '铃' => '鈴',
                '钴' => '鈷',
                '钹' => '鈸',
                '铍' => '鈹',
                '钰' => '鈺',
                '钸' => '鈽',
                '铀' => '鈾',
                '钿' => '鈿',
                '钾' => '鉀',
                '𨱅' => '鉁',
                '钜' => '鉅',
                '铊' => '鉈',
                '铉' => '鉉',
                '铇' => '鉋',
                '铋' => '鉍',
                '铂' => '鉑',
                '钷' => '鉕',
                '钳' => '鉗',
                '铆' => '鉚',
                '铅' => '鉛',
                '钺' => '鉞',
                '钲' => '鉦',
                '钼' => '鉬',
                '钽' => '鉭',
                '铏' => '鉶',
                '铰' => '鉸',
                '铒' => '鉺',
                '铬' => '鉻',
                '铪' => '鉿',
                '银' => '銀',
                '铳' => '銃',
                '铜' => '銅',
                '铚' => '銍',
                '铣' => '銑',
                '铨' => '銓',
                '铢' => '銖',
                '铭' => '銘',
                '铫' => '銚',
                '铦' => '銛',
                '衔' => '銜',
                '铑' => '銠',
                '铷' => '銣',
                '铱' => '銥',
                '铟' => '銦',
                '铵' => '銨',
                '铥' => '銩',
                '铕' => '銪',
                '铯' => '銫',
                '铐' => '銬',
                '铞' => '銱',
                '锐' => '鋭',
                '𨱇' => '銶',
                '销' => '銷',
                '锈' => '鏽',
                '锑' => '銻',
                '锉' => '銼',
                '铝' => '鋁',
                '锒' => '鋃',
                '锌' => '鋅',
                '钡' => '鋇',
                '𨱈' => '鋉',
                '铤' => '鋌',
                '铗' => '鋏',
                '锋' => '鋒',
                '铻' => '鋙',
                '锊' => '鋝',
                '锓' => '鋟',
                '铘' => '鋣',
                '锄' => '鋤',
                '锃' => '鋥',
                '锔' => '鋦',
                '锇' => '鋨',
                '铓' => '鋩',
                '铺' => '鋪',
                '铖' => '鋮',
                '锆' => '鋯',
                '锂' => '鋰',
                '铽' => '鋱',
                '锍' => '鋶',
                '锯' => '鋸',
                '钢' => '鋼',
                '锞' => '錁',
                '𨱋' => '錂',
                '录' => '録',
                '锖' => '錆',
                '锫' => '錇',
                '锩' => '錈',
                '铔' => '錏',
                '锥' => '錐',
                '锕' => '錒',
                '锟' => '錕',
                '锤' => '鎚',
                '锱' => '錙',
                '铮' => '錚',
                '锛' => '錛',
                '锬' => '錟',
                '锭' => '錠',
                '锜' => '錡',
                '钱' => '錢',
                '锦' => '錦',
                '锚' => '錨',
                '锠' => '錩',
                '锡' => '錫',
                '锢' => '錮',
                '错' => '錯',
                '锰' => '錳',
                '表' => '錶',
                '铼' => '錸',
                '锝' => '鍀',
                '锪' => '鍃',
                '𨱉' => '鍄',
                '钔' => '鍆',
                '锴' => '鍇',
                '锳' => '鍈',
                '锅' => '鍋',
                '镀' => '鍍',
                '锷' => '鍔',
                '铡' => '鍘',
                '钖' => '鍚',
                '锻' => '鍛',
                '锽' => '鍠',
                '锸' => '鍤',
                '锲' => '鍥',
                '锘' => '鍩',
                '锹' => '鍬',
                '𨱎' => '鍮',
                '锾' => '鍰',
                '键' => '鍵',
                '锶' => '鍶',
                '锗' => '鍺',
                '钟' => '鐘',
                '镁' => '鎂',
                '锿' => '鎄',
                '镅' => '鎇',
                '镑' => '鎊',
                '镰' => '鐮',
                '镕' => '鎔',
                '锁' => '鎖',
                '镉' => '鎘',
                '镈' => '鎛',
                '𨱏' => '鎝',
                '镃' => '鎡',
                '钨' => '鎢',
                '蓥' => '鎣',
                '镏' => '鎦',
                '铠' => '鎧',
                '铩' => '鎩',
                '锼' => '鎪',
                '镐' => '鎬',
                '鎮' => '鎭',
                '镇' => '鎮',
                '𨱍' => '鎯',
                '镒' => '鎰',
                '镋' => '鎲',
                '镍' => '鎳',
                '镓' => '鎵',
                '𨰾' => '鎷',
                '镌' => '鐫',
                '镎' => '鎿',
                '镞' => '鏃',
                '𨱌' => '鏆',
                '镟' => '鏇',
                '链' => '鏈',
                '𨱒' => '鏉',
                '镆' => '鏌',
                '镙' => '鏍',
                '镠' => '鏐',
                '镝' => '鏑',
                '铿' => '鏗',
                '锵' => '鏘',
                '镗' => '鏜',
                '镘' => '鏝',
                '镛' => '鏞',
                '镜' => '鏡',
                '镖' => '鏢',
                '镂' => '鏤',
                '𫓩' => '鏦',
                '錾' => '鏨',
                '镚' => '鏰',
                '铧' => '鏵',
                '镤' => '鏷',
                '镪' => '鏹',
                '䥽' => '鏺',
                '铙' => '鐃',
                '铴' => '鐋',
                '𫔎' => '鐍',
                '𨱓' => '鐎',
                '𨱔' => '鐏',
                '镣' => '鐐',
                '铹' => '鐒',
                '镦' => '鐓',
                '镡' => '鐔',
                '镫' => '鐙',
                '镢' => '钁',
                '镨' => '鐠',
                '䦅' => '鐥',
                '锎' => '鐦',
                '锏' => '鐧',
                '镄' => '鐨',
                '䦃' => '鐯',
                '镯' => '鐲',
                '镭' => '鐳',
                '铁' => '鐵',
                '镮' => '鐶',
                '铎' => '鐸',
                '铛' => '鐺',
                '镱' => '鐿',
                '铸' => '鑄',
                '镬' => '鑊',
                '镔' => '鑌',
                '鉴' => '鑒',
                '镲' => '鑔',
                '锧' => '鑕',
                '镴' => '鑞',
                '铄' => '鑠',
                '镳' => '鑣',
                '镥' => '鑥',
                '镧' => '鑭',
                '钥' => '鑰',
                '镵' => '鑱',
                '镶' => '鑲',
                '镊' => '鑷',
                '镩' => '鑹',
                '锣' => '鑼',
                '钻' => '鑽',
                '銮' => '鑾',
                '凿' => '鑿',
                '旋' => '镟',
                '长' => '長',
                '门' => '門',
                '闩' => '閂',
                '闪' => '閃',
                '闫' => '閆',
                '闬' => '閈',
                '闭' => '閉',
                '开' => '開',
                '闶' => '閌',
                '𨸂' => '閍',
                '闳' => '閎',
                '闰' => '閏',
                '𨸃' => '閐',
                '闲' => '閒',
                '间' => '間',
                '闵' => '閔',
                '闸' => '閘',
                '阂' => '閡',
                '阁' => '閣',
                '合' => '閤',
                '阀' => '閥',
                '闺' => '閨',
                '闽' => '閩',
                '阃' => '閫',
                '阆' => '閬',
                '闾' => '閭',
                '阅' => '閲',
                '阊' => '閶',
                '阉' => '閹',
                '阎' => '閻',
                '阏' => '閼',
                '阍' => '閽',
                '阈' => '閾',
                '阌' => '閿',
                '阒' => '闃',
                '板' => '闆',
                '闱' => '闈',
                '阔' => '闊',
                '阕' => '闋',
                '阑' => '闌',
                '阇' => '闍',
                '阗' => '闐',
                '阘' => '闒',
                '闿' => '闓',
                '阖' => '闔',
                '阙' => '闕',
                '闯' => '闖',
                '关' => '關',
                '阚' => '闞',
                '阓' => '闠',
                '阐' => '闡',
                '辟' => '闢',
                '阛' => '闤',
                '闼' => '闥',
                '陉' => '陘',
                '陕' => '陝',
                '阵' => '陣',
                '阴' => '陰',
                '陈' => '陳',
                '陆' => '陸',
                '阳' => '陽',
                '陧' => '隉',
                '队' => '隊',
                '阶' => '階',
                '陨' => '隕',
                '际' => '際',
                '随' => '隨',
                '险' => '險',
                '隐' => '隱',
                '陇' => '隴',
                '隶' => '隸',
                '隽' => '雋',
                '虽' => '雖',
                '双' => '雙',
                '雏' => '雛',
                '杂' => '雜',
                '鸡' => '鷄',
                '离' => '離',
                '难' => '難',
                '云' => '雲',
                '电' => '電',
                '霡' => '霢',
                '雾' => '霧',
                '霁' => '霽',
                '雳' => '靂',
                '霭' => '靄',
                '灵' => '靈',
                '靓' => '靚',
                '静' => '靜',
                '腼' => '靦',
                '靥' => '靨',
                '鼗' => '鞀',
                '巩' => '鞏',
                '秋' => '鞦',
                '鞒' => '鞽',
                '鞑' => '韃',
                '千' => '韆',
                '鞯' => '韉',
                '韦' => '韋',
                '韧' => '韌',
                '韨' => '韍',
                '韩' => '韓',
                '韪' => '韙',
                '韬' => '韜',
                '鞲' => '韝',
                '韫' => '韞',
                '韵' => '韻',
                '响' => '響',
                '页' => '頁',
                '顶' => '頂',
                '顷' => '頃',
                '项' => '項',
                '顺' => '順',
                '顸' => '頇',
                '须' => '鬚',
                '顼' => '頊',
                '颂' => '頌',
                '颀' => '頎',
                '颃' => '頏',
                '预' => '預',
                '顽' => '頑',
                '颁' => '頒',
                '顿' => '頓',
                '颇' => '頗',
                '领' => '領',
                '颌' => '頜',
                '颉' => '頡',
                '颐' => '頤',
                '颏' => '頦',
                '头' => '頭',
                '颒' => '頮',
                '颊' => '頰',
                '颋' => '頲',
                '颕' => '頴',
                '颔' => '頷',
                '颈' => '頸',
                '颓' => '頽',
                '频' => '頻',
                '𩖖' => '顃',
                '颗' => '顆',
                '题' => '題',
                '额' => '額',
                '颚' => '顎',
                '颜' => '顔',
                '颙' => '顒',
                '颛' => '顓',
                '愿' => '願',
                '颡' => '顙',
                '颠' => '顛',
                '类' => '類',
                '颟' => '顢',
                '颢' => '顥',
                '顾' => '顧',
                '颤' => '顫',
                '颥' => '顬',
                '显' => '顯',
                '颦' => '顰',
                '颅' => '顱',
                '颞' => '顳',
                '颧' => '顴',
                '风' => '風',
                '飐' => '颭',
                '飑' => '颮',
                '飒' => '颯',
                '𩙥' => '颰',
                '刮' => '颳',
                '飓' => '颶',
                '𩙪' => '颷',
                '飔' => '颸',
                '飏' => '颺',
                '飖' => '颻',
                '飕' => '颼',
                '𩙫' => '颾',
                '飗' => '飀',
                '飘' => '飄',
                '飙' => '飆',
                '飚' => '飈',
                '飞' => '飛',
                '饣' => '飠',
                '饥' => '饑',
                '饤' => '飣',
                '饦' => '飥',
                '饨' => '飩',
                '饪' => '飪',
                '饫' => '飫',
                '饬' => '飭',
                '饭' => '飯',
                '飧' => '飱',
                '饮' => '飲',
                '饴' => '飴',
                '饲' => '飼',
                '饱' => '飽',
                '饰' => '飾',
                '饳' => '飿',
                '饺' => '餃',
                '饸' => '餄',
                '饼' => '餅',
                '饷' => '餉',
                '养' => '養',
                '饵' => '餌',
                '饹' => '餎',
                '饻' => '餏',
                '饽' => '餑',
                '馁' => '餒',
                '饿' => '餓',
                '𫗦' => '餔',
                '馂' => '餕',
                '饾' => '餖',
                '𫗧' => '餗',
                '余' => '餘',
                '肴' => '餚',
                '馄' => '餛',
                '馃' => '餜',
                '饯' => '餞',
                '馅' => '餡',
                '𫗠' => '餦',
                '𫗮' => '餭',
                '糇' => '餱',
                '饧' => '餳',
                '喂' => '餵',
                '馉' => '餶',
                '馇' => '餷',
                '𩠌' => '餸',
                '馎' => '餺',
                '饩' => '餼',
                '馏' => '餾',
                '馊' => '餿',
                '馌' => '饁',
                '馍' => '饃',
                '馒' => '饅',
                '馐' => '饈',
                '馑' => '饉',
                '馓' => '饊',
                '馈' => '饋',
                '馔' => '饌',
                '饶' => '饒',
                '飨' => '饗',
                '𫗴' => '饘',
                '餍' => '饜',
                '馋' => '饞',
                '馕' => '饢',
                '马' => '馬',
                '驭' => '馭',
                '冯' => '馮',
                '驮' => '馱',
                '驰' => '馳',
                '驯' => '馴',
                '驲' => '馹',
                '驳' => '駁',
                '𫘝' => '駃',
                '𩧨' => '駎',
                '驻' => '駐',
                '驽' => '駑',
                '驹' => '駒',
                '驵' => '駔',
                '驾' => '駕',
                '骀' => '駘',
                '驸' => '駙',
                '𩧫' => '駚',
                '驶' => '駛',
                '驼' => '駝',
                '驷' => '駟',
                '骈' => '駢',
                '𩧲' => '駧',
                '𩧴' => '駩',
                '骇' => '駭',
                '骃' => '駰',
                '骆' => '駱',
                '𩧺' => '駶',
                '骎' => '駸',
                '𫘣' => '駻',
                '骏' => '駿',
                '骋' => '騁',
                '骍' => '騂',
                '𫘤' => '騃',
                '骓' => '騅',
                '骔' => '騌',
                '骒' => '騍',
                '骑' => '騎',
                '骐' => '騏',
                '𩨀' => '騔',
                '骛' => '騖',
                '骗' => '騙',
                '𩨊' => '騚',
                '𩨃' => '騝',
                '𩨈' => '騟',
                '𫘨' => '騠',
                '骙' => '騤',
                '䯄' => '騧',
                '𩨄' => '騪',
                '骞' => '騫',
                '骘' => '騭',
                '骝' => '騮',
                '腾' => '騰',
                '驺' => '騶',
                '骚' => '騷',
                '骟' => '騸',
                '骡' => '騾',
                '蓦' => '驀',
                '骜' => '驁',
                '骖' => '驂',
                '骠' => '驃',
                '骢' => '驄',
                '驱' => '驅',
                '骅' => '驊',
                '𩧯' => '驋',
                '骕' => '驌',
                '骁' => '驍',
                '骣' => '驏',
                '骄' => '驕',
                '验' => '驗',
                '惊' => '驚',
                '驿' => '驛',
                '骤' => '驟',
                '驴' => '驢',
                '骧' => '驤',
                '骥' => '驥',
                '骦' => '驦',
                '骊' => '驪',
                '骉' => '驫',
                '肮' => '骯',
                '髅' => '髏',
                '体' => '體',
                '髌' => '髕',
                '髋' => '髖',
                '松' => '鬆',
                '鬓' => '鬢',
                '斗' => '鬥',
                '闹' => '鬧',
                '哄' => '鬨',
                '阋' => '鬩',
                '阄' => '鬮',
                '郁' => '鬱',
                '魉' => '魎',
                '魇' => '魘',
                '鱼' => '魚',
                '鱽' => '魛',
                '𫚉' => '魟',
                '鱾' => '魢',
                '𩽹' => '魥',
                '鲀' => '魨',
                '鲁' => '魯',
                '鲂' => '魴',
                '鱿' => '魷',
                '鲄' => '魺',
                '鲅' => '鮁',
                '鲆' => '鮃',
                '𫚒' => '鮄',
                '鲌' => '鮊',
                '鲉' => '鮋',
                '鲏' => '鮍',
                '鲇' => '鯰',
                '鲐' => '鮐',
                '鲍' => '鮑',
                '鲋' => '鮒',
                '鲊' => '鮓',
                '𩾀' => '鮕',
                '鲒' => '鮚',
                '鲘' => '鮜',
                '鲞' => '鯗',
                '鲕' => '鮞',
                '𩽾' => '鮟',
                '䲟' => '鮣',
                '鲖' => '鮦',
                '鲔' => '鮪',
                '鲛' => '鮫',
                '鲑' => '鮭',
                '鲜' => '鮮',
                '𫚔' => '鮰',
                '鲓' => '鮳',
                '鲪' => '鮶',
                '𩾃' => '鮸',
                '鲝' => '鮺',
                '鲧' => '鯀',
                '鲠' => '鯁',
                '𩾁' => '鯄',
                '𫚙' => '鯆',
                '鲩' => '鯇',
                '鲤' => '鯉',
                '鲨' => '鯊',
                '鲬' => '鯒',
                '鲻' => '鯔',
                '鲯' => '鯕',
                '鲭' => '鯖',
                '鲷' => '鯛',
                '鲴' => '鯝',
                '鲱' => '鯡',
                '鲵' => '鯢',
                '鲲' => '鯤',
                '鲳' => '鯧',
                '鲸' => '鯨',
                '鲮' => '鯪',
                '鲰' => '鯫',
                '𩾇' => '鯱',
                '鲺' => '鯴',
                '𩽼' => '鯶',
                '鳀' => '鯷',
                '鲫' => '鯽',
                '鳊' => '鯿',
                '鳈' => '鰁',
                '鲗' => '鰂',
                '鳂' => '鰃',
                '䲠' => '鰆',
                '鲽' => '鰈',
                '鳇' => '鰉',
                '䲡' => '鰌',
                '鳅' => '鰍',
                '鲾' => '鰏',
                '鳄' => '鱷',
                '鳆' => '鰒',
                '鳃' => '鰓',
                '鳒' => '鰜',
                '鳑' => '鰟',
                '鳋' => '鰠',
                '鲥' => '鰣',
                '𫚕' => '鰤',
                '鳏' => '鰥',
                '䲢' => '鰧',
                '鳎' => '鰨',
                '鳐' => '鰩',
                '鳍' => '鰭',
                '鳁' => '鰮',
                '鲢' => '鰱',
                '鳌' => '鰲',
                '鳓' => '鰳',
                '鳘' => '鰵',
                '鲦' => '鰷',
                '鲣' => '鰹',
                '鲹' => '鰺',
                '鳗' => '鰻',
                '鳛' => '鰼',
                '鳔' => '鰾',
                '鳉' => '鱂',
                '鳙' => '鱅',
                '𩾌' => '鱇',
                '鳕' => '鱈',
                '鳖' => '鱉',
                '鳟' => '鱒',
                '鳝' => '鱔',
                '鳜' => '鱖',
                '鳞' => '鱗',
                '鲟' => '鱘',
                '鲼' => '鱝',
                '鲎' => '鱟',
                '鲙' => '鱠',
                '鳣' => '鱣',
                '鳡' => '鱤',
                '鳢' => '鱧',
                '鲿' => '鱨',
                '鲚' => '鱭',
                '𫚈' => '鱮',
                '鳠' => '鱯',
                '鲈' => '鱸',
                '鲡' => '鱺',
                '鸟' => '鳥',
                '凫' => '鳬',
                '鸠' => '鳩',
                '鸤' => '鳲',
                '凤' => '鳳',
                '鸣' => '鳴',
                '鸢' => '鳶',
                '𫛛' => '鳷',
                '𪉃' => '鳼',
                '䴓' => '鳾',
                '𫛞' => '鴃',
                '鸩' => '鴆',
                '鸨' => '鴇',
                '鸦' => '鴉',
                '鸰' => '鴒',
                '鸵' => '鴕',
                '𫁡' => '鴗',
                '鸳' => '鴛',
                '𪉈' => '鴜',
                '鸲' => '鴝',
                '鸮' => '鴞',
                '鸱' => '鴟',
                '鸪' => '鴣',
                '鸯' => '鴦',
                '鸭' => '鴨',
                '鸸' => '鴯',
                '鸹' => '鴰',
                '𪉆' => '鴲',
                '鸻' => '鴴',
                '䴕' => '鴷',
                '鸿' => '鴻',
                '鸽' => '鴿',
                '䴔' => '鵁',
                '鸺' => '鵂',
                '鸼' => '鵃',
                '鹀' => '鵐',
                '鹃' => '鵑',
                '鹆' => '鵒',
                '鹁' => '鵓',
                '𪉍' => '鵚',
                '鹈' => '鵜',
                '鹅' => '鵝',
                '鹄' => '鵠',
                '鹉' => '鵡',
                '鹌' => '鵪',
                '鹏' => '鵬',
                '鹐' => '鵮',
                '鹎' => '鵯',
                '雕' => '鵰',
                '鹊' => '鵲',
                '鹓' => '鵷',
                '鹍' => '鵾',
                '䴖' => '鶄',
                '鸫' => '鶇',
                '鹑' => '鶉',
                '鹒' => '鶊',
                '𫛶' => '鶒',
                '鹋' => '鶓',
                '鹙' => '鶖',
                '𫛸' => '鶗',
                '鹕' => '鶘',
                '鹗' => '鶚',
                '鹖' => '鶡',
                '鹛' => '鶥',
                '鹜' => '鶩',
                '䴗' => '鶪',
                '鸧' => '鶬',
                '莺' => '鶯',
                '鹟' => '鶲',
                '鹤' => '鶴',
                '鹠' => '鶹',
                '鹡' => '鶺',
                '鹘' => '鶻',
                '鹣' => '鶼',
                '鹚' => '鷀',
                '鹢' => '鷁',
                '鹞' => '鷂',
                '䴘' => '鷈',
                '鹝' => '鷊',
                '鹧' => '鷓',
                '𪉑' => '鷔',
                '鹥' => '鷖',
                '鸥' => '鷗',
                '鸷' => '鷙',
                '鹨' => '鷚',
                '鸶' => '鷥',
                '鹪' => '鷦',
                '𪉊' => '鷨',
                '鹔' => '鷫',
                '鹩' => '鷯',
                '鹫' => '鷲',
                '鹇' => '鷳',
                '鹬' => '鷸',
                '鹰' => '鷹',
                '鹭' => '鷺',
                '鸴' => '鷽',
                '䴙' => '鷿',
                '㶉' => '鸂',
                '鹯' => '鸇',
                '𫛢' => '鸋',
                '鹱' => '鸌',
                '鹲' => '鸏',
                '鸬' => '鸕',
                '鹴' => '鸘',
                '鹦' => '鸚',
                '鹳' => '鸛',
                '鹂' => '鸝',
                '鸾' => '鸞',
                '咸' => '鹹',
                '鹾' => '鹺',
                '碱' => '鹼',
                '盐' => '鹽',
                '丽' => '麗',
                '麦' => '麥',
                '𪎊' => '麨',
                '麸' => '麩',
                '面' => '麵',
                '曲' => '麴',
                '𪎉' => '麲',
                '𪎌' => '麳',
                '黄' => '黃',
                '黉' => '黌',
                '点' => '點',
                '党' => '黨',
                '黪' => '黲',
                '霉' => '黴',
                '黡' => '黶',
                '黩' => '黷',
                '黾' => '黽',
                '鼋' => '黿',
                '鼍' => '鼉',
                '冬' => '鼕',
                '鼹' => '鼴',
                '齄' => '齇',
                '齐' => '齊',
                '斋' => '齋',
                '齑' => '齏',
                '齿' => '齒',
                '龀' => '齔',
                '龁' => '齕',
                '龂' => '齗',
                '龅' => '齙',
                '龇' => '齜',
                '龃' => '齟',
                '龆' => '齠',
                '龄' => '齡',
                '出' => '齣',
                '龈' => '齦',
                '龊' => '齪',
                '龉' => '齬',
                '龋' => '齲',
                '腭' => '齶',
                '龌' => '齷',
                '龙' => '龍',
                '厐' => '龎',
                '庞' => '龐',
                '龚' => '龔',
                '龛' => '龕',
                '龟' => '龜',
                '㛟' => '𡞵',
                '㛿' => '𡠹',
                '㛠' => '𡢃',
                '㻘' => '𤪺',
                '㻏' => '𤫩',
                '䑽' => '𦪙',
                '䙊' => '𧜵',
                '䘛' => '𧝞',
                '𫍟' => '𧦧',
                '䜥' => '𧩙',
                '䞌' => '𧵳',
                '䢂' => '𨋢',
                '𨱀' => '𨥛',
                '䦀' => '𨦫',
                '䦁' => '𨧜',
                '𨱊' => '𨧱',
                '𨱐' => '𨫒',
                '𨱕' => '𨮂',
                '䥿' => '𨯅',
                '𩏾' => '𩎢',
                '𩏽' => '𩏪',
                '𩖕' => '𩓣',
                '𩙦' => '𩗀',
                '𩙧' => '𩗡',
                '𩙩' => '𩘀',
                '𩙭' => '𩘝',
                '𩙨' => '𩘹',
                '𩙬' => '𩘺',
                '𩙰' => '𩙈',
                '𩠆' => '𩜦',
                '𩠋' => '𩝔',
                '䭪' => '𩞯',
                '𩠅' => '𩟐',
                '𩧦' => '𩡺',
                '𩧬' => '𩢡',
                '𩧵' => '𩢴',
                '𩧳' => '𩢸',
                '𩧮' => '𩢾',
                '𩧶' => '𩣏',
                '䯃' => '𩣑',
                '𩧻' => '𩣵',
                '𩧼' => '𩣺',
                '𩧩' => '𩤊',
                '𩨆' => '𩤙',
                '𩨉' => '𩤲',
                '𩨅' => '𩤸',
                '𩨋' => '𩥄',
                '𩨍' => '𩥇',
                '𩧱' => '𩥉',
                '𩨌' => '𩥑',
                '𩨐' => '𩧆',
                '𩽺' => '𩵩',
                '𩽻' => '𩵹',
                '䲞' => '𩶘',
                '𩽿' => '𩶰',
                '𩽽' => '𩶱',
                '𩾄' => '𩷰',
                '𩾅' => '𩸃',
                '𩾆' => '𩸦',
                '𩾎' => '𩽇',
                '𪉄' => '𩿪',
                '𪉅' => '𪀦',
                '𪉋' => '𪀾',
                '𪉉' => '𪁈',
                '𪉌' => '𪁖',
                '𪉎' => '𪂆',
                '𪉐' => '𪃍',
                '𪉏' => '𪃏',
                '𪉔' => '𪄆',
                '𪉒' => '𪄕',
                '𪉕' => '𪇳',
                '𪚏' => '𪘀',
                '𪚐' => '𪘯',
                '軿' => '𫚒',
                '《易乾' => '《易乾',
                '不着痕迹' => '不著痕跡',
                '不着边际' => '不著邊際',
                '与着' => '與著',
                '与著书' => '與著書',
                '与著作' => '與著作',
                '与著名' => '與著名',
                '与著录' => '與著錄',
                '与著称' => '與著稱',
                '与著者' => '與著者',
                '与著述' => '與著述',
                '丑着' => '丑著',
                '丑著书' => '丑著書',
                '丑著作' => '丑著作',
                '丑著名' => '丑著名',
                '丑著录' => '丑著錄',
                '丑著称' => '丑著稱',
                '丑著者' => '丑著者',
                '丑著述' => '丑著述',
                '专著' => '專著',
                '临着' => '臨著',
                '临著书' => '臨著書',
                '临著作' => '臨著作',
                '临著名' => '臨著名',
                '临著录' => '臨著錄',
                '临著称' => '臨著稱',
                '临著者' => '臨著者',
                '临著述' => '臨著述',
                '丽着' => '麗著',
                '丽著书' => '麗著書',
                '丽著作' => '麗著作',
                '丽著名' => '麗著名',
                '丽著录' => '麗著錄',
                '丽著称' => '麗著稱',
                '丽著者' => '麗著者',
                '丽著述' => '麗著述',
                '乐着' => '樂著',
                '乐著书' => '樂著書',
                '乐著作' => '樂著作',
                '乐著名' => '樂著名',
                '乐著录' => '樂著錄',
                '乐著称' => '樂著稱',
                '乐著者' => '樂著者',
                '乐著述' => '樂著述',
                '乘着' => '乘著',
                '乘著书' => '乘著書',
                '乘著作' => '乘著作',
                '乘著名' => '乘著名',
                '乘著录' => '乘著錄',
                '乘著称' => '乘著稱',
                '乘著者' => '乘著者',
                '乘著述' => '乘著述',
                '乾上乾下' => '乾上乾下',
                '乾为天' => '乾為天',
                '乾为阳' => '乾為陽',
                '乾九' => '乾九',
                '乾乾' => '乾乾',
                '乾亨' => '乾亨',
                '乾仪' => '乾仪',
                '乾位' => '乾位',
                '乾健' => '乾健',
                '乾健也' => '乾健也',
                '乾元' => '乾元',
                '乾光' => '乾光',
                '乾兴' => '乾興',
                '乾冈' => '乾岡',
                '乾刘' => '乾刘',
                '乾刚' => '乾刚',
                '乾务' => '乾务',
                '乾化' => '乾化',
                '乾卦' => '乾卦',
                '乾县' => '乾縣',
                '乾台' => '乾台',
                '乾吉' => '乾吉',
                '乾启' => '乾启',
                '乾命' => '乾命',
                '乾和' => '乾和',
                '乾嘉' => '乾嘉',
                '乾图' => '乾图',
                '乾坤' => '乾坤',
                '乾城' => '乾城',
                '乾基' => '乾基',
                '乾天也' => '乾天也',
                '乾始' => '乾始',
                '乾姓' => '乾姓',
                '乾宁' => '乾宁',
                '乾宅' => '乾宅',
                '乾宇' => '乾宇',
                '乾安' => '乾安',
                '乾定' => '乾定',
                '乾封' => '乾封',
                '乾居' => '乾居',
                '乾岗' => '乾岗',
                '乾巛' => '乾巛',
                '乾州' => '乾州',
                '乾式' => '乾式',
                '乾录' => '乾录',
                '乾律' => '乾律',
                '乾德' => '乾德',
                '乾心' => '乾心',
                '乾忠' => '乾忠',
                '乾文' => '乾文',
                '乾断' => '乾断',
                '乾方' => '乾方',
                '乾施' => '乾施',
                '乾旦' => '乾旦',
                '乾明' => '乾明',
                '乾昧' => '乾昧',
                '乾晖' => '乾晖',
                '乾景' => '乾景',
                '乾晷' => '乾晷',
                '乾曜' => '乾曜',
                '乾构' => '乾構',
                '乾枢' => '乾樞',
                '乾栋' => '乾棟',
                '乾步' => '乾步',
                '乾氏' => '乾氏',
                '乾沓和' => '乾沓和',
                '乾沓婆' => '乾沓婆',
                '乾泉' => '乾泉',
                '乾淳' => '乾淳',
                '乾清宫' => '乾清宫',
                '乾渥' => '乾渥',
                '乾灵' => '乾灵',
                '乾男' => '乾男',
                '乾皋' => '乾皋',
                '乾盛世' => '乾盛世',
                '乾矢' => '乾矢',
                '乾祐' => '乾祐',
                '乾穹' => '乾穹',
                '乾窦' => '乾窦',
                '乾竺' => '乾竺',
                '乾笃' => '乾笃',
                '乾符' => '乾符',
                '乾策' => '乾策',
                '乾精' => '乾精',
                '乾红' => '乾红',
                '乾纲' => '乾纲',
                '乾纽' => '乾紐',
                '乾络' => '乾络',
                '乾统' => '乾统',
                '乾维' => '乾维',
                '乾罗' => '乾罗',
                '乾花' => '乾花',
                '乾荫' => '乾荫',
                '乾行' => '乾行',
                '乾衡' => '乾衡',
                '乾覆' => '乾覆',
                '乾象' => '乾象',
                '乾象历' => '乾象历',
                '乾贞' => '乾貞',
                '乾贶' => '乾贶',
                '乾车' => '乾車',
                '乾轴' => '乾軸',
                '乾通' => '乾通',
                '乾造' => '乾造',
                '乾道' => '乾道',
                '乾鉴' => '乾鉴',
                '乾钧' => '乾鈞',
                '乾闼' => '乾闥',
                '乾陀' => '乾陀',
                '乾陵' => '乾陵',
                '乾隆' => '乾隆',
                '乾音' => '乾音',
                '乾顾' => '乾顧',
                '乾风' => '乾風',
                '乾首' => '乾首',
                '乾马' => '乾马',
                '乾鹄' => '乾鹄',
                '乾鹊' => '乾鹊',
                '乾龙' => '乾龙',
                '乾，健也' => '乾，健也',
                '乾，天也' => '乾，天也',
                '争着' => '爭著',
                '争著书' => '爭著書',
                '争著作' => '爭著作',
                '争著名' => '爭著名',
                '争著录' => '爭著錄',
                '争著称' => '爭著稱',
                '争著者' => '爭著者',
                '争著述' => '爭著述',
                '五箇山' => '五箇山',
                '亮着' => '亮著',
                '亮著书' => '亮著書',
                '亮著作' => '亮著作',
                '亮著名' => '亮著名',
                '亮著录' => '亮著錄',
                '亮著称' => '亮著稱',
                '亮著者' => '亮著者',
                '亮著述' => '亮著述',
                '仗着' => '仗著',
                '仗著书' => '仗著書',
                '仗著作' => '仗著作',
                '仗著名' => '仗著名',
                '仗著录' => '仗著錄',
                '仗著称' => '仗著稱',
                '仗著者' => '仗著者',
                '仗著述' => '仗著述',
                '代表着' => '代表著',
                '代表著书' => '代表著書',
                '代表著作' => '代表著作',
                '代表著名' => '代表著名',
                '代表著录' => '代表著錄',
                '代表著称' => '代表著稱',
                '代表著者' => '代表著者',
                '代表著述' => '代表著述',
                '以微知著' => '以微知著',
                '仰屋著书' => '仰屋著書',
                '仿佛' => '彷彿',
                '伙计' => '夥計',
                '传着' => '傳著',
                '传著书' => '傳著書',
                '传著作' => '傳著作',
                '传著名' => '傳著名',
                '传著录' => '傳著錄',
                '传著称' => '傳著稱',
                '传著者' => '傳著者',
                '传著述' => '傳著述',
                '伴着' => '伴著',
                '伴著书' => '伴著書',
                '伴著作' => '伴著作',
                '伴著名' => '伴著名',
                '伴著录' => '伴著錄',
                '伴著称' => '伴著稱',
                '伴著者' => '伴著者',
                '伴著述' => '伴著述',
                '低着' => '低著',
                '低著书' => '低著書',
                '低著作' => '低著作',
                '低著名' => '低著名',
                '低著录' => '低著錄',
                '低著称' => '低著稱',
                '低著者' => '低著者',
                '低著述' => '低著述',
                '住着' => '住著',
                '住著书' => '住著書',
                '住著作' => '住著作',
                '住著名' => '住著名',
                '住著录' => '住著錄',
                '住著称' => '住著稱',
                '住著者' => '住著者',
                '住著述' => '住著述',
                '佛头著粪' => '佛頭著糞',
                '侏罗纪' => '侏儸紀',
                '侧着' => '側著',
                '侧著书' => '側著書',
                '侧著作' => '側著作',
                '侧著名' => '側著名',
                '侧著录' => '側著錄',
                '侧著称' => '側著稱',
                '侧著者' => '側著者',
                '侧著述' => '側著述',
                '保护着' => '保護著',
                '保障着' => '保障著',
                '保障著书' => '保障著書',
                '保障著作' => '保障著作',
                '保障著名' => '保障著名',
                '保障著录' => '保障著錄',
                '保障著称' => '保障著稱',
                '保障著者' => '保障著者',
                '保障著述' => '保障著述',
                '信着' => '信著',
                '信著书' => '信著書',
                '信著作' => '信著作',
                '信著名' => '信著名',
                '信著录' => '信著錄',
                '信著称' => '信著稱',
                '信著者' => '信著者',
                '信著述' => '信著述',
                '候着' => '候著',
                '候著书' => '候著書',
                '候著作' => '候著作',
                '候著名' => '候著名',
                '候著录' => '候著錄',
                '候著称' => '候著稱',
                '候著者' => '候著者',
                '候著述' => '候著述',
                '借助' => '藉助',
                '借口' => '藉口',
                '借手' => '藉手',
                '借故' => '藉故',
                '借机' => '藉機',
                '借此' => '藉此',
                '借由' => '藉由',
                '借着' => '借著',
                '借端' => '藉端',
                '借著书' => '借著書',
                '借著作' => '借著作',
                '借著名' => '借著名',
                '借著录' => '借著錄',
                '借著称' => '借著稱',
                '借著者' => '借著者',
                '借著述' => '借著述',
                '借词' => '藉詞',
                '做着' => '做著',
                '做著书' => '做著書',
                '做著作' => '做著作',
                '做著名' => '做著名',
                '做著录' => '做著錄',
                '做著称' => '做著稱',
                '做著者' => '做著者',
                '做著述' => '做著述',
                '偷着' => '偷著',
                '偷著书' => '偷著書',
                '偷著作' => '偷著作',
                '偷著名' => '偷著名',
                '偷著录' => '偷著錄',
                '偷著称' => '偷著稱',
                '偷著者' => '偷著者',
                '偷著述' => '偷著述',
                '傢俬' => '傢俬',
                '光着' => '光著',
                '光著书' => '光著書',
                '光著作' => '光著作',
                '光著名' => '光著名',
                '光著录' => '光著錄',
                '光著称' => '光著稱',
                '光著者' => '光著者',
                '光著述' => '光著述',
                '关着' => '關著',
                '关著书' => '關著書',
                '关著作' => '關著作',
                '关著名' => '關著名',
                '关著录' => '關著錄',
                '关著称' => '關著稱',
                '关著者' => '關著者',
                '关著述' => '關著述',
                '冀着' => '冀著',
                '冀著书' => '冀著書',
                '冀著作' => '冀著作',
                '冀著名' => '冀著名',
                '冀著录' => '冀著錄',
                '冀著称' => '冀著稱',
                '冀著者' => '冀著者',
                '冀著述' => '冀著述',
                '冒着' => '冒著',
                '冒著书' => '冒著書',
                '冒著作' => '冒著作',
                '冒著名' => '冒著名',
                '冒著录' => '冒著錄',
                '冒著称' => '冒著稱',
                '冒著者' => '冒著者',
                '冒著述' => '冒著述',
                '写着' => '寫著',
                '写著书' => '寫著書',
                '写著作' => '寫著作',
                '写著名' => '寫著名',
                '写著录' => '寫著錄',
                '写著称' => '寫著稱',
                '写著者' => '寫著者',
                '写著述' => '寫著述',
                '凉着' => '涼著',
                '凉著书' => '涼著書',
                '凉著作' => '涼著作',
                '凉著名' => '涼著名',
                '凉著录' => '涼著錄',
                '凉著称' => '涼著稱',
                '凉著者' => '涼著者',
                '凉著述' => '涼著述',
                '凭借' => '憑藉',
                '制着' => '制著',
                '制著书' => '制著書',
                '制著作' => '制著作',
                '制著名' => '制著名',
                '制著录' => '制著錄',
                '制著称' => '制著稱',
                '制著者' => '制著者',
                '制著述' => '制著述',
                '刻着' => '刻著',
                '刻著书' => '刻著書',
                '刻著作' => '刻著作',
                '刻著名' => '刻著名',
                '刻著录' => '刻著錄',
                '刻著称' => '刻著稱',
                '刻著者' => '刻著者',
                '刻著述' => '刻著述',
                '办着' => '辦著',
                '办著书' => '辦著書',
                '办著作' => '辦著作',
                '办著名' => '辦著名',
                '办著录' => '辦著錄',
                '办著称' => '辦著稱',
                '办著者' => '辦著者',
                '办著述' => '辦著述',
                '动着' => '動著',
                '动著书' => '動著書',
                '动著作' => '動著作',
                '动著名' => '動著名',
                '动著录' => '動著錄',
                '动著称' => '動著稱',
                '动著者' => '動著者',
                '动著述' => '動著述',
                '努力着' => '努力著',
                '努力著书' => '努力著書',
                '努力著作' => '努力著作',
                '努力著名' => '努力著名',
                '努力著录' => '努力著錄',
                '努力著称' => '努力著稱',
                '努力著者' => '努力著者',
                '努力著述' => '努力著述',
                '努着' => '努著',
                '努著书' => '努著書',
                '努著作' => '努著作',
                '努著名' => '努著名',
                '努著录' => '努著錄',
                '努著称' => '努著稱',
                '努著者' => '努著者',
                '努著述' => '努著述',
                '卓著' => '卓著',
                '印着' => '印著',
                '印著书' => '印著書',
                '印著作' => '印著作',
                '印著名' => '印著名',
                '印著录' => '印著錄',
                '印著称' => '印著稱',
                '印著者' => '印著者',
                '印著述' => '印著述',
                '卷舌' => '卷舌',
                '压着' => '壓著',
                '压著书' => '壓著書',
                '压著作' => '壓著作',
                '压著名' => '壓著名',
                '压著录' => '壓著錄',
                '压著称' => '壓著稱',
                '压著者' => '壓著者',
                '压著述' => '壓著述',
                '原著' => '原著',
                '去着' => '去著',
                '去著书' => '去著書',
                '去著作' => '去著作',
                '去著名' => '去著名',
                '去著录' => '去著錄',
                '去著称' => '去著稱',
                '去著者' => '去著者',
                '去著述' => '去著述',
                '反反复复' => '反反覆覆',
                '反复' => '反覆',
                '受着' => '受著',
                '受著书' => '受著書',
                '受著作' => '受著作',
                '受著名' => '受著名',
                '受著录' => '受著錄',
                '受著称' => '受著稱',
                '受著者' => '受著者',
                '受著述' => '受著述',
                '变着' => '變著',
                '变著书' => '變著書',
                '变著作' => '變著作',
                '变著名' => '變著名',
                '变著录' => '變著錄',
                '变著称' => '變著稱',
                '变著者' => '變著者',
                '变著述' => '變著述',
                '叫着' => '叫著',
                '叫著书' => '叫著書',
                '叫著作' => '叫著作',
                '叫著名' => '叫著名',
                '叫著录' => '叫著錄',
                '叫著称' => '叫著稱',
                '叫著者' => '叫著者',
                '叫著述' => '叫著述',
                '可穿著' => '可穿著',
                '叱吒' => '叱吒',
                '吃衣著饭' => '吃衣著飯',
                '合著' => '合著',
                '名著' => '名著',
                '向着' => '向著',
                '向著书' => '向著書',
                '向著作' => '向著作',
                '向著名' => '向著名',
                '向著录' => '向著錄',
                '向著称' => '向著稱',
                '向著者' => '向著者',
                '向著述' => '向著述',
                '含着' => '含著',
                '含著书' => '含著書',
                '含著作' => '含著作',
                '含著名' => '含著名',
                '含著录' => '含著錄',
                '含著称' => '含著稱',
                '含著者' => '含著者',
                '含著述' => '含著述',
                '听着' => '聽著',
                '听著书' => '聽著書',
                '听著作' => '聽著作',
                '听著名' => '聽著名',
                '听著录' => '聽著錄',
                '听著称' => '聽著稱',
                '听著者' => '聽著者',
                '听著述' => '聽著述',
                '吴其濬' => '吳其濬',
                '吹着' => '吹著',
                '吹著书' => '吹著書',
                '吹著作' => '吹著作',
                '吹著名' => '吹著名',
                '吹著录' => '吹著錄',
                '吹著称' => '吹著稱',
                '吹著者' => '吹著者',
                '吹著述' => '吹著述',
                '周易乾' => '周易乾',
                '味着' => '味著',
                '味著书' => '味著書',
                '味著作' => '味著作',
                '味著名' => '味著名',
                '味著录' => '味著錄',
                '味著称' => '味著稱',
                '味著者' => '味著者',
                '味著述' => '味著述',
                '呼幺喝六' => '呼幺喝六',
                '响着' => '響著',
                '响著书' => '響著書',
                '响著作' => '響著作',
                '响著名' => '響著名',
                '响著录' => '響著錄',
                '响著称' => '響著稱',
                '响著者' => '響著者',
                '响著述' => '響著述',
                '哪吒' => '哪吒',
                '哭着' => '哭著',
                '哭著书' => '哭著書',
                '哭著作' => '哭著作',
                '哭著名' => '哭著名',
                '哭著录' => '哭著錄',
                '哭著称' => '哭著稱',
                '哭著者' => '哭著者',
                '哭著述' => '哭著述',
                '唱着' => '唱著',
                '唱著书' => '唱著書',
                '唱著作' => '唱著作',
                '唱著名' => '唱著名',
                '唱著录' => '唱著錄',
                '唱著称' => '唱著稱',
                '唱著者' => '唱著者',
                '唱著述' => '唱著述',
                '喝着' => '喝著',
                '喝著书' => '喝著書',
                '喝著作' => '喝著作',
                '喝著名' => '喝著名',
                '喝著录' => '喝著錄',
                '喝著称' => '喝著稱',
                '喝著者' => '喝著者',
                '喝著述' => '喝著述',
                '嚷着' => '嚷著',
                '嚷著书' => '嚷著書',
                '嚷著作' => '嚷著作',
                '嚷著名' => '嚷著名',
                '嚷著录' => '嚷著錄',
                '嚷著称' => '嚷著稱',
                '嚷著者' => '嚷著者',
                '嚷著述' => '嚷著述',
                '回复' => '回覆',
                '因着' => '因著',
                '因著〈' => '因著〈',
                '因著《' => '因著《',
                '因著书' => '因著書',
                '因著作' => '因著作',
                '因著名' => '因著名',
                '因著录' => '因著錄',
                '因著称' => '因著稱',
                '因著者' => '因著者',
                '因著述' => '因著述',
                '困着' => '困著',
                '困著书' => '困著書',
                '困著作' => '困著作',
                '困著名' => '困著名',
                '困著录' => '困著錄',
                '困著称' => '困著稱',
                '困著者' => '困著者',
                '困著述' => '困著述',
                '围着' => '圍著',
                '围著书' => '圍著書',
                '围著作' => '圍著作',
                '围著名' => '圍著名',
                '围著录' => '圍著錄',
                '围著称' => '圍著稱',
                '围著者' => '圍著者',
                '围著述' => '圍著述',
                '土著' => '土著',
                '在着' => '在著',
                '在著书' => '在著書',
                '在著作' => '在著作',
                '在著名' => '在著名',
                '在著录' => '在著錄',
                '在著称' => '在著稱',
                '在著者' => '在著者',
                '在著述' => '在著述',
                '坐着' => '坐著',
                '坐著书' => '坐著書',
                '坐著作' => '坐著作',
                '坐著名' => '坐著名',
                '坐著录' => '坐著錄',
                '坐著称' => '坐著稱',
                '坐著者' => '坐著者',
                '坐著述' => '坐著述',
                '坤乾' => '坤乾',
                '备着' => '備著',
                '备著书' => '備著書',
                '备著作' => '備著作',
                '备著名' => '備著名',
                '备著录' => '備著錄',
                '备著称' => '備著稱',
                '备著者' => '備著者',
                '备著述' => '備著述',
                '天道为乾' => '天道為乾',
                '夹着' => '夾著',
                '夹著书' => '夾著書',
                '夹著作' => '夾著作',
                '夹著名' => '夾著名',
                '夹著录' => '夾著錄',
                '夹著称' => '夾著稱',
                '夹著者' => '夾著者',
                '夹著述' => '夾著述',
                '奧区' => '奧區',
                '姓幺' => '姓幺',
                '存摺' => '存摺',
                '孤着' => '孤著',
                '孤著书' => '孤著書',
                '孤著作' => '孤著作',
                '孤著名' => '孤著名',
                '孤著录' => '孤著錄',
                '孤著称' => '孤著稱',
                '孤著者' => '孤著者',
                '孤著述' => '孤著述',
                '学着' => '學著',
                '学著书' => '學著書',
                '学著作' => '學著作',
                '学著名' => '學著名',
                '学著录' => '學著錄',
                '学著称' => '學著稱',
                '学著者' => '學著者',
                '学著述' => '學著述',
                '守着' => '守著',
                '守著书' => '守著書',
                '守著作' => '守著作',
                '守著名' => '守著名',
                '守著录' => '守著錄',
                '守著称' => '守著稱',
                '守著者' => '守著者',
                '守著述' => '守著述',
                '定着' => '定著',
                '定著书' => '定著書',
                '定著作' => '定著作',
                '定著名' => '定著名',
                '定著录' => '定著錄',
                '定著称' => '定著稱',
                '定著者' => '定著者',
                '定著述' => '定著述',
                '对着' => '對著',
                '对著书' => '對著書',
                '对著作' => '對著作',
                '对著名' => '對著名',
                '对著录' => '對著錄',
                '对著称' => '對著稱',
                '对著者' => '對著者',
                '对著述' => '對著述',
                '寻着' => '尋著',
                '寻著书' => '尋著書',
                '寻著作' => '尋著作',
                '寻著名' => '尋著名',
                '寻著录' => '尋著錄',
                '寻著称' => '尋著稱',
                '寻著者' => '尋著者',
                '寻著述' => '尋著述',
                '将军抽車' => '將軍抽車',
                '尼乾陀' => '尼乾陀',
                '展着' => '展著',
                '展著书' => '展著書',
                '展著作' => '展著作',
                '展著名' => '展著名',
                '展著录' => '展著錄',
                '展著称' => '展著稱',
                '展著者' => '展著者',
                '展著述' => '展著述',
                '巨著' => '巨著',
                '带着' => '帶著',
                '带著书' => '帶著書',
                '带著作' => '帶著作',
                '带著名' => '帶著名',
                '带著录' => '帶著錄',
                '带著称' => '帶著稱',
                '带著者' => '帶著者',
                '带著述' => '帶著述',
                '帮着' => '幫著',
                '帮著书' => '幫著書',
                '帮著作' => '幫著作',
                '帮著名' => '幫著名',
                '帮著录' => '幫著錄',
                '帮著称' => '幫著稱',
                '帮著者' => '幫著者',
                '帮著述' => '幫著述',
                '干干净净' => '乾乾淨淨',
                '干干脆脆' => '乾乾脆脆',
                '干泉水' => '乾泉水',
                '干着' => '幹著',
                '幺二三' => '幺二三',
                '幺元' => '幺元',
                '幺凤' => '么鳳',
                '幺半群' => '幺半群',
                '幺厮' => '幺厮',
                '幺叔' => '幺叔',
                '幺妈' => '幺媽',
                '幺妹' => '幺妹',
                '幺姓' => '幺姓',
                '幺姨' => '幺姨',
                '幺娘' => '幺孃',
                '幺小' => '么小',
                '幺氏' => '么氏',
                '幺爸' => '幺爸',
                '幺爹' => '么爹',
                '幺篇' => '幺篇',
                '幺舅' => '幺舅',
                '幺蛾子' => '幺蛾子',
                '幺谦' => '幺謙',
                '幺麽' => '么麼',
                '幺麽小丑' => '么麼小丑',
                '庇护着' => '庇護著',
                '应着' => '應著',
                '应著书' => '應著書',
                '应著作' => '應著作',
                '应著名' => '應著名',
                '应著录' => '應著錄',
                '应著称' => '應著稱',
                '应著者' => '應著者',
                '应著述' => '應著述',
                '康乾' => '康乾',
                '康着' => '康著',
                '康著书' => '康著書',
                '康著作' => '康著作',
                '康著名' => '康著名',
                '康著录' => '康著錄',
                '康著称' => '康著稱',
                '康著者' => '康著者',
                '康著述' => '康著述',
                '开着' => '開著',
                '开著书' => '開著書',
                '开著作' => '開著作',
                '开著名' => '開著名',
                '开著录' => '開著錄',
                '开著称' => '開著稱',
                '开著者' => '開著者',
                '开著述' => '開著述',
                '张法乾' => '張法乾',
                '当着' => '當著',
                '当著书' => '當著書',
                '当著作' => '當著作',
                '当著名' => '當著名',
                '当著录' => '當著錄',
                '当著称' => '當著稱',
                '当著者' => '當著者',
                '当著述' => '當著述',
                '彰明较著' => '彰明較著',
                '待着' => '待著',
                '待著书' => '待著書',
                '待著作' => '待著作',
                '待著名' => '待著名',
                '待著录' => '待著錄',
                '待著称' => '待著稱',
                '待著者' => '待著者',
                '待著述' => '待著述',
                '得着' => '得著',
                '得著书' => '得著書',
                '得著作' => '得著作',
                '得著名' => '得著名',
                '得著录' => '得著錄',
                '得著称' => '得著稱',
                '得著者' => '得著者',
                '得著述' => '得著述',
                '循着' => '循著',
                '循著书' => '循著書',
                '循著作' => '循著作',
                '循著名' => '循著名',
                '循著录' => '循著錄',
                '循著称' => '循著稱',
                '循著者' => '循著者',
                '循著述' => '循著述',
                '心着' => '心著',
                '心著书' => '心著書',
                '心著作' => '心著作',
                '心著名' => '心著名',
                '心著录' => '心著錄',
                '心著称' => '心著稱',
                '心著者' => '心著者',
                '心著述' => '心著述',
                '忍着' => '忍著',
                '忍著书' => '忍著書',
                '忍著作' => '忍著作',
                '忍著名' => '忍著名',
                '忍著录' => '忍著錄',
                '忍著称' => '忍著稱',
                '忍著者' => '忍著者',
                '忍著述' => '忍著述',
                '志着' => '志著',
                '志著书' => '志著書',
                '志著作' => '志著作',
                '志著名' => '志著名',
                '志著录' => '志著錄',
                '志著称' => '志著稱',
                '志著者' => '志著者',
                '志著述' => '志著述',
                '忙着' => '忙著',
                '忙著书' => '忙著書',
                '忙著作' => '忙著作',
                '忙著名' => '忙著名',
                '忙著录' => '忙著錄',
                '忙著称' => '忙著稱',
                '忙著者' => '忙著者',
                '忙著述' => '忙著述',
                '怀着' => '懷著',
                '怀著书' => '懷著書',
                '怀著作' => '懷著作',
                '怀著名' => '懷著名',
                '怀著录' => '懷著錄',
                '怀著称' => '懷著稱',
                '怀著者' => '懷著者',
                '怀著述' => '懷著述',
                '急着' => '急著',
                '急著书' => '急著書',
                '急著作' => '急著作',
                '急著名' => '急著名',
                '急著录' => '急著錄',
                '急著称' => '急著稱',
                '急著者' => '急著者',
                '急著述' => '急著述',
                '性着' => '性著',
                '性著书' => '性著書',
                '性著作' => '性著作',
                '性著名' => '性著名',
                '性著录' => '性著錄',
                '性著称' => '性著稱',
                '性著者' => '性著者',
                '性著述' => '性著述',
                '恋着' => '戀著',
                '恋著书' => '戀著書',
                '恋著作' => '戀著作',
                '恋著名' => '戀著名',
                '恋著录' => '戀著錄',
                '恋著称' => '戀著稱',
                '恋著者' => '戀著者',
                '恋著述' => '戀著述',
                '恩威并著' => '恩威並著',
                '悠着' => '悠著',
                '悠著书' => '悠著書',
                '悠著作' => '悠著作',
                '悠著名' => '悠著名',
                '悠著录' => '悠著錄',
                '悠著称' => '悠著稱',
                '悠著者' => '悠著者',
                '悠著述' => '悠著述',
                '惯着' => '慣著',
                '惯著书' => '慣著書',
                '惯著作' => '慣著作',
                '惯著名' => '慣著名',
                '惯著录' => '慣著錄',
                '惯著称' => '慣著稱',
                '惯著者' => '慣著者',
                '惯著述' => '慣著述',
                '想着' => '想著',
                '想著书' => '想著書',
                '想著作' => '想著作',
                '想著名' => '想著名',
                '想著录' => '想著錄',
                '想著称' => '想著稱',
                '想著者' => '想著者',
                '想著述' => '想著述',
                '战着' => '戰著',
                '战著书' => '戰著書',
                '战著作' => '戰著作',
                '战著名' => '戰著名',
                '战著录' => '戰著錄',
                '战著称' => '戰著稱',
                '战著者' => '戰著者',
                '战著述' => '戰著述',
                '戴着' => '戴著',
                '戴著书' => '戴著書',
                '戴著作' => '戴著作',
                '戴著名' => '戴著名',
                '戴著录' => '戴著錄',
                '戴著称' => '戴著稱',
                '戴著者' => '戴著者',
                '戴著述' => '戴著述',
                '扎着' => '扎著',
                '扎著书' => '扎著書',
                '扎著作' => '扎著作',
                '扎著名' => '扎著名',
                '扎著录' => '扎著錄',
                '扎著称' => '扎著稱',
                '扎著者' => '扎著者',
                '扎著述' => '扎著述',
                '打着' => '打著',
                '打著书' => '打著書',
                '打著作' => '打著作',
                '打著名' => '打著名',
                '打著录' => '打著錄',
                '打著称' => '打著稱',
                '打著者' => '打著者',
                '打著述' => '打著述',
                '扛着' => '扛著',
                '扛著书' => '扛著書',
                '扛著作' => '扛著作',
                '扛著名' => '扛著名',
                '扛著录' => '扛著錄',
                '扛著称' => '扛著稱',
                '扛著者' => '扛著者',
                '扛著述' => '扛著述',
                '执著' => '執著',
                '找不着' => '找不著',
                '找不著书' => '找不著書',
                '找不著作' => '找不著作',
                '找不著名' => '找不著名',
                '找不著录' => '找不著錄',
                '找不著称' => '找不著稱',
                '找不著者' => '找不著者',
                '找不著述' => '找不著述',
                '抓着' => '抓著',
                '抓著书' => '抓著書',
                '抓著作' => '抓著作',
                '抓著名' => '抓著名',
                '抓著录' => '抓著錄',
                '抓著称' => '抓著稱',
                '抓著者' => '抓著者',
                '抓著述' => '抓著述',
                '护着' => '護著',
                '护著书' => '護著書',
                '护著作' => '護著作',
                '护著名' => '護著名',
                '护著录' => '護著錄',
                '护著称' => '護著稱',
                '护著者' => '護著者',
                '护著述' => '護著述',
                '披着' => '披著',
                '披著书' => '披著書',
                '披著作' => '披著作',
                '披著名' => '披著名',
                '披著录' => '披著錄',
                '披著称' => '披著稱',
                '披著者' => '披著者',
                '披著述' => '披著述',
                '抬着' => '抬著',
                '抬著书' => '抬著書',
                '抬著作' => '抬著作',
                '抬著名' => '抬著名',
                '抬著录' => '抬著錄',
                '抬著称' => '抬著稱',
                '抬著者' => '抬著者',
                '抬著述' => '抬著述',
                '抱着' => '抱著',
                '抱著书' => '抱著書',
                '抱著作' => '抱著作',
                '抱著名' => '抱著名',
                '抱著录' => '抱著錄',
                '抱著称' => '抱著稱',
                '抱著者' => '抱著者',
                '抱著述' => '抱著述',
                '拉着' => '拉著',
                '拉著书' => '拉著書',
                '拉著作' => '拉著作',
                '拉著名' => '拉著名',
                '拉著录' => '拉著錄',
                '拉著称' => '拉著稱',
                '拉著者' => '拉著者',
                '拉著述' => '拉著述',
                '拉链' => '拉鍊',
                '拎着' => '拎著',
                '拎著书' => '拎著書',
                '拎著作' => '拎著作',
                '拎著名' => '拎著名',
                '拎著录' => '拎著錄',
                '拎著称' => '拎著稱',
                '拎著者' => '拎著者',
                '拎著述' => '拎著述',
                '拖着' => '拖著',
                '拖著书' => '拖著書',
                '拖著作' => '拖著作',
                '拖著名' => '拖著名',
                '拖著录' => '拖著錄',
                '拖著称' => '拖著稱',
                '拖著者' => '拖著者',
                '拖著述' => '拖著述',
                '拙著' => '拙著',
                '拚命' => '拚命',
                '拚搏' => '拚搏',
                '拚死' => '拚死',
                '拼着' => '拼著',
                '拼著书' => '拼著書',
                '拼著作' => '拼著作',
                '拼著名' => '拼著名',
                '拼著录' => '拼著錄',
                '拼著称' => '拼著稱',
                '拼著者' => '拼著者',
                '拼著述' => '拼著述',
                '拿着' => '拿著',
                '拿著书' => '拿著書',
                '拿著作' => '拿著作',
                '拿著名' => '拿著名',
                '拿著录' => '拿著錄',
                '拿著称' => '拿著稱',
                '拿著者' => '拿著者',
                '拿著述' => '拿著述',
                '持着' => '持著',
                '持著书' => '持著書',
                '持著作' => '持著作',
                '持著名' => '持著名',
                '持著录' => '持著錄',
                '持著称' => '持著稱',
                '持著者' => '持著者',
                '持著述' => '持著述',
                '挑着' => '挑著',
                '挑著书' => '挑著書',
                '挑著作' => '挑著作',
                '挑著名' => '挑著名',
                '挑著录' => '挑著錄',
                '挑著称' => '挑著稱',
                '挑著者' => '挑著者',
                '挑著述' => '挑著述',
                '挡着' => '擋著',
                '挡著书' => '擋著書',
                '挡著作' => '擋著作',
                '挡著名' => '擋著名',
                '挡著录' => '擋著錄',
                '挡著称' => '擋著稱',
                '挡著者' => '擋著者',
                '挡著述' => '擋著述',
                '挣着' => '掙著',
                '挣著书' => '掙著書',
                '挣著作' => '掙著作',
                '挣著名' => '掙著名',
                '挣著录' => '掙著錄',
                '挣著称' => '掙著稱',
                '挣著者' => '掙著者',
                '挣著述' => '掙著述',
                '挥着' => '揮著',
                '挥著书' => '揮著書',
                '挥著作' => '揮著作',
                '挥著名' => '揮著名',
                '挥著录' => '揮著錄',
                '挥著称' => '揮著稱',
                '挥著者' => '揮著者',
                '挥著述' => '揮著述',
                '挨着' => '挨著',
                '挨著书' => '挨著書',
                '挨著作' => '挨著作',
                '挨著名' => '挨著名',
                '挨著录' => '挨著錄',
                '挨著称' => '挨著稱',
                '挨著者' => '挨著者',
                '挨著述' => '挨著述',
                '捆着' => '捆著',
                '捆著书' => '捆著書',
                '捆著作' => '捆著作',
                '捆著名' => '捆著名',
                '捆著录' => '捆著錄',
                '捆著称' => '捆著稱',
                '捆著者' => '捆著者',
                '捆著述' => '捆著述',
                '据着' => '據著',
                '据著书' => '據著書',
                '据著作' => '據著作',
                '据著名' => '據著名',
                '据著录' => '據著錄',
                '据著称' => '據著稱',
                '据著者' => '據著者',
                '据著述' => '據著述',
                '掖着' => '掖著',
                '掖著书' => '掖著書',
                '掖著作' => '掖著作',
                '掖著名' => '掖著名',
                '掖著录' => '掖著錄',
                '掖著称' => '掖著稱',
                '掖著者' => '掖著者',
                '掖著述' => '掖著述',
                '接着' => '接著',
                '接著书' => '接著書',
                '接著作' => '接著作',
                '接著名' => '接著名',
                '接著录' => '接著錄',
                '接著称' => '接著稱',
                '接著者' => '接著者',
                '接著述' => '接著述',
                '揉着' => '揉著',
                '揉著书' => '揉著書',
                '揉著作' => '揉著作',
                '揉著名' => '揉著名',
                '揉著录' => '揉著錄',
                '揉著称' => '揉著稱',
                '揉著者' => '揉著者',
                '揉著述' => '揉著述',
                '提着' => '提著',
                '提著书' => '提著書',
                '提著作' => '提著作',
                '提著名' => '提著名',
                '提著录' => '提著錄',
                '提著称' => '提著稱',
                '提著者' => '提著者',
                '提著述' => '提著述',
                '搂着' => '摟著',
                '搂著书' => '摟著書',
                '搂著作' => '摟著作',
                '搂著名' => '摟著名',
                '搂著录' => '摟著錄',
                '搂著称' => '摟著稱',
                '搂著者' => '摟著者',
                '搂著述' => '摟著述',
                '摆着' => '擺著',
                '摆著书' => '擺著書',
                '摆著作' => '擺著作',
                '摆著名' => '擺著名',
                '摆著录' => '擺著錄',
                '摆著称' => '擺著稱',
                '摆著者' => '擺著者',
                '摆著述' => '擺著述',
                '撰著' => '撰著',
                '撼着' => '撼著',
                '撼著书' => '撼著書',
                '撼著作' => '撼著作',
                '撼著名' => '撼著名',
                '撼著录' => '撼著錄',
                '撼著称' => '撼著稱',
                '撼著者' => '撼著者',
                '撼著述' => '撼著述',
                '敞着' => '敞著',
                '敞著书' => '敞著書',
                '敞著作' => '敞著作',
                '敞著名' => '敞著名',
                '敞著录' => '敞著錄',
                '敞著称' => '敞著稱',
                '敞著者' => '敞著者',
                '敞著述' => '敞著述',
                '数着' => '數著',
                '数著书' => '數著書',
                '数著作' => '數著作',
                '数著名' => '數著名',
                '数著录' => '數著錄',
                '数著称' => '數著稱',
                '数著者' => '數著者',
                '数著述' => '數著述',
                '斗着' => '斗著',
                '斗著书' => '斗著書',
                '斗著作' => '斗著作',
                '斗著名' => '斗著名',
                '斗著录' => '斗著錄',
                '斗著称' => '斗著稱',
                '斗著者' => '斗著者',
                '斗著述' => '斗著述',
                '斥着' => '斥著',
                '斥著书' => '斥著書',
                '斥著作' => '斥著作',
                '斥著名' => '斥著名',
                '斥著录' => '斥著錄',
                '斥著称' => '斥著稱',
                '斥著者' => '斥著者',
                '斥著述' => '斥著述',
                '新著' => '新著',
                '新著龙虎门' => '新著龍虎門',
                '於世成' => '於世成',
                '於乎' => '於乎',
                '於乙于同' => '於乙于同',
                '於乙宇同' => '於乙宇同',
                '於于同' => '於于同',
                '於哲' => '於哲',
                '於夫罗' => '於夫羅',
                '於姓' => '於姓',
                '於宇同' => '於宇同',
                '於崇文' => '於崇文',
                '於志贺' => '於志贺',
                '於戏' => '於戲',
                '於梨华' => '於梨华',
                '於氏' => '於氏',
                '於潜县' => '於潜县',
                '於祥玉' => '於祥玉',
                '於菟' => '於菟',
                '於贤德' => '於賢德',
                '於除鞬' => '於除鞬',
                '旋乾转坤' => '旋乾轉坤',
                '旷若发矇' => '曠若發矇',
                '昂着' => '昂著',
                '昂著书' => '昂著書',
                '昂著作' => '昂著作',
                '昂著名' => '昂著名',
                '昂著录' => '昂著錄',
                '昂著称' => '昂著稱',
                '昂著者' => '昂著者',
                '昂著述' => '昂著述',
                '易·乾' => '易·乾',
                '易经·乾' => '易经·乾',
                '易经乾' => '易经乾',
                '映着' => '映著',
                '映著书' => '映著書',
                '映著作' => '映著作',
                '映著名' => '映著名',
                '映著录' => '映著錄',
                '映著称' => '映著稱',
                '映著者' => '映著者',
                '映著述' => '映著述',
                '昭著' => '昭著',
                '显著' => '显著',
                '晃着' => '晃著',
                '晃著书' => '晃著書',
                '晃著作' => '晃著作',
                '晃著名' => '晃著名',
                '晃著录' => '晃著錄',
                '晃著称' => '晃著稱',
                '晃著者' => '晃著者',
                '晃著述' => '晃著述',
                '暗着' => '暗著',
                '暗著书' => '暗著書',
                '暗著作' => '暗著作',
                '暗著名' => '暗著名',
                '暗著录' => '暗著錄',
                '暗著称' => '暗著稱',
                '暗著者' => '暗著者',
                '暗著述' => '暗著述',
                '有着' => '有著',
                '有著书' => '有著書',
                '有著作' => '有著作',
                '有著名' => '有著名',
                '有著录' => '有著錄',
                '有著称' => '有著稱',
                '有著者' => '有著者',
                '有著述' => '有著述',
                '望着' => '望著',
                '望著书' => '望著書',
                '望著作' => '望著作',
                '望著名' => '望著名',
                '望著录' => '望著錄',
                '望著称' => '望著稱',
                '望著者' => '望著者',
                '望著述' => '望著述',
                '朝乾夕惕' => '朝乾夕惕',
                '朝着' => '朝著',
                '朝著书' => '朝著書',
                '朝著作' => '朝著作',
                '朝著名' => '朝著名',
                '朝著录' => '朝著錄',
                '朝著称' => '朝著稱',
                '朝著者' => '朝著者',
                '朝著述' => '朝著述',
                '本着' => '本著',
                '本著书' => '本著書',
                '本著作' => '本著作',
                '本著名' => '本著名',
                '本著录' => '本著錄',
                '本著称' => '本著稱',
                '本著者' => '本著者',
                '本著述' => '本著述',
                '朴於宇同' => '朴於宇同',
                '杀着' => '殺著',
                '杀著书' => '殺著書',
                '杀著作' => '殺著作',
                '杀著名' => '殺著名',
                '杀著录' => '殺著錄',
                '杀著称' => '殺著稱',
                '杀著者' => '殺著者',
                '杀著述' => '殺著述',
                '杂着' => '雜著',
                '杂著书' => '雜著書',
                '杂著作' => '雜著作',
                '杂著名' => '雜著名',
                '杂著录' => '雜著錄',
                '杂著称' => '雜著稱',
                '杂著者' => '雜著者',
                '杂著述' => '雜著述',
                '李乾德' => '李乾德',
                '李乾顺' => '李乾顺',
                '李泽钜' => '李澤鉅',
                '来着' => '來著',
                '来著书' => '來著書',
                '来著作' => '來著作',
                '来著名' => '來著名',
                '来著录' => '來著錄',
                '来著称' => '來著稱',
                '来著者' => '來著者',
                '来著述' => '來著述',
                '杨幺' => '楊幺',
                '枕着' => '枕著',
                '枕著书' => '枕著書',
                '枕著作' => '枕著作',
                '枕著名' => '枕著名',
                '枕著录' => '枕著錄',
                '枕著称' => '枕著稱',
                '枕著者' => '枕著者',
                '枕著述' => '枕著述',
                '柳诒徵' => '柳诒徵',
                '标志着' => '標誌著',
                '梦着' => '夢著',
                '梦著书' => '夢著書',
                '梦著作' => '夢著作',
                '梦著名' => '夢著名',
                '梦著录' => '夢著錄',
                '梦著称' => '夢著稱',
                '梦著者' => '夢著者',
                '梦著述' => '夢著述',
                '梳着' => '梳著',
                '梳著书' => '梳著書',
                '梳著作' => '梳著作',
                '梳著名' => '梳著名',
                '梳著录' => '梳著錄',
                '梳著称' => '梳著稱',
                '梳著者' => '梳著者',
                '梳著述' => '梳著述',
                '樊於期' => '樊於期',
                '氆氌' => '氆氌',
                '求着' => '求著',
                '求著书' => '求著書',
                '求著作' => '求著作',
                '求著名' => '求著名',
                '求著录' => '求著錄',
                '求著称' => '求著稱',
                '求著者' => '求著者',
                '求著述' => '求著述',
                '沉没' => '沈沒',
                '沉着' => '沉著',
                '沉积' => '沈積',
                '沉船' => '沈船',
                '沉著书' => '沉著書',
                '沉著作' => '沉著作',
                '沉著名' => '沉著名',
                '沉著录' => '沉著錄',
                '沉著称' => '沉著稱',
                '沉著者' => '沉著者',
                '沉著述' => '沉著述',
                '沉默' => '沈默',
                '沿着' => '沿著',
                '沿著书' => '沿著書',
                '沿著作' => '沿著作',
                '沿著名' => '沿著名',
                '沿著录' => '沿著錄',
                '沿著称' => '沿著稱',
                '沿著者' => '沿著者',
                '沿著述' => '沿著述',
                '泛滥' => '氾濫',
                '洗练' => '洗鍊',
                '活着' => '活著',
                '活著书' => '活著書',
                '活著作' => '活著作',
                '活著名' => '活著名',
                '活著录' => '活著錄',
                '活著称' => '活著稱',
                '活著者' => '活著者',
                '活著述' => '活著述',
                '流着' => '流著',
                '流著书' => '流著書',
                '流著作' => '流著作',
                '流著名' => '流著名',
                '流著录' => '流著錄',
                '流著称' => '流著稱',
                '流著者' => '流著者',
                '流著述' => '流著述',
                '流露着' => '流露著',
                '浮着' => '浮著',
                '浮著书' => '浮著書',
                '浮著作' => '浮著作',
                '浮著名' => '浮著名',
                '浮著录' => '浮著錄',
                '浮著称' => '浮著稱',
                '浮著者' => '浮著者',
                '浮著述' => '浮著述',
                '润着' => '潤著',
                '润著书' => '潤著書',
                '润著作' => '潤著作',
                '润著名' => '潤著名',
                '润著录' => '潤著錄',
                '润著称' => '潤著稱',
                '润著者' => '潤著者',
                '润著述' => '潤著述',
                '涵着' => '涵著',
                '涵著书' => '涵著書',
                '涵著作' => '涵著作',
                '涵著名' => '涵著名',
                '涵著录' => '涵著錄',
                '涵著称' => '涵著稱',
                '涵著者' => '涵著者',
                '涵著述' => '涵著述',
                '渴着' => '渴著',
                '渴著书' => '渴著書',
                '渴著作' => '渴著作',
                '渴著名' => '渴著名',
                '渴著录' => '渴著錄',
                '渴著称' => '渴著稱',
                '渴著者' => '渴著者',
                '渴著述' => '渴著述',
                '溢着' => '溢著',
                '溢著书' => '溢著書',
                '溢著作' => '溢著作',
                '溢著名' => '溢著名',
                '溢著录' => '溢著錄',
                '溢著称' => '溢著稱',
                '溢著者' => '溢著者',
                '溢著述' => '溢著述',
                '演着' => '演著',
                '演著书' => '演著書',
                '演著作' => '演著作',
                '演著名' => '演著名',
                '演著录' => '演著錄',
                '演著称' => '演著稱',
                '演著者' => '演著者',
                '演著述' => '演著述',
                '漫着' => '漫著',
                '漫著书' => '漫著書',
                '漫著作' => '漫著作',
                '漫著名' => '漫著名',
                '漫著录' => '漫著錄',
                '漫著称' => '漫著稱',
                '漫著者' => '漫著者',
                '漫著述' => '漫著述',
                '点着' => '點著',
                '点著作' => '點著作',
                '点著名' => '點著名',
                '点著录' => '點著錄',
                '点著称' => '點著稱',
                '点著者' => '點著者',
                '点著述' => '點著述',
                '烧着' => '燒著',
                '烧著作' => '燒著作',
                '烧著名' => '燒著名',
                '烧著录' => '燒著錄',
                '烧著称' => '燒著稱',
                '烧著者' => '燒著者',
                '烧著述' => '燒著述',
                '照着' => '照著',
                '照著书' => '照著書',
                '照著作' => '照著作',
                '照著名' => '照著名',
                '照著录' => '照著錄',
                '照著称' => '照著稱',
                '照著者' => '照著者',
                '照著述' => '照著述',
                '爱护着' => '愛護著',
                '爱着' => '愛著',
                '爱著书' => '愛著書',
                '爱著作' => '愛著作',
                '爱著名' => '愛著名',
                '爱著录' => '愛著錄',
                '爱著称' => '愛著稱',
                '爱著者' => '愛著者',
                '爱著述' => '愛著述',
                '牵着' => '牽著',
                '牵著书' => '牽著書',
                '牵著作' => '牽著作',
                '牵著名' => '牽著名',
                '牵著录' => '牽著錄',
                '牵著称' => '牽著稱',
                '牵著者' => '牽著者',
                '牵著述' => '牽著述',
                '犯不着' => '犯不著',
                '独着' => '獨著',
                '独著书' => '獨著書',
                '独著作' => '獨著作',
                '独著名' => '獨著名',
                '独著录' => '獨著錄',
                '独著称' => '獨著稱',
                '独著者' => '獨著者',
                '独著述' => '獨著述',
                '猜着' => '猜著',
                '猜着书' => '猜著書',
                '猜著作' => '猜著作',
                '猜著名' => '猜著名',
                '猜著录' => '猜著錄',
                '猜著称' => '猜著稱',
                '猜著者' => '猜著者',
                '猜著述' => '猜著述',
                '玩着' => '玩著',
                '甜着' => '甜著',
                '甜著书' => '甜著書',
                '甜著作' => '甜著作',
                '甜著名' => '甜著名',
                '甜著录' => '甜著錄',
                '甜著称' => '甜著稱',
                '甜著者' => '甜著者',
                '甜著述' => '甜著述',
                '用不着' => '用不著',
                '用不着书' => '用不著書',
                '用不著作' => '用不著作',
                '用不著名' => '用不著名',
                '用不著录' => '用不著錄',
                '用不著称' => '用不著稱',
                '用不著者' => '用不著者',
                '用不著述' => '用不著述',
                '用着' => '用著',
                '用著书' => '用著書',
                '用著作' => '用著作',
                '用著名' => '用著名',
                '用著录' => '用著錄',
                '用著称' => '用著稱',
                '用著者' => '用著者',
                '用著述' => '用著述',
                '留着' => '留著',
                '留着书' => '留著書',
                '留著作' => '留著作',
                '留著名' => '留著名',
                '留著录' => '留著錄',
                '留著称' => '留著稱',
                '留著者' => '留著者',
                '留著述' => '留著述',
                '疑着' => '疑著',
                '疑著书' => '疑著書',
                '疑著作' => '疑著作',
                '疑著名' => '疑著名',
                '疑著录' => '疑著錄',
                '疑著称' => '疑著稱',
                '疑著者' => '疑著者',
                '疑著述' => '疑著述',
                '癥瘕' => '癥瘕',
                '皱着' => '皺著',
                '皱著书' => '皺著書',
                '皱著作' => '皺著作',
                '皱著名' => '皺著名',
                '皱著录' => '皺著錄',
                '皱著称' => '皺著稱',
                '皱著者' => '皺著者',
                '皱著述' => '皺著述',
                '盛着' => '盛著',
                '盛著书' => '盛著書',
                '盛著作' => '盛著作',
                '盛著名' => '盛著名',
                '盛著录' => '盛著錄',
                '盛著称' => '盛著稱',
                '盛著者' => '盛著者',
                '盛著述' => '盛著述',
                '盯着' => '盯著',
                '盯着书' => '盯著書',
                '盯著作' => '盯著作',
                '盯著名' => '盯著名',
                '盯著录' => '盯著錄',
                '盯著称' => '盯著稱',
                '盯著者' => '盯著者',
                '盯著述' => '盯著述',
                '盾着' => '盾著',
                '盾著书' => '盾著書',
                '盾著作' => '盾著作',
                '盾著名' => '盾著名',
                '盾著录' => '盾著錄',
                '盾著称' => '盾著稱',
                '盾著者' => '盾著者',
                '盾著述' => '盾著述',
                '看着' => '看著',
                '看着书' => '看著書',
                '看著作' => '看著作',
                '看著名' => '看著名',
                '看著录' => '看著錄',
                '看著称' => '看著稱',
                '看著者' => '看著者',
                '看著述' => '看著述',
                '着业' => '著業',
                '着丝' => '著絲',
                '着么' => '著么',
                '着人' => '著人',
                '着什么急' => '著什么急',
                '着他' => '著他',
                '着令' => '著令',
                '着位' => '著位',
                '着体' => '著體',
                '着你' => '著你',
                '着便' => '著便',
                '着凉' => '著涼',
                '着力' => '著力',
                '着劲' => '著勁',
                '着号' => '著號',
                '着呢' => '著呢',
                '着哩' => '著哩',
                '着地' => '著地',
                '着墨' => '著墨',
                '着声' => '著聲',
                '着处' => '著處',
                '着她' => '著她',
                '着妳' => '著妳',
                '着姓' => '著姓',
                '着它' => '著它',
                '着定' => '著定',
                '着实' => '著實',
                '着己' => '著己',
                '着帐' => '著帳',
                '着床' => '著床',
                '着庸' => '著庸',
                '着式' => '著式',
                '着录' => '著錄',
                '着心' => '著心',
                '着志' => '著志',
                '着忙' => '著忙',
                '着急' => '著急',
                '着恼' => '著惱',
                '着惊' => '著驚',
                '着想' => '著想',
                '着意' => '著意',
                '着慌' => '著慌',
                '着我' => '著我',
                '着手' => '著手',
                '着抹' => '著抹',
                '着摸' => '著摸',
                '着撰' => '著撰',
                '着数' => '著數',
                '着明' => '著明',
                '着末' => '著末',
                '着极' => '著極',
                '着格' => '著格',
                '着棋' => '著棋',
                '着槁' => '著槁',
                '着气' => '著氣',
                '着法' => '著法',
                '着浅' => '著淺',
                '着火' => '著火',
                '着然' => '著然',
                '着甚' => '著甚',
                '着生' => '著生',
                '着疑' => '著疑',
                '着白' => '著白',
                '着相' => '著相',
                '着眼' => '著眼',
                '着着' => '著著',
                '着祂' => '著祂',
                '着积' => '著積',
                '着稿' => '著稿',
                '着笔' => '著筆',
                '着籍' => '著籍',
                '着紧' => '著緊',
                '着緑' => '著緑',
                '着绊' => '著絆',
                '着绩' => '著績',
                '着绯' => '著緋',
                '着绿' => '著綠',
                '着肉' => '著肉',
                '着脚' => '著腳',
                '着舰' => '著艦',
                '着色' => '著色',
                '着节' => '著節',
                '着花' => '著花',
                '着莫' => '著莫',
                '着落' => '著落',
                '着藁' => '著藁',
                '着衣' => '著衣',
                '着装' => '著裝',
                '着要' => '著要',
                '着警' => '著警',
                '着趣' => '著趣',
                '着边' => '著邊',
                '着迷' => '著迷',
                '着迹' => '著跡',
                '着重' => '著重',
                '着録' => '著録',
                '着闻' => '著聞',
                '着陆' => '著陸',
                '着雝' => '著雝',
                '着鞭' => '著鞭',
                '着题' => '著題',
                '着魔' => '著魔',
                '睡不着' => '睡不著',
                '睡不著书' => '睡不著書',
                '睡不著作' => '睡不著作',
                '睡不著名' => '睡不著名',
                '睡不著录' => '睡不著錄',
                '睡不著称' => '睡不著稱',
                '睡不著者' => '睡不著者',
                '睡不著述' => '睡不著述',
                '睡着' => '睡著',
                '睡著书' => '睡著書',
                '睡著作' => '睡著作',
                '睡著名' => '睡著名',
                '睡著录' => '睡著錄',
                '睡著称' => '睡著稱',
                '睡著者' => '睡著者',
                '睡著述' => '睡著述',
                '睹微知著' => '睹微知著',
                '睾丸' => '睪丸',
                '瞒着' => '瞞著',
                '瞒著书' => '瞞著書',
                '瞒著作' => '瞞著作',
                '瞒著名' => '瞞著名',
                '瞒著录' => '瞞著錄',
                '瞒著称' => '瞞著稱',
                '瞒著者' => '瞞著者',
                '瞒著述' => '瞞著述',
                '瞧着' => '瞧著',
                '瞧着书' => '瞧著書',
                '瞧著作' => '瞧著作',
                '瞧著名' => '瞧著名',
                '瞧著录' => '瞧著錄',
                '瞧著称' => '瞧著稱',
                '瞧著者' => '瞧著者',
                '瞧著述' => '瞧著述',
                '瞪着' => '瞪著',
                '瞪著书' => '瞪著書',
                '瞪著作' => '瞪著作',
                '瞪著名' => '瞪著名',
                '瞪著录' => '瞪著錄',
                '瞪著称' => '瞪著稱',
                '瞪著者' => '瞪著者',
                '瞪著述' => '瞪著述',
                '瞭望' => '瞭望',
                '石碁镇' => '石碁鎮',
                '福着' => '福著',
                '福著书' => '福著書',
                '福著作' => '福著作',
                '福著名' => '福著名',
                '福著录' => '福著錄',
                '福著称' => '福著稱',
                '福著者' => '福著者',
                '福著述' => '福著述',
                '穀梁' => '穀梁',
                '空着' => '空著',
                '空著书' => '空著書',
                '空著作' => '空著作',
                '空著名' => '空著名',
                '空著录' => '空著錄',
                '空著称' => '空著稱',
                '空著者' => '空著者',
                '空著述' => '空著述',
                '穿着' => '穿著',
                '穿著书' => '穿著書',
                '穿著作' => '穿著作',
                '穿著名' => '穿著名',
                '穿著录' => '穿著錄',
                '穿著称' => '穿著稱',
                '穿著者' => '穿著者',
                '穿著述' => '穿著述',
                '竖着' => '豎著',
                '竖著书' => '豎著書',
                '竖著作' => '豎著作',
                '竖著名' => '豎著名',
                '竖著录' => '豎著錄',
                '竖著称' => '豎著稱',
                '竖著者' => '豎著者',
                '竖著述' => '豎著述',
                '站着' => '站著',
                '站著书' => '站著書',
                '站著作' => '站著作',
                '站著名' => '站著名',
                '站著录' => '站著錄',
                '站著称' => '站著稱',
                '站著者' => '站著者',
                '站著述' => '站著述',
                '笑着' => '笑著',
                '笑著书' => '笑著書',
                '笑著作' => '笑著作',
                '笑著名' => '笑著名',
                '笑著录' => '笑著錄',
                '笑著称' => '笑著稱',
                '笑著者' => '笑著者',
                '笑著述' => '笑著述',
                '答复' => '答覆',
                '管着' => '管著',
                '管著书' => '管著書',
                '管著作' => '管著作',
                '管著名' => '管著名',
                '管著录' => '管著錄',
                '管著称' => '管著稱',
                '管著者' => '管著者',
                '管著述' => '管著述',
                '绑着' => '綁著',
                '绑著书' => '綁著書',
                '绑著作' => '綁著作',
                '绑著名' => '綁著名',
                '绑著录' => '綁著錄',
                '绑著称' => '綁著稱',
                '绑著者' => '綁著者',
                '绑著述' => '綁著述',
                '绕着' => '繞著',
                '绕著书' => '繞著書',
                '绕著作' => '繞著作',
                '绕著名' => '繞著名',
                '绕著录' => '繞著錄',
                '绕著称' => '繞著稱',
                '绕著者' => '繞著者',
                '绕著述' => '繞著述',
                '编著' => '編著',
                '缠着' => '纏著',
                '缠著书' => '纏著書',
                '缠著作' => '纏著作',
                '缠著名' => '纏著名',
                '缠著录' => '纏著錄',
                '缠著称' => '纏著稱',
                '缠著者' => '纏著者',
                '缠著述' => '纏著述',
                '罩着' => '罩著',
                '罩著书' => '罩著書',
                '罩著作' => '罩著作',
                '罩著名' => '罩著名',
                '罩著录' => '罩著錄',
                '罩著称' => '罩著稱',
                '罩著者' => '罩著者',
                '罩著述' => '罩著述',
                '美着' => '美著',
                '美著书' => '美著書',
                '美著作' => '美著作',
                '美著名' => '美著名',
                '美著录' => '美著錄',
                '美著称' => '美著稱',
                '美著者' => '美著者',
                '美著述' => '美著述',
                '耀着' => '耀著',
                '耀著书' => '耀著書',
                '耀著作' => '耀著作',
                '耀著名' => '耀著名',
                '耀著录' => '耀著錄',
                '耀著称' => '耀著稱',
                '耀著者' => '耀著者',
                '耀著述' => '耀著述',
                '老幺' => '老幺',
                '考着' => '考著',
                '考著书' => '考著書',
                '考著作' => '考著作',
                '考著名' => '考著名',
                '考著录' => '考著錄',
                '考著称' => '考著稱',
                '考著者' => '考著者',
                '考著述' => '考著述',
                '肉干干' => '肉乾乾',
                '肘手链足' => '肘手鍊足',
                '背着' => '背著',
                '背著书' => '背著書',
                '背著作' => '背著作',
                '背著名' => '背著名',
                '背著录' => '背著錄',
                '背著称' => '背著稱',
                '背著者' => '背著者',
                '背著述' => '背著述',
                '胶着' => '膠著',
                '胶著书' => '膠著書',
                '胶著作' => '膠著作',
                '胶著名' => '膠著名',
                '胶著录' => '膠著錄',
                '胶著称' => '膠著稱',
                '胶著者' => '膠著者',
                '胶著述' => '膠著述',
                '艺着' => '藝著',
                '艺著书' => '藝著書',
                '艺著作' => '藝著作',
                '艺著名' => '藝著名',
                '艺著录' => '藝著錄',
                '艺著称' => '藝著稱',
                '艺著者' => '藝著者',
                '艺著述' => '藝著述',
                '苦着' => '苦著',
                '苦著书' => '苦著書',
                '苦著作' => '苦著作',
                '苦著名' => '苦著名',
                '苦著录' => '苦著錄',
                '苦著称' => '苦著稱',
                '苦著者' => '苦著者',
                '苦著述' => '苦著述',
                '苧烯' => '薴烯',
                '获着' => '獲著',
                '获著书' => '獲著書',
                '获著作' => '獲著作',
                '获著名' => '獲著名',
                '获著录' => '獲著錄',
                '获著称' => '獲著稱',
                '获著者' => '獲著者',
                '获著述' => '獲著述',
                '萧乾' => '萧乾',
                '落着' => '落著',
                '落著书' => '落著書',
                '落著作' => '落著作',
                '落著名' => '落著名',
                '落著录' => '落著錄',
                '落著称' => '落著稱',
                '落著者' => '落著者',
                '落著述' => '落著述',
                '著书' => '著書',
                '著书立说' => '著書立說',
                '著作' => '著作',
                '著名' => '著名',
                '著录规则' => '著錄規則',
                '著文' => '著文',
                '著有' => '著有',
                '著称' => '著稱',
                '著者' => '著者',
                '著身' => '著身',
                '著述' => '著述',
                '蒙着' => '蒙著',
                '蒙著书' => '蒙著書',
                '蒙著作' => '蒙著作',
                '蒙著名' => '蒙著名',
                '蒙著录' => '蒙著錄',
                '蒙著称' => '蒙著稱',
                '蒙著者' => '蒙著者',
                '蒙著述' => '蒙著述',
                '藏着' => '藏著',
                '藏著书' => '藏著書',
                '藏著作' => '藏著作',
                '藏著名' => '藏著名',
                '藏著录' => '藏著錄',
                '藏著称' => '藏著稱',
                '藏著者' => '藏著者',
                '藏著述' => '藏著述',
                '蘸着' => '蘸著',
                '蘸著书' => '蘸著書',
                '蘸著作' => '蘸著作',
                '蘸著名' => '蘸著名',
                '蘸著录' => '蘸著錄',
                '蘸著称' => '蘸著稱',
                '蘸著者' => '蘸著者',
                '蘸著述' => '蘸著述',
                '行着' => '行著',
                '行著书' => '行著書',
                '行著作' => '行著作',
                '行著名' => '行著名',
                '行著录' => '行著錄',
                '行著称' => '行著稱',
                '行著者' => '行著者',
                '行著述' => '行著述',
                '衣着' => '衣著',
                '衣著书' => '衣著書',
                '衣著作' => '衣著作',
                '衣著名' => '衣著名',
                '衣著录' => '衣著錄',
                '衣著称' => '衣著稱',
                '衣著者' => '衣著者',
                '衣著述' => '衣著述',
                '装着' => '裝著',
                '装著书' => '裝著書',
                '装著作' => '裝著作',
                '装著名' => '裝著名',
                '装著录' => '裝著錄',
                '装著称' => '裝著稱',
                '装著者' => '裝著者',
                '装著述' => '裝著述',
                '裹着' => '裹著',
                '裹著书' => '裹著書',
                '裹著作' => '裹著作',
                '裹著名' => '裹著名',
                '裹著录' => '裹著錄',
                '裹著称' => '裹著稱',
                '裹著者' => '裹著者',
                '裹著述' => '裹著述',
                '覆蓋' => '覆蓋',
                '见微知著' => '見微知著',
                '见着' => '見著',
                '见著书' => '見著書',
                '见著作' => '見著作',
                '见著名' => '見著名',
                '见著录' => '見著錄',
                '见著称' => '見著稱',
                '见著者' => '見著者',
                '见著述' => '見著述',
                '视微知著' => '視微知著',
                '言幾析理' => '言幾析理',
                '记着' => '記著',
                '记著书' => '記著書',
                '记著作' => '記著作',
                '记著名' => '記著名',
                '记著录' => '記著錄',
                '记著称' => '記著稱',
                '记著者' => '記著者',
                '记著述' => '記著述',
                '论著' => '論著',
                '译著' => '譯著',
                '试着' => '試著',
                '试著书' => '試著書',
                '试著作' => '試著作',
                '试著名' => '試著名',
                '试著录' => '試著錄',
                '试著称' => '試著稱',
                '试著者' => '試著者',
                '试著述' => '試著述',
                '语着' => '語著',
                '语著书' => '語著書',
                '语著作' => '語著作',
                '语著名' => '語著名',
                '语著录' => '語著錄',
                '语著称' => '語著稱',
                '语著者' => '語著者',
                '语著述' => '語著述',
                '豫着' => '豫著',
                '豫著书' => '豫著書',
                '豫著作' => '豫著作',
                '豫著名' => '豫著名',
                '豫著录' => '豫著錄',
                '豫著称' => '豫著稱',
                '豫著者' => '豫著者',
                '豫著述' => '豫著述',
                '贞着' => '貞著',
                '贞著书' => '貞著書',
                '贞著作' => '貞著作',
                '贞著名' => '貞著名',
                '贞著录' => '貞著錄',
                '贞著称' => '貞著稱',
                '贞著者' => '貞著者',
                '贞著述' => '貞著述',
                '走着' => '走著',
                '走著书' => '走著書',
                '走著作' => '走著作',
                '走著名' => '走著名',
                '走著录' => '走著錄',
                '走著称' => '走著稱',
                '走著者' => '走著者',
                '走著述' => '走著述',
                '赶着' => '趕著',
                '赶著书' => '趕著書',
                '赶著作' => '趕著作',
                '赶著名' => '趕著名',
                '赶著录' => '趕著錄',
                '赶著称' => '趕著稱',
                '赶著者' => '趕著者',
                '赶著述' => '趕著述',
                '趴着' => '趴著',
                '趴著书' => '趴著書',
                '趴著作' => '趴著作',
                '趴著名' => '趴著名',
                '趴著录' => '趴著錄',
                '趴著称' => '趴著稱',
                '趴著者' => '趴著者',
                '趴著述' => '趴著述',
                '跃着' => '躍著',
                '跃著书' => '躍著書',
                '跃著作' => '躍著作',
                '跃著名' => '躍著名',
                '跃著录' => '躍著錄',
                '跃著称' => '躍著稱',
                '跃著者' => '躍著者',
                '跃著述' => '躍著述',
                '跑着' => '跑著',
                '跑著书' => '跑著書',
                '跑著作' => '跑著作',
                '跑著名' => '跑著名',
                '跑著录' => '跑著錄',
                '跑著称' => '跑著稱',
                '跑著者' => '跑著者',
                '跑著述' => '跑著述',
                '跟着' => '跟著',
                '跟著书' => '跟著書',
                '跟著作' => '跟著作',
                '跟著名' => '跟著名',
                '跟著录' => '跟著錄',
                '跟著称' => '跟著稱',
                '跟著者' => '跟著者',
                '跟著述' => '跟著述',
                '跪着' => '跪著',
                '跪著书' => '跪著書',
                '跪著作' => '跪著作',
                '跪著名' => '跪著名',
                '跪著录' => '跪著錄',
                '跪著称' => '跪著稱',
                '跪著者' => '跪著者',
                '跪著述' => '跪著述',
                '跳着' => '跳著',
                '跳著书' => '跳著書',
                '跳著作' => '跳著作',
                '跳著名' => '跳著名',
                '跳著录' => '跳著錄',
                '跳著称' => '跳著稱',
                '跳著者' => '跳著者',
                '跳著述' => '跳著述',
                '踌躇滿志' => '躊躇滿志',
                '踏着' => '踏著',
                '踏著书' => '踏著書',
                '踏著作' => '踏著作',
                '踏著名' => '踏著名',
                '踏著录' => '踏著錄',
                '踏著称' => '踏著稱',
                '踏著者' => '踏著者',
                '踏著述' => '踏著述',
                '踩着' => '踩著',
                '踩著书' => '踩著書',
                '踩著作' => '踩著作',
                '踩著名' => '踩著名',
                '踩著录' => '踩著錄',
                '踩著称' => '踩著稱',
                '踩著者' => '踩著者',
                '踩著述' => '踩著述',
                '身着' => '身著',
                '身著书' => '身著書',
                '身著作' => '身著作',
                '身著名' => '身著名',
                '身著录' => '身著錄',
                '身著称' => '身著稱',
                '身著者' => '身著者',
                '身著述' => '身著述',
                '躺着' => '躺著',
                '躺著书' => '躺著書',
                '躺著作' => '躺著作',
                '躺著名' => '躺著名',
                '躺著录' => '躺著錄',
                '躺著称' => '躺著稱',
                '躺著者' => '躺著者',
                '躺著述' => '躺著述',
                '转着' => '轉著',
                '转著书' => '轉著書',
                '转著作' => '轉著作',
                '转著名' => '轉著名',
                '转著录' => '轉著錄',
                '转著称' => '轉著稱',
                '转著者' => '轉著者',
                '转著述' => '轉著述',
                '载着' => '載著',
                '载著书' => '載著書',
                '载著作' => '載著作',
                '载著名' => '載著名',
                '载著录' => '載著錄',
                '载著称' => '載著稱',
                '载著者' => '載著者',
                '载著述' => '載著述',
                '较著' => '較著',
                '达着' => '達著',
                '达著书' => '達著書',
                '达著作' => '達著作',
                '达著名' => '達著名',
                '达著录' => '達著錄',
                '达著称' => '達著稱',
                '达著者' => '達著者',
                '达著述' => '達著述',
                '远着' => '遠著',
                '远著书' => '遠著書',
                '远著作' => '遠著作',
                '远著名' => '遠著名',
                '远著录' => '遠著錄',
                '远著称' => '遠著稱',
                '远著者' => '遠著者',
                '远著述' => '遠著述',
                '连着' => '連著',
                '连著书' => '連著書',
                '连著作' => '連著作',
                '连著名' => '連著名',
                '连著录' => '連著錄',
                '连著称' => '連著稱',
                '连著者' => '連著者',
                '连著述' => '連著述',
                '迫着' => '迫著',
                '追着' => '追著',
                '追著书' => '追著書',
                '追著作' => '追著作',
                '追著名' => '追著名',
                '追著录' => '追著錄',
                '追著称' => '追著稱',
                '追著者' => '追著者',
                '追著述' => '追著述',
                '逆着' => '逆著',
                '逆著书' => '逆著書',
                '逆著作' => '逆著作',
                '逆著名' => '逆著名',
                '逆著录' => '逆著錄',
                '逆著称' => '逆著稱',
                '逆著者' => '逆著者',
                '逆著述' => '逆著述',
                '逼着' => '逼著',
                '逼著书' => '逼著書',
                '逼著作' => '逼著作',
                '逼著名' => '逼著名',
                '逼著录' => '逼著錄',
                '逼著称' => '逼著稱',
                '逼著者' => '逼著者',
                '逼著述' => '逼著述',
                '遇着' => '遇著',
                '遇著书' => '遇著書',
                '遇著作' => '遇著作',
                '遇著名' => '遇著名',
                '遇著录' => '遇著錄',
                '遇著称' => '遇著稱',
                '遇著者' => '遇著者',
                '遇著述' => '遇著述',
                '遗著' => '遺著',
                '那麽' => '那麽',
                '郭子乾' => '郭子乾',
                '配着' => '配著',
                '配著书' => '配著書',
                '配著作' => '配著作',
                '配著名' => '配著名',
                '配著录' => '配著錄',
                '配著称' => '配著稱',
                '配著者' => '配著者',
                '配著述' => '配著述',
                '酿着' => '釀著',
                '酿著书' => '釀著書',
                '酿著作' => '釀著作',
                '酿著名' => '釀著名',
                '酿著录' => '釀著錄',
                '酿著称' => '釀著稱',
                '酿著者' => '釀著者',
                '酿著述' => '釀著述',
                '醯壶' => '醯壶',
                '醯酱' => '醯醬',
                '醯醋' => '醯醋',
                '醯醢' => '醯醢',
                '醯鸡' => '醯雞',
                '重复' => '重覆',
                '金链' => '金鍊',
                '铁链' => '鐵鍊',
                '铰链' => '鉸鍊',
                '银链' => '銀鍊',
                '铺着' => '鋪著',
                '铺著书' => '鋪著書',
                '铺著作' => '鋪著作',
                '铺著名' => '鋪著名',
                '铺著录' => '鋪著錄',
                '铺著称' => '鋪著稱',
                '铺著者' => '鋪著者',
                '铺著述' => '鋪著述',
                '链子' => '鍊子',
                '链条' => '鍊條',
                '链锁' => '鍊鎖',
                '链锤' => '鍊錘',
                '锁链' => '鎖鍊',
                '锺锻' => '鍾鍛',
                '锻锺' => '鍛鍾',
                '闫怀礼' => '閻懷禮',
                '闭着' => '閉著',
                '闭著书' => '閉著書',
                '闭著作' => '閉著作',
                '闭著名' => '閉著名',
                '闭著录' => '閉著錄',
                '闭著称' => '閉著稱',
                '闭著者' => '閉著者',
                '闭著述' => '閉著述',
                '闲着' => '閑著',
                '闲著书' => '閑著書',
                '闲著作' => '閑著作',
                '闲著名' => '閑著名',
                '闲著录' => '閑著錄',
                '闲著称' => '閑著稱',
                '闲著者' => '閑著者',
                '闲著述' => '閑著述',
                '阿部正瞭' => '阿部正瞭',
                '附着' => '附著',
                '附睾' => '附睪',
                '附著书' => '附著書',
                '附著作' => '附著作',
                '附著名' => '附著名',
                '附著录' => '附著錄',
                '附著称' => '附著稱',
                '附著者' => '附著者',
                '附著述' => '附著述',
                '陋着' => '陋著',
                '陋著书' => '陋著書',
                '陋著作' => '陋著作',
                '陋著名' => '陋著名',
                '陋著录' => '陋著錄',
                '陋著称' => '陋著稱',
                '陋著者' => '陋著者',
                '陋著述' => '陋著述',
                '陪着' => '陪著',
                '陪著书' => '陪著書',
                '陪著作' => '陪著作',
                '陪著名' => '陪著名',
                '陪著录' => '陪著錄',
                '陪著称' => '陪著稱',
                '陪著者' => '陪著者',
                '陪著述' => '陪著述',
                '陳堵' => '陳堵',
                '陳禕' => '陳禕',
                '随着' => '隨著',
                '随著书' => '隨著書',
                '随著作' => '隨著作',
                '随著名' => '隨著名',
                '随著录' => '隨著錄',
                '随著称' => '隨著稱',
                '随著者' => '隨著者',
                '随著述' => '隨著述',
                '隔着' => '隔著',
                '隔著书' => '隔著書',
                '隔著作' => '隔著作',
                '隔著名' => '隔著名',
                '隔著录' => '隔著錄',
                '隔著称' => '隔著稱',
                '隔著者' => '隔著者',
                '隔著述' => '隔著述',
                '隱睾' => '隱睪',
                '雅着' => '雅著',
                '雅著书' => '雅著書',
                '雅著作' => '雅著作',
                '雅著名' => '雅著名',
                '雅著录' => '雅著錄',
                '雅著称' => '雅著稱',
                '雅著者' => '雅著者',
                '雅著述' => '雅著述',
                '雍乾' => '雍乾',
                '靠着' => '靠著',
                '靠著作' => '靠著作',
                '靠著名' => '靠著名',
                '靠著录' => '靠著錄',
                '靠著称' => '靠著稱',
                '靠著者' => '靠著者',
                '靠著述' => '靠著述',
                '顶着' => '頂著',
                '顶著书' => '頂著書',
                '顶著作' => '頂著作',
                '顶著名' => '頂著名',
                '顶著录' => '頂著錄',
                '顶著称' => '頂著稱',
                '顶著者' => '頂著者',
                '顶著述' => '頂著述',
                '项链' => '項鍊',
                '顺着' => '順著',
                '顺著书' => '順著書',
                '顺著作' => '順著作',
                '顺著名' => '順著名',
                '顺著录' => '順著錄',
                '顺著称' => '順著稱',
                '顺著者' => '順著者',
                '顺著述' => '順著述',
                '领着' => '領著',
                '领著书' => '領著書',
                '领著作' => '領著作',
                '领著名' => '領著名',
                '领著录' => '領著錄',
                '领著称' => '領著稱',
                '领著者' => '領著者',
                '领著述' => '領著述',
                '飘着' => '飄著',
                '飘著书' => '飄著書',
                '飘著作' => '飄著作',
                '飘著名' => '飄著名',
                '飘著录' => '飄著錄',
                '飘著称' => '飄著稱',
                '飘著者' => '飄著者',
                '飘著述' => '飄著述',
                '飭令' => '飭令',
                '驾着' => '駕著',
                '驾著书' => '駕著書',
                '驾著作' => '駕著作',
                '驾著名' => '駕著名',
                '驾著录' => '駕著錄',
                '驾著称' => '駕著稱',
                '驾著者' => '駕著者',
                '驾著述' => '駕著述',
                '骂着' => '罵著',
                '骂著书' => '罵著書',
                '骂著作' => '罵著作',
                '骂著名' => '罵著名',
                '骂著录' => '罵著錄',
                '骂著称' => '罵著稱',
                '骂著者' => '罵著者',
                '骂著述' => '罵著述',
                '骑着' => '騎著',
                '骑著书' => '騎著書',
                '骑著作' => '騎著作',
                '骑著名' => '騎著名',
                '骑著录' => '騎著錄',
                '骑著称' => '騎著稱',
                '骑著者' => '騎著者',
                '骑著述' => '騎著述',
                '骗着' => '騙著',
                '骗著书' => '騙著書',
                '骗著作' => '騙著作',
                '骗著名' => '騙著名',
                '骗著录' => '騙著錄',
                '骗著称' => '騙著稱',
                '骗著者' => '騙著者',
                '骗著述' => '騙著述',
                '高着' => '高著',
                '高著书' => '高著書',
                '高著作' => '高著作',
                '高著名' => '高著名',
                '高著录' => '高著錄',
                '高著称' => '高著稱',
                '高著者' => '高著者',
                '高著述' => '高著述',
                '髭着' => '髭著',
                '髭著书' => '髭著書',
                '髭著作' => '髭著作',
                '髭著名' => '髭著名',
                '髭著录' => '髭著錄',
                '髭著称' => '髭著稱',
                '髭著者' => '髭著者',
                '髭著述' => '髭著述',
                '鬱姓' => '鬱姓',
                '鬱氏' => '鬱氏',
                '魏徵' => '魏徵',
                '鱼干干' => '魚乾乾',
                '鲶鱼' => '鯰魚',
                '麯崇裕' => '麯崇裕',
                '麴义' => '麴义',
                '麴英' => '麴英',
                '麽氏' => '麽氏',
                '麽麽' => '麼麼',
                '黏着' => '黏著',
                '黏著书' => '黏著書',
                '黏著作' => '黏著作',
                '黏著名' => '黏著名',
                '黏著录' => '黏著錄',
                '黏著称' => '黏著稱',
                '黏著者' => '黏著者',
                '黏著述' => '黏著述',
            );
        $cn2twDict = array_flip($cn2twDict);
        return strtr($content, $cn2twDict);
    }

}
