<?php

/**
 * URL解析规则
 * 例如：  114.html 对应 index.php?s=demo&c=show&id=114
 * 可以解析：  "114.html"  => 'index.php?s=demo&c=show&id=114',
 * 动态id解析：  "([0-9]+).html"  => 'index.php?s=demo&c=show&id=$1',
 */

return [

    /***********************下面写你自己的URL解析规则********************/

    /***********************共享栏目测试规则：栏目列表页面分页的伪静态解析*************************/
    "list\-([\w]+)\-([0-9]+).html(.*)"  => 'index.php?c=category&dir=$1&page=$2',

    /***********************共享栏目测试规则：栏目列表页面的伪静态解析*************************/
    "list\-([\w]+).html(.*)"  => 'index.php?c=category&dir=$1',

    /***********************共享栏目测试规则：内容页面分页的伪静态解析*************************/
    "show\-([0-9]+)\-([0-9]+).html(.*)"  => 'index.php?c=show&id=$1&page=$2',

    /***********************共享栏目测试规则：内容页面的伪静态解析*************************/
    "show\-([0-9]+).html(.*)"  => 'index.php?c=show&id=$1',


    //////////////////////////////////////////////////////////////////////////////////////


    /***********************独立模块测试规则、共享模块测试规则：搜索页（带分页）*************************/
    "([a-z]+)\/search\/(.*).html(.*)"  => 'index.php?s=$1&c=search&rewrite=$2',

    /***********************独立模块测试规则、共享模块测试规则：搜索页（不带分页）*************************/
    "([a-z]+)\/search.html(.*)"  => 'index.php?s=$1&c=search',



    //////////////////////////////////////////////////////////////////////////////////////

    /***********************独立模块测试规则：模块首页的伪静态解析*************************/
    "([a-z]+).html(.*)"  => 'index.php?s=$1',

    /***********************独立模块测试规则：栏目列表页面分页的伪静态解析*************************/
    "([a-z]+)\/list\/([0-9]+)\/([0-9]+).html(.*)"  => 'index.php?s=$1&c=category&id=$2&page=$3',

    /***********************独立模块测试规则：栏目列表页面的伪静态解析*************************/
    "([a-z]+)\/list\/([0-9]+).html(.*)"  => 'index.php?s=$1&c=category&id=$2',

    /***********************独立模块测试规则：内容页面分页的伪静态解析*************************/
    "([a-z]+)\/show\/([0-9]+)\/([0-9]+).html(.*)"  => 'index.php?s=$1&c=show&id=$2&page=$3',

    /***********************独立模块测试规则：内容页面的伪静态解析*************************/
    "([a-z]+)\/show\/([0-9]+).html(.*)"  => 'index.php?s=$1&c=show&id=$2',




];