<?php
class IndexAction extends HomeBaseAction {
    public function index(){
        header("Content-Type:text/html; charset=utf-8");
        $welcome = THEME_PATH.'Channel/welcome.html';
        if( !file_exists($welcome) ){ //是否存在引导页
        	   switch (LANG_SET){
		        	case 'en': $ChannelID = 2; break;
		        	case 'cn': $ChannelID = 1; break;
		        	case 'de': $ChannelID = 3; break;
		        	default: $ChannelID = 1;
		        }
		        $SitePath = $this->_getSitePath($ChannelID); //获取当前路径信息
		        $this->assign('SitePath', $SitePath);
		        
		        $m = D('Admin/Channel');
		        $data = $m->find($ChannelID);
		        
		        //是否有阅读权限
		        $data['ReadLevel'] = has_read_level( $data['ReadLevel'] ) ? 1 : 0;
		        
		        //频道优化设置, 会覆盖网站设置
		        $Title = empty($data['Title']) ? $GLOBALS['Config']['TITLE'] : $data['Title'];
		        $Keywords = empty($data['Keywords']) ? $GLOBALS['Config']['KEYWORDS'] : $data['Keywords'];
		        $Description = empty($data['Description']) ? $GLOBALS['Config']['DESCRIPTION'] : $data['Description'];
		        $data['Title'] = YdInput::checkSeoString($Title);
		        $data['Keywords'] = YdInput::checkSeoString($Keywords);
		        $data['Description'] = YdInput::checkSeoString($Description);
		        
		        $data['ChannelContent'] = ParseTag( $data['ChannelContent'] );
		        tag('channel_content', $data['ChannelContent']);
		        $data['HasParent'] = ( $data['Parent'] > 0 ) ? 1 : 0;
		        $data['TopChannelID'] = $ChannelID;
		        $data['TopHasChild'] = 0;
		        $this->assign($data);

		        $IndexTemplate = $data['IndexTemplate'];
		        $IndexTemplate = str_ireplace('.html', '', trim($IndexTemplate) );
		        $IndexTemplate = "Channel:$IndexTemplate";
		        unset($m, $data);
		        $this->display($IndexTemplate);
        }else{
        	$this->display('Channel:welcome');
        }

    }
}