<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */

/**
 * 解析模型参数属性
 * @param array $attribute
 */
function parsemodel($attribute){
	if( !$attribute ) return false;
	$SelectPicture = L('SelectPicture');
	$WebPublic  =  __ROOT__.'/Public/';
	for($i = 0; $i < count($attribute); $i++){
		//构造样式表=======================
		$style = "";  $class = "";  $attribute[$i]['html']="";
		$width = $attribute[$i]['DisplayWidth'];
		$height = $attribute[$i]['DisplayHeight'];
		$class = $attribute[$i]['DisplayClass'];
		$helpText = $attribute[$i]['DisplayHelpText'];
		if(!empty($width) ) $style = "width:$width;";
		if(!empty($height) ) $style .= "height:$height;";
		if(!empty($style) ) $style = "style='$style'";
		if(!empty($class) ) $class = "class='$class'";
		//===============================
		if( $attribute[$i]['IsRequire'] == 1 ){ //必填字段
			$attribute[$i]['DisplayName'] = '<b style="color:red">'.$attribute[$i]['DisplayName'].'</b>';
		}
		$name = $attribute[$i]['FieldName'];
		$value = $attribute[$i]['DisplayValue'];
		
		static $_js = array(); //保证js文件只加载一次
		switch ($attribute[$i]['DisplayType']){
			case 'editormini':
			case 'editor':  //编辑器
				$CkeditorJs = "";
				if (!isset($_js['CkeditorJs'])){
					$CkeditorJs = "<script type='text/javascript' src='__ROOT__/Public/ckeditor/ckeditor.js'></script>";
					$_js['CkeditorJs'] = 1;
				}
				$connectorPhp = "__ROOT__/Public/ckfinder/core/connector/php/connector.php";
				if(GROUP_NAME == 'Admin'){
					$bgcolor = '#bed393';
					//只有管理员才能调用图像浏览器
					$FileBrowser = "filebrowserBrowseUrl : '__ROOT__/Public/ckfinder/ckfinder.html',
						filebrowserImageBrowseUrl : '__ROOT__/Public/ckfinder/ckfinder.html?Type=Images',
						filebrowserFlashBrowseUrl : '__ROOT__/Public/ckfinder/ckfinder.html?Type=Flash', ";
					$customConfig = '';
				}else if(GROUP_NAME=='Member'){
					$bgcolor = '#e6e6e6';
					$FileBrowser = "";
					$customConfig = "customConfig:'__ROOT__/Public/ckeditor/config_member.js',";
				}
				$attribute[$i]['html'] = "<!-- 编辑器 开始 -->
					<textarea id='".$name."' name='".$name."'>".$value."</textarea>
					{$CkeditorJs}
					<script type='text/javascript'>
						$(document).ready(function(){
							window.CKEDITOR_BASEPATH='__ROOT__/Public/ckeditor/';
							CKEDITOR.replace('".$name."', {
								'uiColor': '{$bgcolor}', 'width':'{$width}', 'height':'{$height}',
								{$FileBrowser}
								{$customConfig}
								filebrowserUploadUrl : '{$connectorPhp}?command=QuickUpload&type=Files',
								filebrowserImageUploadUrl : '{$connectorPhp}?command=QuickUpload&type=Images',
								filebrowserFlashUploadUrl : '{$connectorPhp}?command=QuickUpload&type=Flash'
						     });
					     });
					</script>
					<!-- 编辑器 结束 -->";
				break;
			case 'select':    //下拉框
				if($value){
					$value = str_replace(array("\r\n","\r"), "\n", $value);
					$item = explode ("\n", $value);
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					for($j = 0; $j < count($item); $j++){
						$t = explode ('|', $item[$j] ); //value|item|是否是默认
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $t[0]) ? "selected='selected'" : '';
						}else{ //默认选中项
							$selected = empty($t[2]) ? "" : "selected='selected'";
						}
							
						$attribute[$i]['html'] .= "<option value='$t[0]' $selected>$t[1]</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'modelselect':    //模型下拉框
				$m1 = D('Admin/ChannelModel');
				$model = $m1->getChannelModel(0,1,true);
				if($model){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					for($j = 0; $j < count($model); $j++){
						$value = $model[$j]['ChannelModelID'];
						$text = $model[$j]['ChannelModelName'];
						$indexTemplate = $model[$j]['IndexTemplate'];
						$readTemplate = $model[$j]['ReadTemplate'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}else{ //默认选中项
							$selected = ($j==0) ?  "selected='selected'" : "";
						}
							
						$attribute[$i]['html'] .= "<option it='$indexTemplate' rt='$readTemplate' value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'displaytypeselect': //显示类型下拉框
				$m1 = D('Admin/Attribute');
				$model = $m1->getDisplayType();
				if($model){
					$attribute[$i]['html'] = "<select  id='$name'  name='$name'    $style  $class  >";
					for($j = 0; $j < count($model); $j++){
						$value = $model[$j]['DisplayTypeID'];
						$text = $model[$j]['DisplayTypeName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}else{ //默认选中项
							$selected = ($j==0) ?  "selected='selected'" : "";
						}
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'channelselectno':  //频道下拉框，并显示文字"不显示这个版块"，主要用于模板配置
			case 'channelselect':  //频道下拉框
				$m3 = D('Admin/Channel');
				if( isset($attribute[$i]['AdminGroupID']) ){
					$HasSingleModel =isset($attribute[$i]['HasSingleModel']) ? $attribute[$i]['HasSingleModel'] : true;
					$HasLinkModel =isset($attribute[$i]['HasLinkModel']) ? $attribute[$i]['HasLinkModel'] : true;
					$ExcludeChannel =isset($attribute[$i]['ExcludeChannel']) ? $attribute[$i]['ExcludeChannel'] : -1;
					$Depth = isset($attribute[$i]['Depth']) ? $attribute[$i]['Depth'] : -1;
					$Prefix =isset($attribute[$i]['Prefix']) ? $attribute[$i]['Prefix'] : '&nbsp;&nbsp;&nbsp;&nbsp;├─';
					$AdminGroupID =isset($attribute[$i]['AdminGroupID']) ? $attribute[$i]['AdminGroupID'] : -1;
					
					//必须缓存，当后台配置项过多时，非常慢
					$key = md5($HasSingleModel.$HasLinkModel.$ExcludeChannel.$Depth.$Prefix.$AdminGroupID);
					static $_cache = array();
					if (isset($_cache[$key])){
						$Channel = $_cache[$key];
					}else{
						$Channel = $m3->getChannel(0, $HasSingleModel, $HasLinkModel, $ExcludeChannel,$Depth, $Prefix, $AdminGroupID );
						$_cache[$key] = $Channel;
					}
				}else{ //会员
					$MemberGroupID = $attribute[$i]['MemberGroupID'];
					$Channel = $m3->getChannelPurview(0, $MemberGroupID, '&nbsp;&nbsp;&nbsp;&nbsp;├─ ', false);
				}
					
				$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
				//频道下拉框，并显示文字"不显示这个版块"，主要用于模板配置
				if($attribute[$i]['DisplayType']=='channelselectno'){
					$selected = ( $attribute[$i]['SelectedValue'] == 0) ? "selected='selected'" : '';
					$attribute[$i]['html'] .= "<option value='0' $selected>".L('NotShowSection')."</option>";
				}
				if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
					$firstText = $attribute[$i]['FirstText'];
					$firstValue = $attribute[$i]['FirstValue'];
					$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
				}
				
				if($Channel){
					for($j = 0; $j < count($Channel); $j++){
						//不显示投递简历频道
						if($Channel[$j]['ChannelID'] == 10 || $Channel[$j]['ChannelID'] == 11) continue;
						$value = $Channel[$j]['ChannelID'];
						$text = $Channel[$j]['ChannelName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
				}
				$attribute[$i]['html'] .= "</select>";
				break;
			case 'supporttypeselect':
				$st = D('Admin/SupportType');
				$stInfo = $st->getSupportType();
				if($stInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($stInfo); $j++){
						$value = $stInfo[$j]['SupportTypeID'];
						$text = $stInfo[$j]['SupportTypeName'];

						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}

						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'linkclassselectno':
			case 'linkclassselect':
				$lc = D('Admin/LinkClass');
				$lcInfo = $lc->getLinkClass();
				if($lcInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if($attribute[$i]['DisplayType']=='linkclassselectno'){
						$selected = ( $attribute[$i]['SelectedValue'] == 0) ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='0' $selected>".L('NotShowSection')."</option>";
					}
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($lcInfo); $j++){
						$value = $lcInfo[$j]['LinkClassID'];
						$text = $lcInfo[$j]['LinkClassName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
							
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'adgroupselectno':
			case 'adgroupselect':
				$lc = D('Admin/AdGroup');
				$lcInfo = $lc->getAdGroup(array('IsEnable'=>1) );
				if($lcInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					//并显示文字"不显示这个版块"，主要用于模板配置
					if($attribute[$i]['DisplayType']=='adgroupselectno'){
						$selected = ( $attribute[$i]['SelectedValue'] == 0) ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='0' $selected>".L('NotShowSection')."</option>";
					}
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($lcInfo); $j++){
						$value = $lcInfo[$j]['AdGroupID'];
						$text = $lcInfo[$j]['AdGroupName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
							
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'mailclassselect':
				$lc = D('Admin/MailClass');
				$lcInfo = $lc->getMailClass();
				if($lcInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($lcInfo); $j++){
						$value = $lcInfo[$j]['MailClassID'];
						$text = $lcInfo[$j]['MailClassName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
							
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'bannergroupselectno':
			case 'bannergroupselect':
				$lc = D('Admin/BannerGroup');
				$lcInfo = $lc->getBannerGroup();
				if($lcInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					//显示文字"不显示这个版块"，主要用于模板配置
					if($attribute[$i]['DisplayType']=='bannergroupselectno'){
						$selected = ( $attribute[$i]['SelectedValue'] == 0) ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='0' $selected>".L('NotShowSection')."</option>";
					}
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					
					for($j = 0; $j < count($lcInfo); $j++){
						$value = $lcInfo[$j]['BannerGroupID'];
						$text = $lcInfo[$j]['BannerGroupName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
							
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'adselect':
				$lc = D('Admin/Ad');
				$lcInfo = $lc->getAd();
				if($lcInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($lcInfo); $j++){
						$value = $lcInfo[$j]['AdID'];
						$text = "[{$value}] {$lcInfo[$j]['AdName']}";

						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}

						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'areaselect':
				//仅对ProvinceID字段有效
				if( $name!='ProvinceID') break;
				$ma = D('Admin/Area');
				$areaInfo = $ma->getProvinceAndCity(1);
				if(isset($attribute[$i]['ProvinceSelectedValue'])){
					$ProvinceIDSeclected =$attribute[$i]['ProvinceSelectedValue'];
				}else{
					//默认为第一个，$areaInfo为关联数组，不能通过下标获取
					$ProvinceIDSeclected = 0;
					//foreach($areaInfo as $v){
					//	$ProvinceIDSeclected = $v['AreaID'];
					//	break;
					//}
				}
				if($areaInfo){
					//省==
					$attribute[$i]['html'] = "<select id='ProvinceID' name='ProvinceID'  $style  $class>";
					$selected = ($ProvinceIDSeclected== 0) ? "selected='selected'" : '';
					$attribute[$i]['html'] .= "<option value='0' citylist='' $selected>请选择</option>";
					foreach($areaInfo as $v){
						$selected = ($ProvinceIDSeclected== $v['AreaID']) ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='{$v['AreaID']}' citylist='{$v['CityList']}' $selected>{$v['AreaName']}</option>";
					}
					$attribute[$i]['html'] .= "</select>";
					//==
					
					//市== $areaInfo的key值为ProvinceID
					if( isset($areaInfo[$ProvinceIDSeclected]) ){
						$CityList = explode('@', $areaInfo[$ProvinceIDSeclected]['CityList']);
						$attribute[$i]['html'] .= "&nbsp;<select id='CityID' name='CityID'  $style  $class>";
						foreach($CityList as $v){
							$cities = explode(',', $v);
							$CityID = $cities[0];
							$CityName = $cities[1];
							if( isset($attribute[$i]['CitySelectedValue']) ){ //自定义选中项
								$selected = ( $attribute[$i]['CitySelectedValue'] == $CityID) ? "selected='selected'" : '';
							}else{
								$selected = '';
							}
							$attribute[$i]['html'] .= "<option value='{$CityID}' $selected>{$CityName}</option>";
						}
						$attribute[$i]['html'] .= "</select>";
					}else{
						$attribute[$i]['html'] .= "&nbsp;<select id='CityID' name='CityID'  $class style='display:none;'></select>";
					}
					//==
					$attribute[$i]['html'] .= "<input type='hidden' name='DistrictID' value='' />";
					$attribute[$i]['html'] .= "<input type='hidden' name='TownID' value='' />";
					
					//省市联动脚本==
					$attribute[$i]['html'] .= "<script>
						$(document).ready(function(){
							$('#ProvinceID').change( function(){
								var objProvinceSelect = $('#ProvinceID').children('option:selected');
								var citylist = objProvinceSelect.attr('citylist');
								if(citylist){
									var arrCitylist= citylist.split('@');
									var html = '';
									for(var i = 0; i < arrCitylist.length; i++){
										var temp = arrCitylist[i].split(',');
										html += '<option value=\"'+temp[0]+'\">'+temp[1]+'</option>';
									}
									$('#CityID').html(html);
									$('#CityID').show();
								}else{
									html = '<option value=\"0\"></option>';
									$('#CityID').html(html);
									$('#CityID').hide();
								}
							});					
						});
					</script>";
					//==========
				}
				break;
			case 'areaselect4':  //省市区县镇四级联动
				if( $name!='ProvinceID') break;
				//获取区域数据
				$ProvinceIDSeclected = isset($attribute[$i]['ProvinceSelectedValue']) ? $attribute[$i]['ProvinceSelectedValue'] : 0;
				$CityIDSelected = isset($attribute[$i]['CitySelectedValue']) ? $attribute[$i]['CitySelectedValue'] : 0;
				$DistrictIDSelected  = isset($attribute[$i]['DistrictSelectedValue']) ? $attribute[$i]['DistrictSelectedValue'] : 0;
				$TownIDSelected = isset($attribute[$i]['TownSelectedValue']) ? $attribute[$i]['TownSelectedValue'] : 0;
				
				$ma = D('Admin/Area');
				$area = $ma->getArea(0, 1);
				if($area){
					//==省==
					$attribute[$i]['html'] = "<select id='ProvinceID' name='ProvinceID'  $style  $class>";
					$selected = ($ProvinceIDSeclected== 0) ? "selected='selected'" : '';
					$attribute[$i]['html'] .= "<option value='0' $selected>请选择</option>";
					foreach($area as $v){
						$selected = ($ProvinceIDSeclected== $v['AreaID']) ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='{$v['AreaID']}'  $selected>{$v['AreaName']}</option>";
					}
					$attribute[$i]['html'] .= "</select>";
					
					//==市==
					$CityDefaultHtml = "&nbsp;<select id='CityID' name='CityID'  style='display:none;'  $class><option value='0'></option></select>";
					if($ProvinceIDSeclected>0 || $CityIDSelected>0){
						$area = $ma->getArea($ProvinceIDSeclected, 1);
						if(!empty($area)){
							$attribute[$i]['html'] .= "&nbsp;<select id='CityID' name='CityID'  $style  $class>";
							$selected = ($CityIDSelected== 0) ? "selected='selected'" : '';
							$attribute[$i]['html'] .= "<option value='0' $selected>请选择</option>";
							foreach($area as $v){
								$selected = ($CityIDSelected== $v['AreaID']) ? "selected='selected'" : '';
								$attribute[$i]['html'] .= "<option value='{$v['AreaID']}'  $selected>{$v['AreaName']}</option>";
							}
							$attribute[$i]['html'] .= "</select>";
						}
					}else{
						$attribute[$i]['html'] .= $CityDefaultHtml;
					}
					
					//==区县==
					$DistrictDefaultHtml = "&nbsp;<select id='DistrictID' name='DistrictID'  style='display:none;'  $class><option value='0'></option></select>";
					if($CityIDSelected > 0 || $DistrictIDSelected > 0 ){
						$area = $ma->getArea($CityIDSelected, 1);
						if(!empty($area)){
							$attribute[$i]['html'] .= "&nbsp;<select id='DistrictID' name='DistrictID'  $style  $class>";
							$selected = ($DistrictIDSelected== 0) ? "selected='selected'" : '';
							$attribute[$i]['html'] .= "<option value='0' $selected>请选择</option>";
							foreach($area as $v){
								$selected = ($DistrictIDSelected== $v['AreaID']) ? "selected='selected'" : '';
								$attribute[$i]['html'] .= "<option value='{$v['AreaID']}'  $selected>{$v['AreaName']}</option>";
							}
							$attribute[$i]['html'] .= "</select>";
						}
					}else{
						$attribute[$i]['html'] .= $DistrictDefaultHtml;
					}
					
					//==城镇==
					$TownDefaultHtml = "&nbsp;<select id='TownID' name='TownID'  style='display:none;'  $class><option value='0'></option></select>";
					if($DistrictIDSelected > 0 || $TownIDSelected > 0){
						$area = $ma->getArea($DistrictIDSelected, 1);
						if(!empty($area)){
							$attribute[$i]['html'] .= "&nbsp;<select id='TownID' name='TownID'  $style  $class>";
							$selected = ($TownIDSelected== 0) ? "selected='selected'" : '';
							$attribute[$i]['html'] .= "<option value='0' $selected>请选择</option>";
							foreach($area as $v){
								$selected = ($TownIDSelected== $v['AreaID']) ? "selected='selected'" : '';
								$attribute[$i]['html'] .= "<option value='{$v['AreaID']}'  $selected>{$v['AreaName']}</option>";
							}
							$attribute[$i]['html'] .= "</select>";
						}
					}else{
						$attribute[$i]['html'] .= $TownDefaultHtml;
					}
					
					$ApiUrl = ApiUrl('GetArea');
					$attribute[$i]['html'] .= "<script>
						$(document).ready(function(){
							function changeArea(currentid, id){
								var seclectedID = $(currentid).val();
								if(currentid=='#ProvinceID'){
									$('#CityID').hide(); $('#DistrictID').hide(); $('#TownID').hide();
									if(seclectedID==0){
										$('#CityID').html(\"{$CityDefaultHtml}\");
										$('#DistrictID').html(\"{$DistrictDefaultHtml}\");
										$('#TownID').html(\"{$TownDefaultHtml}\");
									}
								}else if(currentid=='#CityID'){
									$('#DistrictID').hide(); $('#TownID').hide();
									if(seclectedID==0){
										$('#DistrictID').html(\"{$DistrictDefaultHtml}\");
										$('#TownID').html(\"{$TownDefaultHtml}\");
									}
								}else if(currentid=='#DistrictID'){
									$('#TownID').hide();
									if(seclectedID==0){
										$('#TownID').html(\"{$TownDefaultHtml}\");
									}
								}
								
								if(seclectedID>0) {
									$.get('{$ApiUrl}', {AreaID: seclectedID}, function(data){
										   var html='<option value=\"0\">请选择</option>';
										   if(data.Data.length>0){
												 for(var i=0; i<data.Data.length; i++){
												     html += '<option value='+data.Data[i].AreaID+'>'+data.Data[i].AreaName+'</option>';
						                         }
						                         $(id).html(html);  $(id).show();
											}else{
												 $(id).hide(); $(id).html(html);
							                }
									}, 'json');
				                }
							}
							$('#ProvinceID').change( function(){ changeArea('#ProvinceID','#CityID'); });
							$('#CityID').change( function(){ changeArea('#CityID','#DistrictID'); });
							$('#DistrictID').change( function(){ changeArea('#DistrictID','#TownID'); });
						});
					</script>";
				}
				break;
			case 'membergroupselect':
				$mg = D('Admin/MemberGroup');
				$mgInfo = $mg->getMemberGroup();
				if($mgInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($mgInfo); $j++){
						$value = $mgInfo[$j]['MemberGroupID'];
						$text = $mgInfo[$j]['MemberGroupName'];

						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}

						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'admingroupselect':
				$ag = D('Admin/AdminGroup');
				$agInfo = $ag->getAdminGroup();
				if($agInfo){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($agInfo); $j++){
						$value = $agInfo[$j]['AdminGroupID'];
						$text = $agInfo[$j]['AdminGroupName'];
							
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
							
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'specialselectno':
			case 'specialselect':
				$s = D('Admin/Special');
				$Special = $s->getSpecial(array('IsEnable'=>1)); //获取当前频道所有的专题
				if( $Special ){ //如果没有专题, 则没有显示
					$attribute[$i]['html'] = "<select  id='$name' multiple='multiple' size='5' name='".$name."[]'    $style  $class  >";
					$attribute[$i]['html'] .= "<optgroup label='请选择所属专题（按Ctrl+左键可进行多选）'>";
					//频道下拉框，并显示文字"不显示这个版块"，主要用于模板配置
					if($attribute[$i]['DisplayType']=='specialselectno'){
						$selected = in_array(0, $attribute[$i]['SelectedValue'])  ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='0' $selected>".L('NotShowSection')."</option>";
					}
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){ //默认第一个值
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					$n = count($Special);
					for($j = 0; $j < $n; $j++){
						$value = $Special[$j]['SpecialID'];
						$text = $Special[$j]['SpecialName'];
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = in_array($value, $attribute[$i]['SelectedValue'])  ? "selected='selected'" : '';
						}
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</optgroup></select>";
				}
				break;
			case 'channelexselectno':
			case 'channelexselect':
				$mc = D('Admin/Channel');
				if( isset($attribute[$i]['AdminGroupID']) ){ //管理员
					$HasSingleModel =isset($attribute[$i]['HasSingleModel']) ? $attribute[$i]['HasSingleModel'] : true;
					$HasLinkModel =isset($attribute[$i]['HasLinkModel']) ? $attribute[$i]['HasLinkModel'] : true;
					$ExcludeChannel =isset($attribute[$i]['ExcludeChannel']) ? $attribute[$i]['ExcludeChannel'] : -1;
					
					$Depth = isset($attribute[$i]['Depth']) ? $attribute[$i]['Depth'] : -1;
					$Prefix =isset($attribute[$i]['Prefix']) ? $attribute[$i]['Prefix'] : '&nbsp;&nbsp;&nbsp;&nbsp;├─';
					$field = 'ChannelID,ChannelName,HasChild,ChannelModelID';
					$AdminGroupID = $attribute[$i]['AdminGroupID'];
					$Channel = $mc->getChannel(0, $HasSingleModel, $HasLinkModel, $ExcludeChannel,$Depth, $Prefix, $AdminGroupID,$field);
				}else{ //会员
					$MemberGroupID = $attribute[$i]['MemberGroupID'];
					$Channel = $mc->getChannelPurview(0, $MemberGroupID, '&nbsp;&nbsp;&nbsp;&nbsp;├─ ', false);
				}
				
				if( $Channel ){ //如果没有专题, 则没有显示
					$attribute[$i]['html'] = "<select  id='$name' multiple='multiple' size='6' name='".$name."[]'    $style  $class  >";
					$attribute[$i]['html'] .= "<optgroup label='请选择频道（按Ctrl+左键可进行多选）'>";
					//频道下拉框，并显示文字"不显示这个版块"，主要用于模板配置
					if($attribute[$i]['DisplayType']=='channelexselectno'){
						$selected = in_array(0, $attribute[$i]['SelectedValue'])  ? "selected='selected'" : '';
						$attribute[$i]['html'] .= "<option value='0' $selected>".L('NotShowSection')."</option>";
					}
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){ //默认第一个值
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					$n =count($Channel);
					for($j = 0; $j < $n; $j++){
						$value = $Channel[$j]['ChannelID'];
						if($value == 0 || $value == 1) continue;
						$cmid = $Channel[$j]['ChannelModelID'];
						if(!$attribute[$i]['DisplayType']=='channelexselectno'){
							if( $Channel[$j]['HasChild'] == 0 && ($cmid == 33 || $cmid == 32) ) continue;
						}
						$text = $Channel[$j]['ChannelName'];
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = in_array($value, $attribute[$i]['SelectedValue'])  ? "selected='selected'" : '';
						}
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</optgroup></select>";
				}
				break;
			case 'attributegroupselect':  //属性组下拉列表
				$m = D('Admin/Attribute');
				$info = $m->getGroup( $attribute[$i]['ChannelModelID'], -1);
				if($info){
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					if( isset($attribute[$i]['FirstValue']) && isset($attribute[$i]['FirstText']) ){
						$firstText = $attribute[$i]['FirstText'];
						$firstValue = $attribute[$i]['FirstValue'];
						$attribute[$i]['html'] .= "<option value='$firstValue'>$firstText</option>";
					}
					for($j = 0; $j < count($info); $j++){
						$value = $info[$j]['AttributeID'];
						$text = $info[$j]['DisplayName'];

						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $attribute[$i]['SelectedValue'] == $value) ? "selected='selected'" : '';
						}
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
				}
				break;
			case 'labelcheckbox': //标记复选框
				$lbl= D('Admin/Label');
				$LabelInfo = $lbl->getLabel( $attribute[$i]['ChannelModelID'] ,-1,1);
				$checked = explode(',', $value); //转化为数组
				$name .= '[]';
				foreach($LabelInfo as $lk=>$lv) {
					$chk = '';
					if($checked == $lv['LabelID']  || in_array($lv['LabelID'], $checked) ) {
						$chk = "checked='checked'";
					}
					$attribute[$i]['html']  .= "<label><input  id='$name'  type='checkbox' $chk  name='$name' value='".$lv['LabelID']."'>".$lv['LabelName'].'</label>&nbsp;&nbsp;&nbsp;&nbsp;';
				}
				break;
			case 'membergroupcheckbox': //会员分组复选框
				$lbl= D('Admin/MemberGroup');
				$mginfo = $lbl->getMemberGroup( );
				$checked = explode(',', $value); //转化为数组
				$name .= '[]';
				foreach($mginfo as $lk=>$lv) {
					$chk = '';
					if($checked == $lv['MemberGroupID']  || in_array($lv['MemberGroupID'], $checked) ) {
						$chk = "checked='checked'";
					}
					$attribute[$i]['html']  .= "<label><input  id='$name'  type='checkbox' $chk  name='$name' value='".$lv['MemberGroupID']."'>".$lv['MemberGroupName'].'</label>&nbsp;&nbsp;&nbsp;&nbsp;';
				}
				break;
			case 'checkbox':  //复选框
				if($value){
					$name .= '[]';
					$value = str_replace(array("\r\n","\r"), "\n", $value);
					$item = explode ("\n", $value);
					$sv = (array)explode(',', $attribute[$i]['SelectedValue']);
					for($j = 0; $j < count($item); $j++){
						$t = explode ('|', $item[$j] ); //value|item|是否是默认
						if( isset($sv) ){ //自定义选中项
							$checked = in_array($t[0], $sv) ? "checked" : '';
						}else{ //默认选中项
							$checked = ( !empty($t[2]) ) ?  "checked" : "";
						}
						$attribute[$i]['html'] .= "<label><input type='checkbox'  id='$name'  name='$name'   $class  value='$t[0]'  $checked />$t[1]</label>&nbsp;&nbsp;&nbsp;&nbsp;";
					}
				}
				break;
			case 'radio':   //单选钮
				$attribute[$i]['html']="";
				if($value){
					$value = str_replace(array("\r\n","\r"), "\n", $value);
					$item = explode ("\n", $value);
					for($j = 0; $j < count($item); $j++){
						$t = explode ('|', $item[$j] ); //value|item|是否是默认
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$checked = ( $attribute[$i]['SelectedValue'] == $t[0]) ? "checked" : '';
						}else{ //默认选中项
							$checked = ( !empty($t[2]) ) ?  "checked" : "";
						}
						$attribute[$i]['html'] .= "<label><input type='radio'  id='$name'  name='$name'  $class  value='$t[0]'  $checked />$t[1]</label>&nbsp;&nbsp;&nbsp;&nbsp;";
					}
				}
				break;
			case 'adtyperadio':
				$at = D('Admin/AdType');
				$AtInfo = $at->getAdType( );
				$attribute[$i]['html']="";
				$atTemp = true;
				foreach ($AtInfo as $k=>$v){
					if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
						$checked = ( $attribute[$i]['SelectedValue'] == $v['AdTypeID'] ) ? "checked" : '';
					}else{ //默认选中第一项
						$checked = '';
						if( $atTemp ) $checked = "checked";
						$atTemp = false;
					}
					$attribute[$i]['html'] .= "<label><input type='radio'  id='$name'  name='$name'  $style  $class  value='".$v['AdTypeID']."'  $checked />".$v['AdTypeName']."</label>&nbsp;&nbsp;&nbsp;&nbsp;";
				}
				break;
			case 'attachment': //附件上传
			case 'image':      //图片上传
			case 'imageex':  //图片上传升级版本
				if( empty($attribute[$i]['IsMobile'] ) ){
					$attribute[$i]['html'].="<script type='text/javascript'>\n";
					if( GROUP_NAME == 'Admin'){ //会员端不显示从服务器浏览
						$attribute[$i]['html'].="function Browser{$name}Server(){
						    var finder = new CKFinder();
						    finder.basePath = '".$WebPublic."ckfinder';
						    finder.selectActionFunction = Set{$name}FileField;
						    finder.popup();
						}
						function Set{$name}FileField(fileUrl){
						    document.getElementById( '{$name}FileImage' ).value = fileUrl;
						}";
					}
					
					$isthumb = ($name=='InfoPicture') ? 1 : 0; //只有信息的缩略图才生成缩略图
					$nowaterlist = array('MemberAvatar'); //不加水印的上传
					$addwater = in_array($name, $nowaterlist) ? '/addwater/no' : '';
					$style = "width:480px;";  //固定宽度
					if(!empty($height) ) $style .= "height:$height;";
					$style = "style='$style'";
					
					//jquery加载
					$attribute[$i]['html'].="$(document).ready(function(){
					    $('#{$name}FileImage').powerFloat({targetMode: 'ajax',targetAttr: 'value',position: '5-7'});
					    $('#{$name}File').change(function(){
					    	  if( !$(this).val() ) return;
						      $('form:first').attr('action','__URL__/Upload/currentfile/{$name}File/isthumb/{$isthumb}{$addwater}');
						      $('form:first').submit();
					    });
					});
					</script>";

					if( $height > 50 ){
						$attribute[$i]['html'].="<textarea  $style $class id='{$name}FileImage' name = '$name' >$value</textarea>";
					}else{
						$attribute[$i]['html'].="<input type='text' $style $class id='{$name}FileImage' name = '$name'  value='$value'  />";
					}
					
					$attribute[$i]['html'].="<span class='UploadWrapper'>
					    <input class='btnFileUpload' type='button' value='上传' />
					    <input class='InputFile' id='{$name}File' name ='{$name}File' type ='file' $class />
					</span>";
					
					//$attribute[$i]['html'].="<input id='btn{$name}Upload' name ='btn{$name}Upload'  type ='submit' value='点击上传' class='btnUpload'  />";
					if( GROUP_NAME == 'Admin'){ //会员端不显示从服务器浏览
						$attribute[$i]['html'].="<input id='btn{$name}Server' onclick='Browser{$name}Server()' name ='btn{$name}Server'  type ='button' value='{$SelectPicture}'  class='btnUpload'  />";
					}
					if( $helpText != ''){
						if( strlen($helpText) > 50 ) {
							$attribute[$i]['html'] .= "<br/><span class='Caution' style='margin-left:0;'>$helpText</span>";
						}else{
							$attribute[$i]['html'] .= "<span class='Caution'>$helpText</span>";
						}
					}
				}else{
					$attribute[$i]['html'].="<script type='text/javascript'>
						$(document).ready(function(){
						    $('#{$name}File').change(function(){
							      $('form:first').attr('action','__URL__/Upload/currentfile/{$name}File/isthumb/{$isthumb}{$addwater}');
							      $('#frm').submit();
						    });
						});
					</script>
					<div class='weui-uploader'>
							<div class='weui-uploader__bd'>
						          <ul class='weui-uploader__files' id='uploaderFiles'>
						            <li id='{$name}FileImage' class='weui-uploader__file' style='background-image:url({$value})'></li>
						          </ul>
						          <div class='weui-uploader__input-box'>
						          	<input class='{$name}FileImage' name ='{$name}' type ='hidden' value='{$value}' />
						            <input id='{$name}File' name ='{$name}File' class='weui-uploader__input' type='file' accept='image/*' >
						          </div>
					        </div>
					</div>";
				}
				break;
			case 'textarea':    //多行文本
				$attribute[$i]['html'] = "<textarea $style  $class name='$name'  id='$name' >$value</textarea>";
				break;
			case 'label': //文本标签
				$attribute[$i]['html'] = "<span $style  $class name='$name'  id='$name' >$value</span>";
				break;
			case 'datetime': //日期时间
				$attribute[$i]['html'] = "";
				if (!isset($_js['WdatePickerJs'])){
					$attribute[$i]['html'] .= "<script type='text/javascript' src='__ROOT__/Public/My97DatePicker/WdatePicker.js'></script>";
					$_js['WdatePickerJs'] = 1;
				}
				$attribute[$i]['html'] .="<input name='$name' type='text' class='Wdate' id='$name'  $style  $class  onClick=\"WdatePicker({skin:'whyGreen',dateFmt:'yyyy-MM-dd HH:mm:ss'})\" readonly='readonly'   value='$value' />";
				break;
			case 'date': //日期
				$attribute[$i]['html'] = "";
				if (!isset($_js['WdatePickerJs'])){
					$attribute[$i]['html'] .= "<script type='text/javascript' src='__ROOT__/Public/My97DatePicker/WdatePicker.js'></script>";
					$_js['WdatePickerJs'] = 1;
				}
				$attribute[$i]['html'] .="<input name='$name' type='text' class='Wdate' id='$name'  $style  $class  onClick=\"WdatePicker({skin:'whyGreen',dateFmt:'yyyy-MM-dd'})\" readonly='readonly'   value='$value' />";
				break;
			case 'password'://密码框
				$attribute[$i]['html'] = "<input type='password' $style $class name = '$name'  id='$name'   value='$value'  />";
				break;
			case 'album': //相册
				$data = yd_split($value, array('AlbumTitle','AlbumPicture','AlbumDescription'));
				$attribute[$i]['html'].="<table class='table-album' id='table-album{$name}' border='0'><thead><tr>
					<th class='anum'>序号</th><th class='apic'>相册标题 / 图片</th>
					<th class='ades'>相册描述</th><th class='aop'>操作</th></tr></thead><tbody>";
				if( empty($data) ){
					$attribute[$i]['html'] .= "<tr><td class='anum'>1</td><td class='apic'>
						<input type='text' class='at' id='AlbumTitle' name='AlbumTitle'  value=''  /><br/>
						<input onmouseover='imagefloat(this)' type='text' class='ap' id='{$name}File_1Image' name='AlbumPicture'  value='$value'  /><br/>
						<span class='UploadWrapper'>
						    <input class='btnFileUpload' type='button' value='上传' />
						    <input type='file' class='af' id='{$name}File_1' name ='{$name}File_1' onchange='startUpload(this)' />
						</span>";
						
						if( GROUP_NAME == 'Admin'){
							$attribute[$i]['html'] .= "<input onclick='BrowserAlbumServer(this)' id='btn{$name}Server'  name ='btn{$name}Server'  type ='button' value='{$SelectPicture}'  class='btnUpload'  />";
						}
						
						$attribute[$i]['html'] .= "</td><td><textarea style='width:97%;height:68px;' class='ad' id='AlbumDescription' name='AlbumDescription'>";
						$attribute[$i]['html'] .= "</textarea></td><td><a onclick='delAlbumItem(this, \"{$name}\")'  class='btnDel'>删除</a></td></tr>";
				}else{  //表示修改
					$anum = 1;
					foreach ( $data as $v){
						$AlbumTitle = $v['AlbumTitle'];
						$AlbumPicture= $v['AlbumPicture'];
						$AlbumDescription = $v['AlbumDescription'];
						$attribute[$i]['html'] .= "<tr><td class='anum'>{$anum}</td><td class='apic'>
						<input type='text' class='at' id='AlbumTitle' name='AlbumTitle'  value='{$AlbumTitle}'  /><br/>
						<input onmouseover='imagefloat(this)' type='text' class='ap' id='{$name}File_{$anum}Image' name='AlbumPicture'  value='{$AlbumPicture}'  /><br/>
						<span class='UploadWrapper'>
						    <input class='btnFileUpload' type='button' value='上传' />
							<input type='file' class='af' id='{$name}File_{$anum}' name ='{$name}File_{$anum}' onchange='startUpload(this)' />
						</span>";
						if( GROUP_NAME == 'Admin'){
							$attribute[$i]['html'] .= "<input onclick='BrowserAlbumServer(this)' id='btn{$name}Server'  name ='btn{$name}Server'  type ='button' value='{$SelectPicture}'  class='btnUpload'  />";
						}
						$attribute[$i]['html'] .= "</td><td><textarea style='width:97%;height:68px;' class='ad' id='AlbumDescription' name='AlbumDescription'>{$AlbumDescription}";
						$attribute[$i]['html'] .= "</textarea></td><td><a onclick='delAlbumItem(this,\"{$name}\")'  class='btnDel'>删除</a></td></tr>";
						$anum++;
					}
				}
				$attribute[$i]['html'] .= "</tbody><tfoot><tr><td class='add' colspan='4'>";
				$attribute[$i]['html'] .= "<textarea style='display:none;' class='ia' id='{$name}' name='{$name}'></textarea>";
				$attribute[$i]['html'] .= "<a onclick='addAlbumItem(\"{$name}\")'  id='btnSaveAll'>添加相册信息</a></td></tr></tfoot></table>";
				unset($data);
				break;
			case 'relation':  //相关信息
				$m = D('Admin/Info');
				$data = $m->getInfoByIDList($value, array('Field'=>'InfoID,InfoTitle,Html,ChannelID,LinkUrl') );
				$attribute[$i]['html'].="<ul class='relationlist' id='relationlist{$name}'>";
				if(!empty($data)){
					foreach ($data as $v){
						$InfoID = $v['InfoID'];
						$InfoUrl = InfoUrl( $InfoID, $v['Html'], $v['LinkUrl'], false, $v['ChannelID'] );
						$InfoTitle = $v['InfoTitle'];
						$attribute[$i]['html'].="<li><a href='{$InfoUrl}' target='_blank'>{$InfoTitle}</a>";
						$attribute[$i]['html'].="<a onclick='delRelationItem(this, \"{$name}\")' class='btnDel'>删除</a>";
						$attribute[$i]['html'].="<input type='hidden' name='{$name}[]' value='$InfoID' /></li>";
					}
				}
				$attribute[$i]['html'].="</ul><a onclick=\"addRelationItem('{$name}')\"  id='btnSaveAll'>添加相关信息</a>";
				break;
			case 'typeselect': //规格属性
				$m = D('Admin/Type');
				$typeInfo= $m->getType();
				if($typeInfo){
					$SelectedValue = $attribute[$i]['SelectedValue'];
					$attribute[$i]['html'] = "<select id='$name' name='$name'    $style  $class  >";
					$attribute[$i]['html'] .= "<option value='0'>==请选择==</option>";
					for($j = 0; $j < count($typeInfo); $j++){
						$value = $typeInfo[$j]['TypeID'];
						$text = $typeInfo[$j]['TypeName'];
						if( isset($attribute[$i]['SelectedValue']) ){ //自定义选中项
							$selected = ( $SelectedValue == $value) ? "selected='selected'" : '';
						}
						$attribute[$i]['html'] .= "<option value='$value'  $selected>$text</option>";
					}
					$attribute[$i]['html'] .= "</select>";
					if( !empty($SelectedValue) ){
						$attribute[$i]['html'] .="<script>$(document).ready(function() { changeInfoType({$SelectedValue}); });</script>";
					}
				}
				break;
			case 'color': //颜色选择
				$attribute[$i]['html'] = "<input type='text' style='color:{$value}; width:80px' class='textinput' name = '$name'  id='$name'  value='$value'  />
				<input type='text' class='textinput' style='width:16px; border:1px solid #ccc; cursor:pointer;background:{$value}' id='{$name}ColorBox' readonly='readonly'/>
				<script>
				$(document).ready(function(){
				    $('#{$name},#{$name}ColorBox').colorpicker({
						fillcolor:false,
						success:function(o,color){
							$('#{$name}').val(color);
							$('#{$name}').css('color',color);
							$('#{$name}ColorBox').css('background',color);
						}
					});
				});
				</script>";
				break;
			case 'coordinate': //地理位置坐标
				if( $name!='Longitude') break;
				$Longitude = $attribute[$i]['Longitude'];
				$Latitude = $attribute[$i]['Latitude'];
				$attribute[$i]['html'] = "经度：<input type='text' style='width:80px;margin-right:6px;' $class name = 'Longitude'  id='Longitude'  value='{$Longitude}'  />
				经度：<input type='text' style='width:80px;margin-right:6px;' $class name = 'Latitude'  id='Latitude'  value='{$Latitude}'  />
				<input type='button' value='从地图上选择...' style='padding:3px 8px; cursor:pointer;' onclick='OpenMap()' />";
				$attribute[$i]['html'] .= "<span id='dlgMap' style='display:none;' title='获取坐标'>
					<div style='margin-bottom:8px;'>
				    	地址：<input type='text' class='textinput' style='width:220px; margin-right:3px; ' id='map_address' value='' />
				        <input type='button' value='搜索' style='padding:2px 7px; cursor:pointer;' onclick='SearchMap()' />
				        <span style='float:right'>
				        	经度：<span id='jd' style='margin-right:15px;'>{$Longitude}</span>
				        	纬度：<span id='wd'>{$Latitude}</span></span>
				    </div><div style='width: 700px; height: 440px;'  id='container'></div>
				</span>";
				$attribute[$i]['html'] .= '<script type="text/javascript" src="//api.map.baidu.com/api?v=3.0&ak=6lsQyoWKsB0l9K9rt6EFLkqjjBY45N87"></script>
				<script>
					var map="";
					$(document).ready(function(){
						map = new BMap.Map("container");
						map.setDefaultCursor("crosshair");
						map.enableScrollWheelZoom(true);
						map.addControl( new BMap.NavigationControl() );
						map.centerAndZoom("北京市", 17);
						
						map.addEventListener("click", function (e) { 
							map.clearOverlays(); 
							var marker = new BMap.Marker(new BMap.Point(e.point.lng, e.point.lat)); 
							map.addOverlay(marker);
							$("#jd").text( e.point.lng );
							$("#wd").text( e.point.lat );
						});
					});
						
					function OpenMap(){
						var jd = $("#Longitude").val();
						var wd = $("#Latitude").val();
						if( jd && wd && jd!=0 && wd !=0){
							var mypoint = new BMap.Point(jd, wd);
							map.centerAndZoom(mypoint, 17);
							map.clearOverlays();
							var marker = new BMap.Marker(mypoint);
							map.addOverlay(marker);
							map.panBy(330, 180);
						}else{
					    	map.centerAndZoom("北京市", 17);
						}
						
						$.dialog({
							title: "坐标选择",  id: "dlgMap",  padding: 5, 
							content: document.getElementById("dlgMap"),
							ok: function () {
							    $("#Longitude").val( $("#jd").text() );
								$("#Latitude").val( $("#wd").text() );
							},
							okValue: "确定",
							cancelValue: "关闭",
							cancel: true
						});
					}
					
					function SearchMap() {
						var local = new BMap.LocalSearch(map, {
							renderOptions: { map: map }
						});
						var address = $("#map_address").val();
						local.search(address);
					}
				</script>';
				break;
			case 'text':  //默认类型
			default:
				$attribute[$i]['html'] = "<input type='text' $style $class name = '$name'  id='$name'  value='$value'  />";
				break;
		}
		$list = array('image','imageex','attachment');
		if( $helpText != '' && !in_array($attribute[$i]['DisplayType'], $list) && empty($attribute[$i]['IsMobile']) ){
			$attribute[$i]['html'] .= "<span class='Caution'>$helpText</span>";
		}
			
	}
	return $attribute;
}