<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */
class YdTemplateConfig{
	private $_fileName = null;
	private $_languageMark = null;
	private $_order = null;  //排序数组
	function __construct($fileName, $languageMark){
		$this->_fileName = $fileName;
		$this->_languageMark = $languageMark;
		unset($this->_order);
	}
	
	//获取分组
	function getGroup(){
		if( !file_exists($this->_fileName) ) return false;
		$xml = simplexml_load_file( $this->_fileName );
		if(empty($xml)) return false;
		$obj = $xml->groups->group;
		$n = count($obj);
		$group = array();
		for($i=0; $i < $n; $i++){
			$group[] = array('DisplayName' => (string)$obj[$i]['name'],'AttributeID' => (string)$obj[$i]['id']);
		}
		if(empty($group)) return false;
		return $group;
	}
	
	//获取模板配置属性
	function getAttribute(){
		if( !file_exists($this->_fileName) ) return false;
		$xml = simplexml_load_file( $this->_fileName );
		if(empty($xml)) return false;
		unset($this->_order); //清空排序数组
		$lang = $this->_languageMark;
		$a1 = $this->_getVar($xml->global->var);
		if(empty($a1)) $a1 = array();
		$a2 = $this->_getVar($xml->$lang->var);
		if(empty($a2)) $a2 = array();
		$attribute = array_merge($a1, $a2);
		//按order进行排序
		array_multisort ($this->_order, SORT_ASC, SORT_NUMERIC, $attribute);
		return $attribute;
	}
	
	//常见模板配置文件
	function create(){
		
	}
	
	//保存配置
	function save($data){
		unset($data['__hash__']);
		if(empty($data)) return false;
		if( !file_exists($this->_fileName) ) $result = false;
		
		//预处理，对checkbox转化为字符串
		foreach ($data as $k=>$v){
			if( is_array($v) ){
				$data[$k] = implode(',', $v);
			}
		}
		$xml = simplexml_load_file( $this->_fileName );
		if(empty($xml)) return false;
		//保存全局参数========================
		$a1 = &$xml->global->var;
		$n = count($a1);
		for($i=0; $i < $n; $i++){
			$key = (string)$a1[$i]['name'];
			if( key_exists($key, $data)){
				$a1[$i]['value'] = $data[$key];
			}
		}
		//==================================
		
		//保存当前语言配置参数====================
		$lang = $this->_languageMark;
		$a2 = &$xml->$lang->var;
		$n = count($a2);
		for($i=0; $i < $n; $i++){
			$key = (string)$a2[$i]['name'];
			if( key_exists($key, $data)){
				$a2[$i]['value'] = $data[$key];
			}
		}
		//=================================
		$result = $xml->asXML($this->_fileName);
		return $result;	
	}
	
	//获取配置数据
	function getData(){
		$data = false;
		$xml = simplexml_load_file( $this->_fileName );
		if(empty($xml)) return false;
		//获取全局参数
		$a1 = &$xml->global->var;
		$n = count($a1);
		for($i=0; $i < $n; $i++){
			$key = (string)$a1[$i]['name'];
			$data[$key] = (string)$a1[$i]['value'];
		}
		
		//获取语言参数
		$lang = $this->_languageMark;
		$a2 = &$xml->$lang->var;
		$n = count($a2);
		for($i=0; $i < $n; $i++){
			$key = (string)$a2[$i]['name'];
			$data[$key] = (string)$a2[$i]['value'];
		}
		return $data;
	}
	
	//判断属性类型是否是可选
	function isSelected($type){
		if( stripos($type, 'checkbox') === false &&
				stripos($type, 'radio' ) === false &&
				stripos($type, 'select' )  === false  ){
			return false;
		}else{
			return true;
		}
	}

	
    private function _getVar($obj){
    	if(empty( $obj )) return false;
    	$Attribute = array();
    	$n = count( $obj );
    	$x=0;
    	for($i=0; $i < $n; $i++){
    			$this->_order[] = isset($obj[$i]['order']) ? (int)$obj[$i]['order'] : 100;
	    		$DisplayValue = (string)$obj[$i]['value'];
	    		$DisplayType = $this->_getDefault('type', '', (string)$obj[$i]['type']);
	    		$DisplayWidth = $this->_getDefault('width', $DisplayType, (string)$obj[$i]['width']);
	    		$DisplayHeight = $this->_getDefault('height', $DisplayType, (string)$obj[$i]['height']);
	    		$DisplayClass = $this->_getDefault('class', $DisplayType, (string)$obj[$i]['class']);
	    		
	    		$Attribute[$i] = array(
	    				'FieldName'=>(string)$obj[$i]['name'],
	    				'DisplayName'=>(string)$obj[$i]['title'],
	    				'DisplayHelpText'=>(string)$obj[$i]['help'].' 配置变量名称：'.(string)$obj[$i]['name'].'',
	    				'DisplayType'=>$DisplayType,
	    				'DisplayWidth'=>$DisplayWidth,
	    				'DisplayHeight'=>$DisplayHeight,
	    				'DisplayClass'=>$DisplayClass,
	    				'GroupID'=>(string)$obj[$i]['groupid'],
	    		);
	    		
	    		$Attribute[$i]['AdminGroupID'] = 1; //模板配置允许获取所有频道
	    		if ( $DisplayType == 'specialselect' || $DisplayType == 'specialselectno'){
	    			$Attribute[$i]['SelectedValue'] = explode(',' , $DisplayValue); //获取频道设置值
	    		}else if($DisplayType == 'channelexselect' || $DisplayType == 'channelexselectno'){ //支持多选
					$Attribute[$i]['SelectedValue'] = explode(',' ,$DisplayValue); //获取频道设置值
				}else if( $this->isSelected( $DisplayType ) ){
	    			$Attribute[$i]['SelectedValue'] = $DisplayValue;
	    			$Attribute[$i]['DisplayValue'] = str_replace('@@@', "\n", (string)$obj[$i]['parameter']);
	    		}else{
	    			$Attribute[$i]['DisplayValue'] = $DisplayValue;
	    		}
    	}
    	import("@.Common.YdParseModel");
    	$Attribute = parsemodel($Attribute);  //解析属性信息
    	return $Attribute;
    }
	
	//获取默认值
	private function _getDefault($key, $type, $value){
		if( !empty($value) ) {
			$data = $value;
		}else{
			$key = strtolower($key);
			switch ($key){
				case 'width': //宽度
					$dafault = array('text'=>'270px','textarea'=>'100%', 'image'=>'100%');
					$data = key_exists($type, $dafault) ? $dafault[$type] : false;
					break;
				case 'height': //高度
					$dafault = array('textarea'=>'100px');
					$data = key_exists($type, $dafault) ? $dafault[$type] : false;
					break;
				case 'class': //样式类
					$dafault = array('text'=>'textinput','textarea'=>'textinput', 'image'=>'textinput');
					$data = key_exists($type, $dafault) ? $dafault[$type] : false;
					break;
				case 'type': //类型
					$data = 'channelselect';
					break;
				default:
					$data = false;
			}
		}
		return $data;
	}
}