<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */
class AuthorizeModel extends Model {
	protected $_validate = array(
			array('Host', '', '域名已经存在!', '0', 'unique'),
	);
	
	function getAuthorizeInfo($offset = -1, $length = -1, $Host='', $IsAuthorize=-1, $AgentID=-1, $OperatorID=-1){
		if( $offset >= 0 && $length > 0){
			$this->limit($offset.','.$length);
		}

		$where = "1=1";
		if( $Host != '' ){
			$where .= " and Host like '%$Host%'";
		}
		
		if( $IsAuthorize != -1 ){
			$where .= " and IsAuthorize= $IsAuthorize";
		}
		
		if( $AgentID != -1 ){
			$where .= " and CustomerID= $AgentID";
		}
		
		if( $OperatorID != -1 ){
			$where .= " and OperatorID= $OperatorID";
		}
		
		$result = $this->where($where)->order('AuthorizeID desc')->select();
		return $result;
	}
	
	/**
	 * 全局检索域名是否授权
	 * @param string $host
	 * @return array
	 */
	function searchAuthorize($host){
		//过滤非法字符
		$host = str_ireplace(array('%',"'",'"'), '', trim($host));
		$prefix = strtolower( substr($host, 0, 4) );
		if( $prefix == 'www.'){
			$where['Host'] = $host;
		}else{
			$where['Host'] = array('in',"{$host},www.{$host}");
		}
		$result = $this->where($where)->select();
		return $result;
	}
	
	//客服获取自己授权的域名
	function getUserAuthorize($offset = -1, $length = -1, $Host='', $CustomerID=-1, $OperatorID=-1){
		if( $offset >= 0 && $length > 0){
			$this->limit($offset.','.$length);
		}
		$where = "1=1";
		if( $Host != '' ){
			$where .= " and Host='$Host'";
		}
		if( $CustomerID != -1 ){
			$where .= " and CustomerID in($CustomerID)";
		}
		if( $OperatorID != -1 ){
			$where .= " and OperatorID = $OperatorID";
		}
		$result = $this->where($where)->order('AuthorizeID desc')->select();
		return $result;
	}
	
	function getUserCount($Host='', $CustomerID=-1, $OperatorID=-1){
		$where = "1=1";
		if( $Host != '' ){
			$where .= " and Host='$Host'";
		}
		if( $CustomerID != -1 ){
			$where .= " and CustomerID in($CustomerID)";
		}
		if( $OperatorID != -1 ){
			$where .= " and OperatorID = $OperatorID";
		}
		$n = $this->where($where)->count();
		return $n;
	}
	
	//客服获取授权域名总数，$CustomerID取值可能有多个：1,2,3
	function GetUserAuthorizeCount($CustomerID){
		$where = " CustomerID in($CustomerID)";
		$n = $this->where($where)->count();
		return $n;
	}
	
	//代理获取自己的授权域名数 代理的MemberID
	function GetAgentAuthorizeCount($MemberID){
		$where = "CustomerID=$MemberID";
		$n = $this->where($where)->count();
		return $n;
	}
	
	//代理获取自己的授权域名
	function getAgentAuthorize($offset = -1, $length = -1, $Host='',  $OperatorID=-1){
		if( $offset >= 0 && $length > 0){
			$this->limit($offset.','.$length);
		}
		$where = "1=1";
		if( $Host != '' ){
			$where .= " and Host='$Host'";
		}
		
		//代理自己操作的和自己名下的都显示
		if( $OperatorID != -1 ){
			$where .= " and (OperatorID=$OperatorID or CustomerID=$OperatorID)";
		}
		$result = $this->where($where)->order('AuthorizeID desc')->select();
		return $result;
	}
	
	function getAgentCount($Host='',  $OperatorID=-1){
		$where = "1=1";
		if( $Host != '' ){
			$where .= " and Host='$Host'";
		}

		if( $OperatorID != -1 ){
			$where .= " and (OperatorID=$OperatorID or CustomerID=$OperatorID)";
		}
		$n = $this->where($where)->count();
		return $n;
	}
	
	//获取域名授权数量
	function GetAuthorizeCount($IsAuthorize=-1, $MemberID=-1){
		if( $IsAuthorize != -1 ){
			$where['IsAuthorize'] = $IsAuthorize;
		}
		if( $MemberID != -1 ){
			$where['CustomerID'] = $MemberID;
		}
		$n = $this->where($where)->count();
		return $n;
	}

	function getCount($Host='', $IsAuthorize=-1, $AgentID=-1, $OperatorID=-1){
		$where = "1=1";
		if( $Host != '' ){
			$where .= " and Host like '%$Host%'";
		}
		
		if( $IsAuthorize != -1 ){
			$where .= " and IsAuthorize= $IsAuthorize";
		}
		
		if( $AgentID != -1 ){
			$where .= " and AgentID= $AgentID";
		}
		
		if( $OperatorID != -1 ){
			$where .= " and OperatorID= $OperatorID";
		}
		
		$n = $this->where($where)->count();
		return $n;
	}
	
	
	function authorize( $id = array() , $OperatorID, $AgentID=-1, $IsAuthorize = 0){
		if( is_array($id)){
			$where = 'AuthorizeID in('.implode(',', $id).')';
		}else{
			$where = "AuthorizeID=$id";
		}
		if( $IsAuthorize != 0 ) $IsAuthorize = 1;
		$data['IsAuthorize'] = $IsAuthorize;
		$data['OperatorID'] = $OperatorID;
		if( $AgentID != -1){
			$data['CustomerID'] = $AgentID;
		}
		$result = $this->where($where)->setField($data);
		if( $result === false ){
			return false;
		}else{
			return true;
		}
	}
	
	//查询域名是否授权
	function getAuthorize($host){
		$host = strtolower(trim($host)); //转化为小写
		if( substr($host, 0, 4) == 'www.' ){ //输入的域名以3w开头
			$nowww = substr($host, 4);
			$www = $host;
		}else{
			$nowww = $host;
			$www = 'www.'.$host;
		}
		
		$where = "IsAuthorize=1 and Host in('$nowww','$www') ";
		$result = $this->where($where)->find();
		if( empty($result) ){
			return false;
		}else{
			return $result;
		}
	}
	
	//获取所有客户列表(包含代理、直接客户、业务合作)
	function getCustomerData($memberID=-1){
		$m = D('Admin/Member');
		$m->table($m->tablePrefix.'member a');
		$m->join($m->tablePrefix.'member_group b On a.MemberGroupID = b.MemberGroupID');
		$where = "a.MemberGroupID > 100";   //客户分组ID大于100的都是客户
		if($memberID != -1){
			$where .= " and a.InviterID=$memberID";
		}
		$m->field('a.MemberID,a.MemberGroupID,a.MemberName,a.MemberRealName,a.MemberEmail,a.MemberMobile,b.MemberGroupName');
		$data = $m->where($where)->select();
		return $data;
	}
	
	//获取所有代理列表
	function getAgentData($memberID=-1){
		$m = D('Admin/Member');
		$m->table($m->tablePrefix.'member a');
		$m->join($m->tablePrefix.'member_group b On a.MemberGroupID = b.MemberGroupID');
		$where = "a.MemberGroupID in(110,111,112,113,114,115)";   //代理客户分组ID
		if($memberID != -1){
			$where .= " and a.InviterID=$memberID";
		}
		$m->field('a.MemberID,a.MemberGroupID,a.MemberName,a.MemberRealName,a.MemberEmail,a.MemberMobile,b.MemberGroupName');
		$data = $m->where($where)->select();
		return $data;
	}
	
	//获取所有操作员（客服）
	function getOperatorData(){
		$m = D('Admin/Member');
		$where['MemberGroupID'] = 100;   //客服分组ID:100
		$m->field('MemberID,MemberName,MemberRealName,MemberEmail,MemberMobile');
		$data = $m->where($where)->select();
		return $data;
	}
	
	//返回所有操作员（客服）的关联数组 MemberID=>MemberName
	function getAssoOperatorData(){
		$m = D('Admin/Member');
		$where['MemberGroupID'] = 100;   //客服分组ID:100
		$data = $m->where($where)->getField('MemberID,MemberRealName');
		return $data;
	}

	//按操作系统统计授权数
	function statNumByOS(){
		$where = "OS!=''";
		$this->field('OS, count(*) as Total');
		$data = $this->where( $where )->group('OS')->order('Total desc')->select();
		if($data){
			$total = 0;
			foreach ($data as $v){
				$total += $v['Total'];
			}
			$n = count($data);
			for($i = 0; $i < $n; $i++){
				$data[$i]['Percent'] = number_format($data[$i]['Total']*100/$total,2);
			}
		}
		return $data;
	}
}