<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved.
 */
class ConfigModel extends Model{
	/**
	 * 保存配置到数据库
	 * @param array $data 配置数据
	 * @param string $configFile 配置文件名(省略扩展名.php)
	 * @param bool $cache 是否缓存到配置文件
	 */
	function saveConfig($data, $cache = true){
		$this->_save($data); //保存到数据库
		if($cache){ //缓存数据
			//必须删除中英配置，下面的writeConfig只重写当前语言的
			YdCache::deleteConfig(); 
			YdCache::writeConfig();
		}
		return true;
	}
	
	/**
	 * 获取配置数据
	 */
	function getConfig($ConfigFile=false){
		$where = '('.get_language_where().' or LanguageID=0)';
		$where .= " and IsEnable = 1 and ConfigFile not in('config','html','home/config','wap/config') ";
		if($ConfigFile){
			$where .= " and ConfigFile = '{$ConfigFile}'";
		}
		$data = $this->where($where)->getField('ConfigName,ConfigValue');
		return $data;
	}
	
	//保存数据库配置信息
	private function _save($data){
		foreach($data as $key=>$val) {
			$config    = Array();
			$config['ConfigValue']  =  $val;
			$where = '('.get_language_where().' or LanguageID=0)';
			$where .=  " and ConfigName='".$key."'";
			$this->where($where)->save($config);
		}
	}
	
	function getDomain(){
		$where = '('.get_language_where().' or LanguageID=0)';
		$where .= " and IsEnable = 1 and ConfigFile='domain'";
		$data = $this->where($where)->getField('ConfigName,ConfigValue');
		return $data;
	}
}