<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved.
 */
class JobModel extends Model{
	protected $_validate = array(
			array('JobName', 'require', '职位名称不能为空!'),
			array('JobName', '', '职位名称已经存在!', '0', 'lang_unique'),
			array('JobOrder', '/^[-]?\d+$/', '排序必须为数字!', '2','regex'),
	);
	
	protected $_auto = array(
			array('LanguageID', 'get_language_id', 1, 'function'),
	);
	
	function getJob($offset = -1, $length = -1, $IsEnable = -1){
		if( $offset >= 0 && $length > 0){
			$this->limit($offset.','.$length);
		}
		$where = get_language_where();
		if( $IsEnable != -1){
			$where .= " and IsEnable=".intval($IsEnable);
		}
		$result = $this->where($where)->order('JobOrder asc, JobID desc')->select();
		return $result;
	}

	function batchDelJob( $id = array() ){
		$id = YdInput::filterCommaNum($id);
		$where['JobID']  = array('in', implode(',', $id));
		$result = $this->where($where)->delete();
		return $result;
	}
	
	//批量排序
	function batchSortJob($JobID=array(), $JobOrder = array() ){
		$n = count($JobID);
		for($i = 0; $i < $n; $i++){
			if( is_numeric($JobOrder[$i]) ){
				$this->where("JobID=$JobID[$i]")->setField('JobOrder', $JobOrder[$i]);
			}
		}
	}
	
	function hasData($JobID){
		$m = D('Admin/Resume');
		$c = $m->getResumeCount( $JobID );
		if( $c > 0){
			return true;
		}else{
			return false;
		}
	}

}
