<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved. 
 */
class LogModel extends Model{
	function getLog($offset = -1, $length = -1, $p=array()){
		if( $offset >= 0 && $length > 0){
			$this->limit($offset.','.$length);
		}
		$where = array();
		if( !empty( $p['UserName'] ) ){
			$where['UserName'] = array('like', "%{$p['UserName']}%");
		}
		if( !empty( $p['LogType'] ) ){
			$where['LogType'] = intval($p['LogType']);
		}
		$result = $this->where($where)->order('LogID desc')->select();
		return $result;
	}
	
	//统计日志总数
	function getLogCount($p=array() ){
		$where = array();
		if( !empty( $p['UserName'] ) ){
			$where['UserName'] = array('like', "%{$p['UserName']}%");
		}
		if( !empty( $p['LogType'] ) ){
			$where['LogType'] = intval($p['LogType']);
		}
		$n = $this->where($where)->count();
		return $n;
	}
	
	//将指定ip的城市
	function setCity($ip, $city){
		$ip = addslashes(stripslashes($ip));
		$where = "UserIP='{$ip}' and ISNULL(UserCity) ";
		$result = $this->where( $where )->setField('UserCity', $city);
		return $result;
	}
	
	/**
	 * 获取当天指定IP地址发送的短信数
	 * @param string $ip
	 */
	function getDaySmsCountByIp($ip){
		$ip = addslashes(stripslashes($ip));
		$where = "LogType=9 and date(LogTime) = curdate()";
		$where .= " and UserIP='{$ip}'";
		$n = $this->where( $where )->count();
		return $n;
	}
	
	/**
	 * 获取当天指定手机号码发送的短信数
	 * @param string $num 
	 */
	function getDaySmsCountByNum($num){
		$num = addslashes(stripslashes($num));
		$where = "LogType=9 and date(LogTime) = curdate()";
		$where .= " and UserAction='{$num}'";
		$n = $this->where( $where )->count();
		return $n;
	}
	
}
