<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved.
 */
class MenuOperationModel extends Model{
	/**
	 * 返回后台当前路径信息
	 * @param string $actionName
	 * @param string $moduleName
	 * @param string $groupName
	 * @return array
	 */
	function getMenuOperationPath($actionName, $moduleName, $groupName){
		//Info模块的路径单独处理
		if($moduleName=='Info'){
			$this->field('a.MenuGroupName, b.MenuTopName');
			$this->table($this->tablePrefix.'menu_group a');
			$this->join($this->tablePrefix.'menu_top b On a.MenuTopID = b.MenuTopID and b.IsEnable=1');
			$where['a.MenuGroupID'] = ($groupName=='Admin') ? 3 : 17;
			$result = $this->where($where)->find();
			if( empty($result) ) return false;
			$list = array( 'add'=>'添加', 'modify'=>'修改' );
			if( !empty($result['MenuTopName'])){
				$data[] = array('Name'=>$result['MenuTopName'] );
			}
			if( !empty($result['MenuGroupName'])){
				$data[] = array('Name'=>$result['MenuGroupName'] );
			}
			$actionName = strtolower($actionName);
			if( array_key_exists($actionName, $list) ){
				$data[] = array('Name'=>$list[ $actionName ] );
			}
			return $data;
		}
		
		//对于会员后台的频道
		if($groupName=='Member' && $moduleName=='Channel'){
			$this->field('a.MenuGroupName, b.MenuTopName');
			$this->table($this->tablePrefix.'menu_group a');
			$this->join($this->tablePrefix.'menu_top b On a.MenuTopID = b.MenuTopID and b.IsEnable=1');
			$where['a.MenuGroupID'] = 17;
			$result = $this->where($where)->find();
			if( empty($result) ) return false;
			if( !empty($result['MenuTopName'])){
				$data[] = array('Name'=>$result['MenuTopName'] );
			}
			if( !empty($result['MenuGroupName'])){
				$data[] = array('Name'=>$result['MenuGroupName'] );
			}
			return $data;
		}
		
		$this->field('a.MenuOperationName, b.MenuName, c.MenuGroupName, d.MenuTopName,a.LogType');
		$this->table($this->tablePrefix.'menu_operation a');
		$this->join($this->tablePrefix.'menu b On a.MenuID = b.MenuID and b.IsEnable=1');
		$this->join($this->tablePrefix.'menu_group c On b.MenuGroupID = c.MenuGroupID and c.IsEnable=1');
		$this->join($this->tablePrefix.'menu_top d On c.MenuTopID = d.MenuTopID and d.IsEnable=1');
		
		$where['d.MenuOwner'] = ($groupName=='Admin') ? 1 : 0;
		$where['a.ModuleName'] = $moduleName;
		$where['a.ActionName'] = strtolower($actionName);
		$where['a.IsEnable'] = 1;
		$result = $this->where($where)->find();
		if( !empty($result) ){
			if( !empty($result['MenuTopName'])){
				$data[] = array('Name'=>$result['MenuTopName'] );
			}
			
			if( !empty($result['MenuGroupName'])){
				$data[] = array('Name'=>$result['MenuGroupName'] );
			}
			
			if( !empty($result['MenuName'])){
				$data[] = array('Name'=>$result['MenuName'] );
			}
			
			//查看类型的不显示为路径
			if( !empty($result['MenuOperationName']) && $result['LogType'] != 9){
				$data[] = array('Name'=>$result['MenuOperationName']);
			}
			return $data;
		}
		return $result;
	}
	
	/**
	 * 返回日志操作的菜单信息
	 * @param string $actionName
	 * @param string $moduleName
	 * @param string $groupName
	 * @return array 
	 */
	function getLog($actionName, $moduleName, $groupName){
		$this->field('a.MenuOperationName,a.LogType, a.ActionName, a.ModuleName, b.MenuName');
		$this->table($this->tablePrefix.'menu_operation a');
		$this->join($this->tablePrefix.'menu b On a.MenuID = b.MenuID and b.IsEnable=1');
		$where['a.ActionName'] = strtolower($actionName);
		$where['a.ModuleName'] = $moduleName;
		$where['a.GroupName'] = $groupName;
		$data = $this->where($where)->find();
		return $data;
	}
	
	/**
	 * 获取当前操作所属的菜单ID
	 * @param string $actionName
	 * @param string $moduleName
	 * @param string $groupName
	 * @return 菜单ID
	 */
	function getMenuID($actionName, $moduleName, $groupName){
		$where['ActionName'] = strtolower($actionName); //统一使用小写
		$where['ModuleName'] = $moduleName;
		$where['GroupName'] = $groupName;
		$id = $this->where($where)->getField('MenuID');
		return $id;
	}
}
