<?php
/**
 * Youdian Content Management System
 * Copyright (C) YoudianSoft Co.,Ltd (http://www.youdiancms.com). All rights reserved.
 */
class ResumeModel extends Model{
	protected $_validate = array(
			array('JobID', 'require', '{%JobNameRequired}'),
	);
	
	protected $_auto = array(
			array('LanguageID', 'get_language_id', 1, 'function'),
	);
	
	function getResume($offset = -1, $length = -1, $GuestID = -1, $JobID=-1){
		$this->field('b.MemberName,c.*,a.*');
		$this->table($this->tablePrefix.'resume a');
		$this->join('Left Join '.$this->tablePrefix.'member b On a.GuestID = b.MemberID');
		$this->join('Left Join '.$this->tablePrefix.'job c On a.JobID = c.JobID');
		if( $offset >= 0 && $length > 0){
			$this->limit($offset.','.$length);	
		}
		$where = get_language_where('a');
		if( $GuestID != -1){
			$GuestID = intval($GuestID);
			$where .= " and a.GuestID=$GuestID";
		}
		
		if( $JobID != -1){
			$JobID = intval($JobID);
			$where .= " and a.JobID=$JobID";
		}

		$result = $this->where($where)->order('a.ResumeID desc')->select();
		return $result;
	}
	
	function findResume($ResumeID){
		$ResumeID = intval($ResumeID);
		$this->field('b.MemberName,c.JobName,a.*');
		$this->table($this->tablePrefix.'resume a');
		$this->join('Left Join '.$this->tablePrefix.'member b On a.GuestID = b.MemberID');
		$this->join('Left Join '.$this->tablePrefix.'job c On a.JobID = c.JobID');
		$where .= " a.ResumeID=$ResumeID";
		$result = $this->where($where)->order('a.ResumeID desc')->find();
		return $result;
	}
	
	/**
	 * 批量删除简历
	 * @param int $id
	 * @param int $GuestID
	 * @return unknown
	 */
	function batchDelResume( $id = array(),  $GuestID = -1){
		$id = YdInput::filterCommaNum($id);
		$where = 'ResumeID in('.implode(',', $id).')';
		if( $GuestID != -1){
			$GuestID = intval($GuestID);
			$where .= " and GuestID=$GuestID";
		}
		$result = $this->where($where)->delete();
		return $result;
	}
	
	function getResumeCount($JobID=-1){
		$where = get_language_where();
		if($JobID != -1){
			$JobID = intval($JobID);
			$where .= " and JobID=$JobID";
		}
		$n = $this->where($where)->count();
		return $n;
	}
}
