<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\ArticleModelDB;
use admin_application\link\ArticleLink;
use admin_application\link\TemplatesLink;

class ArticleModel {

	private static $document_model_list_cache_key;
	private static $document_model_read_cache_key;
	private static $document_model_att_field_cache_key;

	public function __construct() {
		$exclude_method = array('saveArticleModel', 'setArticleModel', 'readArticleModel');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$document_model_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'document_model_';
		self::$document_model_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'document_model_';
		self::$document_model_att_field_cache_key = ESPCMS_CACHE_FIELD_NAME . ESPCMS_DB_PREFIX . 'document_att';
	}

	public static function listArticleModel() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "document_model";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$pagesylte = $_REQUEST['pagesylte'];
			if (espcms_ismatches($pagesylte)) {
				$db_where .= " AND pagesylte=$pagesylte";
			}
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$isbase = $_REQUEST['isbase'];
			if (espcms_ismatches($isbase)) {
				$db_where .= " AND isbase=$isbase";
			}
			$istsn = $_REQUEST['istsn'];
			if (espcms_ismatches($istsn)) {
				$db_where .= " AND istsn=$istsn";
			}
			$isalbum = $_REQUEST['isalbum'];
			if (espcms_ismatches($isalbum)) {
				$db_where .= " AND isalbum=$isalbum";
			}
			$isextid = $_REQUEST['isextid'];
			if (espcms_ismatches($isextid)) {
				$db_where .= " AND isextid=$isextid";
			}
			$isques = $_REQUEST['isques'];
			if (espcms_ismatches($isques)) {
				$db_where .= " AND isques=$isques";
			}
			$issid = $_REQUEST['issid'];
			if (espcms_ismatches($issid)) {
				$db_where .= " AND issid=$issid";
			}
			$isfgid = $_REQUEST['isfgid'];
			if (espcms_ismatches($isfgid)) {
				$db_where .= " AND isfgid=$isfgid";
			}
			$islinkdid = $_REQUEST['islinkdid'];
			if (espcms_ismatches($islinkdid)) {
				$db_where .= " AND islinkdid=$islinkdid";
			}
			$isorder = $_REQUEST['isorder'];
			if (espcms_ismatches($isorder)) {
				$db_where .= " AND isorder=$isorder";
			}
			$ismessage = $_REQUEST['ismessage'];
			if (espcms_ismatches($ismessage)) {
				$db_where .= " AND ismessage=$ismessage";
			}
			$ispurview = $_REQUEST['ispurview'];
			if (espcms_ismatches($ispurview)) {
				$db_where .= " AND ispurview=$ispurview";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('mid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "mid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = ArticleLink::ArticleModel_link_array('edit', $fetch_row);
				$fetch_row['attrlist'] = ArticleLink::ArticleModelFields_link_array('index', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'article/model_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', ArticleLink::ArticleModel_link_array(false, $_REQUEST));
			$templates = 'article/model_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addArticleModel() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('link', ArticleLink::ArticleModel_link_array());
		$espcms_admin_templates->into('paylist', ESPCMS_Core::get_order_pay_list());
		$espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/model_add');
	}

	public static function editArticleModel() {
		global $espcms_admin_templates;
		$mid = $_GET['mid'];
		if (!$mid || !espcms_ismatches($mid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($mid));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model";
		$db_where = " WHERE mid=$mid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('paylist', ESPCMS_Core::get_order_pay_list($read['opid']));
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', ArticleLink::ArticleModel_link_array());
		$espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/model_edit');
	}

	public static function readArticleModel() {
		$mid = $_GET['mid'];
		if (!$mid || !espcms_ismatches($mid)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mid));
		}
		$read = ArticleModelDB::get_mid_view($mid);
		if (!$read) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_read_fail', 'false', array($mid));
		}
		$json_read = json_encode($read);
		exit($json_read);
	}

	public static function saveArticleModel() {
		global $espcms_db_cache;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "document_model";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!espcms_ismatches($_POST['pagemax']) || empty($_POST['pagemax']) || empty($_POST['modelname']) || !espcms_ismatches($_POST['pagesylte']) ||
			!espcms_ismatches($_POST['isbase']) || !espcms_ismatches($_POST['istsn']) || !espcms_ismatches($_POST['isalbum']) ||
			!espcms_ismatches($_POST['isextid']) || !espcms_ismatches($_POST['issid']) || !espcms_ismatches($_POST['isfgid']) ||
			!espcms_ismatches($_POST['islinkdid']) || !espcms_ismatches($_POST['isorder']) || !espcms_ismatches($_POST['isques'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addArticleModel')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['addtime'] = time();
			$_POST['lockin'] = 1;
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$document_model_list_cache_key, true);
			espcms_log_install('article_pack-espcms_article_model_button_add', $_POST['modelname']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_model_add_save_ok_message', 'true', array($_POST['modelname']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editArticleModel')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$mid = $_POST['mid'];
			if (empty($mid) || !espcms_ismatches($mid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mid));
			}
			$db_where = "WHERE mid=$mid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($mid));
			}
			$_POST['lockin'] = $read['lockin'];
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$document_model_read_cache_key . $mid);
			$espcms_db_cache->cacheDEL(self::$document_model_list_cache_key, true);
			espcms_log_install('article_pack-espcms_article_model_button_edit', $_POST['modelname']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_model_edit_save_ok_message', 'true', array($_POST['modelname']));
		}
	}

	public static function setArticleModel() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticleModel')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE mid=$value", "$field='$field_value'");
			if ($update_key) {
				$espcms_db_cache->cacheDEL(self::$document_model_read_cache_key . $value);
			}
		}
		$espcms_db_cache->cacheDEL(self::$document_model_list_cache_key, true);
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('article_pack-espcms_article_model_button_set', "$field=$field_value" . " mid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'article_pack-espcms_article_model_set_message', 'true', array($field));
	}

	public static function delArticleModel() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delArticleModelDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$document_model_list_cache_key, true);
		$espcms_db_cache->cacheDEL(self::$document_model_att_field_cache_key, true);
		espcms_log_install('article_pack-espcms_article_model_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_model_del_message', 'true', array(), 'json', $return);
	}

	public static function delArticleModelDB($mid = 0) {
		global $espcms_link_db, $espcms_db_cache;
		if (!$mid || !espcms_ismatches($mid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $mid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model";
		$db_table_document_model_att = ESPCMS_DB_PREFIX . "document_model_att";
		$db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE mid=$mid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $mid);
			return $return_array;
		}
		if (!$read['lockin']) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $mid);
			return $return_array;
		}
		$db_where_attr = " AND mid=$mid AND issys=0 AND lockin=0";
		$talbe_field_array_attr = espcms_field_out($db_table_document_model_att);
		$attr_array = espcms_db_list_array($db_table_document_model_att, $talbe_field_array_attr, $db_where_attr, 'aid DESC');
		if (is_array($attr_array)) {
			foreach ($attr_array as $key => $value) {
				$attr_num_where = " AND attrname='$value[attrname]'";
				$attr_num = espcms_db_num($db_table_document_model_att, $attr_num_where, 'aid');
				if ($attr_num == 1) {
					$espcms_link_db->db_query('ALTER TABLE ' . $db_table_document_attr . ' DROP COLUMN ' . $value['attrname']);
				}
			}
		}
		espcms_db_delall($db_table_document_model_att, "mid=$mid");
		$del_query = espcms_db_del($db_table, 'mid', $mid);
		if ($del_query) {
			$espcms_db_cache->cacheDEL(self::$document_model_read_cache_key . $mid);
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $mid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $mid);
			return $return_array;
		}
	}

}
