<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

use application\ESPCMS_AdminAuthority;
use admin_application\ArticleModelDB;
use application\ESPCMS_PublicDB;
use admin_application\link\ArticleLink;

class ArticleModelFields {

	private static $document_model_att_list_cache_key;
	private static $document_model_att_read_cache_key;
	private static $document_model_att_field_cache_key;

	public function __construct() {
		$exclude_method = array('saveArticleModelFields', 'setArticleModelFields', 'getArticleModelFieldsDefaultAttr', 'sortArticleModelFields', 'verifyArticleModelFields');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$document_model_att_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'document_model_att_';
		self::$document_model_att_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'document_model_att_';
		self::$document_model_att_field_cache_key = ESPCMS_CACHE_FIELD_NAME . ESPCMS_DB_PREFIX . 'document_att';
	}

	public static function listArticleModelFields() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$mid = $_GET['mid'];
		if (empty($mid) || !espcms_ismatches($mid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($mid));
		}
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$db_sql = "SELECT * FROM (SELECT * FROM $db_table WHERE mid IN(0,$mid) ORDER BY aid DESC) AS MODELATTR GROUP BY attrname ORDER BY pid,aid";
			$db_query = $espcms_link_db->db_query($db_sql);
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				if ($fetch_row['isdel']) {
					continue;
				}
				$fetch_row['mid'] = $fetch_row['mid'] ? $fetch_row['mid'] : $mid;
				$fetch_row['edit'] = ArticleLink::ArticleModelFields_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'article/model_attr_list';
		} else {
			$espcms_admin_templates->into('link', ArticleLink::ArticleModelFields_link_array(false, $_REQUEST));
			$templates = 'article/model_attr_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addArticleModelFields() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$mid = $_GET['mid'];
		if (empty($mid) || !espcms_ismatches($mid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($mid));
		}
		$espcms_admin_templates->into('model_read', ArticleModelDB::get_mid_view($mid));
		$espcms_admin_templates->into('default_attr_list', ArticleModelDB::get_default_attr_list($mid));
		$espcms_admin_templates->into('form_list', ESPCMS_PublicDB::get_formType());
		$espcms_admin_templates->into('validate_list', ESPCMS_PublicDB::get_validatetype());
		$espcms_admin_templates->into('link', ArticleLink::ArticleModelFields_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/model_attr_add');
	}

	public static function editArticleModelFields() {
		global $espcms_admin_templates;
		$mid = $_GET['mid'];
		if (!$mid || !espcms_ismatches($mid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($mid));
		}
		$aid = $_GET['aid'];
		if (!$aid || !espcms_ismatches($aid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($aid));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$db_where = " WHERE aid=$aid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$mid = $read['mid'] ? $read['mid'] : $mid;
		$read['formtypename'] = espcms_find_array_key(ESPCMS_PublicDB::get_formType(), $read['inputtype'], 'key', 'name');
		$espcms_admin_templates->into('model_read', ArticleModelDB::get_mid_view($mid));
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('validate_list', ESPCMS_PublicDB::get_validatetype());
		$espcms_admin_templates->into('link', ArticleLink::ArticleModelFields_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/model_attr_edit');
	}

	public static function saveArticleModelFields() {
		global $espcms_link_db, $espcms_db_cache;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$addtype = $_POST['addtype'] && espcms_ismatches($_POST['addtype']) ? $_POST['addtype'] : 1;
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (empty($_POST['mid']) || !espcms_ismatches($_POST['mid'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['mid']));
		}
		if (!espcms_ismatches($_POST['attrrow']) || empty($_POST['attrrow']) || !espcms_ismatches($_POST['isvalidate']) || !espcms_ismatches($_POST['issearch'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add' && $addtype == 1) {
			if (!ESPCMS_AdminAuthority::authorityVerify('addArticleModelFields')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			if (!$_POST['attrname'] || !preg_match('/^[a-z_]{2,50}$/', $_POST['attrname'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['attrname']));
			}
			$attr_read = ArticleModelDB::get_mid_attr_view($_POST['mid'], $_POST['attrname']);
			if ($attr_read) {
				espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_model_attr_add_save_err', 'false', array($_POST['attrname']));
			}
			$key = espcms_find_array_key(ESPCMS_PublicDB::get_formType(), $_POST['inputtype'], 'key');
			$attrarray = ESPCMS_PublicDB::get_formType($key);
			if (!$attrarray) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['inputtype']));
			}
			if ($attrarray['alter'] != 'TEXT') {
				$alter = $attrarray['alter'] == 'INT' || $attrarray['alter'] == 'FLOAT' ? $attrarray['alter'] . '(' . $attrarray['varlong'] . ') DEFAULT \'0\'' : $attrarray['alter'] . '(' . $attrarray['varlong'] . ')';
			} else {
				$alter = $attrarray['alter'];
			}
			if (self::verifyArticleModelFieldsDB('attrname', $_POST['attrname'])) {
				espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_model_attr_add_save_err', 'false', array($_POST['attrname']));
			}
			$db_where_num = " AND attrname='$_POST[attrname]'";
			$countnum = espcms_db_num($db_table, $db_where_num, 'aid');
			if (!$countnum) {
				$db_query = $espcms_link_db->db_query('ALTER TABLE ' . $db_table_document_attr . ' ADD COLUMN ' . $_POST['attrname'] . ' ' . $alter . ' NOT NULL');
				if (!$db_query) {
					espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_model_attr_add_save_err2', 'false', array($_POST['attrname']));
				}
			}
			$_POST['attrlenther'] = $attrarray['varlong'];
			$_POST['lockin'] = 0;
			$_POST['islockin'] = 1;
			$_POST['issys'] = 0;
			$_POST['isdel'] = 0;
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$document_model_att_list_cache_key . $_POST['mid'], true);
			$espcms_db_cache->cacheDEL(self::$document_model_att_field_cache_key, true);
			espcms_log_install('article_pack-espcms_article_model_attr_button_add', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_model_attr_add_save_ok_message', 'true', array($_POST['typename']));
		} elseif ($saveType == 'add' && $addtype == 2) {
			if (!ESPCMS_AdminAuthority::authorityVerify('addArticleModelFields')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			if (!espcms_ismatches($_POST['default_attr']) || empty($_POST['default_attr'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			$db_where = "WHERE mid=$_POST[mid] AND aid=$_POST[default_attr]";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['default_attr']));
			}
			$read['isdel'] = 0;
			$read['isclass'] = 1;
			$read['typename'] = $_POST['typename'];
			$read['typeremark'] = $_POST['typeremark'];
			$read['attrvalue'] = $_POST['attrvalue'];
			$read['attrrow'] = $_POST['attrrow'];
			$read['isvalidate'] = $_POST['isvalidate'];
			$read['validatetext'] = $_POST['validatetext'];
			$read['issearch'] = $_POST['issearch'];
			$postvalue = espcms_post($read, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$install_id = espcms_db_update_save($db_table, $db_where, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$document_model_att_list_cache_key . $_POST['mid'], true);
			$espcms_db_cache->cacheDEL(self::$document_model_att_field_cache_key, true);
			espcms_log_install('article_pack-espcms_article_model_attr_button_add', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_model_attr_add_save_ok_message', 'true', array($_POST['typename']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editArticleModelFields')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$aid = $_POST['aid'];
			if (empty($aid) || !espcms_ismatches($aid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($aid));
			}
			$mid = $_POST['mid'];
			$db_where = "WHERE aid=$aid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($aid));
			}
			if ($read['lockin'] && !$read['islockin'] && !$read['issys'] && !$read['mid']) {
				$read['typename'] = $_POST['typename'];
				$read['typeremark'] = $_POST['typeremark'];
				$read['attrvalue'] = $_POST['attrvalue'];
				$read['attrrow'] = $_POST['attrrow'];
				$read['mid'] = $mid;
				$read['issys'] = $aid;
				$read['iscover'] = 1;
				$read['isdel'] = 0;
				$read['isvalidate'] = $_POST['isvalidate'];
				$read['issearch'] = $_POST['issearch'];
				$read['validatetext'] = $_POST['validatetext'];
				$postvalue = espcms_post($read, $talbe_field_array, true);
				if (!$postvalue) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
				$update_id = espcms_db_install_save($db_table, $postvalue);
				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				$postvalue = espcms_post($_POST, $talbe_field_array, true);
				if ($postvalue && is_array($postvalue)) {
					$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
					if (!$update_id) {
						espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
					}
				} else {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			}
			$espcms_db_cache->cacheDEL(self::$document_model_att_list_cache_key . $read['mid'], true);
			$espcms_db_cache->cacheDEL(self::$document_model_att_field_cache_key, true);
			espcms_log_install('article_pack-espcms_article_model_attr_button_edit', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_model_attr_edit_save_ok_message', 'true', array($_POST['typename']));
		}
	}

	public static function setArticleModelFields() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticleModelFields')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$mid = $_GET['mid'];
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			self::setArticleModelFieldsDB($field, $field_value, $mid, $value);
		}
		$set_info_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$document_model_att_list_cache_key . $mid, true);
		$espcms_db_cache->cacheDEL(self::$document_model_att_field_cache_key, true);
		espcms_log_install('article_pack-espcms_article_model_button_set', "$field=$field_value" . " mid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'article_pack-espcms_article_model_set_message', 'true', array($field));
	}

	private static function setArticleModelFieldsDB($field, $field_value, $mid, $value) {
		if (!$mid || !espcms_ismatches($mid) || !$value || !espcms_ismatches($value)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$talbe_field_array = espcms_field_out($db_table, false);
		$db_where = " WHERE aid=$value";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if ($read['lockin'] && !$read['islockin'] && !$read['issys'] && !$read['mid']) {
			$attr_read = ArticleModelDB::get_mid_attr_view($mid, $read['attrname']);
			if (!$attr_read) {
				$read[$field] = $field_value;
				$update_key = ArticleModelDB::install_attr($mid, $read, 0);
			}
		} else {
			$update_key = espcms_db_update_set_save($db_table, "WHERE aid=$value AND mid=$mid", "$field='$field_value'");
		}
		return $update_key;
	}

	public static function delArticleModelFields() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		$mid = $_GET['mid'];
		if (!$mid || !espcms_ismatches($mid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($mid));
		}
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delArticleModelFieldsDB($value, $mid);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('article_pack-espcms_article_model_attr_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		$espcms_db_cache->cacheDEL(self::$document_model_att_list_cache_key, true);
		$espcms_db_cache->cacheDEL(self::$document_model_att_field_cache_key, true);
		espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_model_attr_del_message', 'true', array(), 'json', $return);
	}

	private static function delArticleModelFieldsDB($aid, $mid) {
		global $espcms_link_db;
		if (!$mid || !espcms_ismatches($mid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $mid);
			return $return_array;
		}
		if (!$aid || !espcms_ismatches($aid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $aid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
		$talbe_field_array = espcms_field_out($db_table, false);
		$db_where = " WHERE aid=$aid AND (mid=$mid OR mid=0)";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $aid);
			return $return_array;
		}
		if ($read['lockin'] && !$read['islockin'] && !$read['issys'] && !$read['mid']) {
			$attr_read = ArticleModelDB::get_mid_attr_view($mid, $read['attrname']);
			if (!$attr_read) {
				$del_query = ArticleModelDB::install_attr($mid, $read);
			}
		} elseif ($read['lockin'] && $read['issys'] && $read['mid']) {
			$del_query = espcms_db_update_set_save($db_table, "WHERE aid=$aid AND mid=$mid", "isdel=1");
		} else {
			$db_where_attr = " AND attrname='$read[attrname]'";
			$attr_num = espcms_db_num($db_table, $db_where_attr, 'aid');
			$del_query = espcms_db_delall($db_table, "aid=$aid AND mid=$mid AND islockin=1");
			if ($attr_num == 1 && $del_query) {
				$del_query = $espcms_link_db->db_query('ALTER TABLE ' . $db_table_document_attr . ' DROP COLUMN ' . $read['attrname']);
			}
		}
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $mid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $mid);
			return $return_array;
		}
	}

	public static function verifyArticleModelFields() {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$mid = $_REQUEST['mid'];
		if (empty($mid) || !espcms_ismatches($mid)) {
			exit(1);
		}
		$aid = intval($_REQUEST['aid']);
		$db_num = self::verifyArticleModelFieldsDB($verifyKey, $verifyValue, $aid, $verifyType) ? '1' : '0';
		exit($db_num);
	}

	private static function verifyArticleModelFieldsDB($verifyKey, $verifyValue, $aid = 0, $verifyType = false) {
		$field_array = array('attrname');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			return true;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$db_table_document = ESPCMS_DB_PREFIX . "document";
		$db_table_document_content = ESPCMS_DB_PREFIX . "document_content";
		$talbe_field_array = espcms_field_out($db_table_document);
		$talbe_field_array_document_content = espcms_field_out($db_table_document_content);
		$document_attr_array = espcms_array_onedim($talbe_field_array, 'Field');
		$document_content_attr_array = espcms_array_onedim($talbe_field_array_document_content, 'Field');
		if (in_array($verifyValue, $document_attr_array) || in_array($verifyValue, $document_content_attr_array) || $verifyValue == 'datid') {
			return true;
		}
		if (empty($aid) || !espcms_ismatches($aid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND aid!=$aid" : " AND $verifyKey='$verifyValue' AND aid!=$aid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		return $db_num > 0 ? true : false;
	}

	public static function getArticleModelFieldsDefaultAttr() {
		$aid = $_POST['aid'];
		if (!$aid || !espcms_ismatches($aid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($aid));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$talbe_field_array = espcms_field_out($db_table, false);
		$db_where = " WHERE aid=$aid ";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($aid));
		}
		exit(json_encode($read));
	}

	public static function sortArticleModelFields() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticleModelFields')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$mid = $_GET['mid'];
		if (empty($_POST['id_array'])) {
			exit('false');
		}
		$aid_array = $_POST['id_array'];
		if (!is_array($aid_array) || count($aid_array) <= 0) {
			exit('false');
		}
		foreach ($aid_array as $key => $value) {
			$pid = $key;
			if (espcms_ismatches($pid) && espcms_ismatches($value)) {
				self::sortArticleModelFieldsDB($mid, $value, $pid);
			}
		}
		$espcms_db_cache->cacheDEL(self::$document_model_att_list_cache_key . $mid, true);
		espcms_log_install('article_pack-espcms_article_model_attr_button_sort', 'mid=' . $mid);
		exit('true');
	}

	private static function sortArticleModelFieldsDB($mid = 0, $aid = 0, $pid = 0) {
		if (!$mid || !espcms_ismatches($mid) || !$aid || !espcms_ismatches($aid) || !espcms_ismatches($pid)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$talbe_field_array = espcms_field_out($db_table, false);
		$db_where = " WHERE aid=$aid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if ($read['lockin'] && !$read['islockin'] && !$read['issys'] && !$read['mid']) {
			$read['pid'] = $pid;
			$update_key = ArticleModelDB::install_attr($mid, $read, 0);
		} else {
			$update_key = espcms_db_update_set_save($db_table, "WHERE aid=$aid AND mid=$mid", "pid=$pid");
		}
		return $update_key;
	}

}
