<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleTypeDB;
use admin_application\AdminPublicDB;
use admin_application\link\CreateMainLink;
use application\ESPCMS_FileTool;
use inc_application\link\ArticleLink;

class CreateBaiduMap {

	public function __construct() {
		$exclude_method = array('saveCreateBaiduMap');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function indexBase() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$lng = AdminPublicDB::get_lancode();
		$lng_array = ESPCMS_Core::get_lan_list($lng, false);
		$espcms_admin_templates->into('lng_array', $lng_array);
		$sitemap_path = ESPCMS_URL . 'sitemap/bssitemap_';
		$espcms_admin_templates->into('sitemap_path', $sitemap_path);
		$espcms_admin_templates->into('link', CreateMainLink::CreateBaiduMap_link_array());
		$espcms_admin_templates->output('create/create_baidu_map');
	}

	public static function saveCreateBaiduMap() {
		global $espcms_link_db, $espcms_command;
		if (!$_POST['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['lng'])) {
			return false;
		}
		$lng = $_POST['lng'] == 'big5' ? 'cn' : $_POST['lng'];

		define("ESPCMS_CREAT", $_POST['lng']);
		$sitemap_file = ESPCMS_FILE_ROOT . 'sitemap/bssitemap_' . $_POST['lng'] . '.xml';
		$file_dir = dirname($sitemap_file);
		if (!is_dir($file_dir)) {
			if (!@mkdir($file_dir, 0777, true)) {
				return false;
			}
		}
		$xmlfile = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
		$xmlfile .= '<urlset>' . "\n";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$db_where = " AND isclass=1 AND isbase=0 AND lng='$lng'";
		$limit = espcms_ismatches($_POST['create_linknum']) && $_POST['create_linknum'] ? $_POST['create_linknum'] : 500;
		$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, 'did', 'DESC', 0, $limit));
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['tid']);
			$fetch_row['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $fetch_row['ishtml'];
			$link = $espcms_command['HTTP_PATHTYPE'] ? espcms_host('URL') . ArticleLink::doc_link($fetch_row) : ArticleLink::doc_link($fetch_row);
			$title = $fetch_row['title'];
			$addtime = espcms_timeformat($fetch_row['addtime'], 3);
			$xmlfile .= "\x20\x20\x20\x20<url>\n";
			$xmlfile .= "\x20\x20\x20\x20\x20\x20\x20\x20<loc><![CDATA[$link]]></loc>\n";
			$xmlfile .= "\x20\x20\x20\x20\x20\x20\x20\x20<title>$title</title>\n";
			$xmlfile .= "\x20\x20\x20\x20\x20\x20\x20\x20<lastmod>$addtime</lastmod>\n";
			$xmlfile .= "\x20\x20\x20\x20\x20\x20\x20\x20<changefreq>always</changefreq>\n";
			$xmlfile .= "\x20\x20\x20\x20\x20\x20\x20\x20<priority>0.1</priority>\n";
			$xmlfile .= "\x20\x20\x20\x20</url>\n";
		}
		$xmlfile .= '</urlset>';
		$creat_result = ESPCMS_FileTool::writeFile($sitemap_file, $xmlfile);
		if (!$creat_result) {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_baidumap_save_no_message', 'false');
		} else {
			espcms_public_dialog('espcms_info_save_ok', 'create_pack-espcms_create_baidumap_save_ok_message', 'true', array($_POST['lng']));
		}
	}

}
