<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\link\OrderLink;
use admin_application\link\SettingLink;

class Express {

	private static $order_shipping_list_cache_key;
	private static $order_shipping_read_cache_key;

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveExpress', 'setExpress', 'sortExpress');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		if (!ESPCMS_AdminAuthority::authorityVerify('editSetting')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		if (!$order_app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$order_shipping_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'order_shipping';
		self::$order_shipping_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'order_shipping_';
	}

	public static function listExpress() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "order_shipping";
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('osid', 'pid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "osid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = OrderLink::Express_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'order/express_list';
		} else {
			$espcms_admin_templates->into('link', OrderLink::Express_link_array(false, $_REQUEST));
			$templates = 'order/express_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addExpress() {
		global $espcms_admin_templates;
		$espcms_admin_templates->into('link', OrderLink::Express_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('order/express_add');
	}

	public static function editExpress() {
		global $espcms_admin_templates;
		$osid = $_GET['osid'];
		if (!$osid || !espcms_ismatches($osid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($osid));
		}
		$db_table = ESPCMS_DB_PREFIX . "order_shipping";
		$db_where = " WHERE osid=$osid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('link', OrderLink::Express_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('order/express_edit');
	}

	public static function saveExpress() {
		global $espcms_db_cache;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "order_shipping";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (($_POST['price'] && !espcms_ismoney($_POST['price'])) || ($_POST['markup'] && !espcms_ismoney($_POST['markup'])) || !$_POST['shippingname']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		unset($_POST['isclass'], $_POST['pid']);
		if ($saveType == 'add') {
			$_POST['pid'] = 0;
			$_POST['isclass'] = 1;
			$_POST['addtime'] = time();
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$order_shipping_list_cache_key, true);
			espcms_log_install('order_pack-espcms_order_express_button_add', $_POST['shippingname']);
			espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_express_add_save_ok_message', 'true', array($_POST['shippingname']));
		} elseif ($saveType == 'edit') {
			$osid = $_POST['osid'];
			if (empty($osid) || !espcms_ismatches($osid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($osid));
			}
			$db_where = "WHERE osid=$osid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($osid));
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$order_shipping_read_cache_key . $osid);
			$espcms_db_cache->cacheDEL(self::$order_shipping_list_cache_key, true);
			espcms_log_install('order_pack-espcms_order_express_button_edit', $_POST['shippingname']);
			espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_express_edit_save_ok_message', 'true', array($_POST['shippingname']));
		}
	}

	public static function setExpress() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "order_shipping";
		$talbe_field_array = array('isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE osid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
				$espcms_db_cache->cacheDEL(self::$order_shipping_read_cache_key . $value);
			}
		}
		$set_info_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$order_shipping_list_cache_key, true);
		espcms_log_install('order_pack-espcms_order_express_button_set', "$field=$field_value" . " osid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'order_pack-espcms_order_express_set_message', 'true', array($field));
	}

	public static function delExpress() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delExpressDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('order_pack-espcms_order_express_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		$espcms_db_cache->cacheDEL(self::$order_shipping_list_cache_key, true);
		espcms_public_dialog('espcms_public_dialog', 'order_pack-espcms_order_express_del_message', 'true', array(), 'json', $return);
	}

	private static function delExpressDB($osid = 0) {
		global $espcms_db_cache;
		if (!$osid || !espcms_ismatches($osid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $osid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "order_shipping";
		$del_query = espcms_db_del($db_table, 'osid', $osid);
		if ($del_query) {
			$espcms_db_cache->cacheDEL(self::$order_shipping_read_cache_key . $osid);
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $osid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $osid);
			return $return_array;
		}
	}

	public static function sortExpress() {
		global $espcms_db_cache;
		$aid_array = $_POST['id_array'];
		if (!is_array($aid_array) || count($aid_array) <= 0) {
			exit('false');
		}
		$db_table = ESPCMS_DB_PREFIX . "order_shipping";
		foreach ($aid_array as $key => $value) {
			$pid = $key;
			if (espcms_ismatches($pid) && espcms_ismatches($value) && $value) {
				espcms_db_update_set_save($db_table, "WHERE osid=$value", "pid=$pid");
			}
		}
		$espcms_db_cache->cacheDEL(self::$order_shipping_list_cache_key, true);
		espcms_log_install('order_pack-espcms_order_express_button_sort', 'osid=' . $value);
		exit('true');
	}

}
