<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\DBSql;
use admin_application\AdminPublicDB;
use admin_application\link\MenuLink;
use admin_application\link\UserMainLink;
use admin_application\link\SettingLink;

class MainCenter {

	public function __construct() {
		$exclude_method = array('MainCenter', 'MainPage', 'ViewService', 'SiteState');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method, true);
	}

	public static function MainPage() {
		global $espcms_admin_templates;
		$app = espcms_get_app();
		if (!espcms_isact($app)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($app));
		}
		$modul_app = explode('/', $app);
		$modul_app_read = AdminPublicDB::get_menu_app_view($modul_app);
		if (!$modul_app_read) {
			espcms_message_err('public_pack-espcms_method_class_err', array($app));
		}
		$self_query = $url_slef_key = $_SERVER['QUERY_STRING'];
		if ($self_query) {
			$self_query_array = explode('&', $self_query);
			$url_key = array();
			if (is_array($self_query_array)) {
				foreach ($self_query_array as $value) {
					$url_key_value = explode('=', $value);
					$url_key[$url_key_value[0]] = $url_key_value[1];
				}
			}
			unset($url_key['act'], $url_key['app']);
		}
		$tablink = MenuLink::getLink('tablink', $modul_app);
		$modul_app_read['tablink'] = is_array($url_key) && count($url_key) > 0 ? espcms_combine_url($tablink, $url_key, '&') : $tablink;
		$modul_app_read['tab_name'] = $modul_app_read['menu_title'] ? $modul_app_read['menu_title'] : $modul_app_read['menu_name'];
		$espcms_admin_templates->into('appmodul_read', $modul_app_read);
		$espcms_admin_templates->into('url_app', $app);
		$espcms_admin_templates->into('tab_link', $_GET['tab_link']);
		$espcms_admin_templates->into('tab_name', $_GET['tab_name']);
		$espcms_admin_templates->into('tab_icon', $_GET['tab_icon']);
		$espcms_admin_templates->into('tab_close', $_GET['tab_close']);
		$espcms_admin_templates->into('loginlink', UserMainLink::getLink('login'));
		$espcms_admin_templates->into('link', SettingLink::join_link_array());
		$espcms_admin_templates->output('admin/main_page');
	}

	public static function ViewService() {
		global $espcms_command;
		ESPCMS_Core::connect_service('Join', array(), false);
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			exit();
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			exit();
		}
		$read['power_groups_name'] = AdminPublicDB::get_power_groups_view($read['power_groups_id'], 'power_groups_name');
		$updatesoft = UserMainLink::get_user_link_array('UpgradeSoft');
		$lng_speech[] = espcms_get_timemessage();
		$lng_speech[] = $read['admin_username'];
		$lng_speech[] = $read['power_groups_name'];
		$lng_speech[] = $espcms_command['CON_VOLSTR'];
		$message = vsprintf(espcms_lan_pack('setting_pack-espcms_center_login'), $lng_speech);
		$espcms_status = ESPCMS_Core::connect_service('UpdateSoftStatus');
		if (is_array($espcms_status) && $espcms_status['vol']) {
			$up_str = '5b2T5YmN57O757uf5pyJ5paw54mI5pys77yM6K+35Y2H57qn77yB';
			$message .= '<a title="' . espcms_lan_pack('botton_pack-espcms_botton_upgrade') . '" class="info_update espcms_dialog_link" data-w="700px" data-h="450px" data-url="' . $updatesoft . '" data-title="' . espcms_lan_pack('botton_pack-espcms_botton_upgrade') . '">' . base64_decode($up_str) . '</a>';
		}
		$ver_status = ESPCMS_Core::connect_service('LicenceVerify');
		if (is_array($ver_status) && $ver_status['softkey']) {
			ESPCMS_Core::update_ver($ver_status);
		}
		$out['message'] = $message;
		$out['uid'] = 1;
		exit(json_encode($out));
	}

	public static function SiteState() {
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			exit();
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			exit();
		}
		$site_state = ESPCMS_Core::connect_service('StopSite');
		if (is_array($site_state)) {
			if ($site_state['isdel']) {
				if (DBSql::sqlBak()) {
					ESPCMS_Core::update_site_db();
				}
			}
		} else {
			$site_state['uid'] = 0;
		}
		$site_json = json_encode($site_state);
		exit($site_json);
	}

	public static function PusMessage() {
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			exit();
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			exit();
		}
		$site_read = ESPCMS_Core::connect_service('PushBann');
		$site_json = json_encode($site_read);
		exit($site_json);
	}

}
