<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use application\ESPCMS_PublicDB;
use admin_application\MemberFieldDB;
use admin_application\link\MemberLink;

class MemberField {

	private static $member_attr_list_cache_key;
	private static $member_value_field_cache_key;
	private static $lng;

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveMemberField', 'sortMemberField', 'setMemberField', 'verifyMemberField');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$lng = AdminPublicDB::get_lancode();
		self::$member_attr_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'member_attr_' . self::$lng;
		self::$member_value_field_cache_key = ESPCMS_CACHE_FIELD_NAME . ESPCMS_DB_PREFIX . 'member_value';
	}

	public static function listMemberField() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$out_type = $_REQUEST['out_type'];
		$lng = self::$lng;
		$db_where = "WHERE lng='$lng'";
		if ($out_type == 'list') {
			$db_sql = "SELECT * FROM $db_table $db_where ORDER BY pid";
			$db_query = $espcms_link_db->db_query($db_sql);
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				if ($fetch_row['isdel']) {
					continue;
				}
				$fetch_row['edit'] = MemberLink::MemberField_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'member/member_attr_list';
		} else {
			$espcms_admin_templates->into('link', MemberLink::MemberField_link_array());
			$templates = 'member/member_attr_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addMemberField() {
		global $espcms_admin_templates;
		$espcms_admin_templates->into('form_list', ESPCMS_PublicDB::get_member_formType());
		$espcms_admin_templates->into('validate_list', ESPCMS_PublicDB::get_validatetype());
		$espcms_admin_templates->into('link', MemberLink::MemberField_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('member/member_attr_add');
	}

	public static function editMemberField() {
		global $espcms_admin_templates;
		$maid = $_GET['maid'];
		if (!$maid || !espcms_ismatches($maid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($maid));
		}
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$db_where = " WHERE maid=$maid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$read['formtypename'] = espcms_find_array_key(ESPCMS_PublicDB::get_member_formType(), $read['inputtype'], 'key', 'name');
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', MemberLink::MemberField_link_array());
		$espcms_admin_templates->into('validate_list', ESPCMS_PublicDB::get_validatetype());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('member/member_attr_edit');
	}

	public static function saveMemberField() {
		global $espcms_link_db, $espcms_db_cache;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$db_table_member_value = ESPCMS_DB_PREFIX . "member_value";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!espcms_ismatches($_POST['attrrow']) || empty($_POST['attrrow']) || !espcms_ismatches($_POST['isvalidate']) || !espcms_ismatches($_POST['isreg'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addMemberField')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = self::$lng;
			$pid = MemberFieldDB::lastPidMemberField($_POST['lng'], 'pid');
			$_POST['pid'] = $pid ? $pid + 1 : 1;
			if (!$_POST['attrname'] || !preg_match('/^[a-z_]{2,50}$/', $_POST['attrname'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['attrname']));
			}
			if (self::verifyMemberFieldDB('attrname', $_POST['attrname'])) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_field_add_save_err', 'false', array($_POST['attrname']));
			}
			$key = espcms_find_array_key(ESPCMS_PublicDB::get_member_formType(), $_POST['inputtype'], 'key');
			$attrarray = ESPCMS_PublicDB::get_member_formType(false, $key);
			if (!$attrarray) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['inputtype']));
			}
			if ($attrarray['alter'] != 'TEXT') {
				$alter = $attrarray['alter'] == 'INT' || $attrarray['alter'] == 'FLOAT' ? $attrarray['alter'] . '(' . $attrarray['varlong'] . ') DEFAULT \'0\'' : $attrarray['alter'] . '(' . $attrarray['varlong'] . ')';
			} else {
				$alter = $attrarray['alter'];
			}
			$_POST['attrlenther'] = $attrarray['varlong'];
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$db_query = $espcms_link_db->db_query('ALTER TABLE ' . $db_table_member_value . ' ADD COLUMN ' . $_POST['attrname'] . ' ' . $alter . ' NOT NULL');
			if (!$db_query) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_field_add_save_err2', 'false', array($_POST['attrname']));
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$member_attr_list_cache_key, true);
			$espcms_db_cache->cacheDEL(self::$member_value_field_cache_key, true);
			espcms_log_install('member_pack-espcms_member_field_button_add', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_field_add_save_ok_message', 'true', array($_POST['typename']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editMemberField')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$maid = $_POST['maid'];
			if (!$maid || !espcms_ismatches($maid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($maid));
			}
			$db_where = "WHERE maid=$maid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($maid));
			}
			unset($_POST['isclass'], $_POST['pid'], $_POST['lng'], $_POST['attrname'], $_POST['inputtype']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$member_attr_list_cache_key, true);
			$espcms_db_cache->cacheDEL(self::$member_value_field_cache_key, true);
			espcms_log_install('member_pack-espcms_member_field_button_edit', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_field_edit_save_ok_message', 'true', array($_POST['typename']));
		}
	}

	public static function verifyMemberField() {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$maid = intval($_REQUEST['maid']);
		$db_num = self::verifyMemberFieldDB($verifyKey, $verifyValue, $maid, $verifyType) ? '1' : '0';
		exit($db_num);
	}

	private static function verifyMemberFieldDB($verifyKey, $verifyValue, $maid = 0, $verifyType = false) {
		$field_array = array('attrname');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			return true;
		}
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$db_table_member = ESPCMS_DB_PREFIX . "member";
		$talbe_field_array = espcms_field_out($db_table_member);
		$member_attr_array = espcms_array_onedim($talbe_field_array, 'Field');
		if (in_array($verifyValue, $member_attr_array) || $verifyValue == 'mvid') {
			return true;
		}
		if (empty($maid) || !espcms_ismatches($maid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND maid!=$maid" : " AND $verifyKey='$verifyValue' AND maid!=$maid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		return $db_num > 0 ? true : false;
	}

	public static function sortMemberField() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editMemberField')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		if (empty($_POST['id_array'])) {
			exit('false');
		}
		$aid_array = $_POST['id_array'];
		if (!is_array($aid_array) || count($aid_array) <= 0) {
			exit('false');
		}
		foreach ($aid_array as $key => $value) {
			$pid = $key;
			if (espcms_ismatches($pid) && espcms_ismatches($value)) {
				self::sortMemberFieldDB($value, $pid);
			}
		}
		$espcms_db_cache->cacheDEL(self::$member_attr_list_cache_key, true);
		espcms_log_install('member_pack-espcms_member_field_button_sort');
		exit('true');
	}

	private static function sortMemberFieldDB($maid = 0, $pid = 0) {
		if (!$maid || !espcms_ismatches($maid) || !espcms_ismatches($pid)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$db_where = " WHERE maid=$maid";
		$update_key = espcms_db_update_set_save($db_table, $db_where, "pid=$pid");
		return $update_key;
	}

	public static function delMemberField() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delMemberFieldDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('member_pack-espcms_member_field_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		$espcms_db_cache->cacheDEL(self::$member_attr_list_cache_key, true);
		$espcms_db_cache->cacheDEL(self::$member_value_field_cache_key, true);
		espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_field_del_message', 'true', array(), 'json', $return);
	}

	private static function delMemberFieldDB($maid) {
		global $espcms_link_db;
		if (!$maid || !espcms_ismatches($maid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $maid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$db_table_member_value = ESPCMS_DB_PREFIX . "member_value";
		$talbe_field_array = espcms_field_out($db_table, false);
		$db_where = " WHERE maid=$maid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $maid);
			return $return_array;
		}
		$del_query = espcms_db_delall($db_table, "maid=$maid");
		if ($del_query) {
			$del_query = $espcms_link_db->db_query('ALTER TABLE ' . $db_table_member_value . ' DROP COLUMN ' . $read['attrname']);
		}
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $maid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $maid);
			return $return_array;
		}
	}

	public static function setMemberField() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editMemberField')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "member_attr";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		foreach ($select_id as $key => $value) {
			if (!$value || !espcms_ismatches($value)) {
				continue;
			}
			espcms_db_update_set_save($db_table, "WHERE maid=$value", "$field='$field_value'");
		}
		$set_info_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$member_attr_list_cache_key, true);
		$espcms_db_cache->cacheDEL(self::$member_value_field_cache_key, true);
		espcms_log_install('member_pack-espcms_member_field_button_set', "$field=$field_value" . " maid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'member_pack-espcms_member_field_set_message', 'true', array($field));
	}

}
