<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use modul_application\ESPCMS_MemberDB;
use admin_application\link\MemberLink;

class MemberIntegral {

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveMemberIntegral');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
	}

	public static function listMemberIntegral() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "member_integral";
		$userid = $_REQUEST['userid'];
		if (espcms_ismatches($userid) && $userid) {
			$db_where .= " AND userid=$userid";
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$member_integral_type = $_REQUEST['member_integral_type'];
			if (espcms_ismatches($member_integral_type)) {
				$db_where .= " AND member_integral_type=$member_integral_type";
			}
			$search_keyname_array = array('member_integral_sn');
			$search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'member_integral_sn';
			$search_key = $_REQUEST['search_key'];
			if (isset($search_key) && !empty($search_key)) {
				$search_key = urldecode($search_key);
				$db_where .= " AND $search_keyname LIKE '%$search_key%'";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('member_integral_id');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "member_integral_id";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['username'] = ESPCMS_MemberDB::get_member_noatt_view($fetch_row['userid'], 'username');
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'member/member_integral_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('member_class_array', ESPCMS_MemberDB::get_member_class_list());
			$espcms_admin_templates->into('link', MemberLink::MemberIntegral_link_array(false, $_REQUEST));
			$templates = 'member/member_integral_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addMemberIntegral() {
		global $espcms_admin_templates;
		$userid = $_GET['userid'];
		if ($userid && espcms_ismatches($userid)) {
			$read = ESPCMS_MemberDB::get_member_noatt_view($userid);
			if (!$read) {
				espcms_message_err('db_pack-espcms_db_read_fail', array($userid));
			}
			$espcms_admin_templates->into('read', $read);
		}
		$espcms_admin_templates->into('link', MemberLink::MemberIntegral_link_array());
		$espcms_admin_templates->into('userlink', MemberLink::Member_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('member/member_integral_add');
	}

	public static function saveMemberIntegral() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "member_integral";
		$talbe_field_array = espcms_field_out($db_table, true);
		$app_read = ESPCMS_Core::get_app_config('member', true, 'appconfig');
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addMemberIntegral')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			if (!espcms_ismatches($_POST['userid']) || !$_POST['userid']) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			if (!espcms_ismatches($_POST['member_integral']) || !$_POST['member_integral']) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			if (!espcms_ismatches($_POST['member_integral_type']) || !$_POST['member_integral_type']) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			$read = ESPCMS_MemberDB::get_member_noatt_view($_POST['userid']);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			if ($_POST['member_integral_type'] == 2 && $read['integral'] < $_POST['member_integral']) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_integral_add_save_messags_err', 'false');
			}
			$_POST['member_integral_addtime'] = time();
			$_POST['member_integral_ip'] = real_remote_ip();
			if ($app_read['MEMBER_INTERGRALSN']) {
				$_POST['member_integral_sn'] = espcms_random($app_read['MEMBER_INTERGRALSN']);
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			ESPCMS_MemberDB::member_integral_DB($_POST['userid'], $_POST['member_integral'], $_POST['member_integral_type']);
			espcms_log_install('member_pack-espcms_member_integral_button_add', $read['username']);
			espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_integral_add_save_ok_message', 'true', array($read['username']));
		}
	}

	public static function delMemberIntegral() {
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delMemberIntegralDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('member_pack-espcms_member_integral_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_integral_del_message', 'true', array(), 'json', $return);
	}

	public static function delMemberIntegralDB($member_integral_id = 0) {
		if (!$member_integral_id || !espcms_ismatches($member_integral_id)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $member_integral_id);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "member_integral";
		$read = self::get_member_integral($member_integral_id);
		if (!$read) {
			$return_array = array('lan' => 'db_pack-espcms_db_read_fail', 'code' => 'false', 'key' => $member_integral_id);
			return $return_array;
		}
		$userread = ESPCMS_MemberDB::get_member_noatt_view($read['userid']);
		if ($userread && $userread['integral'] > $read['member_integral'] && $read['member_integral_type'] == 1) {
			ESPCMS_MemberDB::member_integral_DB($read['userid'], $read['member_integral'], 2);
		}
		if ($userread && $read['member_integral_type'] == 2) {
			ESPCMS_MemberDB::member_integral_DB($read['userid'], $read['member_integral'], 1);
		}
		$del_query = espcms_db_del($db_table, 'member_integral_id', $member_integral_id);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $member_integral_id);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $member_integral_id);
			return $return_array;
		}
	}

	private static function get_member_integral($member_integral_id = 0, $return_key = false) {
		if (!$member_integral_id || !espcms_ismatches($member_integral_id)) {
			return false;
		}
		$db_where = "WHERE member_integral_id=$member_integral_id";
		$db_table = ESPCMS_DB_PREFIX . 'member_integral';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

}
