<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use modul_application\ESPCMS_MemberDB;
use admin_application\ApplyDB;
use admin_application\link\MemberLink;
use admin_application\link\SettingLink;

class MemberMain {

	private static $lng;

	public function __construct() {
		global $module_array;
		$exclude_method = array('saveMember', 'verifyMember', 'selectMember', 'jsonMemberView', 'setMember', 'argumentMember', 'argumentSaveMember');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$lng = AdminPublicDB::get_lancode();
	}

	public static function listMember() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "member";
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$mcid = $_REQUEST['mcid'];
			if (espcms_ismatches($mcid) && $mcid) {
				$db_where .= " AND mcid=$mcid";
			}
			$sex = $_REQUEST['sex'];
			if (espcms_ismatches($sex)) {
				$db_where .= " AND sex=$sex";
			}
			$ismoblie = $_REQUEST['ismoblie'];
			if (espcms_ismatches($ismoblie)) {
				$db_where .= " AND ismoblie=$ismoblie";
			}
			$isemail = $_REQUEST['isemail'];
			if (espcms_ismatches($isemail)) {
				$db_where .= " AND isemail=$isemail";
			}
			$isqq = $_REQUEST['isqq'];
			if (espcms_ismatches($isqq)) {
				$db_where .= " AND isqq=$isqq";
			}
			$isweixin = $_REQUEST['isweixin'];
			if (espcms_ismatches($isweixin)) {
				$db_where .= " AND isweixin=$isweixin";
			}
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$search_keyname_array = array('username', 'userid', 'email', 'mobile', 'tel', 'qq');
			$search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'username';
			$search_key = $_REQUEST['search_key'];
			if (isset($search_key) && !empty($search_key)) {
				$search_key = urldecode($search_key);
				$db_where .= espcms_ismatches($search_key) && $search_key ? " AND (userid=$search_key OR username LIKE '%$search_key%')" : " AND (username LIKE '%$search_key%' OR email LIKE '%$search_key%' OR mobile LIKE '%$search_key%' OR alias LIKE '%$search_key%')";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('userid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "userid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['rankname'] = ESPCMS_MemberDB::get_member_class_view($fetch_row['mcid'], 'rankname');
				$fetch_row['edit'] = MemberLink::Member_link_array('edit', $fetch_row);
				$fetch_row['view'] = MemberLink::Member_link_array('view', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'member/member_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('member_class_array', ESPCMS_MemberDB::get_member_class_list());
			$espcms_admin_templates->into('link', MemberLink::Member_link_array(false, $_REQUEST));
			$templates = 'member/member_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addMember() {
		global $espcms_admin_templates;
		$member_class_list = ESPCMS_MemberDB::get_member_class_list();
		$espcms_admin_templates->into('member_class_list', $member_class_list);
		$att_array = ESPCMS_MemberDB::get_member_attr(self::$lng);
		$espcms_admin_templates->into('att_array', $att_array);
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('link', MemberLink::Member_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('member/member_add');
	}

	public static function editMember() {
		global $espcms_admin_templates;
		$userid = $_GET['userid'];
		if (!$userid || !espcms_ismatches($userid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($userid));
		}
		$read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($userid));
		}
		$member_class_list = ESPCMS_MemberDB::get_member_class_list($read['mcid']);
		$att_array = ESPCMS_MemberDB::get_member_attr(self::$lng);
		if (is_array($att_array)) {
			foreach ($att_array as $key => $value) {
				if (($value['inputtype'] == 'select' || $value['inputtype'] == 'radio') && is_array($value['attrvalue'])) {
					foreach ($value['attrvalue'] as $key2 => $value2) {
						$att_array[$key]['attrvalue'][$key2]['selected'] = trim($read[$value['attrname']]) == trim($value2['name']) ? 'selected' : '';
					}
				} elseif ($value['inputtype'] == 'checkbox') {
					$expvale = explode(',', $read[$value['attrname']]);
					foreach ($value['attrvalue'] as $key2 => $value2) {
						$att_array[$key]['attrvalue'][$key2]['selected'] = in_array($value2['name'], $expvale) ? 'selected' : '';
					}
				} elseif ($value['inputtype'] == 'date' || $value['inputtype'] == 'time' || $value['inputtype'] == 'datetime') {
					if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'date') {
						$att_array[$key]['attrvalue'] = date('Y-m-d', $read[$value['attrname']]);
					}
					if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'datetime') {
						$att_array[$key]['attrvalue'] = date('Y-m-d H:i:s', $read[$value['attrname']]);
					}
					if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'time') {
						$att_array[$key]['attrvalue'] = date('H:i', $read[$value['attrname']]);
					}
				} elseif ($value['inputtype'] == 'int' || $value['inputtype'] == 'float' || $value['inputtype'] == 'decimal') {
					$att_array[$key]['attrvalue'] = preg_match("/^[\d.]+/", $read[$value['attrname']]) ? $read[$value['attrname']] : 0;
				} else {
					$att_array[$key]['attrvalue'] = $read[$value['attrname']];
				}
			}
		}
		$espcms_admin_templates->into('att_array', $att_array);
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('member_class_list', $member_class_list);
		$espcms_admin_templates->into('link', MemberLink::Member_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->output('member/member_edit');
	}

	public static function viewMember() {
		global $espcms_admin_templates;
		$userid = $_GET['userid'];
		if (!$userid || !espcms_ismatches($userid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($userid));
		}
		$read = ESPCMS_MemberDB::get_member_view($userid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($userid));
		}
		$read['rankname'] = ESPCMS_MemberDB::get_member_class_view($read['mcid'], 'rankname');
		$att_array = ESPCMS_MemberDB::get_member_attr(self::$lng);
		if (is_array($att_array)) {
			foreach ($att_array as $key => $value) {
				if ($value['inputtype'] == 'date' || $value['inputtype'] == 'time' || $value['inputtype'] == 'datetime') {
					if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'date') {
						$att_array[$key]['attrvalue'] = date('Y-m-d', $read[$value['attrname']]);
					}
					if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'datetime') {
						$att_array[$key]['attrvalue'] = date('Y-m-d H:i:s', $read[$value['attrname']]);
					}
					if ($read[$value['attrname']] && espcms_ismatches($read[$value['attrname']]) && $value['inputtype'] == 'time') {
						$att_array[$key]['attrvalue'] = date('H:i', $read[$value['attrname']]);
					}
				} elseif ($value['inputtype'] == 'int' || $value['inputtype'] == 'float' || $value['inputtype'] == 'decimal') {
					$att_array[$key]['attrvalue'] = preg_match("/^[\d.]+/", $read[$value['attrname']]) ? $read[$value['attrname']] : 0;
				} else {
					$att_array[$key]['attrvalue'] = $read[$value['attrname']];
				}
			}
		}
		$espcms_admin_templates->into('link', MemberLink::Member_link_array(false, $read));
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('att_array', $att_array);
		$espcms_admin_templates->output('member/member_view');
	}

	public static function saveMember() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "member";
		$talbe_field_array = espcms_field_out($db_table, true);
		$_POST['birthday'] = espcms_isdata($_POST['birthday']) ? strtotime($_POST['birthday']) : 0;
		$_POST['qq'] = espcms_ismatches($_POST['qq']) ? $_POST['qq'] : 0;
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addMember')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			if (!espcms_ismatches($_POST['mcid']) || !$_POST['mcid'] || !espcms_ismatches($_POST['sex'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			if ($_POST['password'] && $_POST['password'] == $_POST['validation_password']) {
				$_POST['password'] = md5($_POST['password']);
			} else {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['password']));
			}
			if (self::verifyMemberDB('username', $_POST['username'])) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_username_warning_msg', 'false', array($_POST['username']));
			}
			if (self::verifyMemberDB('email', $_POST['email'])) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_email_warning_msg', 'false', array($_POST['email']));
			}
			if (self::verifyMemberDB('mobile', $_POST['mobile'])) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_email_warning_msg', 'false', array($_POST['mobile']));
			}
			$_POST['lng'] = self::$lng;
			$_POST['addtime'] = time();
			$_POST['visitcount'] = 0;
			$_POST['integral'] = 0;
			$_POST['isclass'] = 1;
			$_POST['ismoblie'] = 1;
			$_POST['isemail'] = 1;
			$_POST['isqq'] = 0;
			$_POST['isweixin'] = 0;
			unset($_POST['lastip'], $_POST['lasttime'], $_POST['updatetime'], $_POST['ismoblietime'], $_POST['isemailtime'], $_POST['isqq'], $_POST['mobliesntime']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			ESPCMS_MemberDB::member_install_attr(self::$lng, $install_id, $_POST);
			espcms_log_install('member_pack-espcms_member_button_add', $_POST['username']);
			espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_add_save_ok_message', 'true', array($_POST['username']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editMember')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$userid = $_POST['userid'];
			if (empty($userid) || !espcms_ismatches($userid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($userid));
			}
			$db_where = "WHERE userid=$userid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($userid));
			}
			if ($_POST['password'] && $_POST['password'] == $_POST['validation_password']) {
				$_POST['password'] = md5($_POST['password']);
			} else {
				unset($_POST['password']);
			}
			if (self::verifyMemberDB('email', $_POST['email'], $userid)) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_email_warning_msg', 'false', array($_POST['email']));
			}
			if (self::verifyMemberDB('mobile', $_POST['mobile'], $userid)) {
				espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_email_warning_msg', 'false', array($_POST['mobile']));
			}
			$_POST['updatetime'] = time();
			unset($_POST['lng'], $_POST['username'], $_POST['addtime'], $_POST['lastip'], $_POST['lasttime'], $_POST['ismoblietime'], $_POST['isemailtime'], $_POST['isqq'], $_POST['mobliesntime']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			ESPCMS_MemberDB::member_install_attr($read['lng'], $userid, $_POST, true);
			espcms_log_install('member_pack-espcms_member_button_edit', $read['username']);
			espcms_public_dialog('espcms_info_save_ok', 'member_pack-espcms_member_edit_save_ok_message', 'true', array($read['username']));
		}
	}

	public static function setMember() {
		if (!ESPCMS_AdminAuthority::authorityVerify('editMember')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$talbe_field_array = array('ismoblie', 'isemail', 'isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE userid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
			}
		}
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('member_pack-espcms_member_button_set', "$field=$field_value" . " userid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'member_pack-espcms_member_set_message', 'true', array($field));
	}

	public static function delMember() {
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delMemberDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('member_pack-espcms_member_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'member_pack-espcms_member_del_message', 'true', array(), 'json', $return);
	}

	private static function delMemberDB($userid = 0) {
		if (!$userid || !espcms_ismatches($userid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $userid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$db_table_member_value = ESPCMS_DB_PREFIX . "member_value";
		$del_query = espcms_db_del($db_table, 'userid', $userid);
		if ($del_query) {
			espcms_db_del($db_table_member_value, 'userid', $userid);
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $userid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $userid);
			return $return_array;
		}
	}

	public static function argumentMember() {
		global $espcms_admin_templates;
		if (!ESPCMS_AdminAuthority::authorityVerify('setExtensions')) {
			espcms_message_err('public_pack-espcms_authority_function_fail');
		}
		$app_read = ESPCMS_Core::get_app_config('member', true, 'appconfig');
		$espcms_admin_templates->into('link', MemberLink::Member_link_array());
		$member_class_list = ESPCMS_MemberDB::get_member_class_list($app_read['MEMBER_REG_MCID']);
		$espcms_admin_templates->into('member_class_list', $member_class_list);
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('app_read', $app_read);
		$espcms_admin_templates->output('member/member_set');
	}

	public static function argumentSaveMember() {
		if (!ESPCMS_AdminAuthority::authorityVerify('setExtensions')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$MEMBER_REG_MCID = $_POST['MEMBER_REG_MCID'];
		if (empty($MEMBER_REG_MCID) || !espcms_ismatches($MEMBER_REG_MCID)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($MEMBER_REG_MCID));
		}
		$_POST['MEMBER_LOGIN_VERIFY'] = !espcms_ismatches($_POST['MEMBER_LOGIN_VERIFY']) ? 1 : $_POST['MEMBER_LOGIN_VERIFY'];
		$_POST['MEMBER_REG_VERIFY'] = !espcms_ismatches($_POST['MEMBER_REG_VERIFY']) ? 1 : $_POST['MEMBER_REG_VERIFY'];
		$_POST['MEMBER_EMAIL_VERIFY'] = !espcms_ismatches($_POST['MEMBER_EMAIL_VERIFY']) ? 1 : $_POST['MEMBER_EMAIL_VERIFY'];
		$_POST['MEMBER_MOBLIE_VERIFY'] = !espcms_ismatches($_POST['MEMBER_MOBLIE_VERIFY']) ? 1 : $_POST['MEMBER_MOBLIE_VERIFY'];
		$_POST['MEMBER_ISCLASS_VERIFY'] = !espcms_ismatches($_POST['MEMBER_ISCLASS_VERIFY']) ? 1 : $_POST['MEMBER_ISCLASS_VERIFY'];
		$_POST['MEMBER_CITY_VERIFY'] = !espcms_ismatches($_POST['MEMBER_CITY_VERIFY']) ? 1 : $_POST['MEMBER_CITY_VERIFY'];
		$_POST['MEMBER_REG_LOCK_USER'] = preg_match('/^[\w,]+$/', $_POST['MEMBER_REG_LOCK_USER']) ? $_POST['MEMBER_REG_LOCK_USER'] : '';
		$_POST['MEMBER_SAFETY_PASSWORD_TIME'] = !espcms_ismatches($_POST['MEMBER_SAFETY_PASSWORD_TIME']) ? 0 : $_POST['MEMBER_SAFETY_PASSWORD_TIME'];
		unset($_POST['token_key'], $_POST['token_name']);
		$update_id = ApplyDB::save_apply('member', $_POST);
		if ($update_id) {
			espcms_log_install('member_pack-espcms_member_button_sys');
			espcms_public_dialog('save_ok', 'member_pack-espcms_member_ageset_message', 'true');
		} else {
			espcms_public_dialog('save_ok', 'member_pack-espcms_member_ageset_message_err', 'false');
		}
	}

	public static function verifyMember() {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$userid = $_REQUEST['userid'];
		$db_num = self::verifyMemberDB($verifyKey, $verifyValue, $userid, $verifyType) ? '1' : '0';
		exit($db_num);
	}

	private static function verifyMemberDB($verifyKey, $verifyValue, $userid = 0, $verifyType = false) {
		$field_array = array('username', 'email', 'mobile');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			return true;
		}
		if (!$verifyValue) {
			return true;
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		if (empty($userid) || !espcms_ismatches($userid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND userid!=$userid" : " AND $verifyKey='$verifyValue' AND userid!=$userid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		return $db_num > 0 ? true : false;
	}

	public static function selectMember() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "member";
		$search_key = rtrim($_GET['search_key']);
		if (!isset($search_key) || empty($search_key) || strlen($search_key) < 2) {
			exit(espcms_lan_pack('member_pack-seapoa_lable_username_id_search_key'));
		}
		$search_keyname_array = array('username', 'email', 'alias', 'mobile');
		$search_keyname = $_REQUEST['search_keyname'] && in_array($_REQUEST['search_keyname'], $search_keyname_array) ? $_REQUEST['search_keyname'] : 'username';
		if (isset($search_key) && !empty($search_key)) {
			$db_where .= "username LIKE '%$search_key%' OR email LIKE '%$search_key%' OR mobile LIKE '%$search_key%' OR alias LIKE '%$search_key%'";
		}
		$db_sql = "SELECT userid,username,mcid,mobile,email FROM $db_table WHERE $db_where ORDER BY userid DESC LIMIT 0,10";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$fetch_row['rankname'] = ESPCMS_MemberDB::get_member_class_view($fetch_row['mcid'], 'rankname');
			$array[] = $fetch_row;
		}
		$espcms_admin_templates->into('array', $array);
		$espcms_admin_templates->output('member/member_dropdown');
	}

	public static function jsonMemberView() {
		$userid = $_POST['userid'];
		if (!$userid || !espcms_ismatches($userid)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($userid));
		}
		$read = ESPCMS_MemberDB::get_member_noatt_view($userid);
		if (!$read) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_read_fail', 'false', array($userid));
		}
		$array_json = json_encode($read);
		exit($array_json);
	}

}
