<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use application\ESPCMS_FileTool;
use admin_application\AdminPublicDB;
use admin_application\link\SettingLink;

class SettingMain {

	public function __construct() {
		$exclude_method = array('saveSettingMain');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function editSetting() {
		global $espcms_admin_templates, $espcms_link_db, $espcms_command;

		$db_table = ESPCMS_DB_PREFIX . "config";

		$config_category_id = $_REQUEST['config_category_id'];
		if (isset($config_category_id) && espcms_ismatches($config_category_id)) {
			$config_category_id = intval($config_category_id);
			$db_where = " AND config_category_id=$config_category_id";
		} else {
			$config_category_id = 1;
			$db_where = " AND config_category_id=1";
		}
		$lan_array = AdminPublicDB::get_lan_list(false, false, false, true);
		$lan_array_web = AdminPublicDB::get_lan_list(false, false, true);
		$first_field_type = false;
		$db_sql = "SELECT * FROM $db_table WHERE 1=1 $db_where AND config_isline=0 ORDER BY config_pid,config_id";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			if (!$first_field_type) {
				$first_field = $fetch_row['config_name'];
				$first_field_type = true;
			}
			$newarray = array();
			if ($fetch_row['config_type'] == 'bool') {
				$bottonname = explode(',', $fetch_row['config_botton']);
				foreach ($bottonname as $key => $value) {
					$newarray[$key]['selected'] = $fetch_row['config_value'] == $key ? 'checked' : '';
					$newarray[$key]['key'] = $key;
					$newarray[$key]['name'] = $value;
					if ($fetch_row['config_style_isopen']) {
						$newarray[$key]['tab'] = $key == 1 ? 'class="tab_click" open_list="' . $fetch_row['config_style_open'] . '"' : 'class="tab_click" close_list="' . $fetch_row['config_style_close'] . '"';
					}
				}
				$fetch_row['selectkey'] = $newarray;
			} elseif ($fetch_row['config_type'] == 'selectkey') {
				$arrayname = $fetch_row['config_classname'];
				if ($fetch_row['config_isclass'] && is_array($$arrayname)) {
					foreach ($$arrayname as $key => $value) {
						$newarray[$key]['selected'] = $fetch_row['config_value'] == $value['lng'] ? 'selected' : '';
						$newarray[$key]['key'] = $value['lng'];
						$newarray[$key]['name'] = $value['lngtitle'];
					}
				} else {
					$bottonname = explode(',', $fetch_row['config_botton']);
					foreach ($bottonname as $key => $value) {
						$bottonvalue = explode('|', $value);
						$newarray[$key]['selected'] = $fetch_row['config_value'] == $bottonvalue[0] ? 'selected' : '';
						$newarray[$key]['key'] = $bottonvalue[0];
						$newarray[$key]['name'] = $bottonvalue[1];
					}
				}
				$fetch_row['selectkey'] = $newarray;
			}

			$fetch_row['isshow'] = !$fetch_row['config_style_islinkvalue'] || ($fetch_row['config_style_islinkvalue'] && $espcms_command[$fetch_row['config_style_linkname']]) ? '' : 'displaynone';

			$fetch_row['link_validation'] = $fetch_row['config_style_islinkvalue'] && $fetch_row['config_style_linkname'] ? 'link-validation="' . $fetch_row['config_style_linkname'] . '" link-gettype="radio" link-getvalue="' . $fetch_row['config_style_linkvalue'] . '"' : '';
			$array[] = $fetch_row;
		}
		$espcms_admin_templates->into('first_field', $first_field);
		$espcms_admin_templates->into('config_category_id', $config_category_id);
		$espcms_admin_templates->into('setting', $array);
		$espcms_admin_templates->into('espcms_command', $espcms_command);
		$espcms_admin_templates->into('link', SettingLink::SettingMain_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->output('admin/setting');
	}

	public static function saveSettingMain() {
		global $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "config";
		if (!ESPCMS_AdminAuthority::authorityVerify('editSetting')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		foreach ($_POST as $key => $value) {

			$update_sql = "UPDATE $db_table SET config_value='$value' WHERE config_name='$key'";
			$espcms_link_db->db_query($update_sql);
		}

		if (!ESPCMS_Core::command_creat()) {
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_setting_creat_err', 'false', array('/espcms_datacache/espcms_command.php'));
		}
		if ($_POST['IS_HTML'] && espcms_ismatches($_POST['IS_HTML'])) {
			$home_index_file = ESPCMS_FILE_ROOT . $_POST['ENTRANCE_FILE'] . '.html';
			ESPCMS_FileTool::delFile($home_index_file);
		}

		espcms_log_install('setting_pack-espcms_setting_log_title', $_POST['config_name']);

		espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_setting_save_ok_mess', 'true', array($_POST['config_name']));
	}

}
