<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
 */

namespace admin_application;

class AdminPublicDB {

	public static function get_lancode() {
		global $espcms_command;
		if ($_GET['lng'] && preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			$lng = $_GET['lng'];
			espcms_set_cookie('espcms_admin_lng_info', $lng);
		} else {
			$cookie_lng = $_COOKIE['espcms_admin_lng_info'];
			$lng = $cookie_lng ? $cookie_lng : $espcms_command['DEFAULT_LNG'];
		}
		return $lng;
	}

	public static function get_lan_view($lan_id = 0, $lng = false, $return_key = false) {
		if (empty($lan_id) || !espcms_ismatches($lan_id)) {
			return false;
		}
		$db_where = "WHERE 1=1";
		if (espcms_ismatches($lan_id) && !empty($lan_id)) {
			$db_where .= " AND lan_id=$lan_id";
		}
		if (espcms_ismatches($lng)) {
			$db_where .= " AND lng='$lng'";
		}
		$db_table = ESPCMS_DB_PREFIX . 'lng';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_lan_exclude_list($lng = false, $exclude_lan = false) {
		$db_table = ESPCMS_DB_PREFIX . 'lng';
		if (!preg_match("/^[a-z0-9]{2,50}$/i", $exclude_lan)) {
			return false;
		}
		$db_where = " AND isuptype=0 AND lng!='$exclude_lan'";
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "lan_id DESC");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		if ($array && preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			foreach ($array as $key => $value) {
				if ($lng == $value['lng']) {
					$array[$key]['selected'] = 'selected';
				}
			}
		}
		return $array;
	}

	public static function get_lan_list($lng = false, $iswap = false, $isopen = false, $isuptype = false, $order_type = "ASC") {
		global $espcms_db_cache, $espcms_command;
		$db_table = ESPCMS_DB_PREFIX . 'lng';
		$db_order = "lan_id $order_type";
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $order_type . '_' . $iswap . '_' . $isopen . '_' . $isuptype;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!is_array($array) || !count($array) > 0) {
			$talbe_field_array = espcms_field_out($db_table);
			if ($isuptype) {
				$db_where .= " AND isuptype=0";
			}
			if (espcms_ismatches($iswap)) {
				$db_where .= " AND iswap=$iswap";
			}
			if (espcms_ismatches($isopen)) {
				$db_where .= " AND isopen=$isopen";
			}
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $db_order);
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		$lng = $lng ? $lng : $espcms_command['DEFAULT_LNG'];
		if ($lng) {
			foreach ($array as $key => $value) {
				if ($lng == $value['lng']) {
					$array[$key]['selected'] = 'selected';
				}
			}
		}
		return $array;
	}

	public static function get_menu_app_view($app = array(), $return_key = false) {
		if (!is_array($app)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'menulink';
		$talbe_field_array = espcms_field_out($db_table, false);
		$db_where = "WHERE menu_dirname='$app[0]' AND menu_classname='$app[1]' AND menu_module='$app[2]'";
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_admin_member_view($admin_member_id, $return_key = false) {
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'admin_member';
		$talbe_field_array = espcms_field_out($db_table);
		$db_where = "WHERE admin_member_id=$admin_member_id";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			return false;
		}
		return !$return_key ? $read : $read[$return_key];
	}

	public static function get_power_groups_view($power_groups_id, $return_key = false) {
		global $espcms_db_cache;
		if (empty($power_groups_id) || !espcms_ismatches($power_groups_id)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'power_groups';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $power_groups_id;
		$read = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read) {
			$talbe_field_array = espcms_field_out($db_table);
			$db_where = "WHERE power_groups_id=$power_groups_id";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read);
		}
		return !$return_key ? $read : $read[$return_key];
	}

	public static function get_power_groups_list($power_groups_id = 0, $order_type = "DESC") {
		global $espcms_db_cache;
		$db_table = ESPCMS_DB_PREFIX . 'power_groups';
		$db_order = "power_groups_id $order_type";
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $order_type;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!is_array($array) || !count($array) > 0) {
			$talbe_field_array = espcms_field_out($db_table);
			$array = espcms_db_list_array($db_table, $talbe_field_array, false, $db_order);
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		foreach ($array as $key => $value) {
			if ($power_groups_id == $value['power_groups_id']) {
				$array[$key]['selected'] = 'selected';
			}
		}
		return $array;
	}

}
