<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



namespace admin_application;

use application\ESPCMS_Change;

class ArticleTypeDB {

	public static function lastPidArticleType($lng = false, $return_key = false) {
		$db_where = "WHERE lng='$lng' ORDER BY pid DESC LIMIT 0,1";
		$db_table = ESPCMS_DB_PREFIX . 'document_typelist';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function lastPidSpecialCatalog($lng = false, $return_key = false) {
		$db_where = "WHERE lng='$lng' ORDER BY pid DESC LIMIT 0,1";
		$db_table = ESPCMS_DB_PREFIX . 'document_subjectlist';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_article_type_list($tid = 0, $upid = 0, $mid = 0, $isclass = false, $lng = false, $islink = false, $isbase = false) {
		global $espcms_db_cache;
		$db_table = ESPCMS_DB_PREFIX . 'document_typelist';
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $mid . '_' . $upid . '_' . $isclass . '_' . $isbase;
		$article_type_array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$article_type_array) {
			$article_type_array = self::get_article_type_listDB($upid, $lng, $mid, 0, $isclass, 0, $isbase);
			$espcms_db_cache->cacheSave($cache_key, $article_type_array);
		}
		if (!is_array($article_type_array) || !$article_type_array) {
			return false;
		}
		$article_type_new_array = array();
		foreach ($article_type_array as $key => $value) {

			if ((!$value['isclass'] && $isclass) || ($islink && $value['styleid'] == 3)) {
				$un_id = $value['pathid'] . '-';
				continue;
			}
			$article_type_array[$key]['selected'] = ($tid == $value['tid']) ? 'selected' : '';
			$unkey = strrpos($value['pathid'], $un_id, 0);

			if ($unkey === 0) {
				continue;
			}
			$article_type_new_array[] = $article_type_array[$key];
		}
		return $article_type_new_array;
	}

	public static function get_article_type_listDB($in_tid = 0, $lng = 'cn', $mid = 0, $tid = 0, $isclass = false, $level = 0, $isbase = false) {
		global $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . 'document_typelist';
		if (espcms_ismatches($isclass)) {
			$db_where = " AND c.isclass=$isclass";
		}
		if ($mid && espcms_ismatches($mid)) {
			$db_where .= " AND c.mid=$mid";
		}
		if ($isbase) {
			$db_where .= " AND c.styleid<3";
		}
		$db_where .= " AND c.lng='$lng'";

		$db_sql = "SELECT c.tid,c.pid,c.mid,c.topid,c.upid,c.linkid,c.gotoid,c.styleid,c.purview,c.ismenu,c.isaccessory,c.ispart,c.pageclass,c.isclass,c.isline,c.pagemax,c.iswap,c.typename,c.typepic,COUNT(a.tid) AS has_c FROM $db_table AS c LEFT JOIN $db_table AS a ON a.upid = c.tid WHERE 1=1 $db_where GROUP BY c.tid ORDER BY c.upid,c.pid,c.tid";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$array[] = $fetch_row;
		}

		if ($tid > 0) {
			foreach ($array as $key => $value) {

				$array[$key]['selected'] = ($tid == $value['tid']) ? 'selected' : '';
			}
		}

		$out_category_array = ESPCMS_Change::has_category($in_tid, $array, 'tid', 'upid');
		if (is_array($out_category_array)) {
			foreach ($out_category_array as $key => $value) {

				$out_category_array[$key]['classname'] = 'opt_three_' . $value['level'];
				$out_category_array[$key]['icon'] = $value['has_c'] > 0 ? 'espcms_icon_fa espcms_icon_fa-chevron-circle-down text-orange' : 'espcms_icon_fa espcms_icon_fa-chevron-circle-right text-danfei';
			}
		}

		if ($level > 0) {
			if ($in_tid == 0) {
				$end_level = $level;
			} else {

				$first_item = reset($out_category_array);
				$end_level = $first_item['level'] + $level;
			}

			foreach ($out_category_array AS $key => $val) {
				if ($val['level'] >= $end_level) {
					unset($out_category_array[$key]);
				}
			}
		}
		return $out_category_array;
	}

	public static function get_document_subjectlist_list($lng = false, $sid = 0, $mid = 0, $isclass = false) {
		global $espcms_db_cache;
		if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			return false;
		}
		$db_where .= " AND lng='$lng'";
		if ($mid && espcms_ismatches($mid)) {
			$db_where .= " AND mid=$mid";
		}
		if (espcms_ismatches($isclass)) {
			$db_where .= " AND isclass=$isclass";
		}
		$db_table = ESPCMS_DB_PREFIX . 'document_subjectlist';
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $mid . '_' . $isclass;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$array) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "pid,sid DESC");
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		if (is_array($array) && count($array) > 0 && $sid && espcms_ismatches($sid)) {
			foreach ($array as $key => $value) {
				$array[$key]['selected'] = ($sid == $value['sid']) ? 'selected' : '';
			}
		}
		return $array;
	}

	public static function get_document_label_list($lng = false, $dlid = 0, $mid = 0) {
		global $espcms_db_cache;
		if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			return false;
		}
		$db_where .= " AND lng='$lng'";
		if ($mid && espcms_ismatches($mid)) {
			$db_where .= " AND mid=$mid";
		}
		$db_table = ESPCMS_DB_PREFIX . 'document_label';
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $lng . '_' . $mid;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$array) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "dlid DESC");
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		if (is_array($array) && count($array) > 0 && $dlid && espcms_ismatches($dlid)) {
			foreach ($array as $key => $value) {
				$array[$key]['selected'] = ($dlid == $value['dlid']) ? 'selected' : '';
			}
		}
		if (is_array($array) && count($array) > 0 && $dlid && preg_match("/^[0-9,]+$/i", $dlid)) {
			$dlid_array = explode(',', $dlid);
			foreach ($array as $key => $value) {
				$array[$key]['selected'] = in_array($value['dlid'], $dlid_array) ? 'selected' : '';
			}
		}
		return $array;
	}

}
