<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

namespace inc_application\link;

use modul_application\ESPCMS_ArticleDB;

class ArticleLink {

	public static function doc_link($read = array(), $isdyurl = false, $isrewrite = true, $lng = false, $ispath = false) {
		global $espcms_command;
		if ($read['islink'] && espcms_isurl($read['link'])) {
			$link = $read['link'];
		} else {
			if (!$espcms_command['IS_HTML'] && $read['ishtml'] <= 1 && !$isdyurl && $read['pageclass'] <= 1 && ESPCMS_WEB_TYPE != 'WAP') {
				$action_key[] = ESPCMS_ArticleDB::update_article_filepath($read);
				$link = espcms_url_html_out($action_key, false, false);
			} else {
				if ($espcms_command['IS_REWRITE'] && $isrewrite) {
					$action_key[] = espcms_ismatches($read['page_key']) && $read['page_key'] && $read['page_key'] > 1 ? 'Article_Read_' . $read['did'] . '_' . $read['page_key'] : 'Article_Read_' . $read['did'];
					$action_key[] = urlencode(str_replace('/', '_', $read['title']));
					$link = espcms_url_out($action_key, true);
				} else {
					$action_key['ac'] = 'Article';
					$action_key['at'] = 'Read';
					$action_key['did'] = $read['did'];
					if (espcms_ismatches($read['page_key']) && $read['page_key'] && $read['page_key'] > 1) {
						$action_key['page'] = $read['page_key'];
					}
					$link = espcms_url_out($action_key, false, $lng, $ispath);
				}
			}
		}
		return $link;
	}

	public static function doc_js_link($linkcode = false, $read = array()) {
		$link_array = array();
		$action_key['ac'] = 'Article';
		$action_key['at'] = 'GetClick';
		$action_key['did'] = $read['did'];
		$link_array['click'] = espcms_url_out($action_key);
		$action_key['at'] = 'Readpuv';
		$action_key['did'] = $read['did'];
		$link_array['readpuv'] = espcms_url_out($action_key);
		$action_key['at'] = 'Typepuv';
		$action_key['tid'] = $read['tid'];
		$link_array['typepuv'] = espcms_url_out($action_key);
		$action_key['at'] = 'Subpuv';
		$action_key['sid'] = $read['sid'];
		$link_array['subpuv'] = espcms_url_out($action_key);
		return $linkcode ? $link_array[$linkcode] : $link_array;
	}

	public static function type_link($read = array(), $pageid = 0, $ispath = false) {
		global $espcms_command;
		if ($read['styleid'] == 3) {
			if ($read['isline'] && espcms_isurl($read['typeurl'])) {
				$link = $read['typeurl'];
			}
			if (!$read['isline'] && espcms_ismatches($read['gotoline']) && $read['gotoline']) {
				$doc_read = ESPCMS_ArticleDB::get_article_read($read['gotoline']);
				$link = self::doc_link($doc_read);
			}
		} else {
			if (!$espcms_command['IS_HTML'] && $read['pageclass'] <= 1 && ESPCMS_WEB_TYPE != 'WAP') {
				$action_key[] = $read['dirname'];
				$read['filenamestyle'] = !$read['filenamestyle'] ? '{tid}_{pageid}' : $read['filenamestyle'];
				if (espcms_ismatches($pageid) && $pageid && $pageid > 1) {
					$read['pageid'] = $pageid;
					$action_key[] = get_htmlfilename($read['filenamestyle'], $read);
				}
				$link = $pageid > 1 ? espcms_url_html_out($action_key, false, false, true) : espcms_url_html_out($action_key);
			} else {
				if ($espcms_command['IS_REWRITE']) {
					$action_key[] = espcms_ismatches($pageid) && $pageid ? 'Article_List_' . $read['tid'] . '_' . $pageid : 'Article_List_' . $read['tid'];
					$action_key[] = urlencode(str_replace('/', '_', $read['typename']));
					$link = espcms_url_out($action_key, true);
				} else {
					$action_key['ac'] = 'Article';
					$action_key['at'] = 'List';
					$action_key['tid'] = $read['tid'];
					if (espcms_ismatches($pageid) && $pageid) {
						$action_key['pageid'] = $pageid;
					}
					$link = espcms_url_out($action_key, false, false, $ispath);
				}
			}
		}
		return $link;
	}

	public static function subtype_link($read = array(), $pageid = 0, $ispath = false) {
		global $espcms_command;
		if (!$espcms_command['IS_HTML'] && $read['ishtml'] <= 1 && ESPCMS_WEB_TYPE != 'WAP') {
			$action_key[] = $read['dirname'];
			$read['filenamestyle'] = !$read['filenamestyle'] ? '{sid}_{pageid}' : $read['filenamestyle'];
			if (espcms_ismatches($pageid) && $pageid && $pageid > 1) {
				$read['pageid'] = $pageid;
				$action_key[] = get_htmlfilename($read['filenamestyle'], $read);
			}
			$link = $pageid > 1 ? espcms_url_html_out($action_key, false, false, true) : espcms_url_html_out($action_key);
		} else {
			if ($espcms_command['IS_REWRITE']) {
				$action_key[] = espcms_ismatches($pageid) && $pageid ? 'Article_SubList_' . $read['sid'] . '_' . $pageid : 'Article_SubList_' . $read['sid'];
				$action_key[] = urlencode(str_replace('/', '_', $read['subjectname']));
				$link = espcms_url_out($action_key, true);
			} else {
				$action_key['ac'] = 'Article';
				$action_key['at'] = 'SubList';
				$action_key['sid'] = $read['sid'];
				if (espcms_ismatches($pageid) && $pageid) {
					$action_key['pageid'] = $pageid;
				}
				$link = espcms_url_out($action_key, false, false, $ispath);
			}
		}
		return $link;
	}

	public static function tags_link($read = array(), $pageid = 0) {
		global $espcms_command;
		if ($espcms_command['IS_REWRITE']) {
			$action_key[] = espcms_ismatches($pageid) && $pageid ? 'Article_Tags' . '_' . $pageid : 'Article_Tags';
			$action_key[] = urlencode($read['keywordname']);
			$link = espcms_url_out($action_key, true);
		} else {
			$action_key['ac'] = 'Article';
			$action_key['at'] = 'Tags';
			if (espcms_ismatches($pageid) && $pageid) {
				$action_key['pageid'] = $pageid;
			}
			$action_key['key'] = urlencode($read['keywordname']);
			$link = espcms_url_out($action_key);
		}
		return $link;
	}

	public static function search_link($read = array(), $pageid = 0) {
		$action_key['ac'] = 'Search';
		$action_key['at'] = 'List';
		$action_key['pageid'] = $pageid;
		$action_key['mid'] = $read['mid'];
		$action_key['tid'] = $read['tid'];
		$action_key['keyword'] = urlencode($read['keyword']);
		$action_key['keyname'] = urlencode($read['keyname']);
		$action_key['attr_array'] = $read['attr_array'] && is_array($read['attr_array']) ? urlencode(serialize($read['attr_array'])) : '';
		$link = espcms_url_out($action_key);
		return $link;
	}

}
