
CREATE TABLE IF NOT EXISTS `esp_admin_member` (
  `admin_member_id` int(10) unsigned NOT NULL auto_increment,
  `power_groups_id` int(11) unsigned NOT NULL default '0',
  `admin_username` varchar(100) NOT NULL default '',
  `admin_password` varchar(50) NOT NULL default '',
  `admin_email` varchar(200) NOT NULL,
  `admin_name` varchar(50) NOT NULL default '',
  `admin_sex` tinyint(1) unsigned NOT NULL default '0',
  `admin_intotime` int(11) unsigned NOT NULL default '0',
  `admin_intime` int(11) unsigned NOT NULL default '0',
  `admin_outtime` int(11) unsigned NOT NULL default '0',
  `admin_ipadd` varchar(50) NOT NULL default '',
  `admin_hit` int(10) unsigned NOT NULL default '0',
  `admin_isclass` tinyint(1) unsigned NOT NULL default '1',
  `admin_isremote` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`admin_member_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_admin_users_login` (
  `user_login_id` int(11) unsigned NOT NULL auto_increment,
  `user_login_ip` varchar(50) NOT NULL,
  `user_login_username` varchar(100) NOT NULL,
  `user_login_err_num` tinyint(1) unsigned NOT NULL default '0',
  `user_login_err_time` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `user_login_id` (`user_login_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_apply` (
  `appid` int(11) unsigned NOT NULL auto_increment,
  `apptype` smallint(5) unsigned NOT NULL default '0',
  `applyname` varchar(200) NOT NULL default '',
  `applycontent` text NOT NULL,
  `applycode` varchar(100) NOT NULL,
  `applyvol` varchar(100) NOT NULL,
  `volsn` int(11) unsigned NOT NULL default '0',
  `uservol` bigint(11) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  `setuptime` int(11) unsigned NOT NULL default '0',
  `isdel` tinyint(1) unsigned NOT NULL default '0',
  `isetup` tinyint(1) unsigned NOT NULL default '0',
  `isopen` tinyint(1) unsigned NOT NULL default '1',
  `isset` tinyint(1) unsigned NOT NULL default '0',
  `isdb` tinyint(1) unsigned NOT NULL default '0',
  `appconfig` text NOT NULL,
  `appseturl` varchar(100) NOT NULL default '',
  UNIQUE KEY `appid` (`appid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_config` (
  `config_id` int(11) unsigned NOT NULL auto_increment,
  `config_pid` smallint(5) unsigned NOT NULL default '50',
  `config_category_id` int(11) unsigned NOT NULL default '0',
  `config_isline` tinyint(1) unsigned NOT NULL default '0',
  `config_title` varchar(200) NOT NULL,
  `config_name` varchar(200) NOT NULL default '',
  `config_value` text NOT NULL,
  `config_type` varchar(50) NOT NULL,
  `config_content` varchar(200) NOT NULL,
  `config_botton` text NOT NULL,
  `config_select_value` varchar(100) NOT NULL default '',
  `config_validation` varchar(200) NOT NULL,
  `config_minlength` int(10) unsigned NOT NULL default '0',
  `config_maxlength` int(10) unsigned NOT NULL default '0',
  `config_isvalidation` tinyint(1) NOT NULL default '0',
  `config_validation_msg` varchar(200) NOT NULL,
  `config_style_height` smallint(5) unsigned NOT NULL default '0',
  `config_style_isopen` tinyint(1) unsigned NOT NULL default '0',
  `config_style_open` varchar(200) NOT NULL,
  `config_style_close` varchar(200) NOT NULL default '',
  `config_style_islinkvalue` tinyint(1) unsigned NOT NULL default '0',
  `config_style_linkname` varchar(200) NOT NULL,
  `config_style_linktype` varchar(50) NOT NULL default 'radio',
  `config_style_linkvalue` varchar(20) NOT NULL default '',
  `config_isclass` tinyint(1) unsigned NOT NULL default '0',
  `config_classname` varchar(100) NOT NULL,
  UNIQUE KEY `config_id` (`config_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_document` (
  `did` int(11) unsigned NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL default 'cn',
  `pid` smallint(6) unsigned NOT NULL default '50',
  `mid` smallint(6) unsigned NOT NULL default '0',
  `aid` smallint(6) unsigned NOT NULL default '0',
  `tid` int(11) unsigned NOT NULL default '0',
  `extid` varchar(200) NOT NULL,
  `sid` int(11) unsigned NOT NULL default '0',
  `fgid` int(8) unsigned NOT NULL default '0',
  `linkdid` varchar(200) NOT NULL default '',
  `votelink` varchar(200) NOT NULL,
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `ishtml` tinyint(1) unsigned NOT NULL default '1',
  `ismess` tinyint(1) unsigned NOT NULL default '1',
  `isorder` tinyint(1) unsigned NOT NULL default '0',
  `ktid` int(6) unsigned NOT NULL default '0',
  `purview` varchar(200) NOT NULL default '0',
  `istemplates` tinyint(1) unsigned NOT NULL default '0',
  `isbase` tinyint(1) unsigned NOT NULL default '0',
  `recommend` varchar(100) NOT NULL default '',
  `tsn` varchar(50) NOT NULL default '',
  `title` varchar(200) NOT NULL,
  `longtitle` varchar(200) NOT NULL,
  `color` varchar(8) NOT NULL,
  `author` char(20) NOT NULL,
  `source` char(30) NOT NULL,
  `pic` varchar(200) NOT NULL,
  `tags` varchar(250) NOT NULL,
  `headtitle` varchar(200) NOT NULL,
  `keywords` varchar(220) NOT NULL default '',
  `description` text NOT NULL,
  `summary` text NOT NULL,
  `link` varchar(250) NOT NULL,
  `oprice` decimal(10,2) NOT NULL default '0.00',
  `bprice` decimal(10,2) NOT NULL default '0.00',
  `click` smallint(6) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  `uptime` int(11) unsigned NOT NULL default '0',
  `template` varchar(100) NOT NULL,
  `filename` varchar(100) NOT NULL default '',
  `filepath` varchar(200) NOT NULL default '',
  `filepage` smallint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`did`),
  UNIQUE KEY `tid` (`did`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_document_album` (
  `daid` int(11) NOT NULL auto_increment,
  `did` int(11) NOT NULL,
  `picname` varchar(200) NOT NULL default '',
  `filedes` text NOT NULL,
  `picfile` varchar(150) NOT NULL,
  `addtime` int(11) NOT NULL default '0',
  PRIMARY KEY  (`daid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_document_attr` (
  `datid` int(11) unsigned NOT NULL auto_increment,
  `did` int(11) NOT NULL default '0',
  PRIMARY KEY  (`datid`,`did`),
  UNIQUE KEY `daid` (`datid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_document_content` (
  `dcid` int(11) NOT NULL auto_increment,
  `did` int(11) NOT NULL,
  `content` longtext NOT NULL,
  PRIMARY KEY  (`dcid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_document_label` (
  `dlid` int(10) unsigned NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL,
  `mid` int(11) NOT NULL default '0',
  `labelname` varchar(100) NOT NULL,
  PRIMARY KEY  (`dlid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_document_message` (
  `dmid` int(11) unsigned NOT NULL auto_increment,
  `did` int(11) unsigned NOT NULL default '0',
  `userid` int(11) unsigned NOT NULL default '0',
  `adminid` int(11) unsigned NOT NULL default '0',
  `ipadd` varchar(11) NOT NULL default '0',
  `lng` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `recontent` text NOT NULL,
  `isreply` tinyint(1) unsigned NOT NULL default '0',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `addtime` int(11) unsigned NOT NULL default '0',
  `retime` int(11) unsigned NOT NULL default '0',
  `support` int(7) unsigned NOT NULL default '0',
  `oppose` int(7) unsigned NOT NULL default '0',
  UNIQUE KEY `dmid` (`dmid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_document_model` (
  `mid` int(11) NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL default 'cn',
  `modelname` varchar(150) NOT NULL,
  `pagemax` smallint(3) unsigned NOT NULL default '20',
  `tsnstyle` varchar(100) NOT NULL default 'SN{datetime}{s}',
  `listtitlestyle` varchar(100) NOT NULL default '{typename}-{sitename}',
  `readtitlestyle` varchar(100) NOT NULL default '{title}-{typename}-{sitename}',
  `index_templates` varchar(100) NOT NULL,
  `list_templates` varchar(100) NOT NULL,
  `read_templates` varchar(100) NOT NULL,
  `pagesylte` tinyint(1) unsigned NOT NULL default '1',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `lockin` tinyint(1) unsigned NOT NULL default '1',
  `isbase` tinyint(1) unsigned NOT NULL default '0',
  `istsn` tinyint(1) unsigned NOT NULL default '1',
  `isalbum` tinyint(1) unsigned NOT NULL default '1',
  `isextid` tinyint(1) unsigned NOT NULL default '1',
  `issid` tinyint(1) unsigned NOT NULL default '1',
  `isfgid` tinyint(1) unsigned NOT NULL default '1',
  `islinkdid` tinyint(1) unsigned NOT NULL default '1',
  `isorder` tinyint(1) unsigned NOT NULL default '1',
  `ismessage` tinyint(1) unsigned NOT NULL default '1',
  `ispurview` tinyint(1) unsigned NOT NULL default '1',
  `isques` tinyint(1) unsigned NOT NULL default '0',
  `addtime` int(10) unsigned NOT NULL,
  `opid` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_document_model_att` (
  `aid` int(11) NOT NULL auto_increment,
  `pid` smallint(5) unsigned NOT NULL default '0',
  `mid` smallint(5) unsigned NOT NULL default '0',
  `typename` varchar(100) NOT NULL default '',
  `typeremark` varchar(200) NOT NULL default '',
  `attrname` varchar(100) NOT NULL default '',
  `inputtype` varchar(15) NOT NULL default 'string',
  `attrvalue` text NOT NULL,
  `attrsize` smallint(3) unsigned NOT NULL default '20',
  `attrrow` smallint(3) unsigned NOT NULL default '5',
  `attrlenther` smallint(3) unsigned NOT NULL default '50',
  `isvalidate` tinyint(1) unsigned NOT NULL default '0',
  `validatetext` varchar(150) NOT NULL default '',
  `validate_str` varchar(200) NOT NULL,
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `issearch` tinyint(1) unsigned NOT NULL default '0',
  `lockin` tinyint(1) unsigned NOT NULL default '0',
  `islockin` tinyint(1) unsigned NOT NULL default '0',
  `issys` tinyint(1) unsigned NOT NULL default '0',
  `iscover` tinyint(1) unsigned NOT NULL default '0',
  `isdel` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_document_subjectlist` (
  `sid` int(10) unsigned NOT NULL auto_increment,
  `pid` int(10) unsigned NOT NULL default '0',
  `mid` smallint(5) unsigned NOT NULL default '0',
  `lng` varchar(50) NOT NULL default 'cn',
  `subjectname` varchar(150) NOT NULL,
  `headtitle` varchar(200) NOT NULL,
  `keywords` varchar(80) NOT NULL,
  `description` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `subpic` varchar(200) NOT NULL default '',
  `isdir` tinyint(1) unsigned NOT NULL default '1',
  `dirname` varbinary(150) NOT NULL default '',
  `purview` varchar(200) NOT NULL default '1',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `styleid` tinyint(1) unsigned NOT NULL default '1',
  `ishtml` tinyint(1) unsigned NOT NULL default '1',
  `iswap` tinyint(1) unsigned NOT NULL default '0',
  `waptempalte` varchar(100) NOT NULL,
  `indextemplates` varchar(100) NOT NULL,
  `template` varchar(100) NOT NULL,
  `filenamestyle` varchar(100) NOT NULL,
  `dirpath` varchar(200) NOT NULL,
  `pagemax` smallint(5) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_document_typelist` (
  `tid` int(10) unsigned NOT NULL auto_increment,
  `pid` smallint(5) unsigned NOT NULL default '50',
  `mid` smallint(5) unsigned NOT NULL default '0',
  `topid` smallint(5) unsigned NOT NULL default '0',
  `upid` smallint(5) unsigned NOT NULL default '0',
  `linkid` int(11) unsigned NOT NULL default '0',
  `gotoid` int(11) unsigned NOT NULL default '0',
  `lng` varchar(50) NOT NULL default 'cn',
  `typename` varchar(150) NOT NULL,
  `content` text NOT NULL,
  `headtitle` varchar(200) NOT NULL,
  `keywords` varchar(80) NOT NULL default '',
  `description` varchar(180) NOT NULL,
  `typepic` varchar(200) NOT NULL,
  `isdir` tinyint(1) unsigned NOT NULL default '0',
  `dirname` varchar(50) NOT NULL default '',
  `purview` varchar(200) NOT NULL default '0',
  `ismenu` tinyint(1) unsigned NOT NULL default '0',
  `isaccessory` tinyint(1) unsigned NOT NULL default '0',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `ispart` tinyint(1) unsigned NOT NULL default '1',
  `styleid` tinyint(1) unsigned NOT NULL default '1',
  `pageclass` tinyint(1) unsigned NOT NULL default '1',
  `indextemplates` varchar(100) NOT NULL,
  `template` varchar(100) NOT NULL,
  `readtemplate` varchar(100) NOT NULL,
  `filenamestyle` varchar(100) NOT NULL default '',
  `readnamestyle` varchar(100) NOT NULL,
  `isline` tinyint(1) unsigned NOT NULL default '1',
  `gotoline` int(11) unsigned NOT NULL default '0',
  `typeurl` varchar(200) NOT NULL,
  `iswap` tinyint(1) unsigned zerofill NOT NULL default '0',
  `waptempalte` varchar(100) NOT NULL,
  `wapreadtemplate` varchar(100) NOT NULL,
  `pagemax` smallint(5) unsigned NOT NULL default '0',
  `addtime` int(15) unsigned NOT NULL default '0',
  `isorderby` tinyint(1) unsigned NOT NULL default '1',
  `ordertype` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`tid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_file` (
  `file_id` int(11) unsigned NOT NULL auto_increment,
  `admin_member_id` int(11) unsigned NOT NULL default '0',
  `filedir_id` int(11) unsigned NOT NULL default '0',
  `file_title` varchar(200) NOT NULL default '',
  `file_filename` varchar(200) NOT NULL default '',
  `file_ext` varchar(80) NOT NULL default '',
  `file_type` varchar(50) NOT NULL default 'image',
  `file_path` varchar(200) NOT NULL default '',
  `file_size` int(11) unsigned NOT NULL default '0',
  `file_addtime` int(11) unsigned NOT NULL default '0',
  `file_iswidth` tinyint(1) unsigned NOT NULL default '0',
  `file_isclass` tinyint(1) unsigned NOT NULL default '1',
  UNIQUE KEY `picid` (`file_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_filedir` (
  `filedir_id` int(11) unsigned NOT NULL auto_increment,
  `filedir_pid` int(11) unsigned NOT NULL default '0',
  `filedir_lastid` int(11) unsigned NOT NULL default '0',
  `filedir_name` varchar(200) NOT NULL,
  `filedir_content` varchar(200) NOT NULL,
  `filedir_size` int(200) unsigned NOT NULL,
  `filedir_addtime` int(11) unsigned NOT NULL default '0',
  `filedir_isclass` tinyint(1) unsigned NOT NULL default '0',
  `filedir_isdir` tinyint(1) unsigned NOT NULL default '0',
  `filedir_path` varchar(200) NOT NULL,
  `filedir_dirname` varchar(200) NOT NULL,
  UNIQUE KEY `filedir_id` (`filedir_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_keylink` (
  `kid` int(11) unsigned NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL default 'cn',
  `pid` int(11) unsigned NOT NULL default '50',
  `mid` int(11) unsigned NOT NULL default '0',
  `tid` int(11) unsigned NOT NULL default '0',
  `hit` smallint(5) unsigned NOT NULL default '0',
  `keywordname` varchar(200) NOT NULL default '',
  `linkurl` varchar(220) NOT NULL default '',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `istop` tinyint(1) unsigned NOT NULL default '0',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `isreplace` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`kid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `esp_keylink_type` (
  `ktid` int(10) unsigned NOT NULL auto_increment,
  `lng` varchar(20) NOT NULL,
  `mid` int(11) unsigned NOT NULL default '0',
  `tid` int(11) unsigned NOT NULL default '0',
  `keytypename` varchar(200) NOT NULL default '',
  `keyworklist` text NOT NULL,
  `description` text NOT NULL,
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  UNIQUE KEY `ktid` (`ktid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `esp_lng` (
  `lan_id` int(10) unsigned NOT NULL auto_increment,
  `pid` tinyint(10) unsigned NOT NULL default '0',
  `lng` varchar(50) NOT NULL default '',
  `lngtitle` varchar(100) NOT NULL default '',
  `islink` tinyint(1) unsigned NOT NULL default '0',
  `url` varchar(200) NOT NULL default '',
  `lockin` tinyint(1) unsigned NOT NULL default '0',
  `iswap` tinyint(1) unsigned NOT NULL default '0',
  `isopen` tinyint(1) unsigned NOT NULL default '1',
  `isuptype` tinyint(1) unsigned NOT NULL,
  `ispack` tinyint(1) unsigned NOT NULL default '0',
  `packname` varchar(100) NOT NULL,
  PRIMARY KEY  (`lan_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_lngpack` (
  `lpid` int(11) unsigned NOT NULL auto_increment,
  `pid` smallint(5) NOT NULL default '50',
  `lng` varchar(50) NOT NULL default 'cn',
  `title` varchar(150) NOT NULL,
  `keycode` varchar(50) NOT NULL default '',
  `langstr` text NOT NULL,
  `lockin` tinyint(1) NOT NULL default '1',
  `typeid` tinyint(1) NOT NULL default '1',
  `typeclass` varchar(50) NOT NULL,
  UNIQUE KEY `lpid` (`lpid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_logs` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `admin_member_id` int(11) unsigned NOT NULL default '0',
  `user_log_ip` int(15) NOT NULL,
  `user_log_time` int(11) NOT NULL,
  `user_log_action` varchar(200) NOT NULL default '',
  `user_log_remarks` varchar(200) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_member` (
  `userid` int(11) unsigned NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL,
  `weixin_openid` varchar(80) NOT NULL,
  `qq_openid` varchar(80) NOT NULL,
  `alipay_openid` varchar(80) NOT NULL,
  `weibo_openid` int(11) unsigned NOT NULL DEFAULT '0',
  `username` varchar(100) NOT NULL default '',
  `password` varchar(100) NOT NULL default '',
  `email` varchar(250) NOT NULL default '',
  `mobile` varchar(20) NOT NULL default '0',
  `question` varchar(250) NOT NULL default '',
  `answer` varchar(250) NOT NULL default '',
  `pic` varchar(150) NOT NULL default '',
  `sex` tinyint(1) unsigned NOT NULL default '0',
  `birthday` int(11) unsigned NOT NULL default '0',
  `country` varchar(20) NOT NULL,
  `province` varchar(20) NOT NULL,
  `city` varchar(20) NOT NULL,
  `district` varchar(20) NOT NULL,
  `alias` varchar(250) NOT NULL default '',
  `address` varchar(250) NOT NULL default '',
  `zipcode` varchar(20) NOT NULL default '0',
  `tel` varchar(30) NOT NULL default '',
  `qq` int(11) unsigned NOT NULL default '0',
  `weixin` varchar(150) NOT NULL default '',
  `integral` int(10) unsigned NOT NULL default '0',
  `visitcount` smallint(6) unsigned NOT NULL default '0',
  `lastip` varchar(11) NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  `lasttime` int(11) unsigned NOT NULL default '0',
  `outtime` int(11) unsigned NOT NULL default '0',
  `updatetime` int(11) unsigned NOT NULL default '0',
  `mcid` smallint(2) unsigned NOT NULL default '1',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `ismoblie` tinyint(1) unsigned NOT NULL default '0',
  `ismoblietime` int(11) unsigned NOT NULL default '0',
  `isemail` tinyint(1) unsigned NOT NULL default '0',
  `isemailtime` int(11) unsigned NOT NULL default '0',
  `isqq` tinyint(1) unsigned NOT NULL default '0',
  `isweixin` tinyint(1) unsigned NOT NULL default '0',
  `mobliesn` varchar(10) NOT NULL default '',
  `mobliesntime` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_member_attr` (
  `maid` int(11) unsigned NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL default '',
  `pid` smallint(6) unsigned NOT NULL default '50',
  `typename` varchar(150) NOT NULL default '',
  `typeremark` varchar(200) NOT NULL,
  `attrname` varchar(150) NOT NULL default '',
  `inputtype` varchar(20) NOT NULL default 'string',
  `attrvalue` text NOT NULL,
  `validatetext` varchar(150) NOT NULL default '',
  `validate_str` varchar(200) NOT NULL,
  `attrsize` smallint(3) unsigned NOT NULL default '20',
  `attrrow` smallint(3) unsigned NOT NULL default '10',
  `attrlenther` smallint(3) unsigned NOT NULL default '50',
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `isvalidate` tinyint(1) unsigned NOT NULL default '0',
  `isline` tinyint(1) unsigned NOT NULL default '0',
  `isreg` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`maid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_member_class` (
  `mcid` int(10) unsigned NOT NULL auto_increment,
  `rankname` varchar(150) NOT NULL,
  `isinter` tinyint(1) NOT NULL default '0',
  `integra` int(11) NOT NULL default '100',
  `isclass` tinyint(1) NOT NULL default '1',
  `lockin` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`mcid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_member_integral` (
  `member_integral_id` int(11) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `member_integral_sn` varchar(30) NOT NULL,
  `member_integral` int(8) unsigned NOT NULL default '0',
  `member_integral_type` tinyint(1) unsigned NOT NULL default '1',
  `member_integral_name` varchar(150) NOT NULL,
  `member_integral_addtime` int(11) unsigned NOT NULL default '0',
  `member_integral_ip` varchar(50) NOT NULL,
  UNIQUE KEY `member_integral_id` (`member_integral_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `esp_member_login` (
  `member_login_id` int(11) unsigned NOT NULL auto_increment,
  `userid` int(10) unsigned NOT NULL,
  `login_time` int(11) unsigned NOT NULL default '0',
  `login_ip` int(50) unsigned NOT NULL default '0',
  `login_type` varchar(50) NOT NULL default 'web',
  `login_content` varchar(200) NOT NULL,
  UNIQUE KEY `member_login_id` (`member_login_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `esp_member_value` (
  `mvid` int(11) NOT NULL auto_increment,
  `userid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`mvid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `esp_menulink` (
  `menu_id` int(10) unsigned NOT NULL auto_increment,
  `menu_pid` smallint(6) unsigned NOT NULL default '50',
  `menu_upid` smallint(6) unsigned NOT NULL default '0',
  `menu_name` varchar(100) NOT NULL default '',
  `menu_title` varchar(100) NOT NULL,
  `menu_dirname` varchar(100) NOT NULL,
  `menu_classname` varchar(100) NOT NULL default '',
  `menu_module` varchar(100) NOT NULL,
  `menu_isshow` tinyint(1) unsigned NOT NULL default '1',
  `menu_isclass` tinyint(1) unsigned NOT NULL default '1',
  `menu_isview` tinyint(1) unsigned NOT NULL default '0',
  `menu_isedit` tinyint(1) unsigned NOT NULL default '0',
  `menu_isdel` tinyint(1) unsigned NOT NULL default '0',
  `menu_isleft` tinyint(1) unsigned NOT NULL default '0',
  `menu_left_modul` varchar(200) NOT NULL,
  PRIMARY KEY  (`menu_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_nevigate` (
  `nevigate_id` int(11) unsigned NOT NULL auto_increment,
  `nevigate_pid` smallint(5) unsigned NOT NULL,
  `nevigate_topid` int(11) unsigned NOT NULL default '0',
  `nevigate_uid` int(11) unsigned NOT NULL default '0',
  `lng` varchar(50) NOT NULL,
  `nevigate_name` varchar(200) NOT NULL,
  `nevigate_linkid` int(11) unsigned NOT NULL default '0',
  `nevigate_modul` varchar(50) NOT NULL default 'article',
  `nevigate_linktype` tinyint(1) unsigned NOT NULL default '1',
  `nevigate_url` varchar(200) NOT NULL default '',
  `nevigate_target` tinyint(1) unsigned NOT NULL default '0',
  `nevigate_iswap` tinyint(1) unsigned NOT NULL default '0',
  `nevigate_isaccessory` tinyint(1) unsigned NOT NULL default '0',
  `nevigate_ismenu` tinyint(1) unsigned NOT NULL default '0',
  UNIQUE KEY `nevigate_id` (`nevigate_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_order` (
  `oid` int(10) unsigned NOT NULL auto_increment,
  `ordersn` varchar(50) NOT NULL,
  `userid` int(10) unsigned NOT NULL default '0',
  `order_source` varchar(20) NOT NULL default 'web',
  `ordertype` tinyint(1) unsigned NOT NULL default '1',
  `islock` tinyint(1) unsigned NOT NULL default '0',
  `ispay` tinyint(1) unsigned NOT NULL default '0',
  `isshipping` tinyint(1) unsigned NOT NULL default '0',
  `isinvoice` tinyint(1) unsigned NOT NULL default '0',
  `osid` smallint(6) unsigned NOT NULL default '0',
  `opid` smallint(6) unsigned NOT NULL default '0',
  `paytype` tinyint(1) unsigned NOT NULL default '1',
  `shiptype` tinyint(1) unsigned NOT NULL default '1',
  `shippingsn` varchar(50) NOT NULL,
  `paysn` varchar(50) NOT NULL,
  `consignee` varchar(50) NOT NULL,
  `country` varchar(50) NOT NULL,
  `province` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `district` varchar(50) NOT NULL,
  `address` varchar(255) NOT NULL,
  `zipcode` varchar(20) NOT NULL,
  `tel` varchar(20) NOT NULL,
  `mobile` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `invpayee` varchar(100) NOT NULL default '',
  `companysn` varchar(50) NOT NULL,
  `invcontent` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `treatnote` text NOT NULL,
  `paytime` int(11) unsigned NOT NULL default '0',
  `shippingtime` int(11) unsigned NOT NULL default '0',
  `productmoney` decimal(10,2) unsigned NOT NULL default '0.00',
  `shippingmoney` decimal(10,2) unsigned NOT NULL default '0.00',
  `paymoney` decimal(10,2) unsigned NOT NULL default '0.00',
  `invoicefeemoney` decimal(10,2) unsigned NOT NULL default '0.00',
  `orderamount` decimal(10,2) unsigned NOT NULL default '0.00',
  `discount` decimal(10,2) unsigned NOT NULL default '0.00',
  `integral` int(10) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  `updatetime` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`oid`),
  UNIQUE KEY `ordersn` (`ordersn`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_order_info` (
  `oiid` int(11) NOT NULL auto_increment,
  `oid` int(10) unsigned NOT NULL,
  `did` int(10) unsigned NOT NULL,
  `tsn` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `oprice` decimal(10,2) unsigned NOT NULL default '0.00',
  `bprice` decimal(10,2) unsigned NOT NULL default '0.00',
  `countprice` decimal(10,2) NOT NULL default '0.00',
  `amount` smallint(6) unsigned NOT NULL,
  `inventory` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`oiid`),
  KEY `orderid` (`oid`),
  KEY `productid` (`did`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_order_pay` (
  `opid` int(11) NOT NULL auto_increment,
  `pid` int(11) unsigned NOT NULL default '50',
  `payname` varchar(150) NOT NULL,
  `paycontent` text NOT NULL,
  `paycode` varchar(20) NOT NULL,
  `paypic` varchar(100) NOT NULL,
  `payis` smallint(5) unsigned NOT NULL default '0',
  `payplugver` varchar(20) NOT NULL default '1.0',
  `pluglist` text NOT NULL,
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `addtime` int(11) unsigned NOT NULL default '0',
  `ismoblie` tinyint(1) unsigned NOT NULL default '0',
  `isonlinepay` tinyint(1) unsigned NOT NULL default '1',
  `isqrcode` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`opid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

CREATE TABLE IF NOT EXISTS `esp_order_payreceipt` (
  `oprid` int(10) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `oid` int(11) unsigned NOT NULL default '0',
  `paytype` tinyint(1) unsigned NOT NULL default '1',
  `opid` int(11) unsigned NOT NULL default '0',
  `paysn` varchar(100) NOT NULL default '0',
  `payamount` decimal(10,2) unsigned NOT NULL default '0.00',
  `bankaccount` varchar(100) NOT NULL default '',
  `bankname` varchar(100) NOT NULL default '',
  `content` text NOT NULL,
  `payclass` tinyint(1) unsigned NOT NULL default '1',
  `paytime` int(11) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`oprid`),
  KEY `orderid` (`oid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_order_shipping` (
  `osid` int(11) NOT NULL auto_increment,
  `pid` int(10) unsigned NOT NULL default '50',
  `shippingname` varchar(80) NOT NULL default '',
  `shippingpic` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `price` decimal(10,2) unsigned NOT NULL default '0.00',
  `markup` decimal(10,2) unsigned NOT NULL default '0.00',
  `isclass` tinyint(1) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`osid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_order_shipreceipt` (
  `osrid` int(10) unsigned NOT NULL auto_increment,
  `userid` int(11) unsigned NOT NULL default '0',
  `oid` int(11) unsigned NOT NULL default '0',
  `osid` int(11) unsigned NOT NULL default '0',
  `shippingsn` varchar(20) NOT NULL default '0',
  `content` text NOT NULL,
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  `addtime` int(11) unsigned NOT NULL default '0',
  `sendtime` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`osrid`),
  KEY `orderid` (`oid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_power_groups` (
  `power_groups_id` int(11) unsigned NOT NULL auto_increment,
  `power_groups_name` varchar(200) NOT NULL default '',
  `power_groups_function` text NOT NULL,
  `power_groups_view` text NOT NULL,
  `power_groups_edit` text NOT NULL,
  `power_groups_del` text NOT NULL,
  `power_groups_issystem` tinyint(1) unsigned NOT NULL default '0',
  `power_groups_isdel` tinyint(1) unsigned NOT NULL default '1',
  `power_groups_addtime` int(11) unsigned NOT NULL default '0',
  UNIQUE KEY `powergroup_id` (`power_groups_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_site` (
  `slid` int(11) unsigned NOT NULL auto_increment,
  `pid` smallint(5) unsigned NOT NULL default '50',
  `sitename` varchar(100) NOT NULL,
  `sitehttp` varchar(100) NOT NULL,
  `sitedir` varchar(30) NOT NULL default 'adminsoft',
  `sitecode` varchar(100) NOT NULL,
  `siteip` varchar(50) NOT NULL,
  `adminusername` varchar(50) NOT NULL,
  `addtime` int(11) NOT NULL default '0',
  UNIQUE KEY `slid` (`slid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `esp_skin` (
  `skid` int(11) unsigned NOT NULL auto_increment,
  `skin_name` varchar(50) NOT NULL default '',
  `skin_code` varchar(50) NOT NULL default '',
  `islockin` tinyint(1) unsigned NOT NULL default '0',
  `isclass` tinyint(1) unsigned NOT NULL default '0',
  `addtime` int(11) unsigned NOT NULL,
  `iswap` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`skid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_templates` (
  `tmid` int(11) unsigned NOT NULL auto_increment,
  `lng` varchar(50) NOT NULL default 'cn',
  `templatename` varchar(200) NOT NULL,
  `templatecode` varchar(100) NOT NULL,
  `title` varchar(200) NOT NULL default '',
  `templatecontent` text NOT NULL,
  `typeclass` varchar(15) NOT NULL default '',
  `styleclass` varchar(50) NOT NULL default 'email',
  `lockin` tinyint(1) unsigned NOT NULL default '1',
  `addtime` int(11) unsigned NOT NULL,
  `isclass` tinyint(1) unsigned NOT NULL default '1',
  PRIMARY KEY  (`tmid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_widget` (
  `widget_id` int(11) unsigned NOT NULL auto_increment,
  `widget_pid` smallint(5) unsigned NOT NULL default '0',
  `widget_name` varchar(100) NOT NULL default '',
  `widget_code` varchar(50) NOT NULL,
  `widget_file` varchar(80) NOT NULL default '',
  `widget_fun` varchar(80) NOT NULL default '',
  `widget_list` varchar(100) NOT NULL,
  `widget_link` varchar(100) NOT NULL,
  `widget_isopen` tinyint(1) unsigned NOT NULL default '1',
  `widget_isclose` tinyint(1) unsigned NOT NULL default '1',
  UNIQUE KEY `widget_id` (`widget_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;


CREATE TABLE IF NOT EXISTS `esp_widget_bt` (
  `widget_bt_id` int(11) unsigned NOT NULL auto_increment,
  `widget_bt_pid` smallint(5) unsigned NOT NULL default '0',
  `widget_bt_name` varchar(100) NOT NULL default '',
  `widget_bt_code` varchar(50) NOT NULL,
  `widget_bt_icon` varchar(50) NOT NULL,
  `widget_bt_link` varchar(100) NOT NULL,
  `widget_bt_isopen` tinyint(1) unsigned NOT NULL default '1',
  UNIQUE KEY `widget_bt_id` (`widget_bt_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
