<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

namespace modul_application;

use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_ArticleModelDB;
use modul_application\KeywordsOptimizationDB;
use inc_application\link\ArticleLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;

class ESPCMS_ArticleCreateDB {

	public static function creat_document_html($did = 0, $creat_lng = false) {
		global $espcms_command;
		if (!$creat_lng || !preg_match("/^[a-z0-9]{2,50}$/i", $creat_lng)) {
			return false;
		}
		if (!$did || !espcms_ismatches($did) || $espcms_command['IS_HTML']) {
			return false;
		}
		define("ESPCMS_CREAT", $creat_lng);
		$espcms_web_templates = espcms_web_template($creat_lng);
		$db_table = ESPCMS_DB_PREFIX . "document";
		$doc_read = ESPCMS_ArticleDB::get_article_read($did);
		if (!$doc_read || !$doc_read['isclass'] || $doc_read['ishtml'] == 2 || $doc_read['islink']) {
			return false;
		}
		$doc_read['link'] = ArticleLink::doc_link($doc_read);
		$doc_read['click_link'] = ArticleLink::doc_js_link('click', $doc_read);
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
		$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($doc_read['tid']);
		if (!$type_read || !$type_read['isclass'] || $type_read['pageclass'] == 2) {
			return false;
		}
		$type_read['link'] = ArticleLink::type_link($type_read);
		$type_read['purview_link'] = ArticleLink::doc_js_link('readpuv', $doc_read);
		if (empty($type_read['mid']) || !espcms_ismatches($type_read['mid'])) {
			return false;
		}
		$model_read = ESPCMS_ArticleModelDB::get_mid_view($type_read['mid']);
		if (!empty($doc_read['linkdid'])) {
			$doc_read['linkdid'] = str_replace(',', '/', $doc_read['linkdid']);
		}
		if ($doc_read['votelink']) {
			$doc_read['votelink'] = str_replace(',', '/', $doc_read['votelink']);
		}
		if ($order_app_config['isetup'] && $order_app_config['isopen']) {
			$doc_read['buylink'] = OrderLink::get_order_link('buy', $doc_read);
		}
		if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
			$doc_read['enqlink'] = EnquiryLink::get_enquiry_link('into', $doc_read);
		}
		$doc_read['ctitle'] = empty($doc_read['color']) ? $doc_read['title'] : "<font color='" . $doc_read['color'] . "'>" . $doc_read['title'] . "</font>";
		$attr_read = ESPCMS_ArticleDB::get_article_attr_read($did);
		$read = is_array($attr_read) ? array_merge($doc_read, $attr_read) : $doc_read;
		$lanpack = $espcms_web_templates->geto('lngpack');
		if ($doc_read['headtitle']) {
			$str_replace_keyArray = array('{title}' => $doc_read['headtitle'], '{typename}' => $type_read['typename'], '{sitename}' => $lanpack['sitename']);
		} else {
			$str_replace_keyArray = array('{title}' => $doc_read['title'], '{typename}' => $type_read['typename'], '{sitename}' => $lanpack['sitename']);
		}
		$lanpack['sitename'] = format_array_replace_string($model_read['readtitlestyle'], $str_replace_keyArray);
		if ($doc_read['keywords']) {
			$lanpack['keyword'] = $doc_read['keywords'];
		}
		if ($doc_read['description']) {
			$lanpack['description'] = $doc_read['description'];
		}
		$espcms_web_templates->into('lngpack', $lanpack);
		$tag = KeywordsOptimizationDB::get_key_link($doc_read['keywords']);
		$espcms_web_templates->into('tag', $tag);
		$photo_read = ESPCMS_ArticleDB::get_document_album_list($did);
		$espcms_web_templates->into('photo', $photo_read);
		if ($doc_read['template'] && $doc_read['istemplates']) {
			$template_read = $doc_read['template'];
		} else {
			$template_read = $type_read['readtemplate'] ? $type_read['readtemplate'] : $model_read['read_templates'];
		}
		$current = !$type_read['upid'] ? $type_read['tid'] : $type_read['topid'];
		$espcms_web_templates->into('current', $current);
		$espcms_web_templates->into('hover_id', $type_read['tid']);
		$espcms_web_templates->into('doc_id', $read['did']);
		$espcms_web_templates->into('type', $type_read);
		$espcms_web_templates->into('path', 'article');
		$html_dir = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];
		$lan_read = ESPCMS_Core::get_lan_view($creat_lng);
		$lan_dirname = $lan_read['ispack'] && $lan_read['packname'] ? $lan_read['packname'] : $lan_read['lng'];
		if (!$espcms_command['IS_ALONELNG']) {
			$html_creat_path = $espcms_command['HOME_LNG'] == $creat_lng ? $html_dir : $html_dir . $lan_dirname . '/';
		} else {
			$html_creat_path = $html_dir . $lan_dirname . '/';
		}
		if (!is_dir($html_creat_path)) {
			if (!@mkdir($html_creat_path, 0777, true)) {
				return false;
			}
		}
		$doc_content = ESPCMS_ArticleDB::get_article_content_read($did, 'content');
		if ($doc_content) {
			$read['content'] = htmlspecialchars_decode($doc_content);
			$exCotnet = explode('<hr class="espcms_pagebreak"/>', $read['content']);
			$filepage = count($exCotnet);
		}
		if ($filepage > 1 && is_array($exCotnet)) {
			for ($page = 1; $page <= $filepage; $page++) {
				$pageArray = array();
				$nkey = $page + 1;
				$pkey = $page > 1 ? $page - 1 : 1;
				$read['page_key'] = $nkey;
				$read['nlink'] = $nkey <= $filepage ? ArticleLink::doc_link($read) : null;
				$read['page_key'] = $pkey;
				$read['plink'] = $page > 1 ? ArticleLink::doc_link($read) : null;
				for ($index = 0; $index < $filepage; $index++) {
					$num = $index + 1;
					$pageArray[$index]['num'] = $num;
					$pageArray[$index]['n'] = $num == $page ? 1 : 0;
					$read['page_key'] = $num;
					$pageArray[$index]['link'] = ArticleLink::doc_link($read);
				}
				$outkey = $page - 1;
				$read['content'] = $exCotnet[$outkey];
				$espcms_web_templates->into('page', $pageArray);
				$espcms_web_templates->into('read', $read);
				$read['page_key'] = $page;
				$file_name = ESPCMS_ArticleDB::update_article_filepath($read, $type_read);
				$file_dir = $html_creat_path . dirname($file_name);
				if (!is_dir($file_dir)) {
					if (!@mkdir($file_dir, 0777, true)) {
						return false;
					}
				}
				if ($page == 1) {
					espcms_db_update_set_save($db_table, "WHERE did=$did", "filepath='$file_name'");
				}
				$html_creat_file = $html_creat_path . $file_name;
				$html_start = $espcms_web_templates->output('article/' . $template_read, 'article_read', true, $html_creat_file);
			}
		} else {
			$espcms_web_templates->into('read', $read);
			$file_name = ESPCMS_ArticleDB::update_article_filepath($read, $type_read);
			$file_dir = $html_creat_path . dirname($file_name);
			if (!is_dir($file_dir)) {
				if (!@mkdir($file_dir, 0777, true)) {
					return false;
				}
			}
			espcms_db_update_set_save($db_table, "WHERE did=$did", "filepath='$file_name'");
			$html_creat_file = $html_creat_path . $file_name;
			$html_start = $espcms_web_templates->output('article/' . $template_read, 'article_read', true, $html_creat_file);
		}
		return $html_start;
	}

	public static function creat_index_html($creat_lng = false) {
		global$espcms_command;
		if (!$creat_lng || !preg_match("/^[a-z0-9]{2,50}$/i", $creat_lng) || $espcms_command['IS_HTML']) {
			return false;
		}
		define("ESPCMS_CREAT", $creat_lng);
		$espcms_web_templates = espcms_web_template($creat_lng);
		$espcms_web_templates->into('path', 'index');
		$html_dir = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];
		$lan_read = ESPCMS_Core::get_lan_view($creat_lng);
		$lan_dirname = $lan_read['ispack'] && $lan_read['packname'] ? $lan_read['packname'] : $lan_read['lng'];
		if (!$espcms_command['IS_ALONELNG']) {
			$html_creat_path = $espcms_command['HOME_LNG'] == $creat_lng ? $html_dir : $html_dir . $lan_dirname . '/';
		} else {
			$html_creat_path = $html_dir . $lan_dirname . '/';
		}
		if (!is_dir($html_creat_path)) {
			if (!@mkdir($html_creat_path, 0777, true)) {
				return false;
			}
		}
		if ($creat_lng == $espcms_command['HOME_LNG']) {
			$home_html_creat_file = ESPCMS_FILE_ROOT . $espcms_command['ENTRANCE_FILE'] . '.html';
			$home_html_start = $espcms_web_templates->output('index', 'index', true, $home_html_creat_file);
		}
		$html_creat_file = $html_creat_path . $espcms_command['ENTRANCE_FILE'] . '.html';
		$html_start = $espcms_web_templates->output('index', 'index', true, $html_creat_file);
		return $html_start;
	}

	public static function create_type_html($tid = 0, $creat_lng = false) {
		global $espcms_command, $espcms_link_db;
		if (!$creat_lng || !preg_match("/^[a-z0-9]{2,50}$/i", $creat_lng)) {
			return false;
		}
		if (!$tid || !espcms_ismatches($tid) || $espcms_command['IS_HTML']) {
			return false;
		}
		$lng = $creat_lng == 'big5' ? 'cn' : $creat_lng;
		define("ESPCMS_CREAT", $creat_lng);
		$espcms_web_templates = espcms_web_template($creat_lng);
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
		if (!$type_read || !$type_read['isclass'] || $type_read['pageclass'] == 2 || $type_read['styleid'] == 3 || $type_read['gotoid']) {
			return false;
		}
		$type_read['link'] = ArticleLink::type_link($type_read);
		$type_read['purview_link'] = ArticleLink::doc_js_link('typepuv', $type_read);
		if (!$type_read['mid'] || !espcms_ismatches($type_read['mid'])) {
			return false;
		}
		$model_read = ESPCMS_ArticleModelDB::get_mid_view($type_read['mid']);
		if ($type_read['pagemax'] && espcms_ismatches($type_read['pagemax'])) {
			$per_page_num = $type_read['pagemax'];
		} elseif ($model_read['pagemax'] && espcms_ismatches($model_read['pagemax'])) {
			$per_page_num = $model_read['pagemax'];
		} else {
			$per_page_num = 20;
		}
		$template_index = $type_read['indextemplates'] ? $type_read['indextemplates'] : $model_read['index_templates'];
		$template_list = $type_read['template'] ? $type_read['template'] : $model_read['list_templates'];
		$lanpack = $espcms_web_templates->geto('lngpack');
		if ($type_read['styleid'] != 4) {
			if ($type_read['headtitle']) {
				$str_replace_keyArray = array('{typename}' => $type_read['headtitle'], '{sitename}' => $lanpack['sitename']);
			} else {
				$str_replace_keyArray = array('{typename}' => $type_read['typename'], '{sitename}' => $lanpack['sitename']);
			}
			$lanpack['sitename'] = format_array_replace_string($model_read['listtitlestyle'], $str_replace_keyArray);
			if ($type_read['keywords']) {
				$lanpack['keyword'] = $type_read['keywords'];
			}
			if ($type_read['description']) {
				$lanpack['description'] = $type_read['description'];
			}
		}
		$current = !$type_read['upid'] ? $type_read['tid'] : $type_read['topid'];
		$espcms_web_templates->into('current', $current);
		$espcms_web_templates->into('hover_id', $type_read['tid']);
		$espcms_web_templates->into('type', $type_read);
		$espcms_web_templates->into('path', 'type');
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
		$html_dir = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];
		$lan_read = ESPCMS_Core::get_lan_view($creat_lng);
		$lan_dirname = $lan_read['ispack'] && $lan_read['packname'] ? $lan_read['packname'] : $lan_read['lng'];
		if (!$espcms_command['IS_ALONELNG']) {
			$html_creat_path = $espcms_command['HOME_LNG'] == $creat_lng ? $html_dir : $html_dir . $lan_dirname . '/';
		} else {
			$html_creat_path = $html_dir . $lan_dirname . '/';
		}
		if (!is_dir($html_creat_path)) {
			if (!@mkdir($html_creat_path, 0777, true)) {
				return false;
			}
		}
		if ($type_read['styleid'] == 1) {
			$espcms_web_templates->into('lngpack', $lanpack);
			$file_name = $espcms_command['ENTRANCE_FILE'] ? $type_read['dirname'] . '/' . $espcms_command['ENTRANCE_FILE'] . '.html' : $type_read['dirname'] . '/index.html';
			$file_dir = $html_creat_path . dirname($file_name);
			if (!is_dir($file_dir)) {
				if (!@mkdir($file_dir, 0777, true)) {
					return false;
				}
			}
			$html_creat_file = $html_creat_path . $file_name;
			$html_start = $espcms_web_templates->output('article/' . $template_index, 'article_index', true, $html_creat_file);
			return $html_start;
		} elseif ($type_read['styleid'] == 2) {
			$espcms_web_templates->into('lngpack', $lanpack);
			$db_where = " AND isclass=1 AND isbase=0";
			if ($type_read['ispart']) {
				$tid_array = ESPCMS_ArticleTypeDB::get_article_type_listDB($tid, $lng);
				$tid_list = implode(',', array_keys($tid_array));
				$db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
			} else {
				$db_where .= " AND tid=$tid";
			}
			$db_where .= " OR FIND_IN_SET('$tid',extid)";
			$db_num = espcms_db_num($db_table, $db_where);
			$order_rank = $type_read['isorderby'] ? 'DESC' : 'ASC';
			$order_key = $type_read['ordertype'] == 2 ? 'pid,addtime' : 'pid,did';
			$db_sql = espcms_db_list_out($db_table, $db_where);
			$page_num = $db_num && $per_page_num ? ceil($db_num / $per_page_num) : 1;
			$file_dir = $html_creat_path . $type_read['dirname'] . '/';
			if (!is_dir($file_dir)) {
				if (!@mkdir($file_dir, 0777, true)) {
					return false;
				}
			}
			for ($page_index = 1; $page_index <= $page_num; $page_index++) {
				if ($page_index > 1) {
					$fileArray = array(
					    'dirname' => $type_read['dirname'],
					    'tid' => $type_read['tid'],
					    'pageid' => $page_index
					);
					$type_read['filenamestyle'] = !$type_read['filenamestyle'] ? '{tid}_{pageid}' : $type_read['filenamestyle'];
					$file_name = $type_read['dirname'] . '/' . get_htmlfilename($type_read['filenamestyle'], $fileArray) . '.html';
				} else {
					$file_name = $espcms_command['ENTRANCE_FILE'] ? $type_read['dirname'] . '/' . $espcms_command['ENTRANCE_FILE'] . '.html' : $type_read['dirname'] . '/index.html';
				}
				$array = array();
				$espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $page_index, $model_read['pagesylte'], $lanpack['pagebotton'], 'inc_application\link\ArticleLink', 'type_link', $type_read);
				$sql = $espcms_page_button->sql_creat($order_key, $order_rank);
				$db_query = $espcms_link_db->db_query($sql);
				while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
					$fetch_row['ctitle'] = empty($fetch_row['color']) ? $fetch_row['title'] : "<font color='" . $fetch_row['color'] . "'>" . $fetch_row['title'] . "</font>";
					if ($fetch_row['tid'] != $tid) {
						$type_read_doc = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['tid']);
					} else {
						$type_read_doc = $type_read;
					}
					$fetch_row['ishtml'] = $type_read_doc['pageclass'] == 2 ? 2 : $fetch_row['ishtml'];
					$fetch_row['typename'] = $type_read_doc['typename'];
					$fetch_row['pageclass'] = $type_read_doc['pageclass'];
					$fetch_row['typelink'] = ArticleLink::type_link($type_read_doc);
					$fetch_row['link'] = ArticleLink::doc_link($fetch_row);
					if ($order_app_config['isetup'] && $order_app_config['isopen']) {
						$fetch_row['buylink'] = OrderLink::get_order_link('buy', $fetch_row);
					}
					if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
						$fetch_row['enqlink'] = EnquiryLink::get_enquiry_link('into', $fetch_row);
					}
					$attr_read = ESPCMS_ArticleDB::get_article_attr_read($fetch_row['did']);
					$array[] = is_array($attr_read) ? array_merge($fetch_row, $attr_read) : $fetch_row;
				}
				$espcms_web_templates->into('array', $array);
				$espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
				$espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
				$html_creat_file = $html_creat_path . $file_name;
				$html_start = $espcms_web_templates->output('article/' . $template_list, 'article_list', true, $html_creat_file);
			}
			return true;
		} elseif ($type_read['styleid'] == 4) {
			if ($type_read['gotoid'] && espcms_ismatches($type_read['gotoid'])) {
				$gotype_read = ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']);
				if (!$gotype_read || !$gotype_read['isclass']) {
					return false;
				}
				$linkid = $gotype_read['linkid'];
			} else {
				$linkid = $type_read['linkid'];
			}
			if (!$linkid || !espcms_ismatches($linkid)) {
				return false;
			}
			$html_start = self::creat_document_html($linkid, $creat_lng);
			return $html_start;
		}
	}

	public static function create_Special_html($sid = 0, $creat_lng = false) {
		global $espcms_command, $espcms_link_db;
		if (!$creat_lng || !preg_match("/^[a-z0-9]{2,50}$/i", $creat_lng)) {
			return false;
		}
		if (!$sid || !espcms_ismatches($sid) || $espcms_command['IS_HTML']) {
			return false;
		}
		define("ESPCMS_CREAT", $creat_lng);
		$espcms_web_templates = espcms_web_template($creat_lng);
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$sub_read = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($sid);
		if (!$sub_read || !$sub_read['isclass'] || $sub_read['ishtml'] == 2) {
			return false;
		}
		$sub_read['purview_link'] = ArticleLink::doc_js_link('subpuv', $sub_read);
		$sub_read['link'] = ArticleLink::subtype_link($sub_read);
		if (!$sub_read['mid'] || !espcms_ismatches($sub_read['mid'])) {
			return false;
		}
		$model_read = ESPCMS_ArticleModelDB::get_mid_view($sub_read['mid']);
		if ($sub_read['pagemax'] && espcms_ismatches($sub_read['pagemax'])) {
			$per_page_num = $sub_read['pagemax'];
		} elseif ($model_read['pagemax'] && espcms_ismatches($model_read['pagemax'])) {
			$per_page_num = $model_read['pagemax'];
		} else {
			$per_page_num = 20;
		}
		$html_dir = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];
		$lan_read = ESPCMS_Core::get_lan_view($creat_lng);
		$lan_dirname = $lan_read['ispack'] && $lan_read['packname'] ? $lan_read['packname'] : $lan_read['lng'];
		if (!$espcms_command['IS_ALONELNG']) {
			$html_creat_path = $espcms_command['HOME_LNG'] == $creat_lng ? $html_dir : $html_dir . $lan_dirname . '/';
		} else {
			$html_creat_path = $html_dir . $lan_dirname . '/';
		}
		if (!is_dir($html_creat_path)) {
			if (!@mkdir($html_creat_path, 0777, true)) {
				return false;
			}
		}
		$template_list = $sub_read['template'] ? $sub_read['template'] : $model_read['list_templates'];
		$lanpack = $espcms_web_templates->geto('lngpack');
		if ($sub_read['styleid'] != 4) {
			if ($sub_read['headtitle']) {
				$str_replace_keyArray = array('{typename}' => $sub_read['headtitle'], '{sitename}' => $lanpack['sitename']);
			} else {
				$str_replace_keyArray = array('{typename}' => $sub_read['typename'], '{sitename}' => $lanpack['sitename']);
			}
			$lanpack['sitename'] = format_array_replace_string($model_read['listtitlestyle'], $str_replace_keyArray);
			if ($sub_read['keywords']) {
				$lanpack['keyword'] = $sub_read['keywords'];
			}
			if ($sub_read['description']) {
				$lanpack['description'] = $sub_read['description'];
			}
		}
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('sub', $sub_read);
		$espcms_web_templates->into('path', 'sub');
		$espcms_web_templates->into('current', $sid);
		$espcms_web_templates->into('hover_id', $sub_read['sid']);
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
		$db_where = " AND isclass=1 AND isbase=0 AND sid=$sid";
		$db_num = espcms_db_num($db_table, $db_where);
		$db_sql = espcms_db_list_out($db_table, $db_where);
		$page_num = $db_num && $per_page_num ? ceil($db_num / $per_page_num) : 1;
		$file_dir = $html_creat_path . $sub_read['dirname'] . '/';
		if (!is_dir($file_dir)) {
			if (!@mkdir($file_dir, 0777, true)) {
				return false;
			}
		}
		for ($page_index = 1; $page_index <= $page_num; $page_index++) {
			if ($page_index > 1) {
				$fileArray = array(
				    'dirname' => $sub_read['dirname'],
				    'sid' => $sub_read['sid'],
				    'pageid' => $page_index
				);
				$sub_read['filenamestyle'] = !$sub_read['filenamestyle'] ? '{sid}_{pageid}' : $sub_read['filenamestyle'];
				$file_name = $sub_read['dirname'] . '/' . get_htmlfilename($sub_read['filenamestyle'], $fileArray) . '.html';
			} else {
				$file_name = $espcms_command['ENTRANCE_FILE'] ? $sub_read['dirname'] . '/' . $espcms_command['ENTRANCE_FILE'] . '.html' : $sub_read['dirname'] . '/index.html';
			}
			$array = array();
			$espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $page_index, $model_read['pagesylte'], $lanpack['pagebotton'], 'inc_application\link\ArticleLink', 'subtype_link', $sub_read);
			$sql = $espcms_page_button->sql_creat('pid,did', 'DESC');
			$db_query = $espcms_link_db->db_query($sql);
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['ctitle'] = empty($fetch_row['color']) ? $fetch_row['title'] : "<font color='" . $fetch_row['color'] . "'>" . $fetch_row['title'] . "</font>";
				$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['tid']);
				$fetch_row['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $fetch_row['ishtml'];
				$fetch_row['typename'] = $type_read['typename'];
				$fetch_row['typelink'] = ArticleLink::type_link($type_read);
				$fetch_row['link'] = ArticleLink::doc_link($fetch_row);
				if ($order_app_config['isetup'] && $order_app_config['isopen']) {
					$fetch_row['buylink'] = OrderLink::get_order_link('buy', $fetch_row);
				}
				if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
					$fetch_row['enqlink'] = EnquiryLink::get_enquiry_link('into', $fetch_row);
				}
				$attr_read = ESPCMS_ArticleDB::get_article_attr_read($fetch_row['did']);
				$array[] = is_array($attr_read) ? array_merge($fetch_row, $attr_read) : $fetch_row;
			}
			$espcms_web_templates->into('array', $array);
			$espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
			$espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
			$html_creat_file = $html_creat_path . $file_name;
			$html_start = $espcms_web_templates->output('article/' . $template_list, 'sub_list', true, $html_creat_file);
		}
		return $html_start;
	}

}
