<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

namespace modul_application;

class ESPCMS_ArticleDB {

	public static function get_article_read($did, $return_key = false) {
		if (empty($did) || !espcms_ismatches($did)) {
			return false;
		}
		$db_where = "WHERE did=$did";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_article_content_read($did, $return_key = false) {
		if (empty($did) || !espcms_ismatches($did)) {
			return false;
		}
		$db_where = "WHERE did=$did";
		$db_table = ESPCMS_DB_PREFIX . 'document_content';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_article_attr_read($did, $return_key = false) {
		if (empty($did) || !espcms_ismatches($did)) {
			return false;
		}
		$db_where = "WHERE did=$did";
		$db_table = ESPCMS_DB_PREFIX . 'document_attr';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_document_album_list($did, $order_field = 'daid', $limit = false) {
		if (empty($did) || !espcms_ismatches($did)) {
			return false;
		}
		$db_where = " AND did=$did";
		$db_table = ESPCMS_DB_PREFIX . 'document_album';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $order_field, $limit);
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function get_mid_view($mid = 0, $return_key = false) {
		global $espcms_db_cache;
		if (empty($mid) || !espcms_ismatches($mid)) {
			return false;
		}
		$db_where = "WHERE mid=$mid";
		$db_table = ESPCMS_DB_PREFIX . 'document_model';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $mid;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function update_article_click($did) {
		if (empty($did) || !espcms_ismatches($did)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document";
		$db_where = "WHERE did=$did";
		$update_key = espcms_db_update_set_save($db_table, $db_where, "click=click+1");
		return $update_key;
	}

	public static function get_article_list($did) {
		if (!preg_match("/^[\d]+[\d,]*$/i", $did)) {
			return false;
		}
		$db_where .= espcms_ismatches($did) ? " AND did=$did" : " AND did IN($did)";
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "did DESC");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function update_article_filepath($read = array(), $type_array = array()) {
		global $espcms_db_cache, $espcms_command;
		if (!$read['did'] || !espcms_ismatches($read['did']) || !$read['tid'] || !espcms_ismatches($read['tid'])) {
			return false;
		}
		$db_where = "WHERE tid=" . $read['tid'];
		$db_table = ESPCMS_DB_PREFIX . 'document_typelist';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $read['tid'];
		$type_read = $type_array && is_array($type_array) ? $type_array : $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$type_read) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$type_read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$type_read) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $type_read);
		}
		if ($read['isbase'] || $type_read['styleid'] == 4) {
			if (espcms_ismatches($read['page_key']) && $read['page_key'] && $read['page_key'] > 1) {
				$file_name = $espcms_command['ENTRANCE_FILE'] ? $type_read['dirname'] . '/' . $espcms_command['ENTRANCE_FILE'] . '_' . $read['page_key'] . '.html' : $type_read['dirname'] . '/index' . '_' . $read['page_key'] . '.html';
			} else {
				$file_name = $espcms_command['ENTRANCE_FILE'] ? $type_read['dirname'] . '/' . $espcms_command['ENTRANCE_FILE'] . '.html' : $type_read['dirname'] . '/index.html';
			}
		} else {

			$file_code = $read['filename'] ? $read['filename'] : $read['did'];
			$readfileArray = array(
			    'dirname' => $type_read['dirname'],
			    'tid' => $read['tid'],
			    'did' => $file_code,
			    'datetime' => date("YmdHis", $read['addtime']),
			    'data' => date("Ymd", $read['addtime']),
			    'y' => date("Y", $read['addtime']),
			    'm' => date("m", $read['addtime']),
			    'd' => date("d", $read['addtime'])
			);

			$type_read['readnamestyle'] = !$type_read['readnamestyle'] ? '{did}' : $type_read['readnamestyle'];
			if (espcms_ismatches($read['page_key']) && $read['page_key'] && $read['page_key'] > 1) {
				$file_name = $type_read['dirname'] . '/' . get_htmlfilename($type_read['readnamestyle'], $readfileArray) . '_' . $read['page_key'] . '.html';
			} else {
				$file_name = $type_read['dirname'] . '/' . get_htmlfilename($type_read['readnamestyle'], $readfileArray) . '.html';
			}
		}
		return $file_name;
	}

}
