<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace modul_application;

class ESPCMS_ArticleModelDB {

	public static function get_mid_view($mid = 0, $return_key = false) {
		global $espcms_db_cache;
		if (empty($mid) || !espcms_ismatches($mid)) {
			return false;
		}
		$db_where = "WHERE mid=$mid";
		$db_table = ESPCMS_DB_PREFIX . 'document_model';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $mid;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_document_model_att_list($mid = 0, $selectedid = true, $is_search = false) {
		global $espcms_link_db, $espcms_db_cache;
		if (empty($mid) || !espcms_ismatches($mid)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_model_att";
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $mid;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$array) {
			$db_sql = "SELECT * FROM (SELECT * FROM $db_table WHERE mid IN(0,$mid) ORDER BY aid DESC) AS MODELATTR GROUP BY attrname ORDER BY pid,aid";
			$db_query = $espcms_link_db->db_query($db_sql);
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				if ($fetch_row['isdel'] || !$fetch_row['isclass']) {
					continue;
				}
				$array[] = $fetch_row;
			}
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		if (is_array($array) && count($array) > 0) {
			$attr_array = array();

			foreach ($array as $att_id => $fetch_row) {
				if ($is_search && !$fetch_row['issearch']) {
					continue;
				}
				if ($fetch_row['inputtype'] == 'select' || $fetch_row['inputtype'] == 'radio' || $fetch_row['inputtype'] == 'checkbox') {
					$forvalue = preg_split("/\n/", $fetch_row['attrvalue']);
					$newvalue = array();
					foreach ($forvalue as $key => $value) {
						if ($key == 0 && $selectedid) {
							$newvalue[] = array('name' => trim($value), 'selected' => 'selected');
						} else {
							$newvalue[] = array('name' => trim($value), 'selected' => '');
						}
					}
					$fetch_row['attrvalue'] = $newvalue;
				}

				if ($fetch_row['inputtype'] == 'selectinput') {
					$forvalue = preg_split("/\n/", $fetch_row['attrvalue']);
					$selectinputvalue = array();
					foreach ($forvalue as $key => $value) {
						$selectinputvalue[] = array('name' => trim($value));
					}
					$fetch_row['selectinputvalue'] = $selectinputvalue;
				}
				$attr_array[] = $fetch_row;
			}
		}
		return $attr_array;
	}

}
