<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
 */

namespace modul_application;

use modul_application\ESPCMS_Dialog;
use inc_application\link\MemberLink;

class ESPCMS_MemberAuthority {

	public static function getMemberInfo($key_value = false, $return_type = 'user') {
		if (!in_array($return_type, array('user', 'info'))) {
			return false;
		}
		if ($return_type == 'user') {
			$espcms_user_info = $_COOKIE['espcms_web_user_info'];
			if ($espcms_user_info) {
				$espcms_user_info_array = espcms_decrypt($espcms_user_info, ESPCMS_ENCRYPT_CODE);
				return $key_value ? $espcms_user_info_array[$key_value] : $espcms_user_info_array;
			} else {
				return false;
			}
		}
		if ($return_type == 'info') {
			$espcms_user_login_info = $_COOKIE['espcms_web_server_info'];
			if ($espcms_user_login_info) {
				$espcms_user_login_info_array = espcms_decrypt($espcms_user_login_info, ESPCMS_ENCRYPT_CODE);
				return $key_value ? $espcms_user_login_info_array[$key_value] : $espcms_user_login_info_array;
			} else {
				return false;
			}
		}
	}

	public static function authorityWebVerify($status = false, $appconfig = false, $default_link = false) {
		$user_info = self::getMemberInfo();
		$user_server_info = self::getMemberInfo(false, 'info');
		$member_con = $appconfig ? unserialize($appconfig) : array();
		if ($user_info['username'] && espcms_ismatches($user_info['userid']) && espcms_ismatches($user_info['mcid'])) {
			if ($member_con['MEMBER_MOBLIE_VERIFY'] && !$user_info['ismoblie']) {
				if ($status) {
					return false;
				} else {
					ESPCMS_Dialog::Message_Page('ismoblie_check', MemberLink::get_link('binding'), 'bangtin_moblie');
				}
			} else {
				return true;
			}
		} else {
			if ($default_link) {
				espcms_set_cookie('espcms_web_login_link', espcms_encrypt($default_link, ESPCMS_ENCRYPT_CODE));
			}
			if ($status) {
				return false;
			} else {
				header('location:' . MemberLink::get_link('login'));
				exit();
			}
		}
	}

	public static function authorityRandVerify($purview = 0, $status = false) {
		if (!$purview || !espcms_islongfig($purview)) {
			return false;
		}
		self::authorityWebVerify($status);
		$user_info = self::getMemberInfo();
		if (espcms_ismatches($purview)) {
			if ($purview != $user_info['mcid']) {
				if ($status) {
					return false;
				} else {
					ESPCMS_Dialog::Message_Page('member_puv_err', MemberLink::get_link('login'));
				}
			} else {
				return true;
			}
		} elseif (espcms_islongfig($purview)) {
			$purview_array = explode(',', $purview);
			if (!in_array($user_info['mcid'], $purview_array)) {
				if ($status) {
					return false;
				} else {
					ESPCMS_Dialog::Message_Page('member_puv_err', MemberLink::get_link('login'));
				}
			} else {
				return true;
			}
		} else {
			if ($status) {
				return false;
			} else {
				ESPCMS_Dialog::Message_Page('member_puv_err', MemberLink::get_link('login'));
			}
		}
	}

}
