<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_SendMessage;
use inc_application\link\PublicLink;
use inc_application\link\MemberLink;

class Member {

	public static function in_Login() {
		global $espcms_web_templates, $espcms_command;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		if (ESPCMS_MemberAuthority::authorityWebVerify(true)) {
			header('location:' . MemberLink::get_link('center'));
			exit();
		}
		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('tokenkey', token('member_login'));
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('seccodelink', PublicLink::get_verfication('seccodelink'));
		$espcms_web_templates->into('verify_isopen', $member_con['MEMBER_LOGIN_VERIFY'] && $espcms_command['SAFETY_ISVERIFICATION_CODE'] ? 1 : 0);
		$espcms_web_templates->into('member_con', $member_con);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->output('member/member_login', 'member_login', false, false);
	}

	public static function in_LoginVerify() {
		global $espcms_command;
		$mlink = MemberLink::get_link();
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', $mlink['login']);
		}
		if ($member_con['MEMBER_LOGIN_VERIFY'] && $espcms_command['SAFETY_ISVERIFICATION_CODE']) {
			require_once( ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_VerificationCode.php' );
			$espcms_login_verification_code_cookie = $_COOKIE['espcms_web_login_verification_code'];
			if ($espcms_login_verification_code_cookie) {
				$espcms_login_verification_code = espcms_decrypt($espcms_login_verification_code_cookie, ESPCMS_ENCRYPT_CODE);
			} else {
				ESPCMS_Dialog::Message_Page('seescode_err', $mlink['login']);
			}
			$code = new ESPCMS_VerificationCode();
			$code->seccodeconvert($espcms_login_verification_code);
			$_POST['seccode'] = $_POST['seccode'] ? strtoupper($_POST['seccode']) : '';
			if ($espcms_login_verification_code != $_POST['seccode']) {
				ESPCMS_Dialog::Message_Page('seescode_err', $mlink['login']);
			}
		}
		if (!preg_match('/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u', $_POST['login_user']) && !espcms_ismoblie($_POST['login_user']) && !espcms_isemail($_POST['login_user'])) {
			ESPCMS_Dialog::Message_Page('input_err', $mlink['login']);
		}
		$login_user = $_POST['login_user'];
		$password_len = strlen($_POST['password']);
		if ($password_len < 6 || $password_len > 30) {
			ESPCMS_Dialog::Message_Page('password_input_err', $mlink['login']);
		}
		$password = md5($_POST['password']);
		if (preg_match('/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u', $_POST['login_user']) && !espcms_ismoblie($_POST['login_user'])) {
			$db_where = "WHERE username='$login_user' AND password='$password' AND isclass=1";
		} elseif (espcms_ismoblie($_POST['login_user'])) {
			$db_where = "WHERE mobile='$login_user' AND password='$password' AND isclass=1";
		} elseif (espcms_isemail($_POST['login_user'])) {
			$db_where = "WHERE email='$login_user' AND password='$password' AND isclass=1";
		} else {
			ESPCMS_Dialog::Message_Page('username_input_err', $mlink['login']);
		}
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$talbe_field_array = 'userid,lng,username,password,email,mobile,sex,country,weixin,integral,alias,visitcount,lastip,addtime,lasttime,updatetime,mcid,isclass,ismoblie,ismoblietime,isemail,isemailtime,isqq,isweixin';
		$user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
		if (!$user_read) {
			ESPCMS_Dialog::Message_Page('login_err', $mlink['login']);
		}
		if ($member_con['MEMBER_EMAIL_VERIFY'] && !$user_read['isemail']) {
			ESPCMS_Dialog::Message_Page('isemail_check', $mlink['checkmailsend'], 'checkemail_send');
		}
		$loack_user_array = explode(',', $member_con['MEMBER_REG_LOCK_USER']);
		if (is_array($loack_user_array) && in_array($user_read['username'], $loack_user_array)) {
			ESPCMS_Dialog::Message_Page('blacklist_user', $mlink['login']);
		}
		$SAFETY_PASSWORD_TIME = espcms_ismatches($member_con['MEMBER_SAFETY_PASSWORD_TIME']) && $member_con['MEMBER_SAFETY_PASSWORD_TIME'] > 0 ? $member_con['MEMBER_SAFETY_PASSWORD_TIME'] * 60 * 60 : 3600 * 24 * 30;
		$session_id = espcms_set_cookie('espcms_web_user_info', espcms_encrypt($user_read, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
		if (!$session_id) {
			ESPCMS_Dialog::Message_Page('cookie_save_err', $mlink['login']);
		}
		$user_login_info = array();
		$user_login_info['login_ip'] = real_remote_ip();
		$user_login_info['login_time'] = time();
		espcms_set_cookie('espcms_web_server_info', espcms_encrypt($user_login_info, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
		ESPCMS_MemberDB::member_login_save($user_read['userid']);
		ESPCMS_MemberDB::member_login_log_save($user_read['userid']);
		if ($member_con['MEMBER_MOBLIE_VERIFY'] && !$user_read['ismoblie']) {
			ESPCMS_Dialog::Message_Page('ismoblie_check', $mlink['binding'], 'bangtin_moblie');
		}
		$espcms_web_login_link = $_COOKIE['espcms_web_login_link'] ? espcms_decrypt($_COOKIE['espcms_web_login_link'], ESPCMS_ENCRYPT_CODE) : false;
		if ($espcms_web_login_link) {
			espcms_set_cookie('espcms_web_login_link', false);
			ESPCMS_Dialog::Message_Page('login_ok', $espcms_web_login_link, 'goback_botton', 'member_center_botton', $mlink['center']);
		} else {
			header("location:" . $mlink['center']);
		}
	}

	public static function in_Quit() {
		$username = ESPCMS_MemberAuthority::getMemberInfo('username');
		$userid = ESPCMS_MemberAuthority::getMemberInfo('userid');
		if ($username && $userid) {
			ESPCMS_MemberDB::member_login_save($userid, 2);
			espcms_set_cookie('espcms_web_server_info', false);
			espcms_set_cookie('espcms_web_user_info', false);
		}
		header('location:' . MemberLink::get_link('login'));
	}

	public static function in_RegInitialized() {
		global $espcms_web_templates, $espcms_command;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$lng = espcms_lancode();
		$att_array = ESPCMS_MemberDB::get_member_attr($lng, true, true);
		$espcms_web_templates->into('att_array', $att_array);
		$espcms_web_templates->into('tokenkey', token('member_reg'));
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('seccodelink', PublicLink::get_verfication('seccodelink'));
		$espcms_web_templates->into('verify_isopen', $member_con['MEMBER_LOGIN_VERIFY'] && $espcms_command['SAFETY_ISVERIFICATION_CODE'] ? 1 : 0);
		$espcms_web_templates->into('member_con', $member_con);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->output('member/member_reg', 'member_login', false, false);
	}

	public static function in_RegInitializedSave() {
		global $espcms_command;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		$reg_type = $_POST['type'] ? $_POST['type'] : 'web';
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('reg'));
		}
		if ($member_con['MEMBER_REG_VERIFY'] && $espcms_command['SAFETY_ISVERIFICATION_CODE'] && $reg_type == 'web') {
			require_once( ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_VerificationCode.php' );
			$espcms_login_verification_code_cookie = $_COOKIE['espcms_web_login_verification_code'];
			if ($espcms_login_verification_code_cookie) {
				$espcms_login_verification_code = espcms_decrypt($espcms_login_verification_code_cookie, ESPCMS_ENCRYPT_CODE);
			} else {
				ESPCMS_Dialog::Message_Page('seescode_err', MemberLink::get_link('reg'));
			}
			$code = new ESPCMS_VerificationCode();
			$code->seccodeconvert($espcms_login_verification_code);
			$_POST['seccode'] = $_POST['seccode'] ? strtoupper($_POST['seccode']) : '';
			if ($espcms_login_verification_code != $_POST['seccode']) {
				ESPCMS_Dialog::Message_Page('seescode_err', MemberLink::get_link('reg'));
			}
		}
		if (!preg_match("/^[a-zA-z]{1}[\x{4e00}-\x{9fa5}\w]{2,50}$/u", $_POST['username']) || !espcms_isemail($_POST['email']) || !espcms_ismoblie($_POST['mobile'])) {
			ESPCMS_Dialog::Message_Page('input_err', MemberLink::get_link('reg'));
		}
		if ($_POST['password'] && $_POST['password'] == $_POST['validation_password']) {
			$_POST['password'] = md5($_POST['password']);
		} else {
			ESPCMS_Dialog::Message_Page('password_input_err', MemberLink::get_link('reg'));
		}
		if (self::verifyMemberDB('username', $_POST['username'])) {
			ESPCMS_Dialog::Message_Page('username_repetition', MemberLink::get_link('reg'));
		}
		if (self::verifyMemberDB('email', $_POST['email'])) {
			ESPCMS_Dialog::Message_Page('email_repetition', MemberLink::get_link('reg'));
		}
		if (self::verifyMemberDB('mobile', $_POST['mobile'])) {
			ESPCMS_Dialog::Message_Page('moblie_repetition', MemberLink::get_link('reg'));
		}
		$_POST['lng'] = espcms_lancode();
		$_POST['addtime'] = time();
		$_POST['mcid'] = $member_con['MEMBER_REG_MCID'] && espcms_ismatches($member_con['MEMBER_REG_MCID']) ? $member_con['MEMBER_REG_MCID'] : 0;
		$_POST['visitcount'] = 0;
		$_POST['integral'] = 0;
		$_POST['ismoblie'] = 0;
		$_POST['isemail'] = 0;
		$_POST['mobliesntime'] = 0;
		$_POST['isqq'] = 0;
		$_POST['sex'] = 1;
		$_POST['isweixin'] = 0;
		$_POST['isclass'] = $member_con['MEMBER_ISCLASS_VERIFY'] ? 0 : 1;
		if ($reg_type == 'onekey' && !$_POST['openid']) {
			ESPCMS_Dialog::Message_Page('member_reg_binding_code_err', MemberLink::get_link('login'));
		}
		if ($reg_type == 'onekey' && $_POST['source'] == 'weixin') {
			$_POST['isweixin'] = 1;
			$_POST['weixin_openid'] = $_POST['openid'] ? htmlspecialchars($_POST['openid']) : '';
		}
		if ($reg_type == 'onekey' && $_POST['source'] == 'weibo') {
			$_POST['weibo_openid'] = htmlspecialchars($_POST['openid']);
		}
		if ($reg_type == 'onekey' && $_POST['source'] == 'qq') {
			$_POST['isqq'] = 1;
			$_POST['qq_openid'] = htmlspecialchars($_POST['openid']);
		}
		if ($reg_type == 'onekey') {
			$_POST['alias'] = $_POST['alias'] ? htmlspecialchars($_POST['alias']) : '';
			$_POST['sex'] = $_POST['sex'] && espcms_ismatches($_POST['sex']) ? $_POST['sex'] : 1;
			$_POST['country'] = $_POST['country'] ? htmlspecialchars($_POST['country']) : '';
			$_POST['province'] = $_POST['province'] ? htmlspecialchars($_POST['province']) : '';
			$_POST['city'] = $_POST['city'] ? htmlspecialchars($_POST['city']) : '';
			$_POST['pic'] = $_POST['pic'] ? htmlspecialchars($_POST['pic']) : '';
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$talbe_field_array = espcms_field_out($db_table, true);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			ESPCMS_Dialog::Message_Page('dba_read_err', MemberLink::get_link('reg'));
		}
		$install_id = espcms_db_install_save($db_table, $postvalue);
		if (!$install_id || !espcms_ismatches($install_id)) {
			ESPCMS_Dialog::Message_Page('save_err', MemberLink::get_link('reg'));
		}
		ESPCMS_MemberDB::member_install_attr(espcms_lancode(), $install_id, $_POST);
		if ($espcms_command['EMAIL_ISOPEN'] && $member_con['MEMBER_EMAIL_VERIFY']) {
			$_POST['userid'] = $install_id;
			$_POST['user_key'] = urlencode(espcms_encrypt($_POST['username'], ESPCMS_ENCRYPT_CODE));
			$_POST['pass_key'] = urlencode(espcms_encrypt($_POST['password'], ESPCMS_ENCRYPT_CODE));
			$_POST['checklink'] = MemberLink::get_mailcheck($_POST);
			ESPCMS_SendMessage::send_email_message('member_mail_check', $_POST, $install_id);
			ESPCMS_Dialog::Message_Page('reg_email_check_ok', MemberLink::get_link('login'), 'member_login_botton');
		} else {
			$talbe_field_array = 'userid,lng,username,password,email,mobile,sex,country,weixin,integral,alias,visitcount,lastip,addtime,lasttime,updatetime,mcid,isclass,ismoblie,ismoblietime,isemail,isemailtime,isqq,isweixin';
			$db_where = "WHERE userid=$install_id";
			$user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
			if (!$user_read) {
				ESPCMS_Dialog::Message_Page('login_err', MemberLink::get_link('login'));
			}
			$SAFETY_PASSWORD_TIME = espcms_ismatches($member_con['MEMBER_SAFETY_PASSWORD_TIME']) && $member_con['MEMBER_SAFETY_PASSWORD_TIME'] > 0 ? $member_con['MEMBER_SAFETY_PASSWORD_TIME'] * 60 * 60 : 3600 * 24 * 30;
			$session_id = espcms_set_cookie('espcms_web_user_info', espcms_encrypt($user_read, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
			if (!$session_id) {
				ESPCMS_Dialog::Message_Page('cookie_save_err', MemberLink::get_link('login'));
			}
			$user_login_info = array();
			$user_login_info['login_ip'] = real_remote_ip();
			$user_login_info['login_time'] = time();
			espcms_set_cookie('espcms_web_server_info', espcms_encrypt($user_login_info, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
			ESPCMS_MemberDB::member_login_save($user_read['userid']);
			ESPCMS_MemberDB::member_login_log_save($user_read['userid']);
			$espcms_web_login_link = $_COOKIE['espcms_web_login_link'] ? espcms_decrypt($_COOKIE['espcms_web_login_link'], ESPCMS_ENCRYPT_CODE) : false;
			if ($espcms_web_login_link) {
				espcms_set_cookie('espcms_web_login_link', false);
				ESPCMS_Dialog::Message_Page('login_ok', $espcms_web_login_link, 'goback_botton', 'member_center_botton', MemberLink::get_link('center'));
			} else {
				header("location:" . MemberLink::get_link('center'));
			}
		}
	}

	public static function in_verifyAccount() {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$field_array = array('username', 'email', 'mobile');
		if (!isset($verifyKey) || !in_array($verifyKey, $field_array)) {
			exit('false');
		}
		if ($verifyKey == 'username' && !espcms_isact($verifyValue, "/^[a-zA-z]{1}[\x{4e00}-\x{9fa5}\w]{2,50}$/u")) {
			exit('false');
		}
		if ($verifyKey == 'email' && !espcms_isemail($verifyValue)) {
			exit('false');
		}
		if ($verifyKey == 'mobile' && !espcms_ismoblie($verifyValue)) {
			exit('false');
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$userid = intval($_REQUEST['userid']);
		if (!$userid || !espcms_ismatches($userid)) {
			$db_where = $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where = $verifyType ? " AND $verifyKey!='$verifyValue' AND userid!=$userid" : " AND $verifyKey='$verifyValue' AND userid!=$userid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		exit($db_num);
	}

	private static function verifyMemberDB($verifyKey, $verifyValue, $userid = 0, $verifyType = false) {
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			return true;
		}
		$member_con = unserialize($member_app_config['appconfig']);
		$field_array = array('username', 'email', 'mobile');
		if (!isset($verifyKey) || !in_array($verifyKey, $field_array)) {
			return true;
		}
		if (!$verifyValue) {
			return true;
		}
		$loack_user_array = explode(',', $member_con['MEMBER_REG_LOCK_USER']);
		if (is_array($loack_user_array) && in_array($verifyValue, $loack_user_array) && $verifyKey == 'username') {
			return true;
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		if (empty($userid) || !espcms_ismatches($userid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND userid!=$userid" : " AND $verifyKey='$verifyValue' AND userid!=$userid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		return $db_num > 0 ? true : false;
	}

	public static function in_FindPassword() {
		global $espcms_web_templates;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('tokenkey', token('member_find'));
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('member_con', $member_con);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->output('member/member_find', 'member_find', false, false);
	}

	public static function in_FindPasswordSave() {
		global $espcms_command;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('findpw'));
		}
		if ((!preg_match("/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u", $_POST['username']) || !espcms_ismoblie($_POST['mobile'])) && $_POST['istype'] == 2) {
			ESPCMS_Dialog::Message_Page('input_err', MemberLink::get_link('findpw'));
		}
		if ((!preg_match("/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u", $_POST['username']) || !espcms_isemail($_POST['email'])) && $_POST['istype'] == 1) {
			ESPCMS_Dialog::Message_Page('input_err', MemberLink::get_link('findpw'));
		}
		if ($_POST['istype'] == 2 && !$espcms_command['SMS_ISOPEN']) {
			ESPCMS_Dialog::Message_Page('sms_send_no', MemberLink::get_link('findpw'));
		} elseif ($_POST['istype'] == 1 && !$espcms_command['EMAIL_ISOPEN']) {
			ESPCMS_Dialog::Message_Page('main_send_no', MemberLink::get_link('findpw'));
		}
		$db_table = ESPCMS_DB_PREFIX . "member";
		$db_where = $_POST['istype'] == 2 ? "WHERE isclass=1 AND ismoblie=1 AND username='" . $_POST['username'] . "' AND mobile='" . $_POST['mobile'] . "'" : "WHERE isclass=1 AND isemail=1 AND username='" . $_POST['username'] . "' AND email='" . $_POST['email'] . "'";
		$talbe_field_array = 'userid,lng,username,password,email,mobile,sex,country,weixin,integral,visitcount,lastip,addtime,lasttime,updatetime,mcid,isclass,ismoblie,ismoblietime,isemail,isemailtime,isqq,isweixin';
		$user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
		if (!$user_read) {
			ESPCMS_Dialog::Message_Page('find_user_verify_err', MemberLink::get_link('findpw'));
		}
		$new_password = random(8);
		$password = md5($new_password);
		$update_key = espcms_db_update_set_save($db_table, $db_where, "password='$password'");
		if ($espcms_command['SMS_ISOPEN'] && $_POST['istype'] == 2 && $member_con['MEMBER_MOBLIE_VERIFY'] && $update_key) {
			$user_read['newpassword'] = $new_password;
			ESPCMS_SendMessage::send_sms_message('member_find_password', $user_read, $user_read['userid'], false);
			ESPCMS_Dialog::Message_Page('password_send_moblie', MemberLink::get_link('login'), 'member_login_botton');
		} elseif ($espcms_command['EMAIL_ISOPEN'] && $_POST['istype'] == 1 && $member_con['MEMBER_EMAIL_VERIFY'] && $update_key) {
			$user_read['newpassword'] = $new_password;
			ESPCMS_SendMessage::send_email_message('member_mail_find_password', $user_read, $user_read['userid'], false);
			ESPCMS_Dialog::Message_Page('password_send_email', MemberLink::get_link('login'), 'member_login_botton');
		}
	}

	public static function in_CheckMailSend() {
		global $espcms_web_templates;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		$lanpack = $espcms_web_templates->geto('lngpack');
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('tokenkey', token('member_checkmailsend'));
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('member_con', $member_con);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->output('member/member_checkmailsend', 'member_checkmailsend', false, false);
	}

	public static function in_CheckMailSendSave() {
		global $espcms_command;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('checkmailsend'));
		}
		if (!preg_match("/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u", $_POST['username'])) {
			ESPCMS_Dialog::Message_Page('username_input_err', MemberLink::get_link('checkmailsend'));
		}
		$login_user = $_POST['username'];
		$password_len = strlen($_POST['password']);
		if ($password_len < 6 || $password_len > 30) {
			ESPCMS_Dialog::Message_Page('password_input_err', MemberLink::get_link('checkmailsend'));
		}
		$password = md5($_POST['password']);
		$db_where = "WHERE username='$login_user' AND password='$password' AND isemail=0";
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$talbe_field_array = 'userid,lng,username,password,email,mobile,sex,country,weixin,integral,visitcount,lastip,addtime,lasttime,updatetime,mcid,isclass,ismoblie,ismoblietime,isemail,isemailtime,isqq,isweixin';
		$user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
		if (!$user_read) {
			ESPCMS_Dialog::Message_Page('login_err', MemberLink::get_link('checkmailsend'));
		}
		if ($espcms_command['EMAIL_ISOPEN'] && $member_con['MEMBER_EMAIL_VERIFY']) {
			$_POST['userid'] = $user_read['userid'];
			$_POST['user_key'] = urlencode(espcms_encrypt($_POST['username'], ESPCMS_ENCRYPT_CODE));
			$_POST['pass_key'] = urlencode(espcms_encrypt($user_read['password'], ESPCMS_ENCRYPT_CODE));
			$_POST['checklink'] = MemberLink::get_mailcheck($_POST);
			ESPCMS_SendMessage::send_email_message('member_mail_check', $_POST, $user_read['userid']);
			ESPCMS_Dialog::Message_Page('user_checkmail_sendok', MemberLink::get_link('login'), 'member_login_botton');
		} else {
			ESPCMS_Dialog::Message_Page('main_send_no', MemberLink::get_link('login'), 'member_login_botton');
		}
	}

	public static function in_CheckMail() {
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		if (!espcms_ismatches($_GET['userid']) || !$_GET['userid']) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('login'), 'member_login_botton');
		}
		$key = $_GET['key'] ? espcms_decrypt($_GET['key'], ESPCMS_ENCRYPT_CODE) : false;
		$code = $_GET['code'] ? espcms_decrypt($_GET['code'], ESPCMS_ENCRYPT_CODE) : false;
		if (!preg_match("/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u", $key)) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('login'), 'member_login_botton');
		}
		$db_where = "WHERE username='$key' AND password='$code' AND isemail=0";
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$talbe_field_array = 'userid,lng,username,password,email,mobile,sex,country,weixin,integral,visitcount,lastip,addtime,lasttime,updatetime,mcid,isclass,ismoblie,ismoblietime,isemail,isemailtime,isqq,isweixin';
		$user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
		if (!$user_read) {
			ESPCMS_Dialog::Message_Page('user_check_no', MemberLink::get_link('login'), 'member_login_botton');
		}
		espcms_db_update_set_save($db_table, $db_where, "isemail=1");
		ESPCMS_Dialog::Message_Page('user_check_ok', MemberLink::get_link('login'), 'member_login_botton');
	}

	public static function in_JsLogin() {
		global $espcms_web_templates, $espcms_command;
		$espcms_web_templates->libfile = true;
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		if (ESPCMS_MemberAuthority::authorityWebVerify(true)) {
			$member_info = ESPCMS_MemberAuthority::getMemberInfo();
			$filename = $_GET['info_file'] ? $_GET['info_file'] : 'member_info';
			$espcms_web_templates->into('member', $member_info);
		} else {
			$filename = $_GET['login_file'] ? $_GET['login_file'] : 'member_login';
		}
		$espcms_web_templates->into('tokenkey', token('member_login'));
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('seccodelink', PublicLink::get_verfication('seccodelink'));
		$espcms_web_templates->into('verify_isopen', $member_con['MEMBER_LOGIN_VERIFY'] && $espcms_command['SAFETY_ISVERIFICATION_CODE'] ? 1 : 0);
		$espcms_web_templates->into('member_con', $member_con);
		$output = $espcms_web_templates->fetch('lib/' . $filename);
		$outHTML = addslashes($output);
		$textArray = preg_split('/[\r\n]/i', $outHTML);
		if (is_array($textArray)) {
			$outHTML = null;
			foreach ($textArray as $key => $value) {
				$outHTML .= 'document.write("' . $value . '");';
			}
			exit($outHTML);
		} else {
			exit('document.writeln("' . $outHTML . '")');
		}
	}

	public static function in_BindingLogin() {
		$reg_type = $_POST['type'] ? $_POST['type'] : 'web';
		$mlink = MemberLink::get_link();
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		$member_con = unserialize($member_app_config['appconfig']);
		if (!preg_match('/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u', $_POST['login_user']) && !espcms_ismoblie($_POST['login_user']) && !espcms_isemail($_POST['login_user'])) {
			ESPCMS_Dialog::Message_Page('input_err', $mlink['login']);
		}
		$login_user = $_POST['login_user'];
		$password_len = strlen($_POST['password']);
		if ($password_len < 6 || $password_len > 30) {
			ESPCMS_Dialog::Message_Page('password_input_err', $mlink['login']);
		}
		$password = md5($_POST['password']);
		if (preg_match('/^[\x{4e00}-\x{9fa5}\w]{2,50}$/u', $_POST['login_user']) && !espcms_ismoblie($_POST['login_user'])) {
			$db_where = "WHERE username='$login_user' AND password='$password' AND isclass=1";
		} elseif (espcms_ismoblie($_POST['login_user'])) {
			$db_where = "WHERE mobile='$login_user' AND password='$password' AND isclass=1";
		} elseif (espcms_isemail($_POST['login_user'])) {
			$db_where = "WHERE email='$login_user' AND password='$password' AND isclass=1";
		} else {
			ESPCMS_Dialog::Message_Page('username_input_err', $mlink['login']);
		}
		$db_table = ESPCMS_DB_PREFIX . 'member';
		$talbe_field_array = 'userid,lng,username,password,email,mobile,sex,country,weixin,integral,alias,visitcount,lastip,addtime,lasttime,updatetime,mcid,isclass,ismoblie,ismoblietime,isemail,isemailtime,isqq,isweixin';
		$user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
		if (!$user_read) {
			ESPCMS_Dialog::Message_Page('login_err', $mlink['login']);
		}
		if ($member_con['MEMBER_EMAIL_VERIFY'] && !$user_read['isemail']) {
			ESPCMS_Dialog::Message_Page('isemail_check', $mlink['checkmailsend'], 'checkemail_send');
		}
		$loack_user_array = explode(',', $member_con['MEMBER_REG_LOCK_USER']);
		if (is_array($loack_user_array) && in_array($user_read['username'], $loack_user_array)) {
			ESPCMS_Dialog::Message_Page('blacklist_user', $mlink['login']);
		}
		if ($member_con['MEMBER_MOBLIE_VERIFY'] && !$user_read['ismoblie']) {
			ESPCMS_Dialog::Message_Page('ismoblie_check', $mlink['binding'], 'bangtin_moblie');
		}
		if (!$_POST['openid']) {
			ESPCMS_Dialog::Message_Page('member_reg_binding_code_err', MemberLink::get_link('login'));
		}
		$update_set_array = array();
		if ($_POST['source'] == 'weixin') {
			$update_set_array['isweixin'] = 1;
			$update_set_array['weixin_openid'] = htmlspecialchars($_POST['openid']);
		}
		if ($_POST['source'] == 'weibo') {
			$update_set_array['weibo_openid'] = htmlspecialchars($_POST['openid']);
		}
		if ($_POST['source'] == 'qq') {
			$update_set_array['isqq'] = 1;
			$update_set_array['qq_openid'] = htmlspecialchars($_POST['openid']);
		}
		$update_set_array['alias'] = $_POST['alias'] ? htmlspecialchars($_POST['alias']) : '';
		$update_set_array['sex'] = $_POST['sex'] && espcms_ismatches($_POST['sex']) ? $_POST['sex'] : 1;
		$update_set_array['country'] = $_POST['country'] ? htmlspecialchars($_POST['country']) : '';
		$update_set_array['province'] = $_POST['province'] ? htmlspecialchars($_POST['province']) : '';
		$update_set_array['city'] = $_POST['city'] ? htmlspecialchars($_POST['city']) : '';
		ESPCMS_MemberDB::update_member_info($user_read['userid'], $update_set_array);
		$SAFETY_PASSWORD_TIME = espcms_ismatches($member_con['MEMBER_SAFETY_PASSWORD_TIME']) && $member_con['MEMBER_SAFETY_PASSWORD_TIME'] > 0 ? $member_con['MEMBER_SAFETY_PASSWORD_TIME'] * 60 * 60 : 3600 * 24 * 30;
		$session_id = espcms_set_cookie('espcms_web_user_info', espcms_encrypt($user_read, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
		if (!$session_id) {
			ESPCMS_Dialog::Message_Page('cookie_save_err', $mlink['login']);
		}
		$user_login_info = array();
		$user_login_info['login_ip'] = real_remote_ip();
		$user_login_info['login_time'] = time();
		espcms_set_cookie('espcms_web_server_info', espcms_encrypt($user_login_info, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
		ESPCMS_MemberDB::member_login_save($user_read['userid']);
		ESPCMS_MemberDB::member_login_log_save($user_read['userid']);
		$espcms_web_login_link = $_COOKIE['espcms_web_login_link'] ? espcms_decrypt($_COOKIE['espcms_web_login_link'], ESPCMS_ENCRYPT_CODE) : false;
		if ($espcms_web_login_link) {
			espcms_set_cookie('espcms_web_login_link', false);
			ESPCMS_Dialog::Message_Page('login_ok', $espcms_web_login_link, 'goback_botton', 'member_center_botton', $mlink['center']);
		} else {
			header("location:" . $mlink['center']);
		}
	}

}
