<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ForumDB;
use modul_application\ESPCMS_FormDB;
use inc_application\link\ArticleLink;
use inc_application\link\ForumLink;
use inc_application\link\FormsLink;
use inc_application\link\MemberLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;
use inc_application\link\PublicLink;

class lib_menu {

	public static function call_menu($parameter, $filename = 'menu', $outHTML = null) {
		global $espcms_db_cache, $espcms_command;
		$espcms_lib_template = espcms_web_template();
		$espcms_lib_template->libfile = true;
		$para = espcms_array_getvalue($parameter);
		$lng = espcms_lancode();
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$para['hover_id'] = espcms_ismatches($para['hover_id']) ? $para['hover_id'] : 0;
		$para['ishome'] = espcms_ismatches($para['ishome']) ? $para['ishome'] : 1;
		$para['ismenu'] = espcms_ismatches($para['ismenu']) ? $para['ismenu'] : 0;
		if (!espcms_ismatches($para['iswap'])) {
			$para['iswap'] = ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE') ? 1 : 0;
		}
		$para['iswap'] = espcms_ismatches($para['iswap']) ? $para['iswap'] : 0;
		$para['isacs'] = espcms_ismatches($para['isacs']) ? $para['isacs'] : 0;
		$para['child'] = espcms_ismatches($para['child']) ? $para['child'] : 0;
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $espcms_lib_template->lng . '_' . $espcms_command['IS_HTML'] . '_' . $espcms_command['IS_REWRITE'] . '_' . $para['ismenu'] . '_' . $para['iswap'] . '_' . $para['isacs'] . '_' . $para['child'] . '_' . $para['ishome'];
		$nevigate_array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$nevigate_array) {
			if ($para['ishome']) {
				$home_array['nevigate_name'] = espcms_web_lan_pack($lng, 'home_title');
				$home_array['path'] = 'index';
				$home_array['hover_id'] = 0;
				$home_array['link'] = PublicLink::get_link($lng, 'home');
				$nevigate_array[] = $home_array;
			}
			$talbe_field_array = espcms_field_out($db_table);
			$db_where = " AND lng='$lng'";
			if (espcms_ismatches($para['ismenu']) && $para['ismenu']) {
				$db_where .= " AND nevigate_ismenu=" . $para['ismenu'];
			}
			if (espcms_ismatches($para['iswap']) && $para['iswap']) {
				$db_where .= " AND nevigate_iswap=" . $para['iswap'];
			}
			if (espcms_ismatches($para['isacs']) && $para['isacs']) {
				$db_where .= " AND nevigate_isaccessory=" . $para['isacs'];
			}
			$menu_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, 'nevigate_pid,nevigate_id DESC');
			if (is_array($menu_array)) {
				foreach ($menu_array as $key => $value) {
					if ($value['nevigate_modul'] == 'type') {
						$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($value['nevigate_linkid']);
						$type_goto_read = $type_read['gotoid'] && espcms_ismatches($type_read['gotoid']) ? ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']) : false;
						$value['hover_id'] = $type_read['tid'];
						$value['path'] = 'article';
						$value['link'] = $type_goto_read ? ArticleLink::type_link($type_goto_read) : ArticleLink::type_link($type_read);
						if ($para['child']) {
							if (ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE')) {
								$typelist = ESPCMS_ArticleTypeDB::get_article_type_list(0, $value['nevigate_linkid'], 0, $lng, false, false, true, 1);
							} else {
								$typelist = ESPCMS_ArticleTypeDB::get_article_type_list(0, $value['nevigate_linkid'], 0, $lng, false, false, true);
							}
							if (is_array($typelist)) {
								$value['childArray'] = $typelist;
							}
						}
					}
					if ($value['nevigate_modul'] == 'bbs') {
						$bbs_app_config = ESPCMS_Core::get_app_config('bbsemanage', false);
						if ($bbs_app_config['isetup'] && $bbs_app_config['isopen']) {
							$bbs_type_read = ESPCMS_ForumDB::get_bbs_typelist_view($value['nevigate_linkid']);
							$value['hover_id'] = $bbs_type_read['btid'];
							$value['path'] = 'bbs';
							$value['link'] = ForumLink::type_link($bbs_type_read);
						} else {
							continue;
						}
					}
					if ($value['nevigate_modul'] == 'forms') {
						$forms_app_config = ESPCMS_Core::get_app_config('formsmanage', false);
						if ($forms_app_config['isetup'] && $forms_app_config['isopen']) {
							$form_group_read = ESPCMS_FormDB::get_form_group_view($value['nevigate_linkid']);
							$value['hover_id'] = $form_group_read['fgid'];
							$value['path'] = 'form';
							$value['link'] = FormsLink::type_link($form_group_read);
						} else {
							continue;
						}
					}
					if ($value['nevigate_modul'] == 'member') {
						$member_app_config = ESPCMS_Core::get_app_config('member', false);
						if ($member_app_config['isetup'] && $member_app_config['isopen']) {
							$value['path'] = 'member';
							$value['hover_id'] = 0;
							$value['link'] = MemberLink::get_link('login');
						} else {
							continue;
						}
					}
					if ($value['nevigate_modul'] == 'order') {
						$order_app_config = ESPCMS_Core::get_app_config('order', false);
						if ($order_app_config['isetup'] && $order_app_config['isopen']) {
							$value['path'] = 'order';
							$value['hover_id'] = 0;
							$value['link'] = OrderLink::get_order_link('list');
						} else {
							continue;
						}
					}
					if ($value['nevigate_modul'] == 'enquiry') {
						$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
						if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
							$value['path'] = 'enquiry';
							$value['hover_id'] = 0;
							$value['link'] = EnquiryLink::get_enquiry_link('putin');
						} else {
							continue;
						}
					}
					$nevigate_array[] = $value;
				}
			}
			$espcms_db_cache->cacheSave($cache_key, $nevigate_array);
		}
		if ($para['hover_id'] && $para['path'] == 'article') {
			$espcms_lib_template->into('hover_id', ESPCMS_ArticleTypeDB::get_type_menu_hover($para['hover_id']));
		} else {
			$espcms_lib_template->into('hover_id', espcms_ismatches($para['current']) ? $para['current'] : 0);
		}
		$espcms_lib_template->into('para', $para);
		$espcms_lib_template->into('array', $nevigate_array);
		if (!empty($outHTML)) {
			$output = $espcms_lib_template->fetch(null, null, $outHTML);
		} else {
			$output = $espcms_lib_template->fetch('lib/' . $filename);
		}
		return $output;
	}

}
