<?php

namespace App\Http\Controllers\Admin;


use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldRichtext;
use Edwin404\Admin\Cms\Field\FieldSelect;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\Response;
use Illuminate\Support\Facades\Request;

class BookController extends AdminCheckController
{
    private $cmsConfigBasic = [
        'model' => 'book',
        'pageTitle' => '预约管理',
        'group' => 'data',
        'canAdd' => true,
        'canEdit' => true,
        'canDelete' => true,
        'fields' => [
            'name' => ['type' => FieldText::class, 'title' => '姓名', 'list' => true, 'edit' => true, 'add' => true,],
            'phone' => ['type' => FieldText::class, 'title' => '手机', 'list' => true, 'edit' => true, 'add' => true,],
            'wechat' => ['type' => FieldText::class, 'title' => '微信', 'list' => true, 'edit' => true, 'add' => true,],
            'qq' => ['type' => FieldText::class, 'title' => 'QQ', 'list' => true, 'edit' => true, 'add' => true,],
            'contact' => ['type' => FieldText::class, 'title' => '联系方式', 'list' => true, 'edit' => true, 'add' => true,],
            'data' => ['type' => FieldText::class, 'title' => '数据', 'list' => true, 'edit' => true, 'add' => true,],
        ]
    ];

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);;
    }

    public function dataDelete(BasicCms $basicCms)
    {
        return $basicCms->executeDelete($this, $this->cmsConfigBasic);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        return $basicCms->executeEdit($this, $this->cmsConfigBasic);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        return $basicCms->executeAdd($this, $this->cmsConfigBasic);
    }


}
