<?php

namespace App\Http\Controllers\Admin;


use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldRichtext;
use Edwin404\Admin\Cms\Field\FieldSelect;
use Edwin404\Admin\Cms\Field\FieldSwitch;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\ConfigCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\RequestHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Demo\Helpers\DemoHelper;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;

class ConfigController extends \Edwin404\Tecmz\Controllers\ConfigController
{

    public function setting(ConfigCms $configCms, $param = [])
    {
        return parent::setting($configCms);
    }

    public function template(ConfigCms $configCms, $param = [])
    {
        if (RequestHelper::isPost()) {
            if (DemoHelper::shouldDenyAdminDemo()) {
                return Response::send(-1, '演示账号禁止修改信息');
            }
            $input = InputPackage::buildFromInput();
            foreach ($input->all() as $k => $v) {
                ConfigFacade::set($k, $v);
            }
            return Response::send(0, '保存成功');
        }
        return view('admin.config.template');
    }

    public function module(ConfigCms $configCms)
    {
        return $configCms->execute($this, [
            'group' => 'module',
            'pageTitle' => '模块设置',
            'fields' => [
                'moduleBookEnable' => ['type' => FieldSwitch::class, 'title' => '开启预约', 'desc' => ''],
                'moduleBookTemplate' => ['type' => FieldTextarea::class, 'title' => '预约弹窗HTML', 'desc' => '为空使用姓名，手机，说明三个字段'],
            ]
        ]);
    }

    public function contactInfo(ConfigCms $configCms)
    {
        return $configCms->execute($this, [
            'group' => 'contactInfo',
            'pageTitle' => '联系方式',
            'fields' => [
                'contactAddress' => ['type' => FieldText::class, 'title' => '联系地址', 'desc' => ''],
                'contactQQ' => ['type' => FieldText::class, 'title' => 'QQ', 'desc' => ''],
                'contactTel' => ['type' => FieldText::class, 'title' => '电话', 'desc' => ''],
                'contactEmail' => ['type' => FieldText::class, 'title' => '邮箱', 'desc' => ''],
            ]
        ]);
    }

    public function about(ConfigCms $configCms)
    {
        return $configCms->execute($this, [
            'group' => 'about',
            'pageTitle' => '关于我们',
            'fields' => [
                'siteAbout' => ['type' => FieldRichtext::class, 'title' => '内容', 'desc' => ''],
            ]
        ]);
    }

    public function aboutHome(ConfigCms $configCms)
    {
        return $configCms->execute($this, [
            'group' => 'aboutHome',
            'pageTitle' => '关于我们',
            'fields' => [
                'siteAboutHome' => ['type' => FieldRichtext::class, 'title' => '内容', 'desc' => ''],
            ]
        ]);
    }

    public function contact(ConfigCms $configCms)
    {
        return $configCms->execute($this, [
            'group' => 'contact',
            'pageTitle' => '联系我们',
            'fields' => [
                'siteContact' => ['type' => FieldRichtext::class, 'title' => '内容', 'desc' => ''],
            ]
        ]);
    }

}
