<?php

namespace App\Http\Controllers\Admin;


use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldRichtext;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\Response;
use Illuminate\Support\Facades\Request;

class NewsController extends AdminCheckController
{
    private $cmsConfigBasic = [
        'model' => 'news',
        'pageTitle' => '新闻',
        'group' => 'data',
        'canAdd' => true,
        'canEdit' => true,
        'canDelete' => true,
        'fields' => [
            'title' => ['type' => FieldText::class, 'title' => '标题', 'list' => true, 'edit' => true, 'add' => true,],
            'cover' => ['type' => FieldImage::class, 'title' => '封面', 'list' => true, 'edit' => true, 'add' => true,],
            'keywords' => ['type' => FieldText::class, 'title' => '关键词', 'list' => true, 'edit' => true, 'add' => true,],
            'description' => ['type' => FieldTextarea::class, 'title' => '描述', 'list' => true, 'edit' => true, 'add' => true,],
            'content' => ['type' => FieldRichtext::class, 'title' => '内容', 'edit' => true, 'add' => true,],
        ]
    ];

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);;
    }

    public function dataDelete(BasicCms $basicCms)
    {
        return $basicCms->executeDelete($this, $this->cmsConfigBasic);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        return $basicCms->executeEdit($this, $this->cmsConfigBasic);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        return $basicCms->executeAdd($this, $this->cmsConfigBasic);
    }


}