<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Forum\Services\ForumService;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;

class BookController extends BaseController
{
    public function index()
    {
        if (!ConfigFacade::get('moduleBookEnable')) {
            return Response::send(-1, '没有开启产品预约服务');
        }
        $input = InputPackage::buildFromInput();
        $update = [];
        $update['name'] = $input->getTrimString('name');
        $update['wechat'] = $input->getTrimString('wechat');
        $update['phone'] = $input->getTrimString('phone');
        $update['qq'] = $input->getTrimString('qq');
        $update['remark'] = $input->getTrimString('remark');
        $update['data'] = $input->getArray('data');
        $pass = false;
        foreach ($update as $item) {
            if (!empty($item)) {
                $pass = true;
            }
        }
        if (!$pass) {
            return Response::send(-1, '所有提交数据为空');
        }
        $update['data'] = json_encode($update['data']);
        ModelHelper::add('book', $update);
        return Response::send(0, '提交成功', null, '[reload]');
    }

}
