<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\InputPackage;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Forum\Services\ForumService;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;

class MessageController extends BaseController
{
    public function index()
    {
        $input = InputPackage::buildFromInput();
        $update = [];
        $update['name'] = $input->getTrimString('name');
        $update['email'] = $input->getTrimString('email');
        $update['phone'] = $input->getTrimString('phone');
        $update['content'] = $input->getTrimString('content');
        $pass = false;
        foreach ($update as $item) {
            if (!empty($item)) {
                $pass = true;
            }
        }
        if (!$pass) {
            return Response::send(-1, '所有提交数据为空');
        }
        ModelHelper::add('message', $update);
        return Response::send(0, '提交成功', null, '[reload]');
    }

}
