<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\PageHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Forum\Services\ForumService;
use Illuminate\Support\Facades\Input;

class NewsController extends BaseController
{
    public function index()
    {
        $page = Input::get('page');
        $pageSize = 9;

        $option = [];
        $option['order'] = ['id', 'desc'];
        $productPaginate = ModelHelper::modelPaginate('news', $page, $pageSize, $option);

        $newses = $productPaginate['records'];
        $pageHtml = PageHelper::render($productPaginate['total'], $pageSize, $page, '/news?page={page}');

        $viewData = [];
        $viewData['newses'] = $newses;
        $viewData['pageHtml'] = $pageHtml;
        $viewData['background'] = ModelHelper::load('background', ['type' => 'news_list']);
        return $this->_view('news', $viewData);
    }

    public function view($newsId)
    {
        $newsId = intval($newsId);
        $news = ModelHelper::load('news', ['id' => $newsId]);
        if (empty($news)) {
            return Response::send(-1, '新闻未找到');
        }

        $news['click'] = intval($news['click']) + 1;
        ModelHelper::update('news', ['id' => $news['id']], ['click' => $news['click']]);

        $viewData = [];
        $viewData['news'] = $news;
        $viewData['background'] = ModelHelper::load('background', ['type' => 'news_view']);
        return $this->_view('newsView', $viewData);
    }

}
