<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\ModelHelper;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Forum\Services\ForumService;

class PageController extends BaseController
{
    public function about()
    {
        $viewData = [];
        $viewData['pageTitle'] = '关于我们';
        $viewData['pageContent'] = ConfigFacade::get('siteAbout');
        $viewData['background'] = ModelHelper::load('background', ['type' => 'about']);
        return $this->_view('page', $viewData);
    }

    public function contact()
    {
        $viewData = [];
        $viewData['pageTitle'] = '联系我们';
        $viewData['pageContent'] = ConfigFacade::get('siteContact');
        $viewData['background'] = ModelHelper::load('background', ['type' => 'contact']);
        return $this->_view('page', $viewData);
    }
}
