<?php

namespace App\Http\Controllers;


use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;

class SuperPageController extends BaseController
{
    public function index($url)
    {
        $url = '/' . $url;
        $superPage = ModelHelper::load('super_page', ['url' => $url]);
        if (empty($superPage)) {
            return Response::send(-1, '页面不存在');
        }
        $superPageItems = ModelHelper::find('super_page_item', ['pageId' => $superPage['id']], ['sort', 'asc']);
        ModelHelper::decodeRecordsJson($superPageItems, 'content');

        $viewData = [];
        $viewData['superPage'] = $superPage;
        $viewData['superPageItems'] = $superPageItems;
        return $this->_view('superPage', $viewData);
    }
}
